<?php
function terbilang($n)
{
    if ($n < 0)
    {
        return 'minus ' . terbilang(-$n);
    }
    else if ($n < 10)
    {
        switch ($n)
        {
            case 0:return 'zero';
            case 1:return 'one';
            case 2:return 'two';
            case 3:return 'three';
            case 4:return 'four';
            case 5:return 'five';
            case 6:return 'six';
            case 7:return 'seven';
            case 8:return 'eight';
            case 9:return 'nine';
        }
    }
    else if ($n < 100)
    {
        $kepala = floor($n / 10);
        $sisa   = $n % 10;
        if ($kepala == 1)
        {
            if ($sisa == 0)
            {
                return 'ten';
            }
            else if ($sisa == 1)
            {
                return 'eleven';
            }
            else if ($sisa == 2)
            {
                return 'twelve';
            }
            else if ($sisa == 3)
            {
                return 'thirteen';
            }
            else if ($sisa == 5)
            {
                return 'fifteen';
            }
            else if ($sisa == 8)
            {
                return 'eighteen';
            }
            else
            {
                return terbilang($sisa) . 'teen';
            }

        }
        else if ($kepala == 2)
        {
            $hasil = 'twenty';
        }
        else if ($kepala == 3)
        {
            $hasil = 'thirty';
        }
        else if ($kepala == 5)
        {
            $hasil = 'fifty';
        }
        else if ($kepala == 8)
        {
            $hasil = 'eighty';
        }
        else
        {
            $hasil = terbilang($kepala) . 'ty';
        }

    }
    else if ($n < 1000)
    {
        $kepala = floor($n / 100);
        $sisa   = $n % 100;
        $hasil  = terbilang($kepala) . ' hundred';
    }
    else if ($n < 1000000)
    {
        $kepala = floor($n / 1000);
        $sisa   = $n % 1000;
        $hasil  = terbilang($kepala) . ' thousand';
    }
    else if ($n < 1000000000)
    {
        $kepala = floor($n / 1000000);
        $sisa   = $n % 1000000;
        $hasil  = terbilang($kepala) . ' million';
    }
    else
    {
        return false;
    }

    if ($sisa > 0)
    {
        $hasil .= ' ' . terbilang($sisa);
    }

    return $hasil;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <title>Print SALES INQUERY</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- Bootstrap Core Css -->
	<link href="<?php echo base_url('asset/plugins/bootstrap/css/bootstrap.css'); ?>" rel="stylesheet">
	<!-- jquery UI JS -->
	<script type="text/javascript" src="<?php echo base_url('asset/plugins/jquery-ui-1.12.1.custom/jquery-ui.min.js'); ?>"></script>
	<!-- Bootstrap Core Js -->
	<script src="<?php echo base_url('asset/plugins/bootstrap/js/bootstrap.js'); ?>"></script>
	<style type="text/css">
		body {
		  background: rgb(204,204,204); 
		    font-size: 10px;
		}
/* 
		@page{ 
		    size: 21cm 16cm;
		    display: block; 
		    margin-bottom: 0.5cm;
		} */
		@media print {
		  body, page {
		    /* margin: 0 auto; */
		    box-shadow: 0;
		    font-size: 10px;
		  }
		}
	    .headerdocnames{
	    	text-align: center;
	    	width : 10cm;
	    }
		.srstyle-pjstitle{
            margin-top: -4.9px;
            text-align: right;
            margin-right: 11px;
        }
		.srstyle-pjstitles{
			margin-left: 115px;
			margin-top: 1cm;
			font-size: 10px;

		}
		.srstyle-id{
			font-size: 10px;
		}
		p{
			margin: 0px;
			font-size: 10px;
		}
		.srtyle-tbdetailprint tr th{
			text-align: center;
			white-space: nowrap;
		}

		.srstyle-tacenter{
			text-align: center;
			margin-bottom: -0.2cm;
		}

		.srstyle-taright{
			text-align: right;
			margin-bottom: -0.2cm;
		}

		.srstyle-signature div{
		    text-align: center;
		    min-height: 50px;
		    border: 0.1px solid gray;
		    /* margin: 0.5cm !important; */
		    margin-top: 16px;
		    margin-left: 3.5cm;
		}
		.srstyle-notes div{
		    text-align: center;
		    min-height: 50px;
		    border: 0.1px solid #050000;
		    /* margin: 0.5cm !important; */
		    margin-left: 1.3cm;

		}
		.srstyle-signature,
		.srstyle-ketbayar,
		.srstyle-ketkirim,
		.srstyle-transwarning,
		.srstyle-terbilang
		{
			padding: 0px !important;
			margin-bottom: -0.2cm;
		}

		.srstyle-ketbayar div{
			min-height:100px;
			border: 0.1px solid gray;
			font-size: 10px;
		}

		.srstyle-ketkirim div{
			min-height:50px;
			border: 0.1px solid gray;
			font-size: 10px;
			margin-bottom: -0.2cm;
		}

		.srstyle-terbilang div{
			min-height:35px;
			border: 0.1px solid gray;
		}

		.srstyle-transwarning div{
			min-height:35px;
			border: 0.1px solid gray;
			margin-bottom: -0.2cm;
		}

		.srstyle-sotitle{
			font-size: 10px;
			background-color: gray;
			text-align: center;
			color: white;
			margin-bottom: -0.2cm;
		}

		.srstyle-headerleft,
		.srstyle-headerright{
			font-size: 10px;
			margin-bottom: -0.2cm;
		}
		.addrespjs{
			margin-top: -47px;
            margin-bottom: -1px;

		}
		.marginheader{
			margin-bottom: -0.2cm;
			margin-top: -0.1cm;
			padding :  6px;
		}
		.borderreason{
			border: 0.1px solid rgb(221, 221, 221);
            text-align: center;
            margin-top: -14px;
            margin-bottom: 7px;
		}
		td{
			margin-bottom: -0.2cm;
		}
		table{
			margin-bottom: -22px;
		}
		tbody td {
		  padding: 1px !important;
		  height: 20px;
		  margin-bottom: -0.2cm;
		}

        .boorderbold{
            border: 0.1px solid rgb(3, 3, 3);
            text-align: center;
            margin-top: -14px;
            margin-bottom: 7px;
            min-height: 70px;
        }

		<?php
			if($paper_size == 'a5'){
				$ps = '@page{' 
					    .'size: 21cm 14.8cm;'
					    .'display: block;' 
					    .'margin-bottom: 0.5cm;'
						.'}';
				echo $ps;
			} 

			if($paper_size == 'a4'){
				$ps = '@page{' 
					    .'size: 21cm 29.7cm;'
					    .'display: block;' 
					    .'margin-bottom: 0.5cm;'
						.'}';
				echo $ps;
			} 
		?>
	</style>
</head>
<body>

	<table class="table table-bordered" >
		<thead>

		</thead>
		<tbody>
				<p class="srstyle-pjstitle"><span><img class="logo-pjs" src="<?php echo base_url('asset/images/logo-pjs.png'); ?>" width="110px;" height="50px;" style="    margin-top: 0.2cm; text-align: right; margin-right: -2px;">
                        <div class="addrespjs">
                        <p><strong>PT. PANCA JAYA SETIA</strong></p>
                        <p>Jl. Jelambar Barat III No. 12 Jakarta Barat 11460</p>
                        <p>Telp : (021) 5677081 (Hunting) Fax : (021) 5649089, 5696250</p>
                        </div>

                        <h5 style="text-align: center;"><b>Sales Inquery</b></h5>

				</div>
				<div class="col-md-12">
					<tr>
					<td colspan="4" style="text-align:left;">
						<p class="srstyle-id">Date: <?php echo date('d-m-Y'); ?></p>
						<p class="srstyle-id">No: <?php echo $header['trsi_no']; ?></p>
					</td>
					<td colspan="4" style="text-align:left;">
						<p>Name : <?php echo $header['mscs_nm']; ?></p>
						<p>CP : <?php echo $header['mscs_cp']; ?></p>
						<p>Address : <?php echo $header['mscs_almt_jln']; ?></p>
					</td>
                     <td colspan="4" style="text-align:left;">
                     	<div class="marginheader">
						<p>Sales: <?php echo $header['msus_nm']; ?></p>
						<p>Cabang: <?php echo $header['mscb_nm']; ?></p>
						</div>
					</td>
					</tr>
				</div>

		</tbody>
	</table>

</body>

		<div class="borderreason"><p style="margin-top: 3px; margin-left: 3px;">Opening Steatment </br></br></p></div>

	<table class="table table-bordered srtyle-tbdetailprint margindetail">
    <thead>
      <tr>
        <th style="width:400px;">Product Name</th>
        <th>Price</th>
        <th>Qty</th>
        <th>Disc 1</th>
        <th>Disc 2</th>
        <th>Disc 3</th>
        <th>Nett</th>
      </tr>
    </thead>
    <tbody>

	    <?php
$subtotal = 0;
foreach ($detail as $key => $value)
{
    $total = $value['dtsi_nett'] * $value['dtsi_qty'];
    $subtotal += $total;?>
		    <tr>
		        <td><?php echo $value['mspd_nm']; ?></td>
		        <td class="srstyle-taright"><?php echo number_format($value['dtsi_pricelist']); ?></td>
		        <td class="srstyle-taright"><?php echo number_format($value['dtsi_qty']); ?></td>
		        <td class="srstyle-taright"><?php echo number_format($value['dtsi_discpersen1']); ?></td>
		        <td class="srstyle-taright"><?php echo number_format($value['dtsi_discpersen2']); ?></td>
		        <td class="srstyle-taright"><?php echo number_format($value['dtsi_discpersen3']); ?></td>
		        <td class="srstyle-taright"><?php echo number_format($value['dtsi_nett']); ?></td>
		    </tr><?php
}?>

		<tr>
			<div class="col-md-12">
			<td colspan="6" style="text-align:right;"><b>Grand Total: </b></td>
			<td class="srstyle-taright"><b><?php echo number_format($subtotal,2); ?></b></td>
			</div>
		</tr>
	</tbody>
	</table>
		<div class="borderreason"><p style="margin-top: 3px; margin-left: 3px;">Closing Steatment </p></br></div>

	 <div class="boorderbold" style="max-width: 440px; margin-top: 20px; margin-bottom: 7px;"><p style="margin-top: 3px; margin-left: 3px;">Terms And Condition</p></div>

	 <div class="boorderbold" style="margin-left: 439px; margin-top: -77px; margin-bottom: 24px;"><p style="margin-top: 3px; margin-left: 3px;">T.O.P Notes : </br> <?php echo $header['trsi_catatan']; ?></p></div>

		<table class="table table-bordered" >
		        <thead>

		        </thead>
		        <tbody>

		            <div class="col-md-12">
		                <tr>
		                    <td colspan="6" style="text-align:center; height: 50px; margin-top: 2px;" class="srstyle-headerleft">
		                        <p class="srstyle-id">Head Sales Sign</p>
		                    </td>
		                    <td colspan="6" style="text-align:center; height: 50px; margin-top: 2px;" class="srstyle-headerleft">
		                        <p class="srstyle-id">Sales Sign</p>
		                    </td>
		                </tr>
		            </div>
		        </tbody>
		    </table>

    <script type="text/javascript">
    	window.print();
    </script>

</body>

</html>