<?php   
  function fset_input_supplier($action, $header, $default){
      if($action == 'new'){
        return $default;
      }else if($action == 'new_import'){
        return $header['trpo_mssp_no']. ' - '. $header['mssp_nm'];
      }else{
        return $header['trpt_mssp_no']. ' - '. $header['mssp_nm'];
      }
  }  

  function fset_kurs($header, $kurs){
        if($header['trpo_curr'] == 'USD'){
          return $kurs;
        }else{
          return 1;
        }
  }

  function fset_title_nettpo($header, $action){
        if($action == 'new'){
            return 'Nett PO RP/USD (per Unit)';
        }elseif ($action == 'new_import') {
            if($header['trpo_curr'] == 'RP'){
              return 'Nett PO RP (per Unit)';
            }else{
              return 'Nett PO USD (per Unit)';
            }
        }else{
            if($header['trpt_curr'] == 'RP'){
              return 'Nett PO RP (per Unit)';
            }else{
              return 'Nett PO USD (per Unit)';
            }
        }
  }

?>

<nav class="navbar">
    <div class="container-fluid">
        <div class="pull-right navbar-right">

            <?php 
            if(fcek_hak_akses('.BE0.')) { ?>
                <a class="btn-view-list" id="btn-view-list" href="<?php echo base_url('purchase_return'); ?>">
                    <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="View List">view_list</i>
                </a><?php
            } ?>

            <?php 
            if(fcek_hak_akses('.BE1.')) { ?>
                <a class="btn-new" id="btn-new" href="<?php echo base_url('purchase_return/purchase_return_new'); ?>">
                    <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="New">insert_drive_file</i>
                </a><?php
            } ?>

            <?php
            if(fcek_hak_akses('.BE2.')) {
                if($header['trpt_tglkeluar'] == '0000-00-00'){ ?>
                    <a class="btn-edit" id="btn-edit" href="javascript:void(0);">
                        <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="Edit">create</i>
                    </a><?php
                } 
            } ?>    

            <?php
            if(fcek_hak_akses('.BE6.')) { ?>
                 <a class="btn-print" id="btn-print" href="javascript:void(0);" title="WARNING!" data-toggle="popover"  data-trigger="focus" data-placement="left" data-content="For authorized users only">
                    <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="Print">print</i>
                </a><?php
            } ?>

            <?php
            if(fcek_hak_akses('.BE5.')) {
                if($header['trpt_tglkeluar'] == '0000-00-00'){ ?>
                      <a class="btn-void" id="btn-void" href="javascript:void(0);">
                          <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="Void">delete_forever</i>                    
                      </a><?php
                } 
            } ?>          

            <?php
            if(fcek_hak_akses('.BE1.')) { ?>
                <a class="btn-import-po srstyle-btnnavbar" id="btn-import-po"  href="javascript:void(0);">
                    <button type="button" class="btn">Import PO</button>
                </a><?php
            } ?>

            <?php
            if(fcek_hak_akses('.BE7.')) {
                if($header['trpt_tglkeluar'] == '0000-00-00' && $header['trpt_void'] == 0){ ?>
                    <a class="btn-conf-exit-goods srstyle-btnnavbar" id="btn-conf-exit-goods"  href="javascript:void(0);">
                        <button type="button" class="btn">Confirm Exit of Goods</button>
                    </a><?php
                } 
            } ?>    

            <?php
            if(fcek_hak_akses('.BE8.')) {
                if($header['trpt_tglkeluar'] != '0000-00-00' && $header['is_pthaspaid'] == 0){ ?>
                    <a class="btn-cancel-exits-goods srstyle-btnnavbar" id="btn-cancel-exit-goods" href="javascript:void(0);">
                        <button type="button" class="btn">Cancel Exit of Goods</button>
                    </a><?php                
                } 
            } ?>

        </div>
        <?php $this->load->view('v_navbar_topleft') ?>
    </div>
</nav>

<style type="text/css">
.produknamecol {
  min-width: 400px;
  padding-top: 0;
}
.fixedname {
     position:absolute;
     margin :  0px;
     left: 0%;
     padding-top: 0;
}
.fixed_table {
  min-width: 150px;
  
}
.display_id{
  display: none;
}
</style>


<div class="row clearfix">
  <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">                      
        <div class="card srstyle-card">
            <div id="data-form-container">                

                <!-- ============================================ Purchase Return Form ====================================== -->
                <div class="srstyle-title">Purchase Return</div>
                        
                <form id="purchase_return-form" autocomplete="off" method="POST" action="<?php echo base_url('purchase_return/purchase_return_edit_simpan'); ?>">
                    <input type="hidden" name="key" id="key" value="<?php echo $key ?>" >
                    <input type="hidden" name="hash_key" id="hash_key" value="<?php echo $hash_key ?>" >
                    <input type="hidden" name="trpo_no" id="trpo_no" value="<?php echo ($action == 'new') ? '' : $header['trpo_no']; ?>" >
                    <input type="hidden" name="trpt_cekint" id="trpt_cekint" value="<?php echo ($action == 'view') ? $header['trpt_cekint'] : ''; ?>" >
                    <input type="hidden" name="trpo_cekint" id="trpo_cekint" value="<?php echo ($action == 'new') ? '' : $header['trpo_cekint']; ?>" >
                    <input type="hidden" name="trju_no" class="form-control auto-numeric" id="trju_no" value="<?php echo ($action == 'view') ? $jurnal_h['trju_no'] : ''; ?>">
                    <input type="hidden" name="trpo_fin" id="trpo_fin" value="<?php echo ($action == 'view') ? $header['trpo_fin'] : ''; ?>" >
                    
                    <?php 
                    if($action == 'view'){                     
                            if($header['trpt_void'] == 1) {?>
                                <div class="alert-danger srstyle-boxvoid">
                                    <h2>VOID</h2>
                                </div>
                  <?php     }                         
                    } ?>                          

                    <?php $trpt_mscb_no = ($action == 'view') ? $header['trpt_mscb_no'] : $this->session->userdata('user_aktif')['msus_mscb_no']; ?>      

                    <!-- SRS Toogle -->
                    <div class="col-ms-12 col-md-12 col-xs-12 SRSHeaderFormTop"> 

                        <!-- SRS Toogle -->
                        <div class="lokasi_cb_area SRSLokasiCbArea">
                              <label class="SRSToogleContainer">
                                  <input type="radio" name="trpt_mscb_no" id="trpt_mscb_no" value="<?php echo $trpt_mscb_no; ?>" checked disabled>
                                  <div class="SRSToogleArea"> <?php echo $trpt_mscb_no; ?> </div>
                              </label>
                        </div>

                        <div class="SRSBox">                            
                             <?php echo (($action == 'view') ? $header['trpt_msus_no']. ' - '. $header['msus_nm'] : $this->session->userdata('user_aktif')['msus_no']. ' - ' . $this->session->userdata('user_aktif')['msus_nm']); ?>
                        </div> 

                        <div class="SRSBox">
                          <input type="text" class="srstyle-date-trans" name="trpt_tgl" id="trpt_tgl" value="<?php echo ($action == 'view') ? $header['trpt_tgl'] : date('Y-m-d H:i:s'); ?>" readonly>
                        </div>

                        <?php
                        if($action == 'view'){ 
                            if($header['trpt_tglkeluar'] != '0000-00-00'){
                              $conf_status = 'EoG-CONFIRMED';
                              $conf_status_bg = '#20ff80';
                            }else{
                              $conf_status = 'EoG-NOT YET CONFIRMED';
                              $conf_status_bg = '#FF6347';
                            } ?>

                            <div class="SRSBox" style="background-color:<?php echo $conf_status_bg; ?>">                            
                                 <?php echo $conf_status; ?>
                            </div><?php

                            if($header['trpt_jenis'] == 'V'){
                                if($header['trpt_pbpo_no'] != ''){
                                  $voucher_status = 'VOUCHER-SETTLED';
                                  $voucher_status_bg = '#20ff80';
                                }else{
                                  $voucher_status = 'VOUCHER-UNSETTLED';
                                  $voucher_status_bg = '#FF6347';
                                } ?>

                                <div class="SRSBox" style="background-color:<?php echo $voucher_status_bg; ?>"> 
                                 <?php echo $voucher_status; ?>
                                </div><?php 
                            }
                        } ?>

                        <div class="SRSBox pull-right">
                             <span>Kurs: </span><span class="auto-numeric"><?php echo $kurs; ?></span>
                        </div>       

                    </div>

                    <div class="clearfix"></div>
                            
                    <!-- container kolom -->
                    <div class="col-md-6 col-xs-12">      
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">  
                            <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trpt_no">PR #</label>
                            <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                <input type="text" name="trpt_no" class="form-control" readonly id="trpt_no" placeholder="Auto" value="<?php echo (($action == 'view') ? $header['trpt_no'] : '' ); ?>">
                            </div>
                          </div>                          
                          <!-- <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trpt_msus_no">User:</label>
                              <div class="col-md-9 col-sm-9 col-xs-9 srstyle-nopadding">
                                <input type="text" name="trpt_msus_no" id="trpt_msus_no" class="form-control" readonly disabled value="<?php //echo (($action == 'view') ? $header['trpt_msus_no']. ' - '. $header['msus_nm'] : $this->session->userdata('user_aktif')['msus_no']. ' - ' . $this->session->userdata('user_aktif')['msus_nm']); ?>">
                              </div>                                                        
                          </div> -->
                          <!-- <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trpt_tgl">Date:</label>
                              <div class="col-md-9 col-sm-9 col-xs-9 srstyle-nopadding">
                                <input type="text" name="trpt_tgl" id="trpt_tgl" class="form-control" readonly disabled value="<?php //echo (($action == 'view') ? $header['trpt_tgl'] : date('Y-m-d') ); ?>">
                              </div>                                                        
                          </div> -->
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trpt_tglkeluar">Date Return:</label>
                              <div class="col-md-9 col-sm-9 col-xs-9 srstyle-nopadding">
                                <input type="text" name="trpt_tglkeluar" id="trpt_tglkeluar" readonly disabled placeholder="Date Return" class="form-control" value="<?php echo (($action == 'view') ? $header['trpt_tglkeluar'] : ''); ?>">
                              </div>                                                        
                          </div>

                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trpt_mssp_no">Supplier:</label>
                              <div class="col-md-9 col-sm-9 col-xs-9 srstyle-nopadding">
                                 <input type="text" name="trpt_mssp_no" class="form-control" id="trpt_mssp_no" readonly placeholder="Supplier" value="<?php echo fset_input_supplier($action, $header,''); ?>">
                              </div>
                          </div>
                          
                          <div style="<?php if(!fcek_hak_akses('.BE9.')){echo 'display:none;'; } ?>" class="form-group form-group-sm col-md-12 srstyle-nopadding">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trpt_curr">Currency:</label>
                            <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding srstyle-input-area-radio">
                              <input name="trpt_curr" type="radio" id="rupiah" value="RP" class="radio-col-green" <?php if($action == 'new_import'){if($header['trpo_curr'] == 'RP'){echo 'checked';}}elseif($action == 'view'){if($header['trpt_curr'] == 'RP'){echo 'checked'; }} ?> disabled/>
                              <label for="rupiah">Rupiah</label>
                              <input name="trpt_curr" type="radio" id="usd" value="USD" class="radio-col-green" <?php if($action == 'new_import'){if($header['trpo_curr'] == 'USD'){echo 'checked';}}elseif($action == 'view'){if($header['trpt_curr'] == 'USD'){echo 'checked'; }} ?> disabled/>
                              <label for="usd">USD</label>                              
                            </div>
                          </div>                                                                        
                                                    
                          <div style="<?php if(!fcek_hak_akses('.BE9.')){echo 'display:none;'; } ?>" class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trpt_kurs">Kurs:</label>
                              <div class="col-md-9 col-sm-9 col-xs-9 srstyle-nopadding">
                                <input type="text" name="trpt_kurs" id="trpt_kurs" class="form-control auto-numeric" <?php if($header['trpo_curr'] == 'RP'){echo 'readonly';} ?> value="<?php echo (($action == 'view') ? $header['trpt_kurs'] : fset_kurs($header, $kurs)); ?>">
                              </div>                                                        
                          </div>                          
                                                   
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trpt_msgd_no">Warehouse:<b class="srstyle-Tanda-Harus-Diisi">*</b></label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding srstyle-boxinputicon">            
                                <div class="srstyle-combobox">
                                  <div id="trpt_msgd_no" name="trpt_msgd_no"></div> 
                                </div>            
                                <i class="material-icons srstyle-cursor srstyle-inputicon btn-view-gudang">link</i>
                              </div>                              
                          </div>
                          
                          <div style="<?php if(!fcek_hak_akses('.BE9.')){echo 'display:none;'; } ?>" class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trpt_jenis">Type:</label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding srstyle-input-area-radio">
                                <input name="trpt_jenis" type="radio" id="trpt_jenisc" value="C" class="radio-col-green" checked/>
                                <label for="trpt_jenisc">Cashback</label>
                                <input name="trpt_jenis" type="radio" id="trpt_jenisv" value="V" class="radio-col-green"/>
                                <label for="trpt_jenisv">Purchase Return Voucher</label>            
                              </div>
                          </div>                          

                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trpt_tag">Tag:</label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                 <input type="text" name="trpt_tag" class="form-control" placeholder="Input Tag" id="trpt_tag" maxlength="100" value="<?php echo (($action == 'view') ? $header['trpt_tag'] : ''); ?>">
                              </div>                            
                          </div>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trpt_catatan">Notes:</label>
                            <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">                            
                              <textarea name="trpt_catatan" class="form-control srstyle-textarea" rows="3" id="trpt_catatan" placeholder="Input Notes" maxlength="250"><?php echo (($action == 'view') ? $header['trpt_catatan'] : ''); ?></textarea>
                            </div>
                          </div>      
                     </div>     
                    <!-- End container kolom -->            
                    
                    <div class="clearfix"></div>      

                    <!-- ========================================== Purchase Return Detail ==================================== -->        
                    <div class="tabledetail-container col-md-12 col-sm-12 col-xs-12">
                        <div class="srstyle-list-title list-title">
                          <span>Detail Purchase Return<span>
                          <?php
                          if($action == 'view' && $header['trpt_tglkeluar'] != '0000-00-00' && $header['trpt_void'] == 0 && fcek_hak_akses('.BEA.')){ ?>
                              <i id="btn-view-jurnal" class="material-icons srstyle-cursor pull-right srstyle-btntoprightdetail">chrome_reader_mode</i><?php
                          } ?>
                        </div>
                        
                        <div class="srstyle-col-view" style="<?php if(!fcek_hak_akses('.BE9.')){echo 'display:none;'; } ?>">
                            <table>
                                <thead>                                         
                                    <tr class="filters">                                                          
                                        <th>Total (Rp)</th>                                          
                                    </tr>  
                                </thead>                                
                                <tbody id="purchasereturn-action-tbody">
                                    <?php
                                    if($action == 'view' || $action == 'new_import'){
                                        if(isset($detail)){ 
                                          foreach ($detail as $key => $value) { ?>
                                              <tr>                                                
                                                  <td><input type="text" class="form-control dtpt_total srstyle-ta-right auto-numeric" readonly value="<?php echo ($action == 'view') ? $value['dtpt_nett'] * $value['dtpt_qtyretur'] : ''; ?>"/></td>
                                              </tr><?php
                                          } ?>

                                          <tr>                                                
                                              <td><input type="text" class="form-control srstyle-ta-right auto-numeric" name="trpt_total" id="dtpt_total" readonly value=""/></td>
                                          </tr><?php
                                        }                                                                                     
                                    } ?>                              
                                </tbody>
                            </table>
                          </div>                        

                          <div id="wrap" class="srstyle-col-content">
                              <table id=fixTable class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                  <thead>                                    
                                      <tr class="filters">                
                                          <th style="display:none;">Seq</th>
                                          <th style="min-width:100px;" class="produk_id">Product ID</th>                                                       
                                          <td class="produknamecol" style="background-color: white; text-align: center;"><b>&nbsp; &nbsp;  &nbsp;  &nbsp;  Product Name &nbsp; &nbsp; &nbsp; &nbsp;  &nbsp;  </b></td>
                                          <th style="min-width:100px;">Avaliable</th>
                                          <th style="min-width:100px;">Stock</th>
                                          <th style="min-width:100px;">Qty PO</th>
                                          <th>Qty Sudah Terima</th>
                                          <th>Qty Sudah Retur</th>
                                          <th>Qty Retur</th>                                                                                               

                                          <?php                        
                                          if(fcek_hak_akses('.BE9.')){ ?>                               
                                              <th style="min-width:160px;"><?php echo fset_title_nettpo($header, $action); ?></th>
                                              <th style="min-width:160px;">Before Tax (Rp)</th>
                                              <th style="min-width:160px;">Tax (Rp)</th>
                                              <th style="min-width:160px;">Nett (Rp)</th><?php
                                          } ?>

                                      </tr>
                                  </thead>
                                  <tbody id="purchasereturn-datadetail-tbody">
                                    <!-- >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> if view and new import  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< -->
                                    <?php if($action == 'view' || $action == 'new_import'){                                                                                 
                                                foreach ($detail as $value) { ?>
                                                    <tr>
                                                      <td style="display:none;"><input type="text" name="dtpt[dtpt_seq][]" class="form-control" readonly value="<?php echo $value['dtpo_seq']; ?>"/></td>
                                                      <td class="produk_id"><input type="text" name="dtpt[dtpt_mspd_no][]" class="form-control srstyle-ta-center dtpt_mspd_no dtpt_mspd_no_avl" readonly value="<?php echo $value['dtpo_mspd_no']; ?>"/></td>
                                                      <td class="produknamecol"><input type="text" class="form-control srstyle-col-produkname" readonly value="<?php echo $value['mspd_nm']; ?>"/></td>
                                                      <td><input type="text" class="form-control srstyle-ta-right auto-numeric <?php echo $value['dtpo_mspd_no'].'avl'; ?>" readonly value="0"/></td>
                                                      <td><input type="text" class="form-control srstyle-ta-right auto-numeric <?php echo $value['dtpo_mspd_no']; ?>" readonly value="0"/></td>
                                                      <td><input type="text" class="form-control srstyle-ta-right auto-numeric" readonly value="<?php echo $value['dtpo_qty']; ?>"/></td>
                                                      <td><input type="text" class="form-control srstyle-ta-right auto-numeric" readonly value="<?php echo $value['dtpo_qtyterima']; ?>"/></td>
                                                      <td><input type="text" class="form-control srstyle-ta-right auto-numeric" readonly value="<?php echo $value['calc_qty_retur']; ?>"/></td>
                                                      <td><input type="text" name="dtpt[dtpt_qtyretur][]" class="form-control dtpt_qtyretur srstyle-ta-right auto-numeric" data-trigger="focus" value="<?php echo ($action == 'view') ? $value['dtpt_qtyretur'] : 0; ?>"/></td>                                                                                                            
                                                                                                                                                                
                                                      <td style="<?php if(!fcek_hak_akses('.BE9.')){echo 'display:none;'; } ?>"><input type="text" name="dtpt[dtpt_nettpo][]" class="form-control dtpt_nettpo srstyle-ta-right auto-numeric" readonly value="<?php echo ($action == 'view') ? (($value['dtpt_qtyretur'] > 0)? $value['dtpt_nettpo'] : $value['dtpo_nett']) : $value['dtpo_nett']; ?>"/></td>
                                                      <td style="<?php if(!fcek_hak_akses('.BE9.')){echo 'display:none;'; } ?>"><input type="text" name="dtpt[dtpt_bftaxrp][]" class="form-control dtpt_bftaxrp srstyle-ta-right auto-numeric" readonly value="<?php echo ($action == 'view') ? (($value['dtpt_qtyretur'] > 0)? $value['dtpt_bftaxrp'] : $value['dtpo_bftax']) : $value['dtpo_bftax']; ?>"/></td>
                                                      <td style="<?php if(!fcek_hak_akses('.BE9.')){echo 'display:none;'; } ?>"><input type="text" name="dtpt[dtpt_taxrp][]" class="form-control dtpt_taxrp srstyle-ta-right auto-numeric" readonly value="<?php echo ($action == 'view') ? (($value['dtpt_qtyretur'] > 0)? $value['dtpt_taxrp'] : $value['dtpo_tax']) : $value['dtpo_tax']; ?>"/></td>
                                                      <td style="<?php if(!fcek_hak_akses('.BE9.')){echo 'display:none;'; } ?>"><input type="text" name="dtpt[dtpt_nett][]" class="form-control dtpt_nett srstyle-ta-right auto-numeric" readonly value="<?php echo ($action == 'view') ? (($value['dtpt_qtyretur'] > 0)? $value['dtpt_nett'] : $value['dtpo_nett']) : $value['dtpo_nett']; ?>"/></td>
                                                    </tr><?php 


                                                    // var_dump($value['dtpo_tax']);
                                                    // die();
                                                  } ?>        


                                                  <tr style="<?php if(!fcek_hak_akses('.BE9.')){echo 'display:none;'; } ?>" class="srstyle-rowcountdetail">
                                                    <td colspan="3" style="display:none;"></td>
                                                    <td colspan="8" class="srstyle-detailcount-label">Total</td>
                                                    <td><input type="text" id="dtpt_totalbftaxrp" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>
                                                    <td><input type="text" id="dtpt_totaltaxrp" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>
                                                    <td><input type="text" id="dtpt_totalnett" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>
                                                  </tr><?php                                                   
                                          } ?>                                          
                                  <!-- >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> End if view and new import  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< -->        
                                  </tbody>
                              </table>
                          </div>
                      </div>                    
                    <!-- ========================================== End Purchase Return Detail ==================================== -->
                      
                   <div class="clearfix"></div>

                  <br/>
                  <div class="col-md-6 col-xs-12 srstyle-Remark-Text">
                      <span>Require Data &nbsp;<b class="srstyle-Tanda-Harus-Diisi">*</b></span>                
                      <br/>
                  </div> 
                     
                  <div class="clearfix"></div> 
                  <!-- <input type="submit" value="submit" id="submit"/> -->
              </form>                
            <!-- ========================================== End Purchase Return Form ==================================== -->               
            
            </div>
            <?php $this->load->view('v_save_bar'); ?>
        </div>                        
    </div>
</div>


<!-- Modal -->
<div class="modal fade" id="popup-cancel-exit-goods" role="dialog">
  <div class="modal-dialog">
  
    <!-- Modal content-->
    <div class="modal-content srstyle-confirm-box">
      <div class="modal-header srstyle-modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Confirmation</h4>
      </div>
      <div class="modal-body srstyle-comfirm-text">
        <h4>Are you sure want to cancel exit of goods?</h4>        
      </div>
      <div class="modal-footer srstyle-modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
        <button type="button" id="btn-cancel-exitgoods-ok" class="btn btn-default">Yes</button>
      </div>
    </div>
    
  </div>
</div>  
<!-- End Modal -->  

<?php $this->load->view('v_popup_confirm_void'); ?>
<?php $this->load->view('v_popup_confirm_cancel'); ?>
<?php $this->load->view('v_popup_confirm_print'); ?>
<?php $this->load->view('v_popup_jurnalotomatis'); ?>
<div id="popup-container"></div>

<!-- =====================================================Inisial=========================================== -->
<script type="text/javascript">

var wrap = $("#wrap");

    wrap.on("scroll", function(e) {
      var scrollx = $("div.srstyle-col-content").scrollLeft();  
      if (scrollx > 132) {
        $(".produknamecol").addClass("fixed_table");
        $(".fixededit").addClass("fixedname").css("padding-left", scrollx + "px"); 
        $(".srstyle-detailcount-label").css("padding-left", scrollx + 10 + "px"); 
        $(".produk_id").addClass("display_id");
      } 
      else {
        $(".produknamecol").removeClass("fixed_table");
        $(".fixededit").removeClass("fixedname").css("padding-left", scrollx + "px"); 
        $(".srstyle-detailcount-label").css("padding-left", scrollx + 10 + "px"); 
        $(".produk_id").removeClass("display_id");
      }
    });

  // $(".auto-numeric").autoNumeric("init");
  $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});
  $(document).ready(function(){
      $('#trpt_tgl').datetimepicker({         
        format:'Y-m-d H:i:s',
        formatTime:'H:i'
      });

      $('#trpt_tglkeluar').datetimepicker({
          format:'Y-m-d',
          timepicker:false
      });   

      $("#fixTable").tableHeadFixer({"head" : false, "left" :   3});

      var trpt_jenis = "<?php echo ($action == 'view') ? $header['trpt_jenis'] : ''; ?>";
    
      //Set menu navigai yang sedang dipilih menjadi aktif
      $("#menu-purchase-return").addClass("active");
      $("#menu-purchase > a, #menu-purchase-return > a").addClass("toggled");       
      $("#ml-menu-purchase").css("display","block");                      

      if(trpt_jenis == "C" || trpt_jenis == ""){
        $("#trpt_jenisc").prop("checked",true);
      }else{
        $("#trpt_jenisv").prop("checked",true);
      }

        //Ajax POST untuk combo box gudang
        $.ajax({
              method:"POST",
              url:"<?php echo base_url('gudang/get_gudang'); ?>",
              data:{key:$("#key").val(), hash_key:$("#hash_key").val()},
              dataType:"json",
              success:function(r){                
                  var arrGudang = [];                  
                  var trpt_msgd_no = "";

                  if("<?php echo $action ?>" == "view"){
                      trpt_msgd_no = "<?php echo $header['trpt_msgd_no']; ?>";
                  }
                  
                  for (var i = 0; i < r.length; i++) {              
                      if(r[i]['msgd_aktif'] == 1){                            
                            arrGudang.push({
                                value: r[i]['msgd_no'],                  
                                text: r[i]['msgd_no'] + " : " + r[i]['msgd_nm'],
                                selected: trpt_msgd_no.includes(r[i]['msgd_no']) 
                            });
                      }else{
                        if(trpt_msgd_no.includes(r[i]['msgd_no'])){
                            arrGudang.push({
                                value: r[i]['msgd_no'],
                                text: r[i]['msgd_no'] + " : " + r[i]['msgd_nm'] + ' [OFF]',
                                selected: true                      
                            });                            
                        }
                      }
                  }                  
                  dhxtrpt_msgd_no = dhtmlXComboFromSelect("trpt_msgd_no"); 
                  dhxtrpt_msgd_no.addOption(arrGudang); 
                  dhxtrpt_msgd_no.enableFilteringMode("between");
                  dhxtrpt_msgd_no.allowFreeText(false);
                  dhxtrpt_msgd_no.setPlaceholder("Select Warehouse");                                    

                  dhxtrpt_msgd_no.attachEvent("onChange", function(){                      
                      fset_infostok();                                                                  
                  });    

                  if("<?php echo $action ?>" == "view"){                    
                      dhxtrpt_msgd_no.disable();
                      fset_infostok();
                  }
              }
        });                
        
        if("<?php echo $action; ?>" == "new_import"){              
              vaction = "NEW";
              $(".save-bar-container").show();
              $(".navbar-right").show().find('a').not("#btn-view-list, #btn-import-po").hide();
              $("#btn-save").attr({"url:id":"<?php echo base_url('purchase_return/purchase_return_new_simpan'); ?>", action:"NEW"});
              fset_info_avaliablestock();
              fcount_nett_rp();
              fcount_total();
        }

        
        if("<?php echo $action; ?>" == "new"){              
            $("#btn-import-po").click();
             $(".navbar-right").show().find('a').not("#btn-view-list, #btn-import-po").hide();
        }

        if("<?php echo $action; ?>" == "view"){          
            if("<?php echo $header['trpt_void']; ?>" == 1){
                $("#btn-void, #btn-edit, #btn-print").hide();                                                   
            }                                        
            
            fset_info_avaliablestock();            
            $("#purchase_return-form :input").prop("disabled", true);              
            $(".navbar-right").show().find("#btn-import-po").hide();
            if("<?php echo $this->session->userdata('alert_sukses'); ?>" === "sukses"){
              falertsuccess();
              <?php unset($_SESSION['alert_sukses']); ?>          
            }              
            fcount_total();
        }
        
    });             
</script>
<!-- =====================================================End Inisial=========================================== -->

<!-- =====================================================Event=========================================== -->
<script type="text/javascript">

    // $( ".dtsd_qtykrm" ).bind({                  
    //       keyup: function() {
    //             var curr_row = $(this).parents("tr");
    //             var dtsd_qtysisa = parseFloat(curr_row.find(".dtsd_qtysisa").val());
    //             var dtsd_qtykrm = parseFloat($(this).val());
                
    //             if(dtsd_qtykrm > dtsd_qtysisa || dtsd_qtykrm < 0){                  
    //               $(this).popover({content: "Delivery quantity should be less than or equal to remaining quantity.", placement: "right"});
    //               $(this).popover('show');
    //               $(this).val(0);
    //             }else{
    //               $(this).popover('destroy');
    //             }                                              
    //       }
    // });


    $(".btn-view-gudang").click(function(){
          var msgd_no = dhxtrpt_msgd_no.getSelectedValue();
          if(msgd_no !== null){
            window.open(
              "<?php echo base_url('gudang/gudang_view') ?>" + "/" + msgd_no,
              "_blank"
            );
          }else{
            window.open(
              "<?php echo base_url('gudang') ?>",
              "_blank"
            );
          }
    });    

    $("#btn-conf-exit-goods").click(function(){ 
          vaction = "CONF_EXIT_GOODS";
          $("#purchase_return-form :input").prop("disabled",true);
          dhxtrpt_msgd_no.disable();
          dhxtrpt_msgd_no.enable();
          $(".dtpt_qtyretur").prop({"disabled":false, "readonly":false});
          $("#trpt_tglkeluar").val("<?php echo date('Y-m-d'); ?>");          
          $("#trpt_tglkeluar").prop({"disabled":false, "readonly":false});
          $(".dtpt_qtyretur_lama").val(0);
          $(".save-bar-container").show();
          $("#btn-save").attr({"url:id":"<?php echo base_url('purchase_return/purchase_return_edit_simpan'); ?>", action:"CONF_EXIT_GOODS"});
          var message = "1. Select warehouse <br />"
                        +"2. Make sure qty return <br />"  
                        +"3. Click save button to save confirm exit goods";                      
          todolist(message);
    }); 

    $("#btn-no").click(function(){        
        $("#popup-confirm-print").modal("hide");
        window.open("<?php echo base_url('purchase_return/purchase_return_print?trpt_no='); ?>" + $("#trpt_no").val() + "&&paper_size=A4","_blank");
    })  

    $("#btn-save-print").click(function(){        
        $("#popup-confirm-print").modal("hide");
        window.open("<?php echo base_url('purchase_return/purchase_return_print?trpt_no='); ?>" + $("#trpt_no").val() + "&&paper_size=A5","_blank");
    })

    $("#btn-print").click(function(){  
        $("#popup-confirm-print").modal();
    });     
                      
    // //Event edit purchase_return
    $(document).on('click','#btn-edit',function(){    
        vaction = "EDIT";                        
        $("#purchase_return-form input").not("input[name='trpt_curr'], #trpt_tgl").prop('disabled',false);
        $("#trpt_catatan, #btn-save").prop('disabled',false);        
        dhxtrpt_msgd_no.enable();
        $("#trpt_tglkeluar").prop("disabled", true);
        $("#trpt_tglkeluar").val("0000-00-00");
        $(".save-bar-container").show();
        $("#btn-save").attr({"url:id":"<?php echo base_url('purchase_return/purchase_return_edit_simpan'); ?>", action:"EDIT"});
        notify.close();
    });

    $("#btn-cancel-exit-goods").click(function(){                            
        $("#popup-cancel-exit-goods").modal();        
    });

    $("#btn-cancel-exitgoods-ok").click(function(){            
        vaction = "CANCEL_EXIT_GOODS";
        save_data();
    });

    $("#btn-save-void").click(function(){                                                            
        vaction = "VOID";
        save_data();  
    });
                                   
    //Save purchase_return ke database
    $("#btn-save").click(function(){        
        save_data();
    });

    function save_data(){
      $("#trpt_catatan").prop("disabled", false)
      $("#purchase_return-form input").prop("disabled",false);
      $("#btn-save").prop('disabled',true);        
      $("#btn-save-void").prop('disabled',true);
        $("#purchase_return-form").ajaxSubmit({
              url: "<?php echo base_url('purchase_return/purchase_return_simpan'); ?>",
              data: {action: vaction},
              type: 'POST',
              dataType:"json",      
              success: function(result){                  
                  if (result.response == "gagal") {
                      var errmsg="";
                      $.each(result.error_message, function (index, value) {
                        errmsg += value;                            
                      });
                      falertwarning(errmsg);                             
                      $("#purchase_return-form input").prop('disabled',true);
                      $("#btn-save, #btn-save-void").prop('disabled',false);        

                      if(vaction != "NEW"){  
                        $("#trpt_tgl").prop('disabled',true);
                      }
                      
                      if(vaction == "NEW" || vaction == "EDIT"){            
                          $("#purchase_return-form input").not("input[name='trpt_curr']").prop('disabled',false);
                          $("#trpt_catatan").prop('disabled',false);
                          dhxtrpt_msgd_no.enable();
                      }                      
                      
                      if(vaction == "CONF_EXIT_GOODS"){            
                          $("#purchase_return-form :input").prop("disabled",true);
                          dhxtrpt_msgd_no.disable();
                          dhxtrpt_msgd_no.enable();
                          $(".dtpt_qtyretur").prop({"disabled":false, "readonly":false});
                      }             

                      if(vaction == "VOID" || vaction == "CANCEL_EXIT_GOODS"){            
                        dhxtrpt_msgd_no.disable();
                        $("#trpt_catatan").prop('disabled',true);
                        $("#popup-cancel-exit-goods").modal("hide");
                        $("#popup-confirm-void").modal('hide');
                      }
                  }else{                                
                      window.location.href = "<?php echo base_url('purchase_return/purchase_return_view'); ?>" + "/" + result.trpt_no;
                  }                       
              },
              error:function(){
                falertwarning('Error query or syntax');
                $("#popup-confirm-void").modal("hide");
              }
        });          
    }    

    $("#btn-void").click(function(){           
        $("#popup-confirm-void").modal();
    });          
    
    //Redirect ke purchase_return list
    $("#btn-cancel-detail").click(function(){
        window.location.href = "<?php echo base_url('purchase_return'); ?>";
    });

    $("#btn-cancel").click(function(){
       $('#popup-confirm-cancel').modal();
    });

    $("#btn-import-po").click(function(){            
        $.ajax({
              method:"POST",        
              url: "<?php echo base_url('purchase_order/purchase_order_popup'); ?>",
              data:{key:$("#key").val(), hash_key:$("#hash_key").val()}, 
              dataType:"json",
              success:function(r){                                                                
                $("#popup-container").html(r.popup);                                                            
                $("#purchase-order-modal").modal();
              } 
          });  
    });

    $(document).on('dblclick','#po-datalist-tbody tr',function(){
          var trpo_no = $(this).attr("data['trpo_no']");
          window.location.href = "<?php echo base_url('purchase_return/purchase_return_new/'); ?>" + "/" + trpo_no;
    });

    $(document).on('blur','.dtpt_qtyretur',function(){
        fcount_nett_rp();
        fcount_total();
    });

    $(document).on('blur','#trpt_kurs',function(){
        fcount_nett_rp();
        fcount_total();
    });

    $("div.srstyle-col-content").scroll(function(){
      var scrollx = $("div.srstyle-col-content").scrollLeft() + 10;  
      $("td.srstyle-detailcount-label").css("padding-left", scrollx +"px");  
    });

    $("#btn-view-jurnal").click(function(){                    
        $("#jurnal-modal").modal();                    
    });
                            
</script>
<!-- =====================================================End Event=========================================== -->


<!-- =====================================================Function=========================================== -->
<script type="text/javascript">   

      function fcount_nett_rp(){
          $(".dtpt_qtyretur").each(function(){
              var curr_row_left = $(this).parents("tr");
              var curr_row_right = $("#purchasereturn-action-tbody tr").eq(curr_row_left.index());              
              curr_row_left.find(".dtpt_nett").autoNumeric('init', {aPad:false, mDec:4});
              curr_row_left.find(".dtpt_bftaxrp").autoNumeric('init', {aPad:false, mDec:4});
              curr_row_left.find(".dtpt_taxrp").autoNumeric('init', {aPad:false, mDec:4});
              curr_row_right.find(".dtpt_total").autoNumeric('init', {aPad:false, mDec:4});

              var dtpt_nett = parseFloat(ftodouble(curr_row_left.find(".dtpt_nett").val()));
              var dtpt_taxrp = parseFloat(ftodouble(curr_row_left.find(".dtpt_taxrp").val()));
              var dtpt_bftaxrp = parseFloat(ftodouble(curr_row_left.find(".dtpt_bftaxrp").val())); 

              var kurs = parseFloat(ftodouble($("#trpt_kurs").val()));
              
              var dtpt_nettpo = parseFloat(ftodouble(curr_row_left.find(".dtpt_nettpo").val()));

              var tarifPPN = 10;
              if (dtpt_bftaxrp > 0) {
                tarifPPN = ((dtpt_nett / dtpt_bftaxrp) * 100) - 100;
              }
              
              dtpt_nett = dtpt_nettpo * kurs;
              dtpt_bftaxrp = (dtpt_nett * 100) / (100 + tarifPPN);

              dtpt_taxrp = dtpt_nett - dtpt_bftaxrp;

              var dtpt_qtyretur = 0;
              if($(this).val() > 0){                  
                  dtpt_qtyretur = parseFloat(ftodouble(curr_row_left.find(".dtpt_qtyretur").val()));
              }              

              dtpt_total = dtpt_nett * dtpt_qtyretur;   
              curr_row_left.find(".dtpt_nett").autoNumeric("set", dtpt_nett);
              curr_row_left.find(".dtpt_bftaxrp").autoNumeric("set", dtpt_bftaxrp);
              curr_row_left.find(".dtpt_taxrp").autoNumeric("set", dtpt_taxrp);
              curr_row_right.find(".dtpt_total").autoNumeric("set", dtpt_total);

          });
      }

      function fcount_total(){
          var dtpt_totalbftaxrp = 0;
          var dtpt_totaltaxrp = 0;
          var dtpt_totalnett = 0;
          var dtpt_total = 0;
                            
          $(".dtpt_bftaxrp").each(function(){ 
              var curr_row_left = $(this).parents("tr");
              if(curr_row_left.find(".dtpt_qtyretur").val() > 0){
                  dtpt_totalbftaxrp += parseFloat(ftodouble($(this).val()));                  
              }  
          });

          $(".dtpt_taxrp").each(function(){ 
              var curr_row_left = $(this).parents("tr");
              if(curr_row_left.find(".dtpt_qtyretur").val() > 0){
                  dtpt_totaltaxrp += parseFloat(ftodouble($(this).val()));                  
              }  
          });

          $(".dtpt_nett").each(function(){ 
              var curr_row_left = $(this).parents("tr");
              if(curr_row_left.find(".dtpt_qtyretur").val() > 0){
                  dtpt_totalnett += parseFloat(ftodouble($(this).val()));
              }  
          });

          $(".dtpt_total").each(function(){ 
              var curr_row_right = $(this).parents("tr");
              var curr_row_left = $("#purchasereturn-datadetail-tbody tr").eq(curr_row_right.index());
              if(curr_row_left.find(".dtpt_qtyretur").val() > 0){
                  dtpt_total += parseFloat(ftodouble($(this).val()));
              }  
          });
          
          $("#dtpt_totalbftaxrp").autoNumeric('init', {aPad:false, mDec:4});
          $("#dtpt_totaltaxrp").autoNumeric('init', {aPad:false, mDec:4});
          $("#dtpt_totalnett").autoNumeric('init', {aPad:false, mDec:4});
          $("#dtpt_total").autoNumeric('init', {aPad:false, mDec:4});

          $("#dtpt_totalbftaxrp").autoNumeric('set', dtpt_totalbftaxrp);
          $("#dtpt_totaltaxrp").autoNumeric('set', dtpt_totaltaxrp);
          $("#dtpt_totalnett").autoNumeric('set', dtpt_totalnett);          
          $("#dtpt_total").autoNumeric('set', dtpt_total);          
      }                   
                       
     function falertsuccess() {      
          $.notify({
          // options
            message: "Data successfully saved."
          },{
            // settings
            type: 'success',    
            placement: {
                align: 'center'
              },
            animate:{
              enter: 'animated bounceInDown',
              exit: 'animated bounceOutUp'
            }
          });
      }      

      function falertwarning(value) {     
            $.notify({
            // options
              message: value
            },{
              // settings
              type: 'warning',              
              placement: {
                  align: 'center'
                },
              animate:{
                enter: 'animated bounceInDown',
                exit: 'animated bounceOutUp'
              }
            });
      }

      function todolist(message) {      
        notify =  $.notify({
                    // options
                      title: "<strong>To do list</strong><br />",
                      message: message
                    },{
                      // settings
                      type: 'info',    
                      timer: 60000,
                      offset: {
                          x : 0,
                          y : 40
                      },
                      placement: {
                          align: 'right'
                        },
                      animate:{
                        enter: 'animated fadeInRight',
                        exit: 'animated fadeOutRight'
                      }
                  });
      }              

      function fset_infostok(){
          var varr_mspd_no = $('.dtpt_mspd_no').map(function() {
              if($(this).val() != ""){
                return $(this).val();
              }                          
          }).toArray();                  

          if(varr_mspd_no.length > 0){                                                                          
              $.ajax({
                  method:"POST",
                  url:"<?php echo base_url('produk/produkstok'); ?>",
                  data:{key:$("#key").val(), hash_key:$("#hash_key").val(), msgd_no:dhxtrpt_msgd_no.getSelectedValue(), arr_mspd_no:varr_mspd_no},
                  dataType:"json",
                  success:function(r){                                                           
                      for (var i = 0; i < r.length; i++) {                                                
                          if(r[i]['mspd_paket'] == "N"){
                            $("." + r[i]['mspd_no']).autoNumeric('set', (r[i]['msst_qty']));                            
                          }else{
                            $("." + r[i]['mspd_no']).autoNumeric('set', 0);                                                                                                        
                          }
                      }                                               
                  }
              });  
          }                  
      }

      function fset_info_avaliablestock(){
          var varr_mspd_no = $('.dtpt_mspd_no_avl').map(function() {
              if($(this).val() != ""){
                return $(this).val();
              }                          
          }).toArray();                  

          if(varr_mspd_no.length > 0){                                                                          
              $.ajax({
                  method:"POST",
                  url:"<?php echo base_url('produk/produk_avaliablestock'); ?>",
                  data:{key:$("#key").val(), hash_key:$("#hash_key").val(), arr_mspd_no:varr_mspd_no},
                  dataType:"json",
                  success:function(r){                                                           
                      for (var i = 0; i < r.length; i++) {                            
                          if(r[i]['mspd_paket'] == "N"){
                            $("." + r[i]['mspd_no'] + "avl").autoNumeric('set', (r[i]['mspd_qtyavl']));                            
                          }else{
                            $("." + r[i]['mspd_no'] + "avl").autoNumeric('set', 0);                                                        
                          }
                      }                                               
                  }
              });  
          }                  
      }
</script>
<!-- =====================================================End Function=========================================== -->

