<?php
function terbilang($n)
{
    if ($n < 0)
    {
        return 'minus ' . terbilang(-$n);
    }
    else if ($n < 10)
    {
        switch ($n)
        {
            case 0:return 'zero';
            case 1:return 'one';
            case 2:return 'two';
            case 3:return 'three';
            case 4:return 'four';
            case 5:return 'five';
            case 6:return 'six';
            case 7:return 'seven';
            case 8:return 'eight';
            case 9:return 'nine';
        }
    }
    else if ($n < 100)
    {
        $kepala = floor($n / 10);
        $sisa   = $n % 10;
        if ($kepala == 1)
        {
            if ($sisa == 0)
            {
                return 'ten';
            }
            else if ($sisa == 1)
            {
                return 'eleven';
            }
            else if ($sisa == 2)
            {
                return 'twelve';
            }
            else if ($sisa == 3)
            {
                return 'thirteen';
            }
            else if ($sisa == 5)
            {
                return 'fifteen';
            }
            else if ($sisa == 8)
            {
                return 'eighteen';
            }
            else
            {
                return terbilang($sisa) . 'teen';
            }

        }
        else if ($kepala == 2)
        {
            $hasil = 'twenty';
        }
        else if ($kepala == 3)
        {
            $hasil = 'thirty';
        }
        else if ($kepala == 5)
        {
            $hasil = 'fifty';
        }
        else if ($kepala == 8)
        {
            $hasil = 'eighty';
        }
        else
        {
            $hasil = terbilang($kepala) . 'ty';
        }

    }
    else if ($n < 1000)
    {
        $kepala = floor($n / 100);
        $sisa   = $n % 100;
        $hasil  = terbilang($kepala) . ' hundred';
    }
    else if ($n < 1000000)
    {
        $kepala = floor($n / 1000);
        $sisa   = $n % 1000;
        $hasil  = terbilang($kepala) . ' thousand';
    }
    else if ($n < 1000000000)
    {
        $kepala = floor($n / 1000000);
        $sisa   = $n % 1000000;
        $hasil  = terbilang($kepala) . ' million';
    }
    else
    {
        return false;
    }

    if ($sisa > 0)
    {
        $hasil .= ' ' . terbilang($sisa);
    }

    return $hasil;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <title>Print PURCHASE REQUEST</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- Bootstrap Core Css -->
	<link href="<?php echo base_url('asset/plugins/bootstrap/css/bootstrap.css'); ?>" rel="stylesheet">
	<script src="<?php echo base_url('asset/plugins/jquery/jquery.min.js'); ?>"></script>
	<!-- jquery UI JS -->
	<script type="text/javascript" src="<?php echo base_url('asset/plugins/jquery-ui-1.12.1.custom/jquery-ui.min.js'); ?>"></script>
	<!-- Bootstrap Core Js -->
	<script src="<?php echo base_url('asset/plugins/bootstrap/js/bootstrap.js'); ?>"></script>
	<style type="text/css">
		body {
		  background: rgb(204,204,204); 
		    font-size: 10px;
		}
/* 
		@page{ 
		    size: 21cm 16cm;
		    display: block; 
		    margin-bottom: 0.5cm;
		} */
		@media print {
		  body, page {
		    /* margin: 0 auto; */
		    box-shadow: 0;
		    font-size: 10px;
		  }
		}
	    .headerdocnames{
	    	text-align: center;
	    	width : 10cm;
	    }
		.srstyle-pjstitle{
			margin-top: -4.9px;
            text-align: right;
            margin-right: 11px;

		}
		.srstyle-pjstitles{
			margin-left: 115px;
			margin-top: 1cm;
			font-size: 10px;

		}
		.srstyle-id{
			font-size: 10px;
		}
		p{
			margin: 0px;
			font-size: 10px;
		}
		.srtyle-tbdetailprint tr th{
			text-align: center;
			white-space: nowrap;
		}

		.srstyle-tacenter{
			text-align: center;
			margin-bottom: -0.2cm;
		}

		.srstyle-taright{
			text-align: center;
			margin-bottom: -0.2cm;
			color: black;
		}

		.srstyle-signature div{
		    text-align: center;
		    min-height: 70px;
		    border: 0.1px solid gray;
		    /* margin: 0.5cm !important; */
		    margin-left: 5.4cm;
			margin-top: 15px;
		}
		.srstyle-notes div{
		    text-align: center;
		    min-height: 70px;
		    border: 0.1px solid gray;
		    /* margin: 0.5cm !important; */
		    margin-left: 1.3cm;

		}
		.srstyle-signature,
		.srstyle-ketbayar,
		.srstyle-ketkirim,
		.srstyle-transwarning,
		.srstyle-terbilang
		{
			padding: 0px !important;
			margin-bottom: -0.2cm;
		}

		.srstyle-ketbayar div{
			min-height:100px;
			border: 0.1px solid gray;
			font-size: 10px;
		}

		.srstyle-ketkirim div{
			min-height:50px;
			border: 0.1px solid gray;
			font-size: 10px;
			margin-bottom: -0.2cm;
		}

		row{
			border: 0.1px solid gray;
		}

		.srstyle-terbilang div{
			min-height:35px;
			border: 0.1px solid gray;
		}

		.srstyle-transwarning div{
			min-height:35px;
			border: 0.1px solid gray;
			margin-bottom: -0.2cm;
		}

		.srstyle-sotitle{
			font-size: 10px;
			background-color: gray;
			text-align: center;
			color: white;
			margin-bottom: -0.2cm;
		}

		.srstyle-headerleft,
		.srstyle-headerright{
			font-size: 10px;
			margin-bottom: -0.2cm;
		}
		.addrespjs{
				margin-top: -47px;
			   margin-bottom: -1px;
		}
		.marginheader{
			margin-bottom: -0.2cm;
			margin-top: -0.1cm;
		}
		.margindetail{
			margin-top: -0.1cm;
		}
		.boorder{
			border: 0.1px solid rgb(221, 221, 221);
            text-align: center;
            margin-top: -14px;
            margin-bottom: 7px;
		    min-height: 70px;
		}
		.boorderbold{
			border: 0.1px solid rgba(17, 14, 14, 0.81);
            text-align: center;
            margin-top: -14px;
            margin-bottom: 7px;
		    min-height: 70px;
		}
		td{
			margin-bottom: -0.2cm;
		}
		table{
			margin-bottom: -22px;
		}
		tbody td {
		  padding: 1px !important;
		  height: 20px;
		  margin-bottom: -0.2cm;
		}

		<?php
			if($paper_size == 'a5'){
				$ps = '@page{' 
					    .'size: 21cm 14.8cm;'
					    .'display: block;' 
					    .'margin-bottom: 0.5cm;'
						.'}';
				echo $ps;
			} 

			if($paper_size == 'a4'){
				$ps = '@page{' 
					    .'size: 21cm 29.7cm;'
					    .'display: block;' 
					    .'margin-bottom: 0.5cm;'
						.'}';
				echo $ps;
			} 
		?>
	</style>
</head>
<body>

	<table class="table table-bordered" >
		<thead>

		</thead>
		<tbody>
		<form action="" method="" accept-charset="utf-8">
			<input type="hidden" name="key" id="key" value="<?php echo $key ?>" >   
            <input type="hidden" name="hash_key" id="hash_key" value="<?php echo $hash_key ?>" >
		</form>
				<p class="srstyle-pjstitle"><span><img class="logo-pjs" src="<?php echo base_url('asset/images/logo-pjs.png'); ?>" width="110px;" height="50px;" style="    margin-top: 0.2cm; text-align: right; margin-right: -2px;">
                        <div class="addrespjs">
                        <p><strong>PT. PANCA JAYA SETIA</strong></p>
                        <p>Jl. Jelambar Barat III No. 12 Jakarta Barat 11460</p>
                        <p>Telp : (021) 5677081 (Hunting) Fax : (021) 5649089, 5696250</p>
                        </div>

                        <h5 style="text-align: center;"><b>Purchase Request</b></h5>

				</div>
				<div class="col-md-12">
					<tr>
					<td colspan=12" style="text-align:left;" class="srstyle-headerleft">
						<p class="srstyle-id">Date: <?php echo date('d-m-Y'); ?></p>
						<p class="srstyle-id">No: <?php echo $header['trpr_no']; ?></p>
						<p class="srstyle-id">Made By: <?php echo $header['msus_nm'] ?> &nbsp; <?php echo $header['mscb_nm'] ?>
					</td>
				</div>

		</tbody>
	</table>

	<table class="table table-bordered srtyle-tbdetailprint margindetail">
    <thead>
      <tr>
        <th style="width:400px;">Product Name</th>
        <th>Incoming QTY</th>
        <th>Avalaible Stock</th>
        <th>M.A. in a month</th>
        <th>Qty Req</th>
      </tr>
    </thead>
    <tbody>

	    <?php
$subtotal = 0;
foreach ($detail as $key => $value)
{
    $total = $value['dtso_nett'] * $value['dtso_qty'];
    $subtotal += $total;?>
		    <tr>
<!-- 		    <td class="srstyle-tacenter"><?php echo $key + 1; ?></td> -->
		        <td class="srstyle-taright dtpr_mspd_no dtpr_mspd_no_wip_po " style="display: none;"><?php echo $value['dtpr_mspd_no']; ?></td>
		        <td class="mspd_nm"><?php echo $value['mspd_nm']; ?></td>
		         <td class="srstyle-taright mspd_qty_wip_po auto-numeric <?php echo $value['dtpr_mspd_no'].'wip'; ?>"/></td>
		        <td class="srstyle-taright mspd_qtyval auto-numeric <?php echo $value['dtpr_mspd_no'].'avl'; ?>" /></td>

		        <td class="srstyle-taright"></td>
		        <td class="srstyle-taright"><?php echo $value['dtpr_qtyreq']; ?></td>
		    </tr><?php
}?>

    </tbody>
	</table>

	<div class="boorderbold"><p style="margin-top: 3px; margin-left: 3px;">Request Notes : </br></br> <?php echo $header['trpr_catatan'];?></p></div>

	<table class="table table-bordered" >
		        <thead>

		        </thead>
		        <tbody>

		            <div class="col-md-12">
		                <tr>
		                	<td colspan="6" style="text-align:center; height: 50px; margin-top: 2px;" class="srstyle-headerleft">
		                        <p class="srstyle-id">Stock Kontrol Sign</div>
		                    </td>
		                    <td colspan="6" style="text-align:center; height: 50px; margin-top: 2px;" class="srstyle-headerleft">
		                        <p class="srstyle-id">Stock Control Manager Sign</div>
		                </tr>
		            </div>
		        </tbody>
		    </table>

    <script type="text/javascript">

	 fset_info_avaliablestock();
	 fset_info_wip_po();
	 var varr_mspd_no;
	 loadPrint();

      function fset_info_avaliablestock(){

          varr_mspd_no = $('.dtpr_mspd_no').map(function() {
              if($(this).text() != ""){
                return $(this).text();                   
              }                          
          }).toArray();  


          if(varr_mspd_no.length > 0){                                                                          
              $.ajax({
                  method:"POST",
                  url:"<?php echo base_url('produk/produk_avaliablestock'); ?>",
                  data:{key:$("#key").val(), hash_key:$("#hash_key").val(), arr_mspd_no:varr_mspd_no},
                  dataType:"json",
                  success:function(r){                                                           
                      for (var i = 0; i < r.length; i++) {                          
                          $("." + r[i]['mspd_no'] + 'avl').text(r[i]['mspd_qtyavl']);
                      }                                               
                  }
              });  
          }                  
      }

      function fset_info_wip_po(){

         varr_mspd_no = $('.dtpr_mspd_no_wip_po').map(function() {
              if($(this).text() != ""){
                return $(this).text();                        
              }                          
          }).toArray(); 

          if(varr_mspd_no.length > 0){                                                                          
              $.ajax({
                  method:"POST",
                  url:"<?php echo base_url('produk/produk_wip_po'); ?>",
                  data:{key:$("#key").val(), hash_key:$("#hash_key").val(), arr_mspd_no_wip_po:varr_mspd_no},
                  dataType:"json",
                  success:function(a){                                                        
                      for (var j = 0; j < a.length; j++) {                  
                          $("." + a[j]['mspd_no'] + 'wip').text(a[j]['mspd_qty_wip_po']);
                      }                                               
                  }
              });
          }                  
      }

function loadPrint() {
    window.print();
  setTimeout(function(){window.close();}, 400);
}

</script>

</body>

</html>