<div class="container">  
  <!-- Modal -->
  <div class="modal fade" id="pr-detail-modal" role="dialog">
    <div class="modal-dialog srstyle-modal-box">
    
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header srstyle-popuplist">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4>Search Purchase Request</h4>
        </div>
        
        <!-- Modal Body-->
        <div class="modal-body">                      

				<!-- ========================================== PR Detail List ==================================== -->        
				<div class="row clearfix">
					<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

				        <div class="tablelist-container col-md-12 col-sm-12 col-xs-12">
							<div class="srstyle-list-title list-title">
								<span>Purchase request to be approved<span>								
							</div>													    

							<div class="srstyle-col-view">
						        <table>
						            <thead class="filters">
						                <th class="srstyle-thcbpr">
						             		<span>Choose All </span>
						             		<p>
							             		<input type="checkbox" class="filled-in" id="cbchoose-all-pr" class="srstyle-cbpr" checked/>
												<label for="cbchoose-all-pr" class="srstyle-lbcbpr"></label>
											</p>
						             	</th>
						            </thead>
						            <tbody id="cbpr-tbody">
						                
						            </tbody>
						        </table>
						    </div>

						    <div class="srstyle-col-content">
						        <table class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
						            <thead>
						                <tr class="filters">                							             	
							             	<th style="min-width:135px;">
							             		<span class="title-filter srstyle-cursor srstyle-fa-active" sortby="ASC" id="dtpr_no">PR # <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span>
				                                <div class="srstyle-combobox filter-combo" id="dtpr_no">
				                                  <div id="cdtpr_no"></div>
				                                </div>
							             	</th>
							             	<th style="min-width:120px;">
							             		<span class="title-filter srstyle-cursor" sortby="ASC" id="trpr_tgl">Date <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span>
				                                <div class="srstyle-combobox filter-combo" id="trpr_tgl">
				                                  <div id="ctrpr_tgl"></div>
				                                </div>
							             	</th>
							             	<th style="min-width:125px;">
							             		<span class="title-filter srstyle-cursor" sortby="ASC" id="dtpr_mspd_no">Product # <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span>
				                                <div class="srstyle-combobox filter-combo" id="dtpr_mspd_no">
				                                  <div id="cdtpr_mspd_no"></div>
				                                </div>
							             	</th>
							             	<th style="min-width:350px;">
							             		<span class="title-filter srstyle-cursor" sortby="ASC" id="mspd_nm">Product Name <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span>
				                                <div class="srstyle-combobox filter-combo" id="mspd_nm">
				                                  <div id="cmspd_nm"></div>
				                                </div>
							             	</th>
							             	<!-- <th>
							             		<span class="title-filter srstyle-cursor" sortby="ASC" id="mspd_qtyavl">Avaliable Stock <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span>
				                                <div class="srstyle-combobox filter-combo" id="mspd_qtyavl">
				                                  <div id="cmspd_qtyavl"></div>
				                                </div>
							             	</th> -->
							             	<th>
							             		<span class="title-filter srstyle-cursor" sortby="ASC" id="dtpr_qtyreq">Qty Request <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span>
				                                <div class="srstyle-combobox filter-combo" id="dtpr_qtyreq">
				                                  <div id="cdtpr_qtyreq"></div>
				                                </div>
							             	</th>
							             	<th style="min-width:200px;">
							             		<span class="title-filter srstyle-cursor" sortby="ASC" id="msmr_nm">Brand Name <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span>
				                                <div class="srstyle-combobox filter-combo" id="msmr_nm">
				                                  <div id="cmsmr_nm"></div>
				                                </div>
							             	</th>
							             	<th style="min-width:200px;">
							             		<span class="title-filter srstyle-cursor" sortby="ASC" id="mskt_nm">Category Name <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span>
				                                <div class="srstyle-combobox filter-combo" id="mskt_nm">
				                                  <div id="cmskt_nm"></div>
				                                </div>
							             	</th>
							             	<th style="min-width:200px;">
							             		<span class="title-filter srstyle-cursor" sortby="ASC" id="msfm_nm">Family Name <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span>
				                                <div class="srstyle-combobox filter-combo" id="msfm_nm">
				                                  <div id="cmsfm_nm"></div>
				                                </div>
							             	</th>
							             	<th style="min-width:200px;">
							             		<span class="title-filter srstyle-cursor" sortby="ASC" id="msmd_nm">Model Name <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span>
				                                <div class="srstyle-combobox filter-combo" id="msmd_nm">
				                                  <div id="cmsmd_nm"></div>
				                                </div>
							             	</th>
							             	<th style="min-width:200px;">
							             		<span class="title-filter srstyle-cursor" sortby="ASC" id="trpr_tag">Tag <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span>
				                                <div class="srstyle-combobox filter-combo" id="trpr_tag">
				                                  <div id="ctrpr_tag"></div>
				                                </div>
							             	</th>				        	                							             	
							            </tr>
						            </thead>
						            <tbody id="pr-datalist-tbody">
						                
						            </tbody>
						        </table>

						    </div>
						</div>						
						<div class="pull-right pagination-container"></div>
				        
				    </div>
				</div> 
				<!-- ========================================== End PR Detail List ==================================== -->

		</div>
        <!-- /Modal Body-->

        <div class="modal-footer srstyle-modal-footer">
	        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
	        <button type="button" id="btn-add-datapr" class="btn btn-default">Add Data PR</button>
	    </div>

        <div class="clearfix"></div>

        
      </div>
      
    </div>
  </div>
</div>

<script type="text/javascript">

	$(document).ready(function(){		        					
		var vper_page = 10;
		var vcurr_page = 1;
		$.ajax({
			method:"POST",
			data:{per_page:vper_page, offset:(vcurr_page - 1) * vper_page, curr_page: vcurr_page, sort:'DESC',fn:'dtpr_no', arr_filter: fobjFilter(), key:$("#key").val(), hash_key:$("#hash_key").val()},
			url:"<?php echo base_url('purchase_request/pr_detail_list'); ?>",
			dataType:"json",
			success:function(r){

						$("#pr-datalist-tbody").html(r.pr_detail_list);
						$("#cbpr-tbody").html(r.pr_detail_list);
		                $("#pr-datalist-tbody").find("td.tdcbpr").remove();
		                $("#cbpr-tbody td").not("td.tdcbpr").remove();
		                $(".pagination-container").html(r.pagination);

						var arr_dtpr_no = [];
						var arr_trpr_tgl = [];
						var arr_dtpr_mspd_no = [];
						var arr_mspd_nm = [];
						// var arr_mspd_qtyavl = [];
						var arr_dtpr_qtyreq = [];
						var arr_msmr_nm = [];
						var arr_mskt_nm = [];
						var arr_msfm_nm = [];
						var arr_msmd_nm = [];
						var arr_tag = [];

		                for (var i = 0; i < r.pr_detail.length; i++) {  		                                             	                
		                	var is_dtprno_exists = fvalueExists(arr_dtpr_no, r.pr_detail[i]['dtpr_no']);
		                	var is_trprtgl_exists = fvalueExists(arr_trpr_tgl, r.pr_detail[i]['trpr_tgl']);
		                	var is_dtprmspdno_exists = fvalueExists(arr_dtpr_mspd_no, r.pr_detail[i]['dtpr_mspd_no']);
		                	var is_mspdnm_exists = fvalueExists(arr_mspd_nm, r.pr_detail[i]['mspd_nm']);
		                	// var is_mspdqtyavl_exists = fvalueExists(arr_mspd_qtyavl, r.pr_detail[i]['mspd_qtyavl']);
		                	var is_dtprqtyreq_exists = fvalueExists(arr_dtpr_qtyreq, r.pr_detail[i]['dtpr_qtyreq']);
		                	var is_msmrnm_exists = fvalueExists(arr_msmr_nm, r.pr_detail[i]['msmr_nm']);
		                	var is_msktnm_exists = fvalueExists(arr_mskt_nm, r.pr_detail[i]['mskt_nm']);
		                	var is_msfmnm_exists = fvalueExists(arr_msfm_nm, r.pr_detail[i]['msfm_nm']);
		                	var is_msmdnm_exists = fvalueExists(arr_msmd_nm, r.pr_detail[i]['msmd_nm']);
		                	var is_tag_exists = fvalueExists(arr_tag, r.pr_detail[i]['trpr_tag']);

		                	fsetarr_combo_option(arr_dtpr_no, r.pr_detail[i]['dtpr_no'], is_dtprno_exists);
		                	fsetarr_combo_option(arr_trpr_tgl, r.pr_detail[i]['trpr_tgl'], is_trprtgl_exists);
		                	fsetarr_combo_option(arr_dtpr_mspd_no, r.pr_detail[i]['dtpr_mspd_no'], is_dtprmspdno_exists);
		                	fsetarr_combo_option(arr_mspd_nm, r.pr_detail[i]['mspd_nm'], is_mspdnm_exists);
		                	// fsetarr_combo_option(arr_mspd_qtyavl, r.pr_detail[i]['mspd_qtyavl'], is_mspdqtyavl_exists);
		                	fsetarr_combo_option(arr_dtpr_qtyreq, r.pr_detail[i]['dtpr_qtyreq'], is_dtprqtyreq_exists);
		                	fsetarr_combo_option(arr_msmr_nm, r.pr_detail[i]['msmr_nm'], is_msmrnm_exists);
		                	fsetarr_combo_option(arr_mskt_nm, r.pr_detail[i]['mskt_nm'], is_msktnm_exists);
		                	fsetarr_combo_option(arr_msfm_nm, r.pr_detail[i]['msfm_nm'], is_msfmnm_exists);
		                	fsetarr_combo_option(arr_msmd_nm, r.pr_detail[i]['msmd_nm'], is_msmdnm_exists);
		                	fsetarr_combo_option(arr_tag, r.pr_detail[i]['trpr_tag'], is_tag_exists);
	                        	                    
		                }                  	                  
		                
		                combo_dtpr_no = dhtmlXComboFromSelect("cdtpr_no"); 
		                fsetting_combo_pr(combo_dtpr_no, arr_dtpr_no, "dtpr_no", vper_page);

		                combo_trpr_tgl = dhtmlXComboFromSelect("ctrpr_tgl"); 
		                fsetting_combo_pr(combo_trpr_tgl, arr_trpr_tgl, "trpr_tgl", vper_page);

						combo_dtpr_mspd_no = dhtmlXComboFromSelect("cdtpr_mspd_no"); 
						fsetting_combo_pr(combo_dtpr_mspd_no, arr_dtpr_mspd_no, "dtpr_mspd_no", vper_page);	   

						combo_mspd_nm = dhtmlXComboFromSelect("cmspd_nm"); 
						fsetting_combo_pr(combo_mspd_nm, arr_mspd_nm, "mspd_nm", vper_page);	  

						// combo_mspd_qtyavl = dhtmlXComboFromSelect("cmspd_qtyavl"); 
						// fsetting_combo_pr(combo_mspd_qtyavl, arr_mspd_qtyavl, "mspd_qtyavl", vper_page);

						combo_dtpr_qtyreq = dhtmlXComboFromSelect("cdtpr_qtyreq"); 
						fsetting_combo_pr(combo_dtpr_qtyreq, arr_dtpr_qtyreq, "dtpr_qtyreq", vper_page);

						combo_msmr_nm = dhtmlXComboFromSelect("cmsmr_nm"); 
						fsetting_combo_pr(combo_msmr_nm, arr_msmr_nm, "msmr_nm", vper_page);	  

						combo_mskt_nm = dhtmlXComboFromSelect("cmskt_nm"); 
						fsetting_combo_pr(combo_mskt_nm, arr_mskt_nm, "mskt_nm", vper_page);	    

						combo_msfm_nm = dhtmlXComboFromSelect("cmsfm_nm"); 
						fsetting_combo_pr(combo_msfm_nm, arr_msfm_nm, "msfm_nm", vper_page);	    

						combo_msmd_nm = dhtmlXComboFromSelect("cmsmd_nm"); 
						fsetting_combo_pr(combo_msmd_nm, arr_msmd_nm, "msmd_nm", vper_page);	    

						combo_tag = dhtmlXComboFromSelect("ctrpr_tag"); 
						fsetting_combo_pr(combo_tag, arr_tag, "trpr_tag", vper_page);	

						if("<?php echo $action; ?>" == 'new_import'){
							var trpr_no = "<?php if(isset($trpr_no)){ echo $trpr_no; } ?>";							
				            var index_option = combo_dtpr_no.getIndexByValue(trpr_no);
				        	combo_dtpr_no.selectOption(index_option, true, true);    
				        }      
			}	
		});				
			
		
		//Ajak POST untuk pagination
		$(document).on('click','.page-number',function(){			
			vcurr_page = $(this).attr("id");
			vsort = $(this).attr("sortby");
			vfn = $(this).attr("fn");						
			$.ajax({
				method:"POST",
				data:{per_page:vper_page, offset:(vcurr_page - 1) * vper_page, curr_page: vcurr_page, sort:vsort, fn:vfn, arr_filter: fobjFilter(), key:$("#key").val(), hash_key:$("#hash_key").val()},
				url:"<?php echo base_url('purchase_request/pr_detail_list'); ?>",
				dataType:"json",
				success:function(r){												
					$("#pr-datalist-tbody").html(r.pr_detail_list);
					$("#cbpr-tbody").html(r.pr_detail_list);
	                $("#pr-datalist-tbody").find("td.tdcbpr").remove();
	                $("#cbpr-tbody td").not("td.tdcbpr").remove();
	                $(".pagination-container").html(r.pagination);
	    			$('.cbpr').prop('checked', $("#cbchoose-all-pr").prop("checked"));
	                for (var i = 0; i < arrcbpr.length; i++) {
	                	$('.cbpr').each(function(){
							if($(this).attr("id") == arrcbpr[i]){
								if($("#cbchoose-all-pr").prop("checked") == true){
									$(this).prop("checked", false);
								}else{
									$(this).prop("checked", true);
								}
							}							
						});
	                };	                
				}	
			});			
		});

		//Ajak POST untuk sort
		$(document).on("click", ".title-filter", function(){			
			vcurr_page = 1;			
			var vsort = $(this).attr("sortby");
			var vfn = $(this).attr("id");

			$.ajax({
				method:"POST",
				data:{per_page:vper_page, offset:(vcurr_page - 1) * vper_page, curr_page: vcurr_page, sort:vsort,fn:vfn, arr_filter: fobjFilter(), key:$("#key").val(), hash_key:$("#hash_key").val()},
				url:"<?php echo base_url('purchase_request/pr_detail_list'); ?>",
				dataType:"json",
				success:function(r){
					$("#pr-datalist-tbody").html(r.pr_detail_list);
					$("#cbpr-tbody").html(r.pr_detail_list);
	                $("#pr-datalist-tbody").find("td.tdcbpr").remove();
	                $("#cbpr-tbody td").not("td.tdcbpr").remove();
	                $(".pagination-container").html(r.pagination);
	                $('.cbpr').prop('checked', $("#cbchoose-all-pr").prop("checked"));
	                for (var i = 0; i < arrcbpr.length; i++) {
	                	$('.cbpr').each(function(){
							if($(this).attr("id") == arrcbpr[i]){
								if($("#cbchoose-all-pr").prop("checked") == true){
									$(this).prop("checked", false);
								}else{
									$(this).prop("checked", true);
								}
							}							
						});
	                };	                
				}	
			});

			if (vsort == "ASC") {
				$(this).attr("sortby","DESC");
				$(this).find("i").removeClass("fa-sort-alpha-desc").addClass("fa fa-sort-alpha-asc");
			}else{
				$(this).attr("sortby","ASC");
				$(this).find("i").removeClass("fa-sort-alpha-asc").addClass("fa-sort-alpha-desc");
			}

			$(".title-filter").not($(this)).attr("sortby","ASC");
			$(".title-filter, .title-filter > i").not($(this)).removeClass("srstyle-fa-active");			
			$(this, this + " > i").addClass("srstyle-fa-active");

		});		 	

	});


</script> 

<!-- ===================================================== Event =========================================== -->
<script type="text/javascript">
	var arrcbpr = [];
	$("#cbchoose-all-pr").click(function(){		
		$('.cbpr').prop('checked', this.checked);		
		arrcbpr = [];				
	});

	$(document).on('click','.cbpr', function(){
		if($("#cbchoose-all-pr").prop("checked") == true){
			if(this.checked == false){			
				arrcbpr.push($(this).attr("id"));			
			}else{						
				arrcbpr.splice(arrcbpr.indexOf($(this).attr("id")), 1);
			}
		}else{
			if(this.checked == true){			
				arrcbpr.push($(this).attr("id"));			
			}else{						
				arrcbpr.splice(arrcbpr.indexOf($(this).attr("id")), 1);
			}
		}					
	});	


</script>
<!-- =================================================== End Event =========================================== -->


<!-- ===================================================== Funcntion =========================================== -->
<script>

	function fvalueExists(arr,val) {
	  return arr.some(function(el) {
	    return el.text === val;
	  }); 
	}
			
	function ffilterPR(vper_page){					
		$.ajax({
			method:"POST",			
			data:{per_page:vper_page, offset:0, curr_page: 1, sort:"DESC",fn:"dtpr_no", arr_filter: fobjFilter(), key:$("#key").val(), hash_key:$("#hash_key").val()},
			url:"<?php echo base_url('purchase_request/pr_detail_list'); ?>",
			dataType:"json",
			success:function(r){
				$("#pr-datalist-tbody").html(r.pr_detail_list);
				$("#cbpr-tbody").html(r.pr_detail_list);
                $("#pr-datalist-tbody").find("td.tdcbpr").remove();
                $("#cbpr-tbody td").not("td.tdcbpr").remove();
                $(".pagination-container").html(r.pagination);
                $('.cbpr').prop('checked', $("#cbchoose-all-pr").prop("checked"));
                for (var i = 0; i < arrcbpr.length; i++) {
                	$('.cbpr').each(function(){
						if($(this).attr("id") == arrcbpr[i]){
							if($("#cbchoose-all-pr").prop("checked") == true){
								$(this).prop("checked", false);
							}else{
								$(this).prop("checked", true);
							}
						}							
					});
                };	                
                $(".title-filter, .title-filter > i").removeClass("srstyle-fa-active");
			}	
		});				
	}

	function fobjFilter(){
		var objFilter = {};						

		$(".filter-combo .dhxcombo_input").each(function(){
			if($(this).val() !== "" ){					
				var key = $(this).parents(".filter-combo").attr("id");
				objFilter[key] = $(this).val();                           							
			}				
		});
		return objFilter;
	}

	function fsetting_combo_pr(obj, arr, field_name, vper_page){
		obj.addOption(arr); 
        obj.enableFilteringMode("between");
        obj.allowFreeText(false);                                    														
        obj.attachEvent("onOpen", function(){
        	var curr_thwidth = $("#" + field_name).parent().width();
		    $(".dhxcombolist_material").css({"z-index":"20000", width: curr_thwidth});
		    $(".dhxcombo_material .dhxcombo_input").css({width:"100%"});					    
		});	
		obj.attachEvent("onChange", function(){
    		ffilterPR(vper_page);
		});	
	}

	function fsetarr_combo_option(arr, value, is_exists){  							
		if(!is_exists){
            arr.push({                            
                value: value,
                text: value
            });
        }	
	}

</script>
<!-- ================================================== End Funcntion =========================================== -->