<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_sales_delivery extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('setting/m_user_log');		
	}

	public function get_sales_delivery_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trsd_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_sales_dlv.*, mscb_nm, msgd_nm, mscs_nm, mscs_npwp, mscs_almt_jln, mscs_almt_kota, mscs_almt_kota, trso_tophari, trso_pocust');
		$this->db->from('tr_sales_dlv');		
		$this->db->join('ms_cabang','mscb_no = trsd_mscb_no', 'left');		
		$this->db->join('ms_gudang','msgd_no = trsd_msgd_no', 'left');		
		$this->db->join('ms_customer','mscs_no = trsd_mscs_no', 'left');
		$this->db->join('tr_so','trso_no = substring(trsd_no,1,12)', 'left');
		// $this->db->join('tr_jurnal AS a', 'a.trju_refno = tr_sales_dlv.trsd_no','left');
		// $this->db->join('tr_jurnal AS b', 'b.trju_refno = CONCAT(tr_sales_dlv.trsd_no, "DR")','left');

		$query_string = '';

		//Confirm delivery status:
		//1. Confirmed
		//2. Not yet confirmed

		if(isset($arr_filter['confirm_status'])){
			if($arr_filter['confirm_status'] == '1'){			
				$query_string .= 'trsd_tglbalik != 0000-00-00';
			}elseif($arr_filter['confirm_status'] == '2'){			
				$query_string .= 'trsd_tglbalik = 0000-00-00';
			}
			unset($arr_filter['confirm_status']);	
		}

		//Delivery status:
		//1. Delivered
		//2. Not yet delivered

		if(isset($arr_filter['delivery_status'])){
			if($arr_filter['delivery_status'] == '1'){			
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'trsd_tglkirim != 0000-00-00';
			}elseif($arr_filter['delivery_status'] == '2'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'trsd_tglkirim = 0000-00-00';
			}
			unset($arr_filter['delivery_status']);	
		}


		//TOP status:
		//1. TOP Due Date
		//2. TOP Late Date

		if(isset($arr_filter['top_status'])){
			if($arr_filter['top_status'] == 1){			
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= ' trsd_toptgl <> 0
									AND trsd_terbayar < trsd_total
									AND (DATEDIFF(trsd_toptgl, CURDATE()) <= 10
									AND DATEDIFF(trsd_toptgl, CURDATE()) >= 0) ';
			}elseif($arr_filter['top_status'] == 2){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= ' trsd_toptgl <> 0
									AND trsd_terbayar < trsd_total
									AND DATEDIFF(trsd_toptgl, CURDATE()) < 0 ';
			}
			unset($arr_filter['top_status']);	
		}

		//Payment status:
		//1. Settled
		//2. Unsettled

		if(isset($arr_filter['payment_status'])){
			if($arr_filter['payment_status'] == 1){			
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'trsd_terbayar >= trsd_total';
			}elseif($arr_filter['payment_status'] == 2){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'trsd_terbayar < trsd_total';
			}
			unset($arr_filter['payment_status']);	
		}

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_so x1 WHERE x1.dtso_no = SUBSTRING(trsd_no, 1, 12) AND x1.dtso_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_so x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtso_mspd_no WHERE x2.dtso_no = SUBSTRING(trsd_no, 1, 12) AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}

		if(isset($arr_filter['mskt_no'])){
			if($arr_filter['mskt_no'] != 'all'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'EXISTS(SELECT dt_so.*, mskt_no FROM dt_so LEFT JOIN ms_produk AS b ON b.mspd_no = dtso_mspd_no LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(b.mspd_no, 1, 1) WHERE dtso_no = SUBSTRING(trsd_no, 1, 12) AND mskt_no ="'. $arr_filter['mskt_no']. '")';
			}	
			unset($arr_filter['mskt_no']);
		}		

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}
		// $arr_filter['trsd_void'] = 0;
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_sales_delivery_dtlist($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'dtsd_no', $sort = 'DESC'){
		if(!$is_count){
			$this->db->limit($per_page, $offset);		
		}
		$this->db->select('dt_sales_dlv.*
							,tr_sales_dlv.*
							,mspd_nm
							,mscs_no
							,mscs_nm
							,mscs_jenis
							,mscs_almt_jln
							,mscs_almt_kota
							,mscs_almt_provinsi
							,trso_fin');
		$this->db->from('dt_sales_dlv');				
		$this->db->join('tr_sales_dlv','trsd_no = dtsd_no', 'left');				
		$this->db->join('ms_customer','mscs_no = trsd_mscs_no', 'left');				
		$this->db->join('ms_produk','mspd_no = dtsd_mspd_no', 'left');
		$this->db->join('tr_so','trso_no = substring(dtsd_no,1,12)', 'left');

		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		

		$this->db->where(array('mspd_reqserialno'=>'Y'));
		$this->db->order_by($fn, $sort);
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_sales_delivery($trsd_no){		
		$data = array();		
		
		//Get sales delivery header berdasarkan trsd_no	
		$this->db->select('*, 
							a.msus_nm AS msus_nm1, 
							b.msus_nm AS msus_nm2, 
							c.msus_nm AS msus_nm3,							
							EXISTS(SELECT pbso_refno FROM pby_so WHERE pbso_refno = "'.$trsd_no.'" AND pbso_void = 0) AS is_sdhaspaid,
							EXISTS(SELECT trsr_no FROM tr_salesret WHERE SUBSTRING(trsr_no, 1, 17) = "'.$trsd_no.'" AND trsr_void = 0) AS is_srcreated');
		$this->db->from('tr_sales_dlv');
		$this->db->join('ms_customer', 'mscs_no = trsd_mscs_no','left');
		$this->db->join('ms_cabang', 'mscb_no = trsd_mscb_no','left');		
		$this->db->join('ms_user AS a', 'a.msus_no = tr_sales_dlv.trsd_msus_no','left');
		$this->db->join('ms_user AS b', 'b.msus_no = tr_sales_dlv.trsd_dlvnowusr','left');
		$this->db->join('ms_user AS c', 'c.msus_no = tr_sales_dlv.trsd_cnfusr','left');
		// $this->db->join('tr_jurnal AS d', 'd.trju_refno = CONCAT(tr_sales_dlv.trsd_no, "SD")','left');			
		// $this->db->join('tr_jurnal AS e', 'e.trju_refno = CONCAT(tr_sales_dlv.trsd_no, "DR")','left');
		$this->db->join('tr_so', 'trso_no = SUBSTRING(trsd_no,1,12)','left');
		$this->db->where('trsd_no',$trsd_no);
		$query = $this->db->get();
		
		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];

			$trso_no = substr($trsd_no, 0,12);
			
			$this->db->select('trso_cekint');
			$this->db->where('trso_no',$trso_no);
			$query = $this->db->get('tr_so');
			$result = $query->result_array();				

			$data['header']['trso_cekint'] = $result[0]['trso_cekint'];			
		}

		// .' IFNULL((SELECT SUM(dtsd_qtykrm - dtsd_qtyrej) FROM dt_sales_dlv LEFT JOIN tr_sales_dlv ON tr_sales_dlv.trsd_no=dt_sales_dlv.dtsd_no WHERE SUBSTRING(dtsd_no,1,12) = dtso_no AND dtsd_seq = dtso_seq AND dtsd_no <> ? AND trsd_void = 0),0) AS calc_qty_sd,'

		//Get dt_sales_dlv
		$sql = 'SELECT dt_so.*,' 					
					.' IFNULL(dtsd_statuspaket,dtso_statuspaket) as dtsd_statuspaket,'
					.' mskt_statusinv,'
					.' IFNULL(dt_sales_dlv.dtsd_no,"") AS dtsd_no,'
					.' IFNULL(dt_sales_dlv.dtsd_seq,"") AS dtsd_seq,'
					.' IFNULL(dt_sales_dlv.dtsd_mspd_no,"") AS dtsd_mspd_no,'
					.' IFNULL(dt_sales_dlv.dtsd_hpp,"") AS dtsd_hpp,'
					.' IFNULL(dt_sales_dlv.dtsd_qtykrm,0) AS dtsd_qtykrm,'
					.' IFNULL(dt_sales_dlv.dtsd_qtyrej,0) AS dtsd_qtyrej,'
					.' IFNULL(dt_sales_dlv.dtsd_noserial,"") AS dtsd_noserial,'
					.' IFNULL(dt_sales_dlv.dtsd_ketgaransi,"") AS dtsd_ketgaransi,'
					.' IFNULL(dt_sales_dlv.dtsd_tglgaransisp,"") AS dtsd_tglgaransisp,'
					.' IFNULL(dt_sales_dlv.dtsd_tglgaransijasa,"") AS dtsd_tglgaransijasa,'
					.' IFNULL(dt_sales_dlv.dtsd_nett,0) AS dtsd_nett,'
					.' IFNULL((SELECT SUM(dtsr_qtyretur) FROM dt_salesret LEFT JOIN tr_salesret ON tr_salesret.trsr_no=dt_salesret.dtsr_no WHERE SUBSTRING(dtsr_no,1,17) = dtsd_no AND dtsr_seq = dtsd_seq AND dtsr_no <> "" AND trsr_void = 0),0) AS calc_qty_retur,'
					.' ms_produk.mspd_nm, ms_produk.mspd_reqserialno, mspd_hpp, mskt_msap_no_inv, mskt_msap_no_pjr, mskt_msap_no_pja, mskt_msap_no_hpr, mskt_msap_no_hpa'
					.' FROM dt_so'
					.' LEFT JOIN dt_sales_dlv'
					.' ON dtsd_no=?'
					.' AND dt_so.dtso_seq = dt_sales_dlv.dtsd_seq'
					.' LEFT JOIN ms_produk'
					.' ON dt_so.dtso_mspd_no=ms_produk.mspd_no'					
					.' LEFT JOIN ms_kategori'
					.' ON ms_kategori.mskt_no=SUBSTRING(ms_produk.mspd_no,1,1)'
					.' WHERE dt_so.dtso_no =? ORDER BY dtso_seq ASC';

		$query = $this->db->query($sql, array($trsd_no, $trso_no));

		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;
		}
		
		return $data;
		
	}		

	public function get_sales_delivery_import($trsd_no){		
		$data = array();		
		
		//Get sales delivery header berdasarkan trsd_no	
		$this->db->select('tr_sales_dlv.*, ms_customer.*, trso_tgl');
		$this->db->from('tr_sales_dlv');
		$this->db->join('ms_customer', 'tr_sales_dlv.trsd_mscs_no = ms_customer.mscs_no','inner');
		$this->db->join('tr_so','trso_no = substring(trsd_no,1,12)', 'left');
		$this->db->where('trsd_no',$trsd_no);
		$query = $this->db->get();
		
		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];
		}

		//Get sales delivery detail berdasarkan trsd_no	
		$this->db->select("*, 
							IFNULL((SELECT SUM(dtsr_qtyretur) FROM dt_salesret LEFT JOIN tr_salesret ON tr_salesret.trsr_no=dt_salesret.dtsr_no WHERE SUBSTRING(dtsr_no,1,17) = dtsd_no AND dtsr_seq = dtsd_seq AND dtsr_no <> '' AND trsr_void = 0),0) AS calc_qty_retur");
		$this->db->from('dt_sales_dlv');
		$this->db->join('ms_produk', 'dt_sales_dlv.dtsd_mspd_no = ms_produk.mspd_no','left');
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_produk.mspd_no,1,1)','left');
		$this->db->where('dt_sales_dlv.dtsd_no',$trsd_no);
		$this->db->where('ms_kategori.mskt_statusinv','Y');
		$this->db->order_by('dtsd_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;
		}
		if(count($data) > 0){
			return $data;
		}else{
			return false;
		}
	}		

	public function get_hppsd($dtsd_no, $dtsd_seq){
		$query = $this->db->get_where('dt_sales_dlv', array('dtsd_no'=>$dtsd_no, 'dtsd_seq'=>$dtsd_seq));
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['dtsd_hpp'];
		}else{
			return 0;
		}
	}	

	public function get_sales_delivery_bysoid($trso_no){				
		//Get sales delivery header berdasarkan trso_no	
		$where_sql = "trsd_terbayar < trsd_total AND trsd_tglbalik <> '0000-00-00' AND trsd_void = 0 AND SUBSTRING(trsd_no, 1, 12) = '". $trso_no."'";
		$this->db->select('*');
		$this->db->from('tr_sales_dlv');						
		$this->db->where('SUBSTRING(trsd_no, 1, 12) = ', $trso_no);
		$this->db->where($where_sql, null, false);
		$query = $this->db->get();
				
		return $query->result_array();		
	}

	public function get_sales_delivery_bycust($mscs_no){						
		$where_sql = "trsd_terbayar < trsd_total AND trsd_tglbalik <> '0000-00-00' AND trsd_void = 0";
		$this->db->select('tr_sales_dlv.*, mscs_nm, DATE_FORMAT(trsd_tgl, "%Y-%m-%d") as trsd_tgl');
		$this->db->from('tr_sales_dlv');
		$this->db->join('ms_customer', 'mscs_no = trsd_mscs_no', 'left');
		$this->db->where('trsd_mscs_no', $mscs_no);
		$this->db->where($where_sql, null, false);
		$query = $this->db->get();
				
		return $query->result_array();		
	}

	public function sales_delivery_kode_auto($trso_no){
		$this->db->select_max("trsd_no");
		$this->db->like("trsd_no", $trso_no, "after");
		$query = $this->db->get("tr_sales_dlv");
		if ($query->num_rows() == 0){
			return $trso_no. "-DL01";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trsd_no'];
			$nomor = ((int) substr($kode, 15)) + 1;			
			return $trso_no. '-DL'. sprintf("%'.02d", $nomor);
		}
	}

	public function get_sales_delivery_cekint($trsd_no, $trsd_cekint){		
		$query =  $this->db->get_where('tr_sales_dlv', array('trsd_no' => $trsd_no, 'trsd_cekint' => $trsd_cekint));
		
		if($query->num_rows()){
			return true;
		}else{
			return false;
		}		
	}		

	public function set_sales_delivery_cekint($trsd_no){		
		//Update trsd_cekint di tabel tr_sales_dlv
		$this->db->where('trsd_no', $trsd_no);
		$this->db->update('tr_sales_dlv', array('trsd_cekint' => rand(0,10000)));
	}

	public function sales_delivery_simpan($data){
		try {					
				if($data['action'] == 'NEW'){
					$this->insert_data($data);
					// Update trsd_total
					$this->update_trsd_total($data['header']['trsd_no']);
				}		

				if($data['action'] == 'SHIPPINGFEE'){
					//1. Update header sales delivery
					$this->db->where('trsd_no', $data['header']['trsd_no']);
					$this->db->update('tr_sales_dlv', $data['header']);
				}

				if($data['action'] == 'EDIT'){					
					$this->update_data($data);
					// Update trsd_total
					$this->update_trsd_total($data['header']['trsd_no']);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);				
				}

				if($data['action'] == 'DELIVERYNOW'){
					//todo list
					//1. Update data sales delivery header/detail					
					//2. Update hpp (-)
					//3. Update stok (-)
					//4. Create jurnal

					//1. Update data sales delivery header/detail
					$this->update_data($data);
					// Update trsd_total
					$this->update_trsd_total($data['header']['trsd_no']);					
					//2. Update hpp (-)
					$this->save_update_hpp('DELIVERYNOW', $data['header']['trsd_no'], -1, 'SDD');
					// $this->update_hpp('DELIVERYNOW', $data['header']['trsd_no'], -1);
					//3. Update stok (-)
					$this->update_stok('DELIVERYNOW', $data['header']['trsd_no'], -1);
					//4. Create jurnal
					$this->jurnal_simpan($data);
				}

				if($data['action'] == 'CANCEL_DELIVERYNOW'){
					//todo list
					//1. Update hpp (+)
					//2. Update stok (+)
					//3. Update data sales delivery header/detail					
					//4. Delete jurnal

					//1. Update hpp (+)
					$this->save_update_hpp('CANCEL_DELIVERYNOW', $data['header']['trsd_no'], 1, 'SDC');
					// $this->update_hpp('CANCEL_DELIVERYNOW', $data['header']['trsd_no'], 1);
					//2. Update stok (+)
					$this->update_stok('CANCEL_DELIVERYNOW', $data['header']['trsd_no'], 1);
					//3. Update data sales delivery header/detail
					$this->update_data($data);							
					//4. Delete jurnal
					$this->jurnal_hapus($data);
				}

				if($data['action'] == 'CONFDELIVERY'){
					//todo list
					//1. Update data sales delivery header/detail					
					//2. Update hpp (+)
					//3. Update stok (+)										
					//4. Create jurnal					

					//1. Update data sales delivery header/detail
					$this->update_data($data);
					// Update trsd_total
					$this->update_trsd_total($data['header']['trsd_no']);					
					//2. Update hpp (+)
					$this->save_update_hpp('CONFDELIVERY', $data['header']['trsd_no'], 1, 'SCD');
					// $this->update_hpp('CONFDELIVERY', $data['header']['trsd_no'], 1);
					//3. Update stok (+)
					$this->update_stok('CONFDELIVERY', $data['header']['trsd_no'], 1);										
					//4. Create jurnal
					$this->jurnal_simpan($data);
					
				}

				if($data['action'] == 'CANCEL_CONFDELIVERY'){
					//todo list
					//1. Update hpp (-)
					//2. Update stok (-)
					//3. Update data sales delivery header/detail										
					//4. Delete jurnal					
					
					//1. Update hpp (-)
					$this->save_update_hpp('CANCEL_CONFDELIVERY', $data['header']['trsd_no'], -1, 'SCC');					
					// $this->update_hpp('CANCEL_CONFDELIVERY', $data['header']['trsd_no'], -1);
					//2. Update stok (-)
					$this->update_stok('CANCEL_CONFDELIVERY', $data['header']['trsd_no'], -1);					
					//3. Update data sales delivery header/detail
					$this->update_data($data);					
					// Update trsd_total
					$this->update_trsd_total($data['header']['trsd_no']);
					//4. Delete jurnal
					$this->jurnal_hapus($data);					
				}											

				if($data['action'] == 'VOID'){					
					// //Set dtso_qtysd = 0 di tabel dt_so										
					// $this->db->where(array('dtso_no' => substr($data['header']['trsd_no'], 0, 12)));
					// $this->db->update('dt_so', array('dtso_qtysd' => 0));	

					//void sales delivery									
					$this->db->where('trsd_no', $data['header']['trsd_no']);
					$this->db->update('tr_sales_dlv', array('trsd_void'=>1));	
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);				
				}

				//Update dtso_qtysd di detail so
				$this->update_qtysd($data['header']['trsd_no']);

				//Update dtso_qtykirim di detail so
				if($data['action'] != 'NEW'){					
					$this->update_qtykirim($data['header']['trsd_no']);
				}

				if($data['action'] == 'CONFDELIVERY' || $data['action'] == 'CANCEL_CONFDELIVERY'){
					$this->load->model('sales/m_sales_order');
					$this->m_sales_order->update_stcopy($data['action'], substr($data['header']['trsd_no'], 0, 12));										
				}

				return 1;						
		} catch (Exception $e) {
			return 0;
		}		
	}	

	private function insert_data($data){
		//todo list
		//1. Insert header sales delivery
		//2. Insert detail sales delivery					

		//1. Insert header sales delivery
		// Generate CekInt
		$data['header']['trsd_cekint'] = rand(0,10000);						
		$this->db->insert('tr_sales_dlv',$data['header']);
		//2. Insert detail sales delivery
		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $detail) {												
				$this->db->insert('dt_sales_dlv',$data['detail'][$key]);						
			}		
		}								
	}

	private function update_data($data){		
		$this->db->where('trsd_no', $data['header']['trsd_no']);
		$this->db->update('tr_sales_dlv', $data['header']);
		
		$this->db->where(array('dtsd_no' => $data['header']['trsd_no']));
		$this->db->delete('dt_sales_dlv');

		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $value) {				
				$this->db->insert('dt_sales_dlv', $data['detail'][$key]);
			}						
		}
	}	

	private function update_qtysd($trsd_no){
		$query = "UPDATE dt_so SET dtso_qtysd =" 
					."IFNULL(("
					." SELECT SUM(A.dtsd_qtykrm - A.dtsd_qtyrej) FROM dt_sales_dlv A"
					." LEFT JOIN tr_sales_dlv B ON B.trsd_no = A.dtsd_no"
					." WHERE SUBSTRING(A.dtsd_no,1,12) = dt_so.dtso_no"
					." AND A.dtsd_seq = dt_so.dtso_seq"
					." AND B.trsd_void = 0"
					."),0)"
				." WHERE dt_so.dtso_no = '".substr($trsd_no, 0, 12)."'";
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
	}

	private function update_qtykirim($trsd_no){
		$query = "UPDATE dt_so SET dtso_qtykirim ="
					."IFNULL(("
					." SELECT SUM(A.dtsd_qtykrm - A.dtsd_qtyrej) FROM dt_sales_dlv A"
					." LEFT JOIN tr_sales_dlv B ON B.trsd_no = A.dtsd_no"
					." WHERE SUBSTRING(A.dtsd_no,1,12) = dt_so.dtso_no"
					." AND A.dtsd_seq = dt_so.dtso_seq"
					." AND B.trsd_void = 0"
					." AND B.trsd_tglkirim <> '0000-00-00'"
					."),0)"
				." WHERE dt_so.dtso_no = '".substr($trsd_no, 0, 12)."'";
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
	}

	private function update_trsd_total($trsd_no){
		$query = "UPDATE tr_sales_dlv SET trsd_total ="
										."IFNULL(ROUND(("
										." SELECT SUM(A.dtsd_nett * (A.dtsd_qtykrm - A.dtsd_qtyrej)) FROM dt_sales_dlv A"					
										." WHERE A.dtsd_no = '".$trsd_no."'"					
										."), 4),0)"
				." WHERE tr_sales_dlv.trsd_no = '".$trsd_no."'";				
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
	}
//AND D.dtsd_statuspaket <> 'P'
	private function save_update_hpp($menu, $trsd_no, $i, $trhpp_refjenis){
		$trhpp_tgl = date('Y-m-d H:i:s');

		if($menu == 'DELIVERYNOW' || $menu == 'CANCEL_DELIVERYNOW'){
			$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
								(SELECT '".$trhpp_tgl."',
										'".$trhpp_refjenis."',
										'".$trsd_no."',
										D.dtsd_mspd_no, 
										(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtsd_mspd_no),
										 P.mspd_hpp,
										 SUM(".$i." * D.dtsd_qtykrm),
										ROUND(SUM((".$i." * D.dtsd_qtykrm) * D.dtsd_hpp), 4)
								FROM dt_sales_dlv D 
								LEFT JOIN ms_produk P 
								ON P.mspd_no = D.dtsd_mspd_no 
								LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtsd_mspd_no,1,1)
								WHERE D.dtsd_no = '".$trsd_no."'
								AND D.dtsd_statuspaket <> 'P'
								AND D.dtsd_qtykrm > 0
								AND KT.mskt_statusinv = 'Y'
								GROUP BY D.dtsd_mspd_no, D.dtsd_hpp)";
		}

		if($menu == 'CONFDELIVERY' || $menu == 'CANCEL_CONFDELIVERY'){
			$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
								(SELECT '".$trhpp_tgl."',
										'".$trhpp_refjenis."',
										'".$trsd_no."',
										D.dtsd_mspd_no, 
										(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtsd_mspd_no),
										 P.mspd_hpp,
										 SUM(".$i." * D.dtsd_qtyrej),
										ROUND(SUM((".$i." * D.dtsd_qtyrej) * D.dtsd_hpp), 4)
								FROM dt_sales_dlv D 
								LEFT JOIN ms_produk P 
								ON P.mspd_no = D.dtsd_mspd_no 
								LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtsd_mspd_no,1,1)
								WHERE D.dtsd_no = '".$trsd_no."'
								AND D.dtsd_statuspaket <> 'P'
								AND D.dtsd_qtyrej > 0
								AND KT.mskt_statusinv = 'Y'
								GROUP BY D.dtsd_mspd_no, D.dtsd_hpp)";
		}

		$this->db->simple_query($query);

		$query = "UPDATE tr_his_hpp 
					SET trhpp_totalawal = ROUND((trhpp_qtyawal * trhpp_hppawal), 4),
						trhpp_hppakhir = IF(
							(trhpp_qtyawal + (trhpp_qtytrans)) <> 0,
							ROUND(
								((trhpp_qtyawal * trhpp_hppawal) + (trhpp_totaltrans))
								 /
								 (trhpp_qtyawal + (trhpp_qtytrans)), 4), trhpp_hppawal)
					WHERE trhpp_tgl = '".$trhpp_tgl."'
					AND trhpp_refjenis = '".$trhpp_refjenis."'
					AND trhpp_refno = '".$trsd_no."'";		

		$this->db->simple_query($query);

		$query = "UPDATE ms_produk P 
							SET P.mspd_hpp = IFNULL((SELECT trhpp_hppakhir FROM tr_his_hpp 
										WHERE trhpp_tgl = '".$trhpp_tgl."'
										AND trhpp_refjenis = '".$trhpp_refjenis."'
										AND trhpp_refno = '".$trsd_no."'
										AND trhpp_mspd_no = P.mspd_no), P.mspd_hpp)
				WHERE P.mspd_no IN
				(SELECT dtsd_mspd_no FROM dt_sales_dlv D
				LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtsd_mspd_no,1,1)
				WHERE dtsd_no = '".$trsd_no."'";
		
		if($menu == 'DELIVERYNOW' || $menu == 'CANCEL_DELIVERYNOW'){
			$query .= ' AND D.dtsd_qtykrm > 0';
		}

		if($menu == 'CONFDELIVERY' || $menu == 'CANCEL_CONFDELIVERY'){
			$query .= ' AND D.dtsd_qtyrej > 0';
		}

		$query .= " AND D.dtsd_statuspaket <> 'P'";
		$query .= " AND KT.mskt_statusinv = 'Y')";

		$this->db->simple_query($query);
	}

	private function update_hpp($menu, $trsd_no, $i){

		if($menu == 'DELIVERYNOW' || $menu == 'CANCEL_DELIVERYNOW'){
				$query = "UPDATE ms_produk SET mspd_hpp =ROUND("
											."((mspd_hpp * (SELECT SUM(A.msst_qty) FROM ms_stok A WHERE A.msst_mspd_no = ms_produk.mspd_no))"
											." +"
											." (SELECT (".$i." * SUM(B.dtsd_qtykrm * B.dtsd_hpp)) FROM dt_sales_dlv B"
												." WHERE B.dtsd_no = '".$trsd_no."'"
												." AND B.dtsd_mspd_no = ms_produk.mspd_no))"
											." /"
											." ((SELECT SUM(C.msst_qty) FROM ms_stok C WHERE C.msst_mspd_no = ms_produk.mspd_no)"
											 ." +"
											 ." (SELECT (".$i." * SUM(D.dtsd_qtykrm)) FROM dt_sales_dlv D"
												." WHERE D.dtsd_no = '".$trsd_no."'"
												." AND D.dtsd_mspd_no= ms_produk.mspd_no)), 4)"
											 
											." WHERE ms_produk.mspd_no IN"
												." (SELECT E.dtsd_mspd_no FROM dt_sales_dlv E"
												." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(E.dtsd_mspd_no,1,1)"
												." WHERE E.dtsd_no = '".$trsd_no."'"
												." AND KT.mskt_statusinv = 'Y')"
											
											." AND ((SELECT SUM(F.msst_qty) FROM ms_stok F WHERE F.msst_mspd_no = ms_produk.mspd_no)"
												." +"
												." (SELECT (".$i." * SUM(G.dtsd_qtykrm)) FROM dt_sales_dlv G"
												." WHERE G.dtsd_no = '".$trsd_no."'"
												." AND G.dtsd_mspd_no= ms_produk.mspd_no)) <> 0";
		}


		if($menu == 'CONFDELIVERY' || $menu == 'CANCEL_CONFDELIVERY'){
				$query = "UPDATE ms_produk SET mspd_hpp =ROUND("
											."((mspd_hpp * (SELECT SUM(A.msst_qty) FROM ms_stok A WHERE A.msst_mspd_no = ms_produk.mspd_no))"
											." +"
											." (SELECT (".$i." * SUM(B.dtsd_qtyrej * B.dtsd_hpp)) FROM dt_sales_dlv B"
												." WHERE B.dtsd_no = '".$trsd_no."'"
												." AND B.dtsd_mspd_no = ms_produk.mspd_no))"
											." /"
											." ((SELECT SUM(C.msst_qty) FROM ms_stok C WHERE C.msst_mspd_no = ms_produk.mspd_no)"
											 ." +"
											 ." (SELECT (".$i." * SUM(D.dtsd_qtyrej)) FROM dt_sales_dlv D"
												." WHERE D.dtsd_no = '".$trsd_no."'"
												." AND D.dtsd_mspd_no= ms_produk.mspd_no)), 4)"
											 
											." WHERE ms_produk.mspd_no IN"
												." (SELECT E.dtsd_mspd_no FROM dt_sales_dlv E"
												." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(E.dtsd_mspd_no,1,1)"
												." WHERE E.dtsd_no = '".$trsd_no."'"
												." AND KT.mskt_statusinv = 'Y'"
												." AND E.dtsd_qtyrej <> 0)"
											
											." AND ((SELECT SUM(F.msst_qty) FROM ms_stok F WHERE F.msst_mspd_no = ms_produk.mspd_no)"
												." +"
												." (SELECT (".$i." * SUM(G.dtsd_qtyrej)) FROM dt_sales_dlv G"
												." WHERE G.dtsd_no = '".$trsd_no."'"
												." AND G.dtsd_mspd_no= ms_produk.mspd_no)) <> 0";
		}

		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
		
	}

	// private function update_dtsd_hpp($trsd_no){		
	// 	$query = "UPDATE dt_sales_dlv"
	// 				." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(dt_sales_dlv.dtsd_mspd_no,1,1)"
	// 				." SET dtsd_hpp ="
	// 				." (SELECT mspd_hpp FROM ms_produk A WHERE A.mspd_no = dt_sales_dlv.dtsd_mspd_no)"
	// 				." WHERE dt_sales_dlv.dtsd_no = '".$trsd_no."'"
	// 				." AND KT.mskt_statusinv = 'Y'"
	// 				." AND dt_sales_dlv.dtsd_qtyrej > 0";

	// 	if($this->db->simple_query($query)){		
	// 		return 1;
	// 	}else{
	// 		return 0;
	// 	}		
	// }

	public function update_stok($menu, $trsd_no, $i){
		$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
						." (SELECT DISTINCT A.dtsd_mspd_no, B.trsd_msgd_no, 0 FROM dt_sales_dlv A"
						." LEFT JOIN tr_sales_dlv B ON B.trsd_no = A.dtsd_no"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtsd_mspd_no, 1,1)"
						." LEFT JOIN ms_produk mspd ON mspd.mspd_no = A.dtsd_mspd_no"
						." WHERE A.dtsd_no = '".$trsd_no."'"
						." AND KT.mskt_statusinv = 'Y'"
						." AND mspd.mspd_paket = 'N'"
						." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
								." WHERE C.msst_mspd_no = A.dtsd_mspd_no"
								." AND C.msst_msgd_no= B.trsd_msgd_no))";

		$this->db->simple_query($query);

		if($menu == 'DELIVERYNOW' || $menu == 'CANCEL_DELIVERYNOW'){
				$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
								." (".$i." * (SELECT SUM(A.dtsd_qtykrm) FROM dt_sales_dlv A"
								." WHERE A.dtsd_no = '".$trsd_no."'"
								." AND A.dtsd_mspd_no = ms_stok.msst_mspd_no))"
						." WHERE ms_stok.msst_mspd_no IN"
								." (SELECT B.dtsd_mspd_no FROM dt_sales_dlv B"
								." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtsd_mspd_no,1,1)"								
								." WHERE B.dtsd_no = '".$trsd_no."'"
								." AND B.dtsd_statuspaket <> 'P'"
								." AND KT.mskt_statusinv = 'Y'"								
								." AND B.dtsd_qtykrm <> 0)"
						." AND ms_stok.msst_msgd_no ="
								." (SELECT C.trsd_msgd_no FROM tr_sales_dlv C"
								." WHERE C.trsd_no = '".$trsd_no."')";
		}
		
		if($menu == 'CONFDELIVERY' || $menu == 'CANCEL_CONFDELIVERY'){
				$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
								." (".$i." * (SELECT SUM(A.dtsd_qtyrej) FROM dt_sales_dlv A"
								." WHERE A.dtsd_no = '".$trsd_no."'"
								." AND A.dtsd_mspd_no = ms_stok.msst_mspd_no))"
							." WHERE ms_stok.msst_mspd_no IN"
								." (SELECT B.dtsd_mspd_no FROM dt_sales_dlv B"
								." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtsd_mspd_no,1,1)"								
								." WHERE B.dtsd_no = '".$trsd_no."'"
								." AND B.dtsd_statuspaket <> 'P'"
								." AND KT.mskt_statusinv = 'Y'"
								." AND B.dtsd_qtyrej <> 0)"
							." AND ms_stok.msst_msgd_no =" 
								." (SELECT C.trsd_msgd_no FROM tr_sales_dlv C"
								." WHERE C.trsd_no = '".$trsd_no."')";
		}
			
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}					
	}

	private function jurnal_simpan($data){		
		if(isset($data['jurnal_d'])){
			// Generate CekInt
			$data['jurnal_h']['trju_cekint'] = rand(0,10000);			
			// Insert data header jurnal
			$this->db->insert('tr_jurnal',$data['jurnal_h']);		

			//Insert data detail jurnal
			if(isset($data['jurnal_d'])){
				$seq = 1;
				foreach ($data['jurnal_d'] as $key => $value) {														
					$data['jurnal_d'][$key]['dtju_no'] = $data['jurnal_h']['trju_no'];
					$data['jurnal_d'][$key]['dtju_seq'] = $seq;
					$this->db->insert('dt_jurnal',$data['jurnal_d'][$key]);
					$seq += 1;
				}		
			}
		}
	}

	private function jurnal_hapus($data){		
		if(isset($data['jurnal_h']['trju_no']) && strlen($data['jurnal_h']['trju_no']) > 0){
			$this->db->delete('tr_jurnal', array('trju_no' => $data['jurnal_h']['trju_no']));
			$this->db->delete('dt_jurnal', array('dtju_no' => $data['jurnal_h']['trju_no']));
		}
	}

	public function get_dtsd_hpp($dtsd_no, $dtsd_seq){
		$query = $this->db->get_where('dt_sales_dlv', array('dtsd_no'=>$dtsd_no, 'dtsd_seq'=>$dtsd_seq));
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['dtsd_hpp'];
		}
	}

	public function get_eksport_csv_efaktur_header($trsd_no){
		// ,round(((trsd_total/110)*100),2) as dpp_total, round(trsd_total/11,2) as ppn_total
		// ,trsd_biayaekspedisi, trsd_tglkirim 		

		$dpp_total += round(($data['dtsd_qtykrm']-$data['dtsd_qtyrej'])*$data['dtsd_bftax']);
		$ppn_total += round((($data['dtsd_qtykrm']-$data['dtsd_qtyrej'])*$data['dtsd_tax']));
		
		
		$query = 'select trsd_no, trsd_catatan, trso_pocust, trso_kurs, trso_alamatnpwp, mscs_nm, mscs_npwp, mscs_almt_jln, mscs_almt_kota, 
					mscs_almt_provinsi, mscs_cp, mscs_telp, trsd_fakturno, trsd_fakturtgl, trso_tophari,
					IFNULL((SELECT SUM(dtsd_bftax * (dtsd_qtykrm - dtsd_qtyrej)) FROM dt_sales_dlv WHERE dtsd_no = trsd_no),0) AS dpp_total,
                    IFNULL((SELECT SUM(dtsd_tax * (dtsd_qtykrm - dtsd_qtyrej)) FROM dt_sales_dlv WHERE dtsd_no = trsd_no),0) AS ppn_total
				  From tr_sales_dlv
				  left join tr_so on trso_no = SUBSTRING(trsd_no,1,12)
				  LEFT JOIN ms_customer on mscs_no = trsd_mscs_no
				  WHERE trsd_no = "'.$trsd_no.'" and trsd_void = 0';

		$result = $this->db->query($query)->result_array();			

		return $result;			
	}

	public function get_eksport_csv_efaktur_details($trsd_no){
		$query = 'select dtsd_no, dtsd_mspd_no, dtso_nett, dtsd_qtykrm, dtsd_qtyrej, mspd_nm, 
						 trsd_no, dtsd_bftax, dtsd_tax
					FROM dt_sales_dlv
					LEFT JOIN tr_sales_dlv on dtsd_no = trsd_no
					LEFT JOIN dt_so ON dtso_no = SUBSTRING(dtsd_no,1,12) AND dtsd_seq = dtso_seq
					LEFT JOIN tr_so on trso_no = SUBSTRING(dtsd_no,1,12)
					LEFT JOIN ms_customer on mscs_no = trsd_mscs_no
					LEFT JOIN ms_produk ON mspd_no = dtso_mspd_no
					LEFT JOIN ms_sales on trso_mssl_no = mssl_no
					WHERE dtsd_no = "'.$trsd_no.'" AND dtsd_statuspaket != "K"
					AND (dtsd_qtykrm-dtsd_qtyrej) > 0
					order BY dtsd_seq ASC';
		$result = $this->db->query($query)->result_array();			

		return $result;			
	}

	public function sd_confirmed($trsd_no){
		$query = $this->db->get_where('tr_sales_dlv', array('trsd_no' => $trsd_no, 'trsd_tglbalik !=' => '0000-00-00'));

		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

}
