<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_inventory extends MY_Model {
	
	public function get_inventory_list($arr_filter, $arr_option_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'mspd_no', $sort = 'DESC'){				
		if($this->db->count_all('ms_produk') > 0){				
				$this->db->select('*');
				$this->db->from('ms_gudang');		
				$this->db->like(array('msgd_listmscb' => $this->session->userdata('user_aktif')['msus_mscb_no'], 'msgd_aktif'=>1));
				$query = $this->db->get();
				$gudang = $query->result_array(); 
				
				if(count($gudang) > 0){
					//query field produk
					$sql = "mspd_no AS mspd_no|Product #, mspd_nm AS mspd_nm|Product Name, mspd_satuan AS mspd_satuan|Unit, msmr_nm AS msmr_nm|Brand, ";
					
					$total = "";
					$total_query_y = "";
					$total_query_n = "";

					if(fcek_hak_akses('.HA6.') && $arr_filter['menu'] == 'INV_REPORT_ADMIN') {
						$sql .= "mspd_pricelist AS mspd_pricelist|Price List, mspd_hpp AS mspd_hpp|HPP, ";
					}

					foreach ($gudang as $key => $value) {
						if($gudang[$key]['msgd_avl'] == 'Y'){
							$gudang_query = " IFNULL((SELECT SUM(msst_qty) FROM ms_stok INNER JOIN ms_gudang ON msgd_no = msst_msgd_no AND msgd_avl = 'Y' WHERE msst_mspd_no = mspd_no AND msst_msgd_no = '". $gudang[$key]['msgd_no'] ."'),0)";

							if($total_query_y != ""){
								$total_query_y .= " + ";
							}

							$total_query_y .= $gudang_query;

							//query field gudang avaliability = "Y"
							$sql .= $gudang_query. " AS '". $gudang[$key]['msgd_no'].'|'.$gudang[$key]['msgd_nm']. "',";
						}

						if($gudang[$key]['msgd_avl'] == 'N'){
							$gudang_query = " IFNULL((SELECT SUM(msst_qty) FROM ms_stok INNER JOIN ms_gudang ON msgd_no = msst_msgd_no AND msgd_avl = 'N' WHERE msst_mspd_no = mspd_no AND msst_msgd_no = '". $gudang[$key]['msgd_no'] ."'),0)";

							if($total_query_n != ""){
								$total_query_n .= " + ";
							}

							$total_query_n .= $gudang_query; 

							//query field gudang avaliability = "N"
							$sql .= $gudang_query. " AS 'avaliabilityno|". $gudang[$key]['msgd_no']. "#". $gudang[$key]['msgd_nm']. "',";		
						}	
					}

					if($total_query_y == ''){
						$total_query_y = 0;
					}

					if($total_query_n == ''){
						$total_query_n = 0;
					}

					$total .= $total_query_y. " + ". $total_query_n. " AS 'total|Total Stock',";
					
					//query field total					
					$sql .= $total;					

					$so_dekat_locky = " IFNULL((SELECT SUM(dtso_qtysd - dtso_qtykirim) FROM dt_so LEFT JOIN tr_so ON trso_no = dtso_no WHERE trso_void = 0 AND trso_lock='Y' AND trso_mscb_no LIKE '%". $this->session->userdata('user_aktif')['msus_mscb_no'] ."%' AND DATEDIFF(trso_tglestkirim,'". date('Y-m-d') ."') <= 120 AND dtso_mspd_no = mspd_no),0)";
					$so_dekat_lockn = " IFNULL((SELECT SUM(dtso_qty - dtso_qtykirim) FROM dt_so LEFT JOIN tr_so ON trso_no = dtso_no WHERE trso_void = 0 AND trso_lock='N' AND trso_mscb_no LIKE '%". $this->session->userdata('user_aktif')['msus_mscb_no'] ."%' AND DATEDIFF(trso_tglestkirim,'". date('Y-m-d') ."') <= 120 AND dtso_mspd_no = mspd_no),0)";
					$so_dekat_query = $so_dekat_lockn. '+'. $so_dekat_locky;

					$so_jauh_locky = " IFNULL((SELECT SUM(dtso_qtysd - dtso_qtykirim) FROM dt_so LEFT JOIN tr_so ON trso_no = dtso_no WHERE trso_void = 0 AND trso_lock='Y' AND trso_mscb_no LIKE '%". $this->session->userdata('user_aktif')['msus_mscb_no'] ."%' AND DATEDIFF(trso_tglestkirim,'". date('Y-m-d') ."') > 120 AND dtso_mspd_no = mspd_no),0)";
					$so_jauh_lockn = " IFNULL((SELECT SUM(dtso_qty - dtso_qtykirim) FROM dt_so LEFT JOIN tr_so ON trso_no = dtso_no WHERE trso_void = 0 AND trso_lock='N' AND trso_mscb_no LIKE '%". $this->session->userdata('user_aktif')['msus_mscb_no'] ."%' AND DATEDIFF(trso_tglestkirim,'". date('Y-m-d') ."') > 120 AND dtso_mspd_no = mspd_no),0)";
					$so_jauh_query = $so_jauh_lockn. '+'. $so_jauh_locky;

					$wip_po_locky = " IFNULL((SELECT SUM(dtpo_qtyid - dtpo_qtyterima) FROM dt_po LEFT JOIN tr_po ON tr_po.trpo_no=dt_po.dtpo_no WHERE trpo_void = 0 AND trpo_lock='Y' AND trpo_mscb_no LIKE '%".$this->session->userdata('user_aktif')['msus_mscb_no']."%' AND dtpo_mspd_no = mspd_no),0) ";
					$wip_po_lockn = " IFNULL((SELECT SUM(dtpo_qty - dtpo_qtyterima) FROM dt_po LEFT JOIN tr_po ON tr_po.trpo_no=dt_po.dtpo_no WHERE trpo_void = 0 AND trpo_lock='N' AND trpo_mscb_no LIKE '%".$this->session->userdata('user_aktif')['msus_mscb_no']."%' AND dtpo_mspd_no = mspd_no),0) ";
					$wip_po_query = $wip_po_lockn. '+'. $wip_po_locky;

					//query field WIP PO
					$sql .= $wip_po_query. "AS 'wip_po|WIP PO', ";					

					//query field so dekat dan so jauh
					$sql .= $so_dekat_query. " AS 'so_dekat|SO Dekat',";
					$sql .= $so_jauh_query. " AS 'so_jauh|SO Jauh',";
					
					$mutasi_out_query = " IFNULL((SELECT SUM(dtmt_qtyout - dtmt_qtyin)"
										 ." FROM dt_mutasi"
										 ." LEFT JOIN tr_mutasi ON trmt_no = dtmt_no"
										 ." LEFT JOIN ms_gudang ON msgd_no = trmt_msgd_no1"
										 ." WHERE trmt_void = 0"
										 ." AND trmt_tglkirim = '0000-00-00'"
										 ." AND dtmt_mspd_no = mspd_no"
										 ." AND dtmt_stapv = 'N'" 
										 ." AND msgd_listmscb LIKE '%".$this->session->userdata('user_aktif')['msus_mscb_no']."%'), 0) ";	

					$mutasi_in_query = " IFNULL((SELECT SUM(dtmt_qtyout - dtmt_qtyin)"
										 ." FROM dt_mutasi"
										 ." LEFT JOIN tr_mutasi ON trmt_no = dtmt_no"
										 ." LEFT JOIN ms_gudang ON msgd_no = trmt_msgd_no2"
										 ." WHERE trmt_void = 0"
										 ." AND trmt_tglkirim != '0000-00-00'"
										 ." AND dtmt_mspd_no = mspd_no"
										 ." AND dtmt_stapv = 'N'" 
										 ." AND msgd_listmscb LIKE '%".$this->session->userdata('user_aktif')['msus_mscb_no']."%'), 0) ";
					
					//query field mutasi out dan mutasi in
					$sql .= $mutasi_out_query. " As 'mutasi_out|Mutasi Out',";
					$sql .= $mutasi_in_query. " As 'mutasi_in|Mutasi In',";

					//query field icoming stok
					$incoming_stock_query = $wip_po_query. " + ". $mutasi_in_query;
					$sql .= $incoming_stock_query." AS 'incoming_stock|Incoming Stock',";

					//query field avaliable stock
					$avaliable_stock_query = $total_query_y. " - (". $so_dekat_query. " + ". $mutasi_out_query. ") ";
					$sql .= $avaliable_stock_query." AS 'avaliable_stock|Avaliable Stock', ";					
					
					$this->db->select($sql);
					$this->db->from('ms_produk');
					$this->db->join('ms_merk', 'msmr_no = mspd_msmr_no', 'left');
					$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_produk.mspd_no,1,1)','left');
					$this->db->join('ms_model', 'msmd_no = Substring(ms_produk.mspd_no,1,6)', 'LEFT');
					$this->db->join('ms_famili', 'msfm_no = substring(ms_produk.mspd_no,1,3)', 'LEFT' );
					$this->db->where(array('mspd_no !=' => '', 'mskt_statusinv' => 'Y', 'mspd_paket' => 'N'));							
					$this->db->like('mspd_listmscb', $this->session->userdata('user_aktif')['msus_mscb_no']);	
					
					$filter_stok = array();		
					if(count($arr_option_filter) > 0){												
						foreach ($arr_option_filter as $key => $value) {
							if($key == 'total'){												 			
								if($value != 'all'){
									$vtotal_query = $total_query_y. $value;	
									$filter_stok[$vtotal_query] = 0;
								}
							}else if ($key == 'wip_po') {
								if($value != 'all'){
								  	$vquery_wip = $wip_po_query. $value;
									$filter_stok[$vquery_wip] = 0;												
								}
							}else if ($key == 'so_dekat') {
								if($value != 'all'){
								  	$vquery_sodekat = $so_dekat_query. $value;
									$filter_stok[$vquery_sodekat] = 0;												
								}
							}else if ($key == 'so_jauh'){
								if($value != 'all'){
									$vquery_sojauh = $so_jauh_query. $value;
									$filter_stok[$vquery_sojauh] = 0;
								}
							}elseif ($key == 'mutasi_out') {
								if($value != 'all'){
									$vmutasi_out_query = $mutasi_out_query. $value;
									$filter_stok[$vmutasi_out_query] = 0;
								}
							}elseif ($key == 'mutasi_in') {
								if($value != 'all'){
									$vmutasi_in_query = $mutasi_in_query. $value;
									$filter_stok[$vmutasi_in_query] = 0;
								}
							}elseif ($key == 'incoming_stock') {
								if($value != 'all'){
									$vincoming_stock_query = $incoming_stock_query. $value;
									$filter_stok[$vincoming_stock_query] = 0;
								}
							}elseif($key == 'avaliable_stock'){								
								if($value != 'all'){
									$vavaliable_stock_query = $avaliable_stock_query. $value;
									$filter_stok[$vavaliable_stock_query] = 0;
								}
							}else{
								if($value != 'all'){
									$query_string = "IFNULL((SELECT SUM(msst_qty) FROM ms_stok WHERE msst_mspd_no = mspd_no AND msst_msgd_no = '". $key ."'),0) ". $value;
									$filter_stok[$query_string] = 0;
								}
							}
						}												
					}	

					//isi array $filter_stok jadi: array('$variable (operator, contoh: >)' => 0)

					if(count($filter_stok) != 0){												
						$this->db->where($filter_stok);
					}							
					
					$nlimit = $arr_filter['nlimit'];
					
					if(count($arr_filter) != 0){			
						unset($arr_filter['nlimit']);
						unset($arr_filter['menu']);
						$this->db->like($arr_filter);			
					}		

					$this->db->order_by($fn, $sort);							

					if($nlimit > 0){
						$this->db->limit($nlimit);
					}else{			
						if(!$is_count){
							$this->db->limit($per_page, $offset);		
						}
					}

					$query = $this->db->get();										
					if(!$is_count){
						return $query->result_array();
					}else{
						return $query->num_rows();
					}
				}else{
					return array();
				}	
		}else{
			return array();
		}	
	}

	public function get_inventory_list_report($arr_filter){				
		if($this->db->count_all('ms_produk') > 0){				
				$this->db->select('*');
				$this->db->from('ms_gudang');		
				$this->db->like(array('msgd_listmscb' => $this->session->userdata('user_aktif')['msus_mscb_no'], 'msgd_aktif'=>1));
				$query = $this->db->get();
				$gudang = $query->result_array(); 
				
				if(count($gudang) > 0){
					//query field produk
					$sql = "mspd_no AS mspd_no|Product #, mspd_nm AS mspd_nm|Product Name, mspd_satuan AS mspd_satuan|Unit, msmr_nm AS msmr_nm|Brand, ";
					
					$total = "";
					$total_query_y = "";
					$total_query_n = "";

					if(fcek_hak_akses('.HA6.') && $arr_filter['menu'] == 'INV_REPORT_ADMIN') {
						$sql .= "mspd_pricelist AS mspd_pricelist|Price List, mspd_hpp AS mspd_hpp|HPP, ";
					}

					foreach ($gudang as $key => $value) {
						if($gudang[$key]['msgd_avl'] == 'Y'){
							$gudang_query = " IFNULL((SELECT SUM(msst_qty) FROM ms_stok INNER JOIN ms_gudang ON msgd_no = msst_msgd_no AND msgd_avl = 'Y' WHERE msst_mspd_no = mspd_no AND msst_msgd_no = '". $gudang[$key]['msgd_no'] ."'),0)";

							if($total_query_y != ""){
								$total_query_y .= " + ";
							}

							$total_query_y .= $gudang_query;

							//query field gudang avaliability = "Y"
							$sql .= $gudang_query. " AS '". $gudang[$key]['msgd_no'].'|'.$gudang[$key]['msgd_nm']. "',";
						}

						if($gudang[$key]['msgd_avl'] == 'N'){
							$gudang_query = " IFNULL((SELECT SUM(msst_qty) FROM ms_stok INNER JOIN ms_gudang ON msgd_no = msst_msgd_no AND msgd_avl = 'N' WHERE msst_mspd_no = mspd_no AND msst_msgd_no = '". $gudang[$key]['msgd_no'] ."'),0)";

							if($total_query_n != ""){
								$total_query_n .= " + ";
							}

							$total_query_n .= $gudang_query; 

							//query field gudang avaliability = "N"
							$sql .= $gudang_query. " AS 'avaliabilityno|". $gudang[$key]['msgd_no']. "#". $gudang[$key]['msgd_nm']. "',";		
						}	
					}

					if($total_query_y == ''){
						$total_query_y = 0;
					}

					if($total_query_n == ''){
						$total_query_n = 0;
					}

					$total .= $total_query_y. " + ". $total_query_n. " AS 'total|Total Stock',";
					
					//query field total					
					$sql .= $total;					
					
					$this->db->select($sql);
					$this->db->from('ms_produk');
					$this->db->join('ms_merk', 'msmr_no = mspd_msmr_no', 'left');
					$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_produk.mspd_no,1,1)','left');
					$this->db->join('ms_model', 'msmd_no = Substring(ms_produk.mspd_no,1,6)', 'LEFT');
					$this->db->join('ms_famili', 'msfm_no = substring(ms_produk.mspd_no,1,3)', 'LEFT' );
					$this->db->where(array('mspd_no !=' => '', 'mskt_statusinv' => 'Y', 'mspd_paket' => 'N'));							
					$this->db->like('mspd_listmscb', $this->session->userdata('user_aktif')['msus_mscb_no']);	
												
					if(count($arr_filter) != 0){
						unset($arr_filter['menu']);
						$this->db->like($arr_filter);			
					}		


					$query = $this->db->get();										
					return $query->result_array();
				}else{
					return array();
				}	
		}else{
			return array();
		}	
	}

	public function get_needtoorderitem_list($arr_filter, $arr_option_filter, $is_count = false, $per_page = 5, $offset = 0, $fn = 'mspd_no', $sort = 'DESC'){				
		if($this->db->count_all('ms_produk') > 0){				
				$this->db->select('*');
				$this->db->from('ms_gudang');		
				$this->db->like(array('msgd_aktif'=>1));
				$query = $this->db->get();
				$gudang = $query->result_array(); 
			
				if(count($gudang) > 0){
					//query field produk
					$sql = "mspd_no AS mspd_no|Product #, mspd_nm AS mspd_nm|Product Name, mspd_satuan AS mspd_satuan|Unit, msmr_nm AS msmr_nm|Brand, ";
					
					$total = "";
					$total_query_y = "";
					$total_query_n = "";

					foreach ($gudang as $key => $value) {
						if($gudang[$key]['msgd_avl'] == 'Y'){
							$gudang_query = " IFNULL((SELECT SUM(msst_qty) FROM ms_stok INNER JOIN ms_gudang ON msgd_no = msst_msgd_no AND msgd_avl = 'Y' WHERE msst_mspd_no = mspd_no AND msst_msgd_no = '". $gudang[$key]['msgd_no'] ."'),0)";

							if($total_query_y != ""){
								$total_query_y .= " + ";
							}

							$total_query_y .= $gudang_query;

							//query field gudang avaliability = "Y"
							$sql .= $gudang_query. " AS '". $gudang[$key]['msgd_no'].'|'.$gudang[$key]['msgd_nm']. "',";
						}

						if($gudang[$key]['msgd_avl'] == 'N'){
							$gudang_query = " IFNULL((SELECT SUM(msst_qty) FROM ms_stok INNER JOIN ms_gudang ON msgd_no = msst_msgd_no AND msgd_avl = 'N' WHERE msst_mspd_no = mspd_no AND msst_msgd_no = '". $gudang[$key]['msgd_no'] ."'),0)";

							if($total_query_n != ""){
								$total_query_n .= " + ";
							}

							$total_query_n .= $gudang_query; 

							//query field gudang avaliability = "N"
							$sql .= $gudang_query. " AS 'avaliabilityno|". $gudang[$key]['msgd_no']. "#". $gudang[$key]['msgd_nm']. "',";		
						}	
					}

					if($total_query_y == ''){
						$total_query_y = 0;
					}

					if($total_query_n == ''){
						$total_query_n = 0;
					}

					$total .= $total_query_y. " + ". $total_query_n. " AS 'total|Total Stock',";
					
					//query field total					
					$sql .= $total;					

					$so_dekat_locky = " IFNULL((SELECT SUM(dtso_qtysd - dtso_qtykirim) FROM dt_so LEFT JOIN tr_so ON trso_no = dtso_no WHERE trso_void = 0 AND trso_lock='Y' AND DATEDIFF(trso_tglestkirim,'". date('Y-m-d') ."') <= 120 AND dtso_mspd_no = mspd_no),0)";
					$so_dekat_lockn = " IFNULL((SELECT SUM(dtso_qty - dtso_qtykirim) FROM dt_so LEFT JOIN tr_so ON trso_no = dtso_no WHERE trso_void = 0 AND trso_lock='N' AND DATEDIFF(trso_tglestkirim,'". date('Y-m-d') ."') <= 120 AND dtso_mspd_no = mspd_no),0)";
					$so_dekat_query = $so_dekat_lockn. ' + '. $so_dekat_locky;

					$so_jauh_locky = " IFNULL((SELECT SUM(dtso_qtysd - dtso_qtykirim) FROM dt_so LEFT JOIN tr_so ON trso_no = dtso_no WHERE trso_void = 0 AND trso_lock='Y' AND DATEDIFF(trso_tglestkirim,'". date('Y-m-d') ."') > 120 AND dtso_mspd_no = mspd_no),0)";
					$so_jauh_lockn = " IFNULL((SELECT SUM(dtso_qty - dtso_qtykirim) FROM dt_so LEFT JOIN tr_so ON trso_no = dtso_no WHERE trso_void = 0 AND trso_lock='N' AND DATEDIFF(trso_tglestkirim,'". date('Y-m-d') ."') > 120 AND dtso_mspd_no = mspd_no),0)";
					$so_jauh_query = $so_jauh_lockn. ' + '. $so_jauh_locky;

					// $wip_po_locky = " IFNULL((SELECT SUM(dtpo_qtyid - dtpo_qtyterima) FROM dt_po LEFT JOIN tr_po ON tr_po.trpo_no=dt_po.dtpo_no WHERE trpo_void = 0 AND trpo_lock='Y' AND dtpo_mspd_no = mspd_no),0) ";
					// $wip_po_lockn = " IFNULL((SELECT SUM(dtpo_qty - dtpo_qtyterima) FROM dt_po LEFT JOIN tr_po ON tr_po.trpo_no=dt_po.dtpo_no WHERE trpo_void = 0 AND trpo_lock='N' AND dtpo_mspd_no = mspd_no),0) ";
					// $wip_po_query = $wip_po_lockn. ' + '. $wip_po_locky;

					$wip_po_query = " IFNULL((SELECT SUM(DAPV.dappr_qtyapv - IFNULL(DPO.dtpo_qtyterima, 0))
											FROM dt_apv_purcreq DAPV
											LEFT JOIN apv_purcreq APV
											ON APV.appr_no = DAPV.dappr_no
											LEFT JOIN tr_po PO ON PO.trpo_no = DAPV.dappr_trpo_no
											LEFT JOIN dt_po DPO ON DPO.dtpo_no = DAPV.dappr_trpo_no AND DPO.dtpo_dappr_no = DAPV.dappr_no AND DPO.dtpo_dappr_seq = DAPV.dappr_seq
											WHERE IFNULL(PO.trpo_lock, '') <> 'Y'
											AND IFNULL(PO.trpo_void, '') = 0
											AND DAPV.dappr_mspd_no = mspd_no
											AND APV.appr_void = 0											
											GROUP BY DAPV.dappr_mspd_no), 
									0) ";

					//query field WIP PO
					$sql .= $wip_po_query. "AS 'wip_po|WIP PO', ";					

					//query field so dekat dan so jauh
					$sql .= $so_dekat_query. " AS 'so_dekat|SO Dekat',";
					$sql .= $so_jauh_query. " AS 'so_jauh|SO Jauh',";
					
					$mutasi_out_query = " IFNULL((SELECT SUM(dtmt_qtyout - dtmt_qtyin)"
										 ." FROM dt_mutasi"
										 ." LEFT JOIN tr_mutasi ON trmt_no = dtmt_no"
										 ." LEFT JOIN ms_gudang ON msgd_no = trmt_msgd_no1"
										 ." WHERE trmt_void = 0"
										 ." AND trmt_tglkirim = '0000-00-00'"
										 ." AND dtmt_mspd_no = mspd_no"
										 ." AND dtmt_stapv = 'N'), 0) "; 										 

					$mutasi_in_query = " IFNULL((SELECT SUM(dtmt_qtyout - dtmt_qtyin)"
										 ." FROM dt_mutasi"
										 ." LEFT JOIN tr_mutasi ON trmt_no = dtmt_no"
										 ." LEFT JOIN ms_gudang ON msgd_no = trmt_msgd_no2"
										 ." WHERE trmt_void = 0"
										 ." AND trmt_tglkirim != '0000-00-00'"
										 ." AND dtmt_mspd_no = mspd_no"
										 ." AND dtmt_stapv = 'N'), 0) "; 										 
					
					//query field mutasi out dan mutasi in
					$sql .= $mutasi_out_query. " As 'mutasi_out|Mutasi Out',";
					$sql .= $mutasi_in_query. " As 'mutasi_in|Mutasi In',";

					//query field icoming stok
					$incoming_stock_query = $wip_po_query. " + ". $mutasi_in_query;
					$sql .= $incoming_stock_query." AS 'incoming_stock|Incoming Stock',";

					//query field avaliable stock
					$avaliable_stock_query = $total_query_y. " - (". $so_dekat_query. " + ". $mutasi_out_query. ") ";
					$sql .= $avaliable_stock_query." AS 'avaliable_stock|Avaliable Stock', ";					

					$sql .= "mspd_rop AS 'mspd_rop|ROP'";									
					
					if(!$is_count){
						$this->db->limit($per_page, $offset);
					}	
					
					$this->db->select($sql);
					$this->db->from('ms_produk');
					$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_produk.mspd_no,1,1)','left');
					$this->db->join('ms_famili', 'ms_famili.msfm_no = SUBSTRING(ms_produk.mspd_no,1,3)','left');
					$this->db->join('ms_model', 'ms_model.msmd_no = SUBSTRING(ms_produk.mspd_no,1,6)','left');
					$this->db->join('ms_supplier', 'ms_supplier.mssp_no = ms_produk.mspd_mssp_no','left');
					$this->db->join('ms_merk', 'ms_merk.msmr_no = ms_produk.mspd_msmr_no', 'left');
					$this->db->where(array('mspd_no !=' => '', 'mskt_statusinv' => 'Y', 'mspd_aktif'=>1));							
					
					$filter_stok = array();		
					if(count($arr_option_filter) > 0){												
						foreach ($arr_option_filter as $key => $value) {
							if($key == 'total'){												 			
								if($value != 'all'){
									$vtotal_query = $total_query_y. $value;	
									$filter_stok[$vtotal_query] = 0;
								}
							}else if ($key == 'wip_po') {
								if($value != 'all'){
								  	$vquery_wip = $wip_po_query. $value;
									$filter_stok[$vquery_wip] = 0;												
								}
							}else if ($key == 'so_dekat') {
								if($value != 'all'){
								  	$vquery_sodekat = $so_dekat_query. $value;
									$filter_stok[$vquery_sodekat] = 0;												
								}
							}else if ($key == 'so_jauh'){
								if($value != 'all'){
									$vquery_sojauh = $so_jauh_query. $value;
									$filter_stok[$vquery_sojauh] = 0;
								}
							}elseif ($key == 'mutasi_out') {
								if($value != 'all'){
									$vmutasi_out_query = $mutasi_out_query. $value;
									$filter_stok[$vmutasi_out_query] = 0;
								}
							}elseif ($key == 'mutasi_in') {
								if($value != 'all'){
									$vmutasi_in_query = $mutasi_in_query. $value;
									$filter_stok[$vmutasi_in_query] = 0;
								}
							}elseif ($key == 'incoming_stock') {
								if($value != 'all'){
									$vincoming_stock_query = $incoming_stock_query. $value;
									$filter_stok[$vincoming_stock_query] = 0;
								}
							}elseif($key == 'avaliable_stock'){
								if($value != 'all'){
									$vavaliable_stock_query = $avaliable_stock_query. $value;
									$filter_stok[$vavaliable_stock_query] = 0;
								}
							}else{
								if($value != 'all'){
									$query_string = "IFNULL((SELECT SUM(msst_qty) FROM ms_stok WHERE msst_mspd_no = mspd_no AND msst_msgd_no = '". $key ."'),0) ". $value;
									$filter_stok[$query_string] = 0;
								}
							}
						}												
					}						

					if(count($filter_stok) != 0){												
						$this->db->where($filter_stok);
					}
					
					
					if(count($arr_filter) != 0){									
						$this->db->like($arr_filter);
					}						

					// query need to order item
					$inv_needtoorderitem = '('.$incoming_stock_query.' + '.$avaliable_stock_query.') < mspd_rop';
					$this->db->where($inv_needtoorderitem, null, false);

					$this->db->order_by($fn, $sort);
					$query = $this->db->get();
					if(!$is_count){
						return $query->result_array();
					}else{
						return $query->num_rows();
					}
				}else{
					return array();
				}	
		}else{
			return array();
		}	
	}	

}	