<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_goods_convertion extends MY_Model {

	function __construct(){
		parent::__construct();				
		$this->load->model('setting/m_user_log');
	}

	public function get_goods_convertion_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trcv_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_cvtgoods.*, msgd_nm, msus_nm, mscb_nm');
		$this->db->join('ms_gudang','ms_gudang.msgd_no = tr_cvtgoods.trcv_msgd_no', 'left');
		$this->db->join('ms_user','ms_user.msus_no = tr_cvtgoods.trcv_msus_no', 'left');
		$this->db->join('ms_cabang','ms_cabang.mscb_no = tr_cvtgoods.trcv_mscb_no', 'left');		
		$this->db->from('tr_cvtgoods');		

		$query_string = '';

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_cvtgoods x1 WHERE x1.dtcv_no = trcv_no AND x1.dtcv_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';							
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_cvtgoods x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtcv_mspd_no WHERE x2.dtcv_no = trcv_no AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}		

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}
		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_goods_convertion($trcv_no){		
		$data = array();

		//Get goods_convertion header berdasarkan trcv_no	
		$this->db->select('tr_cvtgoods.*, msus_no, msus_nm, mscb_no, mscb_nm');
		$this->db->from('tr_cvtgoods');		
		$this->db->join('ms_user','msus_no = trcv_msus_no', 'left');
		$this->db->join('ms_cabang','mscb_no = trcv_mscb_no', 'left');				
		$this->db->where('trcv_no',$trcv_no);
		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();
			$data['header'] = $result[0];
		}
		
		//Get goods convertion produk detail berdasarkan trcv_no
		$this->db->select('dt_cvtgoods.*, mspd_nm, mskt_msap_no_inv');
		$this->db->from('dt_cvtgoods');
		$this->db->join('ms_produk', 'mspd_no = dtcv_mspd_no','left');
		$this->db->join('ms_kategori', 'mskt_no = SUBSTRING(dtcv_mspd_no,1,1)','left');
		$this->db->where('dtcv_no',$trcv_no);
		$this->db->order_by('dtcv_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail_prod'] = $detail;
		}

		//Get goods convertion account detail berdasarkan trcv_no
		$this->db->select('dt_cvtgoods_accper.*, msap_nm');
		$this->db->from('dt_cvtgoods_accper');
		$this->db->join('ms_accper', 'msap_no = dtcvap_msap_no','left');
		$this->db->where('dtcvap_no',$trcv_no);
		$this->db->order_by('dtcvap_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail_acc'] = $detail;
		}

		if(count($data) > 0){
			return $data;
		}else{
			return false;
		}
	}

	public function goods_convertion_kode_auto($trcv_kode_depan){
		$this->db->select_max("trcv_no");
		$this->db->like("trcv_no", $trcv_kode_depan, "after");
		$query = $this->db->get("tr_cvtgoods");
		if ($query->num_rows() == 0){
			return $trcv_kode_depan. "0001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trcv_no'];
			$nomor = ((int) substr($kode, 8)) + 1;
			return $trcv_kode_depan. sprintf("%'.04d", $nomor);
		}
	}

	public function get_goods_convertion_cekint($trcv_no, $trcv_cekint){		
		$query = $this->db->get_where('tr_cvtgoods', array('trcv_no' => $trcv_no, 'trcv_cekint' => $trcv_cekint));				 
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_goods_convertion_cekint($trcv_no){				
		$this->db->where('trcv_no', $trcv_no);
		$this->db->update('tr_cvtgoods', array('trcv_cekint' => rand(0,10000)));
	}
	
	public function goods_convertion_simpan($data){
		try {
				if($data['action'] == 'NEW'){
					// Simpan Data
					$this->insert_data($data);	

					// Update hpp produk from
					$this->save_update_hpp_from($data['header']['trcv_no'], -1, 'CFN');
					// Update Stok
					$this->save_update_stok_from($data['header']['trcv_no'], -1);
					// Update hpp produk result
					$this->save_update_hpp_result($data['header']['trcv_no'], 1, 'CRN');
					// Update Stok
					$this->save_update_stok_result($data['header']['trcv_no'], 1);
					
					// Create jurnal
					$this->jurnal_simpan($data);
				}

				if($data['action'] == 'EDIT'){

					// Update hpp produk result
					$this->save_update_hpp_result($data['header']['trcv_no'], -1, 'CF1');
					// Update Stok
					$this->save_update_stok_result($data['header']['trcv_no'], -1);
					// Update hpp produk from
					$this->save_update_hpp_from($data['header']['trcv_no'], 1, 'CR1');
					// Update Stok
					$this->save_update_stok_from($data['header']['trcv_no'], 1);

					// Update Data
					$this->update_data($data);

					// Update hpp produk from
					$this->save_update_hpp_from($data['header']['trcv_no'], -1, 'CF2');
					// Update Stok
					$this->save_update_stok_from($data['header']['trcv_no'], -1);
					// Update hpp produk result
					$this->save_update_hpp_result($data['header']['trcv_no'], 1, 'CR2');
					// Update Stok
					$this->save_update_stok_result($data['header']['trcv_no'], 1);
				
					// Create jurnal
					$this->jurnal_simpan($data);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);			
				}

				if($data['action'] == 'VOID'){
					// Update hpp produk result
					$this->save_update_hpp_result($data['header']['trcv_no'], -1, 'CRV');
					// Update Stok
					$this->save_update_stok_result($data['header']['trcv_no'], -1);
					// Update hpp produk from
					$this->save_update_hpp_from($data['header']['trcv_no'], 1, 'CFV');
					// Update Stok
					$this->save_update_stok_from($data['header']['trcv_no'], 1);

										
					// Update Data
					$this->void_data($data);	
					// Hapus jurnal
					$this->jurnal_hapus($data);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);						
				}
								
			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	private function void_data($data){
		$this->db->where('trcv_no', $data['header']['trcv_no']);
		$this->db->update('tr_cvtgoods', array('trcv_void'=>1));
	}

	private function insert_data($data){
		// Generate CekInt
		$data['header']['trcv_cekint'] = rand(0,10000);			

		//Insert data header goods convertion
		$this->db->insert('tr_cvtgoods',$data['header']);
	
		//Insert data detail produk goods convertion
		if(isset($data['detail_prod'])){
			$seq = 1;
			foreach ($data['detail_prod'] as $key => $value) {
				$data['detail_prod'][$key]['dtcv_seq'] = $seq;					
			    $this->db->insert('dt_cvtgoods', $data['detail_prod'][$key]);											
				$seq += 1;
			}									
		}			

		//Insert data detail account goods convertion
		if(isset($data['detail_acc'])){
			$seq = 1;
			foreach ($data['detail_acc'] as $key => $value) {
				$data['detail_acc'][$key]['dtcvap_seq'] = $seq;					
			   	$this->db->insert('dt_cvtgoods_accper',$data['detail_acc'][$key]);	
			   	$seq += 1;
			}
		}	
	}

	private function update_data($data){
		// Generate CekInt
		$data['header']['trcv_cekint'] = rand(0,10000);			

		// Update data header goods convertion
		$this->db->where('trcv_no', $data['header']['trcv_no']);
		$this->db->update('tr_cvtgoods', $data['header']);
	
		// Delete data dt_cvtgoods lama
		$this->db->delete('dt_cvtgoods', array('dtcv_no' => $data['header']['trcv_no']));

		//Insert data detail produk goods convertion
		if(isset($data['detail_prod'])){
			$seq = 1;
			foreach ($data['detail_prod'] as $key => $value) {
				$data['detail_prod'][$key]['dtcv_seq'] = $seq;					
			    $this->db->insert('dt_cvtgoods', $data['detail_prod'][$key]);											
				$seq += 1;
			}									
		}

		// Delete data dt_cvtgoods_accper lama
		$this->db->delete('dt_cvtgoods_accper', array('dtcvap_no' => $data['header']['trcv_no']));			

		//Insert data detail account goods convertion
		if(isset($data['detail_acc'])){
			$seq = 1;
			foreach ($data['detail_acc'] as $key => $value) {
				$data['detail_acc'][$key]['dtcvap_seq'] = $seq;					
			   	$this->db->insert('dt_cvtgoods_accper',$data['detail_acc'][$key]);	
			   	$seq += 1;
			}
		}	
	}

	private function save_update_hpp_from($trcv_no, $i, $trhpp_refjenis){
		$trhpp_tgl = date('Y-m-d H:i:s');

		$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
							(SELECT '".$trhpp_tgl."',
									'".$trhpp_refjenis."',
									'".$trcv_no."',
									D.dtcv_mspd_no, 
									(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtcv_mspd_no),
									 P.mspd_hpp,
									 SUM(".$i." * D.dtcv_qty),
									ROUND(SUM((".$i." * D.dtcv_qty) * D.dtcv_hpp), 4)
							FROM dt_cvtgoods D 
							LEFT JOIN ms_produk P 
							ON P.mspd_no = D.dtcv_mspd_no 
							LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtcv_mspd_no,1,1)
							WHERE D.dtcv_no = '".$trcv_no."'
							AND D.dtcv_qty <> 0
							AND KT.mskt_statusinv = 'Y'
							AND D.dtcv_jenis = 'F'
							GROUP BY D.dtcv_mspd_no, D.dtcv_hpp)";

		$this->db->simple_query($query);

		$query = "UPDATE tr_his_hpp 
					SET trhpp_totalawal = ROUND((trhpp_qtyawal * trhpp_hppawal), 4),
						trhpp_hppakhir = IF(
							(trhpp_qtyawal + (trhpp_qtytrans)) <> 0,
							ROUND(
								((trhpp_qtyawal * trhpp_hppawal) + (trhpp_totaltrans))
								 /
								 (trhpp_qtyawal + (trhpp_qtytrans)), 4), trhpp_hppawal)
					WHERE trhpp_tgl = '".$trhpp_tgl."'
					AND trhpp_refjenis = '".$trhpp_refjenis."'
					AND trhpp_refno = '".$trcv_no."'";

		$this->db->simple_query($query);

		$query = "UPDATE ms_produk P 
							SET P.mspd_hpp = IFNULL((SELECT trhpp_hppakhir FROM tr_his_hpp 
										WHERE trhpp_tgl = '".$trhpp_tgl."'
										AND trhpp_refjenis = '".$trhpp_refjenis."'
										AND trhpp_refno = '".$trcv_no."'
										AND trhpp_mspd_no = P.mspd_no), P.mspd_hpp)
				WHERE P.mspd_no IN
				(SELECT dtcv_mspd_no FROM dt_cvtgoods D
				LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtcv_mspd_no,1,1)
				WHERE D.dtcv_no = '".$trcv_no."'
				AND D.dtcv_qty <> 0
				AND KT.mskt_statusinv = 'Y'
				AND D.dtcv_jenis = 'F')";

		$this->db->simple_query($query);
	}

	private function save_update_hpp_result($trcv_no, $i, $trhpp_refjenis){
		$trhpp_tgl = date('Y-m-d H:i:s');

		$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
							(SELECT '".$trhpp_tgl."',
									'".$trhpp_refjenis."',
									'".$trcv_no."',
									D.dtcv_mspd_no, 
									(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtcv_mspd_no),
									 P.mspd_hpp,
									 SUM(".$i." * D.dtcv_qty),
									ROUND(SUM((".$i." * D.dtcv_qty) * D.dtcv_hpp), 4)
							FROM dt_cvtgoods D 
							LEFT JOIN ms_produk P 
							ON P.mspd_no = D.dtcv_mspd_no 
							LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtcv_mspd_no,1,1)
							WHERE D.dtcv_no = '".$trcv_no."'
							AND D.dtcv_qty <> 0
							AND KT.mskt_statusinv = 'Y'
							AND D.dtcv_jenis = 'R'
							GROUP BY D.dtcv_mspd_no, D.dtcv_hpp)";

		$this->db->simple_query($query);

		$query = "UPDATE tr_his_hpp 
					SET trhpp_totalawal = ROUND((trhpp_qtyawal * trhpp_hppawal), 4),
						trhpp_hppakhir = IF(
							(trhpp_qtyawal + (trhpp_qtytrans)) <> 0,
							ROUND(
								((trhpp_qtyawal * trhpp_hppawal) + (trhpp_totaltrans))
								 /
								 (trhpp_qtyawal + (trhpp_qtytrans)), 4), trhpp_hppawal)
					WHERE trhpp_tgl = '".$trhpp_tgl."'
					AND trhpp_refjenis = '".$trhpp_refjenis."'
					AND trhpp_refno = '".$trcv_no."'";

		$this->db->simple_query($query);

		$query = "UPDATE ms_produk P 
							SET P.mspd_hpp = IFNULL((SELECT trhpp_hppakhir FROM tr_his_hpp 
										WHERE trhpp_tgl = '".$trhpp_tgl."'
										AND trhpp_refjenis = '".$trhpp_refjenis."'
										AND trhpp_refno = '".$trcv_no."'
										AND trhpp_mspd_no = P.mspd_no), P.mspd_hpp)
				WHERE P.mspd_no IN
				(SELECT dtcv_mspd_no FROM dt_cvtgoods D
				LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtcv_mspd_no,1,1)
				WHERE D.dtcv_no = '".$trcv_no."'
				AND D.dtcv_qty <> 0
				AND KT.mskt_statusinv = 'Y'
				AND D.dtcv_jenis = 'R')";

		$this->db->simple_query($query);
	}

	private function update_hpp_produk_from($trcv_no, $i){		
		$query = "UPDATE ms_produk SET mspd_hpp =ROUND("
									."((mspd_hpp * (SELECT SUM(A.msst_qty) FROM ms_stok A WHERE A.msst_mspd_no = ms_produk.mspd_no))"
									." +"
									." (SELECT (".$i." * SUM(B.dtcv_qty * B.dtcv_hpp)) FROM dt_cvtgoods B"
										." WHERE B.dtcv_no = '".$trcv_no."'"
										." AND B.dtcv_mspd_no = ms_produk.mspd_no"
										." AND B.dtcv_jenis = 'F'))"
									." /"
									." ((SELECT SUM(C.msst_qty) FROM ms_stok C WHERE C.msst_mspd_no = ms_produk.mspd_no)"
									." +"
									." (SELECT (".$i." * SUM(D.dtcv_qty)) FROM dt_cvtgoods D"
										." WHERE D.dtcv_no = '".$trcv_no."'"
										." AND D.dtcv_mspd_no= ms_produk.mspd_no"
										." AND D.dtcv_jenis = 'F')), 4)"
									 
									." WHERE ms_produk.mspd_no IN"
										." (SELECT E.dtcv_mspd_no FROM dt_cvtgoods E"
										." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(E.dtcv_mspd_no,1,1)"
										." WHERE E.dtcv_no = '".$trcv_no."'"
										." AND KT.mskt_statusinv = 'Y'"
										." AND E.dtcv_jenis = 'F')"
									
									." AND ((SELECT SUM(F.msst_qty) FROM ms_stok F WHERE F.msst_mspd_no = ms_produk.mspd_no)"
										." +"
										." (SELECT (".$i." * SUM(G.dtcv_qty)) FROM dt_cvtgoods G"
										." WHERE G.dtcv_no = '".$trcv_no."'"
										." AND G.dtcv_mspd_no= ms_produk.mspd_no AND G.dtcv_jenis = 'F')) <> 0";

		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}				
	}

	private function update_hpp_produk_result($trcv_no, $i){		
		$query = "UPDATE ms_produk SET mspd_hpp =ROUND("
									."((mspd_hpp * (SELECT SUM(A.msst_qty) FROM ms_stok A WHERE A.msst_mspd_no = ms_produk.mspd_no))"
									." +"
									." (SELECT (".$i." * SUM(B.dtcv_qty * B.dtcv_hpp)) FROM dt_cvtgoods B"
										." WHERE B.dtcv_no = '".$trcv_no."'"
										." AND B.dtcv_mspd_no = ms_produk.mspd_no"
										." AND B.dtcv_jenis = 'R'))"
									." /"
									." ((SELECT SUM(C.msst_qty) FROM ms_stok C WHERE C.msst_mspd_no = ms_produk.mspd_no)"
									." +"
									." (SELECT (".$i." * SUM(D.dtcv_qty)) FROM dt_cvtgoods D"
										." WHERE D.dtcv_no = '".$trcv_no."'"
										." AND D.dtcv_mspd_no= ms_produk.mspd_no"
										." AND D.dtcv_jenis = 'R')), 4)"
									 
									." WHERE ms_produk.mspd_no IN"
										." (SELECT E.dtcv_mspd_no FROM dt_cvtgoods E"
										." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(E.dtcv_mspd_no,1,1)"
										." WHERE E.dtcv_no = '".$trcv_no."'"
										." AND KT.mskt_statusinv = 'Y'"
										." AND E.dtcv_jenis = 'R')"
									
									." AND ((SELECT SUM(F.msst_qty) FROM ms_stok F WHERE F.msst_mspd_no = ms_produk.mspd_no)"
										." +"
										." (SELECT (".$i." * SUM(G.dtcv_qty)) FROM dt_cvtgoods G"
										." WHERE G.dtcv_no = '".$trcv_no."'"
										." AND G.dtcv_mspd_no= ms_produk.mspd_no AND G.dtcv_jenis = 'R')) <> 0";

		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}				
	}

	private function save_update_stok_from($trcv_no, $i){
		$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
						." (SELECT DISTINCT A.dtcv_mspd_no, B.trcv_msgd_no, 0 FROM dt_cvtgoods A"
						." LEFT JOIN tr_cvtgoods B ON B.trcv_no = A.dtcv_no"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtcv_mspd_no, 1,1)"
						." WHERE A.dtcv_no = '".$trcv_no."'"
						." AND A.dtcv_jenis = 'F'" // <-- Penting !!!
						." AND KT.mskt_statusinv = 'Y'"
						." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
								." WHERE C.msst_mspd_no = A.dtcv_mspd_no"
								." AND C.msst_msgd_no= B.trcv_msgd_no))";
		$this->db->simple_query($query);

		$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
						." (".$i." * (SELECT SUM(A.dtcv_qty) FROM dt_cvtgoods A"
						." WHERE A.dtcv_no = '".$trcv_no."'"
						." AND A.dtcv_mspd_no = ms_stok.msst_mspd_no"
						." AND A.dtcv_jenis = 'F'" // <-- Penting !!!
						."))"
				." WHERE ms_stok.msst_mspd_no IN"
						." (SELECT B.dtcv_mspd_no FROM dt_cvtgoods B"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtcv_mspd_no,1,1)"
						." WHERE B.dtcv_no = '".$trcv_no."'"
						." AND B.dtcv_jenis = 'F'"
						." AND KT.mskt_statusinv = 'Y')"
				." AND ms_stok.msst_msgd_no ="
						." (SELECT C.trcv_msgd_no FROM tr_cvtgoods C"
						." WHERE C.trcv_no = '".$trcv_no."')";
		$this->db->simple_query($query);
	}

	private function save_update_stok_result($trcv_no, $i){
		$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
						." (SELECT DISTINCT A.dtcv_mspd_no, B.trcv_msgd_no, 0 FROM dt_cvtgoods A"
						." LEFT JOIN tr_cvtgoods B ON B.trcv_no = A.dtcv_no"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtcv_mspd_no, 1,1)"
						." WHERE A.dtcv_no = '".$trcv_no."'"
						." AND A.dtcv_jenis = 'R'" // <-- Penting !!!
						." AND KT.mskt_statusinv = 'Y'"
						." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
								." WHERE C.msst_mspd_no = A.dtcv_mspd_no"
								." AND C.msst_msgd_no= B.trcv_msgd_no))";
		$this->db->simple_query($query);
		$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
						." (".$i." * (SELECT SUM(A.dtcv_qty) FROM dt_cvtgoods A"
						." WHERE A.dtcv_no = '".$trcv_no."'"
						." AND A.dtcv_mspd_no = ms_stok.msst_mspd_no"
						." AND A.dtcv_jenis = 'R'" // <-- Penting !!!
						."))"
				." WHERE ms_stok.msst_mspd_no IN"
						." (SELECT B.dtcv_mspd_no FROM dt_cvtgoods B"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtcv_mspd_no,1,1)"
						." WHERE B.dtcv_no = '".$trcv_no."'"
						." AND B.dtcv_jenis = 'R'"
						." AND KT.mskt_statusinv = 'Y')"
				." AND ms_stok.msst_msgd_no ="
						." (SELECT C.trcv_msgd_no FROM tr_cvtgoods C"
						." WHERE C.trcv_no = '".$trcv_no."')";

		$this->db->simple_query($query);									
	}		

	// private function update_stok($trcv_no, $i, $x){
	// 	$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
	// 					." (SELECT DISTINCT A.dtcv_mspd_no, B.trcv_msgd_no, 0 FROM dt_cvtgoods A"
	// 					." LEFT JOIN tr_cvtgoods B ON B.trcv_no = A.dtcv_no"
	// 					." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtcv_mspd_no, 1,1)"
	// 					." WHERE A.dtcv_no = '".$trcv_no."'"
	// 					." AND KT.mskt_statusinv = 'Y'"
	// 					." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
	// 							." WHERE C.msst_mspd_no = A.dtcv_mspd_no"
	// 							." AND C.msst_msgd_no= B.trcv_msgd_no))";

	// 	$this->db->simple_query($query);

	// 	$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
	// 					." (".$i." * (SELECT SUM(A.dtcv_qty) FROM dt_cvtgoods A"
	// 					." WHERE A.dtcv_no = '".$trcv_no."'"
	// 					." AND A.dtcv_mspd_no = ms_stok.msst_mspd_no))"
	// 			." WHERE ms_stok.msst_mspd_no IN"
	// 					." (SELECT B.dtcv_mspd_no FROM dt_cvtgoods B"
	// 					." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtcv_mspd_no,1,1)"
	// 					." WHERE B.dtcv_no = '".$trcv_no."'"
	// 					." AND KT.mskt_statusinv = 'Y'"
	// 					." AND B.dtcv_jenis = 'F')"
	// 			." AND ms_stok.msst_msgd_no ="
	// 					." (SELECT C.trcv_msgd_no FROM tr_cvtgoods C"
	// 					." WHERE C.trcv_no = '".$trcv_no."')";

	// 	$this->db->simple_query($query);

	// 	$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
	// 					." (".$x." * (SELECT SUM(A.dtcv_qty) FROM dt_cvtgoods A"
	// 					." WHERE A.dtcv_no = '".$trcv_no."'"
	// 					." AND A.dtcv_mspd_no = ms_stok.msst_mspd_no))"
	// 			." WHERE ms_stok.msst_mspd_no IN"
	// 					." (SELECT B.dtcv_mspd_no FROM dt_cvtgoods B"
	// 					." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtcv_mspd_no,1,1)"
	// 					." WHERE B.dtcv_no = '".$trcv_no."'"
	// 					." AND KT.mskt_statusinv = 'Y'"
	// 					." AND B.dtcv_jenis = 'R')"
	// 			." AND ms_stok.msst_msgd_no ="
	// 					." (SELECT C.trcv_msgd_no FROM tr_cvtgoods C"
	// 					." WHERE C.trcv_no = '".$trcv_no."')";

	// 	$this->db->simple_query($query);									
	// }	

	private function jurnal_simpan($data){				
		// Generate CekInt
		$data['jurnal_h']['trju_cekint'] = rand(0,10000);			

		if($data['action'] == 'NEW'){
			// Insert data header jurnal
			$this->db->insert('tr_jurnal',$data['jurnal_h']);
		}

		if($data['action'] == 'EDIT'){
			// Update data header jurnal
			$this->db->where('trju_no',$data['jurnal_h']['trju_no']);
			$this->db->update('tr_jurnal',$data['jurnal_h']);
			$this->db->delete('dt_jurnal',array('dtju_no' => $data['jurnal_h']['trju_no']));
		}			

		//Insert data detail jurnal
		if(isset($data['jurnal_d'])){
			$seq = 1;
			foreach ($data['jurnal_d'] as $key => $value) {														
				$data['jurnal_d'][$key]['dtju_no'] = $data['jurnal_h']['trju_no'];
				$data['jurnal_d'][$key]['dtju_seq'] = $seq;
				$this->db->insert('dt_jurnal',$data['jurnal_d'][$key]);
				$seq += 1;
			}		
		}		
	}

	private function jurnal_hapus($data){		
		if(isset($data['jurnal_h']['trju_no']) && strlen($data['jurnal_h']['trju_no']) > 0){
			$this->db->delete('tr_jurnal', array('trju_no' => $data['jurnal_h']['trju_no']));
			$this->db->delete('dt_jurnal', array('dtju_no' => $data['jurnal_h']['trju_no']));
		}
	}

}