<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_spk_visit extends MY_Model {

	function __construct(){
		parent::__construct();				
		$this->load->model('setting/m_user_log');
	}

	public function get_spk_visit_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trsv_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_spk_visit.*, ms_sales.*, mscs_nm, mspd_nm');		
		$this->db->from('tr_spk_visit');			
		$this->db->join('tr_spk', 'trspk_no=substring(trsv_no, 1, 12)', 'left');			
		$this->db->join('ms_customer', 'mscs_no=trspk_mscs_no', 'left');			
		$this->db->join('ms_produk', 'mspd_no=trspk_mspd_no', 'left');			
		$this->db->join('ms_sales', 'mssl_no=trsv_mssl_no', 'left');			

		//Confirm status
		//1. SV-Confirmed
		//2. SV-Not yet confirmed

		if(isset($arr_filter['confirm_status'])){
			if($arr_filter['confirm_status'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'trsv_tglvisituntil != "0000-00-00"';
			}elseif($arr_filter['confirm_status'] == '2'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'trsv_tglvisituntil = "0000-00-00"';
			}		
			unset($arr_filter['confirm_status']);	
		}		

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}
		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}	

	public function get_spk_visit($trsv_no){		
		$data = array();

		//Get spk_visit
		$this->db->select('*, mspd_nm, u1.msus_nm as msus_nm, u2.msus_nm as cnfusr_nm,
							EXISTS(SELECT trspk_tglselesai FROM tr_spk WHERE trspk_no = "'.substr($trsv_no, 0, 12).'" AND trspk_tglselesai <> "0000-00-00" AND trspk_void = 0) AS is_spkfinish');
		$this->db->from('tr_spk_visit');
		$this->db->join('tr_spk','trspk_no = SUBSTRING(trsv_no, 1, 12)','left');
		$this->db->join('ms_customer','mscs_no = trspk_mscs_no','left');
		$this->db->join('ms_user u1','u1.msus_no = trsv_msus_no','left');
		$this->db->join('ms_user u2','u2.msus_no = trsv_cnfusr','left');
		$this->db->join('ms_produk','mspd_no = trspk_mspd_no', 'left');	
		$this->db->where('trsv_no',$trsv_no);
		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];
		}

		$this->db->select('dt_spk_sp.*, mspd_nm, msst_qty');
		$this->db->from('dt_spk_sp');
		$this->db->join('ms_produk', 'mspd_no = dtspk_mspd_no','left');
		$this->db->join('tr_spk', 'trspk_no = dtspk_no','left');					
		$this->db->join('ms_stok', 'msst_mspd_no = dtspk_mspd_no AND msst_msgd_no = trspk_msgd_no','left');
		$this->db->where('dtspk_no',$trspk_no);
		$this->db->order_by('dtspk_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;
		}
		
		if(count($data) > 0){
			return $data;
		}else{
			return false;
		}
	}

	public function get_spk_visit_by_trspk_no($trspk_no){
		$data = array();

		//Get spk_visit
		$this->db->select('tr_spk_visit.*, u1.msus_nm as msus_nm, u2.msus_nm as cnfusr_nm, mssl_nm');
		$this->db->from('tr_spk_visit');
		$this->db->join('ms_user u1','u1.msus_no = trsv_msus_no','left');
		$this->db->join('ms_user u2','u2.msus_no = trsv_cnfusr','left');		
		$this->db->join('ms_sales','mssl_no = trsv_mssl_no','left');		
		$this->db->where('SUBSTRING(trsv_no, 1, 12) = "'. $trspk_no. '"');
		$this->db->where('trsv_void',0);		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$data = $query->result_array();				
		}

		return $data;		
	}

	public function spk_visit_kode_auto($trspk_no){
		$this->db->select_max("trsv_no");
		$this->db->like("trsv_no", $trspk_no, "after");
		$query = $this->db->get("tr_spk_visit");
		if ($query->num_rows() == 0){
			return $trspk_no. "-VS01";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trsv_no'];
			$nomor = ((int) substr($kode, 15)) + 1;			
			return $trspk_no. '-SV'. sprintf("%'.02d", $nomor);
		}
	}	

	public function get_spk_visit_cekint($trsv_no, $trsv_cekint){		
		$query = $this->db->get_where('tr_spk_visit', array('trsv_no' => $trsv_no, 'trsv_cekint' => $trsv_cekint));				 
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_spk_visit_cekint($trsv_no){		
		//Update trju_cekint di tabel tr_jurnal
		$this->db->where('trsv_no', $trsv_no);
		$this->db->update('tr_spk_visit', array('trsv_cekint' => rand(0,10000)));
	}	

	public function spk_visit_simpan($data){
		try {					

			if($data['action'] == 'NEW'){
				// Generate CekInt			
				$data['header']['trsv_cekint'] = rand(0,10000);
				//Insert data spk_visit
				$this->db->insert('tr_spk_visit',$data['header']);
			}

			if($data['action'] == 'EDIT' || $data['action'] == 'CONF_VISIT' || $data['action'] == 'CANCEL_CONF_VISIT'){
				// Generate CekInt			
				$data['header']['trsv_cekint'] = rand(0,10000);
				// Update data spk_visit
				$this->db->where('trsv_no', $data['header']['trsv_no']);
				$this->db->update('tr_spk_visit', $data['header']);				
			}

			if($data['action'] == 'EDIT'){
				// Simpan userlog
				$this->m_user_log->user_log_simpan($data['userlog']);
			}
											
			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}		

	public function spk_visit_void($data){
		try {						
			$this->db->where('trsv_no', $data['header']['trsv_no']);
			$this->db->update('tr_spk_visit', array('trsv_cekint'=>rand(0,10000),'trsv_void'=>1));
			// Simpan userlog
			$this->m_user_log->user_log_simpan($data['userlog']);
			return 1;				
		} catch (Exception $e) {
			return 0;
		}		
	}

}		