<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_sales_retur extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('setting/m_user_log');		
	}

	public function get_sales_retur_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trsr_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_salesret.*, msus_nm, mscs_nm, msgd_nm');
		$this->db->from('tr_salesret');
		$this->db->join('ms_user','msus_no = trsr_msus_no', 'left');
		$this->db->join('ms_customer', 'ms_customer.mscs_no = tr_salesret.trsr_mscs_no','left');
		$this->db->join('ms_gudang', 'ms_gudang.msgd_no = tr_salesret.trsr_msgd_no','left');		

		$query_string = '';

		//Return confirm status
		//1. Confirmed
		//2. Not yet confirmed

		if(isset($arr_filter['confirm_srrg_status'])){
			if($arr_filter['confirm_srrg_status'] == '1'){
				$query_string .= 'trsr_tglterima <> 0000-00-00';
			}elseif($arr_filter['confirm_srrg_status'] == '2'){
				$query_string .= 'trsr_tglterima = 0000-00-00';
			}
			unset($arr_filter['confirm_srrg_status']);
		}

		//Return voucher status
		//1. Settled
		//2. Unsettled

		if(isset($arr_filter['voucher_status'])){
			if($arr_filter['voucher_status'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'NOT(trsr_jenis = "V" AND trsr_pbso_no = "")';
			}elseif($arr_filter['voucher_status'] == '2'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'trsr_jenis = "V" AND trsr_pbso_no = ""';
			}
			unset($arr_filter['voucher_status']);
		}

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_sales_dlv x1 WHERE x1.dtsd_no = SUBSTRING(trsr_no, 1, 17) AND x1.dtsd_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_sales_dlv x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtsd_mspd_no WHERE x2.dtsd_no = SUBSTRING(trsr_no, 1, 17) AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}
		
		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}
				
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}		

	public function sales_retur_kode_auto($trsd_no){
		$this->db->select_max("trsr_no");
		$this->db->like("trsr_no", $trsd_no, "after");
		$query = $this->db->get("tr_salesret");
		if ($query->num_rows() == 0){
			return $trsd_no. "-RT01";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trsr_no'];
			$nomor = ((int) substr($kode, 20)) + 1;			
			return $trsd_no. '-RT'. sprintf("%'.02d", $nomor);
		}
	}

	public function get_sales_retur($trsr_no){		
		$data = array();		
		
		//Get sales retur header berdasarkan trsr_no	
		$this->db->select('*, trsd_no, trsd_cekint, msus_nm, mscs_jenis,
							EXISTS(SELECT pbso_trsr_no FROM pby_so WHERE pbso_trsr_no = "'.$trsr_no.'" AND pbso_void = 0) AS is_srhaspaid');
		$this->db->from('tr_salesret');
		$this->db->join('tr_sales_dlv', 'tr_sales_dlv.trsd_no = SUBSTRING(tr_salesret.trsr_no, 1, 17)','inner');
		$this->db->join('ms_customer', 'ms_customer.mscs_no = tr_salesret.trsr_mscs_no','inner');
		$this->db->join('ms_user', 'ms_user.msus_no = tr_salesret.trsr_msus_no','inner');		
		$this->db->join('tr_so', 'trso_no = SUBSTRING(trsr_no,1,12)','left');
		$this->db->where('tr_salesret.trsr_no',$trsr_no);
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];
		}

		//Get dt_salesret
		$sql = 'SELECT dt_sales_dlv.*,'
					.' IFNULL(dt_salesret.dtsr_no,"") AS dtsr_no,'
					.' IFNULL(dt_salesret.dtsr_seq,"") AS dtsr_seq,'
					.' IFNULL(dt_salesret.dtsr_mspd_no,"") AS dtsr_mspd_no,'
					.' IFNULL(dt_salesret.dtsr_qtyretur,0) AS dtsr_qtyretur,'
					.' IFNULL(dt_salesret.dtsr_bftax,dt_sales_dlv.dtsd_bftax) AS dtsr_bftax,'
					.' IFNULL(dt_salesret.dtsr_tax,dt_sales_dlv.dtsd_tax) AS dtsr_tax,'
					.' IFNULL(dt_salesret.dtsr_nett,dt_sales_dlv.dtsd_nett) AS dtsr_nett,'					
					.' IFNULL(ms_produk.mspd_nm,"") AS mspd_nm,'					
					.' IFNULL((SELECT SUM(dtsr_qtyretur) FROM dt_salesret LEFT JOIN tr_salesret ON tr_salesret.trsr_no=dt_salesret.dtsr_no WHERE SUBSTRING(dtsr_no,1,17) = dtsd_no AND dtsr_seq = dtsd_seq AND dtsr_no <> ? AND trsr_void = 0),0) AS calc_qty_retur'
					.' FROM dt_sales_dlv'
					.' LEFT JOIN dt_salesret'
					.' ON dt_salesret.dtsr_no=?'
					.' AND dt_sales_dlv.dtsd_seq = dt_salesret.dtsr_seq'					
					.' LEFT JOIN ms_produk'
					.' ON dt_sales_dlv.dtsd_mspd_no=ms_produk.mspd_no'
					.' LEFT JOIN ms_kategori'
					.' ON ms_kategori.mskt_no=SUBSTRING(ms_produk.mspd_no,1,1)'
					.' WHERE dt_sales_dlv.dtsd_no =? AND ms_kategori.mskt_statusinv = "Y" ORDER BY dtsd_seq ASC';

		$query = $this->db->query($sql, array($trsr_no, $trsr_no, substr($trsr_no, 0, 17)));
	
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;
		}
		if(count($data) > 0){
			return $data;
		}else{
			return false;
		}
	}	

	public function get_sales_retur_cekint($trsr_no, $trsr_cekint){		
		$query = $this->db->get_where('tr_salesret', array('trsr_no' => $trsr_no, 'trsr_cekint' => $trsr_cekint));		
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_sales_retur_cekint($trsr_no){		
		//Update trsr_cekint di tabel tr_salesret
		$this->db->where('trsr_no', $trsr_no);
		$this->db->update('tr_salesret', array('trsr_cekint' => rand(0,10000)));								
	}	

	public function sales_retur_simpan($data){
		try{
			if($data['action'] == 'NEW'){
				// insert data
				$this->insert_data($data);
				// update trsr_total
				$this->update_trsr_total($data['header']['trsr_no']);
			}

			if($data['action'] == 'EDIT'){					
				// update data
				$this->update_data($data);
				// update trsr_total
				$this->update_trsr_total($data['header']['trsr_no']);
				// Simpan userlog
				$this->m_user_log->user_log_simpan($data['userlog']);					
			}

			if($data['action'] == 'CONF_RECEIVING_GOODS'){
				//todo list
				//1a. Update data sales return header/detail					
				//1b. Update trsr_total
				//2. Update hpp (+)
				//3. Update stok (+)
				//4. Create jurnal

				//1a. Update data sales return header/detail
				$this->update_data($data);
				//1b. update trsr_total
				$this->update_trsr_total($data['header']['trsr_no']);					
				//2. Update hpp (+)
				$this->save_update_hpp($data['header']['trsr_no'], 1, 'SRR');				
				//3. Update stok (+)
				$this->update_stok($data['header']['trsr_no'], 1);
				//4. Create jurnal
				$this->jurnal_simpan($data);
			}

			if($data['action'] == 'CANCEL_RECEIVING_GOODS'){
				//todo list
				//1. Update hpp (-)
				//2. Update stok (-)
				//3. Update data sales return header/detail					
				//4. Delete jurnal

				//1. Update hpp (-)
				$this->save_update_hpp($data['header']['trsr_no'], -1, 'SRC');
				// $this->update_hpp($data['header']['trsr_no'], -1);
				//2. Update stok (-)
				$this->update_stok($data['header']['trsr_no'], -1);
				//3. Update data sales return header/detail
				$this->update_data($data);							
				//4. Delete jurnal
				$this->jurnal_hapus($data);
			}			

			if($data['action'] == 'VOID'){
				$this->void_data($data);
				// Simpan userlog
				$this->m_user_log->user_log_simpan($data['userlog']);
			}

			//Update dtso_qtyretur di detail so
			if($data['action'] != 'NEW'){			
				$this->update_qtyretur($data['header']['trsr_no']);
			}
			
			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	private function insert_data($data){
		//todo list
		//1. Insert header sales return
		//2. Insert detail sales return

		//1. Insert header sales return
		//Generate CekInt
		$data['header']['trsr_cekint'] = rand(0,10000);			
		$this->db->insert('tr_salesret',$data['header']);

		//2. Insert detail sales return
		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $detail) {					
				$this->db->insert('dt_salesret',$data['detail'][$key]);
			}		
		}
	}

	private function update_data($data){		
		$this->db->where('trsr_no', $data['header']['trsr_no']);
		$this->db->update('tr_salesret', $data['header']);
		
		$this->db->where(array('dtsr_no' => $data['header']['trsr_no']));
		$this->db->delete('dt_salesret');

		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $value) {							
				$this->db->insert('dt_salesret', $data['detail'][$key]);
			}						
		}
	}

	private function update_trsr_total($trsr_no){
		$query = "UPDATE tr_salesret SET trsr_total ="
										."IFNULL(("
										." SELECT SUM(A.dtsr_nett * A.dtsr_qtyretur) FROM dt_salesret A"					
										." WHERE A.dtsr_no = '".$trsr_no."'"					
										."),0)"
				." WHERE tr_salesret.trsr_no = '".$trsr_no."'";				
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
	}

	private function update_qtyretur($trsr_no){
		$query = "UPDATE dt_so SET dtso_qtyretur ="
					."IFNULL(("
					." SELECT SUM(A.dtsr_qtyretur) FROM dt_salesret A"
					." LEFT JOIN tr_salesret B ON B.trsr_no = A.dtsr_no"
					." WHERE SUBSTRING(A.dtsr_no,1,12) = dt_so.dtso_no"
					." AND A.dtsr_seq = dt_so.dtso_seq"
					." AND B.trsr_void = 0"
					." AND B.trsr_tglterima <> '0000-00-00'"
					."),0)"
				." WHERE dt_so.dtso_no = '".substr($trsr_no, 0, 11)."'";
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
	}

	private function save_update_hpp($trsr_no, $i, $trhpp_refjenis){
		$trhpp_tgl = date('Y-m-d H:i:s');

		$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
							(SELECT '".$trhpp_tgl."',
									'".$trhpp_refjenis."',
									'".$trsr_no."',
									D.dtsr_mspd_no, 
									(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtsr_mspd_no),
									 P.mspd_hpp,
									 SUM(".$i." * D.dtsr_qtyretur),
									ROUND(SUM((".$i." * D.dtsr_qtyretur) * D.dtsr_hpp), 4)
							FROM dt_salesret D 
							LEFT JOIN ms_produk P 
							ON P.mspd_no = D.dtsr_mspd_no 
							LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtsr_mspd_no,1,1)
							WHERE D.dtsr_no = '".$trsr_no."'
							AND D.dtsr_qtyretur > 0
							AND KT.mskt_statusinv = 'Y'
							AND P.mspd_paket = 'N'
							GROUP BY D.dtsr_mspd_no, D.dtsr_hpp)";

		$this->db->simple_query($query);

		$query = "UPDATE tr_his_hpp 
					SET trhpp_totalawal = ROUND((trhpp_qtyawal * trhpp_hppawal), 4),
						trhpp_hppakhir = IF(
							(trhpp_qtyawal + (trhpp_qtytrans)) <> 0,
							ROUND(
								((trhpp_qtyawal * trhpp_hppawal) + (trhpp_totaltrans))
								 /
								 (trhpp_qtyawal + (trhpp_qtytrans)), 4), trhpp_hppawal)
					WHERE trhpp_tgl = '".$trhpp_tgl."'
					AND trhpp_refjenis = '".$trhpp_refjenis."'
					AND trhpp_refno = '".$trsr_no."'";

		$this->db->simple_query($query);

		$query = "UPDATE ms_produk P 
							SET P.mspd_hpp = IFNULL((SELECT trhpp_hppakhir FROM tr_his_hpp 
										WHERE trhpp_tgl = '".$trhpp_tgl."'
										AND trhpp_refjenis = '".$trhpp_refjenis."'
										AND trhpp_refno = '".$trsr_no."'
										AND trhpp_mspd_no = P.mspd_no), P.mspd_hpp)
				WHERE P.mspd_no IN
				(SELECT dtsr_mspd_no FROM dt_salesret D
				LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtsr_mspd_no,1,1)				
				WHERE D.dtsr_no = '".$trsr_no."'
				AND D.dtsr_qtyretur > 0				
				AND KT.mskt_statusinv = 'Y')
				AND P.mspd_paket = 'N'";

		$this->db->simple_query($query);
	}

	private function update_hpp($trsr_no, $i){		
		$query = "UPDATE ms_produk SET mspd_hpp =ROUND("
									."((mspd_hpp * (SELECT SUM(A.msst_qty) FROM ms_stok A WHERE A.msst_mspd_no = ms_produk.mspd_no))"
									." +"
									." (SELECT (".$i." * SUM(B.dtsr_qtyretur * B.dtsr_hpp)) FROM dt_salesret B"
										." WHERE B.dtsr_no = '".$trsr_no."'"
										." AND B.dtsr_mspd_no = ms_produk.mspd_no))"
									." /"
									." ((SELECT SUM(C.msst_qty) FROM ms_stok C WHERE C.msst_mspd_no = ms_produk.mspd_no)"
									 ." +"
									 ." (SELECT (".$i." * SUM(D.dtsr_qtyretur)) FROM dt_salesret D"
										." WHERE D.dtsr_no = '".$trsr_no."'"
										." AND D.dtsr_mspd_no= ms_produk.mspd_no)), 4)"
									 
									." WHERE ms_produk.mspd_no IN"
										." (SELECT E.dtsr_mspd_no FROM dt_salesret E"
										." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(E.dtsr_mspd_no,1,1)"
										." WHERE E.dtsr_no = '".$trsr_no."'"
										." AND KT.mskt_statusinv = 'Y')"
									
									." AND ((SELECT SUM(F.msst_qty) FROM ms_stok F WHERE F.msst_mspd_no = ms_produk.mspd_no)"
										." +"
										." (SELECT (".$i." * SUM(G.dtsr_qtyretur)) FROM dt_salesret G"
										." WHERE G.dtsr_no = '".$trsr_no."'"
										." AND G.dtsr_mspd_no= ms_produk.mspd_no)) <> 0";

		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
		
	}

	private function update_stok($trsr_no, $i){
		$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
						." (SELECT DISTINCT A.dtsr_mspd_no, B.trsr_msgd_no, 0 FROM dt_salesret A"
						." LEFT JOIN tr_salesret B ON B.trsr_no = A.dtsr_no"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtsr_mspd_no, 1,1)"
						." LEFT JOIN ms_produk mspd ON mspd.mspd_no = A.dtsr_mspd_no"
						." WHERE A.dtsr_no = '".$trsr_no."'"
						." AND KT.mskt_statusinv = 'Y'"
						." AND mspd.mspd_paket = 'N'"
						." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
								." WHERE C.msst_mspd_no = A.dtsr_mspd_no"
								." AND C.msst_msgd_no= B.trsr_msgd_no))";

		$this->db->simple_query($query);		

		$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
						." (".$i." * (SELECT SUM(A.dtsr_qtyretur) FROM dt_salesret A"
						." WHERE A.dtsr_no = '".$trsr_no."'"
						." AND A.dtsr_mspd_no = ms_stok.msst_mspd_no))"
				." WHERE ms_stok.msst_mspd_no IN"
						." (SELECT B.dtsr_mspd_no FROM dt_salesret B"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtsr_mspd_no,1,1)"
						." LEFT JOIN ms_produk mspd ON mspd.mspd_no = B.dtsr_mspd_no"
						." WHERE B.dtsr_no = '".$trsr_no."'"
						." AND KT.mskt_statusinv = 'Y'"
						." AND mspd.mspd_paket = 'N'"
						." AND B.dtsr_qtyretur <> 0)"
				." AND ms_stok.msst_msgd_no ="
						." (SELECT C.trsr_msgd_no FROM tr_salesret C"
						." WHERE C.trsr_no = '".$trsr_no."')";		
			
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}					
	}		

	private function void_data($data){
		//Set dtso_qtyretur = 0 di tabel dt_so
		// $this->db->where(array('dtso_no' => substr($data['header']['trsr_no'], 0, 17)));
		// $this->db->update('dt_so', array('dtso_qtyretur' => 0));					

		//void sales retur
		$this->db->where('trsr_no', $data['header']['trsr_no']);
		$this->db->update('tr_salesret', array('trsr_void'=>1));					
	}

	private function jurnal_simpan($data){
		// Generate CekInt
		$data['jurnal_h']['trju_cekint'] = rand(0,10000);			
		// Insert data header jurnal
		$this->db->insert('tr_jurnal',$data['jurnal_h']);
		
		//Insert data detail jurnal
		if(isset($data['jurnal_d'])){
			$seq = 1;
			foreach ($data['jurnal_d'] as $key => $detail) {														
				$data['jurnal_d'][$key]['dtju_no'] = $data['jurnal_h']['trju_no'];
				$data['jurnal_d'][$key]['dtju_seq'] = $seq;
				$this->db->insert('dt_jurnal',$data['jurnal_d'][$key]);
				$seq += 1;
			}		
		}		
	}

	private function jurnal_hapus($data){		
		if(isset($data['jurnal_h']['trju_no']) && strlen($data['jurnal_h']['trju_no']) > 0){
			$this->db->delete('tr_jurnal', array('trju_no' => $data['jurnal_h']['trju_no']));
			$this->db->delete('dt_jurnal', array('dtju_no' => $data['jurnal_h']['trju_no']));
		}
	}

}	