<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_reporting extends MY_Model {

	public function get_lp_sales_query($data){
		$query = 'select dtso.*, trso_tgl, trso_catatan, trso_pocust, trso_total, 
					trso_terbayar, trso_tglestkirim, trso_lock, mscs_no, mscs_nm, 
					mssl_no, mssl_nm, mspd_nm, msmr_no, msmr_nm,
					IFNULL((SELECT SUM(dtso2.dtso_qty - dtso2.dtso_qtysd) FROM dt_so dtso2 WHERE dtso2.dtso_no = dtso.dtso_no AND trso_lock = "N"),0) as totalblmsd
					from dt_so dtso
					left join tr_so trso on trso.trso_no = dtso.dtso_no
					left join ms_sales mssl on mssl.mssl_no = trso.trso_mssl_no
					left join ms_customer mscs on mscs.mscs_no = trso.trso_mscs_no
					left join ms_produk mspd on mspd.mspd_no = dtso.dtso_mspd_no
					left join ms_kategori mskt on mskt.mskt_no = SUBSTRING(mspd.mspd_no,1,1)
					left join ms_famili msfm on msfm.msfm_no = SUBSTRING(mspd.mspd_no,1,3)
					left join ms_model msmd on msmd.msmd_no = SUBSTRING(mspd.mspd_no,1,6)
					left join ms_merk msmr on msmr.msmr_no = mspd.mspd_msmr_no
					left join ms_cabang mscb on mscb.mscb_no = trso.trso_mscb_no
					left join top_so on tpso_no = dtso.dtso_no
					where trso.trso_void = 0 and POSITION(mscb.mscb_no in "'.$data['mscb_listmscb'].'")';

		// filter by trso_tgl
		if($data['lp_trso_tgl'] == 'lp_tglso_sel'){
			$param['vtrso_tgldari'] = $data['lp_trso_tgl_dari'];
			$param['vtrso_tglsampai'] = $data['lp_trso_tgl_sampai'];
			$query .= ' and (CONVERT(trso.trso_tgl, DATE) between "'.$data['lp_trso_tgl_dari'].'" and "'.$data['lp_trso_tgl_sampai'].'")';
		}else{
			$param['vtrso_tgldari'] = 'ALL';
			$param['vtrso_tglsampai'] = 'ALL';
		}

		// filter by trso_tglestkirim
		if($data['lp_trso_tgl'] == 'lp_tglestkirim_sel'){
			$param['vtrso_tglestkirimdari'] = $data['lp_trso_tglestkirim_dari'];
			$param['vtrso_tglestkirimsampai'] = $data['lp_trso_tglestkirim_sampai'];
			$query .= ' and trso.trso_tglestkirim between "'.$data['lp_trso_tglestkirim_dari'].'" and "'.$data['lp_trso_tglestkirim_sampai'].'"';
		}else{
			$param['vtrso_tglestkirimdari'] = 'ALL';
			$param['vtrso_tglestkirimsampai'] = 'ALL';			
		}

		// filter by mscs (customer)
		if($data['lp_mscs'] != 'lp_mscs_all'){
			if ($data['lp_mscs'] == 'lp_mscs_r') {
				$query .= ' and mscs_jenis="R"';
				$param['vtrso_mscs_no'] = 'Retail';
				$param['vtrso_mscs_nm'] = '';
			} else if ($data['lp_mscs'] == 'lp_mscs_a') {
				$query .= ' and mscs_jenis="A"';
				$param['vtrso_mscs_no'] = 'Agen';
				$param['vtrso_mscs_nm'] = '';
			} else if ($data['lp_mscs'] == 'lp_mscs_sel'){
				$query .= ' and mscs_no = "'. $data['lp_mscs_no']. '"';
				$param['vtrso_mscs_no'] = $data['lp_mscs_nm'];
				$param['vtrso_mscs_nm'] = '';
			} 
		} else {
				$param['vtrso_mscs_no'] ='ALL';
				$param['vtrso_mscs_nm'] = 'ALL';
				}

		
		// filter by mssl (sales)
		if($data['lp_mssl'] != 'lp_mssl_all'){
			if ($data['lp_mssl'] == 'lp_mssl_sls') {
				$query .= ' and mssl_divisi="S"';
				$param['vtrso_mssl_no'] = 'Salesman';
				$param['vtrso_mssl_nm'] = '';
			} else if ($data['lp_mssl'] == 'lp_mssl_tkn') {
				$query .= ' and mssl_divisi="T"';
				$param['vtrso_mssl_no'] = 'Teknisi';
				$param['vtrso_mssl_nm'] = '';
			} else if ($data['lp_mssl'] == 'lp_mssl_sel'){
				$query .= ' and mssl_no = "'. $data['lp_mssl_no']. '"';
				$param['vtrso_mssl_no'] = $data['lp_mssl_no'];
				$param['vtrso_mssl_nm'] = trim($data['mssl_no'][1]);
			} 
		} else {
				$param['vtrso_mssl_no'] ='ALL';
				$param['vtrso_mssl_nm'] = 'ALL';
				}

		// filter by payment status (settled)
		if($data['lp_pbystatus'] != "all"){
			if($data['lp_pbystatus'] == 1){
				$query .= ' and trso_terbayar >= trso_total';
			}elseif ($data['lp_pbystatus'] == 2){
				$query .= ' and trso_terbayar < trso_total';
			}
		}
		
		//filter by sales order delivery status
		if($data['lp_sodlvstatus'] !="ALL"){
			if($data['lp_sodlvstatus'] == 1){
				$query .= ' and (((SELECT SUM(a.dtso_qty - a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") <= 0) OR (trso_lock = "Y"))';
				$param['lp_sodlvstatus'] = "Complete Sales Order";
			} else if ($data['lp_sodlvstatus'] == 2){
				$query .= ' and (SELECT SUM(a.dtso_qty - a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") > 0';
				$param['lp_sodlvstatus'] = "Incomplete Sales Order";
			} else if ($data['lp_sodlvstatus'] == 3){
				$query .= ' and (SELECT SUM(a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") <= 0';
				$param['lp_sodlvstatus'] = "No Delivery At ALL";
			} else if ($data['lp_sodlvstatus'] == 4){
				$query .= ' and ((SELECT SUM(a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") > 0 AND (SELECT SUM(a.dtso_qty - a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") > 0)';
				$param['lp_sodlvstatus'] = "Partial Delivery";
			}
		} else $param['lp_sodlvstatus'] = "ALL";
		
		
		if($data['lp_topstatus'] != "ALL"){
			if($data['lp_topstatus'] == 1){
				$query .= ' and (DATEDIFF(tpso_tgljatuhtempo, "'.date('Y-m-d').'") <= 3) AND (DATEDIFF(tpso_tgljatuhtempo, "'.date('Y-m-d').'") >= 0) AND (tpso_aktif ="Y") ';
				$param['top_status'] = "Due Date Payment SO";
			}else if($data['lp_topstatus'] == 2){
				$query .= ' and (tpso_tgljatuhtempo < CURDATE()) AND (trso_terbayar < trso_total) AND (tpso_aktif ="Y") ';
				$param['top_status'] = "Late Payment SO";
			}
		} else $param['top_status'] = "ALL";
		
		// filter by mspd_no
		if($data['lp_mspd'] == 'lp_mspd_sel'){						
			$query .= ' and EXISTS(SELECT dtso4.* FROM dt_so dtso4 LEFT JOIN ms_produk mspd1 ON mspd1.mspd_no = dtso4.dtso_mspd_no WHERE dtso4.dtso_no = dtso.dtso_no AND mspd1.mspd_no = "'. $data['lp_mspd_no_sel']. '")';
		}					

		// filter by containing mspd_no/mspd_nm
		if($data['lp_mspd'] == 'lp_mspd_con'){			
			if($data['lp_mspd_no_con'] != ''){
				$query .= ' and EXISTS(SELECT dtso5.* FROM dt_so dtso5 LEFT JOIN ms_produk mspd2 ON mspd2.mspd_no = dtso5.dtso_mspd_no WHERE dtso5.dtso_no = dtso.dtso_no AND mspd2.mspd_no LIKE "%'. $data['lp_mspd_no_con']. '%")';
			}

			if($data['lp_mspd_nm_con'] != ''){
				$query .= ' and EXISTS(SELECT dtso6.* FROM dt_so dtso6 LEFT JOIN ms_produk mspd3 ON mspd3.mspd_no = dtso6.dtso_mspd_no WHERE dtso6.dtso_no = dtso.dtso_no AND mspd3.mspd_nm LIKE "%'. $data['lp_mspd_nm_con']. '%")';
			}
		}		
		
		if($data['judul_laporan'] == 'lp_wip_so'){
			// filter by wip so all
			if($data['lp_wip_so'] == 'lp_wip_so_all'){
				$query .= ' and (IFNULL((SELECT SUM(dtso7.dtso_qty - dtso7.dtso_qtykirim) FROM dt_so dtso7 WHERE dtso7.dtso_no = dtso.dtso_no AND trso_lock = "N"), 0) > 0 OR IFNULL((SELECT SUM(dtso7.dtso_qtysd - dtso7.dtso_qtykirim) FROM dt_so dtso7 WHERE dtso7.dtso_no = dtso.dtso_no AND trso_lock = "Y"), 0) > 0)';
			}

			// filter by wip so dekat
			if($data['lp_wip_so'] == 'lp_wip_so_dekat'){			
				// $query .= ' and EXISTS(SELECT dtso7.* FROM dt_so dtso7 WHERE dtso7.dtso_no = dtso.dtso_no AND (((dtso7.dtso_qty - dtso7.dtso_qtykirim) > 0 AND trso_lock = "N") OR ((dtso7.dtso_qtysd - dtso7.dtso_qtykirim) > 0 AND trso_lock = "Y")) AND DATEDIFF(trso_tglestkirim,"'. date('Y-m-d') .'") <= 120 )';
				$query .= ' and (IFNULL((SELECT SUM(dtso7.dtso_qty - dtso7.dtso_qtykirim) FROM dt_so dtso7 WHERE dtso7.dtso_no = dtso.dtso_no AND trso_lock = "N"), 0) > 0 OR IFNULL((SELECT SUM(dtso7.dtso_qtysd - dtso7.dtso_qtykirim) FROM dt_so dtso7 WHERE dtso7.dtso_no = dtso.dtso_no AND trso_lock = "Y"), 0) > 0) AND DATEDIFF(trso_tglestkirim,"'. date('Y-m-d') .'") <= 120';
			}		

			// filter by wip so jauh
			if($data['lp_wip_so'] == 'lp_wip_so_jauh'){
				// $query .= ' and EXISTS(SELECT dtso8.* FROM dt_so dtso8 WHERE dtso8.dtso_no = dtso.dtso_no AND (((dtso8.dtso_qty - dtso8.dtso_qtykirim) > 0 AND trso_lock = "N") OR ((dtso8.dtso_qtysd - dtso8.dtso_qtykirim) > 0 AND trso_lock = "Y")) AND DATEDIFF(trso_tglestkirim,"'. date('Y-m-d') .'") > 120)';			
				$query .= ' and (IFNULL((SELECT SUM(dtso7.dtso_qty - dtso7.dtso_qtykirim) FROM dt_so dtso7 WHERE dtso7.dtso_no = dtso.dtso_no AND trso_lock = "N"), 0) > 0 OR IFNULL((SELECT SUM(dtso7.dtso_qtysd - dtso7.dtso_qtykirim) FROM dt_so dtso7 WHERE dtso7.dtso_no = dtso.dtso_no AND trso_lock = "Y"), 0) > 0) AND DATEDIFF(trso_tglestkirim,"'. date('Y-m-d') .'") > 120';
			}					
		}

		// filter by mskt_no
		if($data['lp_mskt'] == 'lp_mskt_sel'){						
			$query .= ' and EXISTS(SELECT dtso8.* FROM dt_so dtso8 LEFT JOIN ms_produk mspd4 ON mspd4.mspd_no = dtso8.dtso_mspd_no WHERE dtso8.dtso_no = dtso.dtso_no AND SUBSTRING(mspd4.mspd_no,1,1) = "'. $data['lp_mskt_no']. '")';
		}

		// filter by msfm_no
		if($data['lp_msfm'] == 'lp_msfm_sel'){			
			$query .= ' and EXISTS(SELECT dtso9.* FROM dt_so dtso9 LEFT JOIN ms_produk mspd5 ON mspd5.mspd_no = dtso9.dtso_mspd_no WHERE dtso9.dtso_no = dtso.dtso_no AND SUBSTRING(mspd5.mspd_no,1,3) = "'. $data['lp_msfm_no']. '")';
		}

		// filter by msmd_no
		if($data['lp_msmd'] == 'lp_msmd_sel'){			
			$query .= ' and EXISTS(SELECT dtso10.* FROM dt_so dtso10 LEFT JOIN ms_produk mspd6 ON mspd6.mspd_no = dtso10.dtso_mspd_no WHERE dtso10.dtso_no = dtso.dtso_no AND SUBSTRING(mspd6.mspd_no,1,6) = "'. $data['lp_msmd_no']. '")';
		}

		//filter by tipe data (F/C)
		if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
			$query .= ' AND trso_fin = "'. $data['lp_trju_fin'].'"';
		}

		if($data['judul_laporan'] == 'lp_so_list'){
			$query .= ' group by dtso_no';			
		}
		
		$query .= ' order by trso_tgl, trso_no, dtso_seq';  // #update 27july# //
		
		return array('query' => $query, 'param' => $param);		
	}

	public function get_lp_incdlv_with_detpbyr($data) {
		$query = '
			SELECT  
			trid_no
			,trid_tgl
			,trid_tglterima
			,trid_mssp_no
			,mssp_nm
			,mssp_jenis
			,trpo_curr
			,trid_kurs
			,trid_total
			,IFNULL((SELECT SUM(dtid_bftaxcurr * dtid_qtyterima) FROM dt_in_dlv WHERE dtid_no = trid_no),0) AS dpp
			,IFNULL((SELECT SUM(pbpo_jlhbayar) FROM pby_po WHERE pbpo_refno = trid_no AND pbpo_void = 0),0) AS terbayar

			,IFNULL((Select sum(dtid_bea) 
				                   	from dt_in_dlv
				                   	where dtid_no = trid_no
				                   	),0) as trid_totalbea
			,IFNULL((SELECT SUM(pbidbm_jlhbayar) FROM pby_in_dlv_beamasuk WHERE pbidbm_trid_no = trid_no), 0) AS terbayar_beamasuk
			,IFNULL((SELECT SUM(pbidbm_adj) FROM pby_in_dlv_beamasuk WHERE pbidbm_trid_no = trid_no), 0) AS adj_beamasuk
			,IFNULL((SELECT pbidbm_tglbayar FROM pby_in_dlv_beamasuk WHERE pbidbm_trid_no = trid_no), "") AS pbidbm_tglbayar
			
			,trid_totalbiayakirim
			,IFNULL((SELECT SUM(pbidbk_jlhbayar) FROM pby_in_dlv_biayakirim WHERE pbidbk_trid_no = trid_no), 0) AS terbayar_shipping_fee
			,IFNULL((SELECT SUM(pbidbk_adj) FROM pby_in_dlv_biayakirim WHERE pbidbk_trid_no = trid_no), 0) AS adj_shipping_fee
			,IFNULL((SELECT pbidbk_tglbayar FROM pby_in_dlv_biayakirim WHERE pbidbk_trid_no = trid_no), "") AS pbidbk_tglbayar
			
			,trid_catatan
			,pbpo_tgl
			,pbpo_tglcair
			,pbpo_msjb_no
			,msjb_nm
			,IF(pbpo_jenis = "D", "From DP", 
				IF(pbpo_jenis = "O", "Other", pbpo_jenis)
			) AS payment_from
			,pbpo_kurs
			,pbpo_jlhbayar
			,pbpo_catatan
			FROM tr_in_dlv trid
			LEFT JOIN tr_po on trpo_no = SUBSTRING(trid_no, 1, 12)
			LEFT JOIN ms_supplier on mssp_no = trid_mssp_no
			LEFT JOIN ms_cabang on mscb_no = trid_mscb_no
			LEFT JOIN ms_gudang on trid_msgd_no = msgd_no
			LEFT JOIN pby_po ON pbpo_refno = trid_no AND pbpo_void=0
			LEFT JOIN ms_jnspbyr on pbpo_msjb_no = msjb_no
			WHERE trid_void=0
			AND POSITION(trid_mscb_no in "'.$data['mscb_listmscb'].'")
		';

		//filter by tanggal
		if ($data['lp_trid_tgl'] == 'lp_trid_tglsel') {
			$query .= ' and (CONVERT(trid_tgl, DATE) between "'.$data['lp_trid_tgl_dari'].'" and "'.$data['lp_trid_tgl_sampai'].'")';
			$param['periode'] = 'Created Date : '.$data['lp_trid_tgl_dari'].' s/d '.$data['lp_trid_tgl_sampai'].'';
		}

		//filter by tanggal
		if ($data['lp_trid_tgl'] == 'lp_trid_tglterima') {
			$query .= ' and trid_tglterima between "'.$data['lp_trid_tglterima_dari'].'" and "'.$data['lp_trid_tglterima_sampai'].'"';
			$param['periode'] = 'Receive Date : '.$data['lp_trid_tglterima_dari'].' s/d '.$data['lp_trid_tglterima_sampai'].'';
		}

		//filter by confirm status
		if ($data['lp_id_receive_status'] != 'all'){
			if($data['lp_id_receive_status'] == 1 ){
				$query .= ' and trid_tglterima > 0';
				$param['receive_status'] = "Incoming Deleivery Received";
			} else if ($data['lp_id_receive_status'] == 2){
				$query .= ' and trid_tglterima = 0';
				$param['receive_status'] = "Incoming Deleivery Not Yet Received";
			}
		} else {
			$param['receive_status'] ="ALL";
		}

		// filter by mssp (supplier)
		if($data['lp_mssp'] != 'ALL'){
			if ($data['lp_mssp'] == 'lp_mssp_lokal') {
				$param['mssp'] ='Lokal';
				$query .= ' and mssp_jenis="L"';
			} else if ($data['lp_mssp'] == 'lp_mssp_import') {
				$param['mssp'] ='Import';
				$query .= ' and mssp_jenis="I"';
			} else if ($data['lp_mssp'] == 'lp_mssp_sel'){
				$query .= ' and mssp_no = "'. $data['lp_mssp_no']. '"';
				$param['mssp'] = $data['lp_mssp_nm'];
			} else {
				$param['mssp'] ='ALL';	
			}
		} else {
			$param['mssp'] ='ALL';
		}

		//filter by tipe data (F/C)
		if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
			$query .= ' AND trpo_fin = "'. $data['lp_trju_fin'].'"';
			$param['trju_fin'] = $data['lp_trju_fin'];
		} else $param['trju_fin'] = "ALL";

		//filter by gudang
		if($data['lp_msgd'] != "lp_msgd_all"){
			$query .= ' And trid_msgd_no = "'.$data['lp_msgd_no'].'"';
			$param['msgd_no'] = $data['lp_msgd_no'];
		}else{
			$param['msgd_no'] = "ALL";
		}

		$query .= ' ORDER BY (Convert(trid_tgl,Date)), trid_no ASC';
	
		return array('query' => $query, 'param' => $param);	
	}

	public function get_lp_faktur_penj($data){
		if ($data['judul_laporan'] == "lp_faktur_penj_det"){
			// round((trsd_total*100/110),4) as dpp, 
			// round((trsr_total*100/110),4) as retur_dpp, 

			$query = 'select trsd_no, trsd_tgl, trsd_tglkirim, trsd_tglbalik, trso_pocust, trsd_fakturno, trsd_fakturtgl, trsd_mscs_no, mscs_nm, mscs_jenis, trsd_total,
					trsd_terbayar, mssl_nm, trsd_catatan, trsr_total,
					IFNULL((SELECT SUM(dtsd_bftax * (dtsd_qtykrm - dtsd_qtyrej)) FROM dt_sales_dlv WHERE dtsd_no = trsd_no),0) AS dpp,
					IFNULL((SELECT SUM(dtsr_bftax * dtsr_qtyretur) FROM dt_salesret WHERE dtsr_no = trsr_no),0) AS retur_dpp,
					pbso_tglterima, pbso_tglcair,
					pbso_msjb_no, msjb_nm, pbso_jlhbayar, pbso_catatan
				FROM tr_sales_dlv trsd
				LEFT JOIN tr_so on trso_no = SUBSTRING(trsd_no,1,12) and trso_void=0
				LEFT JOIN ms_customer on mscs_no = trsd_mscs_no
				LEFT JOIN ms_sales on trso_mssl_no = mssl_no
				LEFT JOIN ms_cabang on mscb_no = trsd_mscb_no
				LEFT JOIN ms_gudang on trsd_msgd_no = msgd_no
				LEFT JOIN tr_salesret on trsd_no = substring(trsr_no,1,17) and trsr_void=0
				LEFT JOIN pby_so ON pbso_refno = trsd_no and pbso_void=0
				LEFT JOIN ms_jnspbyr on pbso_msjb_no = msjb_no
				where trsd_void=0  and POSITION(trsd_mscb_no in "'.$data['mscb_listmscb'].'")';

		} elseif ($data['judul_laporan'] == "lp_faktur_penj") 
			{
				// round((trsd_total*100/110),4) as dpp, 
				// round((trsr_total*100/110),4) as retur_dpp,

				$query = 'select trsd_no, trsd_tgl, trsd_tglkirim, trsd_tglbalik, trso_pocust, trsd_fakturno, trsd_fakturtgl, trsd_mscs_no, mscs_nm, mscs_jenis, trsd_total,
							IFNULL((SELECT SUM(dtsd_bftax * (dtsd_qtykrm - dtsd_qtyrej)) FROM dt_sales_dlv WHERE dtsd_no = trsd_no),0) AS dpp,
							IFNULL((SELECT SUM(dtsr_bftax * dtsr_qtyretur) FROM dt_salesret WHERE dtsr_no = trsr_no),0) AS retur_dpp,
							trsd_terbayar, mssl_nm, trsd_catatan, trsr_total
						FROM tr_sales_dlv trsd
						LEFT JOIN tr_so on trso_no = SUBSTRING(trsd_no,1,12) and trso_void=0
						LEFT JOIN ms_customer on mscs_no = trsd_mscs_no
						LEFT JOIN ms_sales on trso_mssl_no = mssl_no
						LEFT JOIN ms_cabang on mscb_no = trsd_mscb_no
						LEFT JOIN ms_gudang on trsd_msgd_no = msgd_no
						LEFT JOIN tr_salesret on trsd_no = substring(trsr_no,1,17) and trsr_void=0
						where trsd_void=0 and POSITION(trsd_mscb_no in "'.$data['mscb_listmscb'].'")';
			}

		//filter by tanggal
		if ($data['lp_trsd_tgl'] == 'lp_trsd_tglsel') {
			$query .= ' and (CONVERT(trsd_tgl, DATE) between "'.$data['lp_trsd_tgl_dari'].'" and "'.$data['lp_trsd_tgl_sampai'].'")';
			$param['periode'] = 'Created Date : '.$data['lp_trsd_tgl_dari'].' s/d '.$data['lp_trsd_tgl_sampai'].'';
		}

		//filter by tanggal
		if ($data['lp_trsd_tgl'] == 'lp_trsd_tglkirim') {
			$query .= ' and trsd_tglkirim between "'.$data['lp_trsd_tglkirim_dari'].'" and "'.$data['lp_trsd_tglkirim_sampai'].'"';
			$param['periode'] = 'Delivery Date : '.$data['lp_trsd_tglkirim_dari'].' s/d '.$data['lp_trsd_tglkirim_sampai'].'';
		}

		//filter by tanggal
		if ($data['lp_trsd_tgl'] == 'lp_trsd_tglconfirm') {
			$query .= ' and trsd_tglbalik between "'.$data['lp_trsd_tglconf_dari'].'" and "'.$data['lp_trsd_tglconf_sampai'].'"';
			$param['periode'] = 'Confirmation Date : '.$data['lp_trsd_tglconf_dari'].' s/d '.$data['lp_trsd_tglconf_sampai'].'';
		}

		//filter by delivery status
		if ($data['lp_sd_dlv_status'] != 'all'){
			if($data['lp_sd_dlv_status'] == 1 ){
				$query .= ' and trsd_tglkirim > 0';
				$param['dlv_status'] = "DLV-Delivered";
			} else if ($data['lp_sd_dlv_status'] == 2){
				$query .= ' and trsd_tglkirim = 0';
				$param['dlv_status'] = "Preparing SO Delivery";
			}
		} else {
			$param['dlv_status'] = "ALL";
		}
		
		//filter by confirm status
		if ($data['lp_sd_conf_status'] != 'all'){
			if($data['lp_sd_conf_status'] == 1 ){
				$query .= ' and trsd_tglbalik > 0';
				$param['conf_status'] = "DLV-Confirmed";
			} else if ($data['lp_sd_conf_status'] == 2){
				$query .= ' and trsd_tglbalik = 0';
				$param['conf_status'] = "DLV-Unconfirm";
			}
		} else {
			$param['conf_status'] ="ALL";
		}

		// filter by mscs (customer)
		if($data['lp_mscs'] != 'lp_mscs_all'){
			if ($data['lp_mscs'] == 'lp_mscs_r') {
				$query .= ' and mscs_jenis="R"';
				$param['mscs'] = 'Retail';
			} else if ($data['lp_mscs'] == 'lp_mscs_a') {
				$query .= ' and mscs_jenis="A"';
				$param['mscs'] = 'Agen';
			} else if ($data['lp_mscs'] == 'lp_mscs_sel'){
				$query .= ' and mscs_no = "'. $data['lp_mscs_no']. '"';
				$param['mscs'] = $data['lp_mscs_nm'];
			} 
		} else {
				$param['mscs'] ='ALL';
				}

		// filter by mssl (sales)
		if($data['lp_mssl'] != 'lp_mssl_all'){
			if ($data['lp_mssl'] == 'lp_mssl_sls') {
				$query .= ' and mssl_divisi="S"';
				$param['mssl'] = 'Salesman';
			} else if ($data['lp_mssl'] == 'lp_mssl_tkn') {
				$query .= ' and mssl_divisi="T"';
				$param['mssl'] = 'Teknisi';
			} else if ($data['lp_mssl'] == 'lp_mssl_sel'){
				$query .= ' and mssl_no = "'. $data['lp_mssl_no']. '"';
				$param['mssl'] = $data['lp_mssl_no'];
			} 
		} else {
				$param['mssl'] ='ALL';
				}

		//filter by tipe data (F/C)
		if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
			$query .= ' AND trso_fin = "'. $data['lp_trju_fin'].'"';
			$param['trju_fin'] = $data['lp_trju_fin'];
		} else $param['trju_fin'] = "ALL";

		//filter by gudang
		if($data['lp_msgd'] != "lp_msgd_all"){
			$query .= ' And trsd_msgd_no = "'.$data['lp_msgd_no'].'"';
			$param['msgd_no'] = $data['lp_msgd_no'];
		}else{
			$param['msgd_no'] = "ALL";
		}

		$query .= ' ORDER BY (Convert(trsd_tgl,Date)), trsd_no ASC';
	
		return array('query' => $query, 'param' => $param);		
	}

	public function get_lp_ringkasan_harga_jual_produk($data){
		$query = 'Select dtsd_no, trsd_tgl, trsd_tglkirim, trsd_tglbalik, trso_pocust, trsd_mscs_no,
					mscs_nm, mscs_jenis, dtsd_mspd_no, mspd_nm, (dtsd_qtykrm-dtsd_qtyrej) as qty, dtsd_bftax, mssl_nm, trsd_catatan
				FROM dt_sales_dlv
				LEFT JOIN tr_sales_dlv on dtsd_no = trsd_no
				LEFT JOIN tr_so on trso_no = SUBSTRING(trsd_no,1,12) and trso_void=0 
				LEFT JOIN ms_produk on dtsd_mspd_no = mspd_no
				LEFT JOIN ms_customer on mscs_no = trsd_mscs_no 
				LEFT JOIN ms_sales on trso_mssl_no = mssl_no 
				WHERE trsd_void=0 AND POSITION(trsd_mscb_no in "'.$data['mscb_listmscb'].'")';

		//filter by tanggal
		if ($data['lp_trsd_tgl'] == 'lp_trsd_tglsel') {
			$query .= ' and (CONVERT(trsd_tgl, DATE) between "'.$data['lp_trsd_tgl_dari'].'" and "'.$data['lp_trsd_tgl_sampai'].'")';
			$param['periode'] = 'Created Date : '.$data['lp_trsd_tgl_dari'].' s/d '.$data['lp_trsd_tgl_sampai'].'';
		}

		//filter by tanggal
		if ($data['lp_trsd_tgl'] == 'lp_trsd_tglkirim') {
			$query .= ' and trsd_tglkirim between "'.$data['lp_trsd_tglkirim_dari'].'" and "'.$data['lp_trsd_tglkirim_sampai'].'"';
			$param['periode'] = 'Delivery Date : '.$data['lp_trsd_tglkirim_dari'].' s/d '.$data['lp_trsd_tglkirim_sampai'].'';
		}

		//filter by tanggal
		if ($data['lp_trsd_tgl'] == 'lp_trsd_tglconfirm') {
			$query .= ' and trsd_tglbalik between "'.$data['lp_trsd_tglconf_dari'].'" and "'.$data['lp_trsd_tglconf_sampai'].'"';
			$param['periode'] = 'Confirmation Date : '.$data['lp_trsd_tglconf_dari'].' s/d '.$data['lp_trsd_tglconf_sampai'].'';
		}

		//filter by delivery status
		if ($data['lp_sd_dlv_status'] != 'all'){
			if($data['lp_sd_dlv_status'] == 1 ){
				$query .= ' and trsd_tglkirim > 0';
				$param['dlv_status'] = "DLV-Delivered";
			} else if ($data['lp_sd_dlv_status'] == 2){
				$query .= ' and trsd_tglkirim = 0';
				$param['dlv_status'] = "Preparing SO Delivery";
			}
		} else {
			$param['dlv_status'] = "ALL";
		}
		
		//filter by confirm status
		if ($data['lp_sd_conf_status'] != 'all'){
			if($data['lp_sd_conf_status'] == 1 ){
				$query .= ' and trsd_tglbalik > 0';
				$param['conf_status'] = "DLV-Confirmed";
			} else if ($data['lp_sd_conf_status'] == 2){
				$query .= ' and trsd_tglbalik = 0';
				$param['conf_status'] = "DLV-Unconfirm";
			}
		} else {
			$param['conf_status'] ="ALL";
		}

		// filter by mscs (customer)
		if($data['lp_mscs'] != 'lp_mscs_all'){
			if ($data['lp_mscs'] == 'lp_mscs_r') {
				$query .= ' and mscs_jenis="R"';
				$param['mscs'] = 'Retail';
			} else if ($data['lp_mscs'] == 'lp_mscs_a') {
				$query .= ' and mscs_jenis="A"';
				$param['mscs'] = 'Agen';
			} else if ($data['lp_mscs'] == 'lp_mscs_sel'){
				$query .= ' and mscs_no = "'. $data['lp_mscs_no']. '"';
				$param['mscs'] = $data['lp_mscs_nm'];
			} 
		} else {
				$param['mscs'] ='ALL';
				}

		// filter by mssl (sales)
		if($data['lp_mssl'] != 'lp_mssl_all'){
			if ($data['lp_mssl'] == 'lp_mssl_sls') {
				$query .= ' and mssl_divisi="S"';
				$param['mssl'] = 'Salesman';
			} else if ($data['lp_mssl'] == 'lp_mssl_tkn') {
				$query .= ' and mssl_divisi="T"';
				$param['mssl'] = 'Teknisi';
			} else if ($data['lp_mssl'] == 'lp_mssl_sel'){
				$query .= ' and mssl_no = "'. $data['lp_mssl_no']. '"';
				$param['mssl'] = $data['lp_mssl_no'];
			} 
		} else {
				$param['mssl'] ='ALL';
				}

		//filter by tipe data (F/C)
		if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
			$query .= ' AND trso_fin = "'. $data['lp_trju_fin'].'"';
			$param['trju_fin'] = $data['lp_trju_fin'];
		} else $param['trju_fin'] = "ALL";

		//filter by gudang
		if($data['lp_msgd'] != "lp_msgd_all"){
			$query .= ' And trsd_msgd_no = "'.$data['lp_msgd_no'].'"';
			$param['msgd_no'] = $data['lp_msgd_no'];
		}else{
			$param['msgd_no'] = "ALL";
		}

		$query .= ' ORDER BY (Convert(trsd_tgl,Date)), trsd_no ASC';
	
		return array('query' => $query, 'param' => $param);				
	}

	public function print_faktur_negara($data){
		$inserttemp = 'INSERT INTO tmp_faktur_negara_gabung(
						tfng_idlap,
						tfng_mspd_no,
						tfng_qty,
						tfng_total_bftax,
						tfng_total_tax
						) ';

		$count_dlv = count($data['sales_dlv']);
		for($i=0; $i<$count_dlv; $i++){
			$insert = $inserttemp. 
						'(SELECT "'.$data['tfng_idlap'].'", dtsd_mspd_no, dtsd_qtykrm-dtsd_qtyrej as qty, 
							dtsd_bftax * (dtsd_qtykrm-dtsd_qtyrej),
							dtsd_tax * (dtsd_qtykrm-dtsd_qtyrej)
							FROM dt_sales_dlv
							WHERE dtsd_no = "'.$data['sales_dlv'][$i].'"
							AND dtsd_statuspaket != "K"
							HAVING qty > 0)';
			
			$this->db->simple_query($insert);
		}

		$count_spk = count($data['spk']);
		for($i=0; $i<$count_spk; $i++){
			$insert = $inserttemp.
						'(SELECT "'.$data['tfng_idlap'].'", dtspk_mspd_no, dtspk_qty as qty, 
							dtspk_bftax * dtspk_qty,
							dtspk_tax * dtspk_qty
							FROM dt_spk_sp
							WHERE dtspk_no = "'.$data['spk'][$i].'"
							AND dtspk_statuspaket != "K"
							HAVING qty > 0 )';
			
			$this->db->simple_query($insert);
		}

		$query = 'SELECT tfng_mspd_no, mspd_nm, sum(tfng_qty) as qty
						, FLOOR(sum(tfng_total_bftax)) as total
						, FLOOR(sum(tfng_total_tax)) as tottax
				FROM tmp_faktur_negara_gabung
				LEFT JOIN ms_produk on tfng_mspd_no = mspd_no
				WHERE tfng_idlap = "'.$data['tfng_idlap'].'"
				GROUP BY tfng_mspd_no';

		return $query;
	}

	public function delete_datatemp_bayrand_tfng($rand){
		$this->db->delete('tmp_faktur_negara_gabung', array('tfng_idlap' => $rand));
	}

	public function inserto_tmp_lap_spk($data){

		// delete data temp
		$this->delete_datatemp_bayrand_tls($data['tls_idlap']);
		
    	$inserttemp = 'INSERT INTO tmp_lap_spk(
					tls_idlap,
					tls_ref_jns,
					tls_ref_no,
					tls_ref_v_tglrncnvisitfrom,
					tls_ref_v_tglrncnvisituntil,
					tls_ref_v_tglvisitfrom,
					tls_ref_v_tglvisituntil,
					tls_ref_v_mssl_no,
					tls_ref_v_mssl_nm,
					tls_ref_v_catatan,
					tls_ref_v_kesimpulan,
					tls_ref_v_ketkonfirmasi,
					tls_ref_s_mspd_no,
					tls_ref_s_mspd_nm,
					tls_ref_s_qty,
					tls_ref_s_nett,
					tls_ref_s_hpp,
					tls_ref_a_msap_no,
					tls_ref_a_msap_nm,
					tls_ref_a_total
					) ';
		
					
		// Tahap 1 - Insert Query Data dari SPK VISIT (TR_SPK_VISIT) ===============================================================================================
		$query = $inserttemp
					.'(SELECT '.$data['tls_idlap'].', "V", trsv_no, trsv_tglrncnvisitfrom, trsv_tglrncnvisituntil, trsv_tglvisitfrom,
						trsv_tglvisituntil, trsv_mssl_no, mssl_nm, trsv_catatan, trsv_kesimpulan, trsv_ketkonfirmasi,
						"", "", "", "", "", "", "", ""
					FROM tr_spk_visit
					LEFT JOIN ms_sales on mssl_no = trsv_mssl_no
					LEFT JOIN tr_spk on trspk_no = substring(trsv_no,1,12) and trspk_void=0
					WHERE POSITION(trsv_mscb_no in "'.$data['mscb_listmscb'].'")
					AND trsv_void = 0';

			// filter  =========================================================================
				// filter by tgl spk
					if ($data['lp_trspk_tgl'] == "lp_tglspk_sel"){
						$query .= ' AND (Convert(trspk_tgl,Date) between "'.$data['lp_trspk_tgl_dari'].'" and "'.$data['lp_trspk_tgl_sampai'].'")';
					}elseif ($data['lp_trspk_tgl'] == "lp_tglspk_finish_sel"){
						$query .= ' AND trspk_tglselesai between "'.$data['lp_trspk_tglfinish_dari'].'" and "'.$data['lp_trspk_tglfinish_sampai'].'"';
					}
					
				// filter by mssl (sales)
				if($data['lp_mssl_sel'] != 'lp_mssl_all'){
					if ($data['lp_mssl_sel'] == 'lp_mssl_sls') {
						$query .= ' and mssl_divisi="S"';
						$param['mssl_nm'] = "Salesman";
						$param['mssl_no'] = "";
					} else if ($data['lp_mssl_sel'] == 'lp_mssl_tkn') {
						$query .= ' and mssl_divisi="T"';
						$param['mssl_nm'] = "Teknisi";
						$param['mssl_no'] = "";
					} else if ($data['lp_mssl_sel'] == 'lp_mssl_sel'){
						$query .= ' and trsv_mssl_no = "'. $data['mssl_no'].'"';
						$param['mssl_nm'] = trim($data['mssl'][1]);
						$param['mssl_no'] = $data['mssl_no'];
						} 
				} else {
					$param['mssl_nm'] = "ALL";
					$param['mssl_no'] = "ALL";
						}

			$query .= ')';
			$this->db->simple_query($query);

			// Tahap 2 - Insert Query Data dari DETAIL AKUN PERKIRAAN SPK (dt_spk_accper) ===============================================================================================
			$query = $inserttemp
					.'(SELECT "'.$data['tls_idlap'].'", "A", dtspkap_no, "", "", "", "", "", "", "", "", "",
						"", "", "", "", "", dtspkap_msap_no, msap_nm, dtspkap_total
					FROM dt_spk_accper
					LEFT JOIN tr_spk on trspk_no = dtspkap_no
					LEFT JOIN ms_accper on dtspkap_msap_no = msap_no
					WHERE trspk_void = 0';

			// filter =========================================================================
				// filter by tgl spk
					if ($data['lp_trspk_tgl'] == "lp_tglspk_sel"){
						$query .= ' AND (Convert(trspk_tgl,Date) between "'.$data['lp_trspk_tgl_dari'].'" and "'.$data['lp_trspk_tgl_sampai'].'")';
					}elseif ($data['lp_trspk_tgl'] == "lp_tglspk_finish_sel"){
						$query .= ' AND trspk_tglselesai between "'.$data['lp_trspk_tglfinish_dari'].'" and "'.$data['lp_trspk_tglfinish_sampai'].'"';
					}
			$query .= ')';
			$this->db->simple_query($query);

			// Tahap 3 - Insert Query Data dari DETAIL SPAREPART SPK (dt_spk_sp) ===============================================================================================
			$query = $inserttemp
					.'(SELECT "'.$data['tls_idlap'].'", "S", dtspk_no, "", "", "", "", "", "", "", "", "",
						dtspk_mspd_no, mspd_nm, dtspk_qty, dtspk_nett, dtspk_hpp, "", "", ""
					FROM dt_spk_sp
					LEFT JOIN tr_spk on trspk_no = dtspk_no
					LEFT JOIN ms_produk on mspd_no = dtspk_mspd_no
					WHERE trspk_void = 0';
			
			// filter  =========================================================================
				// filter by tgl spk
					if ($data['lp_trspk_tgl'] == "lp_tglspk_sel"){
						$query .= ' AND (Convert(trspk_tgl,Date) between "'.$data['lp_trspk_tgl_dari'].'" and "'.$data['lp_trspk_tgl_sampai'].'")';
					}elseif ($data['lp_trspk_tgl'] == "lp_tglspk_finish_sel"){
						$query .= ' AND trspk_tglselesai between "'.$data['lp_trspk_tglfinish_dari'].'" and "'.$data['lp_trspk_tglfinish_sampai'].'"';
					}

					$query .= ')';

			$this->db->simple_query($query);
	}

	public function get_lp_spk($data){
		// Tahap 3 - SELECT QUERY tabel tr_spk left join tmp_lap_spk between tanggal dari - tgl sampai
		if($data['judul_laporan'] == "lp_spk_sn_by_sd"){
			$query = 'select trsd_no, dtsd_mspd_no, trsd_tgl, dtsd_noserial, trspk_no, trspk_tgl, trspk_tglselesai, trspk_msus_no, msus_nm, trspk_mscs_no, mscs_nm, trspk_jnsservis, trspk_garansisp, trspk_biayaservis,
					trspk_garansijasa, trspk_fin, trspk_msgd_no, msgd_nm, trspk_mspd_no, mspd_nm, trspk_noserial, trspk_keluhan, trspk_catatan,
					tls_ref_jns, tls_ref_no, tls_ref_v_tglrncnvisitfrom, tls_ref_v_tglrncnvisituntil, 
					tls_ref_v_tglvisitfrom, tls_ref_v_tglvisituntil, tls_ref_v_mssl_no,
					tls_ref_v_mssl_nm, tls_ref_v_catatan, tls_ref_v_kesimpulan, tls_ref_v_ketkonfirmasi, tls_ref_s_mspd_no,
					tls_ref_s_mspd_nm, tls_ref_s_qty, tls_ref_s_nett, tls_ref_s_hpp, tls_ref_a_msap_no, tls_ref_a_msap_nm, tls_ref_a_total
				FROM dt_sales_dlv
				LEFT JOIN tr_sales_dlv on dtsd_no = trsd_no
				LEFT JOIN tr_spk on trspk_noserial = dtsd_noserial and trspk_void=0 
				LEFT JOIN tmp_lap_spk on trspk_no = substring(tls_ref_no,1,12) and tls_idlap="'.$data['tls_idlap'].'"
				LEFT JOIN ms_produk on mspd_no = dtsd_mspd_no
				LEFT JOIN ms_customer on mscs_no = trspk_mscs_no
				LEFT JOIN ms_gudang on trspk_msgd_no = msgd_no
				LEFT JOIN ms_sales on mssl_no = tls_ref_v_mssl_no
				LEFT JOIN ms_user on msus_no = trspk_msus_no
				where trsd_void=0 and POSITION(trsd_mscb_no in "'.$data['mscb_listmscb'].'") and substring(dtsd_mspd_no,1,1)="M" and dtsd_noserial !=""
				';
			}else {
				$query = 'select trspk_no, trspk_tgl, trspk_tglselesai, trspk_msus_no, msus_nm, trspk_mscs_no, mscs_nm, trspk_jnsservis, trspk_garansisp, trspk_biayaservis,
					trspk_garansijasa, trspk_fin, trspk_msgd_no, msgd_nm, trspk_mspd_no, mspd_nm, trspk_noserial, trspk_keluhan, trspk_catatan,
					tls_ref_jns, tls_ref_no, tls_ref_v_tglrncnvisitfrom, tls_ref_v_tglrncnvisituntil, 
					tls_ref_v_tglvisitfrom, tls_ref_v_tglvisituntil, tls_ref_v_mssl_no,
					tls_ref_v_mssl_nm, tls_ref_v_catatan, tls_ref_v_kesimpulan, tls_ref_v_ketkonfirmasi, tls_ref_s_mspd_no,
					tls_ref_s_mspd_nm, tls_ref_s_qty, tls_ref_s_nett, tls_ref_s_hpp, tls_ref_a_msap_no, tls_ref_a_msap_nm, tls_ref_a_total
				FROM tr_spk
				LEFT JOIN tmp_lap_spk on trspk_no = substring(tls_ref_no,1,12) and tls_idlap="'.$data['tls_idlap'].'"
				LEFT JOIN ms_produk on mspd_no = trspk_mspd_no
				LEFT JOIN ms_customer on mscs_no = trspk_mscs_no
				LEFT JOIN ms_gudang on trspk_msgd_no = msgd_no
				LEFT JOIN ms_sales on mssl_no = tls_ref_v_mssl_no
				LEFT JOIN ms_user on msus_no = trspk_msus_no
				where trspk_void=0 and POSITION(trspk_mscb_no in "'.$data['mscb_listmscb'].'")
				';	
			}
  
		if($data['judul_laporan'] == "lp_spk_sn"){
			$query .= ' and trspk_mspd_no != "" and trspk_noserial != ""';
				//filter by Serial Number
				if($data['lp_sn'] != "lp_sn_all"){
					if($data['lp_sn'] == "lp_sn_sel"){
						$query .= ' AND trspk_noserial like "%'.$data['lp_sn_no'].'%"';
					}
				}
		}
		
		// filter  ===================================================================================================================================
			// filter by tgl spk
				if ($data['lp_trspk_tgl'] == "lp_tglspk_sel"){
					if($data['judul_laporan'] == "lp_spk_sn_by_sd"){
						$query .= ' AND (Convert(trsd_tgl,Date) between "'.$data['lp_trspk_tgl_dari'].'" and "'.$data['lp_trspk_tgl_sampai'].'")';
						$param['tgl_dari'] = $data['lp_trspk_tgl_dari'];
						$param['tgl_sampai'] = $data['lp_trspk_tgl_sampai'];
					}else {
						$query .= ' AND (Convert(trspk_tgl,Date) between "'.$data['lp_trspk_tgl_dari'].'" and "'.$data['lp_trspk_tgl_sampai'].'")';
						$param['tgl_dari'] = $data['lp_trspk_tgl_dari'];
						$param['tgl_sampai'] = $data['lp_trspk_tgl_sampai'];
					}
					
				}elseif ($data['lp_trspk_tgl'] == "lp_tglspk_finish_sel"){
					$query .= ' AND trspk_tglselesai between "'.$data['lp_trspk_tglfinish_dari'].'" and "'.$data['lp_trspk_tglfinish_sampai'].'"';
					$param['tgl_dari'] = $data['lp_trspk_tglfinish_dari'];
					$param['tgl_sampai'] = $data['lp_trspk_tglfinish_sampai'];
				}
				
			// filter by mspd_no
			if($data['lp_mspd'] != 'ALL'){
					if($data['lp_mspd'] == 'lp_mspd_sel'){
						$param['mspd_no'] = $data['lp_mspd_no_sel'];
						$param['mspd_nm'] = $data['lp_mspd_nm'];					
						$query .= ' and mspd_no = "'. $data['lp_mspd_no_sel']. '"';
					}else if($data['lp_mspd'] == 'lp_mspd_con'){
						$param['mspd_no'] = '';
						$param['mspd_nm'] = $data['lp_mspd_nm_con'];					
						if($data['lp_mspd_nm_con'] != ''){
							$query .= ' and mspd_nm LIKE "%'. $data['lp_mspd_nm_con']. '%"';
						}
					} else {
						$param['mspd_no'] = 'ALL';
						$param['mspd_nm'] = 'ALL';
					}
				}
				

				// filter by mscs (customer)
				if($data['lp_mscs'] != 'lp_mscs_all'){
					if ($data['lp_mscs'] == 'lp_mscs_r') {
						$query .= ' and mscs_jenis="R"';
						$param['mscs_nm'] = "RETAIL";
						$param['mscs_no'] = "";
					} else if ($data['lp_mscs'] == 'lp_mscs_a') {
						$query .= ' and mscs_jenis="A"';
						$param['mscs_nm'] = "AGENT";
						$param['mscs_no'] = "";
					} else if ($data['lp_mscs'] == 'lp_mscs_sel'){
						$param['mscs_nm'] = $data['lp_mscs_nm'];
						$param['mscs_no'] = $data['lp_mscs_no'];
						$query .= ' and trspk_mscs_no = "'.$data['lp_mscs_no'].'"';
					} 
				} else {
					$param['mscs_nm'] = "ALL";
					$param['mscs_no'] = "ALL";
						}

			// filter by mssl (sales)
				if($data['lp_mssl_sel'] != 'lp_mssl_all'){
					if ($data['lp_mssl_sel'] == 'lp_mssl_sls') {
						$query .= ' and mssl_divisi="S"';
						$param['mssl_nm'] = "Salesman";
						$param['mssl_no'] = "";
					} else if ($data['lp_mssl_sel'] == 'lp_mssl_tkn') {
						$query .= ' and mssl_divisi="T"';
						$param['mssl_nm'] = "Teknisi";
						$param['mssl_no'] = "";
					} else if ($data['lp_mssl_sel'] == 'lp_mssl_sel'){
						$query .= ' and mssl_no = "'. $data['mssl_no'].'"';
						$param['mssl_nm'] = trim($data['mssl'][1]);
						$param['mssl_no'] = $data['mssl_no'];
						} 
				} else {
					$param['mssl_nm'] = "ALL";
					$param['mssl_no'] = "ALL";
						}

				
			//filter by service type
			if($data['lp_servicetype'] != "ALL"){
				if($data['lp_servicetype'] == 1){
					$query .= ' AND trspk_jnsservis = "PEMASANGAN"';
					$param['servicetype'] = "PEMASANGAN";
				}else if ($data['lp_servicetype'] == 2){
					$query .= ' AND trspk_jnsservis = "PERBAIKAN"';
					$param['servicetype'] = "PERBAIKAN";
				}else if ($data['lp_servicetype'] == 3){
					$query .= ' AND trspk_jnsservis = "PELATIHAN"';
					$param['servicetype'] = "PELATIHAN";
				}else if ($data['lp_servicetype'] == 4){
					$query .= ' AND trspk_jnsservis = "SURVEY"';
					$param['servicetype'] = "SURVEY";
				}
			} else $param['servicetype'] = "ALL";


			//filter by finish status
			if($data['lp_finishstatus'] != "ALL"){
				if($data['lp_finishstatus'] == 1){
					$query .= ' AND trspk_tglselesai <> 0';
					$param['finishstatus'] = "Finish";
				}else if ($data['lp_finishstatus'] == 2){
					$query .= ' AND trspk_tglselesai = 0';
					$param['finishstatus'] = "Unfinish";
				}
			} else $param['finishstatus'] = "ALL";

			//filter by payment status
			if($data['lp_paymentstatus'] != "ALL"){
				if($data['lp_paymentstatus'] == 1){
					$query .= ' AND IFNULL((SELECT SUM(pbspk_jlhbayar) 
									FROM pby_spk 
									WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0)
							 		>= 
								IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) 
									FROM dt_spk_sp 
									WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0)';
					$param['lp_paymentstatus'] = "Settled";
				}else if ($data['lp_paymentstatus'] == 2){
					$query .= ' AND (NOT(IFNULL((SELECT SUM(pbspk_jlhbayar) 
									FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0) 
									>= 
								IFNULL((SELECT SUM(dtspk_nett * dtspk_qty)
									FROM dt_spk_sp WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0)))';

					$param['lp_paymentstatus'] = "unsettled";
				}
			} else $param['lp_paymentstatus'] = "ALL";

			//filter by sparepart warranty
			if($data['sp_warranty'] != "All"){
				if($data['sp_warranty'] == "Y"){
					$query .= ' AND trspk_garansisp = "Y"';
					$param['sp_warranty'] = "Yes";
				}else if ($data['sp_warranty'] == "N"){
					$query .= ' AND trspk_garansisp = "N"';
					$param['sp_warranty'] = "No";
				} 
			} else $param['sp_warranty'] = "ALL";

			//filter by service warranty
			if($data['svc_warranty'] != "All"){
				if($data['svc_warranty'] == "Y"){
					$query .= ' AND trspk_garansijasa = "Y"';
					$param['svc_warranty'] = "Yes";
				}else if ($data['svc_warranty'] == "N"){
					$query .= ' AND trspk_garansijasa = "N"';
					$param['svc_warranty'] = "No";
				} 
			} else $param['svc_warranty'] = "ALL";

			// Filter by tipe data F/C
			if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
					$query .= ' AND trspk_fin = "'. $data['lp_trju_fin'].'"';
					$param['trju_fin'] =  $data['lp_trju_fin'];
				} else {
					$param['trju_fin'] = "ALL";
				}

		
		if($data['judul_laporan'] == "lp_spk_sn"){
			$query .= ' order by trspk_mspd_no, trspk_noserial, trspk_tgl, trspk_no, tls_ref_jns';
		} else {
			$query .= ' order by trspk_tgl, trspk_no, tls_ref_jns';
		}
			
		return array('query' => $query, 'param' => $param);
	}

	public function delete_datatemp_bayrand_tls($rand){
		$this->db->delete('tmp_lap_spk', array('tls_idlap' => $rand));
	}

	public function get_lp_spk_ringkasan($data){
		$query = 'Select trspk_no, trspk_tgl, trspk_tglselesai, trspk_msus_no, msus_nm, trspk_mscs_no, mscs_nm, trspk_fakturtgl, trspk_fakturno, trspk_jnsservis, trspk_garansisp, 
					trspk_garansijasa, sum(tls_ref_s_qty*tls_ref_s_nett) as total, ifnull(pby.paid,0) as paid, 
					tls_ref_v_mssl_nm, trspk_catatan
					FROM tr_spk
					LEFT JOIN tmp_lap_spk on trspk_no = substring(tls_ref_no,1,12) and tls_idlap="'.$data['tls_idlap'].'"
					LEFT JOIN ms_customer on mscs_no = trspk_mscs_no
					LEFT JOIN ms_user on msus_no = trspk_msus_no
					LEFT JOIN (select pbspk_no, sum(pbspk_jlhbayar) as paid
                               	FROM pby_spk
                               	WHERE pbspk_void = "0"
                              GROUP BY substring(pbspk_no,1,12))
                    pby on substring(pby.pbspk_no,1,12) = trspk_no
					WHERE trspk_void=0 and POSITION(trspk_mscb_no in "'.$data['mscb_listmscb'].'")';
				 	

        // FILTER ======================================================================================================================================
        // filter by tgl spk
		if ($data['lp_trspk_tgl'] == "lp_tglspk_sel"){
			$query .= ' AND (Convert(trspk_tgl,Date) between "'.$data['lp_trspk_tgl_dari'].'" and "'.$data['lp_trspk_tgl_sampai'].'")';
			$param['tgl'] = "Tanggal Create";
			$param['tgl_dari'] = $data['lp_trspk_tgl_dari'];
			$param['tgl_sampai'] = $data['lp_trspk_tgl_sampai'];
		}else {
			$query .= ' AND trspk_tglselesai between "'.$data['lp_trspk_tglfinish_dari'].'" and "'.$data['lp_trspk_tglfinish_sampai'].'"';
			$param['tgl'] = "Tanggal Finish";
			$param['tgl_dari'] = $data['lp_trspk_tglfinish_dari'];
			$param['tgl_sampai'] = $data['lp_trspk_tglfinish_sampai'];
		}

		//filter by sparepart warranty
		if($data['sp_warranty'] != "All"){
			if($data['sp_warranty'] == "Y"){
				$query .= ' AND trspk_garansisp = "Y"';
				$param['sp_warranty'] = "Yes";
			}else if ($data['sp_warranty'] == "N"){
				$query .= ' AND trspk_garansisp = "N"';
				$param['sp_warranty'] = "No";
			} 
		} else $param['sp_warranty'] = "ALL";

		//filter by service warranty
		if($data['svc_warranty'] != "All"){
			if($data['svc_warranty'] == "Y"){
				$query .= ' AND trspk_garansijasa = "Y"';
				$param['svc_warranty'] = "Yes";
			}else if ($data['svc_warranty'] == "N"){
				$query .= ' AND trspk_garansijasa = "N"';
				$param['svc_warranty'] = "No";
			} 
		} else $param['svc_warranty'] = "ALL";

		//filter by finish status
		if($data['lp_finishstatus'] != "ALL"){
			if($data['lp_finishstatus'] == 1){
				$query .= ' AND trspk_tglselesai <> 0';
				$param['finishstatus'] = "Finish";
			}else if ($data['lp_finishstatus'] == 2){
				$query .= ' AND trspk_tglselesai = 0';
				$param['finishstatus'] = "Unfinish";
			}
		} else $param['finishstatus'] = "ALL";

		//filter by service type
		if($data['lp_servicetype'] != "ALL"){
			if($data['lp_servicetype'] == 1){
				$query .= ' AND trspk_jnsservis = "PEMASANGAN"';
				$param['servicetype'] = "PEMASANGAN";
			}else if ($data['lp_servicetype'] == 2){
				$query .= ' AND trspk_jnsservis = "PERBAIKAN"';
				$param['servicetype'] = "PERBAIKAN";
			}else if ($data['lp_servicetype'] == 3){
				$query .= ' AND trspk_jnsservis = "PELATIHAN"';
				$param['servicetype'] = "PELATIHAN";
			}else if ($data['lp_servicetype'] == 4){
				$query .= ' AND trspk_jnsservis = "SURVEY"';
				$param['servicetype'] = "SURVEY";
			}
		} else $param['servicetype'] = "ALL";

		//filter by payment status
		if($data['lp_paymentstatus'] != "ALL"){
			if($data['lp_paymentstatus'] == 1){
				$query .= ' AND IFNULL((SELECT SUM(pbspk_jlhbayar) 
								FROM pby_spk 
								WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0)
						 		>= 
							IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) 
								FROM dt_spk_sp 
								WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0)';
				$param['lp_paymentstatus'] = "Settled";
			}else if ($data['lp_paymentstatus'] == 2){
				$query .= ' AND (NOT(IFNULL((SELECT SUM(pbspk_jlhbayar) 
								FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0) 
								>= 
							IFNULL((SELECT SUM(dtspk_nett * dtspk_qty)
								FROM dt_spk_sp WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0)))';

				$param['lp_paymentstatus'] = "unsettled";
			}
		} else $param['lp_paymentstatus'] = "ALL";



		// filter by mscs (customer)
		if($data['lp_mscs'] != 'lp_mscs_all'){
			if ($data['lp_mscs'] == 'lp_mscs_r') {
				$query .= ' and mscs_jenis="R"';
				$param['mscs_nm'] = "RETAIL";
				$param['mscs_no'] = "";
			} else if ($data['lp_mscs'] == 'lp_mscs_a') {
				$query .= ' and mscs_jenis="A"';
				$param['mscs_nm'] = "AGENT";
				$param['mscs_no'] = "";
			} else if ($data['lp_mscs'] == 'lp_mscs_sel'){
				$param['mscs_nm'] = $data['lp_mscs_nm'];
				$param['mscs_no'] = $data['lp_mscs_no'];
				$query .= ' and trspk_mscs_no = "'.$data['lp_mscs_no'].'"';
			} 
		} else {
			$param['mscs_nm'] = "ALL";
			$param['mscs_no'] = "ALL";
				}

		// Filter by tipe data F/C
		if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
				$query .= ' AND trspk_fin = "'. $data['lp_trju_fin'].'"';
				$param['trju_fin'] =  $data['lp_trju_fin'];
			} else {
				$param['trju_fin'] = "ALL";
			}

		
		$query .= ' GROUP BY trspk_no
                 	ORDER BY trspk_tgl, trspk_no, tls_ref_jns';

        return array('query' => $query, 'param' => $param);
	}

	public function get_lp_spk_payment($data){
		$query = 'Select trspk_mscs_no, mscs_nm, pbspk_no, pbspk_tglterima, pbspk_tglcair, pbspk_catatan, 
					pbspk_msjb_no, msjb_nm, trspk_no, trspk_tgl, pbspk_jlhbayar
					FROM `pby_spk`
					LEFT JOIN tr_spk on trspk_no = substring(pbspk_no,1,12) and trspk_void=0 
					LEFT JOIN ms_customer on mscs_no = trspk_mscs_no
					LEFT JOIN ms_jnspbyr on msjb_no = pbspk_msjb_no
					WHERE pbspk_void = 0 and POSITION(trspk_mscb_no in "'.$data['mscb_listmscb'].'")';

		//FILTER ================================================================================================================================
		//Filter by tgl
		if($data['lp_pbspk_tgl'] == "lp_pbspk_trma"){
			$query .= ' AND (Convert(pbspk_tglterima,Date) between "'.$data['lp_pbspk_tgl_dari'].'" and "'.$data['lp_pbspk_tgl_sampai'].'")';
			$param['tgl'] = "Tanggal Terima";
			$param['tgl_dari'] = $data['lp_pbspk_tgl_dari'];
			$param['tgl_sampai'] = $data['lp_pbspk_tgl_sampai'];
		}else{
			$query .= ' AND pbspk_tglcair between "'.$data['lp_pbspk_cair_tgl_dari'].'" and "'.$data['lp_pbspk_cair_tgl_sampai'].'"';
			$param['tgl'] = "Tanggal Cair";
			$param['tgl_dari'] = $data['lp_pbspk_cair_tgl_dari'];
			$param['tgl_sampai'] = $data['lp_pbspk_cair_tgl_sampai'];
		}

		//filter by jenis bayar
		if($data['lp_msjb'] != "lp_msjb_all"){
			$query .= ' and pbspk_msjb_no = '.$data['lp_msjb_no'];
			$param['jenis_bayar'] = trim($data['msjb_no'][1]);
		} else {
			$param['jenis_bayar'] = 'ALL';
		}

		// filter by mscs (customer)
		if($data['lp_mscs'] != 'lp_mscs_all'){
			if ($data['lp_mscs'] == 'lp_mscs_r') {
				$query .= ' and mscs_jenis="R"';
				$param['mscs_nm'] = "RETAIL";
				$param['mscs_no'] = "";
			} else if ($data['lp_mscs'] == 'lp_mscs_a') {
				$query .= ' and mscs_jenis="A"';
				$param['mscs_nm'] = "AGENT";
				$param['mscs_no'] = "";
			} else if ($data['lp_mscs'] == 'lp_mscs_sel'){
				$param['mscs_nm'] = $data['lp_mscs_nm'];
				$param['mscs_no'] = $data['lp_mscs_no'];
				$query .= ' and trspk_mscs_no = "'.$data['lp_mscs_no'].'"';
			} 
		} else {
			$param['mscs_nm'] = "ALL";
			$param['mscs_no'] = "ALL";
				}

		// Filter by tipe data F/C
		if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
				$query .= ' AND trspk_fin = "'. $data['lp_trju_fin'].'"';
				$param['trju_fin'] =  $data['lp_trju_fin'];
			} else {
				$param['trju_fin'] = "ALL";
			}

		$query .= ' ORDER BY pbspk_tglterima, pbspk_tglcair, pbspk_no, trspk_no';

		return array('query' => $query, 'param' => $param);
	}

	public function get_tmp_so_top_dlv($data){
		
    	$inserttemp = 'INSERT INTO tmp_so_top_dlv(
					tstd_idlap,
					tstd_ref_jns,
					tstd_ref_no,
					tstd_ref_t_tgljatuhtempo,
					tstd_ref_t_value,
					tstd_ref_t_cttn,
					tstd_ref_t_status,
					tstd_ref_d_tgl,
					tstd_ref_d_tglkirim,
					tstd_ref_d_tglbalik,
					tstd_ref_d_status,
					tstd_ref_d_catatan,
					tstd_ref_d_total,
					tstd_ref_d_terbayar,
					tstd_ref_p_tgl,
					tstd_ref_p_tglcair,
					tstd_ref_p_jlhbayar,
					tstd_ref_p_payfor,
					tstd_ref_p_refno,
					tstd_ref_p_paidfrom,
					tstd_ref_p_catatan) ';
		
		// Tahap 1 - Insert Query Data dari TOP SO (top_so) ===============================================================================================
		$query_top = $inserttemp
					.'(SELECT '.$data['tstd_idlap'].', "T", tpso_no, tpso_tgljatuhtempo, tpso_value, tpso_cttn,
						tpso_aktif, "", "", "", "", "", "", "", "", "", "", "", "", "", ""
					FROM top_so
					LEFT JOIN tr_so on trso_no = tpso_no
					where trso_void=0';

		// Tahap 2 - Insert Query Data dari SALES DELIVERY (tr_sales_dlv) ===============================================================================================
		$query_sd = $inserttemp
				.'(SELECT "'.$data['tstd_idlap'].'", "D", trsd_no, "", "", "", "", trsd_tgl, trsd_tglkirim, trsd_tglbalik,
					(CASE 
						WHEN (trsd_tglkirim = "") THEN "Dlv-Not Yet Delivered"
					    WHEN (trsd_tglkirim != "" and trsd_tglbalik = "") THEN "Conf Dlv-Not Yet Confirmed"
					 	when (trsd_tglbalik !="") then "Conf Dlv-Confirmed"
					 	else ""
					END ) as status,
					trsd_catatan, trsd_total, trsd_terbayar, "", "", "", "", "",
					"", ""
				FROM tr_sales_dlv
				LEFT JOIN tr_so on trso_no = substring(trsd_no,1,12) and trso_void=0
				WHERE trsd_void = 0';

		// Tahap 3 - Insert Query Data dari PEMBAYARAN SO (pby_so)) ===============================================================================================
		$query_pby = $inserttemp
				.'(SELECT "'.$data['tstd_idlap'].'", "P", pbso_no, "", "", "", "", "", "", "", "", "", "", "",
					pbso_tglterima, pbso_tglcair, pbso_jlhbayar,
					(CASE
						WHEN (pbso_bayardp = "D") THEN "DP"
						WHEN (pbso_bayardp = "A") THEN "Adj DP"
						WHEN (pbso_bayardp = "T") THEN "Tagihan"
						ELSE ""
					END) as payfor, pbso_refno, 
					IF(pbso_jenis = "D", "Potong DP", IF(pbso_jenis = "G", "Giro Masuk", IF(pbso_jenis = "T", "Transfer Masuk", msjb_nm))) as jns_byar, pbso_catatan
				FROM pby_so
				LEFT JOIN tr_so on trso_no = substring(pbso_no,1,12) and trso_void=0
				LEFT JOIN ms_jnspbyr on pbso_msjb_no = msjb_no
				WHERE pbso_void = 0';

		// Tahap 4 - SELECT FROM TMP_SO_TOP_DLV ============================================================================================================
		$query = 'select trso_tgl, trso_no, trso_mscs_no, mscs_nm, trso_mssl_no, mssl_nm,
					trso_total, trso_terbayar, trso_mscb_no, trso_catatan, 
					tstd_ref_jns,
					tstd_ref_no,
					if(tstd_ref_t_tgljatuhtempo="0000-00-00","",tstd_ref_t_tgljatuhtempo) as tstd_ref_t_tgljatuhtempo,
					tstd_ref_t_value,
					tstd_ref_t_cttn,
					if(tstd_ref_t_status="Y", "Aktif", "Non-Aktif") as tstd_ref_t_status,
					if(tstd_ref_d_tgl="0000-00-00","", tstd_ref_d_tgl) as tstd_ref_d_tgl,
					if(tstd_ref_d_tglkirim="0000-00-00","", tstd_ref_d_tglkirim) as tstd_ref_d_tglkirim,
					if(tstd_ref_d_tglbalik="0000-00-00","", tstd_ref_d_tglbalik) as tstd_ref_d_tglbalik,
					tstd_ref_d_status,
					tstd_ref_d_catatan,
					tstd_ref_d_total,
					tstd_ref_d_terbayar,
					if(tstd_ref_p_tgl="0000-00-00", "", tstd_ref_p_tgl) as tstd_ref_p_tgl,
					if(tstd_ref_p_tglcair="0000-00-00","", tstd_ref_p_tglcair) as tstd_ref_p_tglcair,
					tstd_ref_p_jlhbayar,
					tstd_ref_p_payfor,
					tstd_ref_p_refno,
					tstd_ref_p_paidfrom,
					tstd_ref_p_catatan
				FROM tr_so
				LEFT JOIN tmp_so_top_dlv on trso_no = substring(tstd_ref_no,1,12)
				LEFT JOIN ms_customer on mscs_no = trso_mscs_no
				LEFT JOIN ms_sales on mssl_no = trso_mssl_no
				WHERE trso_void = 0 and POSITION(trso_mscb_no in "'.$data['mscb_listmscb'].'")';


		// ============================= FILTERING ======================================================================================================
		// FILTER  by tanggal so
		if($data['lp_trso_tgl'] == "lp_tglso_sel"){
			$query_top .= ' and (CONVERT(trso_tgl,DATE) between "'.$data['lp_trso_tgl_dari'].'" and "'.$data['lp_trso_tgl_sampai'].'")';
			$query_sd .= ' and (CONVERT(trso_tgl, DATE) between "'.$data['lp_trso_tgl_dari'].'" and "'.$data['lp_trso_tgl_sampai'].'")';
			$query_pby .= ' and (CONVERT(trso_tgl,DATE) between "'.$data['lp_trso_tgl_dari'].'" and "'.$data['lp_trso_tgl_sampai'].'")';
			$query .= ' and (CONVERT(trso_tgl,DATE) between "'.$data['lp_trso_tgl_dari'].'" and "'.$data['lp_trso_tgl_sampai'].'")';

			$param['tgl_dari'] = $data['lp_trso_tgl_dari'];
			$param['tgl_sampai'] = $data['lp_trso_tgl_sampai'];

		} else if($data['lp_trso_tgl'] == "lp_tglestkirim_sel"){
			$query_top .= ' and (CONVERT(trso_tglestkirim, DATE) between "'.$data['lp_trso_tglestkirim_dari'].'" and "'.$data['lp_trso_tglestkirim_sampai'].'")';
			$query_sd .= ' and (CONVERT(trso_tglestkirim, DATE) between "'.$data['lp_trso_tglestkirim_dari'].'" and "'.$data['lp_trso_tglestkirim_sampai'].'")';
			$query_pby .= ' and (CONVERT(trso_tglestkirim, DATE) between "'.$data['lp_trso_tglestkirim_dari'].'" and "'.$data['lp_trso_tglestkirim_sampai'].'")';
			$query .= ' and (CONVERT(trso_tglestkirim, DATE) between "'.$data['lp_trso_tglestkirim_dari'].'" and "'.$data['lp_trso_tglestkirim_sampai'].'")';
				
			$param['tgl_dari'] = $data['lp_trso_tglestkirim_sampai'];
			$param['tgl_sampai'] = $data['lp_trso_tglestkirim_sampai'];
		}

		
		// filter by mscs (customer)
		if($data['lp_mscs'] != 'lp_mscs_all'){
			if ($data['lp_mscs'] == 'lp_mscs_r') {
				$query .= ' and mscs_jenis="R"';
				$param['mscs_nm'] = "RETAIL";
				$param['mscs_no'] = "";
			} else if ($data['lp_mscs'] == 'lp_mscs_a') {
				$query .= ' and mscs_jenis="A"';
				$param['mscs_nm'] = "AGENT";
				$param['mscs_no'] = "";
			} else if ($data['lp_mscs'] == 'lp_mscs_sel'){
				$param['mscs_nm'] = $data['lp_mscs_nm'];
				$param['mscs_no'] = $data['lp_mscs_no'];
				$query .= ' and trso_mscs_no = "'.$data['lp_mscs_no'].'"';
			} 
		} else {
			$param['mscs_nm'] = "ALL";
			$param['mscs_no'] = "ALL";
		}

		// filter by mssl (sales)
		if($data['lp_mssl'] != 'lp_mssl_all'){
			if ($data['lp_mssl'] == 'lp_mssl_sls') {
				$query .= ' and mssl_divisi="S"';
				$param['mssl_nm'] = "Salesman";
				$param['mssl_no'] = "";
			} else if ($data['lp_mssl'] == 'lp_mssl_tkn') {
				$query .= ' and mssl_divisi="T"';
				$param['mssl_nm'] = "Teknisi";
				$param['mssl_no'] = "";
			} else if ($data['lp_mssl'] == 'lp_mssl_sel' && $data['lp_mssl_no'] != null){
				$query .= ' and trso_mssl_no = "'. $data['lp_mssl_no'].'"';
				$param['mssl_nm'] = trim($data['mssl_no'][1]);
				$param['mssl_no'] = $data['lp_mssl_no'];
			} else {
				$param['mssl_nm'] = "ALL";
				$param['mssl_no'] = "ALL";
			}
		} else {
			$param['mssl_nm'] = "ALL";
			$param['mssl_no'] = "ALL";
		}

		// Filter by tipe data F/C
		if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
			$query .= ' AND trso_fin = "'. $data['lp_trju_fin'].'"';
			$param['trju_fin'] =  $data['lp_trju_fin'];
		} else {
			$param['trju_fin'] = "ALL";
		}

		// filter by payment status (settled)
		if($data['lp_pbystatus'] != "all"){
			if($data['lp_pbystatus'] == 1){
				$query .= ' and trso_terbayar >= trso_total';
					$param['lp_pbystatus'] = "Payment Settled";
			}elseif ($data['lp_pbystatus'] == 2){
				$query .= ' and trso_terbayar < trso_total';
					$param['lp_pbystatus'] = "Unsettled SO";
			}
		} else $param['lp_pbystatus'] = "ALL";

		//filter by sales order delivery status
		if($data['lp_sodlvstatus'] !="ALL"){
			if($data['lp_sodlvstatus'] == 1){
				$query .= ' and (((SELECT SUM(a.dtso_qty - a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") <= 0) OR (trso_lock = "Y"))';
				$param['lp_sodlvstatus'] = "Complete Sales Order";
			} else if ($data['lp_sodlvstatus'] == 2){
				$query .= ' and (SELECT SUM(a.dtso_qty - a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") > 0';
				$param['lp_sodlvstatus'] = "Incomplete Sales Order";
			} else if ($data['lp_sodlvstatus'] == 3){
				$query .= ' and (SELECT SUM(a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") <= 0';
				$param['lp_sodlvstatus'] = "No Delivery At ALL";
			} else if ($data['lp_sodlvstatus'] == 4){
				$query .= ' and ((SELECT SUM(a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") > 0 AND (SELECT SUM(a.dtso_qty - a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") > 0)';
				$param['lp_sodlvstatus'] = "Partial Delivery";
			}
		} else $param['lp_sodlvstatus'] = "ALL";
		


			$query_top .= ')';
			$query_sd .= ')';
			$query_pby .= ')';

			$query .= ' order by trso_tgl, trso_no, tstd_ref_jns, tstd_ref_t_tgljatuhtempo, tstd_ref_d_tgl, tstd_ref_p_tgl';

			
			// jalankan query //
			$this->db->simple_query($query_top);
			$this->db->simple_query($query_sd);
			$this->db->simple_query($query_pby);
			$this->db->simple_query($query);
			

		return array('query' => $query, 'param'=> $param);
	}

	public function delete_datatemp_bayrand_tstd($rand){
		$this->db->delete('tmp_so_top_dlv', array('tstd_idlap' => $rand));
	}


	public function get_lp_po($data){
		$param['vtrpo_tgldari'] = $data['lp_trpo_tgl_dari'];
		$param['vtrpo_tglsampai'] = $data['lp_trpo_tgl_sampai'];
		$param['vtrpo_mscb'] = $data['mscb_listmscb'];
		$query = 'select dtpo.*, trpo_tgl, trpo_catatan, trpo_total, trpo_curr, trpo_terbayar,
					IF(trpo_lock="N","Unlocked","Locked") as lockstatus, mssp_no, mssp_nm,mspd_nm, msmr_no,
					msmr_nm, trpo_catatan, (dtpo_qty*dtpo_nett) as subtotal, if(mssp_jenis="I","Import","Lokal") as mssp_jenis,
					IF(trpo_terbayar >= trpo_total,"Settled","Unsettled") as settle,
					IF(dtpo_qtyid < dtpo_qty,"Incomplete Delivery", "Complete Delivery") as delivery
					FROM dt_po dtpo
					LEFT JOIN tr_po trpo on trpo.trpo_no = dtpo.dtpo_no
					LEFT JOIN ms_supplier mssp on mssp.mssp_no = trpo.trpo_mssp_no
					LEFT JOIN ms_produk mspd on mspd.mspd_no = dtpo.dtpo_mspd_no
					LEFT JOIN ms_kategori mskt on mskt.mskt_no = SUBSTRING(mspd.mspd_no,1,1)
					LEFT JOIN ms_famili msfm on msfm.msfm_no = SUBSTRING(mspd.mspd_no,1,3)
					LEFT JOIN ms_model msmd on msmd.msmd_no = SUBSTRING(mspd.mspd_no,1,6)
					LEFT JOIN ms_merk msmr on msmr.msmr_no = mspd.mspd_msmr_no
					LEFT JOIN ms_cabang mscb on mscb.mscb_no = trpo.trpo_mscb_no
					where trpo.trpo_void = 0 and POSITION(mscb.mscb_no in "'.$data['mscb_listmscb'].'")
					and (Convert (trpo.trpo_tgl,Date) between "'.$data['lp_trpo_tgl_dari'].'" and "'.$data['lp_trpo_tgl_sampai'].'")';

		// WIP PO Report
		// if($data['judul_laporan'] == 'lp_wip_po'){
		// 	$query .= ' and (IFNULL((SELECT SUM(dtpo7.dtpo_qty - dtpo7.dtpo_qtyterima) FROM dt_po dtpo7 WHERE dtpo7.dtpo_no = dtpo.dtpo_no AND trpo_lock = "N"), 0) > 0 OR IFNULL((SELECT SUM(dtpo7.dtpo_qtyid - dtpo7.dtpo_qtyterima) FROM dt_po dtpo7 WHERE dtpo7.dtpo_no = dtpo.dtpo_no AND trpo_lock = "Y"), 0) > 0)';
		// }

		//filter by po payment status
		if ($data['lp_pobystatus'] != "all") {
			if($data['lp_pobystatus'] == 1 ){
				$param['trpostatus'] = 'PAYMENT SETTLED';
				$query .= ' and trpo_terbayar >= trpo_total';
			} else if ($data['lp_pobystatus'] == 2){
				$param['trpostatus'] = 'Unsettled PO';
				$query .= ' and trpo_terbayar < trpo_total';
			}	
		} 	else $param['trpostatus'] = "ALL"; 

		//filter by delivery status
		if ($data['lp_dlvstatus'] != "all") {
			if($data['lp_dlvstatus'] == 1 ){
				$param['trpodlvstatus'] = 'Complete PO';
				$query .= ' and (((SELECT SUM(a.dtpo_qty - a.dtpo_qtyid) FROM dt_po a WHERE a.dtpo_no = trpo_no AND trpo_lock = "N") <= 0) OR (trpo_lock = "Y"))';
			} else if ($data['lp_dlvstatus'] == 2){
				$param['trpodlvstatus'] = 'Incomplete PO';
				$query .= ' and (SELECT SUM(a.dtpo_qty - a.dtpo_qtyid) FROM dt_po a WHERE a.dtpo_no = trpo_no AND trpo_lock = "N") > 0';			
				} 
			} 	else $param['trpodlvstatus'] = "ALL";

		//filter by lock status
		if ($data['lp_lockstatus'] != "all") {
			if($data['lp_lockstatus'] == 1 ){
				$param['trpolockstatus'] = 'Locked';
				$query .= ' and trpo_lock="Y"';
			} else if ($data['lp_lockstatus'] == 2){
				$param['trpolockstatus'] = 'Unlocked';
				$query .= ' and trpo_lock="N"';
				} 
			} else $param['trpolockstatus'] = "ALL";

		//filter by lock status
		if ($data['lp_po_final'] != "all") {
			if($data['lp_po_final'] == 1 ){
				$param['lp_po_final'] = 'Final';
				$query .= ' and trpo_final="Y"';
			} else if ($data['lp_po_final'] == 2){
				$param['lp_po_final'] = 'Not Final Yet';
				$query .= ' and trpo_final="N"';
				} 
			} 	else $param['lp_po_final'] = "ALL";

		// filter by mskt_no
		if($data['lp_mskt'] == 'lp_mskt_sel'){						
			$param['vtrpo_mskt_no'] = $data['lp_mskt_no'];
			$param['vtrpo_mskt_nm'] = $data['lp_mskt_nm'];
			$query .= ' and SUBSTRING(mspd.mspd_no,1,1)="'.$data['lp_mskt_no'].'"';
			} else{
				$param['vtrpo_mskt_no'] = 'ALL';
				$param['vtrpo_mskt_nm'] = 'ALL';
			}

		// filter by msfm_no
		if($data['lp_msfm'] == 'lp_msfm_sel'){
			$param['vtrpo_msfm_no'] = $data['lp_msfm_no'];
			$param['vtrpo_msfm_nm'] = $data['lp_msfm_nm'];
			$query .= ' and SUBSTRING(mspd.mspd_no,1,3)="'.$data['lp_msfm_no'].'"';;
			} else {
				$param['vtrpo_msfm_no'] = 'ALL';
				$param['vtrpo_msfm_nm'] = 'ALL';
			}

		// filter by msmd_no
		if($data['lp_msmd'] == 'lp_msmd_sel'){
			$param['vtrpo_msmd_no'] = $data['lp_msmd_no'];
			$param['vtrpo_msmd_nm'] = $data['lp_msmd_nm'];
			$query .= ' and SUBSTRING(mspd.mspd_no,1,6)="'. $data['lp_msmd_no']. '"';
			} else {
				$param['vtrpo_msmd_no'] = 'ALL';
				$param['vtrpo_msmd_nm'] = 'ALL';
			}

		// filter by mspd_no
		if($data['lp_mspd'] != 'ALL'){
				if($data['lp_mspd'] == 'lp_mspd_sel'){
					$param['vtrpo_mspd_no'] = $data['lp_mspd_no_sel'];
					$param['vtrpo_mspd_nm'] = $data['lp_mspd_nm'];					
					$query .= ' and mspd.mspd_no = "'. $data['lp_mspd_no_sel']. '"';
				}else if($data['lp_mspd'] == 'lp_mspd_con'){
					$param['vtrpo_mspd_no'] = '';
					$param['vtrpo_mspd_nm'] = $data['lp_mspd_nm_con'];					
					if($data['lp_mspd_nm_con'] != ''){
						$query .= ' and mspd.mspd_nm LIKE "%'. $data['lp_mspd_nm_con']. '%")';
					}
				} else {
					$param['vtrpo_mspd_no'] = 'ALL';
					$param['vtrpo_mspd_nm'] = 'ALL';
				}
			}

		// filter by mssp (supplier)
		if($data['lp_mssp'] != 'ALL'){
			if ($data['lp_mssp'] == 'lp_mssp_lokal') {
				$param['vtrpo_mssp_jenis'] = 'Lokal';
				$param['vtrpo_mssp_nm'] ='';
				$query .= ' and mssp_jenis="L"';
			} else if ($data['lp_mssp'] == 'lp_mssp_import') {
				$param['vtrpo_mssp_jenis'] = 'Import';
				$param['vtrpo_mssp_nm'] ='';
				$query .= ' and mssp_jenis="I"';
			} else if ($data['lp_mssp'] == 'lp_mssp_sel'){
				$query .= ' and mssp.mssp_no = "'. $data['lp_mssp_no']. '"';
				$param['vtrpo_mssp_jenis'] = '';
				$param['vtrpo_mssp_nm'] = $data['lp_mssp_nm'];
			} else {
				$param['vtrpo_mssp_jenis'] ='ALL';
				$param['vtrpo_mssp_nm'] ='ALL';	
			}
		}

		//filter by tipe data (F/C)
		if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
			$query .= ' AND trpo_fin = "'.$data['lp_trju_fin'].'"';
			$param['trju_fin'] = $data['lp_trju_fin'];
		} else $param['trju_fin'] = "";

		return array('query' => $query, 'param' => $param);		
	}

	public function get_lp_po_final($data){
		$param['vtrpo_tgldari'] = $data['lp_trpo_tgl_dari'];
		$param['vtrpo_tglsampai'] = $data['lp_trpo_tgl_sampai'];
		$param['vtrpo_mscb'] = $data['mscb_listmscb'];
		$query = 'select trpo_tgl, trpo_no, trpo_total, trpo_curr, trpo_terbayar,
					IF(trpo_lock="N","Unlocked","Locked") as lockstatus, trpo_mssp_no, mssp_nm,
					if(mssp_jenis="I","Import","Lokal") as mssp_jenis
					FROM tr_po
					LEFT JOIN ms_supplier on mssp_no = trpo_mssp_no
					LEFT JOIN ms_cabang on mscb_no = trpo_mscb_no
					where trpo_void = 0 and POSITION(mscb_no in "'.$data['mscb_listmscb'].'") 
					and trpo_tgl between "'.$data['lp_trpo_tgl_dari'].'" and "'.$data['lp_trpo_tgl_sampai'].'" 
					and trpo_terbayar >= trpo_total and trpo_final = "N" and trpo_sisadp <= 0';

		// filter by mssp (supplier)
		if($data['lp_mssp'] != 'ALL'){
			if ($data['lp_mssp'] == 'lp_mssp_lokal') {
				$param['vtrpo_mssp_nm'] ='Lokal';
				$query .= ' and mssp_jenis="L"';
			} else if ($data['lp_mssp'] == 'lp_mssp_import') {
				$param['vtrpo_mssp_nm'] ='Import';
				$query .= ' and mssp_jenis="I"';
			} else if ($data['lp_mssp'] == 'lp_mssp_sel'){
				$query .= ' and mssp_no = "'. $data['lp_mssp_no']. '"';
				$param['vtrpo_mssp_nm'] = $data['lp_mssp_nm'];
			} else {
				$param['vtrpo_mssp_nm'] ='ALL';	
			}
		}

		//filter by tipe data (F/C)
		if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
			$query .= ' AND trpo_fin = "'. $data['lp_trju_fin'].'"';
			$param['trju_fin'] = $data['lp_trju_fin'];
		} else $param['trju_fin'] = "";

		$query .= ' order by trpo_tgl, trpo_no';

		return array('query' => $query, 'param' => $param);		
	}

	public function lap_tmp_sales_dlv_hpp($data){
    	$inserttemp = 'INSERT INTO tmp_sales_dlv_hpp(
					tsdh_idlap, 
					tsdh_mspd_no,
					tsdh_jnstran,
					tsdh_notran,
					tsdh_tgltran,
					tsdh_mscs_no,
					tsdh_mssl_no,
					tsdh_qty,
					tsdh_bftax, 
					tsdh_nett, 
					tsdh_hpp,
					tsdh_catatan_tran
					) ';
		
					
		// Tahap 1 - Insert Query Data dari SALES DELIVERY ===============================================================================================
		// Tidak lagi digunakan	: trso_mssl_no, (dtsd_qtykrm-dtsd_qtyrej), round((dtsd_nett/1.1),4), dtsd_nett, dtsd_hpp, trsd_catatan
		// diganti menjadi		: trso_mssl_no, (dtsd_qtykrm-dtsd_qtyrej), dtsd_bftax, dtsd_nett, dtsd_hpp, trsd_catatan
		$query_sd = $inserttemp
					.'(SELECT '.$data['tsdh_idlap'].', dtsd_mspd_no, "SALES DELIVERY", trsd_no, trsd_tgl, trsd_mscs_no,
						trso_mssl_no, (dtsd_qtykrm-dtsd_qtyrej), dtsd_bftax, dtsd_nett, dtsd_hpp, trsd_catatan
					FROM dt_sales_dlv
					LEFT JOIN tr_sales_dlv on dtsd_no = trsd_no
					LEFT JOIN tr_so on trso_no = substring(trsd_no,1,12) and trso_void=0
					LEFT JOIN ms_customer on mscs_no = trsd_mscs_no 
					LEFT JOIN ms_sales on mssl_no = trso_mssl_no
					LEFT JOIN ms_produk on mspd_no = dtsd_mspd_no
					LEFT JOIN ms_kategori on mskt_no = SUBSTRING(mspd_no,1,1)
					LEFT JOIN ms_famili on msfm_no = SUBSTRING(mspd_no,1,3)
					LEFT JOIN ms_model on msmd_no = SUBSTRING(mspd_no,1,6)
					LEFT JOIN ms_merk on msmr_no = mspd_msmr_no
					WHERE POSITION(trsd_mscb_no in "'.$data['mscb_listmscb'].'")
					AND trsd_void = 0';
		
		// Tahap 2 - Insert Query Data dari SALES RETUR ===============================================================================================
		// Tidak lagi digunakan	: (-1*dtsr_qtyretur), round((dtsr_nett/1.1),4), dtsr_nett, dtsr_hpp, trsr_catatan
		// diganti menjadi		: (-1*dtsr_qtyretur), dtsr_bftax, dtsr_nett, dtsr_hpp, trsr_catatan
		$query_sr = $inserttemp
					.'(SELECT "'.$data['tsdh_idlap'].'", dtsr_mspd_no, "SALES RETUR", trsr_no, trsr_tgl, trsr_mscs_no, trso_mssl_no,
						(-1*dtsr_qtyretur), dtsr_bftax, dtsr_nett, dtsr_hpp, trsr_catatan
					FROM dt_salesret
					LEFT JOIN tr_salesret on dtsr_no = trsr_no
					LEFT JOIN tr_sales_dlv on trsd_no = substring(trsr_no,1,17) and trsd_void=0
					LEFT JOIN tr_so on trso_no = substring(trsr_no,1,12) and trso_void=0
					LEFT JOIN ms_customer on mscs_no = trsr_mscs_no
 					LEFT JOIN ms_sales on mssl_no = trso_mssl_no
 					LEFT JOIN ms_produk on mspd_no = dtsr_mspd_no
					LEFT JOIN ms_kategori on mskt_no = SUBSTRING(mspd_no,1,1)
					LEFT JOIN ms_famili on msfm_no = SUBSTRING(mspd_no,1,3)
					LEFT JOIN ms_model on msmd_no = SUBSTRING(mspd_no,1,6)
					LEFT JOIN ms_merk on msmr_no = mspd_msmr_no
					WHERE POSITION(trsr_mscb_no in "'.$data['mscb_listmscb'].'")
					AND trsr_void = 0';
		
		// Tahap 3 - Query Select between tanggal dari - tgl sampai
		$query = 'select tsdh_mspd_no, mspd_nm, tsdh_mscs_no, mscs_nm, tsdh_jnstran, tsdh_notran, tsdh_tgltran, tsdh_mssl_no, mssl_nm,
					tsdh_qty,  tsdh_bftax, tsdh_hpp
				FROM tmp_sales_dlv_hpp
				LEFT JOIN ms_produk on mspd_no = tsdh_mspd_no
				LEFT JOIN ms_kategori on mskt_no = SUBSTRING(mspd_no,1,1)
				LEFT JOIN ms_famili on msfm_no = SUBSTRING(mspd_no,1,3)
				LEFT JOIN ms_model on msmd_no = SUBSTRING(mspd_no,1,6)
				LEFT JOIN ms_merk on msmr_no = mspd_msmr_no
				LEFT JOIN ms_customer on mscs_no = tsdh_mscs_no
				LEFT JOIN ms_sales on mssl_no = tsdh_mssl_no
				where tsdh_idlap = "'.$data['tsdh_idlap'].'"';

		//  Tahap 3 - FILTER =====================================================================================================================================
		// filter by date sales delivery
		if($data['lp_trsd_tgl'] == "lp_trsd_tglsel"){
			$query_sd .=' AND (Convert(trsd_tgl,Date) between "'.$data['lp_trsd_tgl_dari'].'" and "'.$data['lp_trsd_tgl_sampai'].'")';
			$query_sr .=' AND (Convert(trsd_tgl,Date) between "'.$data['lp_trsd_tgl_dari'].'" and "'.$data['lp_trsd_tgl_sampai'].'")';

			$param['periode'] = "Tanggal Created ".$data['lp_trsd_tgl_dari']." - ".$data['lp_trsd_tgl_sampai'];
		}else if($data['lp_trsd_tgl'] == "lp_trsd_tglkirim"){
			$query_sd .=' AND (Convert(trsd_tglkirim,Date) between "'.$data['lp_trsd_tglkirim_dari'].'" and "'.$data['lp_trsd_tglkirim_sampai'].'")';
			$query_sr .=' AND (Convert(trsd_tglkirim,Date) between "'.$data['lp_trsd_tglkirim_dari'].'" and "'.$data['lp_trsd_tglkirim_sampai'].'")';

			$param['periode'] = "Tanggal Delivery ".$data['lp_trsd_tglkirim_dari']." - ".$data['lp_trsd_tglkirim_sampai'];
		}else{
			$query_sd .=' AND (Convert(trsd_tglbalik,Date) between "'.$data['lp_trsd_tglconf_dari'].'" and "'.$data['lp_trsd_tglconf_sampai'].'")';
			$query_sr .=' AND (Convert(trsd_tglbalik,Date) between "'.$data['lp_trsd_tglconf_dari'].'" and "'.$data['lp_trsd_tglconf_sampai'].'")';

			$param['periode'] = "Tanggal confirm ".$data['lp_trsd_tglconf_dari']." - ".$data['lp_trsd_tglconf_sampai'];
		}

		//filter by delivery status
		if ($data['lp_sd_dlv_status'] != 'all'){
			if($data['lp_sd_dlv_status'] == 1 ){
				$query_sd .= ' and trsd_tglkirim > 0';
				$query_sr .= ' and trsd_tglkirim > 0';
				$param['dlv_status'] = "DLV-Delivered";
			} else if ($data['lp_sd_dlv_status'] == 2){
				$query_sd .= ' and trsd_tglkirim = 0';
				$query_sr .= ' and trsd_tglkirim = 0';
				$param['dlv_status'] = "Preparing SO Delivery";
			}
		} else {
			$param['dlv_status'] = "ALL";
		}
		
		//filter by confirm status
		if ($data['lp_sd_conf_status'] != 'all'){
			if($data['lp_sd_conf_status'] == 1 ){
				$query_sd .= ' and trsd_tglbalik > 0';
				$query_sr .= ' and trsd_tglbalik > 0';
				$param['conf_status'] = "DLV-Confirmed";
			} else if ($data['lp_sd_conf_status'] == 2){
				$query_sd .= ' and trsd_tglbalik = 0';
				$query_sr .= ' and trsd_tglbalik = 0';
				$param['conf_status'] = "DLV-Unconfirm";
			}
		} else {
			$param['conf_status'] ="ALL";
		}


		// filter by mskt_no
		if($data['lp_mskt'] == 'lp_mskt_sel'){						
			$param['mskt_no'] = $data['lp_mskt_no'];
			$param['mskt_nm'] = $data['lp_mskt_nm'];
			$query .= ' and SUBSTRING(mspd_no,1,1)="'.$data['lp_mskt_no'].'"';
			$query_sd .= ' and SUBSTRING(mspd_no,1,1)="'.$data['lp_mskt_no'].'"';
			$query_sr .= ' and SUBSTRING(mspd_no,1,1)="'.$data['lp_mskt_no'].'"';
			} else{
				$param['mskt_no'] = 'ALL';
				$param['mskt_nm'] = 'ALL';
			}

		// filter by msfm_no
		if($data['lp_msfm'] == 'lp_msfm_sel'){
			$param['msfm_no'] = $data['lp_msfm_no'];
			$param['msfm_nm'] = $data['lp_msfm_nm'];
			$query .= ' and SUBSTRING(mspd_no,1,3)="'.$data['lp_msfm_no'].'"';;
			$query_sr .= ' and SUBSTRING(mspd_no,1,3)="'. $data['lp_msfm_no']. '"';
			$query_sd .= ' and SUBSTRING(mspd_no,1,3)="'. $data['lp_msfm_no']. '"';
			} else {
				$param['msfm_no'] = 'ALL';
				$param['msfm_nm'] = 'ALL';
			}

		// filter by msmd_no
		if($data['lp_msmd'] == 'lp_msmd_sel'){
			$param['msmd_no'] = $data['lp_msmd_no'];
			$param['msmd_nm'] = $data['lp_msmd_nm'];
			$query .= ' and SUBSTRING(mspd_no,1,6)="'. $data['lp_msmd_no']. '"';
			$query_sr .= ' and SUBSTRING(mspd_no,1,6)="'. $data['lp_msmd_no']. '"';
			$query_sd .= ' and SUBSTRING(mspd_no,1,6)="'. $data['lp_msmd_no']. '"';
			} else {
				$param['msmd_no'] = 'ALL';
				$param['msmd_nm'] = 'ALL';
			}

		// filter by mspd_no
		if($data['lp_mspd'] != 'ALL'){
				if($data['lp_mspd'] == 'lp_mspd_sel'){
					$param['mspd_no'] = $data['lp_mspd_no_sel'];
					$param['mspd_nm'] = $data['lp_mspd_nm'];					
					$query .= ' and mspd_no = "'. $data['lp_mspd_no_sel']. '"';
					$query_sd .= ' and mspd_no = "'. $data['lp_mspd_no_sel']. '"';
					$query_sr .= ' and mspd_no = "'. $data['lp_mspd_no_sel']. '"';
				}else if($data['lp_mspd'] == 'lp_mspd_con'){
					$param['mspd_no'] = '';
					$param['mspd_nm'] = $data['lp_mspd_nm_con'];					
					if($data['lp_mspd_nm_con'] != ''){
						$query .= ' and mspd_nm LIKE "%'. $data['lp_mspd_nm_con']. '%"';
						$query_sd .= ' and mspd_nm LIKE "%'. $data['lp_mspd_nm_con']. '%"';
						$query_sr .= ' and mspd_nm LIKE "%'. $data['lp_mspd_nm_con']. '%"';
					}
				} else {
					$param['mspd_no'] = 'ALL';
					$param['mspd_nm'] = 'ALL';
				}
			}

			// filter by mscs (customer)
			if($data['lp_mscs'] != 'lp_mscs_all'){
				if ($data['lp_mscs'] == 'lp_mscs_r') {
					$query_sd .= ' and mscs_jenis="R"';
					$query_sr .= ' and mscs_jenis="R"';
					$query .= ' and mscs_jenis="R"';
					$param['mscs_nm'] = "RETAIL";
					$param['mscs_no'] = "";
				} else if ($data['lp_mscs'] == 'lp_mscs_a') {
					$query_sd .= ' and mscs_jenis="A"';
					$query_sr .= ' and mscs_jenis="A"';
					$query .= ' and mscs_jenis="A"';
					$param['mscs_nm'] = "AGENT";
					$param['mscs_no'] = "";
				} else if ($data['lp_mscs'] == 'lp_mscs_sel'){
					$param['mscs_nm'] = $data['lp_mscs_nm'];
					$param['mscs_no'] = $data['lp_mscs_no'];
					$query_sd .= ' and trsd_mscs_no = "'. $data['lp_mscs_no'].'"';
					$query_sr .= ' and trsr_mscs_no = "'.$data['lp_mscs_no'].'"';	
					$query .= ' and tsdh_mscs_no = "'.$data['lp_mscs_no'].'"';
				} 
			} else {
				$param['mscs_nm'] = "ALL";
				$param['mscs_no'] = "ALL";
					}

			// filter by mssl (sales)
			if($data['lp_mssl'] != 'lp_mssl_all'){
				if ($data['lp_mssl'] == 'lp_mssl_sls') {
					$query_sd .= ' and mssl_divisi="S"';
					$query_sr .= ' and mssl_divisi="S"';
					$query .= ' and mssl_divisi="S"';
					$param['mssl_nm'] = "Salesman";
					$param['mssl_no'] = "";
				} else if ($data['lp_mssl'] == 'lp_mssl_tkn') {
					$query_sd .= ' and mssl_divisi="T"';
					$query_sr .= ' and mssl_divisi="T"';
					$query .= ' and mssl_divisi="T"';
					$param['mssl_nm'] = "Teknisi";
					$param['mssl_no'] = "";
				} else if ($data['lp_mssl'] == 'lp_mssl_sel'){
					$query_sd .= ' and trso_mssl_no = "'. $data['mssl_no'].'"';
					$query_sr .= ' and trso_mssl_no = "'. $data['mssl_no'].'"';
					$query .= ' and tsdh_mssl_no = "'. $data['mssl_no'].'"';
					$param['mssl_nm'] = trim($data['lp_mssl_no'][1]);
					$param['mssl_no'] = $data['mssl_no'];
					} 
			} else {
				$param['mssl_nm'] = "ALL";
				$param['mssl_no'] = "ALL";
					}

			// Filter by tipe data F/C
			if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
				$query_sd .= ' AND trso_fin = "'. $data['lp_trju_fin'].'"';
				$query_sr .= ' AND trso_fin = "'. $data['lp_trju_fin'].'"';
				$param['trju_fin'] =  $data['lp_trju_fin'];
			} else {
				$param['trju_fin'] = "ALL";
			}

		$query_sd .= ')';
		$query_sr .= ')';
		$query .= ' order by tsdh_tgltran, tsdh_notran';
	

			//filter by sumber data
			if($data['sumberdata'] != "all"){
				if($data['sumberdata'] == 1 ){
					$this->db->simple_query($query_sd);
				}elseif ($data['sumberdata'] == 2) {	
					$this->db->simple_query($query_sr);
				}
			} else {
				$this->db->simple_query($query_sd);
				$this->db->simple_query($query_sr);
			}
		//==========================================================================================================================================================
		
		return array('query' => $query, 'param' => $param);
	}

	public function delete_datatemp_bayrand_tsdh($rand){
		$this->db->delete('tmp_sales_dlv_hpp', array('tsdh_idlap' => $rand));
		}

	public function get_lp_pr($data){
		$param['vtrpr_tgldari'] = $data['lp_trpr_tgl_dari'];
		$param['vtrpr_tglsampai'] = $data['lp_trpr_tgl_sampai'];
		$param['vtrpr_mscb'] = $data['mscb_listmscb'];
		//[01] test query appr.appr_no.
		$query = 'select dtpr.*, mspd_mssp_no, mssp_nm, mssp_jenis, trpr.trpr_tgl, trpr.trpr_no, mspd.mspd_nm, appr.appr_tgl, appr.appr_no, dappr.dappr_trpo_no
					FROM dt_purcreq dtpr 
						LEFT JOIN tr_purcreq trpr ON trpr.trpr_no = dtpr.dtpr_no
						LEFT JOIN apv_purcreq appr on dtpr.dtpr_appr_no = appr.appr_no and appr.appr_void=0
						LEFT JOIN dt_apv_purcreq dappr on dtpr.dtpr_no = appr.appr_no 
									AND dtpr.dtpr_seq = dappr.dappr_seq 
									AND dtpr.dtpr_appr_no = dappr.dappr_no
						LEFT JOIN ms_produk mspd on mspd.mspd_no = dtpr.dtpr_mspd_no
						LEFT JOIN ms_kategori mskt on mskt.mskt_no = SUBSTRING(mspd.mspd_no,1,1)
						LEFT JOIN ms_famili msfm on msfm.msfm_no = SUBSTRING(mspd.mspd_no,1,3)
						LEFT JOIN ms_model msmd on msmd.msmd_no = SUBSTRING(mspd.mspd_no,1,6)
						LEFT JOIN ms_merk msmr on msmr.msmr_no = mspd.mspd_msmr_no
						LEFT JOIN ms_cabang mscb on mscb.mscb_no = trpr.trpr_mscb_no
						LEFT JOIN ms_supplier mssp on mssp.mssp_no = mspd.mspd_mssp_no
					where trpr.trpr_void = 0 and POSITION(mscb.mscb_no in "'.$data['mscb_listmscb'].'")
					and trpr.trpr_tgl between "'.$data['lp_trpr_tgl_dari'].'" and "'.$data['lp_trpr_tgl_sampai'].'"';
		
		//filter by approval status
		if ($data['lp_trprbystatus'] != 'ALL') {
			if($data['lp_trprbystatus'] == 1 ){
				$param['trprstatus'] = 'COMPLETE APPROVAL';
				$query .= ' and dtpr.dtpr_appr_no <> ""';
			} else if ($data['lp_trprbystatus'] == 2){
				$param['trprstatus'] = 'WAITING FOR APPROVAL';
				$query .= ' and dtpr.dtpr_appr_no = ""';
				} else $param['trprstatus'] = 'ALL';
			} 

		//filter by po status
		if ($data['lp_trprbypostatus'] != 'ALL') {
			if($data['lp_trprbypostatus'] == 1 ){
				$param['trprbypostatus'] = 'COMPLETE PO';
				$query .= ' and dappr.dappr_trpo_no <> ""';
			} else if ($data['lp_trprbypostatus'] == 2){
				$param['trprbypostatus'] = 'READY FOR PO';
				$query .= ' and dappr.dappr_trpo_no = ""';
				} else $param['trprbypostatus'] = 'ALL';
			}
				
		// filter by mskt_no
		if($data['lp_mskt'] == 'lp_mskt_sel'){						
			$param['vtrpr_mskt_no'] = $data['lp_mskt_no'];
			$param['vtrpr_mskt_nm'] = $data['lp_mskt_nm'];
			$query .= ' and SUBSTRING(mspd.mspd_no,1,1)="'.$data['lp_mskt_no'].'"';
			} else{
				$param['vtrpr_mskt_no'] = 'ALL';
				$param['vtrpr_mskt_nm'] = 'ALL';
			}


		// filter by msfm_no
		if($data['lp_msfm'] == 'lp_msfm_sel'){
			$param['vtrpr_msfm_no'] = $data['lp_msfm_no'];
			$param['vtrpr_msfm_nm'] = $data['lp_msfm_nm'];
			$query .= ' and SUBSTRING(mspd.mspd_no,1,3)="'.$data['lp_msfm_no'].'"';;
			} else {
				$param['vtrpr_msfm_no'] = 'ALL';
				$param['vtrpr_msfm_nm'] = 'ALL';
			}

		// filter by msmd_no
		if($data['lp_msmd'] == 'lp_msmd_sel'){
			$param['vtrpr_msmd_no'] = $data['lp_msmd_no'];
			$param['vtrpr_msmd_nm'] = $data['lp_msmd_nm'];
			$query .= ' and SUBSTRING(mspd.mspd_no,1,6)="'. $data['lp_msmd_no']. '"';
			} else {
				$param['vtrpr_msmd_no'] = 'ALL';
				$param['vtrpr_msmd_nm'] = 'ALL';
			}

		// filter by mspd_no
		if($data['lp_mspd'] != 'ALL'){
				if($data['lp_mspd'] == 'lp_mspd_sel'){
					$param['vtrpr_mspd_no'] = $data['lp_mspd_no_sel'];
					$param['vtrpr_mspd_nm'] = $data['lp_mspd_nm'];					
					$query .= ' and mspd.mspd_no = "'. $data['lp_mspd_no_sel']. '"';
				}else if($data['lp_mspd'] == 'lp_mspd_con'){
					$param['vtrpr_mspd_no'] = '';
					$param['vtrpr_mspd_nm'] = $data['lp_mspd_nm_con'];					
					if($data['lp_mspd_nm_con'] != ''){
						$query .= ' and mspd.mspd_nm LIKE "%'. $data['lp_mspd_nm_con']. '%")';
					}
				} else {
					$param['vtrpr_mspd_no'] = 'ALL';
					$param['vtrpr_mspd_nm'] = 'ALL';
				}
			}

		// filter by mssp (supplier)
		if($data['lp_mssp'] != 'ALL'){
			if ($data['lp_mssp'] == 'lp_mssp_lokal') {
				$param['mssp_jenis'] = 'Lokal';
				$param['mssp_nm'] ='';
				$query .= ' and mssp_jenis="L"';
			} else if ($data['lp_mssp'] == 'lp_mssp_import') {
				$param['mssp_jenis'] = 'Import';
				$param['mssp_nm'] ='';
				$query .= ' and mssp_jenis="I"';
			} else if ($data['lp_mssp'] == 'lp_mssp_sel'){
				$query .= ' and mssp.mssp_no = "'. $data['lp_mssp_no']. '"';
				$param['mssp_jenis'] = '';
				$param['mssp_nm'] = $data['lp_mssp_nm'];
			} else {
				$param['mssp_jenis'] ='ALL';
				$param['mssp_nm'] ='ALL';	
			}
		}

		$query .= ' order by mspd_mssp_no';

		//sort by
		if($data['lp_trpr_sortby'] == 'sortbydate'){
			$query .= ', trpr.trpr_tgl, dtpr.dtpr_mspd_no ';
			} else if ($data['lp_trpr_sortby'] == 'sortbymspd'){
				$query .= ' , dtpr.dtpr_mspd_no, trpr.trpr_tgl ';
				}

		return array('query' => $query, 'param' => $param);		
	}

	public function get_lp_mutasi_query($data){				
		$param['vtrmt_tgldari'] = $data['lp_trmt_tgl_dari'];
		$param['vtrmt_tglsampai'] = $data['lp_trmt_tgl_sampai'];
		$param['vtrmt_tglkirimdari'] = $data['lp_trmt_tglkirim_dari'];
		$param['vtrmt_tglkirimsampai'] = $data['lp_trmt_tglkirim_sampai'];
		$param['vtrmt_tglterimadari'] = $data['lp_trmt_tglterima_dari'];
		$param['vtrmt_tglterimasampai'] = $data['lp_trmt_tglterima_sampai'];
		$param['vtrmt_mscb'] = $data['mscb_listmscb'];
		
		$query = 'select dtmt.*, if(dtmt.dtmt_stapv="Y","Approved","Not") as stapv,
					trmt.trmt_tgl, trmt.trmt_tglkirim, trmt.trmt_tglterima,
					trmt.trmt_msgd_no1, msgdfrom.msgd_nm as msgd_nm_from,
					trmt.trmt_msgd_no2, msgdto.msgd_nm as msgd_nm_to, trmt.trmt_catatan,
					mspd.mspd_nm, msmr.msmr_no, msmr.msmr_nm
					from dt_mutasi dtmt
						left join tr_mutasi trmt on trmt.trmt_no = dtmt.dtmt_no
						left join ms_gudang msgdfrom on msgdfrom.msgd_no = trmt.trmt_msgd_no1
						left join ms_gudang msgdto on msgdto.msgd_no = trmt.trmt_msgd_no2
						left join ms_produk mspd on mspd.mspd_no = dtmt.dtmt_mspd_no
						left join ms_kategori mskt on mskt.mskt_no = SUBSTRING(mspd.mspd_no,1,1)
						left join ms_famili msfm on msfm.msfm_no = SUBSTRING(mspd.mspd_no,1,3)
						left join ms_model msmd on msmd.msmd_no = SUBSTRING(mspd.mspd_no,1,6)
						left join ms_merk msmr on msmr.msmr_no = mspd.mspd_msmr_no
						left join ms_cabang mscb on mscb.mscb_no = trmt.trmt_mscb_no
					where trmt.trmt_void = 0
					and trmt.trmt_tgl between "'.$data['lp_trmt_tgl_dari'].'" and "'.$data['lp_trmt_tgl_sampai'].'"
					and trmt.trmt_tglkirim between "'.$data['lp_trmt_tglkirim_dari'].'" and "'.$data['lp_trmt_tglkirim_sampai'].'"
					and trmt.trmt_tglterima between "'.$data['lp_trmt_tglterima_dari'].'" and "'.$data['lp_trmt_tglterima_sampai'].'"';

		// filter by mskt_no
		if($data['lp_mskt'] == 'lp_mskt_sel'){						
			$param['vtrmt_mskt_no'] = $data['lp_mskt_no'];
			$param['vtrmt_mskt_nm'] = $data['lp_mskt_nm'];
			$query .= ' and SUBSTRING(mspd.mspd_no,1,1)="'.$data['lp_mskt_no'].'"';
			} else{
				$param['vtrmt_mskt_no'] = 'ALL';
				$param['vtrmt_mskt_nm'] = 'ALL';
			}

		// filter by msfm_no
		if($data['lp_msfm'] == 'lp_msfm_sel'){
			$param['vtrmt_msfm_no'] = $data['lp_msfm_no'];
			$param['vtrmt_msfm_nm'] = $data['lp_msfm_nm'];
			$query .= ' and SUBSTRING(mspd.mspd_no,1,3)="'.$data['lp_msfm_no'].'"';;
			} else {
				$param['vtrmt_msfm_no'] = 'ALL';
				$param['vtrmt_msfm_nm'] = 'ALL';
			}

		// filter by msmd_no
		if($data['lp_msmd'] == 'lp_msmd_sel'){
			$param['vtrmt_msmd_no'] = $data['lp_msmd_no'];
			$param['vtrmt_msmd_nm'] = $data['lp_msmd_nm'];
			$query .= ' and SUBSTRING(mspd.mspd_no,1,6)="'. $data['lp_msmd_no']. '"';
			} else {
				$param['vtrmt_msmd_no'] = 'ALL';
				$param['vtrmt_msmd_nm'] = 'ALL';
			}

		// filter by mspd_no
		if($data['lp_mspd'] != 'ALL'){
				if($data['lp_mspd'] == 'lp_mspd_sel'){
					$param['vtrmt_mspd_no'] = $data['lp_mspd_no_sel'];
					$param['vtrmt_mspd_nm'] = $data['lp_mspd_nm'];					
					$query .= ' and mspd.mspd_no = "'. $data['lp_mspd_no_sel']. '"';
				}else if($data['lp_mspd'] == 'lp_mspd_con'){
					$param['vtrmt_mspd_no'] = '';
					$param['vtrmt_mspd_nm'] = $data['lp_mspd_nm_con'];					
					if($data['lp_mspd_nm_con'] != ''){
						$query .= ' and mspd.mspd_nm LIKE "%'. $data['lp_mspd_nm_con']. '%")';
					}
				} else {
					$param['vtrmt_mspd_no'] = 'ALL';
					$param['vtrmt_mspd_nm'] = 'ALL';
				}
			}

		//filter by mutasi all/in/out
			if ($data['lp_mutasi'] == 'lp_mutasi_all') {
				$param['vtrmt_inout']= 'ALL Mutasi';
				$query .= ' and (POSITION(mscb.mscb_no in "'.$data['mscb_listmscb'].'") or POSITION(trmt_mscb_no1 in "'.$data['mscb_listmscb'].'") OR POSITION(trmt_mscb_no2 in "'.$data['mscb_listmscb'].'"))';
			} elseif ($data['lp_mutasi'] == 'lp_mutasi_in') {
				$param['vtrmt_inout']= 'Mutasi in';
				$query .= ' and POSITION(trmt_mscb_no2 in "'.$data['mscb_listmscb'].'")';
			} else {
				$param['vtrmt_inout']= 'Mutasi out';
				$query .= ' and POSITION(trmt_mscb_no1 in "'.$data['mscb_listmscb'].'")';
			}

		// filter by msgd_no
		if($data['lp_trmt_msgd'] == 'lp_trmt_msgd_sel'){			
			$query .= ' and msgdfrom.msgd_no = "'.$data['lp_trmt_msgd_no1'].'" and msgdto.msgd_no = "'.$data['lp_trmt_msgd_no2'].'"';
			}							
		
		return array('query' => $query, 'param' => $param);		
	}

	//Select data from tmp_lap_kartustock
	public function get_lp_kartustok_query($data){
		$param['tmplks_tgldari'] = $data['tmplks_tgldari'];
		$param['tmplks_tglsampai'] = $data['tmplks_tglsampai'];
		$param['tmplks_mscb_nm'] = $data['mscb_listmscb'];
		$param['stok_awal'] = 0;
		if($data['tmplks_msgd'] != 'lp_msgd_all'){
			$param['tmplks_msgd_no'] = $data['tmplks_msgd_no'];
		}else{
			$param['tmplks_msgd_no'] = 'ALL';
		}

		$query = 'select tmp.*, mspd.mspd_nm, msgd.msgd_no, msgd.msgd_nm
		 			from tmp_lap_kartustok tmp
		 			left join ms_produk mspd
		 			on mspd.mspd_no = tmplks_mspd_no
		 			left join ms_gudang msgd
		 			on msgd.msgd_no = tmplks_msgd_no
		 			WHERE tmplks_idlap = '.$data['tmplks_idlap']. ' order by tmplks_tgl, tmplks_trans_jenis';
		
		$result = $this->db->query($query);
		if(count($result->result_array()) > 0){			
			$result = $result->result_array();
			$param['stok_awal'] = $result[0]['tmplks_qtyin'];		
		}

		return array('query' => $query, 'param' => $param);
	}	

	//public function insert_datato_tmp_lap_kartustock($data){
    public function insertto_tmp_lap_kartustock($data){
    	$inserttemp = 'INSERT INTO tmp_lap_kartustok(
          tmplks_idlap, 
          tmplks_mspd_no, 
          tmplks_tgl,
          tmplks_trans_jenis, 
          tmplks_trans_no, 
          tmplks_ket,
          tmplks_msgd_no,
          tmplks_qtyin,
          tmplks_qtyout,
          tmplks_harga) ';
    
	    // Tahap 1 - Query Stok Awal (sebelum tgldari) ===============================================================================================
	    // insert sebagai data tmplks_trans_jenis = "00"

	    // dari sales deivery - by tgl kirim
		$query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", 0, IFNULL(SUM(dtsd.dtsd_qtykrm),0), dtsd.dtsd_nett
	          FROM dt_sales_dlv dtsd
	          LEFT JOIN tr_sales_dlv trsd ON trsd.trsd_no = dtsd.dtsd_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trsd.trsd_mscb_no
	          WHERE trsd.trsd_void = 0 and dtsd.dtsd_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND trsd.trsd_tglkirim < "'.$data['tmplks_tgldari'].'" 
	          AND trsd.trsd_tglkirim > 0 AND POSITION(trsd.trsd_mscb_no in "'.$data['mscb_listmscb'].'")';
	      
	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trsd.trsd_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }
	    
	    $query .= ')';
	    $this->db->simple_query($query);

	    // dari sales delivery - by tgl balik
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", IFNULL(SUM(dtsd.dtsd_qtyrej),0), 0, dtsd.dtsd_nett
	          FROM dt_sales_dlv dtsd
	          LEFT JOIN tr_sales_dlv trsd ON trsd.trsd_no = dtsd.dtsd_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trsd.trsd_mscb_no
	          WHERE trsd.trsd_void = 0 and dtsd.dtsd_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND trsd.trsd_tglbalik < "'.$data['tmplks_tgldari'].'" AND trsd.trsd_tglbalik > 0 
	          AND POSITION(trsd.trsd_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trsd.trsd_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')';
	    $this->db->simple_query($query);

	    // dari sales retur - qtyin
	    $query =  $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", IFNULL(SUM(dtsr.dtsr_qtyretur),0), 0, dtsr.dtsr_nett
	          FROM dt_salesret dtsr
	          LEFT JOIN tr_salesret trsr ON trsr.trsr_no = dtsr.dtsr_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trsr.trsr_mscb_no
	          WHERE trsr.trsr_void = 0 and dtsr.dtsr_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND trsr.trsr_tglterima < "'.$data['tmplks_tgldari'].'" AND trsr.trsr_tglterima > 0 
	          AND POSITION(trsr.trsr_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trsr.trsr_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')';   
	    $this->db->simple_query($query);

	    // dari incoming delivery - qtyin

	    // $query = $inserttemp
	    //       .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", IFNULL(SUM(dtid.dtid_qtyterima),0), 0, IFNULL(dtid.dtid_nett,0)
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", IFNULL(SUM(dtid.dtid_qtyterima),0), 0, IFNULL(dtid.dtid_hpp,0)
	          FROM dt_in_dlv dtid
	          LEFT JOIN tr_in_dlv trid ON trid.trid_no = dtid.dtid_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trid.trid_mscb_no
	          WHERE trid.trid_void = 0 and dtid.dtid_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND trid.trid_tglterima < "'.$data['tmplks_tgldari'].'" AND trid.trid_tglterima > 0
	          AND POSITION(trid.trid_mscb_no in "'.$data['mscb_listmscb'].'")';
	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trid.trid_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')';
	    $this->db->simple_query($query);

	    //dari purchase retur - qtyout
	    // $query = $inserttemp
	    //       .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", 0, IFNULL(SUM(dtpt.dtpt_qtyretur),0), dtpt.dtpt_nett
		$query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", 0, IFNULL(SUM(dtpt.dtpt_qtyretur),0), dtpt.dtpt_hpp			  
	          FROM dt_purcret dtpt
	          LEFT JOIN tr_purcret trpt ON trpt.trpt_no = dtpt.dtpt_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trpt.trpt_mscb_no
	          WHERE trpt.trpt_void = 0 and dtpt.dtpt_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND trpt.trpt_tglkeluar < "'.$data['tmplks_tgldari'].'" AND trpt.trpt_tglkeluar > 0
	          AND POSITION(trpt.trpt_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trpt.trpt_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')'; 
	    $this->db->simple_query($query);

	    // dari adjusment stock - qtyin
	    $query =  $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", IFNULL(SUM(dtas.dtas_qty),0), 0, 0
	          FROM dt_adjstok dtas
	          LEFT JOIN tr_adjstok tras ON tras.tras_no = dtas.dtas_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = tras.tras_mscb_no
	          WHERE tras.tras_void = 0 and dtas.dtas_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(tras.tras_tgl, DATE) < "'.$data['tmplks_tgldari'].'") AND (CONVERT(tras.tras_tgl,DATE) > 0)
	          AND POSITION(msgd.msgd_listmscb in "'.$data['mscb_listmscb'].'")';
	          

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND tras.tras_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')'; 
	    $this->db->simple_query($query);

	    // dari mutasi - by tgl keluar (qtyout)
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", 0, IFNULL(SUM(dtmt.dtmt_qtyout),0), 0
	          FROM dt_mutasi dtmt
	          LEFT JOIN tr_mutasi trmt ON trmt.trmt_no = dtmt.dtmt_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trmt.trmt_mscb_no
	          WHERE trmt.trmt_void = 0 and dtmt.dtmt_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND trmt.trmt_tglkirim < "'.$data['tmplks_tgldari'].'" AND trmt.trmt_tglkirim > 0 
	          AND POSITION(trmt.trmt_mscb_no1 in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trmt.trmt_msgd_no1 = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')'; 
	    $this->db->simple_query($query);

	    // dari mutasi - by tgl terima (qtyin)
	    $query =  $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", IFNULL(SUM(dtmt.dtmt_qtyin),0), 0, 0
	          FROM dt_mutasi dtmt
	          LEFT JOIN tr_mutasi trmt ON trmt.trmt_no = dtmt.dtmt_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trmt.trmt_mscb_no
	          WHERE trmt.trmt_void = 0 and dtmt.dtmt_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND trmt.trmt_tglterima < "'.$data['tmplks_tgldari'].'" AND trmt.trmt_tglterima > 0 
	          AND POSITION(trmt.trmt_mscb_no2 in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trmt.trmt_msgd_no2 = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')';  
	    $this->db->simple_query($query);


	    // dari job costing (tfmgoods) - by qty out
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", 0, IFNULL(SUM(dtts.dtts_qty),0), dtts.dtts_hpp
	          FROM dt_tfmgoods dtts
	          LEFT JOIN tr_tfmgoods trts ON trts.trts_no = dtts.dtts_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trts.trts_mscb_no
	          WHERE trts.trts_void = 0 and dtts.dtts_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trts.trts_tgl, DATE) < "'.$data['tmplks_tgldari'].'") AND (CONVERT(trts.trts_tgl,DATE) > 0)
	          AND dtts.dtts_jenis = "F" AND POSITION(trts.trts_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trts.trts_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')';
	    $this->db->simple_query($query);

	    // dari job costing (tfmgoods) - by qty in
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", IFNULL(SUM(dtts.dtts_qty),0), 0, dtts.dtts_hpp
	          FROM dt_tfmgoods dtts
	          LEFT JOIN tr_tfmgoods trts ON trts.trts_no = dtts.dtts_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trts.trts_mscb_no
	          WHERE trts.trts_void = 0 and dtts.dtts_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trts.trts_tgl, DATE) < "'.$data['tmplks_tgldari'].'") AND (CONVERT(trts.trts_tgl, DATE) > 0)
	          AND dtts.dtts_jenis = "R" AND POSITION(trts.trts_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trts.trts_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')'; 
	    $this->db->simple_query($query);  


	    // dari goods convertion - by qty in
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", IFNULL(SUM(dtcv.dtcv_qty),0), 0, dtcv.dtcv_hpp
	          FROM dt_cvtgoods dtcv
	          LEFT JOIN tr_cvtgoods trcv ON trcv.trcv_no = dtcv.dtcv_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trcv.trcv_mscb_no
	          WHERE trcv.trcv_void = 0 and dtcv.dtcv_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trcv.trcv_tgl, DATE) < "'.$data['tmplks_tgldari'].'") AND (CONVERT(trcv.trcv_tgl, DATE) > 0)
	          AND dtcv.dtcv_jenis = "R" AND POSITION(trcv.trcv_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trcv.trcv_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')'; 
	    $this->db->simple_query($query);    


	    // dari goods convertion - by qty out
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", 0, IFNULL(SUM(dtcv.dtcv_qty),0), dtcv.dtcv_hpp
	          FROM dt_cvtgoods dtcv
	          LEFT JOIN tr_cvtgoods trcv ON trcv.trcv_no = dtcv.dtcv_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trcv.trcv_mscb_no
	          WHERE trcv.trcv_void = 0 and dtcv.dtcv_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trcv.trcv_tgl, DATE) < "'.$data['tmplks_tgldari'].'") AND (CONVERT(trcv.trcv_tgl, DATE) > 0)
	          AND dtcv.dtcv_jenis = "F" AND POSITION(trcv.trcv_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trcv.trcv_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }
	  
	    $query .= ')';   
	    $this->db->simple_query($query);

	    // dari detail sparepart SPK - by qty out
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "", "0000-00-00 00:00:00", "00", "", "", "", 0, IFNULL(SUM(dtspk.dtspk_qty),0), dtspk.dtspk_nett
	          FROM dt_spk_sp dtspk
	          LEFT JOIN tr_spk ON trspk_no = dtspk.dtspk_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trspk_mscb_no
	          WHERE trspk_void = 0 and dtspk.dtspk_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trspk_tgl, DATE) < "'.$data['tmplks_tgldari'].'") AND (CONVERT(trspk_tgl, DATE) > 0)
	          AND POSITION(trspk_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trspk_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }
	  
	    $query .= ')';
	    $this->db->simple_query($query);


	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $msgd = $data['tmplks_msgd_no'];
	    }else{
	      $msgd = '';
	    }

	    // Tahap 2 - Rekap / Hitung Total Stok Awal (sebelum tgldari) ===============================================================================================

	    // Tahap 2 A. SUM(tmplks.tmplks_qtyin - tmplks.tmplks_qtyout)
	    // insert sebagai data tmplks_trans_jenis = "01"
	    $inserttemp = 'INSERT INTO tmp_lap_kartustok(
	          tmplks_idlap, 
	          tmplks_mspd_no, 
	          tmplks_tgl,
	          tmplks_trans_jenis, 
	          tmplks_trans_no, 
	          tmplks_ket,
	          tmplks_msgd_no,
	          tmplks_qtyin,
	          tmplks_qtyout,
	          tmplks_harga)';

	    // insert dari tmp_lap_kartustock where tmplks.tmplks_trans_jenis = "00"
	    $query =  $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', "'.$data['tmplks_mspd_no'].'", "'.$data['tmplks_tgldari'].'", "01", "", "DATA AWAL '.$data['tmplks_tgldari'].'", "'.$msgd.'", IFNULL(SUM(tmplks.tmplks_qtyin - tmplks.tmplks_qtyout),0), 0, 0
	          FROM tmp_lap_kartustok tmplks
	          WHERE tmplks.tmplks_idlap = "'.$data['tmplks_idlap'].'"
	          AND tmplks.tmplks_trans_jenis = "00"';          

	    $query .= ')';   
	    $this->db->simple_query($query);
	    
	    // Tahap 2 B. Delete data temp stok awal (where tmplks_trans_jenis = "00")
	    $this->db->delete('tmp_lap_kartustok', array('tmplks_idlap' => $data['tmplks_idlap'], 'tmplks_trans_jenis' => '00'));   

	    
	    // Tahap 3 - Query Stok Periode yang dipilih (tgldari s.d. tglsampai) ===============================================================================================
	    $inserttemp = 'INSERT INTO tmp_lap_kartustok(
	          tmplks_idlap, 
	          tmplks_mspd_no, 
	          tmplks_tgl,
	          tmplks_trans_jenis, 
	          tmplks_trans_no, 
	          tmplks_ket,
	          tmplks_msgd_no,
	          tmplks_qtyin,
	          tmplks_qtyout,
	          tmplks_harga)';
	    
	    // dari tbl sales delivery - by tgl kirim/qtyout
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', dtsd.dtsd_mspd_no, trsd.trsd_tglkirim, "SD", dtsd.dtsd_no, CONCAT(dtsd.dtsd_no, " / SALES DELIVERY / ", mscs.mscs_nm), trsd.trsd_msgd_no, 0, dtsd.dtsd_qtykrm, dtsd.dtsd_nett
	          FROM dt_sales_dlv dtsd
	          LEFT JOIN tr_sales_dlv trsd ON trsd.trsd_no = dtsd.dtsd_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trsd.trsd_mscb_no
	          LEFT JOIN ms_customer mscs ON mscs.mscs_no = trsd.trsd_mscs_no
	          WHERE trsd.trsd_void = 0 
	          and dtsd.dtsd_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trsd.trsd_tglkirim, DATE) BETWEEN "'.$data['tmplks_tgldari'].'" AND "'.$data['tmplks_tglsampai'].'") 
	          AND POSITION(trsd.trsd_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trsd.trsd_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')';
	    $this->db->simple_query($query);

	    // dari tbl sales delivery - by tglbalik/qtyin
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', dtsd.dtsd_mspd_no, trsd.trsd_tglbalik, "DR", dtsd.dtsd_no, CONCAT(dtsd.dtsd_no, " / SALES DELIVERY REJECT / ", mscs.mscs_nm), trsd.trsd_msgd_no, dtsd.dtsd_qtyrej, 0, dtsd.dtsd_nett
	          FROM dt_sales_dlv dtsd
	          LEFT JOIN tr_sales_dlv trsd ON trsd.trsd_no = dtsd.dtsd_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trsd.trsd_mscb_no
	          LEFT JOIN ms_customer mscs ON mscs.mscs_no = trsd.trsd_mscs_no
	          WHERE trsd.trsd_void = 0
	          and dtsd.dtsd_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trsd.trsd_tglbalik,DATE) BETWEEN "'.$data['tmplks_tgldari'].'" AND "'.$data['tmplks_tglsampai'].'") 
	          AND POSITION(trsd.trsd_mscb_no in "'.$data['mscb_listmscb'].'")
	          AND dtsd.dtsd_qtyrej > 0';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trsd.trsd_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')'; 
	    $this->db->simple_query($query);

	    // dari tbl sales retur - qtyin
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', dtsr.dtsr_mspd_no, trsr.trsr_tglterima, "SR", dtsr.dtsr_no, CONCAT(dtsr.dtsr_no, " / SALES RETURN / ", mscs.mscs_nm), trsr.trsr_msgd_no, dtsr.dtsr_qtyretur, 0, dtsr.dtsr_nett
	          FROM dt_salesret dtsr
	          LEFT JOIN tr_salesret trsr ON trsr.trsr_no = dtsr.dtsr_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trsr.trsr_mscb_no
	          LEFT JOIN ms_customer mscs ON mscs.mscs_no = trsr.trsr_mscs_no
	          WHERE trsr.trsr_void = 0
	          and dtsr.dtsr_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trsr.trsr_tglterima, DATE) BETWEEN "'.$data['tmplks_tgldari'].'" AND "'.$data['tmplks_tglsampai'].'") 
	          AND POSITION(trsr.trsr_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trsr.trsr_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')';  
	    $this->db->simple_query($query);

	    // dari tbl incoming delivery
	    // $query = $inserttemp
	    //       .'(SELECT '.$data['tmplks_idlap'].', dtid.dtid_mspd_no, trid.trid_tglterima, "ID", dtid.dtid_no, CONCAT(dtid.dtid_no, " / INCOMING DELIVERY / ", mssp.mssp_nm), trid.trid_msgd_no, dtid.dtid_qtyterima, 0, dtid.dtid_nett

		$query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', dtid.dtid_mspd_no, trid.trid_tglterima, "ID", dtid.dtid_no, CONCAT(dtid.dtid_no, " / INCOMING DELIVERY / ", mssp.mssp_nm), trid.trid_msgd_no, dtid.dtid_qtyterima, 0, dtid.dtid_hpp
	          FROM dt_in_dlv dtid
	          LEFT JOIN tr_in_dlv trid ON trid.trid_no = dtid.dtid_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trid.trid_mscb_no
	          LEFT JOIN ms_supplier mssp ON mssp.mssp_no = trid.trid_mssp_no
	          WHERE trid.trid_void = 0
	          and dtid.dtid_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trid.trid_tglterima, DATE) BETWEEN "'.$data['tmplks_tgldari'].'" AND "'.$data['tmplks_tglsampai'].'") 
	          AND POSITION(trid.trid_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trid.trid_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')'; 
	    $this->db->simple_query($query);

	    // dari tbl purchase retur
	    // $query = $inserttemp
	    //       .'(SELECT '.$data['tmplks_idlap'].', dtpt.dtpt_mspd_no, trpt.trpt_tglkeluar, "PR", dtpt.dtpt_no, CONCAT(dtpt.dtpt_no, " / PURCHASE RETURN / ", mssp.mssp_nm), trpt.trpt_msgd_no, 0, dtpt.dtpt_qtyretur, dtpt.dtpt_nett

		$query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', dtpt.dtpt_mspd_no, trpt.trpt_tglkeluar, "PR", dtpt.dtpt_no, CONCAT(dtpt.dtpt_no, " / PURCHASE RETURN / ", mssp.mssp_nm), trpt.trpt_msgd_no, 0, dtpt.dtpt_qtyretur, dtpt.dtpt_hpp
	          FROM dt_purcret dtpt
	          LEFT JOIN tr_purcret trpt ON trpt.trpt_no = dtpt.dtpt_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trpt.trpt_mscb_no
	          LEFT JOIN ms_supplier mssp ON mssp.mssp_no = trpt.trpt_mssp_no
	          WHERE trpt.trpt_void = 0
	          and dtpt.dtpt_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trpt.trpt_tglkeluar,DATE) BETWEEN "'.$data['tmplks_tgldari'].'" AND "'.$data['tmplks_tglsampai'].'")
	          AND POSITION(trpt.trpt_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trpt.trpt_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')';  
	    $this->db->simple_query($query);

	    // dari tbl adjusment stock
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', dtas.dtas_mspd_no, tras.tras_tgl, "SA", dtas.dtas_no, CONCAT(dtas.dtas_no, " / STOCK ADJUSTMENT / ", msgd.msgd_nm), tras.tras_msgd_no, dtas.dtas_qty, 0, 0
	          FROM dt_adjstok dtas
	          LEFT JOIN tr_adjstok tras ON tras.tras_no = dtas.dtas_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = tras.tras_mscb_no
	          LEFT JOIN ms_gudang msgd ON msgd.msgd_no = tras.tras_msgd_no
	          WHERE tras.tras_void = 0 and dtas.dtas_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(tras.tras_tgl, DATE) BETWEEN "'.$data['tmplks_tgldari'].'" AND "'.$data['tmplks_tglsampai'].'") 
	          AND POSITION(msgd.msgd_listmscb in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND tras.tras_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')'; 
	    $this->db->simple_query($query);

	    // dari tbl mutasi - by tglkirim/qtyout
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', dtmt.dtmt_mspd_no, trmt.trmt_tglkirim, "MO", dtmt.dtmt_no, CONCAT(dtmt.dtmt_no, " / MUTASI OUT / ", msgd.msgd_nm), trmt.trmt_msgd_no1, 0, dtmt.dtmt_qtyout, 0
	          FROM dt_mutasi dtmt
	          LEFT JOIN tr_mutasi trmt ON trmt.trmt_no = dtmt.dtmt_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trmt.trmt_mscb_no1
	          LEFT JOIN ms_gudang msgd ON msgd.msgd_no = trmt.trmt_msgd_no2
	          WHERE trmt.trmt_void = 0 and dtmt.dtmt_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trmt.trmt_tglkirim, DATE) BETWEEN "'.$data['tmplks_tgldari'].'" AND "'.$data['tmplks_tglsampai'].'") 
	          AND POSITION(trmt.trmt_mscb_no1 in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trmt.trmt_msgd_no1 = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')'; 
	    $this->db->simple_query($query);

	    // dari tbl mutasi - by tglterima/qtyin
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', dtmt.dtmt_mspd_no, trmt.trmt_tglterima, "MI", dtmt.dtmt_no, CONCAT(dtmt.dtmt_no, " / MUTASI IN / ", msgd.msgd_nm), trmt.trmt_msgd_no2, dtmt.dtmt_qtyin, 0, 0
	          FROM dt_mutasi dtmt
	          LEFT JOIN tr_mutasi trmt ON trmt.trmt_no = dtmt.dtmt_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trmt.trmt_mscb_no2
	          LEFT JOIN ms_gudang msgd ON msgd.msgd_no = trmt.trmt_msgd_no1
	          WHERE trmt.trmt_void = 0 and dtmt.dtmt_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trmt.trmt_tglterima, DATE) BETWEEN "'.$data['tmplks_tgldari'].'" AND "'.$data['tmplks_tglsampai'].'") 
	          AND POSITION(trmt.trmt_mscb_no2 in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trmt.trmt_msgd_no2 = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')'; 
	    $this->db->simple_query($query);

	    // dari tbl job costing(tfmgoods) - byqtyout
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', dtts.dtts_mspd_no, trts.trts_tgl, "GI", dtts.dtts_no, CONCAT(dtts.dtts_no, " / GOODS TRANSFORMATION (FROM) / ", msgd.msgd_nm), trts.trts_msgd_no, 0, dtts.dtts_qty, dtts.dtts_hpp
	          FROM dt_tfmgoods dtts
	          LEFT JOIN tr_tfmgoods trts ON trts.trts_no = dtts.dtts_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trts.trts_mscb_no
	          LEFT JOIN ms_gudang msgd ON msgd.msgd_no = trts.trts_msgd_no
	          WHERE trts.trts_void = 0 and dtts.dtts_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trts.trts_tgl, DATE) BETWEEN "'.$data['tmplks_tgldari'].'" AND "'.$data['tmplks_tglsampai'].'") 
	          AND dtts.dtts_jenis = "F" AND POSITION(trts.trts_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trts.trts_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')'; 
	    $this->db->simple_query($query);

	    // dari job costing (tfmgoods) - by qtyin
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', dtts.dtts_mspd_no, trts.trts_tgl, "GO", dtts.dtts_no, CONCAT(dtts.dtts_no, " / GOODS TRANSFORMATION (RESULT) / ", msgd.msgd_nm), trts.trts_msgd_no, dtts.dtts_qty, 0, dtts.dtts_hpp
	          FROM dt_tfmgoods dtts
	          LEFT JOIN tr_tfmgoods trts ON trts.trts_no = dtts.dtts_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trts.trts_mscb_no
	          LEFT JOIN ms_gudang msgd ON msgd.msgd_no = trts.trts_msgd_no
	          WHERE trts.trts_void = 0 and dtts.dtts_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trts.trts_tgl, DATE) BETWEEN "'.$data['tmplks_tgldari'].'" AND "'.$data['tmplks_tglsampai'].'") 
	          AND dtts.dtts_jenis = "R" AND POSITION(trts.trts_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trts.trts_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')'; 
	    $this->db->simple_query($query);

	    // dari tbl goods Convertion - byqtyout
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', dtcv.dtcv_mspd_no, trcv.trcv_tgl, "CI", dtcv.dtcv_no, CONCAT(dtcv.dtcv_no, " / GOODS CONVERTION (FROM) / ", msgd.msgd_nm), trcv.trcv_msgd_no, 0, dtcv.dtcv_qty, dtcv.dtcv_hpp
	          FROM dt_cvtgoods dtcv
	          LEFT JOIN tr_cvtgoods trcv ON trcv.trcv_no = dtcv.dtcv_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trcv.trcv_mscb_no
	          LEFT JOIN ms_gudang msgd ON msgd.msgd_no = trcv.trcv_msgd_no
	          WHERE trcv.trcv_void = 0 and dtcv.dtcv_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trcv.trcv_tgl, DATE) BETWEEN "'.$data['tmplks_tgldari'].'" AND "'.$data['tmplks_tglsampai'].'") 
	          AND dtcv.dtcv_jenis = "F" 
	          AND POSITION(trcv.trcv_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trcv.trcv_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')';  
	    $this->db->simple_query($query);

	    // dari  goods Convertion - by qtyin
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', dtcv.dtcv_mspd_no, trcv.trcv_tgl, "CO", dtcv.dtcv_no, CONCAT(dtcv.dtcv_no, " / GOODS TRANSFORMATION (RESULT) / ", msgd.msgd_nm), trcv.trcv_msgd_no, dtcv.dtcv_qty, 0, dtcv.dtcv_hpp
	          FROM dt_cvtgoods dtcv
	          LEFT JOIN tr_cvtgoods trcv ON trcv.trcv_no = dtcv.dtcv_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trcv.trcv_mscb_no
	          LEFT JOIN ms_gudang msgd ON msgd.msgd_no = trcv.trcv_msgd_no
	          WHERE trcv.trcv_void = 0 and dtcv.dtcv_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trcv.trcv_tgl, DATE) BETWEEN "'.$data['tmplks_tgldari'].'" AND "'.$data['tmplks_tglsampai'].'") 
	          AND dtcv.dtcv_jenis = "R" 
	          AND POSITION(trcv.trcv_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trcv.trcv_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')'; 
	    $this->db->simple_query($query);

	    // dari tbl dt spk sp (dt_spk_sp) - byqtyout
	    $query = $inserttemp
	          .'(SELECT '.$data['tmplks_idlap'].', dtspk.dtspk_mspd_no, trspk.trspk_tgl, "SPK", dtspk.dtspk_no, CONCAT(dtspk.dtspk_no, " / SPK SPAREPART / ", msgd.msgd_nm), trspk.trspk_msgd_no, 0, dtspk.dtspk_qty, dtspk.dtspk_nett
	          FROM dt_spk_sp dtspk
	          LEFT JOIN tr_spk trspk on trspk.trspk_no = dtspk.dtspk_no
	          LEFT JOIN ms_cabang mscb ON mscb.mscb_no = trspk.trspk_mscb_no
	          LEFT JOIN ms_gudang msgd ON msgd.msgd_no = trspk.trspk_msgd_no
	          WHERE trspk.trspk_void = 0 and dtspk.dtspk_mspd_no = "'.$data['tmplks_mspd_no'].'"
	          AND (CONVERT(trspk.trspk_tgl, DATE) BETWEEN "'.$data['tmplks_tgldari'].'" AND "'.$data['tmplks_tglsampai'].'")
	          AND POSITION(trspk.trspk_mscb_no in "'.$data['mscb_listmscb'].'")';

	    if($data['tmplks_msgd'] != 'lp_msgd_all'){
	      $query .= ' AND trspk.trspk_msgd_no = "'.$data['tmplks_msgd_no'].'"';
	    }

	    $query .= ')';
	    $this->db->simple_query($query);


	    if($this->db->count_all('tmp_lap_kartustok') <= 1){
	      echo 'Data not found';      
	      die();
	    }
  	}

	public function delete_datatemp_bayrand($rand){
		$this->db->delete('tmp_lap_kartustok', array('tmplks_idlap' => $rand));
	}

	public function get_lp_rekonsile($data){
		$query = 'select trju_tgl, trju_tipe, trju_refno, trju_catatan, dtju_catatan,
					dtju_debet, dtju_kredit, if(dtju_cek="Y","Yes", "No") as dtju_cek,
					(CASE
						WHEN trju_reftipe = "SD" THEN "Sales Delivery"
						WHEN trju_reftipe = "DR" THEN "Sales Delivery - Reject"
						WHEN trju_reftipe = "PY" THEN "SO Payment"
						WHEN trju_reftipe = "SR" THEN "Sales Return"
						WHEN trju_reftipe = "AS" THEN "Stock Adjustment"
						WHEN trju_reftipe = "GT" THEN "Goods Transformation"
						WHEN trju_reftipe = "SP" THEN "SPK Penjualan"
						WHEN trju_reftipe = "SC" THEN "SPK COA"
						WHEN trju_reftipe = "PR" THEN "Purchase Return"
						WHEN trju_reftipe = "ID" THEN "Incoming Delivery"
						WHEN trju_reftipe = "AT" THEN "Aktiva Tetap"
						WHEN trju_reftipe = "PN" THEN "Penyusutan"
						WHEN trju_reftipe = "DA" THEN "Dispose Aktiva"
						WHEN trju_reftipe = "GC" THEN "Goods Convertion"
						WHEN trju_reftipe = "BK" THEN "Biaya Kirim (ID)"
						WHEN trju_reftipe = "BB" THEN "Bea (ID)"
						WHEN trju_reftipe = "PP" THEN "PO Payment"
						WHEN trju_reftipe = "PK" THEN "SPK Payment"
						WHEN trju_reftipe = "MD" THEN "Mutasi Delivery"
						WHEN trju_reftipe = "MR" THEN "Mutasi Receive"
						WHEN trju_reftipe = "SJ" THEN "Special Jurnal"
						WHEN trju_reftipe = "SK" THEN "Selisih Kurs"
						WHEN trju_reftipe = "PH" THEN "PPH 22 (ID)"
						WHEN trju_reftipe = "PS" THEN "PPN Shipping (ID)"
						ELSE trju_reftipe
					END) as trju_reftipe
				From dt_jurnal left join tr_jurnal on dtju_no = trju_no
				where (Convert(trju_tgl,Date) between "'.$data['lp_tgldari'].'" and "'.$data['lp_tglsampai'].'")
				       and trju_void="0" and POSITION(trju_mscb_no in "'.$data['mscb_listmscb'].'")';

		if($data['lp_msap'] != "lp_msap_all"){
			$query .= ' and dtju_msap_no = "'.$data['lp_msap_no'].'"';
			$param['msap_no'] = $data['lp_msap_no'];
			$param['msap_nm'] = $data['lp_msap_nm'];
		}else{
			$param['msap_no'] = "ALL";
			$param['msap_nm'] = "ALL";
		}
		
		// filter by jenis jurnal
		if($data['lp_trju_tipe'] != 'ALL'){
			if ($data['lp_trju_tipe'] == 'M') {
				$query .= ' and trju_tipe="M"';
				$param['tipe'] = 'Manual';
			} else if ($data['lp_trju_tipe'] == 'A'){
				$query .= ' and trju_tipe="A"';
				$param['tipe'] = 'Automatic';
			} else $param ['tipe'] = 'ALL';
		}

		// filter by status rekon
		if($data['rekon'] != "ALL"){
			if ($data['rekon'] == "Y") {
				$query .= ' and dtju_cek="Y"';
				$param['rekon'] = "YES";
			} else if ($data['rekon'] == "N"){
				$query .= ' and dtju_cek=""';
				$param['rekon'] = "NO";
			} 
		} else $param ['rekon'] = "ALL";

		// filter by no ref rekon
		if($data['ref'] != ""){
			$query .= ' and (trju_refno like "%'.$data['ref'].'%" or trju_reftipe like "%'.$data['ref'].'%")';
		}

		// filter catatan rekon
		if($data['cttn'] != ""){
			$query .= ' and (trju_catatan like "%'.$data['cttn'].'%" or dtju_catatan like "%'.$data['cttn'].'%")';
		}


		$query .= ' order by trju_tgl, trju_no, dtju_msap_no, dtju_seq';

		return array('query' => $query, 'param' => $param);		
	}

	public function get_lp_buku_besar($data){		
		$param['tgldari'] = $data['lp_tgldari'];
		$param['tglsampai'] = $data['lp_tglsampai'];
		$param['data_jurnal'] = $data['lp_trju_fin'];
		$param['cabang'] = $data['mscb_listmscb'];
		
		$query = 'select dtju.*, trju.trju_tgl, trju.trju_no, trju.trju_catatan,
					trju.trju_refno, trju.trju_reftipe, msag.msag_no, msag.msag_nm,
					if(trju_tipe="A","Automatic","Manual") as tipe,
					msap.msap_no, msap.msap_nm, msas.msas_no, msas.msas_nm,
					(CASE
						when trju.trju_reftipe="PP" Then "PO Payment"
						when trju.trju_reftipe="SD" Then "Sls Deliv"
						when trju.trju_reftipe="PY" Then "SO Payment"
						when trju.trju_reftipe="DR" Then "Sls Dlv Rej"
						when trju.trju_reftipe="SR" Then "Sls Ret"
						when trju.trju_reftipe="AS" Then "Adjust Stok"
						when trju.trju_reftipe="GT" Then "Goods Trans"
						when trju.trju_reftipe="SP" Then "SPK Penj"
						when trju.trju_reftipe="SC" Then "SPK COA"
						when trju.trju_reftipe="PR" Then "Purch Ret"
						when trju.trju_reftipe="ID" Then "Incom Dlv"
						when trju.trju_reftipe="AT" Then "Akt Ttp"
						when trju.trju_reftipe="PN" Then "Penyusutan"
						when trju.trju_reftipe="DA" Then "Dsps Akt"
						when trju.trju_reftipe="GC" Then "Goods Convrt"
						when trju.trju_reftipe="BK" Then "Biaya Krm (ID)"
						when trju.trju_reftipe="BB" Then "Bea (ID)"
						when trju.trju_reftipe="PP" Then "PO Paymnt"
						when trju.trju_reftipe="PK" Then "SPK Paymnt"
						when trju.trju_reftipe="MD" Then "Mutasi Dlv"
						when trju.trju_reftipe="MR" Then "Mutasi Rcive"
						when trju.trju_reftipe="PH" Then "PPH22(ID)"
						when trju.trju_reftipe="PS"THEN "PPN Shipping(ID)"
						else trju.trju_reftipe
					END) as reftipe
					, ifnull(saldoawal.total,0) as sa_total
                    FROM dt_jurnal dtju
					LEFT JOIN tr_jurnal trju on trju_no = dtju_no
					LEFT JOIN (select x.dtju_msap_no as sa_msap_no , sum(x.dtju_debet-x.dtju_kredit) as total
                               FROM dt_jurnal x
                               LEFT JOIN tr_jurnal y on x.dtju_no=y.trju_no
                               LEFT JOIN ms_cabang z on mscb_no = trju_mscb_no
                               WHERE y.trju_void=0 
                               		and y.trju_tgl < "'.$data['lp_tgldari'].'" 
                               		and POSITION(z.mscb_no IN "'.$data['mscb_listmscb'].'")
                               GROUP BY x.dtju_msap_no) as saldoawal on saldoawal.sa_msap_no = dtju.dtju_msap_no
					LEFT JOIN ms_accgrp msag on msag_no = substring(dtju_msap_no, 1,2)
					LEFT JOIN ms_accsub msas on msas_no = substring(dtju_msap_no,1,5)
					LEFT JOIN ms_accper msap on msap_no = dtju_msap_no
					LEFT JOIN ms_cabang mscb on mscb_no = trju_mscb_no
					where trju.trju_void = 0 
						and POSITION(mscb.mscb_no IN "'.$data['mscb_listmscb'].'")
						and trju.trju_tgl between "'.$data['lp_tgldari'].'" and "'.$data['lp_tglsampai'].'"';
		
		// filter by akun perkiraan
		if($data['lp_msap'] != 'ALL'){
			if ($data['lp_msap'] == 'lp_msag_sel'){
					// $str1 .= ' and substring(x.dtju_msap_no, 1,2) = "'. $data['lp_msag_no']. '"';						
					$query .= ' and substring(dtju.dtju_msap_no, 1,2) = "'. $data['lp_msag_no']. '"';
						
						$param['msag_no'] = $data['lp_msag_no'];
						$param['group'] = $data['lp_msag_nm'];
						$param['msas_no'] = 'ALL';
						$param['subgroup'] = 'ALL';
						$param['msap_no'] = 'ALL';
						$param['akunperkiraan'] = 'ALL';
				} else if ($data['lp_msap'] == 'lp_msas_sel'){
					// $str1 .= ' and substring(x.dtju_msap_no, 1,5) = "'. $data['lp_msas_no']. '"';
					$query .= ' and substring(dtju.dtju_msap_no, 1,5) = "'. $data['lp_msas_no']. '"';
						
						$param['msag_no'] = 'ALL';
						$param['group'] = 'ALL';
						$param['msas_no'] = $data['lp_msas_no'];
						$param['subgroup'] = $data['lp_msas_nm'];
						$param['msap_no'] = 'ALL';
						$param['akunperkiraan'] = 'ALL';
				} else if ($data['lp_msap'] == 'lp_msap_sel'){
					// $str1 .= ' and x.dtju_msap_no = "'. $data['lp_msap_no']. '"';
					$query .= ' and dtju.dtju_msap_no = "'. $data['lp_msap_no']. '"';
						$param['msag_no'] = 'ALL';
						$param['group'] = 'ALL';
						$param['msas_no'] = 'ALL';
						$param['subgroup'] = 'ALL';
						$param['msap_no'] = $data['lp_msap_no'];
						$param['akunperkiraan'] = $data['lp_msap_nm'];
				} else {
						$param['msag_no'] = 'ALL';
						$param['group'] = 'ALL';
						$param['msas_no'] = 'ALL';
						$param['subgroup'] = 'ALL';
						$param['msap_no'] = 'ALL';
						$param['akunperkiraan'] = 'ALL';
					}
			};

		//search by tipe data jurnal fin/com sebagai parameter
		if($data['lp_trju_fin'] == 'C'){
			$param['data_jurnal'] = "Commercial";
		} else if ($data['lp_trju_fin'] == 'F') {
			$param['data_jurnal'] = "Finance";
		} else {
			$param['data_jurnal'] = "ALL";
		}
		//end//

		if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
			// $str1 .= ' AND y.trju_fin = "'. $data['lp_trju_fin'].'"';
			$query .= ' AND trju.trju_fin = "'. $data['lp_trju_fin'].'"';
		}

		// filter by jenis jurnal
		if($data['lp_trju_tipe'] != 'ALL'){
			if ($data['lp_trju_tipe'] == 'M') {
					// $str1 .= ' and y.trju_tipe="M"';
					$query .= ' and trju.trju_tipe="M"';
					
					$param['tipe'] = 'Manual';
			} else if ($data['lp_trju_tipe'] == 'A'){
					// $str1 .= ' and y.trju_tipe="A"';
					$query .= ' and trju.trju_tipe="A"';
					
					$param['tipe'] = 'Automatic';
			} else $param ['tipe'] = 'ALL';
		}


		$query .= ' ORDER BY msag_no, msas_no, msap_no, trju_tgl';

		return array('query' => $query, 'param' => $param);		
	}

	public function get_lp_rugi_laba($data){		
		$param['bulan'] = $data['bulan'];
		$param['tahun'] = $data['tahun'];

		if ($data['bulan'] == '01') {
			$param['bulan'] = 'January';
		}   else if ($data['bulan'] == '02') {
			$param['bulan'] = 'February';
		}  else if ($data['bulan'] == '03') {
			$param['bulan'] = 'March';
		}  else if ($data['bulan'] == '04') {
			$param['bulan'] = 'April';
		}  else if ($data['bulan'] == '05') {
			$param['bulan'] = 'May';
		}  else if ($data['bulan'] == '06') {
			$param['bulan'] = 'June';
		}  else if ($data['bulan'] == '07') {
			$param['bulan'] = 'July';
		}  else if ($data['bulan'] == '08') {
			$param['bulan'] = 'August';
		}  else if ($data['bulan'] == '09') {
			$param['bulan'] = 'September';
		}  else if ($data['bulan'] == '10') {
			$param['bulan'] = 'October';
		}  else if ($data['bulan'] == '11') {
			$param['bulan'] = 'November';
		} else if ($data['bulan'] == '12') {
			$param['bulan'] = 'Desember';
		} else $param['bulan'] ='Bulan';
		
		$query = 'select hsas_no, hsas_nm, hsap_no, hsap_nm, ifnull(hscc_no, "") as hscc_no, ifnull(hscc_nm, "") as hscc_nm, hsag_kelompok, hsap_debet, hsap_kredit,
						ifnull(sum(hsap_debet-hsap_kredit),0) as saldo
					FROM his_accper hsap
					LEFT JOIN his_accgrp on hsag_no = substring(hsap_no,1,2) and hsap_periode = hsag_periode
					LEFT JOIN his_accsub on hsas_no = substring(hsap_no,1,5) and hsap_periode = hsas_periode
					LEFT JOIN his_costcenter on hscc_no = hsap_mscc_no and hsap_periode = hscc_periode
					WHERE hsag_jenis="I" 
					AND hsap_periode = "'.$data['tahun'].$data['bulan'].'"';

		if($data['opsi_cabang'] != 'all'){
			$query .= ' AND (hsap_mscb_no = "'.$data['cabang'].'" OR hsap_mscb_no = "")';
		}

		$query .= ' GROUP BY hsag_kelompok, hsas_no, hsap_no, hsap_mscc_no ';

		if($data['show_data_nol'] == 'N'){
			$query .= ' having ifnull(sum(hsap_debet-hsap_kredit), 0) <> 0 ';
		}

		$query .= 'ORDER BY hsag_kelompok, hsas_no, hsap_no, hscc_no';
					
		return array('query' => $query, 'param' => $param);		
	}

	public function get_neraca($data){		
		$param['bulan'] = $data['bulan'];
		$param['tahun'] = $data['tahun'];
		
		if ($data['bulan'] == '1') {
			$param['bulan'] = 'January';
		}   else if ($data['bulan'] == '2') {
			$param['bulan'] = 'February';
		}  else if ($data['bulan'] == '3') {
			$param['bulan'] = 'March';
		}  else if ($data['bulan'] == '4') {
			$param['bulan'] = 'April';
		}  else if ($data['bulan'] == '5') {
			$param['bulan'] = 'May';
		}  else if ($data['bulan'] == '6') {
			$param['bulan'] = 'June';
		}  else if ($data['bulan'] == '7') {
			$param['bulan'] = 'July';
		}  else if ($data['bulan'] == '8') {
			$param['bulan'] = 'August';
		}  else if ($data['bulan'] == '9') {
			$param['bulan'] = 'September';
		}  else if ($data['bulan'] == '10') {
			$param['bulan'] = 'October';
		}  else if ($data['bulan'] == '11') {
			$param['bulan'] = 'November';
		} else if ($data['bulan'] == '12') {
			$param['bulan'] = 'December';
		} else $param['bulan'] ='Bulan';
		
		
		$query = 'Select hsag_kelompok, hsas_no,hsas_nm,hsap_no, hsap_nm, ifnull(hscc_no, "") as hscc_no, ifnull(hscc_nm, "") as hscc_nm, ifnull(sum(hsap_debet - hsap_kredit),0) as saldo
						FROM his_accper
						left join his_accgrp on hsag_no = substring(hsap_no,1,2) AND hsag_periode = hsap_periode
						left join his_accsub on hsas_no = substring(hsap_no,1,5) AND hsas_periode = hsap_periode
						left join his_costcenter on hscc_no = hsap_mscc_no and hsap_periode = hscc_periode
						WHERE hsag_jenis="B"
						AND hsap_periode = "'.$data['tahun'].$data['bulan'].'"';

		if($data['opsi_cabang'] != 'all'){
			$query .= ' AND (hsap_mscb_no = "'.$data['cabang'].'" OR hsap_mscb_no = "")';
		}

		$query .= ' GROUP BY hsag_kelompok, hsas_no, hsap_no, hsap_mscc_no ';
					
		if($data['show_data_nol'] == 'N'){
			$query .= 'having ifnull(sum(hsap_debet - hsap_kredit),0) <> 0 ';
		}

		$query .= 'order by hsag_kelompok, hsas_no, hsap_no, hscc_no';

		return array('query' => $query, 'param' => $param);		
	}

	public function insertto_tmp_lap_mutasi_hutang_cust($thc_idlap, $mscs_no, $tgl_dari, $tgl_sampai){
		
    	$inserttemp = 'INSERT INTO tmp_lap_mutasi_hutang_cust(
					thc_idlap, 
					thc_tahap, 
					thc_mscs_no,
					thc_tgltran, 
					thc_jnstran, 
					thc_kettran,
					thc_dp,
					thc_value) ';
		
		// Tahap 1 - Insert Query Data Awal thc_tahap = 2 ===============================================================================================

		// dari sales deivery 
		$query = $inserttemp
					.'(SELECT '.$thc_idlap.', "2", "'.$mscs_no.'", trsd_tgl, "Sales Dlv", concat(trsd_no, " ", trso_catatan), "0", trsd_total
					FROM tr_sales_dlv
					LEFT JOIN tr_so on trso_no = substring(trsd_no,1,12) and trso_void=0
					WHERE trsd_mscs_no = "'.$mscs_no.'"
					AND trsd_tgl <= "'.$tgl_sampai.'"
					AND trsd_void = 0 )';
		
		$this->db->simple_query($query);
		
		// dari pembayaran SO (DP) 
		$query = $inserttemp
					.'(SELECT '.$thc_idlap.', "2", "'.$mscs_no.'", pbso_tglterima, "Pembayaran DP", concat(pbso_no," ", msjb_nm), pbso_jlhbayar, "0"
					FROM pby_so
					LEFT JOIN ms_jnspbyr on pbso_msjb_no = msjb_no
					LEFT JOIN tr_so on trso_no = substring(pbso_no,1,12) and trso_void=0
					WHERE trso_mscs_no = "'.$mscs_no.'"
					AND pbso_tglterima <= "'.$tgl_sampai.'"
					AND pbso_bayardp = "D"
					AND pbso_void = 0 )';

		$this->db->simple_query($query);

		// dari pembayaran SO (ADJUSTMENT DP) 
		$query = $inserttemp
					.'(SELECT '.$thc_idlap.', "2", "'.$mscs_no.'", pbso_tglterima, "Adjusment DP", concat(pbso_no," ", msjb_nm), -1*pbso_jlhbayar, "0"
					FROM pby_so
					LEFT JOIN ms_jnspbyr on pbso_msjb_no = msjb_no
					LEFT JOIN tr_so on trso_no = substring(pbso_no,1,12) and trso_void=0
					WHERE trso_mscs_no = "'.$mscs_no.'"
					AND pbso_tglterima <= "'.$tgl_sampai.'"
					AND pbso_bayardp = "C"
					AND pbso_void = 0 )';

		$this->db->simple_query($query);

		// dari pembayaran SO (Bayar Tagihan dari potong DP) 
		$query = $inserttemp
					.'(SELECT '.$thc_idlap.', "2", "'.$mscs_no.'", pbso_tglterima, "Pembayaran Invoice", concat(pbso_no," ", msjb_nm), -1*pbso_jlhbayar, -1*pbso_jlhbayar
					FROM pby_so
					LEFT JOIN ms_jnspbyr on pbso_msjb_no = msjb_no
					LEFT JOIN tr_so on trso_no = substring(pbso_no,1,12) and trso_void=0
					WHERE trso_mscs_no = "'.$mscs_no.'"
					AND pbso_tglterima <= "'.$tgl_sampai.'"
					AND pbso_bayardp = "T" and pbso_jenis = "D"
					AND pbso_void = 0 )';

		$this->db->simple_query($query);

		// dari pembayaran SO (Bayar Tagihan dari other (tidak potong DP)) 
		$query = $inserttemp
					.'(SELECT '.$thc_idlap.', "2", "'.$mscs_no.'", pbso_tglterima, "Pembayaran Invoice", concat(pbso_no," ", IF(pbso_jenis = "G", "Giro Masuk", IF(pbso_jenis = "T", "Transfer Masuk", msjb_nm))), "0", -1*pbso_jlhbayar
					FROM pby_so
					LEFT JOIN ms_jnspbyr on pbso_msjb_no = msjb_no
					LEFT JOIN tr_so on trso_no = substring(pbso_no,1,12) and trso_void=0
					WHERE trso_mscs_no = "'.$mscs_no.'"
					AND pbso_tglterima <= "'.$tgl_sampai.'"
					AND pbso_bayardp = "T" and (pbso_jenis = "G" OR pbso_jenis = "T" OR pbso_jenis = "O")
					AND pbso_void = 0 )';
		
		$this->db->simple_query($query);

		// dari sales retur 
		$query = $inserttemp
					.'(SELECT '.$thc_idlap.', "2", "'.$mscs_no.'", trsr_tglterima, "Sales Retur", concat(trsr_no," ", trsr_catatan), trsr_total, "0"
					FROM tr_salesret
					WHERE trsr_mscs_no = "'.$mscs_no.'"
					AND trsr_tglterima <= "'.$tgl_sampai.'"
					AND trsr_void = 0 )';

		$this->db->simple_query($query);

		// Tahap 2 - Insert untuk Rekap / Hitung Saldo Awal (sebelum tgldari) ===============================================================================================
		// dari tmp dengan thc tahap = 1 dan tgl dari awal
		$query = $inserttemp
					.'(SELECT '.$thc_idlap.', "1", "'.$mscs_no.'", "'.$tgl_dari.'", "Saldo Awal", concat("Saldo Awal ", "'.$tgl_dari.'"), 
						ifnull(sum(thc_dp),0), ifnull(sum(thc_value),0)
					FROM tmp_lap_mutasi_hutang_cust
					WHERE thc_idlap = "'.$thc_idlap.'"
					AND thc_tahap = 2
					AND thc_tgltran < "'.$tgl_dari.'")';
		
		
		$this->db->simple_query($query);
					
		// Tahap 3 - Delete data tmp where thc_tahap = 2  ===============================================================================================
		$this->db->delete('tmp_lap_mutasi_hutang_cust', array('thc_idlap' => $thc_idlap, 'thc_tahap' => '2', 'thc_tgltran < ' => $tgl_dari));

		// Tahap 4 - Query Select between tanggal dari - tgl sampai
		$query = 'select thc_tgltran, thc_jnstran, thc_kettran, thc_dp, thc_value
					from tmp_lap_mutasi_hutang_cust
					where thc_idlap = "'.$thc_idlap.'"
					order by thc_tahap, thc_tgltran, thc_jnstran, thc_kettran';
					
					return array('query' => $query);
	}

	public function delete_datatemp_bayrand_thc($rand){
		$this->db->delete('tmp_lap_mutasi_hutang_cust', array('thc_idlap' => $rand));
	}

	public function lap_tmp_lap_top_cust($data){
		
    	$inserttemp = 'INSERT INTO tmp_lap_top_cust(
					tltc_idlap, 
					tltc_tgl_jatuhtempo, 
					tltc_value,
					tltc_tgltran,
					tltc_notran,
					tltc_pocust,
					tltc_mscs_no,
					tltc_mssl_no, 
					tltc_total, 
					tltc_terbayar,
					tltc_catatan_top,
					tltc_catatan_tran,
					tltc_tag) ';
		
					
		// Tahap 1 - Insert Query Data dari TOP SO LEFT JOIN TR_SO ===============================================================================================
		$query_so = $inserttemp
					.'(SELECT '.$data['tltc_idlap'].', tpso_tgljatuhtempo, tpso_value, trso_tgl, trso_no, trso_pocust, trso_mscs_no, trso_mssl_no, trso_total,
						trso_terbayar, trso_catatan, tpso_cttn, trso_tag
					FROM top_so
					LEFT JOIN tr_so on trso_no = tpso_no
					WHERE tpso_tgljatuhtempo between "'.$data['tgl_dari'].'" and "'.$data['tgl_sampai'].'"
					AND POSITION(trso_mscb_no in "'.$data['mscb_listmscb'].'")
					AND trso_void = 0';
		
		// Tahap 2 - Insert Query Data dari TOP SPK LEFT JOIN TR_SPK ===============================================================================================
		$query_spk = $inserttemp
					.'(SELECT "'.$data['tltc_idlap'].'", tpspk_tgljatuhtempo, tpspk_value, trspk_tgl, trspk_no, " ", trspk_mscs_no, " ", 
						ifnull(dtspk.dtspk_sumnett,0), ifnull(pbyspk.pbspk_sumbayar,0), tpspk_cttn, trspk_catatan, trspk_tag
					FROM top_spk
					LEFT JOIN tr_spk on trspk_no = substring(tpspk_no,1,12)
					LEFT JOIN (SELECT dtspk_no, ifnull(sum(dtspk_nett*dtspk_qty),0) as dtspk_sumnett
					           FROM dt_spk_sp
					           GROUP BY dtspk_no) dtspk on trspk_no = dtspk.dtspk_no
					LEFT JOIN (SELECT pbspk_no, ifnull(sum(pbspk_jlhbayar),0) pbspk_sumbayar
					           FROM pby_spk 
					           WHERE pbspk_void=0
					           GROUP BY substring(pbspk_no,1,12)) pbyspk on trspk_no = substring(pbyspk.pbspk_no,1,12)
					WHERE tpspk_tgljatuhtempo between "'.$data['tgl_dari'].'" and "'.$data['tgl_sampai'].'"
					AND POSITION(trspk_mscb_no in "'.$data['mscb_listmscb'].'")
					AND trspk_void = 0';
		// LEFT JOIN tr_spk_visit on trspk_no = substring(trsv_no,1,12)
		// Tahap 3 - Query Select between tanggal dari - tgl sampai
		$query = 'select tltc_tgl_jatuhtempo, tltc_value, tltc_catatan_top, tltc_tgltran, tltc_notran,  tltc_pocust, tltc_mscs_no, mscs_nm, tltc_mssl_no, mssl_nm,
				 	tltc_total, tltc_terbayar, if(tltc_terbayar >= tltc_total, "Lunas", "Belum Lunas") as status_lunas,
				 	tltc_catatan_tran, tltc_tag
				from tmp_lap_top_cust
				LEFT JOIN ms_customer on mscs_no = tltc_mscs_no
				LEFT JOIN ms_sales on mssl_no = tltc_mssl_no
				where tltc_idlap = "'.$data['tltc_idlap'].'"';

		//  Tahap 3 - FILTER =====================================================================================================================================
			// filter by mscs_no
			if($data['lp_mscs_sel'] == 'lp_mscs_sel'){
				$param['mscs_nm'] = $data['mscs_nm'];
				$param['mscs_no'] = $data['mscs_no'];
				$query_so .= ' and trso_mscs_no = "'. $data['mscs_no'].'"';
				$query_spk .= ' and trspk_mscs_no = "'.$data['mscs_no'].'"';		
			}else{
				$param['mscs_nm'] = "ALL";
				$param['mscs_no'] = "ALL";
			}

			// filter by mssl_no
			if($data['lp_mssl_sel'] == 'lp_mssl_sel'){
				$param['mssl_nm'] = $data['mssl_nm'];
				$param['mssl_no'] = $data['mssl_no'];
				$query_so .= ' and trso_mssl_no = "'. $data['mssl_no'].'"';
				$query_spk .= ' and trsv_mssl_no = "'. $data['mssl_no'].'"';
			}else{
				$param['mssl_nm'] = "ALL";
				$param['mssl_no'] = "ALL";
			}

			//filter by status lunas
			if($data['lp_statuslunas'] != 'all'){
				if($data['lp_statuslunas'] == 1){
					$param['lp_statuslunas'] = "LUNAS";
					$query_so .= ' and trso_terbayar = trso_total';
					$query_spk .= ' AND IFNULL((SELECT SUM(pbspk_jlhbayar) 
									FROM pby_spk 
									WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0)
							 		>= 
								IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) 
									FROM dt_spk_sp 
									WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0)';

					// and dtspk.dtspk_sumnett = pbyspk.pbspk_sumbayar';
					$query .= ' and tltc_total = tltc_terbayar';
				} elseif ($data['lp_statuslunas'] == 2) {
					$param['lp_statuslunas'] = "BELUM LUNAS";
					$query_so .= ' and trso_terbayar < trso_total';
					$query_spk .= ' AND NOT(IFNULL((SELECT SUM(pbspk_jlhbayar) 
										FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0) 
										>= 
									IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) 
										FROM dt_spk_sp 
										WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0))';

					// and not dtspk.dtspk_sumnett = pbyspk.pbspk_sumbayar';
					$query .= ' and tltc_total > tltc_terbayar';
				} 
			} else {
				$param['lp_statuslunas'] = "ALL";
			}

		$query_so .= ')';
		$query_spk .= ')';
		$query .= ' order by tltc_tgl_jatuhtempo, tltc_notran';
		// die($query_so);
			//filter by sumber data
			if($data['sumberdata'] != "all"){
				if($data['sumberdata'] == 1 ){
					$this->db->simple_query($query_so);
				}elseif ($data['sumberdata'] == 2) {	
					$this->db->simple_query($query_spk);
				}
			} else {
				$this->db->simple_query($query_so);
				$this->db->simple_query($query_spk);
			}
		//==========================================================================================================================================================
		
		return array('query' => $query, 'param' => $param);
	}

	public function lap_tmp_lap_top_cust_new($data){
		
    	$inserttemp = 'INSERT INTO tmp_lap_top_cust(
					tltc_idlap, 
					tltc_tgl_jatuhtempo, 
					tltc_value,
					tltc_tgltran,
					tltc_notran,
					tltc_pocust,
					tltc_mscs_no,
					tltc_mssl_no, 
					tltc_total, 
					tltc_terbayar,
					tltc_catatan_top,
					tltc_catatan_tran,
					tltc_tag) ';
		
					
		// Tahap 1 - Insert Query Data dari TR_SALES_DLV LEFT JOIN TR_SO ===============================================================================================
		$query_sd = $inserttemp
					.'(SELECT '.$data['tltc_idlap'].', trsd_toptgl, (trsd_total-trsd_terbayar), trsd_tgl, trsd_no, trso_pocust, trsd_mscs_no, trso_mssl_no,
						trsd_total, trsd_terbayar, trsd_catatan, "", trso_tag
					FROM tr_sales_dlv
					LEFT JOIN tr_so on trso_no = substring(trsd_no,1,12)
					WHERE (Convert(trsd_toptgl, Date) between "'.$data['tgl_dari'].'" and "'.$data['tgl_sampai'].'") 
					AND POSITION(trsd_mscb_no in "'.$data['mscb_listmscb'].'")
					AND trsd_void = 0';

		// Tahap 2 - Insert Query Data dari TOP SPK LEFT JOIN TR_SPK ===============================================================================================
		$query_spk = $inserttemp
					.'(SELECT "'.$data['tltc_idlap'].'", trspk_toptgl, (ifnull(dtspk.dtspk_sumnett,0) - ifnull(pbyspk.pbspk_sumbayar,0)), 
						trspk_tgl, trspk_no, " ", trspk_mscs_no, " ", 
						ifnull(dtspk.dtspk_sumnett,0), ifnull(pbyspk.pbspk_sumbayar,0), "", trspk_catatan, trspk_tag
					FROM tr_spk
					LEFT JOIN (SELECT dtspk_no, ifnull(sum(dtspk_nett*dtspk_qty),0) as dtspk_sumnett
					           FROM dt_spk_sp
					           GROUP BY dtspk_no) dtspk on trspk_no = dtspk.dtspk_no
					LEFT JOIN (SELECT pbspk_no, ifnull(sum(pbspk_jlhbayar),0) pbspk_sumbayar
					           FROM pby_spk 
					           WHERE pbspk_void=0
					           GROUP BY substring(pbspk_no,1,12)) pbyspk on trspk_no = substring(pbyspk.pbspk_no,1,12)
					WHERE (Convert(trspk_toptgl,Date) between "'.$data['tgl_dari'].'" and "'.$data['tgl_sampai'].'") 
					AND POSITION(trspk_mscb_no in "'.$data['mscb_listmscb'].'")
					AND trspk_void = 0';
		// LEFT JOIN tr_spk_visit on trspk_no = substring(trsv_no,1,12)
		// Tahap 3 - Query Select between tanggal dari - tgl sampai
		$query = 'select tltc_tgl_jatuhtempo, tltc_value, tltc_catatan_top, tltc_tgltran, tltc_notran,  tltc_pocust, tltc_mscs_no, mscs_nm, tltc_mssl_no, mssl_nm,
				 	tltc_total, tltc_terbayar, if(tltc_terbayar >= tltc_total, "Lunas", "Belum Lunas") as status_lunas,
				 	tltc_catatan_tran, tltc_tag
				from tmp_lap_top_cust
				LEFT JOIN ms_customer on mscs_no = tltc_mscs_no
				LEFT JOIN ms_sales on mssl_no = tltc_mssl_no
				where tltc_idlap = "'.$data['tltc_idlap'].'"';

		//  Tahap 3 - FILTER =====================================================================================================================================
			// filter by mscs_no
			if($data['lp_mscs_sel'] == 'lp_mscs_sel'){
				$param['mscs_nm'] = $data['mscs_nm'];
				$param['mscs_no'] = $data['mscs_no'];
				$query_sd .= ' and trsd_mscs_no = "'. $data['mscs_no'].'"';
				$query_spk .= ' and trspk_mscs_no = "'.$data['mscs_no'].'"';		
			}else{
				$param['mscs_nm'] = "ALL";
				$param['mscs_no'] = "ALL";
			}

			// filter by mssl_no
			if($data['lp_mssl_sel'] == 'lp_mssl_sel'){
				$param['mssl_nm'] = $data['mssl_nm'];
				$param['mssl_no'] = $data['mssl_no'];
				$query_sd .= ' and trso_mssl_no = "'. $data['mssl_no'].'"';
				$query_spk .= ' and trsv_mssl_no = "'. $data['mssl_no'].'"';
			}else{
				$param['mssl_nm'] = "ALL";
				$param['mssl_no'] = "ALL";
			}

			//filter by status lunas
			if($data['lp_statuslunas'] != 'all'){
				if($data['lp_statuslunas'] == 1){
					$param['lp_statuslunas'] = "LUNAS";
					$query_sd .= ' and trsd_total >= trsd_terbayar';
					$query_spk .= ' AND IFNULL((SELECT SUM(pbspk_jlhbayar) 
									FROM pby_spk 
									WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0)
							 		>= 
								IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) 
									FROM dt_spk_sp 
									WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0)';

					// and dtspk.dtspk_sumnett = pbyspk.pbspk_sumbayar';
					$query .= ' and tltc_total = tltc_terbayar';
				} elseif ($data['lp_statuslunas'] == 2) {
					$param['lp_statuslunas'] = "BELUM LUNAS";
					$query_sd .= ' and trsd_terbayar < trsd_total';
					$query_spk .= ' AND NOT(IFNULL((SELECT SUM(pbspk_jlhbayar) 
										FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0) 
										>= 
									IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) 
										FROM dt_spk_sp 
										WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0))';

					// and not dtspk.dtspk_sumnett = pbyspk.pbspk_sumbayar';
					$query .= ' and tltc_total > tltc_terbayar';
				} 
			} else {
				$param['lp_statuslunas'] = "ALL";
			}

		$query_sd .= ')';
		$query_spk .= ')';
		$query .= ' order by tltc_tgl_jatuhtempo, tltc_notran';
		// die($query_spk);
			//filter by sumber data
			if($data['sumberdata'] != "all"){
				if($data['sumberdata'] == 1 ){
					$this->db->simple_query($query_sd);
				}elseif ($data['sumberdata'] == 2) {	
					$this->db->simple_query($query_spk);
				}
			} else {
				$this->db->simple_query($query_sd);
				$this->db->simple_query($query_spk);
			}
		//==========================================================================================================================================================
		
		return array('query' => $query, 'param' => $param);
	}

	public function delete_datatemp_bayrand_tltc($rand){
		$this->db->delete('tmp_lap_top_cust', array('tltc_idlap' => $rand));
	}

	public function get_lp_top_supplier($data){
		$query = 'select tppo_tgljatuhtempo, tppo_value, tppo_cttn, trpo_tgl, trpo_no, trpo_mssp_no, mssp_nm,
					trpo_curr, trpo_total, (trpo_total-trpo_terbayar) sisabayar, 
					if(trpo_total=trpo_terbayar, "Lunas", "Belum Lunas") as status_lunas,
					trpo_catatan, trpo_tag
				FROM top_po
				LEFT JOIN tr_po on trpo_no = tppo_no
				LEFT JOIN ms_supplier on trpo_mssp_no = mssp_no
				WHERE trpo_void = 0 and POSITION(trpo_mscb_no in "'.$data['mscb_listmscb'].'")
				and tppo_tgljatuhtempo between "'.$data['tgl_dari'].'" and "'.$data['tgl_sampai'].'"';

		//filter by po payment status
		if ($data['lp_statuslunas'] != 'ALL') {
			if($data['lp_statuslunas'] == 1 ){
				$param['trpostatus'] = 'PAYMENT SETTLED';
				$query .= ' and trpo_terbayar >= trpo_total';
			} else if ($data['lp_statuslunas'] == 2){
				$param['trpostatus'] = 'Unsettled PO';
				$query .= ' and trpo_terbayar < trpo_total';
			}	else $param['trpostatus'] = 'ALL'; 
		} 
		
		// filter by mssp (supplier)
		if($data['lp_mssp'] != 'ALL'){
			if ($data['lp_mssp'] == 'lp_mssp_lokal') {
				$param['mssp_jenis'] = 'Lokal';
				$param['mssp_nm'] ='';
				$query .= ' and mssp_jenis="L"';
			} else if ($data['lp_mssp'] == 'lp_mssp_import') {
				$param['mssp_jenis'] = 'Import';
				$param['mssp_nm'] ='';
				$query .= ' and mssp_jenis="I"';
			} else if ($data['lp_mssp'] == 'lp_mssp_sel'){
				$query .= ' and mssp_no = "'. $data['lp_mssp_no']. '"';
				$param['mssp_jenis'] = '';
				$param['mssp_nm'] = $data['lp_mssp_nm'];
			} else {
				$param['mssp_jenis'] ='ALL';
				$param['mssp_nm'] ='ALL';	
			}
		}

		//filter by tipe data (F/C)
		if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
			$query .= ' AND trpo_fin = "'. $data['lp_trju_fin'].'"';
		}

		return array('query' => $query, 'param' => $param);		
	}

	
	public function get_trans_jurnal_hpp($data){
		// delete tmp_lap_trans_jurnal_hpp by tmptjh_idlap
		$this->db->delete('tmp_lap_trans_jurnal_hpp', array('tmptjh_idlap' => $data['random_number']));

		// insert detail spk to tmp_lap_trans_jurnal_hpp
		$query = "INSERT INTO tmp_lap_trans_jurnal_hpp(
					tmptjh_idlap,
					tmptjh_trju_no,
					tmptjh_trju_tgl,
					tmptjh_trans_no,
					tmptjh_trans_tgl,
					tmptjh_trans_jenis,
					tmptjh_mspd_no,
					tmptjh_qty,
					tmptjh_hpp,
					tmptjh_catatan)
					(SELECT ".$data['random_number'].", 
						trju_no,
						trju_tgl,
						dtspk_no, 
						trspk_tgl,
						'SP',
						dtspk_mspd_no, 
						dtspk_qty,
						dtspk_hpp,
						'SPK'  
					FROM dt_spk_sp
					LEFT JOIN tr_spk ON trspk_no = dtspk_no
					LEFT JOIN tr_jurnal ON SUBSTRING(trju_refno, 1, 12) = trspk_no
					WHERE MONTH(trspk_tglselesai) = ".$data['periode_bulan']." 
					AND YEAR(trspk_tglselesai) = ".$data['periode_tahun']."
					AND trspk_void = 0";

		if($data['opsi_cabang'] != 'all'){
			$query .= " AND (trju_mscb_no = '".$data['cabang']."')";
		}	

		$query .= ")";

		$this->db->simple_query($query);		
						
		// insert detail sales return to tmp_lap_trans_jurnal_hpp
		$query = "INSERT INTO tmp_lap_trans_jurnal_hpp(
						tmptjh_idlap,
						tmptjh_trju_no,
						tmptjh_trju_tgl,
						tmptjh_trans_no,
						tmptjh_trans_tgl,
						tmptjh_trans_jenis,
						tmptjh_mspd_no,
						tmptjh_qty,
						tmptjh_hpp,
						tmptjh_catatan)
						(SELECT ".$data['random_number'].", 
							trju_no,
							trju_tgl,
							dtsr_no, 
							trsr_tgl,
							'SR',
							dtsr_mspd_no, 
							dtsr_qtyretur * -1,
							dtsr_hpp,
							'Sales Return' 
						FROM dt_salesret
						LEFT JOIN tr_salesret ON trsr_no = dtsr_no
						LEFT JOIN tr_jurnal ON trju_refno = trsr_no
						WHERE MONTH(trsr_tglterima) = ".$data['periode_bulan']."
						AND YEAR(trsr_tglterima) = ".$data['periode_tahun']."
						AND trsr_void = 0";

		if($data['opsi_cabang'] != 'all'){
			$query .= " AND (trju_mscb_no = '".$data['cabang']."')";
		}	

		$query .= ")";	

		$this->db->simple_query($query);
			
		// insert detail sales delivery to tmp_lap_trans_jurnal_hpp
		$query = "INSERT INTO tmp_lap_trans_jurnal_hpp(
					tmptjh_idlap,
					tmptjh_trju_no,
					tmptjh_trju_tgl,
					tmptjh_trans_no,
					tmptjh_trans_tgl,
					tmptjh_trans_jenis,
					tmptjh_mspd_no,
					tmptjh_qty,
					tmptjh_hpp,
					tmptjh_catatan)					
					(SELECT ".$data['random_number'].",
						trju_no,
						trju_tgl,
						dtsd_no, 
						trsd_tgl,
						'SD',
						dtsd_mspd_no, 
						dtsd_qtykrm - dtsd_qtyrej, 
						dtsd_hpp,
						'Sales Delivery'
					FROM dt_sales_dlv
					LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
					LEFT JOIN tr_jurnal ON trju_refno = CONCAT(trsd_no, 'SD')
					WHERE MONTH(CONVERT(trsd_tglkirim, DATE)) = ".$data['periode_bulan']."
					AND YEAR(CONVERT(trsd_tglkirim, DATE)) = ".$data['periode_tahun']."
					AND trsd_void = 0";

		if($data['opsi_cabang'] != 'all'){
			$query .= " AND (trju_mscb_no = '".$data['cabang']."')";
		}	

		$query .= ")";

		$this->db->simple_query($query);

		// get tmp_lap_trans_jurnal_hpp by tmptjh_idlap (random number)		
		$query = "SELECT tmptjh_trju_no,
							tmptjh_trju_tgl,
							tmptjh_trans_no,
							tmptjh_mspd_no,
							mspd_nm,
							tmptjh_qty,
							tmptjh_hpp,
							tmptjh_hpp * tmptjh_qty AS total_hpp,							
							tmptjh_catatan
				FROM tmp_lap_trans_jurnal_hpp
				LEFT JOIN ms_produk ON mspd_no = tmptjh_mspd_no
				WHERE tmptjh_idlap = ".$data['random_number'];
		$query = $this->db->query($query);
		
		// delete tmp_lap_trans_jurnal_hpp by tmptjh_idlap
		$this->db->delete('tmp_lap_trans_jurnal_hpp', array('tmptjh_idlap' => $data['random_number']));
		
		return $query->result_array();
	}
}
