<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_incoming_delivery extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('setting/m_user_log');		
	}

	public function get_incoming_delivery_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trid_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_in_dlv.*, mscb_nm, msgd_nm, mssp_nm, 
			IFNULL(pbidbk_jlhbayar, 0) AS pbidbk_jlhbayar, 
			IFNULL(pbidbk_adj, 0) AS pbidbk_adj, 
			IFNULL(pbidbm_jlhbayar, 0) AS pbidbm_jlhbayar,
			IFNULL(pbidbm_adj, 0) AS pbidbm_adj,
			IFNULL(pbidph_jlhbayar, 0) AS pbidph_jlhbayar,
			IFNULL(pbidph_adj, 0) AS pbidph_adj,
			IFNULL(pbidps_jlhbayar, 0) AS pbidps_jlhbayar,
			IFNULL(pbidps_adj, 0) AS pbidps_adj
			');
		$this->db->from('tr_in_dlv');		
		$this->db->join('ms_cabang','mscb_no = trid_mscb_no', 'left');		
		$this->db->join('ms_gudang','msgd_no = trid_msgd_no', 'left');		
		$this->db->join('ms_supplier','mssp_no = trid_mssp_no', 'left');		
		$this->db->join('pby_in_dlv_biayakirim','pbidbk_trid_no = trid_no', 'left');		
		$this->db->join('pby_in_dlv_beamasuk','pbidbm_trid_no = trid_no', 'left');		
		$this->db->join('pby_in_dlv_pph22','pbidph_trid_no = trid_no', 'left');		
		$this->db->join('pby_in_dlv_ppnshipping','pbidps_trid_no = trid_no', 'left');		

		$query_string = '';

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_po x1 WHERE x1.dtpo_no = SUBSTRING(trid_no, 1, 12) AND x1.dtpo_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';							
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_po x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtpo_mspd_no WHERE x2.dtpo_no = SUBSTRING(trid_no, 1, 12) AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}

		//Confirm receiving goods status
		//1. Confirmed
		//2. Not yet confirmed

		if(isset($arr_filter['confirm_idrg_status'])){			
			if($arr_filter['confirm_idrg_status'] == '1'){			
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= ' trid_tglterima != 0000-00-00';
			}elseif($arr_filter['confirm_idrg_status'] == '2'){			
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= ' trid_tglterima = 0000-00-00';			
			}		
			unset($arr_filter['confirm_idrg_status']);
		}				

		//Shipping fee payment status
		//1. Settled
		//2. Unsettled

		if(isset($arr_filter['sfp_status'])){			
			if($arr_filter['sfp_status'] == '1'){			
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= ' IFNULL(pbidbk_jlhbayar - pbidbk_adj, 0) >= tr_in_dlv.trid_totalbiayakirim';
			}elseif($arr_filter['sfp_status'] == '2'){			
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= ' IFNULL(pbidbk_jlhbayar - pbidbk_adj, 0) < tr_in_dlv.trid_totalbiayakirim';
				//$query_string .= ' NOT(IFNULL(pbidbk_jlhbayar, 0) > 0)';			
			}		
			unset($arr_filter['sfp_status']);
		}		

		//Bea masuk payment status
		//1. Settled
		//2. Unsettled

		if(isset($arr_filter['bmp_status'])){			
			if($arr_filter['bmp_status'] == '1'){			
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= ' IFNULL(pbidbm_jlhbayar - pbidbm_adj, 0) >= 
				                   IFNULL((Select sum(dtid_bea) 
				                   	from dt_in_dlv
				                   	where dtid_no = trid_no
				                   	),0)';
			}elseif($arr_filter['bmp_status'] == '2'){			
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= ' IFNULL(pbidbm_jlhbayar - pbidbm_adj, 0) < 
				                   IFNULL((Select sum(dtid_bea) 
				                   	from dt_in_dlv
				                   	where dtid_no = trid_no
				                   	),0)';	
			}		
			unset($arr_filter['bmp_status']);
		}				

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);
		
		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}

		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_incoming_delivery($trid_no){		
		$data = array();
		$trpo_no = substr($trid_no, 0, 12);
		
		//Get incoming delivery header berdasarkan trid_no	
		$this->db->select('tr_in_dlv.*, mssp_nm, mssp_cp, mssp_email, mssp_almt_jln, mssp_almt_kota, mssp_almt_negara,  mscb_nm,
								crtusr.msus_nm as msus_nm, lsusr.msus_nm as lsusr_msus_nm, msgd_nm, msgd_telp, msgd_pic, msgd_email, msgd_alamat , msgd_kota,
								trpo_cekint, trpo_curr, trpo_lock, trpo_fin, trpo_stcopy, 
								IFNULL(terimausr.msus_nm, "") as usrterima_nm,
							EXISTS(SELECT pbidbk_trid_no FROM pby_in_dlv_biayakirim WHERE pbidbk_trid_no = "'.$trid_no.'") AS is_bkcreated,
							EXISTS(SELECT pbidbm_trid_no FROM pby_in_dlv_beamasuk WHERE pbidbm_trid_no = "'.$trid_no.'") AS is_bmcreated,
							EXISTS(SELECT pbidps_trid_no FROM pby_in_dlv_ppnshipping WHERE pbidps_trid_no = "'.$trid_no.'") AS is_pscreated,
							EXISTS(SELECT pbidph_trid_no FROM pby_in_dlv_pph22 WHERE pbidph_trid_no = "'.$trid_no.'") AS is_phcreated,
							EXISTS(SELECT pbidpi_trid_no FROM pby_in_dlv_ppnimport WHERE pbidpi_trid_no = "'.$trid_no.'") AS is_picreated,
							EXISTS(SELECT pbpo_refno FROM pby_po WHERE pbpo_refno = "'.$trid_no.'" AND pbpo_void = 0) AS is_idhaspaid,
							IFNULL(pbidbk_jlhbayar, 0) AS pbidbk_jlhbayar, 
							IFNULL(pbidbk_adj, 0) AS pbidbk_adj, 
							IFNULL(pbidbm_jlhbayar, 0) AS pbidbm_jlhbayar,
							IFNULL(pbidbm_adj, 0) AS pbidbm_adj,
							IFNULL(pbidph_jlhbayar, 0) AS pbidph_jlhbayar,
							IFNULL(pbidph_adj, 0) AS pbidph_adj,
							IFNULL(pbidps_jlhbayar, 0) AS pbidps_jlhbayar,
							IFNULL(pbidps_adj, 0) AS pbidps_adj,
							IFNULL(pbidpi_jlhbayar, 0) AS pbidpi_jlhbayar,
							IFNULL(pbidpi_adj, 0) AS pbidpi_adj,
							IFNULL((Select sum(dtid_bea) 
				                   	from dt_in_dlv
				                   	where dtid_no = trid_no
				                   	),0) as trid_totalbea');
		$this->db->from('tr_in_dlv');
		$this->db->join('ms_supplier', 'mssp_no = trid_mssp_no', 'left');
		$this->db->join('ms_cabang', 'mscb_no = trid_mscb_no', 'left');		
		$this->db->join('ms_user as crtusr', 'crtusr.msus_no = trid_msus_no', 'left');	
		$this->db->join('ms_user as lsusr','lsusr.msus_no = trid_lsusr', 'left');
		$this->db->join('ms_user as terimausr', 'terimausr.msus_no = trid_usrterima', 'left');
		$this->db->join('ms_gudang', 'msgd_no = trid_msgd_no', 'left');		
		$this->db->join('tr_po', 'trpo_no = SUBSTRING(trid_no,1,12)', 'left');
		$this->db->join('pby_in_dlv_biayakirim','pbidbk_trid_no = trid_no', 'left');
		$this->db->join('pby_in_dlv_beamasuk','pbidbm_trid_no = trid_no', 'left');		
		$this->db->join('pby_in_dlv_pph22','pbidph_trid_no = trid_no', 'left');		
		$this->db->join('pby_in_dlv_ppnshipping','pbidps_trid_no = trid_no', 'left');		
		$this->db->join('pby_in_dlv_ppnimport','pbidpi_trid_no = trid_no', 'left');		
		$this->db->where('trid_no', $trid_no);
		$query = $this->db->get();
		
		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];			
		}

		//Get dt_in_dlv
		$this->db->select('dt_po.*, mspd_nm, mspd_dimensi,
							IFNULL(dt_in_dlv.dtid_no,"") AS dtid_no,
							IFNULL(dt_in_dlv.dtid_seq,"") AS dtid_seq,
							IFNULL(dt_in_dlv.dtid_mspd_no,"") AS dtid_mspd_no,
							IFNULL(dt_in_dlv.dtid_qtyterima,0) AS dtid_qtyterima,
							IFNULL(dt_in_dlv.dtid_dimensi,0) AS dtid_dimensi,
							IFNULL(dt_in_dlv.dtid_bftaxcurr,"") AS dtid_bftaxcurr,
							IFNULL(dt_in_dlv.dtid_taxcurr,"") AS dtid_taxcurr,
							IFNULL(dt_in_dlv.dtid_nettcurr,"") AS dtid_nettcurr,
							IFNULL(dt_in_dlv.dtid_bftax,"") AS dtid_bftax,
							IFNULL(dt_in_dlv.dtid_nett,"") AS dtid_nett,
							IFNULL(dt_in_dlv.dtid_bea,"") AS dtid_bea,
							IFNULL(dt_in_dlv.dtid_biayakirim,"") AS dtid_biayakirim,
							IFNULL(dt_in_dlv.dtid_biayaperunit,"") AS dtid_biayaperunit,
							IFNULL(dt_in_dlv.dtid_hpp,"") AS dtid_hpp,
							IFNULL((SELECT SUM(dtid_qtyterima) FROM dt_in_dlv LEFT JOIN tr_in_dlv ON trid_no = dtid_no WHERE SUBSTRING(dtid_no,1,12) = dtpo_no AND dtid_seq = dtpo_seq AND dtid_no <> "'. $trid_no .'" AND trid_void = 0),0) AS calc_qty_id');

		$this->db->from('dt_po');
		$this->db->join('dt_in_dlv', 'dtid_no = "'. $trid_no. '" AND dtid_seq = dtpo_seq', 'left');
		$this->db->join('ms_produk', 'mspd_no = dtpo_mspd_no', 'left');
		$this->db->where('dtpo_no', $trpo_no);
								
		$this->db->order_by('dtpo_seq', 'ASC');
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;
		}

		return $data;
		// if(count($data) > 0){
		// 	return $data;
		// }else{
		// 	return false;
		// }
	}

	public function get_incoming_delivery_biayakirim($pbidbk_trid_no){		
		$this->db->select('pby_in_dlv_biayakirim.*, msus_nm, mscb_nm');
		$this->db->from('pby_in_dlv_biayakirim');		
		$this->db->join('ms_user', 'ms_user.msus_no = pby_in_dlv_biayakirim.pbidbk_msus_no','inner');
		$this->db->join('ms_cabang', 'ms_cabang.mscb_no = pby_in_dlv_biayakirim.pbidbk_mscb_no','inner');
		$this->db->where(array('pbidbk_trid_no' => $pbidbk_trid_no));
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_incoming_delivery_ppnshipping($pbidps_trid_no){		
		$this->db->select('pby_in_dlv_ppnshipping.*, msus_nm, mscb_nm');
		$this->db->from('pby_in_dlv_ppnshipping');		
		$this->db->join('ms_user', 'ms_user.msus_no = pby_in_dlv_ppnshipping.pbidps_msus_no','inner');
		$this->db->join('ms_cabang', 'ms_cabang.mscb_no = pby_in_dlv_ppnshipping.pbidps_mscb_no','inner');
		$this->db->where(array('pbidps_trid_no' => $pbidps_trid_no));
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_incoming_delivery_bea($pbidbm_trid_no){		
		$this->db->select('pby_in_dlv_beamasuk.*, msus_nm, mscb_nm');
		$this->db->from('pby_in_dlv_beamasuk');		
		$this->db->join('ms_user', 'ms_user.msus_no = pby_in_dlv_beamasuk.pbidbm_msus_no','inner');
		$this->db->join('ms_cabang', 'ms_cabang.mscb_no = pby_in_dlv_beamasuk.pbidbm_mscb_no','inner');
		$this->db->where(array('pbidbm_trid_no' => $pbidbm_trid_no));
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_incoming_delivery_pph22($pbidph_trid_no){		
		$this->db->select('pby_in_dlv_pph22.*, msus_nm, mscb_nm');
		$this->db->from('pby_in_dlv_pph22');		
		$this->db->join('ms_user', 'ms_user.msus_no = pby_in_dlv_pph22.pbidph_msus_no','inner');
		$this->db->join('ms_cabang', 'ms_cabang.mscb_no = pby_in_dlv_pph22.pbidph_mscb_no','inner');
		$this->db->where(array('pbidph_trid_no' => $pbidph_trid_no));
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}		

	public function get_incoming_delivery_ppnimport($pbidpi_trid_no){		
		$this->db->select('pby_in_dlv_ppnimport.*, msus_nm, mscb_nm');
		$this->db->from('pby_in_dlv_ppnimport');		
		$this->db->join('ms_user', 'ms_user.msus_no = pby_in_dlv_ppnimport.pbidpi_msus_no','inner');
		$this->db->join('ms_cabang', 'ms_cabang.mscb_no = pby_in_dlv_ppnimport.pbidpi_mscb_no','inner');
		$this->db->where(array('pbidpi_trid_no' => $pbidpi_trid_no));
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}		

	public function get_incoming_delivery_bypoid($trpo_no){				
		//Get incoming delivery header berdasarkan trpo_no	
		$where_sql = "trid_terbayar < trid_total AND trid_tglterima <> '0000-00-00' AND trid_void = 0 AND SUBSTRING(trid_no, 1, 12) = '".$trpo_no."'";
		$this->db->select('*');
		$this->db->from('tr_in_dlv');						
		$this->db->where('SUBSTRING(trid_no, 1, 12) = ', $trpo_no);
		$this->db->where($where_sql, null, false);
		$query = $this->db->get();
				
		return $query->result_array();		
	}

	public function incoming_delivery_kode_auto($trpo_no){
		$this->db->select_max("trid_no");
		$this->db->like("trid_no", $trpo_no, "after");
		$query = $this->db->get("tr_in_dlv");
		if ($query->num_rows() == 0){
			return $trpo_no. "-DL01";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trid_no'];
			$nomor = ((int) substr($kode, 15)) + 1;			
			return $trpo_no. '-DL'. sprintf("%'.02d", $nomor);
		}
	}

	public function get_incoming_delivery_cekint($trid_no, $trid_cekint){		
		$query = $this->db->get_where('tr_in_dlv', array('trid_no' => $trid_no, 'trid_cekint' => $trid_cekint));			
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}		
	}		

	public function set_incoming_delivery_cekint($trid_no){		
		//Update trid_cekint di tabel tr_in_dlv
		$this->db->where('trid_no', $trid_no);
		$this->db->update('tr_in_dlv', array('trid_cekint' => rand(0,10000)));
	}

	public function incoming_delivery_simpan($data){
		try {							

				if($data['action'] == 'NEW'){
					// Insert data Incoming Delivery
					$this->insert_data($data);
					// Update trid_total
					$this->update_trid_total($data['header']['trid_no']);
				}

				if($data['action'] == 'EDIT'){
					// Update data Incoming Delivery
					$this->update_data($data);
					// Update trid_total
					$this->update_trid_total($data['header']['trid_no']);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);
				}

				if($data['action'] == 'CONF_RECEIVING_GOODS'){
					//todo list
					//1. Update data incoming delivery header/detail					
					//2. Update hpp (+)
					//3. Update stok (+)					
					//4. Create jurnal					

					//1. Update data incoming delivery header/detail
					$this->update_data($data);					
					// Update trid_total
					$this->update_trid_total($data['header']['trid_no']);
					//2. Update hpp (+)
					$this->save_update_hpp($data['header']['trid_no'], 1, 'IDR');
					// $this->update_hpp($data['header']['trid_no'], 1);
					//3. Update stok (+)
					$this->update_stok($data['header']['trid_no'], 1);					
					//4. Create jurnal
					$this->jurnal_simpan($data);					
				}

				if($data['action'] == 'CANCEL_RECEIVING_GOODS'){
					//todo list
					//1. Update hpp (-)
					//2. Update stok (-)
					//3. Update data incoming delivery header/detail					
					//4. Delete jurnal
					//5. Update status copy

					//1. Update hpp (-)
					$this->save_update_hpp($data['header']['trid_no'], -1,'IDC');
					// $this->update_hpp($data['header']['trid_no'], -1);
					//2. Update stok (-)
					$this->update_stok($data['header']['trid_no'], -1);
					//3. Update data incoming delivery header/detail
					$this->update_data($data);							
					//4. Delete jurnal
					$this->jurnal_hapus($data);					
				}
							
				if($data['action'] == 'VOID'){
					// Void data
					$this->void_data($data);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);
				}

				// Update data detail PO
				$this->update_dt_po($data);

				if($data['action'] == 'CONF_RECEIVING_GOODS' || $data['action'] == 'CANCEL_RECEIVING_GOODS'){					
					$this->load->model('purchase/m_purchase_order');					
					$this->m_purchase_order->update_stcopy($data['action'], substr($data['header']['trid_no'], 0, 12));
				}

			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function ppn_shipping_simpan($data){
		try{
			$this->db->where('trid_no', $data['header']['trid_no']);
			$this->db->update('tr_in_dlv', $data['header']);
			return 1;	
		} catch (Exception $e) {
			return 0;
		}
	}

	public function pph22_simpan($data){
		try{
			$this->db->where('trid_no', $data['header']['trid_no']);
			$this->db->update('tr_in_dlv', $data['header']);
			return 1;	
		} catch (Exception $e) {
			return 0;
		}
	}

	public function ppnimport_simpan($data){
		try{
			$this->db->where('trid_no', $data['header']['trid_no']);
			$this->db->update('tr_in_dlv', $data['header']);
			return 1;	
		} catch (Exception $e) {
			return 0;
		}
	}

	private function insert_data($data){
		//todo list
		//1. Insert header incoming delivery
		//2. Insert detail incoming delivery		

		//1. Insert header incoming delivery
		//Generate CekInt
		$data['header']['trid_cekint'] = rand(0,10000);
		$this->db->insert('tr_in_dlv',$data['header']);
		//2. Insert detail incoming delivery
		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $detail) {									
				$this->db->insert('dt_in_dlv',$data['detail'][$key]);
			}		
		}
	}	

	private function update_data($data){		
		$this->db->where('trid_no', $data['header']['trid_no']);
		$this->db->update('tr_in_dlv', $data['header']);
		
		$this->db->where(array('dtid_no' => $data['header']['trid_no']));
		$this->db->delete('dt_in_dlv');

		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $value) {							
				$this->db->insert('dt_in_dlv', $data['detail'][$key]);
			}						
		}
	}

	private function update_trid_total($trid_no){
		$query = "UPDATE tr_in_dlv SET trid_total ="
										."IFNULL(ROUND(("
										." SELECT SUM(A.dtid_nettcurr * A.dtid_qtyterima) FROM dt_in_dlv A"
										." WHERE A.dtid_no = '".$trid_no."'"					
										."), 4),0)"
				." WHERE tr_in_dlv.trid_no = '".$trid_no."'";				
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
	}

	private function update_dt_po($data){
		//Update dtpo_qtyid di detail po
		$this->update_qtyid($data['header']['trid_no']);
		
		if($data['action'] != 'NEW'){
			//Update dtpo_qtyterima di detail po
			$this->update_qtyterima($data['header']['trid_no']);
		}
	}

	private function update_qtyid($trid_no){
		$query = "UPDATE dt_po SET dtpo_qtyid =" 
					."IFNULL(("
					." SELECT SUM(A.dtid_qtyterima) FROM dt_in_dlv A"
					." LEFT JOIN tr_in_dlv B ON B.trid_no = A.dtid_no"
					." WHERE SUBSTRING(A.dtid_no,1,12) = dt_po.dtpo_no"
					." AND A.dtid_seq = dt_po.dtpo_seq"
					." AND B.trid_void = 0"
					."),0)"
				." WHERE dt_po.dtpo_no = '".substr($trid_no, 0, 12)."'";
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
	}

	private function update_qtyterima($trid_no){
		$query = "UPDATE dt_po SET dtpo_qtyterima ="
					."IFNULL(("
					." SELECT SUM(A.dtid_qtyterima) FROM dt_in_dlv A"
					." LEFT JOIN tr_in_dlv B ON B.trid_no = A.dtid_no"
					." WHERE SUBSTRING(A.dtid_no,1,12) = dt_po.dtpo_no"
					." AND A.dtid_seq = dt_po.dtpo_seq"
					." AND B.trid_void = 0"
					." AND B.trid_tglterima <> '0000-00-00'"
					."),0)"
				." WHERE dt_po.dtpo_no = '".substr($trid_no, 0, 12)."'";
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}
	}
	
	private function save_update_hpp($trid_no, $i, $trhpp_refjenis){
		$trhpp_tgl = date('Y-m-d H:i:s');

		$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
							(SELECT '".$trhpp_tgl."',
									'".$trhpp_refjenis."',
									'".$trid_no."',
									D.dtid_mspd_no, 
									(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtid_mspd_no),
									 P.mspd_hpp,
									 SUM(".$i." * D.dtid_qtyterima),
									ROUND(SUM((".$i." * D.dtid_qtyterima) * D.dtid_hpp), 4)
							FROM dt_in_dlv D 
							LEFT JOIN ms_produk P 
							ON P.mspd_no = D.dtid_mspd_no 
							LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtid_mspd_no,1,1)							
							WHERE D.dtid_no = '".$trid_no."'
							AND D.dtid_qtyterima > 0
							AND KT.mskt_statusinv = 'Y'							
							GROUP BY D.dtid_mspd_no, D.dtid_hpp)";

		$this->db->simple_query($query);

		$query = "UPDATE tr_his_hpp 
					SET trhpp_totalawal = ROUND((trhpp_qtyawal * trhpp_hppawal), 4),
						trhpp_hppakhir = IF(
							(trhpp_qtyawal + (trhpp_qtytrans)) <> 0,
							ROUND(
								((trhpp_qtyawal * trhpp_hppawal) + (trhpp_totaltrans))
								 /
								 (trhpp_qtyawal + (trhpp_qtytrans)), 4), trhpp_hppawal)
					WHERE trhpp_tgl = '".$trhpp_tgl."'
					AND trhpp_refjenis = '".$trhpp_refjenis."'
					AND trhpp_refno = '".$trid_no."'";

		$this->db->simple_query($query);

		$query = "UPDATE ms_produk P 
							SET P.mspd_hpp = IFNULL((SELECT trhpp_hppakhir FROM tr_his_hpp 
										WHERE trhpp_tgl = '".$trhpp_tgl."'
										AND trhpp_refjenis = '".$trhpp_refjenis."'
										AND trhpp_refno = '".$trid_no."'
										AND trhpp_mspd_no = P.mspd_no), P.mspd_hpp)
				WHERE P.mspd_no IN
					(SELECT dtid_mspd_no FROM dt_in_dlv D
					LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtid_mspd_no,1,1)
					WHERE D.dtid_no = '".$trid_no."'
					AND D.dtid_qtyterima > 0
					AND KT.mskt_statusinv = 'Y')";				

		$this->db->simple_query($query);
	}

	private function update_hpp($trid_no, $i){		
		$query = "UPDATE ms_produk SET mspd_hpp =ROUND("
									."((mspd_hpp * (SELECT SUM(A.msst_qty) FROM ms_stok A WHERE A.msst_mspd_no = ms_produk.mspd_no))"
									." +"
									." (SELECT (".$i." * SUM(B.dtid_qtyterima * B.dtid_hpp)) FROM dt_in_dlv B"
										." WHERE B.dtid_no = '".$trid_no."'"
										." AND B.dtid_mspd_no = ms_produk.mspd_no))"
									." /"
									." ((SELECT SUM(C.msst_qty) FROM ms_stok C WHERE C.msst_mspd_no = ms_produk.mspd_no)"
									 ." +"
									 ." (SELECT (".$i." * SUM(D.dtid_qtyterima)) FROM dt_in_dlv D"
										." WHERE D.dtid_no = '".$trid_no."'"
										." AND D.dtid_mspd_no= ms_produk.mspd_no)), 4)"
									 
									." WHERE ms_produk.mspd_no IN"
										." (SELECT E.dtid_mspd_no FROM dt_in_dlv E"
										." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(E.dtid_mspd_no,1,1)"
										." WHERE E.dtid_no = '".$trid_no."'"
										." AND KT.mskt_statusinv = 'Y')"
									
									." AND ((SELECT SUM(F.msst_qty) FROM ms_stok F WHERE F.msst_mspd_no = ms_produk.mspd_no)"
										." +"
										." (SELECT (".$i." * SUM(G.dtid_qtyterima)) FROM dt_in_dlv G"
										." WHERE G.dtid_no = '".$trid_no."'"
										." AND G.dtid_mspd_no= ms_produk.mspd_no)) <> 0";

		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
		
	}

	public function update_stok($trid_no, $i){
		$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
						." (SELECT DISTINCT A.dtid_mspd_no, B.trid_msgd_no, 0 FROM dt_in_dlv A"
						." LEFT JOIN tr_in_dlv B ON B.trid_no = A.dtid_no"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtid_mspd_no, 1,1)"
						//." LEFT JOIN ms_produk KT ON mspd.mspd_no = A.dtid_mspd_no"
						." WHERE A.dtid_no = '".$trid_no."'"
						." AND KT.mskt_statusinv = 'Y'"
						//." AND mspd.mspd_paket = 'N'"
						." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
								." WHERE C.msst_mspd_no = A.dtid_mspd_no"
								." AND C.msst_msgd_no= B.trid_msgd_no))";

		$this->db->simple_query($query);		

		$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
						." (".$i." * (SELECT SUM(A.dtid_qtyterima) FROM dt_in_dlv A"
						." WHERE A.dtid_no = '".$trid_no."'"
						." AND A.dtid_mspd_no = ms_stok.msst_mspd_no))"
				." WHERE ms_stok.msst_mspd_no IN"
						." (SELECT B.dtid_mspd_no FROM dt_in_dlv B"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtid_mspd_no,1,1)"
						//." LEFT JOIN ms_produk mspd ON mspd.mspd_no = B.dtid_mspd_no"
						." WHERE B.dtid_no = '".$trid_no."'"
						." AND KT.mskt_statusinv = 'Y'"
						//." AND mspd.mspd_paket = 'N'"
						." AND B.dtid_qtyterima <> 0)"
				." AND ms_stok.msst_msgd_no ="
						." (SELECT C.trid_msgd_no FROM tr_in_dlv C"
						." WHERE C.trid_no = '".$trid_no."')";		
			
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}					
	}

	private function void_data($data){
		//Set dtid_qtyid = 0 di tabel dt_po
		// $this->db->where(array('dtpo_no' => substr($data['header']['trid_no'], 0, 12)));
		// $this->db->update('dt_po', array('dtpo_qtyid' => 0));					
		//void incoming delivery
		$this->db->where('trid_no', $data['header']['trid_no']);
		$this->db->update('tr_in_dlv', array('trid_void'=>1));
	}

	public function incoming_delivery_biayakirim_simpan($data){
		try {						
			$this->db->where(array('trid_no' => $data['header']['pbidbk_trid_no']));
			$this->db->update('tr_in_dlv', array('trid_totalbiayakirim'=>$data['trid_totalbiayakirim']));						

			// Insert data 
			$this->db->insert('pby_in_dlv_biayakirim',$data['header']);

			// Create jurnal
			$this->jurnal_simpan($data);

			return 1;					
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function incoming_delivery_ppnshipping_simpan($data){
		try {						
			$this->db->where(array('trid_no' => $data['header']['pbidps_trid_no']));
			$this->db->update('tr_in_dlv', array('trid_totalppnshipping'=>$data['trid_totalppnshipping']));

			// Insert data 
			$this->db->insert('pby_in_dlv_ppnshipping',$data['header']);

			// Create jurnal
			$this->jurnal_simpan($data);

			return 1;					
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function incoming_delivery_pph22_simpan($data){
		try {						
			$this->db->where(array('trid_no' => $data['header']['pbidph_trid_no']));
			$this->db->update('tr_in_dlv', array('trid_totalpph22'=>$data['trid_totalpph22']));

			// Insert data 
			$this->db->insert('pby_in_dlv_pph22',$data['header']);

			// Create jurnal
			$this->jurnal_simpan($data);

			return 1;					
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function incoming_delivery_ppnimport_simpan($data){
		try {						
			$this->db->where(array('trid_no' => $data['header']['pbidpi_trid_no']));
			$this->db->update('tr_in_dlv', array('trid_totalppnimport'=>$data['trid_totalppnimport']));

			// Insert data 
			$this->db->insert('pby_in_dlv_ppnimport',$data['header']);

			// Create jurnal
			$this->jurnal_simpan($data);

			return 1;					
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function incoming_delivery_cancelbiayakirim($data){
		try {												
			// Delete pembayaran biaya kirim
			$this->db->delete('pby_in_dlv_biayakirim', array('pbidbk_trid_no' => $data['header']['pbidbk_trid_no']));
			// Hapus jurnal
			$this->jurnal_hapus($data);				
			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function incoming_delivery_cancelppnshipping($data){
		try {												
			// Delete pembayaran ppn shipping
			$this->db->delete('pby_in_dlv_ppnshipping', array('pbidps_trid_no' => $data['header']['pbidps_trid_no']));
			// Hapus jurnal
			$this->jurnal_hapus($data);				
			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function incoming_delivery_cancelpph22($data){
		try {												
			// Delete pembayaran PPh 22
			$this->db->delete('pby_in_dlv_pph22', array('pbidph_trid_no' => $data['header']['pbidph_trid_no']));
			// Hapus jurnal
			$this->jurnal_hapus($data);				
			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function incoming_delivery_cancelppnimport($data){
		try {
			// Delete pembayaran PPN Import
			$this->db->delete('pby_in_dlv_ppnimport', array('pbidpi_trid_no' => $data['header']['pbidpi_trid_no']));
			// Hapus jurnal
			$this->jurnal_hapus($data);				
			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function incoming_delivery_bea_simpan($data){
		try {										
				// Insert data 
				$this->db->insert('pby_in_dlv_beamasuk',$data['header']);			
				// Create jurnal
				$this->jurnal_simpan($data);
				return 1;											
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function incoming_delivery_cancelbea($data){
		try {												
			$this->db->delete('pby_in_dlv_beamasuk', array('pbidbm_trid_no' => $data['header']['pbidbm_trid_no']));			
			// Hapus jurnal
			$this->jurnal_hapus($data);						
			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	private function jurnal_simpan($data){
		// Generate CekInt
		$data['jurnal_h']['trju_cekint'] = rand(0,10000);			
		// Insert data header jurnal
		$this->db->insert('tr_jurnal',$data['jurnal_h']);
		
		//Insert data detail jurnal
		if(isset($data['jurnal_d'])){
			$seq = 1;
			foreach ($data['jurnal_d'] as $key => $detail) {														
				$data['jurnal_d'][$key]['dtju_no'] = $data['jurnal_h']['trju_no'];
				$data['jurnal_d'][$key]['dtju_seq'] = $seq;
				$this->db->insert('dt_jurnal',$data['jurnal_d'][$key]);
				$seq += 1;
			}		
		}		
	}

	private function jurnal_hapus($data){
		if(isset($data['jurnal_h']['trju_no']) && strlen($data['jurnal_h']['trju_no']) > 0){
			$this->db->delete('tr_jurnal', array('trju_no' => $data['jurnal_h']['trju_no']));
			$this->db->delete('dt_jurnal', array('dtju_no' => $data['jurnal_h']['trju_no']));
		}
	}
	
	public function cek_pby_biayakirim_exists($pbidbk_trid_no){
		$query = $this->db->get_where('pby_in_dlv_biayakirim', array('pbidbk_trid_no' => $pbidbk_trid_no));
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}	

	public function cek_pby_beamasuk_exists($pbidbm_trid_no){
		$query = $this->db->get_where('pby_in_dlv_beamasuk', array('pbidbm_trid_no' => $pbidbm_trid_no));
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}	

	public function get_incoming_delivery_bycust($mssp_no){						
		$where_sql = "trid_terbayar < trid_total AND trid_tglterima <> '0000-00-00' AND trid_void = 0";
		$this->db->select('tr_in_dlv.*, mssp_nm, DATE_FORMAT(trid_tgl, "%Y-%m-%d") as trid_tgl');
		$this->db->from('tr_in_dlv');
		$this->db->join('ms_supplier', 'mssp_no = trid_mssp_no', 'left');
		$this->db->where('trid_mssp_no', $mssp_no);
		$this->db->where($where_sql, null, false);
		$query = $this->db->get();
				
		return $query->result_array();		
	}
}
