<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_apv_pr extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('stok_kontrol/m_stok');
		$this->load->model('setting/m_user_log');
	}

	public function get_apv_pr_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'appr_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('apv_purcreq.*, msus_nm, mscb_nm');
		$this->db->from('apv_purcreq');
		$this->db->join('ms_user','msus_no = appr_msus_no', 'left');
		$this->db->join('ms_cabang','mscb_no = appr_mscb_no', 'left');

		$query_string = '';

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_apv_purcreq x1 WHERE x1.dappr_no = appr_no AND x1.dappr_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';							
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_apv_purcreq x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dappr_mspd_no WHERE x2.dappr_no = appr_no AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}		

		//PO status
		//1. PO-COMPLETE
		//2. PO-INCOMPLETE
		
		if(isset($arr_filter['po_status'])){
			if($arr_filter['po_status'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'NOT EXISTS(SELECT x3.* FROM dt_apv_purcreq x3 WHERE x3.dappr_no = appr_no AND dappr_trpo_no = "" AND dappr_qtyapv > 0)';
				//$query_string .= 'EXISTS(SELECT x4.* FROM dt_apv_purcreq x4 WHERE x4.dappr_no = appr_no AND dappr_trpo_no <> "" AND dappr_qtyapv > 0)';				
			}elseif($arr_filter['po_status'] == '2'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'EXISTS(SELECT x3.* FROM dt_apv_purcreq x3 WHERE x3.dappr_no = appr_no AND dappr_trpo_no = "" AND dappr_qtyapv > 0)';
			}
			unset($arr_filter['po_status']);
		}		

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}

	public function get_apv_pr($appr_no){		
		$data = array();		

		//Get approval PR header berdasarkan appr_no	
		$this->db->select('*, EXISTS(SELECT * FROM dt_apv_purcreq WHERE dappr_no = "'. $appr_no .'" AND dappr_trpo_no = "" AND dappr_qtyapv > 0) AS appr_postat, 
							NOT EXISTS(SELECT * FROM dt_apv_purcreq WHERE dappr_no = "'. $appr_no .'" AND dappr_qtyapv > 0) AS pr_not_approved, 
							NOT EXISTS(SELECT * FROM dt_apv_purcreq WHERE dappr_no = "'. $appr_no .'" AND dappr_trpo_no != "" AND dappr_qtyapv > 0) AS is_editable');
		$this->db->from('apv_purcreq');
		$this->db->join('ms_cabang', 'ms_cabang.mscb_no = apv_purcreq.appr_mscb_no','inner');
		$this->db->join('ms_user', 'ms_user.msus_no = apv_purcreq.appr_msus_no','inner');
		$this->db->where('apv_purcreq.appr_no',$appr_no);
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];
		}
		
		//Get approval PR detail berdasarkan appr_no
		$this->db->select('dt_apv_purcreq.*, ms_produk.*, dt_purcreq.*, trpr_no, trpr_tgl, trpr_msus_no, trpr_mscb_no, IFNULL((SELECT sum(dtpo_qtyterima) FROM dt_po LEFT JOIN tr_po ON trpo_no = dtpo_no WHERE dtpo_dappr_no = dappr_no AND dtpo_dappr_seq = dappr_seq AND trpo_void = 0), 0) AS dtpo_ig');
		$this->db->from('dt_apv_purcreq');
		$this->db->join('ms_produk', 'ms_produk.mspd_no = dt_apv_purcreq.dappr_mspd_no','left');		
		$this->db->join('tr_purcreq', 'tr_purcreq.trpr_no = dt_apv_purcreq.dappr_dtpr_no','left');		
		$this->db->join('dt_purcreq', 'dt_purcreq.dtpr_no = dt_apv_purcreq.dappr_dtpr_no AND dt_purcreq.dtpr_seq = dt_apv_purcreq.dappr_dtpr_seq','left');		
		$this->db->where('dt_apv_purcreq.dappr_no',$appr_no);
		$this->db->order_by('dappr_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;			
		}

		if(count($data) > 0){
			return $data;
		}else{
			return array();
		}
	}

	public function apv_pr_kode_auto($appr_kode_depan){
		$this->db->select_max("appr_no");
		$this->db->like("appr_no", $appr_kode_depan, "after");
		$query = $this->db->get("apv_purcreq");
		if ($query->num_rows() == 0){
			return $appr_kode_depan. "0001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['appr_no'];
			$nomor = ((int) substr($kode, 7)) + 1;			
			return $appr_kode_depan. sprintf("%'.04d", $nomor);
		}
	}	

	public function apvpr_detail_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'appr_no', $sort = 'DESC'){
		// $this->load->model('data_master/m_produk');
		// $avaliable_stock_query = $this->m_produk->avaliable_stock_query();
		$sql = "dt_apv_purcreq.*, mspd_nm, msmr_nm, mssp_no, mssp_nm, mskt_nm, msfm_nm, msmd_nm, appr_tag, mspd_fin, ";	

		// $sql .= $avaliable_stock_query." AS 'mspd_qtyavl'";

		$nlimit = $arr_filter['nlimit'];

		$this->db->select($sql);
		$this->db->from('dt_apv_purcreq');		
		$this->db->join('apv_purcreq', 'apv_purcreq.appr_no = dt_apv_purcreq.dappr_no','left');
		$this->db->join('ms_produk', 'ms_produk.mspd_no = dt_apv_purcreq.dappr_mspd_no','left');
		$this->db->join('ms_merk', 'ms_merk.msmr_no = ms_produk.mspd_msmr_no','left');
		$this->db->join('ms_supplier', 'ms_supplier.mssp_no = ms_produk.mspd_mssp_no','left');
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(dt_apv_purcreq.dappr_mspd_no,1,1)','left');
		$this->db->join('ms_famili', 'ms_famili.msfm_no = SUBSTRING(dt_apv_purcreq.dappr_mspd_no,1,3)','left');
		$this->db->join('ms_model', 'ms_model.msmd_no = SUBSTRING(dt_apv_purcreq.dappr_mspd_no,1,6)','left');

		if(count($arr_filter) != 0){

			// foreach ($arr_filter as $key => $value) {
			// 	if ($key == 'mspd_qtyavl') {
			// 		unset($arr_filter['mspd_qtyavl']);
			// 		$arr_filter[$avaliable_stock_query] = $value;
			// 		break;
			// 	}
			// }
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);
		}		

		$this->db->where(array('dappr_trpo_no'=>'', 'dappr_qtyapv >'=>0, 'appr_void'=> 0));
		$this->db->order_by($fn, $sort);		
		
		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}	
	

	public function get_apvpr_detail($arr_filter){
		// $this->load->model('data_master/m_produk');
		// $avaliable_stock_query = $this->m_produk->avaliable_stock_query();

		$sql = 'dt_apv_purcreq.*, mspd_nm, mspd_curr, mspd_pricelist, msmr_nm, mssp_no, 
				 mssp_nm, mspd_curr, mskt_nm, msfm_nm, msmd_nm, appr_tag, ';

		// $sql .= $avaliable_stock_query." AS 'mspd_qtyavl'";

		$nlimit = $arr_filter['nlimit'];

		$this->db->select($sql);
		$this->db->from('dt_apv_purcreq');		
		$this->db->join('apv_purcreq', 'apv_purcreq.appr_no = dt_apv_purcreq.dappr_no','left');
		$this->db->join('ms_produk', 'ms_produk.mspd_no = dt_apv_purcreq.dappr_mspd_no','left');
		$this->db->join('ms_merk', 'ms_merk.msmr_no = ms_produk.mspd_msmr_no','left');
		$this->db->join('ms_supplier', 'ms_supplier.mssp_no = ms_produk.mspd_mssp_no','left');
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(dt_apv_purcreq.dappr_mspd_no,1,1)','left');
		$this->db->join('ms_famili', 'ms_famili.msfm_no = SUBSTRING(dt_apv_purcreq.dappr_mspd_no,1,3)','left');
		$this->db->join('ms_model', 'ms_model.msmd_no = SUBSTRING(dt_apv_purcreq.dappr_mspd_no,1,6)','left');	

		if(count($arr_filter) != 0){

			// foreach ($arr_filter as $key => $value) {
			// 	if ($key == 'mspd_qtyavl') {
			// 		unset($arr_filter['mspd_qtyavl']);
			// 		$arr_filter[$avaliable_stock_query] = $value;
			// 		break;
			// 	}
			// }
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);
		}

		// if(count($arr_filter) != 0){
		// 	$this->db->like($arr_filter);			
		// }		
		$this->db->where(array('dappr_trpo_no'=>'', 'dappr_qtyapv >'=>0, 'appr_void'=> 0));
		
		// if($nlimit > 0){
		// 	$this->db->limit($nlimit);
		// }

		$query = $this->db->get();				
		return $query->result_array();
	}

	public function apv_pr_simpan($data){
		try {													
				if($data['action'] == 'NEW'){
					// Insert data approval PR
					$this->insert_data($data);
					// Insert data detail purchase request
					$this->update_dt_purcreq($data);
				}
				
				if($data['action'] == 'EDIT'){
					// Update data
					$this->update_data($data);
					// Insert data detail purchase request
					$this->update_dt_purcreq($data);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);
				}

				if($data['action'] == 'VOID'){
					// Void data
					$this->void_data($data);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);
				}				
				return 1;
		} catch (Exception $e) {
			return 0;
		}		
	}			

	private function insert_data($data){
		//Insert data header approval PR
		$this->db->insert('apv_purcreq',$data['header']);
	
		//Insert data detail approval PR
		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $value) {								
				// Generate CekInt			
				$data['detail'][$key]['dappr_cekint'] = rand(0,10000);
			    $this->db->insert('dt_apv_purcreq',$data['detail'][$key]);
			}		
		}				
	}

	private function update_data($data){
		//Update data header approval PR
		$this->db->where('appr_no', $data['header']['appr_no']);
		$this->db->update('apv_purcreq', $data['header']);
		
		//Delete data detail approval PR
		$this->db->where(array('dappr_no' => $data['header']['appr_no']));
		$this->db->delete('dt_apv_purcreq');

		//Insert data detail approval PR
		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $value) {							
				$data['detail'][$key]['dappr_cekint'] = rand(0,10000);				
				$this->db->insert('dt_apv_purcreq', $data['detail'][$key]);
			}						
		}
	}

	private function update_dt_purcreq($data){				
		//Update data detail purchase request
		if(isset($data['detail'])){
			//Reset/Update data detail purchase request				
			$this->db->where('dtpr_appr_no', $data['header']['appr_no']);
			$this->db->update('dt_purcreq', array('dtpr_qtyapv' => 0, 'dtpr_appr_no' => ''));

			//Update dtpr_qtyapv, dtpr_appr_no dan dtpr_cekint di table dt_purcreq
			foreach ($data['detail'] as $key => $value) {								
				$this->db->where(array('dtpr_no' => $data['detail'][$key]['dappr_dtpr_no'],
										'dtpr_seq' => $data['detail'][$key]['dappr_dtpr_seq']));

				$this->db->update('dt_purcreq', array('dtpr_qtyapv' => $data['detail'][$key]['dappr_qtyapv'],
														'dtpr_appr_no' => $data['detail'][$key]['dappr_no'],
														'dtpr_cekint' => rand(0,10000)));
			}
		}				
	}

	private function void_data($data){
		//Void data
		$this->db->where('appr_no', $data['header']['appr_no']);
		$this->db->update('apv_purcreq', array('appr_void' => 1));

		//Update dappr_cekint di table dt_apv_purcreq	
		$this->db->where('dappr_no', $data['header']['appr_no']);
		$this->db->update('dt_apv_purcreq', array('dappr_cekint' => rand(0,10000)));

		//Update dtpr_cekint, dtpr_qtyapv, dtpr_appr_no di table dt_purcreq	
		$this->db->where('dtpr_appr_no', $data['header']['appr_no']);
		$this->db->update('dt_purcreq', array('dtpr_cekint' => rand(0,10000), 'dtpr_qtyapv' => 0, 'dtpr_appr_no' => ''));
	}	

	public function get_apv_pr_cekint($dappr_no, $dappr_seq, $dappr_cekint){
		$query = $this->db->get_where('dt_apv_purcreq', array('dappr_no' => $dappr_no, 
																'dappr_seq' => $dappr_seq,
																'dappr_cekint' => $dappr_cekint));
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}				
	}

	public function set_apv_pr_cekint($dappr_no, $dappr_seq){
		$this->db->where(array('dappr_no' => $dappr_no, 'dappr_seq' => $dappr_seq));
		$this->db->update('dt_apv_purcreq', array('dappr_cekint' => rand(0, 10000)));
	}

	public function setall_apv_pr_cekint($dappr_trpo_no){
		$this->db->where(array('dappr_trpo_no' => $dappr_trpo_no));
		$this->db->update('dt_apv_purcreq', array('dappr_cekint' => rand(0, 10000)));
	}
	
	public function cek_appr_no_exists($appr_no){		
		$query = $this->db->get_where('apv_purcreq', array('appr_no' => $appr_no));
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}
}
