<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_simrel extends MY_Model {	

	private function fms_cabang_createtable(){
		$query = "DROP TABLE IF EXISTS ms_cabang";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_cabang ("
				    ."mscb_no char(1) NOT NULL,"
					."mscb_nm varchar(100) NOT NULL DEFAULT '',"
					."mscb_aktif tinyint NOT NULL DEFAULT 0,"
					."mscb_lsupd datetime NOT NULL,"
					."mscb_lsusr char(4) NOT NULL DEFAULT '',"  
				    ."PRIMARY KEY (mscb_no)"			
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
		if ($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}
	}

	private function fms_usergroup_createtable(){
		$query = "DROP TABLE IF EXISTS ms_usergroup";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_usergroup ("
				    ."msug_no char(4) NOT NULL,"
					."msug_nm varchar(100) NOT NULL DEFAULT '',"
					."msug_hakakses varchar(5000) NOT NULL DEFAULT '',"					
					."msug_aktif tinyint NOT NULL DEFAULT 0,"
					."msug_lsupd datetime NOT NULL,"
					."msug_lsusr char(4) NOT NULL DEFAULT '',"  
				    ."PRIMARY KEY (msug_no)"				    
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
		if ($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}
	}

	private function ftr_in_dlv_alter8(){
		$query = "ALTER TABLE tr_in_dlv ADD ("															
					." trid_usrterima varchar(4) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_in_dlv_createtable(){
		$query = "DROP TABLE IF EXISTS tr_in_dlv";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_in_dlv ("																																	
					."trid_no char(16) NOT NULL,"
					."trid_mscb_no char(1) NOT NULL DEFAULT '',"
					."trid_tgl date NOT NULL,"
					."trid_tglterima date NOT NULL,"
					."trid_msgd_no char(3) NOT NULL DEFAULT '',"
					."trid_pl_no varchar(100) NOT NULL DEFAULT '',"
					."trid_pl_tgl date NOT NULL,"
					."trid_pl_kontrak varchar(100) NOT NULL DEFAULT '',"
					."trid_pl_catatan varchar(250) NOT NULL DEFAULT '',"
					."trid_bl_no varchar(100) NOT NULL DEFAULT '',"
					."trid_bl_tgl date NOT NULL,"
					."trid_bl_tglestterima date NOT NULL,"
					."trid_bl_catatan varchar(250) NOT NULL DEFAULT '',"
					."trid_totalbiayakirim double NOT NULL DEFAULT 0,"
					."trid_totaldimensi double NOT NULL DEFAULT 0,"
					."trid_mssp_no char(6) NOT NULL DEFAULT '',"
					."trid_kurs double NOT NULL DEFAULT 0,"
					."trid_catatan varchar(250) NOT NULL DEFAULT '',"
					."trid_tag varchar(100) NOT NULL DEFAULT '',"
					."trid_nprint integer NOT NULL DEFAULT 0,"
					."trid_void tinyint NOT NULL DEFAULT 0,"
					."trid_cekint integer NOT NULL DEFAULT 0,"
					."trid_lsupd datetime NOT NULL,"
					."trid_lsusr char(4) NOT NULL DEFAULT '',"
					." PRIMARY KEY (trid_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_in_dlv_createtable(){
		$query = "DROP TABLE IF EXISTS dt_in_dlv";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_in_dlv ("																																						
					."dtid_no char(16) NOT NULL,"
					."dtid_seq int NOT NULL,"
					."dtid_mspd_no char(9) NOT NULL DEFAULT '',"
					."dtid_qtyterima double NOT NULL DEFAULT 0,"
					."dtid_dimensi double NOT NULL DEFAULT 0,"
					."dtid_nett double NOT NULL DEFAULT 0,"
					."dtid_bea double NOT NULL DEFAULT 0,"
					."dtid_biayakirim double NOT NULL DEFAULT 0,"
					."dtid_biayalain double NOT NULL DEFAULT 0,"
					."dtid_hpp double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dtid_no, dtid_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_user_createtable(){
		$query = "DROP TABLE IF EXISTS ms_user";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_user ("
				    ."msus_no char(4) NOT NULL,"
					."msus_nm varchar(100) NOT NULL DEFAULT '',"
					."msus_pswd varchar(32) NOT NULL DEFAULT '',"
					."msus_msug_no char(4) NOT NULL DEFAULT '',"
					."msus_mscb_no char(1) NOT NULL DEFAULT '',"
					."msus_aktif tinyint NOT NULL DEFAULT 0,"
					."msus_lsupd datetime NOT NULL,"
					."msus_lsusr char(4) NOT NULL DEFAULT '',"  
				    ."PRIMARY KEY (msus_no)"				    
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
		if ($this->db->simple_query($query)){
			return 1;
		}
		else{			
			return 0;
		}
	}

	private function fms_sales_createtable(){
		$query = "DROP TABLE IF EXISTS ms_sales";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_sales ("
					."mssl_no char(10) NOT NULL,"
					."mssl_nm varchar(100) NOT NULL DEFAULT '',"
					."mssl_listmscb varchar(250) NOT NULL DEFAULT '',"
					."mssl_aktif tinyint NOT NULL DEFAULT 0,"
					."mssl_lsupd datetime NOT NULL,"
					."mssl_lsusr char(4) NOT NULL DEFAULT '',"
				    ."PRIMARY KEY (mssl_no)"				    
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
		if ($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}

	}


	private function fms_customer_createtable(){
		$query = "DROP TABLE IF EXISTS ms_customer";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_customer ("		
					."mscs_no char(6) NOT NULL,"
					."mscs_nm varchar(100) NOT NULL DEFAULT '',"
					."mscs_jenis char(1) NOT NULL DEFAULT '',"
					."mscs_listmscb varchar(250) NOT NULL DEFAULT '',"
					."mscs_aktif tinyint NOT NULL DEFAULT 0,"
					."mscs_lsupd datetime NOT NULL,"
					."mscs_lsusr char(4) NOT NULL DEFAULT '',"
				    ."PRIMARY KEY (mscs_no)"				    
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
		if ($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}

	}

	private function fms_famili_createtable(){
		$query = "DROP TABLE IF EXISTS ms_famili";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_famili ("		
					."msfm_no char(3) NOT NULL,"
					."msfm_nm varchar(100) NOT NULL DEFAULT '',"
					."msfm_listmscb	varchar(250) NOT NULL DEFAULT '',"
					."msfm_aktif tinyint NOT NULL DEFAULT 0,"
					."msfm_lsupd datetime NOT NULL,"
					."msfm_lsusr char(4) NOT NULL DEFAULT '',"
				    ."PRIMARY KEY (msfm_no)"				    
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
		if ($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}

	}		

	private function fms_model_createtable(){
		$query = "DROP TABLE IF EXISTS ms_model";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_model ("					
					."msmd_no char(6) NOT NULL,"
					."msmd_nm varchar(100) NOT NULL DEFAULT '',"
					."msmd_listmscb varchar(250) NOT NULL DEFAULT '',"
					."msmd_aktif tinyint NOT NULL DEFAULT 0,"
					."msmd_lsupd datetime NOT NULL,"
					."msmd_lsusr char(4) NOT NULL DEFAULT '',"
				    ."PRIMARY KEY (msmd_no)"				    
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}

	}

	private function fms_merk_createtable(){
		$query = "DROP TABLE IF EXISTS ms_merk";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_merk ("					
					."msmr_no char(10) NOT NULL,"
					."msmr_nm varchar(100) NOT NULL DEFAULT '',"
					."msmr_listmscb varchar(250) NOT NULL DEFAULT '',"
					."msmr_aktif tinyint NOT NULL DEFAULT 0,"
					."msmr_lsupd datetime NOT NULL,"
					."msmr_lsusr char(4) NOT NULL DEFAULT '',"
				    ."PRIMARY KEY (msmr_no)"				    
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}

	}

	private function fms_produk_createtable(){
		$query = "DROP TABLE IF EXISTS ms_produk";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_produk ("					
					."mspd_no char(9) NOT NULL,"
					."mspd_nm varchar(100) NOT NULL DEFAULT '',"
					."mspd_msmr_no char(10) NOT NULL DEFAULT '',"
					."mspd_mssp_no char(6) NOT NULL DEFAULT '',"
					."mspd_listmscb	varchar(250) NOT NULL DEFAULT '',"
					."mspd_pricelist double NOT NULL DEFAULT 0,"
					."mspd_rop double NOT NULL DEFAULT 0,"
					."mspd_satuan varchar(10) NOT NULL DEFAULT '',"
					."mspd_dimensi double NOT NULL DEFAULT 0,"
					."mspd_berat double NOT NULL DEFAULT 0,"
					."mspd_curr varchar(10) NOT NULL DEFAULT '',"
					."mspd_reqserialno char(1) NOT NULL DEFAULT '',"
					."mspd_garansisp  integer NOT NULL DEFAULT 0,"
					."mspd_garansijasa  integer NOT NULL DEFAULT 0,"
					."mspd_tag varchar(100) NOT NULL DEFAULT '',"
					."mspd_aktif tinyint NOT NULL DEFAULT 0,"
					."mspd_lsupd datetime NOT NULL,"
					."mspd_lsusr char(4) NOT NULL DEFAULT '',"
				    ."PRIMARY KEY (mspd_no)"				    
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}

	}

	private function fms_gudang_createtable(){
		$query = "DROP TABLE IF EXISTS ms_gudang";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_gudang ("					
					."msgd_no char(3) NOT NULL,"
					."msgd_nm varchar(100) NOT NULL DEFAULT '',"
					."msgd_listmscb varchar(250) NOT NULL DEFAULT '',"
					."msgd_aktif tinyint NOT NULL DEFAULT 0,"
					."msgd_lsupd datetime NOT NULL,"
					."msgd_lsusr char(4) NOT NULL DEFAULT '',"
				    ."PRIMARY KEY (msgd_no)"				    
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}

	}

	private function fms_supplier_createtable(){
		$query = "DROP TABLE IF EXISTS ms_supplier";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_supplier ("							
					."mssp_no char(6) NOT NULL,"
					."mssp_nm varchar(100) NOT NULL DEFAULT '',"
					."mssp_jenis char(1) NOT NULL DEFAULT '',"
					."mssp_listmscb varchar(250) NOT NULL DEFAULT '',"
					."mssp_aktif tinyint NOT NULL DEFAULT 0,"
					."mssp_lsupd datetime NOT NULL,"
					."mssp_lsusr char(4) NOT NULL DEFAULT '',"
					."PRIMARY KEY (mssp_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
		if ($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}

	}


	// private function fms_stok_createtable(){
	// 	$query = "DROP TABLE IF EXISTS ms_stok";
	// 	$this->db->simple_query($query);

	// 	$query = "CREATE TABLE ms_stok ("					
	// 				."msst_mspd_no char(9) NOT NULL,"
	// 				."msst_01 double NOT NULL DEFAULT 0,"
	// 				."msst_02 double NOT NULL DEFAULT 0,"
	// 				."msst_03 double NOT NULL DEFAULT 0,"
	// 				."msst_04 double NOT NULL DEFAULT 0,"
	// 				."msst_05 double NOT NULL DEFAULT 0,"
	// 				."msst_06 double NOT NULL DEFAULT 0,"
	// 				."msst_07 double NOT NULL DEFAULT 0,"
	// 				."msst_08 double NOT NULL DEFAULT 0,"
	// 				."msst_09 double NOT NULL DEFAULT 0,"
	// 				."msst_10 double NOT NULL DEFAULT 0,"
	// 				."msst_11 double NOT NULL DEFAULT 0,"
	// 				."msst_12 double NOT NULL DEFAULT 0,"
	// 				."msst_13 double NOT NULL DEFAULT 0,"
	// 				."msst_14 double NOT NULL DEFAULT 0,"
	// 				."msst_15 double NOT NULL DEFAULT 0,"
	// 				."msst_16 double NOT NULL DEFAULT 0,"
	// 				."msst_17 double NOT NULL DEFAULT 0,"
	// 				."msst_18 double NOT NULL DEFAULT 0,"
	// 				."msst_19 double NOT NULL DEFAULT 0,"
	// 				."msst_20 double NOT NULL DEFAULT 0,"
	// 				."msst_wippr double NOT NULL DEFAULT 0,"
	// 				."msst_wippo double NOT NULL DEFAULT 0,"
	// 				."msst_wipmutasi double NOT NULL DEFAULT 0,"
	// 				."msst_wipsodekat double NOT NULL DEFAULT 0,"
	// 				."msst_wipsojauh double NOT NULL DEFAULT 0,"
	// 				."msst_cekint integer NOT NULL DEFAULT 0,"
	// 			    ."PRIMARY KEY (msst_mspd_no)"
	// 			    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

	// 	if ($this->db->simple_query($query)){
	// 		return 1;
	// 	}
	// 	else{
	// 		return 0;
	// 	}

	// }

	private function fms_kategori_createtable(){
			$query = "DROP TABLE IF EXISTS ms_kategori";
			$this->db->simple_query($query);

			$query = "CREATE TABLE ms_kategori ("				
						."mskt_no CHAR(1) NOT NULL,"
						."mskt_nm VARCHAR(100) NOT NULL DEFAULT '',"
						."mskt_listmscb VARCHAR(250) NOT NULL DEFAULT '',"
						."mskt_statusinv CHAR(1) NOT NULL DEFAULT '',"
						."mskt_discagen1 DOUBLE NOT NULL DEFAULT 0,"
						."mskt_discagen2 DOUBLE NOT NULL DEFAULT 0,"
						."mskt_discagen3 DOUBLE NOT NULL DEFAULT 0,"
						."mskt_discnonagen1 DOUBLE NOT NULL DEFAULT 0,"
						."mskt_discnonagen2 DOUBLE NOT NULL DEFAULT 0,"
						."mskt_discnonagen3 DOUBLE NOT NULL DEFAULT 0,"
						."mskt_aktif TINYINT NOT NULL DEFAULT 0,"
						."mskt_lsupd DATETIME NOT NULL,"
						."mskt_lsusr CHAR(4) NOT NULL DEFAULT '',"
						."PRIMARY KEY (mskt_no)"
					    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

			if ($this->db->simple_query($query)){
				return 1;
			}
			else{
				return 0;
			}

		}

	private function ftr_sales_inquery_createtable(){
			$query = "DROP TABLE IF EXISTS tr_sales_inquery";
			$this->db->simple_query($query);

			$query = "CREATE TABLE tr_sales_inquery ("				
						." trsi_no char(11) NOT NULL,"
						." trsi_mscb_no char(1) NOT NULL DEFAULT '',"
						." trsi_tgl date NOT NULL,"
						." trsi_mssl_no char(10) NOT NULL DEFAULT '',"
						." trsi_statusppn char(1) NOT NULL DEFAULT '',"
						." trsi_mscs_no char(6) NOT NULL DEFAULT '',"
						." trsi_cp varchar(100) NOT NULL DEFAULT '',"
						." trsi_kurs double NOT NULL DEFAULT 0,"
						." trsi_pocust varchar(100) NOT NULL DEFAULT '',"
						." trsi_subtotal double NOT NULL DEFAULT 0,"
						." trsi_ppn double NOT NULL DEFAULT 0,"
						." trsi_catatan varchar(250) NOT NULL DEFAULT '',"
						." trsi_tag varchar(100) NOT NULL DEFAULT '',"
						." trsi_nprint integer NOT NULL DEFAULT 0,"
						." trsi_void tinyint NOT NULL DEFAULT 0,"
						." trsi_cekint integer NOT NULL DEFAULT 0,"
						." trsi_lsupd datetime NOT NULL,"
						." trsi_lsusr char(4) NOT NULL DEFAULT '',"
						." trsi_top varchar(250) NOT NULL DEFAULT '',"
						." PRIMARY KEY (trsi_no)"
					    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

			if($this->db->simple_query($query)){
				return 1;
			}
			else{
				return 0;
			}			
		}

		private function fdt_sales_inquery_createtable(){
			$query = "DROP TABLE IF EXISTS dt_sales_inquery";
			$this->db->simple_query($query);

			$query = "CREATE TABLE dt_sales_inquery ("				
						." dtsi_no char(11) NOT NULL,"
						." dtsi_seq  integer NOT NULL DEFAULT 0,"
						." dtsi_mspd_no char(9) NOT NULL DEFAULT '',"
						." dtsi_pricelist double NOT NULL DEFAULT 0,"
						." dtsi_discpersen1 double NOT NULL DEFAULT 0,"
						." dtsi_discpersen2 double NOT NULL DEFAULT 0,"
						." dtsi_discpersen3 double NOT NULL DEFAULT 0,"
						." dtsi_discrp double NOT NULL DEFAULT 0,"
						." dtsi_nett double NOT NULL DEFAULT 0,"
						." dtsi_qty double NOT NULL DEFAULT 0,"						
						." PRIMARY KEY (dtsi_no, dtsi_seq)"						
					    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

			if($this->db->simple_query($query)){
				return 1;
			}
			else{
				return 0;
			}			
		}


	private function ftr_purcreq_createtable(){
		$query = "DROP TABLE IF EXISTS tr_purcreq";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_purcreq ("									
					." trpr_no char(11) NOT NULL,"
					." trpr_mscb_no char(1) NOT NULL DEFAULT '',"						
					." trpr_tgl date NOT NULL,"
					." trpr_catatan varchar(250) NOT NULL DEFAULT '',"
					." trpr_tag varchar(100) NOT NULL DEFAULT '',"
					." trpr_nprint integer NOT NULL DEFAULT 0,"
					." trpr_void tinyint NOT NULL DEFAULT 0,"
					." trpr_lsupd datetime NOT NULL,"
					." trpr_lsusr char(4) NOT NULL DEFAULT '',"
					." trpr_msus_no char(4) NOT NULL DEFAULT '',"
					." PRIMARY KEY (trpr_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_purcreq_createtable(){
		$query = "DROP TABLE IF EXISTS dt_purcreq";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_purcreq ("				
					." dtpr_no char(11) NOT NULL,"
					." dtpr_seq integer NOT NULL,"
					." dtpr_mspd_no char(9) NOT NULL DEFAULT '',"
					." dtpr_qtyreq double NOT NULL DEFAULT 0,"
					." dtpr_qtyapv double NOT NULL DEFAULT 0,"
					// ." dtpr_trpo_no char(11) NOT NULL DEFAULT '',"
					." dtpr_appr_no char(11) NOT NULL DEFAULT '',"
					." dtpr_cekint integer NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dtpr_no, dtpr_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_customer_alter1(){					
		$query = "ALTER TABLE ms_customer ADD ("										
					." mscs_top varchar(250) NOT NULL DEFAULT '',"
					." mscs_tag varchar(100) NOT NULL DEFAULT '',"
					." mscs_ppn char(1) NOT NULL DEFAULT 'Y',"
					." mscs_telp varchar(100) NOT NULL DEFAULT '',"
					." mscs_email varchar(100) NOT NULL DEFAULT '',"
					." mscs_cp varchar(100) NOT NULL DEFAULT '',"
					." mscs_almt_jln varchar(250) NOT NULL DEFAULT '',"
					." mscs_almt_kota varchar(100) NOT NULL DEFAULT '',"
					." mscs_almt_negara varchar(100) NOT NULL DEFAULT '',"
					." mscs_catatan varchar(250) NOT NULL DEFAULT '',"
					." mscs_kirim_jln varchar(250) NOT NULL DEFAULT '',"
					." mscs_kirim_kota varchar(100) NOT NULL DEFAULT '',"
					." mscs_kirim_negara varchar(100) NOT NULL DEFAULT '')";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}
		

	private function fms_supplier_alter1(){					
		$query = "ALTER TABLE ms_supplier ADD ("										
					." mssp_top varchar(250) NOT NULL DEFAULT '',"
					." mssp_tag varchar(100) NOT NULL DEFAULT '',"
					." mssp_ppn char(1) NOT NULL DEFAULT 'Y',"
					." mssp_telp varchar(100) NOT NULL DEFAULT '',"
					." mssp_email varchar(100) NOT NULL DEFAULT '',"
					." mssp_cp varchar(100) NOT NULL DEFAULT '',"
					." mssp_almt_jln varchar(250) NOT NULL DEFAULT '',"
					." mssp_almt_kota varchar(100) NOT NULL DEFAULT '',"
					." mssp_almt_negara varchar(100) NOT NULL DEFAULT '',"
					." mssp_catatan varchar(250) NOT NULL DEFAULT '',"
					." mssp_bank1_nm varchar(100) NOT NULL DEFAULT '',"
					." mssp_bank1_almt varchar(250) NOT NULL DEFAULT '',"
					." mssp_bank1_accno varchar(100) NOT NULL DEFAULT '',"
					." mssp_bank1_accnm varchar(100) NOT NULL DEFAULT '',"
					." mssp_bank1_swift varchar(100) NOT NULL DEFAULT '',"
					." mssp_bank2_nm varchar(100) NOT NULL DEFAULT '',"
					." mssp_bank2_almt varchar(250) NOT NULL DEFAULT '',"
					." mssp_bank2_accno varchar(100) NOT NULL DEFAULT '',"
					." mssp_bank2_accnm varchar(100) NOT NULL DEFAULT '',"
					." mssp_bank2_swift varchar(100) NOT NULL DEFAULT '',"
					." mssp_bank3_nm varchar(100) NOT NULL DEFAULT '',"
					." mssp_bank3_almt varchar(250) NOT NULL DEFAULT '',"
					." mssp_bank3_accno varchar(100) NOT NULL DEFAULT '',"
					." mssp_bank3_accnm varchar(100) NOT NULL DEFAULT '',"
					." mssp_bank3_swift varchar(100) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function ftr_so_createtable(){
		$query = "DROP TABLE IF EXISTS tr_so";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_so ("						
					." trso_no char(11) NOT NULL,"
					." trso_mscb_no char(1) NOT NULL DEFAULT '',"
					." trso_tgl date NOT NULL,"
					." trso_tglestkirim date NOT NULL,"
					." trso_mssl_no char(10) NOT NULL DEFAULT '',"
					." trso_statusppn char(1) NOT NULL DEFAULT '',"
					." trso_mscs_no char(6) NOT NULL DEFAULT '',"
					." trso_alamatkirim varchar(250) NOT NULL DEFAULT '',"
					." trso_cp varchar(100) NOT NULL DEFAULT '',"
					." trso_ekspedisi varchar(100) NOT NULL DEFAULT '',"
					." trso_kurs double NOT NULL DEFAULT 0,"
					." trso_pocust varchar(100) NOT NULL DEFAULT '',"
					." trso_subtotal double NOT NULL DEFAULT 0,"
					." trso_ppn double NOT NULL DEFAULT 0,"
					." trso_biayaekspedisi double NOT NULL DEFAULT 0,"
					." trso_catatan varchar(250) NOT NULL DEFAULT '',"
					." trso_tag varchar(100) NOT NULL DEFAULT '',"
					." trso_nprint integer NOT NULL DEFAULT 0,"
					." trso_void tinyint NOT NULL DEFAULT 0,"
					." trso_cekint integer NOT NULL DEFAULT 0,"
					." trso_lsupd datetime NOT NULL,"
					." trso_lsusr char(4) NOT NULL DEFAULT '',"
					." PRIMARY KEY (trso_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftop_so_createtable(){
		$query = "DROP TABLE IF EXISTS top_so";
		$this->db->simple_query($query);

		$query = "CREATE TABLE top_so ("									
					." tpso_no char(11) NOT NULL,"
					." tpso_seq int NOT NULL,"
					." tpso_tgljatuhtempo date NOT NULL,"
					." tpso_value double NOT NULL DEFAULT 0,"
					." tpso_cttn varchar(250) NOT NULL DEFAULT '',"
					." PRIMARY KEY (tpso_no, tpso_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_so_createtable(){
		$query = "DROP TABLE IF EXISTS dt_so";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_so ("														
					." dtso_no char(11) NOT NULL,"
					." dtso_seq int NOT NULL,"
					." dtso_mspd_no char(9) NOT NULL DEFAULT '',"
					." dtso_pricelist double NOT NULL DEFAULT 0,"
					." dtso_discpersen1 double NOT NULL DEFAULT 0,"
					." dtso_discpersen2 double NOT NULL DEFAULT 0,"
					." dtso_discpersen3 double NOT NULL DEFAULT 0,"
					." dtso_discrp double NOT NULL DEFAULT 0,"
					." dtso_nett double NOT NULL DEFAULT 0,"
					." dtso_qty double NOT NULL DEFAULT 0,"
					." dtso_qtykirim double NOT NULL DEFAULT 0,"
					." dtso_qtyretur double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dtso_no, dtso_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_sales_dlv_createtable(){
		$query = "DROP TABLE IF EXISTS tr_sales_dlv";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_sales_dlv ("																			
					." trsd_no char(16) NOT NULL,"
					." trsd_mscb_no char(1) NOT NULL DEFAULT '',"
					." trsd_tgl date NOT NULL,"
					." trsd_tglestkirim date NOT NULL,"
					." trsd_tglkirim date NOT NULL,"
					." trsd_tglbalik date NOT NULL,"
					." trsd_msgd_no char(3) NOT NULL DEFAULT '',"
					." trsd_sopir varchar(100) NOT NULL DEFAULT '',"
					." trsd_nopol varchar(100) NOT NULL DEFAULT '',"
					." trsd_ekspedisi varchar(100) NOT NULL DEFAULT '',"
					." trsd_noekspedisi varchar(100) NOT NULL DEFAULT '',"
					." trsd_biayaekspedisi double NOT NULL DEFAULT 0,"
					." trsd_mscs_no char(6) NOT NULL DEFAULT '',"
					." trsd_alamatkirim varchar(250) NOT NULL DEFAULT '',"
					." trsd_cp varchar(100) NOT NULL DEFAULT '',"
					." trsd_catatan varchar(250) NOT NULL DEFAULT '',"
					." trsd_tag varchar(100) NOT NULL DEFAULT '',"
					." trsd_nprint integer NOT NULL DEFAULT 0,"
					." trsd_void tinyint NOT NULL DEFAULT 0,"
					." trsd_cekint integer NOT NULL DEFAULT 0,"
					." trsd_lsupd datetime NOT NULL,"
					." trsd_lsusr char(4) NOT NULL DEFAULT '',"
					." PRIMARY KEY (trsd_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_sales_dlv_createtable(){
		$query = "DROP TABLE IF EXISTS dt_sales_dlv";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_sales_dlv ("			
					." dtsd_no char(16) NOT NULL,"
					." dtsd_seq int NOT NULL DEFAULT 0,"
					." dtsd_mspd_no char(9) NOT NULL DEFAULT '',"
					." dtsd_qtykrm double NOT NULL DEFAULT 0,"
					." dtsd_qtyrej double NOT NULL DEFAULT 0,"
					." dtsd_noserial varchar(100) NOT NULL DEFAULT '',"
					." dtsd_ketgaransi varchar(100) NOT NULL DEFAULT '',"
					." PRIMARY KEY (dtsd_no, dtsd_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function fms_cabang_alter1(){					
		$query = "ALTER TABLE ms_cabang ADD ("															
					." mscb_catatan varchar(250) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_usergroup_alter1(){					
		$query = "ALTER TABLE ms_usergroup ADD ("															
					." msug_catatan varchar(250) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function fms_user_alter1(){					
		$query = "ALTER TABLE ms_user ADD ("															
					." msus_catatan varchar(250) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_sales_alter1(){					
		$query = "ALTER TABLE ms_sales ADD ("															
					." mssl_catatan varchar(250) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_kategori_alter1(){					
		$query = "ALTER TABLE ms_kategori ADD ("															
					." mskt_catatan varchar(250) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_famili_alter1(){					
		$query = "ALTER TABLE ms_famili ADD ("															
					." msfm_catatan varchar(250) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_model_alter1(){					
		$query = "ALTER TABLE ms_model ADD ("															
					." msmd_catatan varchar(250) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_merk_alter1(){					
		$query = "ALTER TABLE ms_merk ADD ("															
					." msmr_catatan varchar(250) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_produk_alter1(){					
		$query = "ALTER TABLE ms_produk ADD ("															
					." mspd_catatan varchar(250) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_gudang_alter1(){					
		$query = "ALTER TABLE ms_gudang ADD ("															
					." msgd_catatan varchar(250) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	public function fms_customer_alter2(){					
		$query = "ALTER TABLE ms_customer" 
					." CHANGE mscs_almt_negara mscs_almt_provinsi VARCHAR(100) NOT NULL DEFAULT '',"
					." CHANGE mscs_kirim_negara mscs_kirim_provinsi VARCHAR(100) NOT NULL DEFAULT ''";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	public function fms_customer_update1(){					
		
		$this->db->set('mscs_jenis','R');
		$this->db->set('mscs_no','CONCAT("R",SUBSTRING(mscs_no,2,5))',false);
		$this->db->where('mscs_jenis !=', 'A');
		$this->db->where('SUBSTRING(mscs_no,1,1)', 'N');
		$this->db->update('ms_customer');			

		// if ($this->db->affected_rows() > 0 ) {
		// 	return 1;
		// }else{
		// 	return 0;
		// }
		return 1;
	}

	private function fms_jnspbyr_createtable(){
		$query = "DROP TABLE IF EXISTS ms_jnspbyr";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_jnspbyr ("
				    ."msjb_no int NOT NULL,"
					."msjb_nm varchar(20) NOT NULL DEFAULT '',"					
					."msjb_tipe char(1) NOT NULL DEFAULT '',"
					."msjb_trans char(1) NOT NULL DEFAULT '',"
					."msjb_listmscb varchar(250) NOT NULL DEFAULT '',"
					."msjb_catatan varchar(250) NOT NULL DEFAULT '',"
					."msjb_aktif tinyint NOT NULL DEFAULT 0,"
					."msjb_lsupd datetime NOT NULL,"
					."msjb_lsusr char(4) NOT NULL DEFAULT '',"  
				    ."PRIMARY KEY (msjb_no)"				    
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
		if ($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}
	}

	private function fms_sales_alter2(){					
		$query = "ALTER TABLE ms_sales ADD ("															
					." mssl_telp varchar(100) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fpby_so_createtable(){
		$query = "DROP TABLE IF EXISTS pby_so";
		$this->db->simple_query($query);

		$query = "CREATE TABLE pby_so ("			
					." pbso_no varchar(16) NOT NULL,"
					." pbso_seq int NOT NULL,"
					." pbso_refno varchar(16) NOT NULL DEFAULT '',"
					." pbso_msjb_no int NOT NULL DEFAULT 0,"
					." pbso_potongdp char(1) NOT NULL DEFAULT '',"
					." pbso_bayardp char(1) NOT NULL DEFAULT '',"
					." pbso_jlhbayar double NOT NULL DEFAULT 0,"
					." pbso_catatan varchar(250) NOT NULL DEFAULT '',"
					." pbso_tglterima date NOT NULL,"
					." pbso_tglcair date NOT NULL,"
					." pbso_void tinyint NOT NULL DEFAULT 0,"
					." pbso_cekint integer NOT NULL DEFAULT 0,"
					." pbso_lsupd datetime NOT NULL,"
					." pbso_lsusr char(4) NOT NULL DEFAULT '',"
					." pbso_nprint integer NOT NULL DEFAULT 0,"
					." pbso_tag varchar(100) NOT NULL DEFAULT '',"
					." pbso_msus_no char(4) NOT NULL DEFAULT '',"					
					." pbso_mscb_no char(1) NOT NULL DEFAULT '',"
					." PRIMARY KEY (pbso_no, pbso_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function ftr_so_alter1(){					
		$query = "ALTER TABLE tr_so ADD ("															
					." trso_terbayar double NOT NULL DEFAULT 0)";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function ftr_so_alter14(){					
		$query = "ALTER TABLE tr_so ADD ("															
				." trso_alamatnpwp varchar(250) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function ftr_spk_alter9(){					
		$query = "ALTER TABLE tr_spk ADD ("															
				." trspk_alamatnpwp varchar(250) NOT NULL DEFAULT '')";

		$this->db->simple_query($query);

		$query = "UPDATE tr_spk
			LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no
			SET trspk_alamatnpwp = CONCAT(mscs_almt_jln, ' ', mscs_almt_kota, ' ', mscs_almt_provinsi)
			WHERE trspk_mscs_no IS NOT NULL";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function fms_stok_createtable(){
		$query = "DROP TABLE IF EXISTS ms_stok";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_stok ("			
					." msst_mspd_no char(9) NOT NULL,"
					." msst_msgd_no char(3) NOT NULL,"
					." msst_qty double NOT NULL DEFAULT 0,"				
					." PRIMARY KEY (msst_mspd_no, msst_msgd_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_adjstok_createtable(){
		$query = "DROP TABLE IF EXISTS tr_adjstok";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_adjstok ("								
					."tras_no char(11) NOT NULL,"
					."tras_tgl date NOT NULL,"
					."tras_msgd_no char(3) NOT NULL DEFAULT '',"
					."tras_msus_no char(4) NOT NULL DEFAULT '',"
					."tras_mscb_no char(1) NOT NULL DEFAULT '',"
					."tras_catatan varchar(250) NOT NULL DEFAULT '',"
					."tras_tag varchar(100) NOT NULL DEFAULT '',"
					."tras_lsupd datetime NOT NULL,"
					."tras_lsusr char(4) NOT NULL DEFAULT '',"
					."tras_cekint integer NOT NULL DEFAULT 0,"
					."tras_void tinyint NOT NULL DEFAULT 0,"					
					." PRIMARY KEY (tras_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}		

	private function fdt_adjstok_createtable(){
		$query = "DROP TABLE IF EXISTS dt_adjstok";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_adjstok ("													
					."dtas_no char(11) NOT NULL,"
					."dtas_seq int NOT NULL,"
					."dtas_mspd_no char(9) NOT NULL DEFAULT '',"
					."dtas_qty double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dtas_no, dtas_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}		

	private function ftr_salesret_createtable(){
		$query = "DROP TABLE IF EXISTS tr_salesret";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_salesret ("																		
					." trsr_no char(16) NOT NULL,"
					." trsr_tgl date NOT NULL,"
					." trsr_tglterima date NOT NULL,"
					." trsr_msgd_no char(3) NOT NULL DEFAULT '',"
					." trsr_mscs_no char(6) NOT NULL DEFAULT '',"
					." trsr_jenis char(1) NOT NULL DEFAULT '',"
					." trsr_catatan varchar(250) NOT NULL DEFAULT '',"
					." trsr_tag varchar(100) NOT NULL DEFAULT '',"
					." trsr_nprint integer NOT NULL DEFAULT 0,"
					." trsr_void tinyint NOT NULL DEFAULT 0,"
					." trsr_cekint integer NOT NULL DEFAULT 0,"
					." trsr_lsupd datetime NOT NULL,"
					." trsr_lsusr char(4) NOT NULL DEFAULT '',"
					." trsr_msus_no char(4) NOT NULL DEFAULT '',"
					." PRIMARY KEY (trsr_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}		

	private function fdt_salesret_createtable(){
		$query = "DROP TABLE IF EXISTS dt_salesret";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_salesret ("																		
					." dtsr_no char(16) NOT NULL,"
					." dtsr_seq int NOT NULL,"
					." dtsr_mspd_no char(9) NOT NULL DEFAULT '',"
					." dtsr_qtyretur double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dtsr_no, dtsr_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_cabang_alter2(){
		$query = "ALTER TABLE ms_cabang ADD ("
					."mscb_alamat varchar(250) NOT NULL DEFAULT '',"
					."mscb_telp1 varchar(100) NOT NULL DEFAULT '',"
					."mscb_telp2 varchar(100) NOT NULL DEFAULT '',"
					."mscb_pic varchar(100) NOT NULL DEFAULT '',"
					."mscb_telp varchar(100) NOT NULL DEFAULT '',"
					."mscb_email1 varchar(100) NOT NULL DEFAULT '',"
					."mscb_email2 varchar(100) NOT NULL DEFAULT '')";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_gudang_alter2(){
		$query = "ALTER TABLE ms_gudang ADD ("																				
					." msgd_alamat varchar(250) NOT NULL DEFAULT '',"
					." msgd_kota varchar(100) NOT NULL DEFAULT '',"
					." msgd_pic varchar(100) NOT NULL DEFAULT '',"
					." msgd_telp varchar(100) NOT NULL DEFAULT '',"
					." msgd_email varchar(100) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_sales_alter3(){
		$query = "ALTER TABLE ms_sales ADD ("			
					." mssl_telp2 varchar(100) NOT NULL DEFAULT '',"
					." mssl_email varchar(100) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	public function fms_sales_alter4(){					
		$query = "ALTER TABLE ms_sales" 
					." CHANGE mssl_telp mssl_telp1 VARCHAR(100) NOT NULL DEFAULT ''";					

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_mutasi_createtable(){
		$query = "DROP TABLE IF EXISTS tr_mutasi";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_mutasi ("																							
					." trmt_no char(11) NOT NULL,"
					." trmt_msgd_no1 char(3) NOT NULL DEFAULT '',"
					." trmt_msgd_no2 char(3) NOT NULL DEFAULT '',"
					." trmt_mscb_no1 char(1) NOT NULL DEFAULT '',"
					." trmt_mscb_no2 char(1) NOT NULL DEFAULT '',"
					." trmt_tgl date NOT NULL,"
					." trmt_msus_no char(4) NOT NULL DEFAULT '',"
					." trmt_catatan varchar(250) NOT NULL DEFAULT '',"
					." trmt_tag varchar(100) NOT NULL DEFAULT '',"
					." trmt_nprint integer NOT NULL DEFAULT 0,"
					." trmt_void tinyint NOT NULL DEFAULT 0,"
					." trmt_cekint integer NOT NULL DEFAULT 0,"
					." trmt_lsupd datetime NOT NULL,"
					." trmt_lsusr char(4) NOT NULL DEFAULT '',"
					." trmt_ekspedisi varchar(100) NOT NULL DEFAULT '',"
					." trmt_noekspedisi varchar(100) NOT NULL DEFAULT '',"
					." trmt_tglkirim date NOT NULL,"
					." trmt_tglterima date NOT NULL,"
					." PRIMARY KEY (trmt_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_mutasi_createtable(){
		$query = "DROP TABLE IF EXISTS dt_mutasi";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_mutasi ("																							
					." dtmt_no char(11) NOT NULL,"
					." dtmt_seq int NOT NULL,"
					." dtmt_mspd_no char(9) NOT NULL DEFAULT '',"					
					." dtmt_qtyout double NOT NULL DEFAULT 0,"
					." dtmt_qtyin double NOT NULL DEFAULT 0,"					
					." dtmt_stapv char(1) NOT NULL DEFAULT 'N',"
					." PRIMARY KEY (dtmt_no, dtmt_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fapv_mutasi_createtable(){
		$query = "DROP TABLE IF EXISTS apv_mutasi";
		$this->db->simple_query($query);

		$query = "CREATE TABLE apv_mutasi ("																												
					."apmt_no char(11) NOT NULL,"
					."apmt_seq int NOT NULL,"
					."apmt_tgl date NOT NULL,"
					."apmt_tag varchar(100) NOT NULL DEFAULT '',"
					."apmt_catatan varchar(250) NOT NULL DEFAULT '',"
					."apmt_msus_no char(4) NOT NULL DEFAULT '',"
					."apmt_mscb_no char(1) NOT NULL DEFAULT '',"
					." PRIMARY KEY (apmt_no, apmt_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fset_norevisi($ver){								
		
		$this->db->delete('simrel',array('simr_no' => 'ver','simr_seq' => 1));

		$data = array(
		        'simr_no' => 'ver',
		        'simr_seq' => 1,
		        'simr_char1' => '',
		        'simr_char2' => '',
		        'simr_int1' => $ver,
		        'simr_int2' => 0,
		        'simr_doub' => 0
		);

		$this->db->insert('simrel',$data);

		if ($this->db->affected_rows() > 0 ) {
			return 1;
		}else{
			return 0;
		}
				
	}

	public function fget_norevisi(){		
		$this->db->select('simr_int1');
		$query = $this->db->get_where('simrel', array('simr_no' => 'ver','simr_seq' => 1));		
		
		if ($query->num_rows() > 0) {
			$result = $query->result_array();
			return $result[0]['simr_int1'];
		}else{
			return 0;
		}
	}


	private function fms_usergroup_initdefault(){
		$this->db->delete('ms_usergroup', array('msug_no'=>'G001'));	
		try{	
			$data = array();
			$data['msug_no'] = 'G001';
			$data['msug_nm'] = 'ADMIN GROUP';
			$data['msug_hakakses'] = '.AL0.AL1.AL2.AK0.AK1.AK2.';
			$data['msug_aktif'] = 1;
			$data['msug_lsupd'] = date('Y-m-d H:i:s');
			$data['msug_lsusr'] = 'U001';
		
			$this->db->insert('ms_usergroup',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	private function fms_user_initdefault(){
		$this->db->delete('ms_user', array('msus_no'=>'U001'));	
		try{	
			$data = array();		
			$data['msus_no'] = 'U001';
			$data['msus_nm'] = 'ADMIN';
			$data['msus_pswd'] = do_hash('admin','md5');
			$data['msus_msug_no'] = 'G001';
			$data['msus_mscb_no'] = 'J';
			$data['msus_aktif'] = 1;
			$data['msus_lsupd'] = date('Y-m-d H:i:s');
			$data['msus_lsusr'] = 'U001';
		
			$this->db->insert('ms_user',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	private function fms_cabang_initdefault(){		
		$this->db->delete('ms_cabang', array('mscb_no'=>'J'));					
		try{	
			$data = array();				
			$data['mscb_no'] = 'J';
			$data['mscb_nm'] = 'JAKARTA';
			$data['mscb_aktif'] = 1;
			$data['mscb_lsupd'] = date('Y-m-d H:i:s');
			$data['mscb_lsusr'] = 'U001';
		
			$this->db->insert('ms_cabang',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	private function fapv_purcreq_createtable(){
		$query = "DROP TABLE IF EXISTS apv_purcreq";
		$this->db->simple_query($query);

		$query = "CREATE TABLE apv_purcreq ("																																	
					."appr_no char(11) NOT NULL,"
					." appr_mscb_no char(1) NOT NULL DEFAULT '',"
					." appr_tgl date NOT NULL,"
					." appr_catatan varchar(250) NOT NULL DEFAULT '',"
					." appr_tag varchar(100) NOT NULL DEFAULT '',"
					." appr_nprint integer NOT NULL DEFAULT 0,"
					." appr_void tinyint NOT NULL DEFAULT 0,"
					." appr_lsupd datetime NOT NULL,"
					." appr_lsusr char(4) NOT NULL DEFAULT '',"
					." appr_msus_no char(4) NOT NULL DEFAULT '',"
					." PRIMARY KEY (appr_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_apv_purcreq_createtable(){
		$query = "DROP TABLE IF EXISTS dt_apv_purcreq";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_apv_purcreq ("																																						
					."dappr_no char(11) NOT NULL,"
					." dappr_seq int NOT NULL,"
					." dappr_dtpr_no char(11) NOT NULL DEFAULT '',"
					." dappr_dtpr_seq int NOT NULL DEFAULT 0,"
					." dappr_mspd_no char(9) NOT NULL DEFAULT '',"
					." dappr_qtyreq double NOT NULL DEFAULT 0,"
					." dappr_qtyapv double NOT NULL DEFAULT 0,"
					." dappr_trpo_no char(12) NOT NULL DEFAULT '',"
					." dappr_cekint integer NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dappr_no, dappr_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_po_createtable(){
		$query = "DROP TABLE IF EXISTS tr_po";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_po ("																																	
					." trpo_no char(11) NOT NULL,"
					." trpo_mscb_no char(1) NOT NULL DEFAULT '',"
					." trpo_tgl date NOT NULL,"
					." trpo_mssp_no char(6) NOT NULL DEFAULT '',"
					." trpo_curr varchar(10) NOT NULL DEFAULT '',"
					." trpo_subtotal double NOT NULL DEFAULT 0,"
					." trpo_ppn double NOT NULL DEFAULT 0,"
					." trpo_terbayar double NOT NULL DEFAULT 0,"
					." trpo_catatan varchar(250) NOT NULL DEFAULT '',"
					." trpo_tag varchar(100) NOT NULL DEFAULT '',"
					." trpo_nprint integer NOT NULL DEFAULT 0,"
					." trpo_void tinyint NOT NULL DEFAULT 0,"
					." trpo_lsupd datetime NOT NULL,"
					." trpo_lsusr char(4) NOT NULL DEFAULT '',"
					." trpo_msus_no char(4) NOT NULL DEFAULT '',"
					." trpo_cekint integer NOT NULL DEFAULT 0,"
					." PRIMARY KEY (trpo_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_po_createtable(){
		$query = "DROP TABLE IF EXISTS dt_po";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_po ("																																						
					."dtpo_no char(11) NOT NULL,"
					." dtpo_seq int NOT NULL,"
					." dtpo_dappr_no char(11) NOT NULL DEFAULT '',"
					." dtpo_dappr_seq int NOT NULL DEFAULT 0,"
					." dtpo_mspd_no char(9) NOT NULL DEFAULT '',"
					." dtpo_nett double NOT NULL DEFAULT 0,"
					." dtpo_qty double NOT NULL DEFAULT 0,"
					." dtpo_qtyterima double NOT NULL DEFAULT 0,"					
					." PRIMARY KEY (dtpo_no, dtpo_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_purcret_createtable(){
		$query = "DROP TABLE IF EXISTS tr_purcret";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_purcret ("																																	
					."trpt_no char(11) NOT NULL,"
					."trpt_tgl date NOT NULL,"
					."trpt_tglkeluar date NOT NULL,"
					."trpt_msgd_no char(3) NOT NULL DEFAULT '',"
					."trpt_mssp_no char(6) NOT NULL DEFAULT '',"
					."trpt_catatan varchar(250) NOT NULL DEFAULT '',"
					."trpt_tag varchar(100) NOT NULL DEFAULT '',"
					."trpt_nprint integer NOT NULL DEFAULT 0,"
					."trpt_void tinyint NOT NULL DEFAULT 0,"
					."trpt_cekint integer NOT NULL DEFAULT 0,"
					."trpt_lsupd datetime NOT NULL,"
					."trpt_lsusr char(4) NOT NULL DEFAULT '',"
					."trpt_msus_no char(4) NOT NULL DEFAULT '',"
					." PRIMARY KEY (trpt_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_purcret_createtable(){
		$query = "DROP TABLE IF EXISTS dt_purcret";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_purcret ("																																						
					."dtpt_no char(11) NOT NULL,"
					."dtpt_seq int NOT NULL,"
					."dtpt_mspd_no char(9) NOT NULL DEFAULT '',"
					."dtpt_qtyretur double NOT NULL DEFAULT 0,"
					."dtpt_nett double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dtpt_no, dtpt_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_accgrp_createtable(){
		$query = "DROP TABLE IF EXISTS ms_accgrp";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_accgrp ("		
					." msag_no char(2) NOT NULL,"
					." msag_nm varchar(100) NOT NULL DEFAULT '',"
					." msag_listmscb varchar(250) NOT NULL DEFAULT '',"
					." msag_jenis char(1) NOT NULL DEFAULT '',"
					." msag_salnorm char(1) NOT NULL,"
					." msag_aktif tinyint NOT NULL DEFAULT 0,"
					." msag_lsupd datetime NOT NULL,"
					." msag_lsusr char(4) NOT NULL DEFAULT '',"
					." PRIMARY KEY (msag_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_accsub_createtable(){
		$query = "DROP TABLE IF EXISTS ms_accsub";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_accsub ("		
					." msas_no char(5) NOT NULL,"
					." msas_nm varchar(100) NOT NULL DEFAULT '',"
					." msas_listmscb varchar(250) NOT NULL DEFAULT '',"
					." msas_salnorm char(1) NOT NULL,"
					." msas_aktif tinyint NOT NULL DEFAULT 0,"
					." msas_lsupd datetime NOT NULL,"
					." msas_lsusr char(4) NOT NULL DEFAULT '',"
					." PRIMARY KEY (msas_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_purcret_alter1(){					
		$query = "ALTER TABLE tr_purcret ADD ("															
					." trpt_jenis char(1) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_purcret_alter2(){					
		$query = "ALTER TABLE tr_purcret MODIFY "															
					."trpt_no char(16) NOT NULL";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_purcret_alter1(){
		$query = "ALTER TABLE dt_purcret MODIFY "															
					."dtpt_no char(16) NOT NULL";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_po_alter1(){
		$query = "ALTER TABLE dt_po ADD ("															
					." dtpo_qtyretur double NOT NULL DEFAULT 0)";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_purcret_alter3(){
		$query = "ALTER TABLE tr_purcret ADD ("															
					." trpt_mscb_no char(1) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}		

	private function ftr_salesret_alter1(){
		$query = "ALTER TABLE tr_salesret ADD ("															
					." trsr_mscb_no char(1) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}		

	private function ftr_mutasi_alter1(){
		$query = "ALTER TABLE tr_mutasi ADD ("															
					." trmt_mscb_no char(1) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_in_dlv_alter1(){
		$query = "ALTER TABLE tr_in_dlv ADD ("															
					." trid_msus_no char(4) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_sales_dlv_alter1(){
		$query = "ALTER TABLE tr_sales_dlv ADD ("															
					." trsd_msus_no char(4) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_sales_inquery_alter1(){
		$query = "ALTER TABLE tr_sales_inquery ADD ("															
					." trsi_msus_no char(4) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_so_alter2(){
		$query = "ALTER TABLE tr_so ADD ("															
					." trso_msus_no char(4) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	// private function fpby_so_alter1(){
	// 	$query = "ALTER TABLE pby_so ADD ("															
	// 				." pbso_mscb_no char(1) NOT NULL DEFAULT '')";
	
	// 	if($this->db->simple_query($query)){
	// 		return 1;
	// 	}
	// 	else{
	// 		return 0;
	// 	}			
	// }

	private function fms_gudang_alter3(){
		$query = "ALTER TABLE ms_gudang ADD ("
					." msgd_avl char(1) NOT NULL DEFAULT '')";
		if($this->db->simple_query($query)){
			$query = "UPDATE ms_gudang SET msgd_avl = 'Y'";
			$this->db->simple_query($query);
				
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_sales_dlv_alter2(){
		$query = "ALTER TABLE tr_sales_dlv ADD ("
					." trsd_total double NOT NULL DEFAULT 0,"
					." trsd_terbayar double NOT NULL DEFAULT 0)";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_sales_dlv_alter1(){
		$query = "ALTER TABLE dt_sales_dlv ADD ("					
					." dtsd_nett double NOT NULL DEFAULT 0)";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_so_alter3(){
		$query = "ALTER TABLE tr_so"
					." DROP COLUMN trso_subtotal,"
					." DROP COLUMN trso_ppn";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_so_alter4(){
		$query = "ALTER TABLE tr_so ADD ("					
					." trso_total double NOT NULL DEFAULT 0,"
					." trso_sisadp double NOT NULL DEFAULT 0)";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_sales_inquery_alter2(){
		$query = "ALTER TABLE tr_sales_inquery"
					." DROP COLUMN trsi_subtotal,"
					." DROP COLUMN trsi_ppn";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_sales_inquery_alter3(){
		$query = "ALTER TABLE tr_sales_inquery ADD ("					
					." trsi_total double NOT NULL DEFAULT 0)";					
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_so_alter1(){
		$query = "ALTER TABLE dt_so ADD ("		
					." dtso_bftax double NOT NULL DEFAULT 0,"					
					." dtso_tax double NOT NULL DEFAULT 0)";					
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_sales_inquery_alter1(){
		$query = "ALTER TABLE dt_sales_inquery ADD ("
					." dtsi_bftax double NOT NULL DEFAULT 0,"
					." dtsi_tax double NOT NULL DEFAULT 0)";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_po_alter2(){
		$query = "ALTER TABLE dt_po ADD ("
					." dtpo_bftax double NOT NULL DEFAULT 0,"
					." dtpo_tax double NOT NULL DEFAULT 0)";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_customer_alter3(){
		$query = "ALTER TABLE ms_customer ADD ("
					." mscs_hp varchar(100) NOT NULL DEFAULT '',"
					." mscs_fax varchar(100) NOT NULL DEFAULT '',"
					." mscs_npwp varchar(100) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_supplier_alter2(){
		$query = "ALTER TABLE ms_supplier ADD ("
					." mssp_hp varchar(100) NOT NULL DEFAULT '',"
					." mssp_fax varchar(100) NOT NULL DEFAULT '')";					
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_in_dlv_alter1(){
		$query = "ALTER TABLE dt_in_dlv"
					." CHANGE dtid_biayalain dtid_biayaperunit double NOT NULL DEFAULT 0";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_sales_dlv_alter2(){
		$query = "ALTER TABLE dt_sales_dlv ADD ("
					." dtsd_tglgaransisp date NOT NULL,"
					." dtsd_tglgaransijasa date NOT NULL)";					
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_in_dlv_alter2(){
		$query = "ALTER TABLE dt_in_dlv ADD ("					
					." dtid_nettcurr double NOT NULL DEFAULT 0)";					
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fpby_po_createtable(){
		$query = "DROP TABLE IF EXISTS pby_po";
		$this->db->simple_query($query);

		$query = "CREATE TABLE pby_po ("		
					." pbpo_no varchar(16) NOT NULL,"
					." pbpo_seq int NOT NULL DEFAULT 0,"
					." pbpo_refno varchar(16) NOT NULL DEFAULT '',"
					." pbpo_msjb_no int NOT NULL DEFAULT 0,"
					." pbpo_potongdp char(1) NOT NULL DEFAULT '',"
					." pbpo_bayardp char(1) NOT NULL DEFAULT '',"
					." pbpo_jlhbayar double NOT NULL DEFAULT 0,"
					." pbpo_catatan varchar(250) NOT NULL DEFAULT '',"
					." pbpo_tgl date NOT NULL,"
					." pbpo_tglbayar date NOT NULL,"
					." pbpo_void tinyint NOT NULL DEFAULT 0,"
					." pbpo_cekint integer NOT NULL DEFAULT 0,"
					." pbpo_lsupd datetime NOT NULL,"
					." pbpo_lsusr char(4) NOT NULL DEFAULT '',"
					." pbpo_nprint integer NOT NULL DEFAULT 0,"
					." pbpo_tag varchar(100) NOT NULL DEFAULT '',"
					." pbpo_msus_no char(4) NOT NULL DEFAULT '',"
					." pbpo_mscb_no char(1) NOT NULL DEFAULT '',"
					." PRIMARY KEY (pbpo_no, pbpo_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function ftr_po_alter1(){
		$query = "ALTER TABLE tr_po ADD ("					
					." trpo_sisadp double NOT NULL DEFAULT 0,"					
					." trpo_total double NOT NULL DEFAULT 0)";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_in_dlv_alter2(){
		$query = "ALTER TABLE tr_in_dlv ADD ("					
					." trid_total double NOT NULL DEFAULT 0,"
					." trid_terbayar double NOT NULL DEFAULT 0)";					
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_user_alter2(){
		$query = "ALTER TABLE ms_user ADD ("
					." msus_allcabang char(1) NOT NULL DEFAULT '')";
		if($this->db->simple_query($query)){
			$query = "UPDATE ms_user SET msus_allcabang = 'N'";
			$this->db->simple_query($query);
				
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_purcret_alter4(){
		$query = "ALTER TABLE tr_purcret ADD ("
					." trpt_kurs double NOT NULL DEFAULT 0,"
					." trpt_curr varchar(10) NOT NULL DEFAULT '')";
		if($this->db->simple_query($query)){
			$query = "UPDATE tr_purcret SET trpt_kurs = 1, trpt_curr = 'RP'";
			$this->db->simple_query($query);
				
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_purcret_alter2(){
		$query = "ALTER TABLE dt_purcret ADD ("
					." dtpt_nettpo double NOT NULL DEFAULT 0,"
					." dtpt_bftaxrp double NOT NULL DEFAULT 0,"
					." dtpt_taxrp double NOT NULL DEFAULT 0)";
		if($this->db->simple_query($query)){							
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_salesret_alter2(){
		$query = "ALTER TABLE tr_salesret ADD ("
					." trsr_pbso_no varchar(16) NOT NULL DEFAULT '',"
					." trsr_total double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){							
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_salesret_alter1(){
		$query = "ALTER TABLE dt_salesret ADD ("
					." dtsr_bftax double NOT NULL DEFAULT 0,"
					." dtsr_tax double NOT NULL DEFAULT 0,"
					." dtsr_nett double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){							
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fpby_so_alter1(){
		$query = "ALTER TABLE pby_so ADD ("
					." pbso_trsr_no varchar(16) NOT NULL DEFAULT '')";					
					
		if($this->db->simple_query($query)){							
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_purcret_alter5(){
		$query = "ALTER TABLE tr_purcret ADD ("
					." trpt_pbpo_no varchar(16) NOT NULL DEFAULT '',"
					." trpt_total double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){							
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function fpby_po_alter1(){
		$query = "ALTER TABLE pby_po ADD ("
					." pbpo_trpt_no varchar(16) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){							
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_si_alter1(){
		$query = "ALTER TABLE dt_sales_inquery ADD ("
					." dtsi_pricelistcurr double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){							
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_so_alter2(){
		$query = "ALTER TABLE dt_so ADD ("
					." dtso_pricelistcurr double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){							
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_accper_createtable(){
		$query = "DROP TABLE IF EXISTS ms_accper";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_accper ("		
					." msap_no char(11) NOT NULL,"
					." msap_nm varchar(100) NOT NULL DEFAULT '',"
					." msap_listmscb varchar(250) NOT NULL DEFAULT '',"
					." msap_aktif tinyint NOT NULL DEFAULT 0,"
					." msap_lsupd datetime NOT NULL,"
					." msap_lsusr char(4) NOT NULL DEFAULT '',"					
					." PRIMARY KEY (msap_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function ftr_jurnal_createtable(){
		$query = "DROP TABLE IF EXISTS tr_jurnal";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_jurnal ("		
					."trju_no varchar(12) NOT NULL,"  // ada alter2 menjadi char(15)
					."trju_tgl date NOT NULL,"
					."trju_tipe char(1) NOT NULL DEFAULT '',"
					."trju_catatan varchar(250) NOT NULL DEFAULT '',"
					."trju_refno varchar(20) NOT NULL DEFAULT '',"
					."trju_reftipe char(2) NOT NULL DEFAULT '',"
					."trju_void tinyint NOT NULL DEFAULT 0,"
					."trju_lsupd datetime NOT NULL,"
					."trju_lsusr char(4) NOT NULL DEFAULT '',"
					."trju_cekint integer NOT NULL DEFAULT 0,"
					."trju_msus_no char(4) NOT NULL DEFAULT '',"
					."trju_mscb_no char(1) NOT NULL DEFAULT '',"
					." PRIMARY KEY (trju_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fdt_jurnal_createtable(){
		$query = "DROP TABLE IF EXISTS dt_jurnal";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_jurnal ("		
					."dtju_no varchar(12) NOT NULL," // ada alter2 menjadi char(15)
					."dtju_seq int NOT NULL DEFAULT 0,"
					."dtju_msap_no char(11) NOT NULL DEFAULT '',"
					."dtju_debet double NOT NULL DEFAULT 0,"
					."dtju_kredit double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dtju_no, dtju_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fms_jnspbyr_alter1(){
		$query = "ALTER TABLE ms_jnspbyr ADD ("
					." msjb_msap_no char(11) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){							
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_spk_createtable(){
		$query = "DROP TABLE IF EXISTS tr_spk";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_spk ("		
					."trspk_no char(11) NOT NULL,"
					." trspk_tgl date NOT NULL,"
					." trspk_tglselesai date NOT NULL,"
					." trspk_catatan varchar(250) NOT NULL DEFAULT '',"
					." trspk_mscs_no char(6) NOT NULL DEFAULT '',"
					." trspk_alamat varchar(250) NOT NULL DEFAULT '',"
					." trspk_cp varchar(100) NOT NULL DEFAULT '',"
					." trspk_noserial varchar(100) NOT NULL DEFAULT '',"
					." trspk_mspd_no char(9) NOT NULL DEFAULT '',"
					." trspk_garansisp char(1) NOT NULL DEFAULT '',"
					." trspk_garansijasa char(1) NOT NULL DEFAULT '',"
					." trspk_keluhan varchar(250) NOT NULL DEFAULT '',"
					." trspk_jnsservis varchar(100) NOT NULL DEFAULT '',"
					." trspk_biayaservis double NOT NULL DEFAULT 0,"
					." trspk_msgd_no char(3) NOT NULL DEFAULT '',"
					." trspk_tag varchar(100) NOT NULL DEFAULT '',"
					." trspk_nprint integer NOT NULL DEFAULT 0,"
					." trspk_void tinyint NOT NULL DEFAULT 0,"
					." trspk_cekint integer NOT NULL DEFAULT 0,"
					." trspk_lsupd datetime NOT NULL,"
					." trspk_lsusr char(4) NOT NULL DEFAULT '',"
					." trspk_msus_no char(4) NOT NULL DEFAULT '',"
					." trspk_mscb_no char(1) NOT NULL DEFAULT '',"
					." trspk_kurs double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (trspk_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fdt_spk_sp_createtable(){
		$query = "DROP TABLE IF EXISTS dt_spk_sp";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_spk_sp ("		
					."dtspk_no char(11) NOT NULL,"
					." dtspk_seq int NOT NULL DEFAULT 0,"
					." dtspk_mspd_no char(9) NOT NULL DEFAULT '',"
					." dtspk_curr varchar(10) NOT NULL DEFAULT '',"
					." dtspk_pricelistcurr double NOT NULL DEFAULT 0,"
					." dtspk_pricelist double NOT NULL DEFAULT 0,"
					." dtspk_discpersen1 double NOT NULL DEFAULT 0,"
					." dtspk_discpersen2 double NOT NULL DEFAULT 0,"
					." dtspk_discpersen3 double NOT NULL DEFAULT 0,"
					." dtspk_discrp double NOT NULL DEFAULT 0,"
					." dtspk_bftax double NOT NULL DEFAULT 0,"
					." dtspk_tax double NOT NULL DEFAULT 0,"
					." dtspk_nett double NOT NULL DEFAULT 0,"
					." dtspk_qty double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dtspk_no, dtspk_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function ftr_spk_visit_createtable(){
		$query = "DROP TABLE IF EXISTS tr_spk_visit";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_spk_visit ("		
					."trsv_no char(16) NOT NULL,"
					." trsv_tgl date NOT NULL,"
					." trsv_tglrncnvisitfrom date NOT NULL,"
					." trsv_tglrncnvisituntil date NOT NULL,"
					." trsv_tglvisitfrom date NOT NULL,"
					." trsv_tglvisituntil date NOT NULL,"
					." trsv_alamat varchar(250) NOT NULL DEFAULT '',"
					." trsv_cp varchar(100) NOT NULL DEFAULT '',"
					." trsv_catatan varchar(250) NOT NULL DEFAULT '',"
					." trsv_kesimpulan varchar(250) NOT NULL DEFAULT '',"
					." trsv_ketkonfirmasi varchar(250) NOT NULL DEFAULT '',"
					." trsv_mssl_no char(10) NOT NULL DEFAULT '',"
					." trsv_tag varchar(100) NOT NULL DEFAULT '',"
					." trsv_nprint integer NOT NULL DEFAULT 0,"
					." trsv_void tinyint  NOT NULL DEFAULT 0,"
					." trsv_cekint integer NOT NULL DEFAULT 0,"
					." trsv_lsupd datetime NOT NULL,"
					." trsv_lsusr char(4) NOT NULL DEFAULT '',"
					." trsv_msus_no char(4) NOT NULL DEFAULT '',"
					." trsv_mscb_no char(1) NOT NULL DEFAULT '',"
					." PRIMARY KEY (trsv_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fms_sales_alter5(){
		$query = "ALTER TABLE ms_sales ADD ("
					." mssl_divisi char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){					
			$query = "UPDATE ms_sales SET mssl_divisi = 'S'";
			$this->db->simple_query($query);

			return 1;
		}
		else{
			return 0;
		}			
	}

	// private function ftr_spk_visit_alter1(){
	// 	$query = "ALTER TABLE tr_spk_visit"					
	// 				." DROP COLUMN trsv_nmteknisi";
	
	// 	if($this->db->simple_query($query)){
	// 		return 1;
	// 	}
	// 	else{
	// 		return 0;
	// 	}			
	// }

	// private function ftr_spk_visit_alter2(){
	// 	$query = "ALTER TABLE tr_spk_visit ADD ("
	// 				." trsv_mssl_no char(10) NOT NULL DEFAULT '')";
					
	// 	if($this->db->simple_query($query)){							
	// 		return 1;
	// 	}else{
	// 		return 0;
	// 	}			
	// }

	private function fms_customer_alter4(){
		$query = "ALTER TABLE ms_customer"
					." DROP COLUMN mscs_kirim_jln,"
					." DROP COLUMN mscs_kirim_kota,"
					." DROP COLUMN mscs_kirim_provinsi";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_cust_dlvyadd_createtable(){
		$query = "DROP TABLE IF EXISTS ms_cust_dlvyadd";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_cust_dlvyadd ("		
					." mscsda_no char(6) NOT NULL,"
					." mscsda_seq int NOT NULL DEFAULT 0,"
					." mscsda_kirim_jln varchar(250) NOT NULL DEFAULT '',"
					." mscsda_kirim_kota varchar(100) NOT NULL DEFAULT '',"
					." mscsda_kirim_provinsi varchar(100) NOT NULL DEFAULT '',"
					." PRIMARY KEY (mscsda_no, mscsda_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fms_cust_npwpdd_createtable(){
		$query = "DROP TABLE IF EXISTS ms_cust_npwpadd";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_cust_npwpadd ("		
					." mscsna_no char(6) NOT NULL,"
					." mscsna_seq int NOT NULL DEFAULT 0,"
					." mscsna_npwp_jln varchar(250) NOT NULL DEFAULT '',"
					." mscsna_npwp_kota varchar(100) NOT NULL DEFAULT '',"
					." mscsna_npwp_provinsi varchar(100) NOT NULL DEFAULT '',"
					." PRIMARY KEY (mscsna_no, mscsna_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fms_cust_npwpdd_defalamatnpwp(){
		$query = "INSERT INTO ms_cust_npwpadd(		
			mscsna_no,
			mscsna_seq,
			mscsna_npwp_jln,
			mscsna_npwp_kota,
			mscsna_npwp_provinsi
		)
		(
			SELECT 
				mscs_no,
				1,
				mscs_almt_jln,
				mscs_almt_kota,
				mscs_almt_provinsi
			FROM ms_customer
		)";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function ftr_so_defalamatnpwp(){
		$query = "UPDATE tr_so
		LEFT JOIN ms_customer ON mscs_no = trso_mscs_no
		SET trso_alamatnpwp = CONCAT(mscs_almt_jln, ' ', mscs_almt_kota, ' ', mscs_almt_provinsi)";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	public function fpby_po_alter2(){		
		$query = "UPDATE pby_po SET pbpo_bayardp = 'D' WHERE pbpo_bayardp = 'Y'";
		$this->db->simple_query($query);

		$query = "UPDATE pby_po SET pbpo_bayardp = 'T' WHERE pbpo_bayardp = 'N'";
		$this->db->simple_query($query);

		$query = "UPDATE pby_so SET pbso_bayardp = 'D' WHERE pbso_bayardp = 'Y'";
		$this->db->simple_query($query);

		$query = "UPDATE pby_so SET pbso_bayardp = 'T' WHERE pbso_bayardp = 'N'";
		$this->db->simple_query($query);

		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}	
	}

	private function fms_kategori_alter2(){
		$query = "ALTER TABLE ms_kategori ADD ("
					." mskt_showinspk char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){
			$query = "UPDATE ms_kategori SET mskt_showinspk = 'Y'";
			$this->db->simple_query($query);							
			return 1;
		}else{
			return 0;
		}			
	}

	private function fms_kategori_alter3(){
		$query = "ALTER TABLE ms_kategori ADD ("
					." mskt_msap_no_inv char(11) NOT NULL DEFAULT '',"
					." mskt_msap_no_pjr char(11) NOT NULL DEFAULT '',"
					." mskt_msap_no_pja char(11) NOT NULL DEFAULT '',"
					." mskt_msap_no_hpr char(11) NOT NULL DEFAULT '',"
					." mskt_msap_no_hpa char(11) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){				
			return 1;
		}else{
			return 0;
		}			
	}

	private function fms_produk_alter2(){
		$query = "ALTER TABLE ms_produk ADD ("					
					." mspd_hpp double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){				
			return 1;
		}else{
			return 0;
		}			
	}

	private function ftr_jurnal_alter1(){					
		$query = "ALTER TABLE tr_jurnal" 					
					." CHANGE trju_no trju_no VARCHAR(14) NOT NULL";  // ada alter2 menjadi char(15)

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_jurnal_alter1(){					
		$query = "ALTER TABLE dt_jurnal" 					
					." CHANGE dtju_no dtju_no VARCHAR(14) NOT NULL";  // ada alter2 menjadi char(15)

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_sales_inquery_alter4(){					
		$query = "ALTER TABLE tr_sales_inquery" 					
					." CHANGE trsi_tgl trsi_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_so_alter5(){					
		$query = "ALTER TABLE tr_so" 					
					." CHANGE trso_tgl trso_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}
	
	private function ftr_salesret_alter3(){					
		$query = "ALTER TABLE tr_salesret" 					
					." CHANGE trsr_tgl trsr_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fpby_in_dlv_biayakirim_createtable(){
		$query = "DROP TABLE IF EXISTS pby_in_dlv_biayakirim";
		$this->db->simple_query($query);

		$query = "CREATE TABLE pby_in_dlv_biayakirim ("		
					."pbidbk_trid_no varchar(16) NOT NULL,"
					." pbidbk_tgl datetime NOT NULL,"
					." pbidbk_adj double NOT NULL DEFAULT 0,"
					." pbidbk_msjb_no int NOT NULL DEFAULT 0,"
					." pbidbk_jlhbayar double NOT NULL DEFAULT 0,"
					." pbidbk_catatan varchar(250) NOT NULL DEFAULT '',"
					." pbidbk_tglbayar date NOT NULL,"
					." pbidbk_tag varchar(100) NOT NULL DEFAULT '',"
					." pbidbk_msus_no char(4) NOT NULL DEFAULT '',"
					." pbidbk_mscb_no char(1) NOT NULL DEFAULT '',"
					." PRIMARY KEY (pbidbk_trid_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fpby_in_dlv_beamasuk_createtable(){
		$query = "DROP TABLE IF EXISTS pby_in_dlv_beamasuk";
		$this->db->simple_query($query);

		$query = "CREATE TABLE pby_in_dlv_beamasuk ("		
					." pbidbm_trid_no varchar(16) NOT NULL,"
					." pbidbm_tgl datetime NOT NULL,"
					." pbidbm_adj double NOT NULL DEFAULT 0,"
					." pbidbm_msjb_no int NOT NULL DEFAULT 0,"
					." pbidbm_jlhbayar double NOT NULL DEFAULT 0,"
					." pbidbm_catatan varchar(250) NOT NULL DEFAULT '',"
					." pbidbm_tglbayar date NOT NULL,"
					." pbidbm_tag varchar(100) NOT NULL DEFAULT '',"
					." pbidbm_msus_no char(4) NOT NULL DEFAULT '',"
					." pbidbm_mscb_no char(1) NOT NULL DEFAULT '',"
					." PRIMARY KEY (pbidbm_trid_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fpby_po_alter3(){
		$query = "ALTER TABLE pby_po ADD ("					
					." pbpo_kurs double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){				
			return 1;
		}else{
			return 0;
		}			
	}	

	private function fms_paket_prod_createtable(){
		$query = "DROP TABLE IF EXISTS ms_paket_prod";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_paket_prod ("			
					."mspp_no varchar(8) NOT NULL,"
					."mspp_nm varchar(100) NOT NULL DEFAULT '',"
					."mspp_total double NOT NULL DEFAULT 0,"
					."mspp_listmscb varchar(250) NOT NULL DEFAULT '',"
					."mspp_tag varchar(100) NOT NULL DEFAULT '',"
					."mspp_catatan varchar(250) NOT NULL DEFAULT '',"
					."mspp_aktif tinyint NOT NULL DEFAULT 0,"
					."mspp_lsupd datetime NOT NULL,"
					."mspp_lsusr char(4) NOT NULL DEFAULT '',"
					." PRIMARY KEY (mspp_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fmd_paket_prod_createtable_direvisi(){
		$query = "DROP TABLE IF EXISTS md_paket_prod";
		$this->db->simple_query($query);

		$query = "CREATE TABLE md_paket_prod ("			
					."mdpp_no varchar(8) NOT NULL,"
					."mdpp_mspd_no char(9) NOT NULL DEFAULT '',"
					."mdpp_qty double NOT NULL DEFAULT 0,"
					."mdpp_curr varchar(10) NOT NULL DEFAULT '',"
					."mdpp_pricelistcurr double NOT NULL DEFAULT 0,"
					."mdpp_pricelist double NOT NULL DEFAULT 0,"
					."mdpp_discpersen1 double NOT NULL DEFAULT 0,"
					."mdpp_discpersen2 double NOT NULL DEFAULT 0,"
					."mdpp_discpersen3 double NOT NULL DEFAULT 0,"
					."mdpp_discrp double NOT NULL DEFAULT 0,"
					."mdpp_bftax double NOT NULL DEFAULT 0,"
					."mdpp_tax double NOT NULL DEFAULT 0,"
					."mdpp_nett double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (mdpp_no, mdpp_mspd_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fmd_paket_prod_createtable(){
		$query = "DROP TABLE IF EXISTS md_paket_prod";
		$this->db->simple_query($query);

		$query = "CREATE TABLE md_paket_prod ("			
					."mdpp_no varchar(9) NOT NULL,"
					."mdpp_mspd_no char(9) NOT NULL,"
					."mdpp_qty double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (mdpp_no, mdpp_mspd_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fms_set_acc_createtable(){
		$query = "DROP TABLE IF EXISTS ms_set_acc";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_set_acc ("			
					." mssa_kode char(4) NOT NULL,"
					." mssa_msap_no char(11) NOT NULL DEFAULT '',"
					." PRIMARY KEY (mssa_kode)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function ftr_purcreq_alter1(){
		$query = "ALTER TABLE tr_purcreq" 					
					." CHANGE trpr_tgl trpr_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fapv_purcreq_alter1(){
		$query = "ALTER TABLE apv_purcreq"
					." CHANGE appr_tgl appr_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_po_alter2(){
		$query = "ALTER TABLE tr_po"
					." CHANGE trpo_tgl trpo_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_in_dlv_alter3(){
		$query = "ALTER TABLE tr_in_dlv"
					." CHANGE trid_tgl trid_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function ftr_purcret_alter6(){
		$query = "ALTER TABLE tr_purcret"
					." CHANGE trpt_tgl trpt_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_spk_alter1(){
		$query = "ALTER TABLE tr_spk"
					." CHANGE trspk_tgl trspk_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function ftr_spk_alter2(){
		$query = "ALTER TABLE tr_spk ADD ("
					." trspk_fin char(1) NOT NULL DEFAULT '',"
					." trspk_stcopy char(1) NOT NULL DEFAULT '')";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function ftr_spk_alter3(){
		$query = "ALTER TABLE tr_spk"					
					." CHANGE trspk_no trspk_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM tr_spk";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}	
	}	

	private function ftr_spk_visit_alter1(){
		$query = "ALTER TABLE tr_spk_visit"
					." CHANGE trsv_tgl trsv_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_spk_visit_alter2(){
		$query = "ALTER TABLE tr_spk_visit"					
					." CHANGE trsv_no trsv_no char(17) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM tr_spk_visit";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_sales_dlv_alter3(){
		$query = "ALTER TABLE tr_sales_dlv"
					." CHANGE trsd_tgl trsd_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}		

	private function ftr_mutasi_alter2(){
		$query = "ALTER TABLE tr_mutasi"
					." CHANGE trmt_tgl trmt_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}		

	private function ftr_adjsotk_alter1(){
		$query = "ALTER TABLE tr_adjstok"
					." CHANGE tras_tgl tras_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}	

	private function fpby_so_alter2(){
		$query = "ALTER TABLE pby_so"
					." CHANGE pbso_tglterima pbso_tglterima DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}	

	private function fpby_po_alter4(){
		$query = "ALTER TABLE pby_po"
					." CHANGE pbpo_tgl pbpo_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}	

	private function ftr_jurnal_alter2(){
		$query = "ALTER TABLE tr_jurnal"
					." CHANGE trju_tgl trju_tgl DATETIME NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}	

	private function ftr_tfmgoods_createtable(){
		$query = "DROP TABLE IF EXISTS tr_tfmgoods";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_tfmgoods ("			
					."trts_no char(11) NOT NULL,"
					."trts_tgl datetime NOT NULL,"
					."trts_msgd_no char(3) NOT NULL DEFAULT '',"
					."trts_msus_no char(4) NOT NULL DEFAULT '',"
					."trts_mscb_no char(1) NOT NULL DEFAULT '',"
					."trts_catatan varchar(250) NOT NULL DEFAULT '',"
					."trts_tag varchar(100) NOT NULL DEFAULT '',"
					."trts_lsupd datetime NOT NULL,"
					."trts_lsusr char(4) NOT NULL DEFAULT '',"
					."trts_cekint integer NOT NULL DEFAULT 0,"
					."trts_void tinyint NOT NULL DEFAULT 0,"					
					." PRIMARY KEY (trts_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fdt_tfmgoods_createtable(){
		$query = "DROP TABLE IF EXISTS dt_tfmgoods";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_tfmgoods ("			
					."dtts_no char(11) NOT NULL,"
					."dtts_seq int NOT NULL,"
					."dtts_jenis char(1) NOT NULL DEFAULT '',"
					."dtts_mspd_no char(9) NOT NULL DEFAULT '',"
					."dtts_qty double NOT NULL DEFAULT 0,"
					."dtts_hpp double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dtts_no, dtts_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fdt_tfmgoods_accper_createtable(){
		$query = "DROP TABLE IF EXISTS dt_tfmgoods_accper";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_tfmgoods_accper ("
					."dttsap_no char(11) NOT NULL,"
					."dttsap_seq int NOT NULL,"
					."dttsap_jenis char(1) NOT NULL DEFAULT '',"
					."dttsap_msap_no char(11) NOT NULL DEFAULT '',"
					."dttsap_total double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dttsap_no, dttsap_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fdt_sales_inquery_alter2(){		
		$query = "ALTER TABLE dt_sales_inquery ADD ("				
					."dtsi_curr varchar(10) NOT NULL DEFAULT '',"
					." dtsi_mspp_no varchar(10) NOT NULL DEFAULT '')";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fdt_so_alter3(){		
		$query = "ALTER TABLE dt_so ADD ("				
					."dtso_curr varchar(10) NOT NULL DEFAULT '',"
					." dtso_mspp_no varchar(10) NOT NULL DEFAULT '')";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function ftr_po_alter3(){
		$query = "ALTER TABLE tr_po ADD ("
					." trpo_lock char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){					
			$query = "UPDATE tr_po SET trpo_lock = 'N'";
			$this->db->simple_query($query);

			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_so_alter6(){
		$query = "ALTER TABLE tr_so ADD ("
					." trso_lock char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){					
			$query = "UPDATE tr_so SET trso_lock = 'N'";
			$this->db->simple_query($query);

			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_so_alter4(){
		$query = "ALTER TABLE dt_so ADD ("
					." dtso_qtysd double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_po_alter3(){
		$query = "ALTER TABLE dt_po ADD ("
					." dtpo_qtyid double NOT NULL DEFAULT 0)";					
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_spk_accper_createtable(){
		$query = "DROP TABLE IF EXISTS dt_spk_accper";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_spk_accper ("
					."dtspkap_no char(11) NOT NULL,"
					."dtspkap_seq int NOT NULL,"					
					."dtspkap_msap_no char(11) NOT NULL DEFAULT '',"
					."dtspkap_total double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dtspkap_no, dtspkap_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fdt_spk_accper_alter1(){
		$query = "ALTER TABLE dt_spk_accper"					
					." CHANGE dtspkap_no dtspkap_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM dt_spk_accper";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}		
	}

	private function fpby_spk_createtable(){
		$query = "DROP TABLE IF EXISTS pby_spk";
		$this->db->simple_query($query);

		$query = "CREATE TABLE pby_spk ("
					."pbspk_no varchar(16) NOT NULL,"
					."pbspk_msjb_no int NOT NULL DEFAULT 0,"
					."pbspk_jlhbayar double NOT NULL DEFAULT 0,"
					."pbspk_catatan varchar(250) NOT NULL DEFAULT '',"
					."pbspk_tglterima datetime NOT NULL,"
					."pbspk_tglcair date NOT NULL,"
					."pbspk_void tinyint NOT NULL DEFAULT 0,"
					."pbspk_lsupd datetime NOT NULL,"
					."pbspk_lsusr char(4) NOT NULL DEFAULT '',"
					."pbspk_msus_no char(4) NOT NULL DEFAULT '',"
					."pbspk_mscb_no char(1) NOT NULL DEFAULT '',"
					." PRIMARY KEY (pbspk_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fpby_spk_alter1(){	
		$query = "ALTER TABLE pby_spk"					
					." CHANGE pbspk_no pbspk_no char(17) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM pby_spk";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}		
	}

	private function ftr_sales_dlv_alter4(){
		$query = "ALTER TABLE tr_sales_dlv ADD ("
					." trsd_dlvnowusr char(4) NOT NULL DEFAULT '',"
					." trsd_cnfusr char(4) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_sales_dlv_alter3(){
		$query = "ALTER TABLE dt_sales_dlv ADD ("					
					." dtsd_hpp double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_salesret_alter2(){
		$query = "ALTER TABLE dt_salesret ADD ("					
					." dtsr_hpp double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_kategori_alter4(){
		$query = "ALTER TABLE ms_kategori ADD ("					
					." mskt_msap_no_srr char(11) NOT NULL DEFAULT '',"
					." mskt_msap_no_sra char(11) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_spk_sp_alter1(){
		$query = "ALTER TABLE dt_spk_sp ADD ("					
					." dtspk_hpp double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_spk_sp_alter2(){
		$query = "ALTER TABLE dt_spk_sp ADD ("
					." dtspk_mdpp_no char(9) NOT NULL DEFAULT '',"
					." dtspk_seqpaket int NOT NULL DEFAULT 0,"
					." dtspk_statuspaket char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}			
	}

	private function fdt_spk_sp_alter3(){
		$query = "ALTER TABLE dt_spk_sp"					
					." CHANGE dtspk_no dtspk_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM dt_spk_sp";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}		
	}

	private function fdt_purcret_alter7(){
		$query = "ALTER TABLE dt_purcret ADD ("					
					." dtpt_hpp double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_adjstok_alter1(){
		$query = "ALTER TABLE dt_adjstok ADD ("					
					." dtas_hpp double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_salesret_alter4(){
		$query = "ALTER TABLE tr_salesret" 					
					." CHANGE trsr_no trsr_no char(21) NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_salesret_alter3(){
		$query = "ALTER TABLE dt_salesret" 					
					." CHANGE dtsr_no dtsr_no char(21) NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_jurnal_alter3(){
		$query = "ALTER TABLE tr_jurnal" 					
					." CHANGE trju_refno trju_refno char(21) NOT NULL DEFAULT ''";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_mutasi_alter1(){
		$query = "ALTER TABLE dt_mutasi ADD ("					
					." dtmt_hpp double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_sales_dlv_alter4(){
		$query = "ALTER TABLE dt_sales_dlv ADD ("					
					." dtsd_bftax double NOT NULL DEFAULT 0,"
					." dtsd_tax double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftop_po_createtable(){
		$query = "DROP TABLE IF EXISTS top_po";
		$this->db->simple_query($query);

		$query = "CREATE TABLE top_po ("									
					." tppo_no char(11) NOT NULL,"
					." tppo_seq int NOT NULL,"
					." tppo_tgljatuhtempo date NOT NULL,"
					." tppo_value double NOT NULL DEFAULT 0,"
					." tppo_cttn varchar(250) NOT NULL DEFAULT '',"
					." PRIMARY KEY (tppo_no, tppo_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}
	}

	private function fdt_in_dlv_alter3(){
		$query = "ALTER TABLE dt_in_dlv ADD ("					
					." dtid_bftaxcurr double NOT NULL DEFAULT 0,"
					." dtid_taxcurr double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_jurnal_alter4(){
		$query = "ALTER TABLE tr_jurnal" 					
					." CHANGE trju_refno trju_refno char(22) NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fpby_so_alter3(){
		$query = "ALTER TABLE pby_so" 					
					." CHANGE pbso_trsr_no pbso_trsr_no char(21) NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_userlog_createtable(){
		$query = "DROP TABLE IF EXISTS ms_userlog";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_userlog ("									
					." msul_no integer NOT NULL AUTO_INCREMENT,"
					." msul_tgl datetime NOT NULL,"
					." msul_msus_no char(4) NOT NULL DEFAULT '',"
					." msul_catatan varchar(250) NOT NULL DEFAULT '',"
					." PRIMARY KEY (msul_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}
	
	private function ftmp_lap_kartustok(){
		$query = "DROP TABLE IF EXISTS tmp_lap_kartustok";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tmp_lap_kartustok ("														
					."tmplks_no integer NOT NULL AUTO_INCREMENT,"
					." tmplks_idlap integer NOT NULL DEFAULT 0,"
					." tmplks_mspd_no char(9) NOT NULL DEFAULT '',"
					." tmplks_tgl datetime NOT NULL,"
					." tmplks_trans_jenis char(2) NOT NULL DEFAULT '',"
					." tmplks_trans_no varchar(25) NOT NULL DEFAULT '',"
					." tmplks_ket varchar(250) NOT NULL DEFAULT '',"
					." tmplks_msgd_no char(3) NOT NULL DEFAULT '',"
					." tmplks_qtyin double NOT NULL DEFAULT 0,"
					." tmplks_qtyout double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (tmplks_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_produk_alter3(){
		$query = "ALTER TABLE ms_produk ADD ("
					." mspd_paket char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){
			$query = "UPDATE ms_produk SET mspd_paket = 'N'";
			$this->db->simple_query($query);							
			return 1;
		}else{
			return 0;
		}			
	}	

	private function fdt_sales_inquery_alter3(){
		$query = "ALTER TABLE dt_sales_inquery ADD ("
					." dtsi_seqpaket int NOT NULL DEFAULT 0,"
					." dtsi_statuspaket char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}			
	}	

	private function fdt_sales_inquery_alter4(){
		$query = "ALTER TABLE dt_sales_inquery" 					
					." CHANGE dtsi_mspp_no dtsi_mdpp_no char(9) NOT NULL DEFAULT ''";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_so_alter5(){
		$query = "ALTER TABLE dt_so ADD ("
					." dtso_seqpaket int NOT NULL DEFAULT 0,"
					." dtso_statuspaket char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}			
	}	

	private function fdt_so_alter6(){
		$query = "ALTER TABLE dt_so" 					
					." CHANGE dtso_mspp_no dtso_mdpp_no char(9) NOT NULL DEFAULT ''";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_tipe_asset_createtable(){
		$query = "DROP TABLE IF EXISTS ms_tipe_asset";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_tipe_asset ("									
					."msta_no char(2) NOT NULL,"
					." msta_nm varchar(100) NOT NULL DEFAULT '',"
					." msta_msmp_no char(2) NOT NULL DEFAULT '',"
					." msta_aktif tinyint NOT NULL DEFAULT 0,"
					." msta_lsupd datetime NOT NULL,"
					." msta_lsusr char(4) NOT NULL DEFAULT '',"
					." msta_listmscb varchar(250) NOT NULL DEFAULT '',"
					." msta_catatan varchar(250) NOT NULL DEFAULT '',"
					." PRIMARY KEY (msta_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function fms_mtd_penyusutan_createtable(){
		$query = "DROP TABLE IF EXISTS ms_mtd_penyusutan";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_mtd_penyusutan ("									
					."msmp_no char(2) NOT NULL,"
					." msmp_nm varchar(100) NOT NULL DEFAULT '',"
					." msmp_metode char(2) NOT NULL DEFAULT '',"
					." msmp_umur int NOT NULL DEFAULT 0,"
					." msmp_tarif double NOT NULL DEFAULT 0,"
					." msmp_aktif tinyint NOT NULL DEFAULT 0,"
					." msmp_lsupd datetime NOT NULL,"
					." msmp_lsusr char(4) NOT NULL DEFAULT '',"
					." msmp_listmscb varchar(250) NOT NULL DEFAULT '',"
					." msmp_catatan varchar(250) NOT NULL DEFAULT '',"
					." PRIMARY KEY (msmp_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_aktiva_tetap_createtable(){
		$query = "DROP TABLE IF EXISTS ms_aktiva_tetap";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_aktiva_tetap ("									
					."msat_no varchar(11) NOT NULL,"
					." msat_msta_no char(2) NOT NULL DEFAULT '',"
					." msat_tgl datetime NOT NULL,"
					." msat_tglbeli date NOT NULL,"
					." msat_tglpakai date NOT NULL,"
					." msat_catatan varchar(250) NOT NULL DEFAULT '',"
					." msat_msap_no_akt char(11) NOT NULL DEFAULT '',"
					." msat_msap_no_akp char(11) NOT NULL DEFAULT '',"
					." msat_msap_no_bbp char(11) NOT NULL DEFAULT '',"
					." msat_nilai_sisa double NOT NULL DEFAULT 0,"
					." msat_total_penyusutan double NOT NULL DEFAULT 0,"					
					." msat_lsupd datetime NOT NULL,"
					." msat_lsusr char(4) NOT NULL DEFAULT '',"					
					." msat_msus_no char(4) NOT NULL DEFAULT '',"
					." msat_mscb_no char(1) NOT NULL DEFAULT '',"
					." msat_cekint integer NOT NULL DEFAULT 0,"
					." msat_void tinyint NOT NULL DEFAULT 0,"
					." msat_tag varchar(100) NOT NULL DEFAULT '',"
					." msat_nprint integer NOT NULL DEFAULT 0,"
					." PRIMARY KEY (msat_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function fmd_aktiva_tetap_createtable(){
		$query = "DROP TABLE IF EXISTS md_aktiva_tetap";
		$this->db->simple_query($query);

		$query = "CREATE TABLE md_aktiva_tetap ("									
					."mdat_no varchar(11) NOT NULL,"
					." mdat_seq int NOT NULL,"
					." mdat_msap_no char(11) NOT NULL DEFAULT '',"
					." mdat_catatan varchar(250) NOT NULL DEFAULT '',"
					." mdat_jumlah double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (mdat_no, mdat_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function fms_aktiva_tetap_alter1(){
		$query = "ALTER TABLE ms_aktiva_tetap ADD ("
					." msat_disp_tgl date NOT NULL,"
					." msat_disp_msap_no char(11) NOT NULL DEFAULT '',"
					." msat_disp_catatan varchar(250) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}			
	}

	private function fms_aktiva_tetap_alter2(){
		$query = "ALTER TABLE ms_aktiva_tetap ADD ("					
					." msat_seq_bln int NOT NULL DEFAULT 0,"
					." msat_last_penyusutan date NOT NULL,"
					." msat_nilai_awal double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}			
	}

	private function fms_produk_alter4(){
		$query = "ALTER TABLE ms_produk ADD ("
					." mspd_fin char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){
			$query = "UPDATE ms_produk SET mspd_fin = 'F'";
			$this->db->simple_query($query);
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_adjstok_alter1(){
		$query = "ALTER TABLE tr_adjstok"
					." CHANGE tras_no tras_no char(12) NOT NULL";					
					
		if($this->db->simple_query($query)){			
			$query = "DELETE FROM tr_adjstok";
			$this->db->simple_query($query);
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_adjstok_alter2(){
		$query = "ALTER TABLE dt_adjstok"
					." CHANGE dtas_no dtas_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){			
			$query = "DELETE FROM dt_adjstok";
			$this->db->simple_query($query);
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_adjstok_alter2(){
		$query = "ALTER TABLE tr_adjstok ADD ("
					." tras_fin char(1) NOT NULL DEFAULT '',"
					." tras_stcopy char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_jurnal_alter5(){
		$query = "ALTER TABLE tr_jurnal ADD ("
					." trju_fin char(1) NOT NULL DEFAULT '',"
					." trju_stcopy char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_jurnal_alter6(){
		$query = "ALTER TABLE tr_jurnal "
					." CHANGE trju_no trju_no char(15) NOT NULL,"
					." CHANGE trju_refno trju_refno varchar(23) NOT NULL DEFAULT ''";
					
		if($this->db->simple_query($query)){			
			$query = "DELETE FROM tr_jurnal";
			$this->db->simple_query($query);
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_jurnal_alter2(){
		$query = "ALTER TABLE dt_jurnal"
					." CHANGE dtju_no dtju_no char(15) NOT NULL";
					
		if($this->db->simple_query($query)){			
			$query = "DELETE FROM dt_jurnal";
			$this->db->simple_query($query);
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_sales_inquery_alter5(){
		$query = "ALTER TABLE tr_sales_inquery ADD ("
					." trsi_fin char(1) NOT NULL DEFAULT '',"
					." trsi_stcopy char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}	

	private function ftr_sales_inquery_alter6(){
		$query = "ALTER TABLE tr_sales_inquery"
					." CHANGE trsi_no trsi_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM tr_sales_inquery";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_sales_inquery_alter5(){
		$query = "ALTER TABLE dt_sales_inquery"
					." CHANGE dtsi_no dtsi_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){			
			$query = "DELETE FROM dt_sales_inquery";
			$this->db->simple_query($query);
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_so_alter7(){
		$query = "ALTER TABLE tr_so ADD ("
					." trso_fin char(1) NOT NULL DEFAULT '',"
					." trso_stcopy char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}		

	private function ftr_so_alter8(){
		$query = "ALTER TABLE tr_so"
					." CHANGE trso_no trso_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM tr_so";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}	

	private function fdt_so_alter7(){
		$query = "ALTER TABLE dt_so"
					." CHANGE dtso_no dtso_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){			
			$query = "DELETE FROM dt_so";
			$this->db->simple_query($query);
			return 1;
		}else{
			return 0;
		}
	}	

	private function ftop_so_alter1(){
		$query = "ALTER TABLE top_so"
					." CHANGE tpso_no tpso_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){			
			$query = "DELETE FROM top_so";
			$this->db->simple_query($query);
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_sales_dlv_alter5(){
		$query = "ALTER TABLE tr_sales_dlv"
					." CHANGE trsd_no trsd_no char(17) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM tr_sales_dlv";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_sales_dlv_alter5(){
		$query = "ALTER TABLE dt_sales_dlv"
					." CHANGE dtsd_no dtsd_no char(17) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM dt_sales_dlv";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function fpby_so_alter4(){
		$query = "ALTER TABLE pby_so"
					." CHANGE pbso_no pbso_no char(17) NOT NULL,"
					." CHANGE pbso_refno pbso_refno char(17) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM pby_so";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_salesret_alter5(){
		$query = "ALTER TABLE tr_salesret"					
					." CHANGE trsr_no trsr_no char(22) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM tr_salesret";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_salesret_alter4(){
		$query = "ALTER TABLE dt_salesret"					
					." CHANGE dtsr_no dtsr_no char(22) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM dt_salesret";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function fpby_so_alter5(){
		$query = "ALTER TABLE pby_so"					
					." CHANGE pbso_trsr_no pbso_trsr_no char(22) NOT NULL DEFAULT ''";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM pby_so";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_salesret_alter6(){
		$query = "ALTER TABLE tr_salesret"					
					." CHANGE trsr_pbso_no trsr_pbso_no char(17) NOT NULL DEFAULT ''";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM tr_salesret";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_tfmgoods_alter1(){
		$query = "ALTER TABLE tr_tfmgoods"					
					." CHANGE trts_no trts_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM tr_tfmgoods";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_tfmgoods_alter1(){
		$query = "ALTER TABLE dt_tfmgoods"					
					." CHANGE dtts_no dtts_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM dt_tfmgoods";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}	

	private function ftr_tfmgoods_alter2(){
		$query = "ALTER TABLE tr_tfmgoods ADD ("
					." trts_fin char(1) NOT NULL DEFAULT '',"
					." trts_stcopy char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_tfmgoods_accper_alter1(){
		$query = "ALTER TABLE dt_tfmgoods_accper"					
					." CHANGE dttsap_no dttsap_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM dt_tfmgoods_accper";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_mutasi_alter3(){
		$query = "ALTER TABLE tr_mutasi ADD ("
					." trmt_fin char(1) NOT NULL DEFAULT '',"
					." trmt_stcopy char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_mutasi_alter4(){
		$query = "ALTER TABLE tr_mutasi"					
					." CHANGE trmt_no trmt_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM tr_mutasi";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_mutasi_alter2(){
		$query = "ALTER TABLE dt_mutasi"					
					." CHANGE dtmt_no dtmt_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM dt_mutasi";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function fapv_mutasi_alter1(){
		$query = "ALTER TABLE apv_mutasi"					
					." CHANGE apmt_no apmt_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM apv_mutasi";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_cvtgoods_createtable(){
		$query = "DROP TABLE IF EXISTS tr_cvtgoods";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_cvtgoods ("									
					."trcv_no char(12) NOT NULL,"
					." trcv_tgl date NOT NULL,"
					." trcv_msgd_no char(3) NOT NULL DEFAULT '',"
					." trcv_msus_no char(4) NOT NULL DEFAULT '',"
					." trcv_mscb_no char(1) NOT NULL DEFAULT '',"
					." trcv_catatan varchar(250) NOT NULL DEFAULT '',"
					." trcv_tag varchar(100) NOT NULL DEFAULT '',"
					." trcv_lsupd datetime NOT NULL,"
					." trcv_lsusr char(4) NOT NULL DEFAULT '',"
					." trcv_cekint integer NOT NULL DEFAULT 0,"
					." trcv_void tinyint NOT NULL DEFAULT 0,"
					." trcv_fin char(1) NOT NULL DEFAULT '',"
					." trcv_stcopy char(1) NOT NULL DEFAULT '',"
					." PRIMARY KEY (trcv_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
					
		if($this->db->simple_query($query)){								
			return 1;
		}else{
			return 0;
		}
	}	

	private function fdt_cvtgoods_createtable(){
		$query = "DROP TABLE IF EXISTS dt_cvtgoods";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_cvtgoods ("									
					."dtcv_no char(12) NOT NULL,"
					." dtcv_seq int NOT NULL,"
					." dtcv_jenis char(1) NOT NULL DEFAULT '',"
					." dtcv_mspd_no char(9) NOT NULL DEFAULT '',"
					." dtcv_qty double NOT NULL DEFAULT 0,"
					." dtcv_hpp double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dtcv_no, dtcv_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
					
		if($this->db->simple_query($query)){								
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_cvtgoods_accper_createtable(){
		$query = "DROP TABLE IF EXISTS dt_cvtgoods_accper";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_cvtgoods_accper ("									
					."dtcvap_no char(12) NOT NULL,"
					." dtcvap_seq int NOT NULL,"
					." dtcvap_jenis char(1) NOT NULL DEFAULT '',"
					." dtcvap_msap_no char(11) NOT NULL DEFAULT '',"
					." dtcvap_total double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (dtcvap_no, dtcvap_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
					
		if($this->db->simple_query($query)){								
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_po_alter4(){
		$query = "ALTER TABLE tr_po ADD ("
					." trpo_fin char(1) NOT NULL DEFAULT '',"
					." trpo_stcopy char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}	

	private function ftr_po_alter5(){
		$query = "ALTER TABLE tr_po"					
					." CHANGE trpo_no trpo_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM tr_po";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}	

	private function fdt_po_alter4(){
		$query = "ALTER TABLE dt_po"					
					." CHANGE dtpo_no dtpo_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM dt_po";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}	

	private function ftop_po_alter1(){
		$query = "ALTER TABLE top_po"					
					." CHANGE tppo_no tppo_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM top_po";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_purcreq_alter1(){
		$query = "ALTER TABLE dt_purcreq"					
					." CHANGE dtpr_no dtpr_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM tr_purcreq";
			$this->db->simple_query($query);			
			$query = "DELETE FROM dt_purcreq";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_apv_purcreq_alter1(){
		$query = "ALTER TABLE dt_apv_purcreq"					
					." CHANGE dappr_no dappr_no char(12) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM apv_purcreq";
			$this->db->simple_query($query);			
			$query = "DELETE FROM dt_apv_purcreq";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_in_dlv_alter4(){
		$query = "ALTER TABLE tr_in_dlv"
					." CHANGE trid_no trid_no char(17) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM tr_in_dlv";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_in_dlv_alter4(){
		$query = "ALTER TABLE dt_in_dlv"
					." CHANGE dtid_no dtid_no char(17) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM dt_in_dlv";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function fpby_in_dlv_biayakirim_alter1(){
		$query = "ALTER TABLE pby_in_dlv_biayakirim"
					." CHANGE pbidbk_trid_no pbidbk_trid_no char(17) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM pby_in_dlv_biayakirim";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}	

	private function fpby_in_dlv_beamasuk_alter1(){
		$query = "ALTER TABLE pby_in_dlv_beamasuk"
					." CHANGE pbidbm_trid_no pbidbm_trid_no char(17) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM pby_in_dlv_beamasuk";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}
	
	private function fpby_po_alter5(){
		$query = "ALTER TABLE pby_po"
					." CHANGE pbpo_no pbpo_no char(17) NOT NULL,"
					." CHANGE pbpo_refno pbpo_refno char(17) NOT NULL,"
					." CHANGE pbpo_trpt_no pbpo_trpt_no char(17) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM pby_po";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_purcret_alter7(){
		$query = "ALTER TABLE tr_purcret"
					." CHANGE trpt_no trpt_no char(17) NOT NULL,"
					." CHANGE trpt_pbpo_no trpt_pbpo_no char(17) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM tr_purcret";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_purcret_alter8(){
		$query = "ALTER TABLE dt_purcret"
					." CHANGE dtpt_no dtpt_no char(17) NOT NULL";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM dt_purcret";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_so_alter9(){
		$query = "ALTER TABLE tr_so ADD ("					
					." trso_klas char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function fms_aktiva_tetap_alter3(){
		$query = "ALTER TABLE ms_aktiva_tetap ADD ("
					." msat_fin char(1) NOT NULL DEFAULT '',"
					." msat_stcopy char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){
			$query = "DELETE FROM ms_aktiva_tetap";
			$this->db->simple_query($query);
			$query = "DELETE FROM md_aktiva_tetap";
			$this->db->simple_query($query);			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_adjstok_alter3(){
		$query = "ALTER TABLE tr_adjstok ADD ("
					." tras_lscopy datetime NOT NULL)";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_tfmgoods_alter3(){
		$query = "ALTER TABLE tr_tfmgoods ADD ("
					." trts_lscopy datetime NOT NULL)";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_mutasi_alter5(){
		$query = "ALTER TABLE tr_mutasi ADD ("
					." trmt_lscopy datetime NOT NULL)";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_mutasi_alter6(){
		$query = "ALTER TABLE tr_mutasi ADD "															
					."(trmt_usrkirim varchar(4) NOT NULL DEFAULT '' "
					.",trmt_usrterima varchar(4) NOT NULL DEFAULT '' "
					.")";
	
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_so_alter10(){
		$query = "ALTER TABLE tr_so ADD ("
					." trso_lscopy datetime NOT NULL)";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_po_alter6(){
		$query = "ALTER TABLE tr_po ADD ("
					." trpo_lscopy datetime NOT NULL)";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_spk_alter4(){
		$query = "ALTER TABLE tr_spk ADD ("
					." trspk_lscopy datetime NOT NULL)";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function fms_customer_alter5(){
		$query = "ALTER TABLE ms_customer ADD ("
					." mscs_klas char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){
			$query = "UPDATE ms_customer SET mscs_klas = '0'";
			$this->db->simple_query($query);
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_jurnal_alter7(){
		$query = "ALTER TABLE tr_jurnal ADD ("
					." trju_lscopy datetime NOT NULL)";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function fms_aktiva_tetap_alter4(){
		$query = "ALTER TABLE ms_aktiva_tetap ADD ("
					." msat_lscopy datetime NOT NULL)";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_cvtgoods_alter1(){
		$query = "ALTER TABLE tr_cvtgoods ADD ("
					." trcv_lscopy datetime NOT NULL)";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_adjstok_alter4(){
		$query = "ALTER TABLE tr_adjstok ADD ("
					." tras_manual char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			$query = "UPDATE tr_adjstok SET tras_manual = 'Y'";
			$this->db->simple_query($query);
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_history_hpp_createtable(){
		$query = "DROP TABLE IF EXISTS tr_history_hpp";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_history_hpp ("									
					." trhpp_no integer NOT NULL AUTO_INCREMENT,"
					." trhpp_tgl datetime NOT NULL,"
					." trhpp_jenis char(3) NOT NULL DEFAULT '',"
					." trhpp_refno varchar(23) NOT NULL DEFAULT '',"
					." trhpp_mspd_no char(9) NOT NULL DEFAULT '',"
					." trhpp_qtytrans double NOT NULL DEFAULT 0,"
					." trhpp_hrgsat double NOT NULL DEFAULT 0,"
					." trhpp_hppakhir double NOT NULL DEFAULT 0,"
					." trhpp_qtyawal double NOT NULL DEFAULT 0,"
					." trhpp_hppawal double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (trhpp_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
					
		if($this->db->simple_query($query)){								
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_his_hpp_createtable(){
		$query = "DROP TABLE IF EXISTS tr_his_hpp";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_his_hpp ("														
					." trhpp_tgl datetime NOT NULL,"
					." trhpp_refjenis char(3) NOT NULL,"
					." trhpp_refno varchar(23) NOT NULL,"
					." trhpp_mspd_no char(9) NOT NULL,"
					." trhpp_qtyawal double NOT NULL DEFAULT 0,"
					." trhpp_hppawal double NOT NULL DEFAULT 0,"
					." trhpp_qtytrans double NOT NULL DEFAULT 0,"
					." trhpp_totalawal double NOT NULL DEFAULT 0,"
					." trhpp_totaltrans double NOT NULL DEFAULT 0,"
					." trhpp_hppakhir double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
					
		if($this->db->simple_query($query)){								
			return 1;
		}else{
			return 0;
		}
	}

	private function fpby_in_dlv_ppnshipping_createtable(){
		$query = "DROP TABLE IF EXISTS pby_in_dlv_ppnshipping";
		$this->db->simple_query($query);

		$query = "CREATE TABLE pby_in_dlv_ppnshipping ("		
					."pbidps_trid_no varchar(17) NOT NULL,"
					." pbidps_tgl datetime NOT NULL,"
					." pbidps_adj double NOT NULL DEFAULT 0,"
					." pbidps_msjb_no int NOT NULL DEFAULT 0,"
					." pbidps_jlhbayar double NOT NULL DEFAULT 0,"
					." pbidps_catatan varchar(250) NOT NULL DEFAULT '',"
					." pbidps_tglbayar date NOT NULL,"
					." pbidps_tag varchar(100) NOT NULL DEFAULT '',"
					." pbidps_msus_no char(4) NOT NULL DEFAULT '',"
					." pbidps_mscb_no char(1) NOT NULL DEFAULT '',"
					." PRIMARY KEY (pbidps_trid_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function ftr_in_dlv_alter5(){
		$query = "ALTER TABLE tr_in_dlv ADD ("					
					." trid_totalppnshipping double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function fpby_in_dlv_pph22_createtable(){
		$query = "DROP TABLE IF EXISTS pby_in_dlv_pph22";
		$this->db->simple_query($query);

		$query = "CREATE TABLE pby_in_dlv_pph22 ("		
					."pbidph_trid_no varchar(17) NOT NULL,"
					." pbidph_tgl datetime NOT NULL,"
					." pbidph_adj double NOT NULL DEFAULT 0,"
					." pbidph_msjb_no int NOT NULL DEFAULT 0,"
					." pbidph_jlhbayar double NOT NULL DEFAULT 0,"
					." pbidph_catatan varchar(250) NOT NULL DEFAULT '',"
					." pbidph_tglbayar date NOT NULL,"
					." pbidph_tag varchar(100) NOT NULL DEFAULT '',"
					." pbidph_msus_no char(4) NOT NULL DEFAULT '',"
					." pbidph_mscb_no char(1) NOT NULL DEFAULT '',"
					." PRIMARY KEY (pbidph_trid_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function ftr_in_dlv_alter6(){
		$query = "ALTER TABLE tr_in_dlv ADD ("					
					." trid_totalpph22 double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_jurnal_alter3(){
		$query = "ALTER TABLE dt_jurnal ADD ("
					." dtju_catatan varchar(250) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function fms_accgrp_alter1(){		
		$query = "ALTER TABLE ms_accgrp ADD ("
					." msag_kelompok_i char(1) NOT NULL DEFAULT '',"
					." msag_kelompok_b char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function fms_accgrp_alter2(){
		$query = "ALTER TABLE ms_accgrp ADD ("
					." msag_kelompok int NOT NULL DEFAULT 0)";				
					
		if($this->db->simple_query($query)){			
			$query = "UPDATE ms_accgrp SET msag_kelompok = msag_kelompok_b where msag_kelompok_b <> ''";			
			$this->db->simple_query($query);

			$query = "UPDATE ms_accgrp SET msag_kelompok = 100 + msag_kelompok_i where msag_kelompok_i <> ''";
			$this->db->simple_query($query);	

			$query = "ALTER TABLE ms_accgrp DROP COLUMN msag_kelompok_b, DROP COLUMN msag_kelompok_i";
			$this->db->simple_query($query);	
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_cvtgoods_alter2(){
		$query = "ALTER TABLE tr_cvtgoods"
					." CHANGE trcv_tgl trcv_tgl datetime NOT NULL";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function fpby_po_alter6(){
		$query = "ALTER TABLE pby_po"
					." CHANGE pbpo_tglbayar pbpo_tglcair date NOT NULL";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function fhis_accgrp_createtable(){
		$query = "DROP TABLE IF EXISTS his_accgrp";
		$this->db->simple_query($query);

		$query = "CREATE TABLE his_accgrp ("		
					." hsag_periode char(6) NOT NULL,"
					." hsag_no char(2) NOT NULL,"
					." hsag_nm varchar(100) NOT NULL DEFAULT '',"
					." hsag_listmscb varchar(250) NOT NULL DEFAULT '',"
					." hsag_jenis char(1) NOT NULL DEFAULT '',"
					." hsag_kelompok int(11) NOT NULL DEFAULT 0,"
					." hsag_salnorm char(1) NOT NULL,"
					." hsag_aktif tinyint NOT NULL DEFAULT 0,"					
					." PRIMARY KEY (hsag_periode, hsag_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fhis_accsub_createtable(){
		$query = "DROP TABLE IF EXISTS his_accsub";
		$this->db->simple_query($query);

		$query = "CREATE TABLE his_accsub ("		
					." hsas_periode char(6) NOT NULL,"
					." hsas_no char(5) NOT NULL,"
					." hsas_nm varchar(100) NOT NULL DEFAULT '',"
					." hsas_listmscb varchar(250) NOT NULL DEFAULT '',"
					." hsas_salnorm char(1) NOT NULL,"
					." hsas_aktif tinyint NOT NULL DEFAULT 0,"					
					." PRIMARY KEY (hsas_periode, hsas_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function fhis_accper_createtable(){
		$query = "DROP TABLE IF EXISTS his_accper";
		$this->db->simple_query($query);

		$query = "CREATE TABLE his_accper ("
					." hsap_periode char(6) NOT NULL,"
					." hsap_no char(11) NOT NULL,"
					." hsap_nm varchar(100) NOT NULL DEFAULT '',"
					." hsap_debet double NOT NULL DEFAULT 0,"
					." hsap_kredit double NOT NULL DEFAULT 0,"
					." hsap_listmscb varchar(250) NOT NULL DEFAULT '',"
					." hsap_aktif tinyint NOT NULL DEFAULT 0,"					
					." PRIMARY KEY (hsap_periode, hsap_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}

	private function fset_lst_jurnal_closingdef(){
		$this->db->delete('simrel',array('simr_no' => 'tcj','simr_seq' => 1));

		$data = array(
		        'simr_no' => 'tcj',
		        'simr_seq' => 1,
		        'simr_char1' => '0',
		        'simr_char2' => '',
		        'simr_int1' => '',
		        'simr_int2' => 0,
		        'simr_doub' => 0
		);

		$this->db->insert('simrel',$data);

		if ($this->db->affected_rows() > 0 ) {
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_jurnal_alter8(){					
		$query = "ALTER TABLE tr_jurnal ADD ("															
					." trju_tag varchar(100) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){			
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftop_spk_createtable(){
		$query = "DROP TABLE IF EXISTS top_spk";
		$this->db->simple_query($query);

		$query = "CREATE TABLE top_spk ("									
					." tpspk_no char(12) NOT NULL,"
					." tpspk_seq int NOT NULL,"
					." tpspk_tgljatuhtempo date NOT NULL,"
					." tpspk_value double NOT NULL DEFAULT 0,"
					." tpspk_cttn varchar(250) NOT NULL DEFAULT '',"
					." PRIMARY KEY (tpspk_no, tpspk_seq)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_kategori_alter5(){					
		$query = "ALTER TABLE ms_kategori ADD ("															
					." mskt_msap_no_spr char(11) NOT NULL DEFAULT '',"
					." mskt_msap_no_spa char(11) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){			
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftmp_lap_mutasi_hutang_cust_createtable(){					
		$query = "DROP TABLE IF EXISTS tmp_lap_mutasi_hutang_cust";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tmp_lap_mutasi_hutang_cust ("														
					."thc_no integer NOT NULL AUTO_INCREMENT,"
					." thc_idlap integer NOT NULL DEFAULT 0,"
					." thc_tahap integer NOT NULL DEFAULT 0,"
					." thc_mscs_no char(6) NOT NULL DEFAULT '',"
					." thc_tgltran date NOT NULL,"
					." thc_jnstran varchar(50) NOT NULL DEFAULT '',"					
					." thc_kettran varchar(250) NOT NULL DEFAULT '',"					
					." thc_dp double NOT NULL DEFAULT 0,"
					." thc_value double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (thc_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftmp_lap_top_cust_createtable(){					
		$query = "DROP TABLE IF EXISTS tmp_lap_top_cust";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tmp_lap_top_cust ("														
					." tltc_no integer NOT NULL AUTO_INCREMENT,"
					." tltc_idlap integer NOT NULL DEFAULT 0,"
					." tltc_tgl_jatuhtempo date NOT NULL,"
					." tltc_value double NOT NULL DEFAULT 0,"
					." tltc_tgltran date NOT NULL,"
					." tltc_notran varchar(25) NOT NULL DEFAULT '',"
					." tltc_pocust varchar(100) NOT NULL DEFAULT '',"
					." tltc_mscs_no char(6) NOT NULL DEFAULT '',"
					." tltc_mssl_no char(10) NOT NULL DEFAULT '',"
					." tltc_total double NOT NULL DEFAULT 0,"
					." tltc_terbayar double NOT NULL DEFAULT 0,"
					." tltc_catatan_top varchar(250) NOT NULL DEFAULT '',"
					." tltc_catatan_tran varchar(250) NOT NULL DEFAULT '',"
					." tltc_tag varchar(100) NOT NULL DEFAULT '',"
					." PRIMARY KEY (tltc_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftmp_sales_dlv_hpp_createtable(){					
		$query = "DROP TABLE IF EXISTS tmp_sales_dlv_hpp";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tmp_sales_dlv_hpp ("														
					." tsdh_no integer NOT NULL AUTO_INCREMENT,"
					." tsdh_idlap integer NOT NULL DEFAULT 0,"					
					." tsdh_mspd_no char(11) NOT NULL DEFAULT '',"
					." tsdh_jnstran varchar(50) NOT NULL DEFAULT '',"
					." tsdh_notran varchar(22) NOT NULL DEFAULT '',"
					." tsdh_tgltran date NOT NULL,"
					." tsdh_mscs_no char(6) NOT NULL DEFAULT '',"
					." tsdh_mssl_no char(10) NOT NULL DEFAULT '',"
					." tsdh_qty double NOT NULL DEFAULT 0,"
					." tsdh_bftax double NOT NULL DEFAULT 0,"
					." tsdh_nett double NOT NULL DEFAULT 0,"
					." tsdh_hpp double NOT NULL DEFAULT 0,"
					." tsdh_catatan_tran varchar(250) NOT NULL DEFAULT '',"
					." PRIMARY KEY (tsdh_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_sales_dlv_alter6(){					
		$query = "ALTER TABLE dt_sales_dlv ADD ("
					." dtsd_statuspaket char(1) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){						
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_sales_dlv_alter7(){					
		$query = "UPDATE dt_sales_dlv SET dtsd_statuspaket = IFNULL((
																SELECT dtso_statuspaket FROM dt_so
																WHERE dtso_no = substring(dtsd_no, 1, 12)
																AND dtso_seq = dtsd_seq
																),'N')";	
	
		if($this->db->simple_query($query)){											
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function fms_stok_alter1(){					
		$query = "DELETE FROM ms_stok WHERE msst_mspd_no in (SELECT mspd_no FROM ms_produk WHERE mspd_paket = 'Y')";	
	
		if($this->db->simple_query($query)){											
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_produk_alter5(){					
		$query = "UPDATE ms_produk SET mspd_hpp = 0 WHERE mspd_paket = 'Y'";	
	
		if($this->db->simple_query($query)){											
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_so_alter11(){					
		$query = "ALTER TABLE tr_so ADD ("
					." trso_tglbataslock date NOT NULL)";
	
		if($this->db->simple_query($query)){						
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function ftmp_lap_spk_createtable(){					
		$query = "DROP TABLE IF EXISTS tmp_lap_spk";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tmp_lap_spk ("														
					." tls_no int (11) NOT NULL AUTO_INCREMENT,"
					." tls_idlap int (11) NOT NULL DEFAULT 0,"
					." tls_ref_jns char(1) NOT NULL DEFAULT '',"
					." tls_ref_no char(17) NOT NULL DEFAULT '',"
					." tls_ref_v_tglrncnvisitfrom date NOT NULL,"
					." tls_ref_v_tglrncnvisituntil date NOT NULL,"
					." tls_ref_v_tglvisitfrom date NOT NULL,"
					." tls_ref_v_tglvisituntil date NOT NULL,"
					." tls_ref_v_mssl_no char(10) NOT NULL DEFAULT '',"
					." tls_ref_v_mssl_nm varchar(100) NOT NULL DEFAULT '',"
					." tls_ref_v_catatan varchar(250) NOT NULL DEFAULT '',"
					." tls_ref_v_kesimpulan varchar(250) NOT NULL DEFAULT '',"
					." tls_ref_v_ketkonfirmasi varchar(250) NOT NULL DEFAULT '',"
					." tls_ref_s_mspd_no char(9) NOT NULL DEFAULT '',"
					." tls_ref_s_mspd_nm varchar(100) NOT NULL DEFAULT '',"
					." tls_ref_s_qty double NOT NULL DEFAULT 0,"
					." tls_ref_s_nett double NOT NULL DEFAULT 0,"					
					." tls_ref_a_msap_no char(11) NOT NULL DEFAULT '',"
					." tls_ref_a_msap_nm varchar(100) NOT NULL DEFAULT '',"
					." tls_ref_a_total double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (tls_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}		

	private function ftr_so_alter12(){					
		$query = "UPDATE tr_so SET trso_tglbataslock = DATE_ADD(CONVERT(trso_tgl, DATE), INTERVAL 89 DAY)";	
	
		if($this->db->simple_query($query)){											
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function ftmp_lap_kartustok_alter1(){					
		$query = "ALTER TABLE tmp_lap_kartustok ADD (
					 tmplks_harga double NOT NULL DEFAULT 0)";
	
		if($this->db->simple_query($query)){						
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_po_alter7(){					
		$query = "ALTER TABLE tr_po ADD (
					 trpo_final char(1) NOT NULL DEFAULT 'N')";
	
		if($this->db->simple_query($query)){						
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftop_po_alter2(){					
		$query = "ALTER TABLE top_po ADD (
					 tppo_aktif char(1) NOT NULL DEFAULT 'Y')";
	
		if($this->db->simple_query($query)){						
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftop_so_alter2(){					
		$query = "ALTER TABLE top_so ADD (
					 tpso_aktif char(1) NOT NULL DEFAULT 'Y')";
	
		if($this->db->simple_query($query)){						
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function ftop_spk_alter1(){					
		$query = "ALTER TABLE top_spk ADD (
					 tpspk_aktif char(1) NOT NULL DEFAULT 'Y')";
	
		if($this->db->simple_query($query)){						
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_sales_dlv_alter8(){							
		$query = "UPDATE dt_sales_dlv 
					LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
					LEFT JOIN ms_produk ON mspd_no = dtsd_mspd_no
					SET 	dtsd_tglgaransisp = DATE_ADD(trsd_tglbalik, INTERVAL mspd_garansisp DAY),
							dtsd_tglgaransijasa = DATE_ADD(trsd_tglbalik, INTERVAL mspd_garansijasa DAY)
					WHERE trsd_tglbalik <> '0000-00-00'
					AND dtsd_qtyrej	<= 0
					AND trsd_void = 0
					AND mspd_reqserialno = 'Y'";
	
		if($this->db->simple_query($query)){											
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftmp_so_top_dlv_createtable(){					
		$query = "DROP TABLE IF EXISTS tmp_so_top_dlv";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tmp_so_top_dlv ("																			
					." tstd_no int(11) NOT NULL AUTO_INCREMENT,"
					." tstd_idlap int(11) NOT NULL DEFAULT 0,"
					." tstd_ref_jns char(1) NOT NULL DEFAULT '',"
					." tstd_ref_no char(17) NOT NULL DEFAULT '',"
					." tstd_ref_t_tgljatuhtempo date NOT NULL,"
					." tstd_ref_t_value double NOT NULL DEFAULT 0,"
					." tstd_ref_t_cttn varchar(250) NOT NULL DEFAULT '',"
					." tstd_ref_t_status char(1) NOT NULL DEFAULT '',"
					." tstd_ref_d_tgl date NOT NULL,"
					." tstd_ref_d_tglkirim date NOT NULL,"					
					." tstd_ref_d_status varchar(50) NOT NULL DEFAULT '',"
					." tstd_ref_d_catatan varchar(250) NOT NULL DEFAULT '',"
					." tstd_ref_d_total double NOT NULL DEFAULT 0,"
					." tstd_ref_d_terbayar double NOT NULL DEFAULT 0,"
					." tstd_ref_p_tgl date NOT NULL,"
					." tstd_ref_p_tglcair date NOT NULL,"
					." tstd_ref_p_jlhbayar double NOT NULL DEFAULT 0,"
					." tstd_ref_p_payfor varchar(50) NOT NULL DEFAULT '',"
					." tstd_ref_p_refno char(17) NOT NULL DEFAULT '',"
					." tstd_ref_p_paidfrom varchar(50) NOT NULL DEFAULT '',"
					." tstd_ref_p_catatan varchar(250) NOT NULL DEFAULT '',"
					." PRIMARY KEY (tstd_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftmp_so_top_dlv_alter1(){					
		$query = "ALTER TABLE tmp_so_top_dlv ADD (
					 tstd_ref_d_tglbalik date NOT NULL)";
	
		if($this->db->simple_query($query)){						
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftmp_lap_spk_alter1(){					
		$query = "ALTER TABLE tmp_lap_spk ADD (
					 tls_ref_s_hpp double NOT NULL DEFAULT 0)";
	
		if($this->db->simple_query($query)){						
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_jurnal_alter4(){
		$query = "ALTER TABLE dt_jurnal ADD ("
					." dtju_cek char(1) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}	

	private function fset_lst_closing_init(){		
		$this->db->update('simrel', array('simr_char1' => '201712', 'simr_char2' => '201712'), array('simr_no' => 'tcj', 'simr_seq' => 1));
					
		if($this->db->affected_rows() > 0 ) {
			return 1;
		}else{
			return 0;
		}
	}	

	private function fms_cabang_alter3(){					
		$query = "ALTER TABLE ms_cabang ADD (
					 mscb_listmsgd varchar(250) NOT NULL DEFAULT '')";
	
		if($this->db->simple_query($query)){						
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_mutasi_alter3(){
		$query = "ALTER TABLE dt_mutasi ADD ("					
					." dtmt_catatan varchar(250) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_mutasi_createindex(){					
		$query = "ALTER TABLE dt_mutasi DROP INDEX dtmt_idx";
		$this->db->simple_query($query);
		
		$query = "CREATE INDEX dtmt_idx ON dt_mutasi (dtmt_mspd_no)";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function fdt_so_createindex(){					
		$query = "ALTER TABLE dt_so DROP INDEX dtso_idx";
		$this->db->simple_query($query);
		
		$query = "CREATE INDEX dtso_idx ON dt_so (dtso_mspd_no)";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_po_createindex(){					
		$query = "ALTER TABLE dt_po DROP INDEX dtpo_idx";
		$this->db->simple_query($query);
		
		$query = "CREATE INDEX dtpo_idx ON dt_po (dtpo_mspd_no)";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_sales_dlv_createindex(){					
		$query = "ALTER TABLE dt_sales_dlv DROP INDEX dtsd_idx";
		$this->db->simple_query($query);
		
		$query = "CREATE INDEX dtsd_idx ON dt_sales_dlv (dtsd_mspd_no)";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_adjstok_createindex(){					
		$query = "ALTER TABLE dt_adjstok DROP INDEX dtas_idx";
		$this->db->simple_query($query);
		
		$query = "CREATE INDEX dtas_idx ON dt_adjstok (dtas_mspd_no)";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function fdt_salesret_createindex(){					
		$query = "ALTER TABLE dt_salesret DROP INDEX dtsr_idx";
		$this->db->simple_query($query);
		
		$query = "CREATE INDEX dtsr_idx ON dt_salesret (dtsr_mspd_no)";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_purcret_createindex(){					
		$query = "ALTER TABLE dt_purcret DROP INDEX dtpt_idx";
		$this->db->simple_query($query);
		
		$query = "CREATE INDEX dtpt_idx ON dt_purcret (dtpt_mspd_no)";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_jurnal_createindex(){					
		$query = "ALTER TABLE dt_jurnal DROP INDEX dtju_idx";
		$this->db->simple_query($query);
		
		$query = "CREATE INDEX dtju_idx ON dt_jurnal (dtju_msap_no)";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_in_dlv_createindex(){					
		$query = "ALTER TABLE dt_in_dlv DROP INDEX dtid_idx";
		$this->db->simple_query($query);
		
		$query = "CREATE INDEX dtid_idx ON dt_in_dlv (dtid_mspd_no)";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_tfmgoods_createindex(){					
		$query = "ALTER TABLE dt_tfmgoods DROP INDEX dtts_idx";
		$this->db->simple_query($query);
		
		$query = "CREATE INDEX dtts_idx ON dt_tfmgoods (dtts_mspd_no)";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_cvtgoods_createindex(){					
		$query = "ALTER TABLE dt_cvtgoods DROP INDEX dtcv_idx";
		$this->db->simple_query($query);
		
		$query = "CREATE INDEX dtcv_idx ON dt_cvtgoods (dtcv_mspd_no)";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_cabang_alter4(){
		$query = "ALTER TABLE ms_cabang ADD(
					mscb_prshn_nm varchar(100) NOT NULL DEFAULT '',
					mscb_logo varchar(250) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_cabang_alter5(){
		$query = "ALTER TABLE ms_cabang ADD(
					mscb_line1 varchar(100) NOT NULL DEFAULT '',
					mscb_line2 varchar(100) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_so_createindex(){					
		$query = "ALTER TABLE tr_so DROP INDEX trso_idx";
		$this->db->simple_query($query);
		
		$query = "CREATE INDEX trso_idx ON tr_so (trso_mscs_no, trso_mscb_no, trso_mssl_no, trso_msus_no)";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_spk_alter5(){
		$query = "ALTER TABLE tr_spk ADD(
					trspk_dtsd_no char(17) NOT NULL DEFAULT '',
					trspk_dtsd_seq int(11) NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fms_cabang_alter6(){
		$query = "ALTER TABLE ms_cabang ADD(
					mscb_footer1 varchar(100) NOT NULL DEFAULT '',
					mscb_footer2 varchar(100) NOT NULL DEFAULT '',
					mscb_footer3 varchar(100) NOT NULL DEFAULT '',
					mscb_footer4 varchar(100) NOT NULL DEFAULT '',
					mscb_footer5 varchar(100) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}


	private function ftr_so_alter13(){
		$query = "ALTER TABLE tr_so ADD(
					trso_tophari int(11) NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function ftr_sales_dlv_alter6(){
		$query = "ALTER TABLE tr_sales_dlv ADD(
					trsd_toptgl date NOT NULL)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_spk_alter6(){
		$query = "ALTER TABLE tr_spk ADD(
					trspk_tophari int(11) NOT NULL DEFAULT 0,
					trspk_toptgl date NOT NULL)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_sales_dlv_alter9(){
		$query = "ALTER TABLE tr_sales_dlv ADD(
					trsd_fakturno varchar(50) NOT NULL DEFAULT '',
					trsd_fakturtgl date NOT NULL)";
					
		if($this->db->simple_query($query)){								
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_auto_set_hpp_createtable(){					
		$query = "DROP TABLE IF EXISTS tr_auto_set_hpp";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_auto_set_hpp (																			
					trash_no int(11) NOT NULL,
					trash_msus_no char(4) NOT NULL DEFAULT '',
					trash_tgl datetime NOT NULL,
					trash_msgd_no char(3) NOT NULL DEFAULT '',
					trash_mspd_no char(9) NOT NULL DEFAULT '',
					trash_hpp double NOT NULL DEFAULT 0,
					trash_mscb_no char(1) NOT NULL DEFAULT '',
					trash_msap_no char(11) NOT NULL DEFAULT '',
					trash_lsupd datetime NOT NULL,
					trash_lsusr char(4) NOT NULL DEFAULT '',
					PRIMARY KEY (trash_no)
				    ) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_auto_set_hpp_createtable(){					
		$query = "DROP TABLE IF EXISTS dt_auto_set_hpp";
		$this->db->simple_query($query);

		$query = "CREATE TABLE dt_auto_set_hpp (																			
					dtash_no int(11) NOT NULL,
					dtash_seq int(11) NOT NULL,
					dtash_trans_jenis char(3) NOT NULL DEFAULT '',
					dtash_trans_no varchar(22) NOT NULL DEFAULT '',
					PRIMARY KEY (dtash_no, dtash_seq)
				    ) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftmp_print_faktur_negara_gabung_createtable(){					
		$query = "DROP TABLE IF EXISTS tmp_faktur_negara_gabung";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tmp_faktur_negara_gabung ("														
					." tfng_no integer NOT NULL AUTO_INCREMENT,"
					." tfng_idlap integer NOT NULL DEFAULT 0,"
					." tfng_mspd_no char(9) NOT NULL,"
					." tfng_qty double NOT NULL DEFAULT 0,"
					." tfng_total_bftax double NOT NULL DEFAULT 0,"
					." tfng_total_tax double NOT NULL DEFAULT 0,"
					." PRIMARY KEY (tfng_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
		
		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftr_spk_alter7(){
		$query = "ALTER TABLE tr_spk"
					." ADD trspk_fakturno varchar(50) NOT NULL, "
					." ADD trspk_fakturtgl date NOT NULL";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fpby_in_dlv_ppnimport_createtable(){
		$query = "DROP TABLE IF EXISTS pby_in_dlv_ppnimport";
		$this->db->simple_query($query);

		$query = "CREATE TABLE pby_in_dlv_ppnimport ("		
					."pbidpi_trid_no varchar(17) NOT NULL,"
					." pbidpi_tgl datetime NOT NULL,"
					." pbidpi_adj double NOT NULL DEFAULT 0,"
					." pbidpi_msjb_no int NOT NULL DEFAULT 0,"
					." pbidpi_jlhbayar double NOT NULL DEFAULT 0,"
					." pbidpi_catatan varchar(250) NOT NULL DEFAULT '',"
					." pbidpi_tglbayar date NOT NULL,"
					." pbidpi_tag varchar(100) NOT NULL DEFAULT '',"
					." pbidpi_msus_no char(4) NOT NULL DEFAULT '',"
					." pbidpi_mscb_no char(1) NOT NULL DEFAULT '',"
					." PRIMARY KEY (pbidpi_trid_no)"
				    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}			
	}		

	private function ftr_in_dlv_alter7(){
		$query = "ALTER TABLE tr_in_dlv ADD ("					
					." trid_totalppnimport double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_sales_inquery_alter7(){
		$query = "ALTER TABLE tr_sales_inquery ADD ("					
					." trsi_tglexp date NOT NULL,"
					." trsi_alamatkirim varchar(250) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_giro_masuk_createtable(){					
		$query = "DROP TABLE IF EXISTS tr_giro_masuk";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_giro_masuk (																			
					trgm_no varchar(23) NOT NULL,					
					trgm_mscb_no char(1) NOT NULL DEFAULT '',
					trgm_mscs_no char(6) NOT NULL DEFAULT '',
					trgm_tglterima datetime NOT NULL,
					trgm_tgljthtempo date NOT NULL,
					trgm_msap_no_bgm char(11) NOT NULL DEFAULT '',
					trgm_msap_no_slh char(11) NOT NULL DEFAULT '',
					trgm_tglcair date NOT NULL,
					trgm_total double NOT NULL DEFAULT 0,
					trgm_used double NOT NULL DEFAULT 0,
					trgm_catatan varchar(250) NOT NULL DEFAULT '',
					trgm_msus_no char(4) NOT NULL DEFAULT '',
					trgm_tag varchar(100) NOT NULL DEFAULT '',
					trgm_cekint int(11) NOT NULL DEFAULT 0,
					trgm_void tinyint NOT NULL DEFAULT 0,
					trgm_nprint int(11) NOT NULL DEFAULT 0,
					trgm_lsupd datetime NOT NULL,
					trgm_lsusr char(4) NOT NULL,
					PRIMARY KEY (trgm_no)
				    ) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if($this->db->simple_query($query)){
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fused_giro_masuk_createtable(){
		$query = "DROP TABLE IF EXISTS used_giro_masuk";
		$this->db->simple_query($query);

		$query = "CREATE TABLE used_giro_masuk (
					usgm_autono int(11) NOT NULL AUTO_INCREMENT,					
					usgm_no varchar(23) NOT NULL DEFAULT '',					
					usgm_refno varchar(17) NOT NULL DEFAULT '',
					usgm_refjenis char(1) NOT NULL DEFAULT '',
					usgm_refseq int(11) NOT NULL DEFAULT 0,
					usgm_total double NOT NULL DEFAULT 0,
				  PRIMARY KEY (usgm_autono)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}
	}

	public function fpby_so_alter6(){
		$query = "ALTER TABLE pby_so"
					." CHANGE pbso_potongdp pbso_jenis char(1) NOT NULL DEFAULT ''";

		if($this->db->simple_query($query)){
			$query = "UPDATE pby_so SET pbso_jenis = 'D' WHERE pbso_jenis = 'Y'";
			$this->db->simple_query($query);
			
			$query = "UPDATE pby_so SET pbso_jenis = 'O' WHERE pbso_jenis = 'N'";
			$this->db->simple_query($query);			
			return 1;
		}
		else{
			return 0;
		}
	}

	public function fpby_so_alter7(){
		$query = "ALTER TABLE pby_so ADD ("					
					." pbso_refnopbyr varchar(23) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_transfer_masuk_createtable(){
		$query = "DROP TABLE IF EXISTS tr_transfer_masuk";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_transfer_masuk (
				    trfm_no char(12) NOT NULL DEFAULT '',	
				    trfm_mscb_no char(1) NOT NULL DEFAULT '',
					trfm_mscs_no char(6) NOT NULL DEFAULT '',
					trfm_tgltransfer datetime NOT NULL,					
					trfm_msap_no_tfm char(11) NOT NULL DEFAULT '',					
					trfm_msap_no_slh char(11) NOT NULL DEFAULT '',
					trfm_total double NOT NULL DEFAULT 0,
					trfm_used double NOT NULL DEFAULT 0,
					trfm_catatan varchar(250) NOT NULL DEFAULT '',
					trfm_msus_no char(4) NOT NULL DEFAULT '',
					trfm_tag varchar(100) NOT NULL DEFAULT '',
					trfm_cekint int NOT NULL DEFAULT 0,
					trfm_void tinyint NOT NULL DEFAULT 0,
					trfm_nprint int NOT NULL DEFAULT 0,
					trfm_lsupd datetime NOT NULL,
					trfm_lsusr char(4) NOT NULL DEFAULT '',
				    PRIMARY KEY (trfm_no)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}	
	}

	private function fused_transfer_masuk_createtable(){
		$query = "DROP TABLE IF EXISTS used_transfer_masuk";
		$this->db->simple_query($query);

		$query = "CREATE TABLE used_transfer_masuk (
					usfm_autono int(11) NOT NULL AUTO_INCREMENT,					
					usfm_no char(12) NOT NULL DEFAULT '',
					usfm_refno varchar(17) NOT NULL DEFAULT '',
					usfm_refjenis char(1) NOT NULL DEFAULT '',
					usfm_refseq int(11) NOT NULL DEFAULT 0,
					usfm_total double NOT NULL DEFAULT 0,
				  PRIMARY KEY (usfm_autono)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}
	}	


	private function fms_costcenter_createtable(){
		$query = "DROP TABLE IF EXISTS ms_costcenter";
		$this->db->simple_query($query);

		$query = "CREATE TABLE ms_costcenter (				
					mscc_no varchar(4) NOT NULL,
					mscc_nm varchar(100) NOT NULL DEFAULT '',
					mscc_catatan varchar(250) NOT NULL DEFAULT '',
					mscc_listmscb varchar(250) NOT NULL DEFAULT '',
					mscc_aktif tinyint NOT NULL DEFAULT 1,
					mscc_lsupd datetime NOT NULL,
					mscc_lsusr char(4) NOT NULL DEFAULT '',
					PRIMARY KEY (mscc_no)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}
	}

	public function fdt_jurnal_alter5(){
		$query = "ALTER TABLE dt_jurnal ADD ("					
					." dtju_mscc_no varchar(4) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	public function fpby_spk_alter2(){
		$query = "ALTER TABLE pby_spk ADD (
					pbspk_jenis char(1) NOT NULL DEFAULT '',
					pbspk_refnopbyr char(23) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			$query = "UPDATE pby_spk SET pbspk_jenis = 'O'";
			$this->db->simple_query($query);
			return 1;
		}else{
			return 0;
		}
	}

	public function fpby_po_alter7(){
		$query = "ALTER TABLE pby_po"
					." CHANGE pbpo_potongdp pbpo_jenis char(1) NOT NULL DEFAULT ''";

		if($this->db->simple_query($query)){
			$query = "UPDATE pby_po SET pbpo_jenis = 'D' WHERE pbpo_jenis = 'Y'";
			$this->db->simple_query($query);
			
			$query = "UPDATE pby_po SET pbpo_jenis = 'O' WHERE pbpo_jenis = 'N'";
			$this->db->simple_query($query);			
			return 1;
		}
		else{
			return 0;
		}
	}

	public function fpby_po_alter8(){
		$query = "ALTER TABLE pby_po ADD ("					
					." pbpo_refnopbyr varchar(23) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){			
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_transfer_keluar_createtable(){
		$query = "DROP TABLE IF EXISTS tr_transfer_keluar";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_transfer_keluar (
				    trfk_no char(12) NOT NULL DEFAULT '',	
				    trfk_mscb_no char(1) NOT NULL DEFAULT '',
					trfk_mssp_no char(6) NOT NULL DEFAULT '',
					trfk_curr varchar(10) NOT NULL DEFAULT '',
					trfk_kurs double NOT NULL DEFAULT 0,
					trfk_tgltransfer datetime NOT NULL,					
					trfk_msap_no_tfk char(11) NOT NULL DEFAULT '',					
					trfk_msap_no_slh char(11) NOT NULL DEFAULT '',
					trfk_total double NOT NULL DEFAULT 0,
					trfk_used double NOT NULL DEFAULT 0,
					trfk_catatan varchar(250) NOT NULL DEFAULT '',
					trfk_msus_no char(4) NOT NULL DEFAULT '',
					trfk_tag varchar(100) NOT NULL DEFAULT '',
					trfk_cekint int NOT NULL DEFAULT 0,
					trfk_void tinyint NOT NULL DEFAULT 0,
					trfk_nprint int NOT NULL DEFAULT 0,
					trfk_lsupd datetime NOT NULL,
					trfk_lsusr char(4) NOT NULL DEFAULT '',
				    PRIMARY KEY (trfk_no)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}	
	}

	private function fused_transfer_keluar_createtable(){
		$query = "DROP TABLE IF EXISTS used_transfer_keluar";
		$this->db->simple_query($query);

		$query = "CREATE TABLE used_transfer_keluar (
					usfk_autono int(11) NOT NULL AUTO_INCREMENT,					
					usfk_no char(12) NOT NULL DEFAULT '',
					usfk_refno varchar(17) NOT NULL DEFAULT '',					
					usfk_refseq int(11) NOT NULL DEFAULT 0,
					usfk_total double NOT NULL DEFAULT 0,
				  PRIMARY KEY (usfk_autono)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}
	}	

	private function ftr_giro_keluar_createtable(){
		$query = "DROP TABLE IF EXISTS tr_giro_keluar";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tr_giro_keluar (
				    trgk_no char(23) NOT NULL DEFAULT '',	
				    trgk_mscb_no char(1) NOT NULL DEFAULT '',
					trgk_mssp_no char(6) NOT NULL DEFAULT '',					
					trgk_tglbayar datetime NOT NULL,					
					trgk_msap_no_bgk char(11) NOT NULL DEFAULT '',					
					trgk_msap_no_slh char(11) NOT NULL DEFAULT '',
					trgk_total double NOT NULL DEFAULT 0,
					trgk_used double NOT NULL DEFAULT 0,
					trgk_tgljthtempo date NOT NULL,
					trgk_tglcair date NOT NULL,
					trgk_catatan varchar(250) NOT NULL DEFAULT '',
					trgk_msus_no char(4) NOT NULL DEFAULT '',
					trgk_tag varchar(100) NOT NULL DEFAULT '',
					trgk_cekint int NOT NULL DEFAULT 0,
					trgk_void tinyint NOT NULL DEFAULT 0,
					trgk_nprint int NOT NULL DEFAULT 0,
					trgk_lsupd datetime NOT NULL,
					trgk_lsusr char(4) NOT NULL DEFAULT '',
				    PRIMARY KEY (trgk_no)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}	
	}

	private function fused_giro_keluar_createtable(){
		$query = "DROP TABLE IF EXISTS used_giro_keluar";
		$this->db->simple_query($query);

		$query = "CREATE TABLE used_giro_keluar (
					usgk_autono int(11) NOT NULL AUTO_INCREMENT,					
					usgk_no char(23) NOT NULL DEFAULT '',
					usgk_refno varchar(17) NOT NULL DEFAULT '',					
					usgk_refseq int(11) NOT NULL DEFAULT 0,
					usgk_total double NOT NULL DEFAULT 0,
				  PRIMARY KEY (usgk_autono)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}
	}	

	public function fhis_accper_alter1(){
		$query = "ALTER TABLE his_accper ADD (					
					hsap_mscb_no char(1) NOT NULL,
					hsap_mscc_no varchar(4) NOT NULL )";
					
		if($this->db->simple_query($query)){
			$query = "ALTER TABLE his_accper DROP PRIMARY KEY, ADD PRIMARY KEY(hsap_periode,hsap_no, hsap_mscb_no, hsap_mscc_no)";			
			$this->db->simple_query($query);
			return 1;
		}else{
			return 0;
		}
	}

	public function ftemp_his_accper_createtable(){
		$query = "DROP TABLE IF EXISTS temp_his_accper";
		$this->db->simple_query($query);

		$query = "CREATE TABLE temp_his_accper (
					hsap_periode char(6) NOT NULL DEFAULT '',
					hsap_no char(11) NOT NULL DEFAULT '',
					hsap_nm varchar(100) NOT NULL DEFAULT '',
					hsap_debet double NOT NULL DEFAULT 0,
					hsap_kredit double NOT NULL DEFAULT 0,
					hsap_listmscb varchar(250) NOT NULL DEFAULT '',
					hsap_aktif tinyint(4) NOT NULL DEFAULT 0,
					hsap_mscb_no char(1) NOT NULL DEFAULT '',
					hsap_mscc_no varchar(4) NOT NULL DEFAULT ''				  
				) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}
	}

	private function fhis_costcenter_createtable(){
		$query = "DROP TABLE IF EXISTS his_costcenter";
		$this->db->simple_query($query);

		$query = "CREATE TABLE his_costcenter (			
					hscc_periode char(6) NOT NULL,	
					hscc_no varchar(4) NOT NULL,
					hscc_nm varchar(100) NOT NULL DEFAULT '',
					hscc_catatan varchar(250) NOT NULL DEFAULT '',
					hscc_listmscb varchar(250) NOT NULL DEFAULT '',
					hscc_aktif tinyint NOT NULL DEFAULT 1,
					hscc_lsupd datetime NOT NULL,
					hscc_lsusr char(4) NOT NULL DEFAULT '',
					PRIMARY KEY (hscc_periode, hscc_no)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}
	}

	private function ftr_spk_alter8(){
		$query = "ALTER TABLE tr_spk ADD ("
					." trspk_finishusr char(4) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){							
			return 1;
		}
		else{
			return 0;
		}			
	}	

	private function ftr_spk_visit_alter3(){
		$query = "ALTER TABLE tr_spk_visit ADD ("
					." trsv_cnfusr char(4) NOT NULL DEFAULT '')";
					
		if($this->db->simple_query($query)){							
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function flog_set_hpp_1907_createtable(){
		$query = "DROP TABLE IF EXISTS log_set_hpp_1907";
		$this->db->simple_query($query);

		$query = "CREATE TABLE log_set_hpp_1907 (		
					lgsh_no int(11) NOT NULL AUTO_INCREMENT,	
					lgsh_mspd_no char(9) NOT NULL DEFAULT '',
					lgsh_hpp double NOT NULL DEFAULT 0,
					PRIMARY KEY (lgsh_no)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}
	}

	private function fdt_in_dlv_alter5(){
		$query = "ALTER TABLE dt_in_dlv ADD (
					dtid_bftax double NOT NULL DEFAULT 0)";
					
		if($this->db->simple_query($query)){										
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_in_dlv_alter6(){
		$query = "UPDATE dt_in_dlv 
						LEFT JOIN tr_in_dlv ON trid_no = dtid_no
						SET dtid_bftax = ROUND(dtid_bftaxcurr * trid_kurs, 4)";
					
		if($this->db->simple_query($query)){										
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_in_dlv_alter7(){
		$query = "UPDATE dt_in_dlv 
						LEFT JOIN tr_in_dlv ON trid_no = dtid_no
						SET dtid_nett = ROUND(dtid_nettcurr * trid_kurs, 4)";
					
		if($this->db->simple_query($query)){										
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function fdt_in_dlv_alter8(){
		$query = "UPDATE dt_in_dlv 						
						SET dtid_hpp = ROUND(dtid_bftax + dtid_biayaperunit, 4)";
					
		if($this->db->simple_query($query)){										
			return 1;
		}
		else{
			return 0;
		}			
	}

	private function ftmp_lap_trans_jurnal_hpp_createtable(){
		$query = "DROP TABLE IF EXISTS tmp_lap_trans_jurnal_hpp";
		$this->db->simple_query($query);

		$query = "CREATE TABLE tmp_lap_trans_jurnal_hpp (
					tmptjh_no INT(11) NOT NULL AUTO_INCREMENT, 
					tmptjh_idlap INT(11) NOT NULL DEFAULT 0, 
					tmptjh_trju_no CHAR(15) NOT NULL DEFAULT '', 
					tmptjh_trju_tgl DATETIME NOT NULL, 
					tmptjh_trans_no VARCHAR(25) NOT NULL DEFAULT '', 
					tmptjh_trans_tgl DATETIME NOT NULL, 
					tmptjh_trans_jenis CHAR(2) NOT NULL DEFAULT '', 
					tmptjh_mspd_no CHAR(9) NOT NULL DEFAULT '', 
					tmptjh_qty DOUBLE NOT NULL DEFAULT 0, 
					tmptjh_hpp DOUBLE NOT NULL DEFAULT 0, 
					tmptjh_catatan VARCHAR(250) NOT NULL DEFAULT '', 
					PRIMARY KEY (tmptjh_no)
					) ENGINE=InnoDB DEFAULT CHARSET=latin1";

		if ($this->db->simple_query($query)){
			return 1;
		}else{
			return 0;
		}
	}
	
	private function fadd_index1(){
		$query = "create index idx_trju_reftipe
		on tr_jurnal(trju_reftipe)";
		$this->db->simple_query($query);

		$query = "create index idx_trju_refno
		on tr_jurnal(trju_refno)";
		$this->db->simple_query($query);

		$query = "create index idx_pbso_refno
		on pby_so(pbso_refno)";
					
		if($this->db->simple_query($query)){										
			return 1;
		}
		else{
			return 0;
		}			
	}

	public function fauto_revisi($no_ver){		
		$ver = $no_ver;

		if ($ver == 0) {				
			if($this->fms_cabang_createtable())
			if($this->fms_usergroup_createtable())
			if($this->fms_user_createtable())
			if($this->fms_sales_createtable())
			if($this->fms_customer_createtable())
			if($this->fms_famili_createtable())
			if($this->fms_model_createtable())
			if($this->fms_merk_createtable())
			if($this->fms_produk_createtable())
			if($this->fms_gudang_createtable())
			if($this->fms_stok_createtable())
			if($this->fms_kategori_createtable())
				$ver += 1;			
		}

		if ($ver == 1) {			
			if($this->fms_cabang_initdefault())
			if($this->fms_usergroup_initdefault())
			if($this->fms_user_initdefault())			
				$ver += 1;									
		}

		if ($ver == 2) {			
			if($this->fms_supplier_createtable())			
				$ver += 1;									
		}

		if ($ver == 3) {			
			if($this->ftr_sales_inquery_createtable())			
				$ver += 1;									
		}

		if ($ver == 4) {			
			if($this->fdt_sales_inquery_createtable())			
				$ver += 1;									
		}
		if ($ver == 5) {			
			if($this->fms_customer_alter1())			
				$ver += 1;									
		}

		if ($ver == 6) {			
			if($this->fms_supplier_alter1())			
				$ver += 1;									
		}

		if ($ver == 7) {			
			//if($this->fdt_purcreq_createtable())			
			 	$ver += 1;									
		}

		if ($ver == 8) {			
			//if($this->ftr_purcreq_createtable())				
				$ver += 1;									
		}		

		if ($ver == 9) {			
			if($this->ftr_so_createtable())
			if($this->ftop_so_createtable())
			//if($this->fdt_so_createtable())
				$ver += 1;									
		}

		if ($ver == 10) {			
			if($this->fdt_so_createtable())
			if($this->ftr_sales_dlv_createtable())
			if($this->fdt_sales_dlv_createtable())
				$ver += 1;									
		}

		if ($ver == 11) {		
			if($this->fms_cabang_alter1())
				$ver += 1;									
		}

		if ($ver == 12) {			
			if($this->fms_usergroup_alter1())
				$ver += 1;									
		}		

		if ($ver == 13) {
			if($this->fms_user_alter1())
				$ver += 1;									
		}		

		if ($ver == 14) {
			if($this->fms_sales_alter1())
				$ver += 1;									
		}		

		if ($ver == 15) {
			if($this->fms_kategori_alter1())
				$ver += 1;									
		}		

		if ($ver == 16) {
			if($this->fms_famili_alter1())
				$ver += 1;									
		}

		if ($ver == 17) {
			if($this->fms_model_alter1())
				$ver += 1;									
		}		

		if ($ver == 18) {
			if($this->fms_merk_alter1())
				$ver += 1;									
		}		

		if ($ver == 19) {
			if($this->fms_produk_alter1())
				$ver += 1;									
		}		

		if ($ver == 20) {
			if($this->fms_gudang_alter1())
				$ver += 1;									
		}

		if ($ver == 21) {
			if($this->fms_customer_alter2())
				$ver += 1;									
		}		

		if ($ver == 22) {
			if($this->fms_customer_update1())
				$ver += 1;									
		}		

		if ($ver == 23) {
			if($this->fms_sales_alter2())
				$ver += 1;									
		}		

		if ($ver == 24) {
			if($this->fms_jnspbyr_createtable())
				$ver += 1;									
		}

		if ($ver == 25) {
			//if($this->fpby_so_createtable())
				$ver += 1;									
		}		

		if ($ver == 26) {
			if($this->ftr_so_alter1())
				$ver += 1;									
		}							

		if ($ver == 27) {
			if($this->fms_stok_createtable())
				$ver += 1;									
		}							

		if ($ver == 28) {
			if($this->ftr_adjstok_createtable())
			if($this->fdt_adjstok_createtable())
				$ver += 1;									
		}

		if ($ver == 29) {
			if($this->ftr_salesret_createtable())
			if($this->fdt_salesret_createtable())
				$ver += 1;									
		}

		if ($ver == 30) {
			if($this->fms_cabang_alter2())
				$ver += 1;									
		}		

		if ($ver == 31) {
			if($this->fms_gudang_alter2())
				$ver += 1;									
		}

		if ($ver == 32) {
			if($this->fms_sales_alter3())
				$ver += 1;									
		}

		if ($ver == 33) {
			if($this->fms_sales_alter4())
				$ver += 1;									
		}

		if ($ver == 34) {
			if($this->ftr_mutasi_createtable())
			if($this->fdt_mutasi_createtable())
				$ver += 1;									
		}

		if ($ver == 35) {
			if($this->fapv_mutasi_createtable())			
				$ver += 1;									
		}

		if ($ver == 36) {			
			if($this->ftr_purcreq_createtable())			
			if($this->fdt_purcreq_createtable())			
			 	$ver += 1;									
		}

		if ($ver == 37) {			
			if($this->fapv_purcreq_createtable())			
			if($this->fdt_apv_purcreq_createtable())			
			 	$ver += 1;									
		}

		if ($ver == 38) {			
			if($this->ftr_po_createtable())			
			if($this->fdt_po_createtable())			
			 	$ver += 1;									
		}

		if ($ver == 39) {			
			if($this->ftr_purcret_createtable())			
			if($this->fdt_purcret_createtable())			
			 	$ver += 1;									
		}

		if ($ver == 40) {			
			if($this->fms_accgrp_createtable())			
			if($this->fms_accsub_createtable())			
			 	$ver += 1;									
		}

		if ($ver == 41) {			
			if($this->ftr_purcret_alter1())						
			 	$ver += 1;									
		}

		if ($ver == 42) {			
			if($this->ftr_purcret_alter2())						
			 	$ver += 1;									
		}

		if ($ver == 43) {			
			if($this->fdt_purcret_alter1())
			 	$ver += 1;									
		}

		if ($ver == 44) {			
			if($this->fdt_po_alter1())						
			 	$ver += 1;									
		}

		if ($ver == 45) {			
			if($this->ftr_in_dlv_createtable())
			if($this->fdt_in_dlv_createtable())
			 	$ver += 1;									
		}

		if ($ver == 46) {			
			if($this->ftr_purcret_alter3())						
			 	$ver += 1;									
		}

		if ($ver == 47) {
			if($this->ftr_salesret_alter1())						
			 	$ver += 1;									
		}

		if ($ver == 48) {
			if($this->ftr_mutasi_alter1())						
			 	$ver += 1;									
		}

		if ($ver == 49) {
			if($this->ftr_in_dlv_alter1())						
			 	$ver += 1;									
		}

		if ($ver == 50) {
			if($this->ftr_sales_dlv_alter1())						
			 	$ver += 1;									
		}

		if ($ver == 51) {
			if($this->ftr_sales_inquery_alter1())						
			 	$ver += 1;									
		}

		if ($ver == 52) {
			if($this->ftr_so_alter2())						
			 	$ver += 1;									
		}

		if ($ver == 53) {
			//if($this->fpby_so_alter1())						
			 	$ver += 1;									
		}

		if ($ver == 54) {
			if($this->fms_gudang_alter3())						
			 	$ver += 1;									
		}

		if ($ver == 55) {
			if($this->fpby_so_createtable())						
			 	$ver += 1;
		}

		if ($ver == 56) {
			if($this->ftr_sales_dlv_alter2())						
			 	$ver += 1;
		}

		if ($ver == 57) {
			if($this->fdt_sales_dlv_alter1())						
			 	$ver += 1;
		}

		if ($ver == 58) {
			if($this->ftr_so_alter3())
			 	$ver += 1;
		}

		if ($ver == 59) {
			if($this->ftr_so_alter4())
			 	$ver += 1;
		}		

		if ($ver == 60) {
			if($this->ftr_sales_inquery_alter2())
			 	$ver += 1;
		}		

		if ($ver == 61) {
			if($this->ftr_sales_inquery_alter3())
			 	$ver += 1;
		}

		if ($ver == 62) {
			if($this->fdt_so_alter1())
			 	$ver += 1;
		}

		if ($ver == 63) {
			if($this->fdt_sales_inquery_alter1())
			 	$ver += 1;
		}

		if ($ver == 64) {
			if($this->fdt_po_alter2())
			 	$ver += 1;
		}

		if ($ver == 65) {
			if($this->fms_customer_alter3())
			 	$ver += 1;
		}

		if ($ver == 66) {
			if($this->fms_supplier_alter2())
			 	$ver += 1;
		}

		if ($ver == 67) {
			if($this->fdt_in_dlv_alter1())
			 	$ver += 1;
		}		

		if ($ver == 68) {
			if($this->fdt_sales_dlv_alter2())
			 	$ver += 1;
		}		

		if ($ver == 69) {
			if($this->fdt_in_dlv_alter2())
			 	$ver += 1;
		}

		if ($ver == 70) {
			if($this->fpby_po_createtable())
			 	$ver += 1;
		}

		if ($ver == 71) {
			if($this->ftr_po_alter1())
			 	$ver += 1;
		}		

		if ($ver == 72) {
			if($this->ftr_in_dlv_alter2())
			 	$ver += 1;
		}		

		if ($ver == 73) {
			if($this->fms_user_alter2())
			 	$ver += 1;
		}

		if ($ver == 74) {
			if($this->ftr_purcret_alter4())
			 	$ver += 1;
		}				

		if ($ver == 75) {
			if($this->fdt_purcret_alter2())
			 	$ver += 1;
		}				

		if ($ver == 76) {
			if($this->ftr_salesret_alter2())
			 	$ver += 1;
		}

		if ($ver == 77) {
			if($this->fdt_salesret_alter1())
			 	$ver += 1;
		}

		if ($ver == 78) {
			if($this->fpby_so_alter1())
			 	$ver += 1;
		}

		if ($ver == 79) {
			if($this->ftr_purcret_alter5())
			 	$ver += 1;
		}

		if ($ver == 80) {
			if($this->fpby_po_alter1())
			 	$ver += 1;
		}

		if ($ver == 81) {
			if($this->fdt_si_alter1())
			 	$ver += 1;
		}

		if ($ver == 82) {
			if($this->fdt_so_alter2())
			 	$ver += 1;
		}

		if ($ver == 83) {
			if($this->fms_accper_createtable())
			 	$ver += 1;
		}

		if ($ver == 84) {
			if($this->ftr_jurnal_createtable())
			if($this->fdt_jurnal_createtable())
			 	$ver += 1;
		}

		if ($ver == 85) {
			if($this->fms_jnspbyr_alter1())
			 	$ver += 1;
		}

		if ($ver == 86) {
			// if($this->ftr_spk_createtable())
			// if($this->fdt_spk_sp_createtable())
			// if($this->ftr_spk_visit_createtable())
			 	$ver += 1;
		}

		if ($ver == 87) {
			if($this->fms_sales_alter5())
			 	$ver += 1;
		}

		if ($ver == 88) {
			//if($this->ftr_spk_visit_alter1())
			 	$ver += 1;
		}

		if ($ver == 89) {
			//if($this->ftr_spk_visit_alter2())
			 	$ver += 1;
		}

		if ($ver == 90) {
			if($this->ftr_spk_createtable())
			if($this->fdt_spk_sp_createtable())
			//if($this->ftr_spk_visit_createtable())
			 	$ver += 1;
		}

		if ($ver == 91) {
			if($this->fms_customer_alter4())
			 	$ver += 1;
		}

		if ($ver == 92) {
			if($this->fms_cust_dlvyadd_createtable())
			 	$ver += 1;
		}

		if ($ver == 93) {
			if($this->fpby_po_alter2())
			 	$ver += 1;
		}

		if ($ver == 94) {
			if($this->fms_kategori_alter2())
			 	$ver += 1;
		}

		if ($ver == 95) {
			if($this->fms_kategori_alter3())
			 	$ver += 1;
		}

		if ($ver == 96) {
			if($this->fms_produk_alter2())
			 	$ver += 1;
		}

		if ($ver == 97) {
			if($this->ftr_jurnal_alter1())
			 	$ver += 1;
		}

		if ($ver == 98) {
			if($this->fdt_jurnal_alter1())
			 	$ver += 1;
		}

		if ($ver == 99) {
			if($this->ftr_sales_inquery_alter4())
			 	$ver += 1;
		}	

		if ($ver == 100) {
			if($this->ftr_so_alter5())
			 	$ver += 1;
		}

		if ($ver == 101) {
			if($this->ftr_salesret_alter3())
			 	$ver += 1;
		}
		
		if ($ver == 102) {
			if($this->fpby_in_dlv_biayakirim_createtable())
			if($this->fpby_in_dlv_beamasuk_createtable())
			 	$ver += 1;
		}

		if ($ver == 103) {
			if($this->fpby_po_alter3())			
			 	$ver += 1;
		}

		if ($ver == 104) {
			if($this->ftr_spk_visit_createtable())
			 	$ver += 1;
		}

		if ($ver == 105) {
			if($this->fms_paket_prod_createtable())
			if($this->fmd_paket_prod_createtable())
			 	$ver += 1;
		}

		if ($ver == 106) {
			if($this->ftr_purcreq_alter1())			
			 	$ver += 1;
		}

		if ($ver == 107) {
			if($this->fapv_purcreq_alter1())
			 	$ver += 1;
		}

		if ($ver == 108) {
			if($this->ftr_po_alter2())
			 	$ver += 1;
		}

		if ($ver == 109) {
			if($this->ftr_in_dlv_alter3())
			 	$ver += 1;
		}

		if ($ver == 110) {
			if($this->ftr_purcret_alter6())
			 	$ver += 1;
		}

		if ($ver == 111) {
			// if($this->fms_set_acc_createtable())
			 	$ver += 1;
		}

		if ($ver == 112) {
			if($this->ftr_spk_alter1())
			 	$ver += 1;
		}

		if ($ver == 113) {
			if($this->ftr_spk_visit_alter1())
			 	$ver += 1;
		}		

		if ($ver == 114) {
			if($this->ftr_sales_dlv_alter3())
			 	$ver += 1;
		}		

		if ($ver == 115) {
			if($this->ftr_mutasi_alter2())
			 	$ver += 1;
		}		

		if ($ver == 116) {
			if($this->ftr_adjsotk_alter1())
			 	$ver += 1;
		}		

		if ($ver == 117) {
			if($this->fms_set_acc_createtable())
			 	$ver += 1;
		}

		if ($ver == 118) {
			if($this->fpby_so_alter2())
			 	$ver += 1;
		}

		if ($ver == 119) {
			if($this->fpby_po_alter4())
			 	$ver += 1;
		}

		if ($ver == 120) {
			if($this->ftr_jurnal_alter2())
			 	$ver += 1;
		}

		if ($ver == 121) {
			if($this->ftr_tfmgoods_createtable())
			if($this->fdt_tfmgoods_createtable())
			if($this->fdt_tfmgoods_accper_createtable())
			 	$ver += 1;
		}

		if ($ver == 122) {
			if($this->fdt_sales_inquery_alter2())
			 	$ver += 1;
		}

		if ($ver == 123) {
			if($this->fdt_so_alter3())
			 	$ver += 1;
		}

		if ($ver == 124) {
			if($this->ftr_po_alter3())
			 	$ver += 1;
		}

		if ($ver == 125) {
			if($this->ftr_so_alter6())
			 	$ver += 1;
		}

		if ($ver == 126) {
			if($this->fdt_so_alter4())
			 	$ver += 1;
		}

		if ($ver == 127) {
			if($this->fdt_po_alter3())
			 	$ver += 1;
		}

		if ($ver == 128) {
			if($this->fdt_spk_accper_createtable())
			 	$ver += 1;
		}

		if ($ver == 129) {
			if($this->fpby_spk_createtable())
			 $ver += 1;
		}

		if ($ver == 130) {
			if($this->ftr_sales_dlv_alter4())
				$ver += 1;
		}

		if ($ver == 131) {
			if($this->fdt_sales_dlv_alter3())
				$ver += 1;
		}

		if ($ver == 132) {
			if($this->fdt_salesret_alter2())
				$ver += 1;
		}

		if ($ver == 133) {
			if($this->fms_kategori_alter4())
				$ver += 1;
		}

		if ($ver == 134) {
			if($this->fdt_spk_sp_alter1())
				$ver += 1;
		}

		if ($ver == 135) {
			if($this->fdt_purcret_alter7())
				$ver += 1;
		}

		if ($ver == 136) {
			if($this->fdt_adjstok_alter1())
				$ver += 1;
		}

		if ($ver == 137) {
			if($this->ftr_salesret_alter4())
				$ver += 1;
		}

		if ($ver == 138) {
			if($this->fdt_salesret_alter3())
				$ver += 1;
		}

		if ($ver == 139) {
			if($this->ftr_jurnal_alter3())
				$ver += 1;
		}

		if ($ver == 140) {
			if($this->fdt_mutasi_alter1())
				$ver += 1;
		}

		if ($ver == 141) {
			if($this->fdt_sales_dlv_alter4())
				$ver += 1;
		}

		if ($ver == 142) {
			if($this->ftop_po_createtable())
				$ver += 1;
		}

		if ($ver == 143) {
			if($this->fdt_in_dlv_alter3())
				$ver += 1;
		}

		if ($ver == 144) {
			if($this->ftr_jurnal_alter4())
				$ver += 1;
		}

		if ($ver == 145) {
			if($this->fpby_so_alter3())
				$ver += 1;
		}		

		if ($ver == 146) {
			if($this->fms_userlog_createtable())
				$ver += 1;
		}		

		if ($ver == 147) {
			// if($this->ftmp_lap_kartustok())
				$ver += 1;
		}		

		if ($ver == 148) {
			if($this->ftmp_lap_kartustok())
				$ver += 1;
		}		

		if ($ver == 149) {
			if($this->fms_produk_alter3())
				$ver += 1;
		}		

		if ($ver == 150) {
			if($this->fmd_paket_prod_createtable())
				$ver += 1;
		}		

		if ($ver == 151) {
			if($this->fdt_sales_inquery_alter3())
				$ver += 1;
		}		

		if ($ver == 152) {
			if($this->fdt_sales_inquery_alter4())
				$ver += 1;
		}		

		if ($ver == 153) {
			if($this->fdt_so_alter5())
				$ver += 1;
		}		

		if ($ver == 154) {
			if($this->fdt_so_alter6())
				$ver += 1;
		}		

		if ($ver == 155) {
			if($this->fdt_spk_sp_alter2())
				$ver += 1;
		}		

		if ($ver == 156) {
			if($this->fms_tipe_asset_createtable())
			if($this->fms_mtd_penyusutan_createtable())
			if($this->fms_aktiva_tetap_createtable())
			if($this->fmd_aktiva_tetap_createtable())
				$ver += 1;
		}

		if ($ver == 157) {
			if($this->fms_aktiva_tetap_alter1())
				$ver += 1;
		}		

		if ($ver == 158) {
			if($this->fms_aktiva_tetap_alter2())
				$ver += 1;
		}

		if ($ver == 159) {
			if($this->fms_produk_alter4())
				$ver += 1;
		}

		if ($ver == 160) {
			if($this->ftr_adjstok_alter1())
				$ver += 1;
		}

		if ($ver == 161) {
			if($this->fdt_adjstok_alter2())
				$ver += 1;
		}

		if ($ver == 162) {
			if($this->ftr_adjstok_alter2())
				$ver += 1;
		}

		if ($ver == 163) {
			if($this->ftr_jurnal_alter5())
				$ver += 1;
		}

		if ($ver == 164) {
			if($this->ftr_jurnal_alter6())
				$ver += 1;
		}

		if ($ver == 165) {
			if($this->fdt_jurnal_alter2())
				$ver += 1;
		}

		if ($ver == 166) {
			if($this->ftr_sales_inquery_alter5())
				$ver += 1;
		}

		if ($ver == 167) {
			if($this->ftr_sales_inquery_alter6())
				$ver += 1;
		}

		if ($ver == 168) {
			if($this->fdt_sales_inquery_alter5())
				$ver += 1;
		}			

		if ($ver == 169) {
			if($this->ftr_so_alter7())
				$ver += 1;
		}			

		if ($ver == 170) {
			if($this->ftr_so_alter8())
				$ver += 1;
		}				

		if ($ver == 171) {
			if($this->fdt_so_alter7())
				$ver += 1;
		}				

		if ($ver == 172) {
			if($this->ftop_so_alter1())
				$ver += 1;
		}

		if ($ver == 173) {
			if($this->ftr_sales_dlv_alter5())
				$ver += 1;
		}				

		if ($ver == 174) {
			if($this->fdt_sales_dlv_alter5())
				$ver += 1;
		}				

		if ($ver == 175) {
			if($this->fpby_so_alter4())
				$ver += 1;
		}

		if ($ver == 176) {
			if($this->ftr_salesret_alter5())
				$ver += 1;
		}

		if ($ver == 177) {
			if($this->fdt_salesret_alter4())
				$ver += 1;
		}

		if ($ver == 178) {
			if($this->fpby_so_alter5())
				$ver += 1;
		}

		if ($ver == 179) {
			if($this->ftr_salesret_alter6())
				$ver += 1;
		}		

		if ($ver == 180) {
			if($this->ftr_tfmgoods_alter1())
				$ver += 1;
		}		

		if ($ver == 181) {
			if($this->fdt_tfmgoods_alter1())
				$ver += 1;
		}		

		if ($ver == 182) {
			if($this->ftr_tfmgoods_alter2())
				$ver += 1;
		}

		if ($ver == 183) {
			if($this->fdt_tfmgoods_accper_alter1())
				$ver += 1;
		}

		if ($ver == 184) {
			if($this->ftr_mutasi_alter3())
				$ver += 1;
		}

		if ($ver == 185) {
			if($this->ftr_mutasi_alter4())
				$ver += 1;
		}

		if ($ver == 186) {
			if($this->fdt_mutasi_alter2())
				$ver += 1;
		}

		if ($ver == 187) {
			if($this->fapv_mutasi_alter1())
				$ver += 1;
		}

		if ($ver == 188) {
			if($this->ftr_cvtgoods_createtable())
			if($this->fdt_cvtgoods_createtable())
			if($this->fdt_cvtgoods_accper_createtable())
				$ver += 1;
		}		

		if ($ver == 189) {
			if($this->ftr_po_alter4())
				$ver += 1;
		}

		if ($ver == 190) {
			if($this->ftr_po_alter5())
				$ver += 1;
		}

		if ($ver == 191) {
			if($this->fdt_po_alter4())
				$ver += 1;
		}

		if ($ver == 192) {
			if($this->ftop_po_alter1())
				$ver += 1;
		}

		if ($ver == 193) {
			if($this->ftr_spk_alter2())
				$ver += 1;
		}

		if ($ver == 194) {
			if($this->ftr_spk_alter3())
				$ver += 1;
		}

		if ($ver == 195) {
			if($this->fdt_spk_sp_alter3())
				$ver += 1;
		}

		if ($ver == 196) {
			if($this->fdt_spk_accper_alter1())
				$ver += 1;
		}

		if ($ver == 197) {
			if($this->ftr_spk_visit_alter2())
				$ver += 1;
		}

		if ($ver == 198) {
			if($this->fpby_spk_alter1())
				$ver += 1;
		}

		if ($ver == 199) {
			if($this->fdt_purcreq_alter1())
				$ver += 1;
		}

		if ($ver == 200) {
			if($this->fdt_apv_purcreq_alter1())
				$ver += 1;
		}

		if ($ver == 201) {
			if($this->ftr_in_dlv_alter4())
				$ver += 1;
		}

		if ($ver == 202) {
			if($this->fdt_in_dlv_alter4())
				$ver += 1;
		}

		if ($ver == 203) {
			if($this->fpby_in_dlv_biayakirim_alter1())
				$ver += 1;
		}

		if ($ver == 204) {
			if($this->fpby_in_dlv_beamasuk_alter1())
				$ver += 1;
		}

		if ($ver == 205) {
			if($this->fpby_po_alter5())
				$ver += 1;
		}

		if ($ver == 206) {
			if($this->ftr_purcret_alter7())
				$ver += 1;
		}		

		if ($ver == 207) {
			if($this->fdt_purcret_alter8())
				$ver += 1;
		}		

		if ($ver == 208) {
			if($this->ftr_so_alter9())
				$ver += 1;
		}

		if ($ver == 209) {
			if($this->fms_aktiva_tetap_alter3())
				$ver += 1;
		}

		if ($ver == 210) {
			if($this->ftr_adjstok_alter3())
				$ver += 1;
		}			

		if ($ver == 211) {
			if($this->ftr_tfmgoods_alter3())
				$ver += 1;
		}

		if ($ver == 212) {
			if($this->ftr_mutasi_alter5())
				$ver += 1;
		}

		if ($ver == 213) {
			if($this->ftr_so_alter10())
				$ver += 1;
		}

		if ($ver == 214) {
			if($this->ftr_po_alter6())
				$ver += 1;
		}

		if ($ver == 215) {
			if($this->ftr_spk_alter4())
				$ver += 1;
		}

		if ($ver == 216) {
			if($this->fms_customer_alter5())
				$ver += 1;
		}			

		if ($ver == 217) {
			if($this->ftr_jurnal_alter7())
				$ver += 1;
		}			

		if ($ver == 218) {
			if($this->fms_aktiva_tetap_alter4())
				$ver += 1;
		}

		if ($ver == 219) {
			if($this->ftr_cvtgoods_alter1())
				$ver += 1;
		}

		if ($ver == 220) {
			if($this->ftr_adjstok_alter4())
				$ver += 1;
		}

		if ($ver == 221) {
			if($this->ftr_history_hpp_createtable())
				$ver += 1;
		}

		if ($ver == 222) {
			if($this->ftr_his_hpp_createtable())
				$ver += 1;
		}

		if ($ver == 223) {
			if($this->fpby_in_dlv_ppnshipping_createtable())
				$ver += 1;
		}

		if ($ver == 224) {
			if($this->ftr_in_dlv_alter5())
				$ver += 1;
		}				

		if ($ver == 225) {
			if($this->fpby_in_dlv_pph22_createtable())
				$ver += 1;
		}		

		if ($ver == 226) {
			if($this->ftr_in_dlv_alter6())
				$ver += 1;
		}

		if ($ver == 227) {
			if($this->fdt_jurnal_alter3())
				$ver += 1;
		}

		if ($ver == 228) {
			if($this->fms_accgrp_alter1())
				$ver += 1;
		}

		if ($ver == 229) {
			if($this->fms_accgrp_alter2())
				$ver += 1;
		}

		if($ver == 230){
			if($this->ftr_cvtgoods_alter2())
				$ver += 1;
		}

		if($ver == 231){
			if($this->fpby_po_alter6())
				$ver += 1;
		}

		if($ver == 232){
			if($this->fset_lst_jurnal_closingdef())			
				$ver += 1;
		}		

		if($ver == 233){
			if($this->fhis_accgrp_createtable())
			if($this->fhis_accsub_createtable())
			if($this->fhis_accper_createtable())
				$ver += 1;
		}		

		if($ver == 234){
			if($this->ftr_jurnal_alter8())			
				$ver += 1;
		}

		if($ver == 235){
			if($this->ftop_spk_createtable())			
				$ver += 1;
		}

		if($ver == 236){
			if($this->fms_kategori_alter5())
				$ver += 1;
		}

		if($ver == 237){
			if($this->ftmp_lap_mutasi_hutang_cust_createtable())
				$ver += 1;
		}

		if($ver == 238){
			// if($this->ftmp_lap_top_cust_createtable())
				$ver += 1;
		}		

		if($ver == 239){
			if($this->ftmp_lap_top_cust_createtable())
				$ver += 1;
		}

		if($ver == 240){
			if($this->ftmp_sales_dlv_hpp_createtable())
				$ver += 1;
		}

		if($ver == 241){
			if($this->fdt_sales_dlv_alter6())
				$ver += 1;
		}

		if($ver == 242){
			if($this->fdt_sales_dlv_alter7())
				$ver += 1;
		}

		if($ver == 243){
			if($this->fms_stok_alter1())
				$ver += 1;
		}

		if($ver == 244){
			if($this->fms_produk_alter5())
				$ver += 1;
		}

		if($ver == 245){
			if($this->ftr_so_alter11())
				$ver += 1;
		}

		if($ver == 246){
			if($this->ftmp_lap_spk_createtable())
				$ver += 1;
		}

		if($ver == 247){
			if($this->ftr_so_alter12())
				$ver += 1;
		}

		if($ver == 248){
			if($this->ftmp_lap_kartustok_alter1())
				$ver += 1;
		}

		if($ver == 249){
			if($this->ftr_po_alter7())
				$ver += 1;
		}

		if($ver == 250){
			if($this->ftop_po_alter2())
				$ver += 1;
		}

		if($ver == 251){
			if($this->ftop_so_alter2())
				$ver += 1;
		}

		if($ver == 252){
			if($this->ftop_spk_alter1())
				$ver += 1;
		}

		if($ver == 253){
			if($this->fdt_sales_dlv_alter8())
				$ver += 1;
		}

		if($ver == 254){
			if($this->ftmp_so_top_dlv_createtable())
				$ver += 1;
		}

		if($ver == 255){
			if($this->ftmp_so_top_dlv_alter1())
				$ver += 1;
		}

		if($ver == 256){
			if($this->ftmp_lap_spk_alter1())
				$ver += 1;
		}

		if($ver == 257){
			if($this->fdt_jurnal_alter4())
				$ver += 1;
		}

		if($ver == 258){
			if($this->fset_lst_closing_init())
				$ver += 1;
		}

		if($ver == 259){
			if($this->fms_cabang_alter3())
				$ver += 1;
		}

		if($ver == 260){
			if($this->fdt_mutasi_alter3())
				$ver += 1;
		}

		if($ver == 261){
			if($this->fdt_mutasi_createindex())
				$ver += 1;
		}

		if($ver == 262){
			if($this->fdt_so_createindex())
				$ver += 1;
		}

		if($ver == 263){
			if($this->fdt_po_createindex())
				$ver += 1;
		}

		if($ver == 264){
			if($this->fdt_sales_dlv_createindex())
				$ver += 1;
		}

		if($ver == 265){
			if($this->fdt_adjstok_createindex())
				$ver += 1;
		}

		if($ver == 266){
			if($this->fdt_salesret_createindex())
				$ver += 1;
		}

		if($ver == 267){
			if($this->fdt_purcret_createindex())
				$ver += 1;
		}

		if($ver == 268){
			if($this->fdt_jurnal_createindex())
				$ver += 1;
		}

		if($ver == 269){
			if($this->fdt_in_dlv_createindex())
				$ver += 1;
		}

		if($ver == 270){
			if($this->fdt_tfmgoods_createindex())
				$ver += 1;
		}

		if($ver == 271){
			if($this->fdt_cvtgoods_createindex())
				$ver += 1;
		}					

		if($ver == 272){
			if($this->fms_cabang_alter4())
				$ver += 1;
		}

		if($ver == 273){
			if($this->fms_cabang_alter5())
				$ver += 1;
		}					

		if($ver == 274){
			if($this->ftr_so_createindex())
				$ver += 1;
		}

		if($ver == 275){
			if($this->ftr_spk_alter5())
				$ver += 1;
		}			

		if($ver == 276){
			if($this->fms_cabang_alter6())
				$ver += 1;
		}				

		if($ver == 277){
			if($this->ftr_so_alter13())
				$ver += 1;
		}

		if($ver == 278){
			if($this->ftr_sales_dlv_alter6())
				$ver += 1;
		}				

		if($ver == 279){
			if($this->ftr_spk_alter6())
				$ver += 1;
		}

		if($ver == 280){
			if($this->fdt_sales_dlv_alter9())
				$ver += 1;
		}

		if($ver == 281){
			if($this->ftr_auto_set_hpp_createtable())
			if($this->fdt_auto_set_hpp_createtable())
				$ver += 1;
		}
			
		if($ver == 282){
			//if($this->ftmp_print_faktur_negara_gabung_createtable())
				$ver += 1;
		}

		if($ver == 283){
			if($this->ftr_spk_alter7())
				$ver += 1;
		}

		if($ver == 284){
			if($this->fpby_in_dlv_ppnimport_createtable())
				$ver += 1;
		}

		if($ver == 285){
			if($this->ftr_in_dlv_alter7())
				$ver += 1;
		}

		if($ver == 286){
			if($this->ftr_sales_inquery_alter7())
				$ver += 1;
		}		

		if($ver == 287){
			if($this->ftr_giro_masuk_createtable())
			if($this->fused_giro_masuk_createtable())
				$ver += 1;
		}		

		if($ver == 288){
			if($this->fpby_so_alter6())			
				$ver += 1;
		}

		if($ver == 289){
			if($this->fpby_so_alter7())			
				$ver += 1;
		}						

		if($ver == 290){
			if($this->ftr_transfer_masuk_createtable())
			if($this->fused_transfer_masuk_createtable())
				$ver += 1;			
		}							

		if($ver == 291){
			if($this->fms_costcenter_createtable())			
				$ver += 1;			
		}				

		if($ver == 292){
			if($this->fdt_jurnal_alter5())			
				$ver += 1;			
		}

		if($ver == 293){
			if($this->fpby_spk_alter2())			
				$ver += 1;			
		}		

		if($ver == 294){
			if($this->fpby_po_alter7())			
				$ver += 1;			
		}				

		if($ver == 295){
			if($this->fpby_po_alter8())			
				$ver += 1;			
		}

		if($ver == 296){
			if($this->ftr_transfer_keluar_createtable())			
			if($this->fused_transfer_keluar_createtable())			
				$ver += 1;			
		}						

		if($ver == 297){
			if($this->ftr_giro_keluar_createtable())			
			if($this->fused_giro_keluar_createtable())			
				$ver += 1;			
		}								

		if($ver == 298){
			if($this->fhis_accper_alter1())						
				$ver += 1;			
		}							

		if($ver == 299){
			if($this->ftemp_his_accper_createtable())						
				$ver += 1;			
		}												

		if($ver == 300){
			if($this->fhis_costcenter_createtable())
				$ver += 1;			
		}				

		if($ver == 301){
			if($this->ftr_spk_alter8())
				$ver += 1;			
		}

		if($ver == 302){
			if($this->ftr_spk_visit_alter3())
				$ver += 1;			
		}	

		if($ver == 303){
			//if($this->flog_set_hpp_1907_createtable())
				$ver += 1;			
		}

		if($ver == 304){
			//if($this->fdt_in_dlv_alter5()) //
				$ver += 1;			
		}					

		if($ver == 305){
			//if($this->fdt_in_dlv_alter6()) //
				$ver += 1;			
		}					

		if($ver == 306){
			//if($this->fdt_in_dlv_alter7()) // 
				$ver += 1;			
		}					

		if($ver == 307){
			//if($this->fdt_in_dlv_alter8()) //
				$ver += 1;			
		}	

		if($ver == 308){
			if($this->ftmp_lap_trans_jurnal_hpp_createtable())
				$ver += 1;			
		}
		
		if($ver == 309){
			if($this->ftmp_print_faktur_negara_gabung_createtable())
				$ver += 1;
		}

		if($ver == 310){
			if($this->fadd_index1())
				$ver += 1;
		}

		if($ver == 311){
			if($this->fms_cust_npwpdd_createtable())
				$ver += 1;
		}

		if($ver == 312){
			if($this->fms_cust_npwpdd_defalamatnpwp())
				$ver += 1;
		}

		if($ver == 313){
			if($this->ftr_so_alter14())
				$ver += 1;
		}

		if($ver == 314){
			if($this->ftr_so_defalamatnpwp())
				$ver += 1;
		}

		if($ver == 315){
			if($this->ftr_spk_alter9())
				$ver += 1;
		}

		if($ver == 316){
			if($this->ftr_in_dlv_alter8())
				$ver += 1;
		}

		if($ver == 317){
			if($this->ftr_mutasi_alter6())
				$ver += 1;
		}		

		$this->fset_norevisi($ver);	
		return $ver;
	}

}
