<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_transfer_masuk extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('setting/m_user_log');		
	}

	public function get_transfer_masuk_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trfm_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('trfm.*, msap1.msap_nm as msap_nm_tfm, msap2.msap_nm as msap_nm_slh, msus_nm, mscs_nm');
		$this->db->from('tr_transfer_masuk trfm');
		$this->db->join('ms_accper msap1','msap1.msap_no = trfm_msap_no_tfm', 'left');				
		$this->db->join('ms_accper msap2','msap2.msap_no = trfm_msap_no_slh', 'left');				
		$this->db->join('ms_user', 'msus_no = trfm_msus_no', 'left');
		$this->db->join('ms_customer', 'mscs_no = trfm_mscs_no', 'left');		
		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}				
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_transfer_masuk($trfm_no){		
		$data = array();
		
		$this->db->select('tr_transfer_masuk.*, msap1.msap_nm as msap_nm_tfm, msap2.msap_nm as msap_nm_slh, msus_no, msus_nm, mscs_nm');
		$this->db->from('tr_transfer_masuk');		
		$this->db->join('ms_user','msus_no = trfm_msus_no', 'left');				
		$this->db->join('ms_accper msap1','msap1.msap_no = trfm_msap_no_tfm', 'left');				
		$this->db->join('ms_accper msap2','msap2.msap_no = trfm_msap_no_slh', 'left');				
		$this->db->join('ms_customer','mscs_no = trfm_mscs_no', 'left');				
		$this->db->where('trfm_no',$trfm_no);		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();			
			$data['header'] = $result[0];
		}					

		return $data;	
	}

	public function transfer_masuk_kode_auto($kode_depan){
		$this->db->select_max("trfm_no");
		$this->db->like("trfm_no", $kode_depan, "after");
		$query = $this->db->get("tr_transfer_masuk");
		if ($query->num_rows() == 0){
			return $kode_depan. "0001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trfm_no'];
			$nomor = ((int) substr($kode, 8)) + 1;			
			return $kode_depan. sprintf("%'.04d", $nomor);
		}
	}

	public function cek_exists_cekint($trfm_no, $trfm_cekint){		
		$query = $this->db->get_where('tr_transfer_masuk', array('trfm_no' => $trfm_no, 'trfm_cekint' => $trfm_cekint));				 
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_transfer_masuk_cekint($trfm_no){				
		$this->db->where('trfm_no', $trfm_no);
		$this->db->update('tr_transfer_masuk', array('trfm_cekint' => rand(0,10000)));
	}

	public function transfer_masuk_simpan($data){
		try{						
			if($data['action'] == 'NEW' || $data['action'] == 'EDIT'){								

				if($data['action'] == 'NEW'){
					// Insert data
					$this->db->insert('tr_transfer_masuk',$data['tr']);
				}
			
				if($data['action'] == 'EDIT'){								
					// Update data trfm
					$this->db->where('trfm_no', $data['tr']['trfm_no']);
					$this->db->update('tr_transfer_masuk', $data['tr']);								

					// void pembayaran pbso
					$this->void_pbso_bypbso_refnopbyr($data['tr']['trfm_no']);

					// void pembayaran pbspk
					$this->void_pbspk_bypbspk_refnopbyr($data['tr']['trfm_no']);

					// Delete data used transfer masuk 
					$this->db->delete('used_transfer_masuk', array('usfm_no' => $data['tr']['trfm_no']));
				}							

				// SIMPAN PEMBAYARAN SO -------------------------------------------------------------------------
				if(isset($data['pbso'])){
					foreach ($data['pbso'] as $key => $value) {					
						// set trsd_cekint
						$this->m_sales_delivery->set_sales_delivery_cekint($data['pbso'][$key]['pbso_refno']);

						// insert pby_so
						$this->db->insert('pby_so', $data['pbso'][$key]);	

						// update trsd_terbayar
						$this->m_so_payment->update_trsd_terbayar($data['pbso'][$key]['pbso_refno']);

						// update trso_terbayar
						$this->m_so_payment->recalc_trso_terbayar(substr($data['pbso'][$key]['pbso_no'], 0, 12));

						// simpan jurnal pbso
						$this->jurnal_simpan_pbyr_so($data['pbso'][$key]['pbso_no'], $data['pbso'][$key]['pbso_tglterima']);

						// set data used_transfer_masuk
						$data_usfm['usfm_no'] = $data['pbso'][$key]['pbso_refnopbyr'];					
						$data_usfm['usfm_refno'] = $data['pbso'][$key]['pbso_no'];
						$data_usfm['usfm_refjenis'] = 'S';
						$data_usfm['usfm_refseq'] = $data['pbso'][$key]['pbso_seq'];
						$data_usfm['usfm_total'] = $data['pbso'][$key]['pbso_jlhbayar'];

						// insert used_transfer_masuk
						$this->db->insert('used_transfer_masuk', $data_usfm);															
					}
				}

				// SIMPAN PEMBAYARAN SPK -------------------------------------------------------------------------
				if(isset($data['pbspk'])){
					foreach ($data['pbspk'] as $key => $value) {					
						// set trspk_cekint
						$this->m_spk->set_spk_cekint(substr($data['pbspk'][$key]['pbspk_no'],0,12));

						// insert pby_spk
						$this->db->insert('pby_spk', $data['pbspk'][$key]);							

						// simpan jurnal pbspk
						$this->jurnal_simpan_pbyr_spk($data['pbspk'][$key]['pbspk_no'], $data['pbspk'][$key]['pbspk_tglterima']);

						// set data used_transfer_masuk
						$data_usfm['usfm_no'] = $data['pbspk'][$key]['pbspk_refnopbyr'];					
						$data_usfm['usfm_refno'] = $data['pbspk'][$key]['pbspk_no'];
						$data_usfm['usfm_refjenis'] = 'K';
						$data_usfm['usfm_refseq'] = 0;
						$data_usfm['usfm_total'] = $data['pbspk'][$key]['pbspk_jlhbayar'];

						// insert used_transfer_masuk
						$this->db->insert('used_transfer_masuk', $data_usfm);															
					}
				}

				// update trfm_used
				$this->update_trfm_used($data['tr']['trfm_no']);

				// Simpan jurnal transfer masuk			
				$this->jurnal_simpan_tm($data['tr']['trfm_no'], $data['tr']['trfm_tgltransfer'], $data['tr']['trfm_msap_no_tfm'], $data['tr']['trfm_msap_no_slh'], $data['action']);
			}

			if($data['action'] == 'VOID'){
				// void pembayaran
				$this->void_pbso_bypbso_refnopbyr($data['tr']['trfm_no']);

				// void pembayaran pbspk
				$this->void_pbspk_bypbspk_refnopbyr($data['tr']['trfm_no']);

				// void transfer masuk
				$this->db->where(array('trfm_no' => $data['tr']['trfm_no']));
				$this->db->update('tr_transfer_masuk', array('trfm_void'=>1, 'trfm_used'=>0));

				// Delete used_trasfer_masuk
				$this->db->delete('used_transfer_masuk', array('usfm_no' => $data['tr']['trfm_no']));						

				// delete jurnal transfer masuk
				$this->jurnal_hapus($data['tr']['trfm_no'], 'TM');				
			}
			
			return 1;			 								
		}catch (Exception $e) {
			return 0;
		}		
	}

	private function void_pbso_bypbso_refnopbyr($trfm_no){
		$query = $this->db->get_where('pby_so', array('pbso_refnopbyr' => $trfm_no, 'pbso_void'=>0));
		if($query->num_rows() > 0){
			$data_pbso = $query->result_array();

			foreach ($data_pbso as $key => $value) {																	
				// void pembayaran
				$this->db->where(array('pbso_no' => $value['pbso_no'], 'pbso_seq' => $value['pbso_seq']));
				$this->db->update('pby_so', array('pbso_void'=>1));

				// update trsd_terbayar
				$this->m_so_payment->update_trsd_terbayar($value['pbso_refno']);

				// update trso_terbayar
				$this->m_so_payment->recalc_trso_terbayar(substr($value['pbso_no'], 0, 12));

				// delete jurnal pbso
				$this->jurnal_hapus($value['pbso_no'], 'PY');				
			}					
		}
	}

	private function void_pbspk_bypbspk_refnopbyr($trfm_no){
		$query = $this->db->get_where('pby_spk', array('pbspk_refnopbyr' => $trfm_no, 'pbspk_void'=>0));
		if($query->num_rows() > 0){
			$data_pbspk = $query->result_array();

			foreach ($data_pbspk as $key => $value) {																	
				// void pembayaran
				$this->db->where(array('pbspk_no' => $value['pbspk_no']));
				$this->db->update('pby_spk', array('pbspk_void'=>1));				

				// delete jurnal pbspk
				$this->jurnal_hapus($value['pbspk_no'], 'PK');				
			}					
		}
	}

	private function jurnal_hapus($trju_refno, $trju_reftipe){
		$query = "DELETE dtju
					FROM dt_jurnal dtju
					LEFT JOIN tr_jurnal trju ON trju.trju_no = dtju.dtju_no
					WHERE trju_refno ='".$trju_refno.$trju_reftipe."' AND trju_reftipe = '".$trju_reftipe."'";
		$this->db->simple_query($query);

		$query = "DELETE trju FROM tr_jurnal trju 
					WHERE trju_refno ='".$trju_refno.$trju_reftipe."' AND trju_reftipe = '".$trju_reftipe."'";
		$this->db->simple_query($query);

		// $query = "DELETE trju, dtju
		// 					FROM dt_jurnal dtju
		// 					LEFT JOIN tr_jurnal trju ON trju.trju_no = dtju.dtju_no
		// 					WHERE trju_refno ='".$trju_refno.$trju_reftipe."' AND trju_reftipe = '".$trju_reftipe."'";

		// if($this->db->simple_query($query)){	
		// 	$this->db->delete('tr_jurnal', array('trju_refno'=>$trju_refno.$trju_reftipe, 'trju_reftipe'=>$trju_refno));						
		// }
	}

	public function update_trfm_used($trfm_no){		
		$query = "UPDATE tr_transfer_masuk					
					SET trfm_used = (
										SELECT IFNULL(SUM(usfm_total), 0)
										FROM used_transfer_masuk										
										WHERE usfm_no = '".$trfm_no."'										
									)
					WHERE trfm_no = '".$trfm_no."'";
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
	}		

	public function jurnal_simpan_pbyr_so($pbso_no, $pbso_tglterima){
		$vok = true;				

		// Generate kode jurnal
		$bulan = substr($pbso_tglterima, 5, 2);			
		$tahun = substr($pbso_tglterima, 2, 2);
		$kd_depan = "JA".$tahun.$bulan.'-';
		$trju_no = $this->m_jurnal->jurnal_kode_auto($kd_depan);		

		// Insert header jurnal
		if($vok){
			$str_query = "INSERT INTO tr_jurnal(
							trju_no,
							trju_tgl,
							trju_tipe,
							trju_catatan,
							trju_refno,
							trju_reftipe,
							trju_void,
							trju_lsupd,
							trju_lsusr,
							trju_cekint,
							trju_msus_no,
							trju_mscb_no,
							trju_fin,
							trju_stcopy,
							trju_lscopy,
							trju_tag)
						(SELECT '".$trju_no."',
								pbso_tglterima,
								'A',
								SUBSTRING(CONCAT(pbso_tag,' ', pbso_no, '/', trso_mscs_no, ' - ', mscs_nm), 1, 250),								
								CONCAT(pbso_no,'PY'),
								'PY',
								0,
								pbso_lsupd,
								pbso_lsusr,
								1,
								pbso_msus_no,
								pbso_mscb_no,
								'F',
								'R',
								0,
								''
						FROM pby_so
						LEFT JOIN tr_so ON trso_no = SUBSTRING(pbso_no, 1, 12)
						LEFT JOIN ms_customer ON mscs_no = trso_mscs_no
						WHERE pbso_no = '".$pbso_no."'
						LIMIT 1)";

			if(!$this->db->simple_query($str_query)){					
				echo $str_query; 
				die('Error create header jurnal. '. $pbso_no);
			}
		}

		// Insert jurnal debet
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'BINT'),
								pbso_jlhbayar,
								0,
								'',
								''
								FROM pby_so
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE pbso_no = '".$pbso_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $pbso_no);
			}
		}

		// Insert jurnal kredit
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq, 
								IF(mscs_jenis = 'A', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUA'),
													(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUR')),
								0,
								pbso_jlhbayar,
								'',
								''
								FROM pby_so
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r								
								LEFT JOIN tr_so ON trso_no = SUBSTRING(pbso_no, 1, 12)
								LEFT JOIN ms_customer ON mscs_no = trso_mscs_no
								WHERE pbso_no = '".$pbso_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $pbso_no);
			}
		}
	}

	public function jurnal_simpan_pbyr_spk($pbspk_no, $pbspk_tglterima){
		$vok = true;				

		// Generate kode jurnal
		$bulan = substr($pbspk_tglterima, 5, 2);			
		$tahun = substr($pbspk_tglterima, 2, 2);
		$kd_depan = "JA".$tahun.$bulan.'-';
		$trju_no = $this->m_jurnal->jurnal_kode_auto($kd_depan);		

		// Insert header jurnal
		if($vok){
			$str_query = "INSERT INTO tr_jurnal(
							trju_no,
							trju_tgl,
							trju_tipe,
							trju_catatan,
							trju_refno,
							trju_reftipe,
							trju_void,
							trju_lsupd,
							trju_lsusr,
							trju_cekint,
							trju_msus_no,
							trju_mscb_no,
							trju_fin,
							trju_stcopy,
							trju_lscopy,
							trju_tag)
						(SELECT '".$trju_no."',
								pbspk_tglterima,
								'A',
								SUBSTRING(CONCAT(pbspk_no, '/', trspk_mscs_no, ' - ', mscs_nm), 1, 250),								
								CONCAT(pbspk_no,'PK'),
								'PK',
								0,
								pbspk_lsupd,
								pbspk_lsusr,
								1,
								pbspk_msus_no,
								pbspk_mscb_no,
								'F',
								'R',
								0,
								''
						FROM pby_spk
						LEFT JOIN tr_spk ON trspk_no = SUBSTRING(pbspk_no, 1, 12)
						LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no
						WHERE pbspk_no = '".$pbspk_no."'
						LIMIT 1)";

			if(!$this->db->simple_query($str_query)){					
				echo $str_query; 
				die('Error create header jurnal. '. $pbspk_no);
			}
		}

		// Insert jurnal debet
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'BINT'),
								pbspk_jlhbayar,
								0,
								'',
								''
								FROM pby_spk
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE pbspk_no = '".$pbspk_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $pbspk_no);
			}
		}

		// Insert jurnal kredit
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq, 
								IF(mscs_jenis = 'A', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUA'),
													(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUR')),
								0,
								pbspk_jlhbayar,
								'',
								''
								FROM pby_spk
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r								
								LEFT JOIN tr_spk ON trspk_no = SUBSTRING(pbspk_no, 1, 12)
								LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no
								WHERE pbspk_no = '".$pbspk_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $pbspk_no);
			}
		}
	}

	public function jurnal_simpan_tm($trfm_no, $trfm_tgltransfer, $trfm_msap_no_tfm, $trfm_msap_no_slh, $action){
		$vok = true;		
		$trju_no = '';		

		if($vok && $action == 'NEW'){
			// Generate kode jurnal
			$bulan = substr($trfm_tgltransfer, 5, 2);			
			$tahun = substr($trfm_tgltransfer, 2, 2);
			$kd_depan = "JA".$tahun.$bulan.'-';
			$trju_no = $this->m_jurnal->jurnal_kode_auto($kd_depan);		

			// Insert header jurnal
			$str_query = "INSERT INTO tr_jurnal(
							trju_no,
							trju_tgl,
							trju_tipe,
							trju_catatan,
							trju_refno,
							trju_reftipe,
							trju_void,
							trju_lsupd,
							trju_lsusr,
							trju_cekint,
							trju_msus_no,
							trju_mscb_no,
							trju_fin,
							trju_stcopy,
							trju_lscopy,
							trju_tag)
						(SELECT '".$trju_no."',
								'".$trfm_tgltransfer."',
								'A',
								SUBSTRING(CONCAT(trfm_tag,' ', trfm_catatan), 1, 250),								
								CONCAT(trfm_no,'TM'),
								'TM',
								0,
								'".date('Y-m-d H:i:s')."',
								'".$this->session->userdata('user_aktif')['msus_no']."',								
								1,
								'".$this->session->userdata('user_aktif')['msus_no']."',
								'".$this->session->userdata('user_aktif')['msus_mscb_no']."',
								'F',
								'R',
								0,
								''
						FROM tr_transfer_masuk						
						WHERE trfm_no = '".$trfm_no."')";

			if(!$this->db->simple_query($str_query)){					
				echo $str_query; 
				die('Error create header jurnal. '. $trfm_no);
			}
		}

		if($vok && $action == 'EDIT'){
			$trju_no = $this->get_trju_no_byrefno($trfm_no, 'TM');

			$str_query = "UPDATE tr_jurnal
							LEFT JOIN tr_transfer_masuk ON trfm_no = SUBSTRING(trju_refno, 1, 12)
							SET trju_catatan = SUBSTRING(CONCAT(trfm_tag,' ', trfm_catatan), 1, 250),
								trju_lsupd = trfm_lsupd,
								trju_lsusr = trfm_lsusr
							WHERE trju_no = '".$trju_no."'";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error update tr_jurnal. '. $trfm_no);
			}
		}

		if($vok){
			// Delete dt_jurnal transfer masuk
			$str_query = "DELETE FROM dt_jurnal WHERE dtju_no ='".$trju_no."'";		
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error delete dt_jurnal. '. $trfm_no);
			}
		}

		// Insert jurnal debet
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								'".$trfm_msap_no_tfm."',
								trfm_total,
								0,
								'',
								''
								FROM tr_transfer_masuk
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE trfm_no = '".$trfm_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $trfm_no);
			}
		}		

		// Insert jurnal kredit
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'BINT'),
								0,
								trfm_used,
								'',
								''
								FROM tr_transfer_masuk
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE trfm_no = '".$trfm_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $trfm_no);
			}
		}

		// Insert jurnal kredit
		if($vok){			
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								'".$trfm_msap_no_slh."',
								0,
								trfm_total - trfm_used,
								'',
								''
								FROM tr_transfer_masuk
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE trfm_no = '".$trfm_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $trfm_no);
			}			
		}

		// delete akun selisih jika tidak ada selisih
		if($vok){
			$str_query = "DELETE FROM dt_jurnal WHERE dtju_no = '".$trju_no."' AND dtju_seq = 3 AND dtju_kredit = 0";

			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error delete akun. '. $trfm_no);
			}			
		}
	}

	private function get_trju_no_byrefno($trju_refno, $trju_reftipe){
		$query = $this->db->get_where('tr_jurnal', array('trju_refno'=>$trju_refno.$trju_reftipe, 'trju_reftipe'=>$trju_reftipe));
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['trju_no'];
		}else{
			return '';
		}
	}
	
}
