<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_so_payment extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('setting/m_user_log');		
	}

	public function get_so_payment_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'pbso_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('DISTINCT(pbso_no),mscs_nm, msjb_nm, pbso_trsr_no, pbso_jenis, pbso_bayardp, pbso_tglterima, pbso_tglcair, pbso_catatan, pbso_tag, pbso_mscb_no, pbso_void');
		$this->db->from('pby_so');
		$this->db->join('tr_so', 'tr_so.trso_no = SUBSTRING(pbso_no, 1, 12)','left');						
		$this->db->join('ms_customer', 'ms_customer.mscs_no = tr_so.trso_mscs_no','left');		
		// $this->db->join('pby_so', 'pby_so.pbso_no = tr_so.trso_no','inner');		
		$this->db->join('ms_jnspbyr', 'ms_jnspbyr.msjb_no = pby_so.pbso_msjb_no','left');		
		// $this->db->join('tr_jurnal', 'trju_refno = pby_so.pbso_no','left');
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}				
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}	

	public function get_so_payment($pbso_no){				

		$this->db->select('pby_so.*, mscs_no, mscs_nm, msus_no, msus_nm, msjb_tipe,trfm_no, trgm_no, IFNULL(trgm_total, 0) as trgm_total, IFNULL(trgm_used, 0) as trgm_used, trgm_cekint,
							trso_total, trso_terbayar, trso_sisadp, trso_cekint, trso_lock, trsr_cekint, tr_sales_dlv.*, IFNULL((SELECT SUM(pbso_jlhbayar) FROM pby_so WHERE SUBSTRING(pbso_no,1,12) ="'.substr($pbso_no, 0, 12).'" AND pbso_jenis = "D" AND pbso_void = "0"), 0) AS cal_dpused');
		$this->db->from('pby_so');		
		$this->db->join('tr_so','trso_no = SUBSTRING(pbso_no, 1, 12)', 'left');
		$this->db->join('tr_sales_dlv','trsd_no = pbso_refno', 'left');
		$this->db->join('tr_salesret','trsr_no = pbso_trsr_no', 'left');
		$this->db->join('ms_customer','mscs_no = trso_mscs_no', 'left');
		$this->db->join('ms_user','msus_no = pbso_msus_no', 'left');		
		$this->db->join('ms_jnspbyr','msjb_no = pbso_msjb_no', 'left');				
		$this->db->join('tr_giro_masuk','trgm_no = pbso_refnopbyr', 'left');
		$this->db->join('tr_transfer_masuk','trfm_no = pbso_refnopbyr', 'left');
		// $this->db->join('tr_jurnal', 'trju_refno = pby_so.pbso_no','left');
		$this->db->where('pbso_no', $pbso_no);
		$this->db->order_by('pbso_seq', 'ASC');
		$query = $this->db->get();
		
		if($query->num_rows() > 0 ){			
			return $query->result_array();
		}else{
			return false;
		}	
	
	}

	public function get_so_payment_bytrfmno($trfm_no){
		$data = array();

		$this->db->select('pby_so.*, trsd_no, trsd_tgl, trsd_total, trsd_terbayar, trsd_cekint');
		$this->db->from('pby_so');				
		$this->db->join('tr_sales_dlv', 'trsd_no = pbso_refno', 'left');				
		$this->db->where('pbso_refnopbyr',$trfm_no);		
		$this->db->where('pbso_void',0);		
		$query = $this->db->get();

		if($query->num_rows() > 0){			
			$data = $query->result_array();			
		}	

		return $data;
	}

	public function get_resume_so_payment($trso_no){
		$query = "SELECT" 
				." so.trso_no,so.trso_total,so.trso_terbayar"
				." ,dlv.trsd_total,dlv.trsd_terbayar"
				." ,IFNULL(jb.msjb_nm,'POTONG DP') AS JENIS_BAYAR"
				." ,bso.*"
				." FROM pby_so AS bso"
				." LEFT JOIN tr_so AS so ON so.trso_no = SUBSTRING(pbso_no,1,12)"
				." LEFT JOIN tr_sales_dlv AS dlv ON dlv.trsd_no = bso.pbso_refno"
				." LEFT JOIN ms_jnspbyr AS jb ON jb.msjb_no = bso.pbso_msjb_no"
				." WHERE bso.pbso_void = 0"
				." AND so.trso_no = '". substr($trso_no, 0, 12)."'"
				." ORDER BY bso.pbso_refno,bso.pbso_no";

		$query = $this->db->query($query);
		return $query->result_array();
	}		

	// public function get_total_potongdp($pbso_no){
	// 	$this->db->limit(1, 0);
	// 	$this->db->select("IFNULL((SELECT SUM(pbso_jlhbayar) FROM pby_so WHERE pbso_jenis = 'D'), 0) AS total_potongdp");
	// 	$this->db->from('pby_so');						
	// 	$this->db->where('SUBSTRING(pbso_no, 1, 12) = ', substr($pbso_no, 0, 12));
	// 	$query = $this->db->get();							
	// 	return $query->num_rows();					
	// }

	public function so_payment_kode_auto($trso_no){
		$this->db->select_max("pbso_no");
		$this->db->like("pbso_no", $trso_no, "after");
		$query = $this->db->get("pby_so");
		if ($query->num_rows() == 0){
			return $trso_no. "-BY01";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['pbso_no'];
			$nomor = ((int) substr($kode, 15)) + 1;
			return $trso_no. '-BY'. sprintf("%'.02d", $nomor);
		}
	}	

	public function get_so_payment_cekint($pbso_no, $pbso_seq, $pbso_cekint){		
		$query = $this->db->get_where('pby_so', array('pbso_no' => $pbso_no, 'pbso_seq' => $pbso_seq, 'pbso_cekint' => $pbso_cekint));		
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_so_payment_cekint($pbso_no, $pbso_seq){		
		//Update pbso_cekint di tabel pby_so
		$this->db->where(array('pbso_no' => $pbso_no, 'pbso_seq' => $pbso_seq));
		$this->db->update('pby_so', array('pbso_cekint' => rand(0,10000)));
	}

	public function so_payment_simpan($data){
		try {
				if($data['action'] == 'NEW'){
					// Insert data SO Payment
					$this->insert_data($data);					
					$this->jurnal_simpan($data);
				}

				if($data['action'] == 'EDIT'){															
					// Update data SO Payment
					$this->update_data($data);										

					$this->jurnal_simpan($data);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);
				}
				
				if($data['action'] == 'VOID'){
					// Void data SO Payment
					$this->void_data($data);					
					$this->jurnal_hapus($data);

					if($data['header']['pbso_jenis'] == 'G'){
						// Delete used_giro_masuk
						$this->db->delete('used_giro_masuk', array('usgm_refno' => $data['header']['pbso_no']));						

						// update trgm_used
						$this->m_giro_masuk->update_trgm_used($data['header']['pbso_refnopbyr']);

						// update cekint
						$this->m_giro_masuk->set_giro_masuk_cekint($data['header']['pbso_refnopbyr']);
					}

					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);
				}				

				$this->recalc_trso_terbayar(substr($data['header']['pbso_no'], 0, 12));
				$this->recalc_trso_sisadp(substr($data['header']['pbso_no'], 0, 12));
				return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	private function insert_data($data){		
		$this->update_tr_salesret($data);
		$seq = 1;
		foreach ($data['detail'] as $key => $value) {										
			$data['header']['pbso_refno'] = $value['pbso_refno'];		
			$data['header']['pbso_seq'] = $seq;
			$data['header']['pbso_jlhbayar'] = $value['pbso_jlhbayar'];
			$this->db->insert('pby_so',$data['header']);
			$this->update_trsd_terbayar($value['pbso_refno']);

			if($data['header']['pbso_jenis'] == 'G'){
		    	$data_usgm['usgm_no'] = $data['header']['pbso_refnopbyr'];						
				$data_usgm['usgm_refno'] = $data['header']['pbso_no'];
				$data_usgm['usgm_refjenis'] = 'S';
				$data_usgm['usgm_refseq'] = $seq;
				$data_usgm['usgm_total'] = $value['pbso_jlhbayar'];

				$this->db->insert('used_giro_masuk', $data_usgm);
		    }
			$seq += 1;
		}	

		if($data['header']['pbso_jenis'] == 'G'){	    	
			// update trgm_used
			$this->m_giro_masuk->update_trgm_used($data['header']['pbso_refnopbyr']);

			// update cekint
			$this->m_giro_masuk->set_giro_masuk_cekint($data['header']['pbso_refnopbyr']);
	    }			
	}

	private function update_data($data){				
		$pbso_jenis = $this->get_pbso_jenis($data['header']['pbso_no']);

		if($pbso_jenis == 'G'){
			// Delete used_giro_masuk
			$this->db->delete('used_giro_masuk', array('usgm_refno' => $data['header']['pbso_no']));					

			// update trgm_used
			$pbso_refnopbyr = $this->get_pbso_refnopbyr($data['header']['pbso_no']);
			$this->m_giro_masuk->update_trgm_used($pbso_refnopbyr);
		}

		$this->update_tr_salesret($data);

		foreach ($data['detail'] as $key => $value) {							
			$data['header']['pbso_jlhbayar'] = $value['pbso_jlhbayar'];
			$this->db->where(array('pbso_no' => $data['header']['pbso_no'], 'pbso_seq' => $data['detail'][$key]['pbso_seq']));
			$this->db->update('pby_so',$data['header']);

			if($data['header']['pbso_jenis'] == 'G'){
		    	$data_usgm['usgm_no'] = $data['header']['pbso_refnopbyr'];						
				$data_usgm['usgm_refno'] = $data['header']['pbso_no'];
				$data_usgm['usgm_refjenis'] = 'S';
				$data_usgm['usgm_refseq'] = $data['detail'][$key]['pbso_seq'];
				$data_usgm['usgm_total'] = $value['pbso_jlhbayar'];

				$this->db->insert('used_giro_masuk', $data_usgm);				
		    }

			$this->update_trsd_terbayar($value['pbso_refno']);
		}				

		if($data['header']['pbso_jenis'] == 'G'){
			// update trgm_used
			$this->m_giro_masuk->update_trgm_used($data['header']['pbso_refnopbyr']);

			// update cekint
			$this->m_giro_masuk->set_giro_masuk_cekint($data['header']['pbso_refnopbyr']);
		}
	}

	public function get_pbso_jenis($pbso_no){
		$query = $this->db->get_where('pby_so', array('pbso_no' => $pbso_no));				 
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['pbso_jenis'];
		}
	}

	public function get_pbso_refnopbyr($pbso_no){
		$query = $this->db->get_where('pby_so', array('pbso_no' => $pbso_no));				 
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['pbso_refnopbyr'];
		}
	}	

	private function void_data($data){
		$this->update_tr_salesret($data);			
		//void PO Payment
		foreach ($data['detail'] as $key => $value) {
			$this->db->where(array('pbso_no' => $data['header']['pbso_no'], 'pbso_seq' => $data['detail'][$key]['pbso_seq']));
			$this->db->update('pby_so', array('pbso_void'=>1));
			$this->update_trsd_terbayar($value['pbso_refno']);
		}
	}

	private function update_tr_salesret($data){
		$this->db->where(array('trsr_pbso_no' => $data['header']['pbso_no']));
		$this->db->update('tr_salesret',array('trsr_pbso_no'=>'','trsr_cekint'=> rand(0, 10000)));

		$this->db->where(array('pbso_no' => $data['header']['pbso_no']));
		$this->db->update('pby_so',array('pbso_trsr_no'=>''));

		//Update trsr_pbso_no di table tr_salesret
		if($data['action'] != 'VOID'){
			if($data['header']['pbso_jenis'] == 'O' && $data['msjb_tipe'] == 'R'){								
				$this->db->where(array('trsr_no' => $data['header']['pbso_trsr_no']));
				$this->db->update('tr_salesret',array('trsr_pbso_no'=>$data['header']['pbso_no'],'trsr_cekint'=> rand(0, 10000)));			
			}
		}
	}

	// private function recalc_trso_terbayar($trso_no){
	// 	$query = "UPDATE tr_so SET trso_terbayar = round(IFNULL(
	// 													(SELECT SUM(pbso_jlhbayar) FROM pby_so 
	// 													WHERE (pbso_jenis <> 'D' AND pbso_bayardp not in ('C','B')) AND SUBSTRING(pbso_no, 1,12) = '".$trso_no."' AND pbso_void = 0)
	// 												,0),4)
	// 				WHERE trso_no = '".$trso_no."'";

	// 	if($this->db->simple_query($query)){		
	// 		return 1;
	// 	}else{
	// 		return 0;
	// 	}
	// }

	public function recalc_trso_terbayar($trso_no){
		$query = "UPDATE tr_so SET trso_terbayar = round(IFNULL((SELECT SUM(pbso_jlhbayar) FROM pby_so"
													." WHERE (pbso_jenis = 'O' OR pbso_jenis = 'G' OR pbso_jenis = 'T') AND SUBSTRING(pbso_no, 1,12) = '".$trso_no."' AND pbso_void = 0),0)"
													." -"
													." IFNULL((SELECT SUM(pbso_jlhbayar) FROM pby_so"
													." WHERE pbso_jenis = 'D' AND pbso_bayardp in ('C','B') AND SUBSTRING(pbso_no, 1,12) = '".$trso_no."' AND pbso_void = 0),0),4)"	
				." WHERE trso_no = '".$trso_no."'";

		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}
	}

	private function recalc_trso_sisadp($trso_no){
		$query = "UPDATE tr_so SET trso_sisadp = round(IFNULL((SELECT SUM(pbso_jlhbayar) FROM pby_so"
													." WHERE pbso_bayardp = 'D' AND SUBSTRING(pbso_no, 1,12) = '".$trso_no."' AND pbso_void = 0),0)"
													." -"
													." IFNULL((SELECT SUM(pbso_jlhbayar) FROM pby_so"
													." WHERE pbso_jenis = 'D' AND SUBSTRING(pbso_no, 1,12) = '".$trso_no."' AND pbso_void = 0),0), 4)"
				." WHERE trso_no = '".$trso_no."'";

		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}
	}
	
	public function update_trsd_terbayar($trsd_no){
			$query = "UPDATE tr_sales_dlv SET trsd_terbayar = round(IFNULL((SELECT SUM(pbso_jlhbayar) FROM pby_so"								
								." WHERE pbso_refno = '".$trsd_no."' "
								." AND pbso_bayardp = 'T' AND SUBSTRING(pbso_no, 1,12) = '".substr($trsd_no, 0, 12)."' AND pbso_void = 0), 0), 4)"
					." WHERE trsd_no = '".$trsd_no."'";

			if($this->db->simple_query($query)){		
				return 1;
			}else{
				return 0;
			}
	}	

	private function jurnal_simpan($data){				
			// Generate CekInt
			$data['jurnal_h']['trju_cekint'] = rand(0,10000);			

			if($data['action'] == 'NEW'){
				// Insert data header jurnal
				$this->db->insert('tr_jurnal',$data['jurnal_h']);
			}

			if($data['action'] == 'EDIT'){
				// Update data header jurnal
				$this->db->where('trju_no',$data['jurnal_h']['trju_no']);
				$this->db->update('tr_jurnal',$data['jurnal_h']);
				$this->db->delete('dt_jurnal',array('dtju_no' => $data['jurnal_h']['trju_no']));
			}			

			//Insert data detail jurnal
			if(isset($data['jurnal_d'])){
				$seq = 1;
				foreach ($data['jurnal_d'] as $key => $value) {														
					$data['jurnal_d'][$key]['dtju_no'] = $data['jurnal_h']['trju_no'];
					$data['jurnal_d'][$key]['dtju_seq'] = $seq;
					$this->db->insert('dt_jurnal',$data['jurnal_d'][$key]);
					$seq += 1;
				}		
			}		
	}

	private function jurnal_hapus($data){
		if(isset($data['jurnal_h']['trju_no']) && strlen($data['jurnal_h']['trju_no']) > 0){
			$this->db->delete('tr_jurnal', array('trju_no' => $data['jurnal_h']['trju_no']));
			$this->db->delete('dt_jurnal', array('dtju_no' => $data['jurnal_h']['trju_no']));
		}
	}
		
}
