<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_po_payment extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('setting/m_user_log');
		$this->load->model('setting/m_setting_account');		
	}

	public function get_po_payment_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'pbpo_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('DISTINCT(pbpo_no),mssp_nm, msjb_nm, pbpo_tgl, pbpo_jenis, pbpo_bayardp, pbpo_tglcair, pbpo_catatan, pbpo_tag, pbpo_mscb_no, pbpo_void');
		$this->db->from('pby_po');
		$this->db->join('tr_po', 'tr_po.trpo_no = SUBSTRING(pbpo_no, 1, 12)','left');						
		$this->db->join('ms_supplier', 'ms_supplier.mssp_no = tr_po.trpo_mssp_no','left');		
		// $this->db->join('pby_po', 'pby_po.pbpo_no = tr_po.trpo_no','inner');		
		$this->db->join('ms_jnspbyr', 'ms_jnspbyr.msjb_no = pby_po.pbpo_msjb_no','left');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}				
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}	

	public function get_po_payment($pbpo_no){				

		$this->db->select('pby_po.*, mssp_no, mssp_nm, msus_no, msus_nm, msjb_tipe, trfk_no, trgk_no,
							trpo_curr, trpo_total, trpo_terbayar, trpo_sisadp, trpo_cekint, trpo_lock, trpt_cekint, trpo_final, trpo_fin, trpo_tag, trpo_no,
							tr_in_dlv.*, IFNULL((SELECT SUM(pbpo_jlhbayar) FROM pby_po WHERE SUBSTRING(pbpo_no,1,12) ="'.substr($pbpo_no, 0, 12).'" AND pbpo_jenis = "D" AND pbpo_void = "0"), 0) AS cal_dpused');
		$this->db->from('pby_po');		
		$this->db->join('tr_po','trpo_no = SUBSTRING(pbpo_no, 1, 12)', 'left');
		$this->db->join('tr_in_dlv','trid_no = pbpo_refno', 'left');
		$this->db->join('tr_purcret','trpt_no = pbpo_trpt_no', 'left');
		$this->db->join('ms_supplier','mssp_no = trpo_mssp_no', 'left');
		$this->db->join('ms_user','msus_no = trpo_msus_no', 'left');
		$this->db->join('ms_jnspbyr','msjb_no = pbpo_msjb_no', 'left');
		$this->db->join('tr_transfer_keluar','trfk_no = pbpo_refnopbyr', 'left');
		$this->db->join('tr_giro_keluar','trgk_no = pbpo_refnopbyr', 'left');
		$this->db->where('pbpo_no', $pbpo_no);
		$this->db->order_by('pbpo_seq', 'ASC');
		$query = $this->db->get();			
		return $query->result_array();		
	}

	public function get_resume_po_payment($trpo_no){
		$query = "SELECT" 
				." po.trpo_no,po.trpo_total,po.trpo_terbayar"
				." ,dlv.trid_total,dlv.trid_terbayar"
				." ,IFNULL(jb.msjb_nm,'POTONG DP') AS JENIS_BAYAR"
				." ,bpo.*"
				." FROM pby_po AS bpo"
				." LEFT JOIN tr_po AS po ON po.trpo_no = SUBSTRING(pbpo_no,1,12)"
				." LEFT JOIN tr_in_dlv AS dlv ON dlv.trid_no = bpo.pbpo_refno"
				." LEFT JOIN ms_jnspbyr AS jb ON jb.msjb_no = bpo.pbpo_msjb_no"
				." WHERE bpo.pbpo_void = 0"
				." AND po.trpo_no = '". substr($trpo_no, 0, 12)."'"
				." ORDER BY bpo.pbpo_refno,bpo.pbpo_no";

		$query = $this->db->query($query);
		return $query->result_array();
	}

	public function get_total_acc_dp($trpo_no){
		$ppdp = $this->m_setting_account->get_setting_account_byid('PPDP');
		
		$query = "SELECT sum(dtju_debet) as total_debet, sum(dtju_kredit) total_kredit FROM dt_jurnal dtju
					LEFT JOIN tr_jurnal ON trju_no = dtju.dtju_no
					WHERE SUBSTRING(trju_refno, 1, 12) = '".$trpo_no."'
					AND trju_reftipe = 'PP'
					AND dtju_msap_no = '".$ppdp['mssa_msap_no']."'";

		$query = $this->db->query($query);
		$result = $query->result_array();
		return $result[0];
	}			

	public function po_payment_kode_auto($trpo_no){
		$this->db->select_max("pbpo_no");
		$this->db->like("pbpo_no", $trpo_no, "after");
		$query = $this->db->get("pby_po");
		if ($query->num_rows() == 0){
			return $trpo_no. "-BY01";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['pbpo_no'];
			$nomor = ((int) substr($kode, 15)) + 1;			
			return $trpo_no. '-BY'. sprintf("%'.02d", $nomor);
		}
	}		

	public function get_po_payment_cekint($pbpo_no, $pbpo_seq, $pbpo_cekint){		
		$query = $this->db->get_where('pby_po', array('pbpo_no' => $pbpo_no, 'pbpo_seq' => $pbpo_seq, 'pbpo_cekint' => $pbpo_cekint));		
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_po_payment_cekint($pbpo_no, $pbpo_seq){		
		//Update pbpo_cekint di tabel pby_po
		$this->db->where(array('pbpo_no' => $pbpo_no, 'pbpo_seq' => $pbpo_seq));
		$this->db->update('pby_po', array('pbpo_cekint' => rand(0,10000)));
	}

	public function set_po_payment_cekint_bypo($trpo_no){		
		//Update pbpo_cekint di tabel pby_po
		$this->db->where(array('substring(pbpo_no, 1, 12) =' => $trpo_no));
		$this->db->update('pby_po', array('pbpo_cekint' => rand(0,10000)));
	}

	public function po_payment_simpan($data){
		try {
				if($data['action'] == 'NEW'){
					// Insert data PO Payment
					$this->insert_data($data);		
					$this->jurnal_simpan($data);			
				}

				if($data['action'] == 'EDIT'){
					// Update data PO Payment
					$this->update_data($data);	
					$this->jurnal_simpan($data);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);				
				}
				
				if($data['action'] == 'VOID'){
					// Void data PO Payment
					$this->void_data($data);
					$this->jurnal_hapus($data);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);					
				}				

				$this->recalc_trpo_terbayar(substr($data['header']['pbpo_no'], 0, 12));
				$this->recalc_trpo_sisadp(substr($data['header']['pbpo_no'], 0, 12));
				return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	private function insert_data($data){		
		$this->update_tr_purcret($data);
		$seq = 1;
		foreach ($data['detail'] as $key => $value) {										
			$data['header']['pbpo_refno'] = $value['pbpo_refno'];		
			$data['header']['pbpo_seq'] = $seq;
			$data['header']['pbpo_jlhbayar'] = $value['pbpo_jlhbayar'];
			$this->db->insert('pby_po',$data['header']);
			$this->update_trid_terbayar(substr($data['header']['pbpo_no'], 0, 12), $value['pbpo_refno']);
			$seq += 1;
		}				
	}

	private function update_data($data){				
		$this->update_tr_purcret($data);
		foreach ($data['detail'] as $key => $value) {
			$data['header']['pbpo_jlhbayar'] = $value['pbpo_jlhbayar'];
			$this->db->where(array('pbpo_no' => $data['header']['pbpo_no'], 'pbpo_seq' => $data['detail'][$key]['pbpo_seq']));
			$this->db->update('pby_po',$data['header']);
			$this->update_trid_terbayar(substr($data['header']['pbpo_no'], 0, 12), $value['pbpo_refno']);
		}				
	}

	private function void_data($data){
		$this->update_tr_purcret($data);			
		//void PO Payment
		foreach ($data['detail'] as $key => $value) {
			$this->db->where(array('pbpo_no' => $data['header']['pbpo_no'], 'pbpo_seq' => $data['detail'][$key]['pbpo_seq']));
			$this->db->update('pby_po', array('pbpo_void'=>1));
			$this->update_trid_terbayar(substr($data['header']['pbpo_no'], 0, 12), $value['pbpo_refno']);
		}
	}

	private function update_tr_purcret($data){
		$this->db->where(array('trpt_pbpo_no' => $data['header']['pbpo_no']));
		$this->db->update('tr_purcret',array('trpt_pbpo_no'=>'','trpt_cekint'=> rand(0, 10000)));

		$this->db->where(array('pbpo_no' => $data['header']['pbpo_no']));
		$this->db->update('pby_po',array('pbpo_trpt_no'=>''));

		//Update trpt_pbpo_no di table tr_purcret
		if($data['action'] != 'VOID'){
			if($data['header']['pbpo_jenis'] == 'O' && $data['msjb_tipe'] == 'R'){								
				$this->db->where(array('trpt_no' => $data['header']['pbpo_trpt_no']));
				$this->db->update('tr_purcret',array('trpt_pbpo_no'=>$data['header']['pbpo_no'],'trpt_cekint'=> rand(0, 10000)));			
			}
		}
	}

	public function recalc_trpo_terbayar($trpo_no){
		$query = "UPDATE tr_po SET trpo_terbayar = round(IFNULL((SELECT SUM(pbpo_jlhbayar) FROM pby_po"
													." WHERE (pbpo_jenis = 'O' OR pbpo_jenis = 'G' OR pbpo_jenis = 'T') AND SUBSTRING(pbpo_no, 1,12) = '".$trpo_no."' AND pbpo_void = 0),0)"
													." -"
													." IFNULL((SELECT SUM(pbpo_jlhbayar) FROM pby_po"
													." WHERE pbpo_jenis = 'D' AND pbpo_bayardp in ('C','B') AND SUBSTRING(pbpo_no, 1,12) = '".$trpo_no."' AND pbpo_void = 0),0), 4)"	
				." WHERE trpo_no = '".$trpo_no."'";		

		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}
	}

	public function recalc_trpo_sisadp($trpo_no){		
		$query = "UPDATE tr_po SET trpo_sisadp = round(IFNULL((SELECT SUM(pbpo_jlhbayar) FROM pby_po"
													." WHERE pbpo_bayardp = 'D' AND SUBSTRING(pbpo_no, 1,12) = '".$trpo_no."' AND pbpo_void = 0),0)"
													." -"
													." IFNULL((SELECT SUM(pbpo_jlhbayar) FROM pby_po"
													." WHERE pbpo_jenis = 'D' AND SUBSTRING(pbpo_no, 1,12) = '".$trpo_no."' AND pbpo_void = 0),0), 4)"
				." WHERE trpo_no = '".$trpo_no."'";

		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}
	}

	public function update_trid_terbayar($trid_no){
			$query = "UPDATE tr_in_dlv SET trid_terbayar = round(IFNULL((SELECT SUM(pbpo_jlhbayar) FROM pby_po"								
								." WHERE pbpo_refno = '".$trid_no."' "
								." AND pbpo_bayardp = 'T' AND SUBSTRING(pbpo_no, 1,12) = '".substr($trid_no, 0, 12)."' AND pbpo_void = 0), 0),4)"
					." WHERE trid_no = '".$trid_no."'";

			if($this->db->simple_query($query)){		
				return 1;
			}else{
				return 0;
			}
	}	

	private function jurnal_simpan($data){				
			// Generate CekInt
			$data['jurnal_h']['trju_cekint'] = rand(0,10000);			

			if($data['action'] == 'NEW'){
				// Insert data header jurnal
				$this->db->insert('tr_jurnal',$data['jurnal_h']);
			}

			if($data['action'] == 'EDIT'){
				// Update data header jurnal
				$this->db->where('trju_no',$data['jurnal_h']['trju_no']);
				$this->db->update('tr_jurnal',$data['jurnal_h']);
				$this->db->delete('dt_jurnal',array('dtju_no' => $data['jurnal_h']['trju_no']));
			}			

			//Insert data detail jurnal
			if(isset($data['jurnal_d'])){
				$seq = 1;
				foreach ($data['jurnal_d'] as $key => $value) {														
					$data['jurnal_d'][$key]['dtju_no'] = $data['jurnal_h']['trju_no'];
					$data['jurnal_d'][$key]['dtju_seq'] = $seq;
					$this->db->insert('dt_jurnal',$data['jurnal_d'][$key]);
					$seq += 1;
				}		
			}		
	}

	private function jurnal_hapus($data){		
		if(isset($data['jurnal_h']['trju_no']) && strlen($data['jurnal_h']['trju_no']) > 0){
			$this->db->delete('tr_jurnal', array('trju_no' => $data['jurnal_h']['trju_no']));
			$this->db->delete('dt_jurnal', array('dtju_no' => $data['jurnal_h']['trju_no']));
		}
	}
	

	public function get_po_payment_bytrfkno($trfk_no){
		$data = array();

		$this->db->select('pby_po.*, trid_no, trid_tgl, trid_total, trid_terbayar, trid_cekint, trid_kurs');
		$this->db->from('pby_po');				
		$this->db->join('tr_in_dlv', 'trid_no = pbpo_refno', 'left');				
		$this->db->where('pbpo_refnopbyr',$trfk_no);		
		$this->db->where('pbpo_void',0);		
		$query = $this->db->get();

		if($query->num_rows() > 0){			
			$data = $query->result_array();			
		}	

		return $data;
	}

	public function get_po_payment_bytrgkno($trgk_no){
		$data = array();

		$this->db->select('pby_po.*, trid_no, trid_tgl, trid_total, trid_terbayar, trid_cekint');
		$this->db->from('pby_po');				
		$this->db->join('tr_in_dlv', 'trid_no = pbpo_refno', 'left');				
		$this->db->where('pbpo_refnopbyr',$trgk_no);		
		$this->db->where('pbpo_void',0);		
		$query = $this->db->get();

		if($query->num_rows() > 0){			
			$data = $query->result_array();			
		}	

		return $data;
	}
}
