<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_perhitungan_bulanan extends MY_Model {	
	function __construct(){
		parent::__construct();
		$this->load->model('finance_and_acc/m_jurnal');
		$this->load->model('setting/m_setting_account');
		$this->load->model('data_master/m_cabang');
	}	

	public function clear_hisacc($periode){
		// clear data master acc by periode
		$this->db->delete('his_accgrp', array('hsag_periode' => $periode));
		$this->db->delete('his_accsub', array('hsas_periode' => $periode));
		$this->db->delete('his_accper', array('hsap_periode' => $periode));		
		$this->db->delete('his_costcenter', array('hscc_periode' => $periode));		
		$this->db->truncate('temp_his_accper');		
		// void spesial jurnal by periode
		$this->db->update('tr_jurnal', array('trju_void' => 1), array('MONTH(trju_tgl) =' => substr($periode, 4, 2), 'YEAR(trju_tgl) =' => substr($periode, 0, 4), 'trju_reftipe' => 'SJ'));
	}

	public function insert_grpsub_tohis($periode){
		$err = 0;
		$err_msg = '';

		$query = 'INSERT INTO his_accgrp (hsag_periode, hsag_no, hsag_nm, hsag_listmscb, hsag_jenis, hsag_kelompok, hsag_salnorm, hsag_aktif)
										(SELECT '.$periode.', msag_no, msag_nm, msag_listmscb, msag_jenis, msag_kelompok, msag_salnorm, msag_aktif FROM ms_accgrp)';										

		// insert ms_accgrp to his_accgrp
		if($this->db->simple_query($query) == false){
			$err = 1;
			$err_msg = 'ERROR INSERT ms_accgrp TO his_accgrp';
		}								

		$query = 'INSERT INTO his_accsub(hsas_periode, hsas_no, hsas_nm, hsas_listmscb, hsas_salnorm, hsas_aktif)
								(SELECT '.$periode.', msas_no, msas_nm, msas_listmscb, msas_salnorm, msas_aktif FROM ms_accsub)';

		// insert ms_accsub to his_accsub
		if($this->db->simple_query($query) == false){
			$err = 1;
			$err_msg = 'ERROR INSERT ms_accsub TO his_accsub';
		}

		$query = 'INSERT INTO his_costcenter(hscc_periode,hscc_no,hscc_nm,hscc_listmscb,hscc_aktif,hscc_lsupd,hscc_lsusr,hscc_catatan)
					(SELECT '.$periode.', mscc_no,mscc_nm,mscc_listmscb,mscc_aktif,mscc_lsupd,mscc_lsusr,mscc_catatan FROM ms_costcenter)';

		// insert ms_costcenter to his_costcenter
		if($this->db->simple_query($query) == false){
			$err = 1;
			$err_msg = 'ERROR INSERT ms_costcenter TO his_costcenter';
		}

		return array('err'=>$err, 'err_msg' => $err_msg);								
	}

	// public function create_special_jurnal($periode){
	// 	$trju_kode_depan = "JA".substr($periode, 2, 2).substr($periode,4, 2).'_';
	// 	$day = cal_days_in_month(CAL_GREGORIAN, substr($periode,4, 2), substr($periode,0, 4));
	// 	$lbrg = $this->m_setting_account->get_setting_account_byid('LBRG');
	// 	$lbtb = $this->m_setting_account->get_setting_account_byid('LBTB');
	// 	$acc_special = array(1 => $lbrg['mssa_msap_no'], 2 => $lbtb['mssa_msap_no']);
	// 	$trju_no = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
	// 	$err = 0;
	// 	$err_msg = '';

	// 	// set data header jurnal				
	// 	$data['trju'] = array(					
	// 						'trju_no' 		=> $trju_no,
	// 						'trju_tgl' 		=> substr($periode, 0, 4).'-'.substr($periode,4, 2).'-'.$day,
	// 						'trju_tipe' 	=> 'A',
	// 						'trju_refno' 	=> '',													
	// 						'trju_reftipe' 	=> 'SJ',
	// 						'trju_msus_no' 	=> $this->session->userdata('user_aktif')['msus_no'],
	// 						'trju_mscb_no' 	=> $this->session->userdata('user_aktif')['msus_mscb_no'],
	// 						'trju_catatan' 	=> '',
	// 						'trju_fin' 		=> ($this->session->userdata('svlogin') == 'F') ? 'F' : 'C',
	// 						'trju_stcopy' 	=> 'A',
	// 						'trju_lscopy' 	=> '',
	// 						'trju_void' 	=> 0,
	// 						'trju_cekint' 	=> 1,
	// 						'trju_lsupd' 	=> date('Y-m-d H:i:s'),
	// 						'trju_lsusr' 	=> $this->session->userdata('user_aktif')['msus_no']
	// 						);

	// 	// insert data header jurnal
	// 	if($this->db->insert('tr_jurnal',$data['trju']) == false){
	// 		$err = 1;
	// 		$err_msg = 'ERROR CREATE HEADER JURNAL NO '. $trju_no;
	// 	}


	// 	foreach ($acc_special as $key => $value) {	
	// 		$query = 'INSERT INTO dt_jurnal(dtju_no, dtju_seq, dtju_msap_no, dtju_debet, dtju_kredit, dtju_catatan) 
	// 					VALUES("'.$trju_no.'",'.$key.', "'.$value.'", 0, 
	// 						IF(IFNULL((SELECT SUM(a.dtju_debet - a.dtju_kredit) FROM dt_jurnal a LEFT JOIN tr_jurnal ON trju_no = a.dtju_no LEFT JOIN ms_accgrp ON msag_no = SUBSTRING(a.dtju_msap_no, 1, 2) WHERE trju_void = 0 AND MONTH(trju_tgl)="'.substr($periode, 4,2).'" AND YEAR(trju_tgl)="'.substr($periode, 0,4).'" AND msag_jenis = "I" AND trju_reftipe <> "SJ"),0) < 0,
	// 						(-1 * IFNULL((SELECT SUM(a.dtju_debet - a.dtju_kredit) FROM dt_jurnal a LEFT JOIN tr_jurnal ON trju_no = a.dtju_no LEFT JOIN ms_accgrp ON msag_no = SUBSTRING(a.dtju_msap_no, 1, 2) WHERE trju_void = 0 AND MONTH(trju_tgl)="'.substr($periode, 4,2).'" AND YEAR(trju_tgl)="'.substr($periode, 0,4).'" AND msag_jenis = "I" AND trju_reftipe <> "SJ"),0)),
	// 						IFNULL((SELECT SUM(a.dtju_debet - a.dtju_kredit) FROM dt_jurnal a LEFT JOIN tr_jurnal ON trju_no = a.dtju_no LEFT JOIN ms_accgrp ON msag_no = SUBSTRING(a.dtju_msap_no, 1, 2) WHERE trju_void = 0 AND MONTH(trju_tgl)="'.substr($periode, 4,2).'" AND YEAR(trju_tgl)="'.substr($periode, 0,4).'" AND msag_jenis = "I" AND trju_reftipe <> "SJ"),0)), "")';

	// 		// insert data detail jurnal
	// 		if($this->db->simple_query($query) == false){
	// 			$err = 1;
	// 			$err_msg = 'ERROR CREATE DETAIL JURNAL NO '.  $trju_no;
	// 			break;
	// 		}
	// 	}

	// 	return array('err'=>$err, 'err_msg' => $err_msg);
	// }

	public function create_special_jurnal($periode, $mscb_no){
		$yyyy = substr($periode,0, 4);
		$mm = substr($periode,4, 2);
		$day = cal_days_in_month(CAL_GREGORIAN, $mm, $yyyy);
		$lbrg = $this->m_setting_account->get_setting_account_byid('LBRG');
		$lbtb = $this->m_setting_account->get_setting_account_byid('LBTB');			
		$trju_kode_depan = "JA".substr($periode, 2, 2).$mm.'-';		
		$trju_no = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);		
		$err = 0;
		$err_msg = '';
		$seq = 0;		

		// set data header jurnal				
		$data['trju'] = array(					
							'trju_no' 		=> $trju_no,
							'trju_tgl' 		=> $yyyy.'-'.$mm.'-'.$day,
							'trju_tipe' 	=> 'A',
							'trju_refno' 	=> '',													
							'trju_reftipe' 	=> 'SJ',
							'trju_msus_no' 	=> $this->session->userdata('user_aktif')['msus_no'],
							'trju_mscb_no' 	=> $mscb_no,
							'trju_catatan' 	=> '',
							'trju_fin' 		=> 'F',
							'trju_stcopy' 	=> 'A',
							'trju_lscopy' 	=> '',
							'trju_void' 	=> 0,
							'trju_cekint' 	=> 1,
							'trju_lsupd' 	=> date('Y-m-d H:i:s'),
							'trju_lsusr' 	=> $this->session->userdata('user_aktif')['msus_no']
							);

		// insert data header jurnal
		if($this->db->insert('tr_jurnal',$data['trju']) == false){
			$err = 1;
			$err_msg = 'ERROR CREATE HEADER JURNAL NO '. $trju_no;
		}

		// cek apakah bulan januari
		if($mm == '01'){
			$prev_date = date('Y-m-d', strtotime($yyyy.'-'.$mm.'-'.$day. 'first day of previous month'));
			$prev_yyyy = substr($prev_date,0, 4);
			$prev_mm = substr($prev_date,5, 2);
			$prev_periode = $prev_yyyy.$prev_mm;

			// query untuk mendapatkan saldo laba tahun berjalan periode sebelumnya
			$query_str = 'Select (a.hsap_debet - a.hsap_kredit) as saldo FROM his_accper a
							Where a.hsap_periode = "'.$prev_periode.'"
							And a.hsap_no ="'. $lbtb['mssa_msap_no']. '"
							And a.hsap_mscb_no ="'. $mscb_no. '"';

			$query_result = $this->db->query($query_str);
			if($query_result->num_rows() > 0){
				$saldo = $query_result->result_array()[0]['saldo'];
			}else{
				$saldo = 0;
			}

			if($saldo < 0){
				$saldoA = -1 * $saldo;
				$saldoB = 0;
			}else{
				$saldoA = 0;
				$saldoB = $saldo;
			}

			$seq += 1;

			$query_str = "INSERT INTO dt_jurnal(dtju_no, dtju_seq, dtju_msap_no, dtju_debet, dtju_kredit, dtju_catatan, dtju_cek) 
							VALUES('$trju_no', '$seq', '".$lbtb['mssa_msap_no']."', '$saldoA', '$saldoB', '', '')";
			if($this->db->simple_query($query_str) == false){
				$err = 1;
				$err_msg = 'ERROR CREATE DETAIL JURNAL NO '.  $trju_no;
				break;
			}

			$seq += 1;
			
			$query_str = "INSERT INTO dt_jurnal(dtju_no, dtju_seq, dtju_msap_no, dtju_debet, dtju_kredit, dtju_catatan, dtju_cek) 
							VALUES('$trju_no', '$seq', '".$lbrg['mssa_msap_no']."', '$saldoB', '$saldoA', '', '')";
			if($this->db->simple_query($query_str) == false){
				$err = 1;
				$err_msg = 'ERROR CREATE DETAIL JURNAL NO '.  $trju_no;
				break;
			}			
		}

		// query untuk mendapatkan saldo laba tahun berjalan
		$query_str = "SELECT round(SUM(a.dtju_debet - a.dtju_kredit), 4) as saldo
						FROM dt_jurnal a
						LEFT JOIN tr_jurnal ON trju_no = a.dtju_no
						LEFT JOIN ms_accgrp ON msag_no = SUBSTRING(a.dtju_msap_no, 1, 2)
						WHERE trju_void = 0
						AND MONTH(trju_tgl)='".$mm."' 
						AND YEAR(trju_tgl)='".$yyyy."' 
						AND trju_mscb_no ='".$mscb_no."' 
						AND msag_jenis = 'I' 
						AND trju_reftipe <> 'SJ'";

		$query_result = $this->db->query($query_str);
		if($query_result->num_rows() > 0){
			$saldo = $query_result->result_array()[0]['saldo'];
		}else{
			$saldo = 0;
		}

		if($saldo < 0){
			$saldoDebet = 0;
			$saldoKredit = -1 * $saldo;
		}else{
			$saldoDebet = $saldo;
			$saldoKredit = 0;
		}

		$seq += 1;

		$query_str = "INSERT INTO dt_jurnal(dtju_no, dtju_seq, dtju_msap_no, dtju_debet, dtju_kredit, dtju_catatan, dtju_cek) 
						VALUES('$trju_no','$seq','".$lbtb['mssa_msap_no']."','$saldoDebet','$saldoKredit','','')";		
				
		if($this->db->simple_query($query_str) == false){
			$err = 1;
			$err_msg = 'ERROR CREATE DETAIL JURNAL NO '.  $trju_no;
			break;
		}

		return array('err'=>$err, 'err_msg' => $err_msg);
	}


	/*
	public function insert_accper_tohis($periode){
		$err = 0;
		$err_msg = '';

		// variabel mundurin tanggal (untuk akumulasi nilai sebelumnya akun/grup yang jenis B)__________
		$thn = substr($periode, 0,4);
		$bln = substr($periode, 4,2);
		$prev_bln = (int)substr($periode, 4,2) - 1;			

		if($prev_bln < 1){
			$prev_bln = 12;
			$thn = (int)$thn - 1;
		}

		$prev_bln = sprintf("%'.02d", $prev_bln);
		$prev_periode = $thn.$prev_bln;
		//_____________________________________________________________________________

		// Query proses I
		$query = 'INSERT INTO his_accper (hsap_periode, hsap_no, hsap_nm, hsap_listmscb, hsap_aktif, hsap_debet, hsap_kredit)
										(SELECT "'.$periode.'",msap_no, msap_nm, msap_listmscb, msap_aktif,
												IFNULL((tbl1.dtju_debet),0),
												IFNULL((tbl1.dtju_kredit),0)
										FROM ms_accper 
										LEFT JOIN ms_accgrp ON msag_no = SUBSTRING(msap_no,1,2)
										LEFT JOIN
											(SELECT dtju_msap_no,
												IFNULL(SUM(dtju_debet),0) AS dtju_debet,
												IFNULL(SUM(dtju_kredit),0) AS dtju_kredit
											FROM dt_jurnal
											LEFT JOIN tr_jurnal ON dtju_no = trju_no
											WHERE MONTH(trju_tgl)="'.substr($periode, 4,2).'" AND YEAR(trju_tgl)="'.substr($periode, 0,4).'" AND trju_void = 0
											GROUP BY dtju_msap_no) AS tbl1 ON tbl1.dtju_msap_no = msap_no
										WHERE msag_jenis = "I"
										GROUP BY msap_no, msap_nm, msap_listmscb, msap_aktif
										)';									
		
		// insert data akun yang jenisnya I
		if($this->db->simple_query($query) == false){
			$err = 1;
			$err_msg = 'ERROR INSERT ACCOUNT (I)';			
		}

		// Qury proses B		
		$query = 'INSERT INTO his_accper (hsap_periode, hsap_no, hsap_nm, hsap_listmscb, hsap_aktif, hsap_debet, hsap_kredit)
										(SELECT "'.$periode.'",msap_no, msap_nm, msap_listmscb, msap_aktif,
															IFNULL((tbl1.dtju_debet),0) + IFNULL(x1.hsap_debet,0),
															IFNULL((tbl1.dtju_kredit),0) + IFNULL(x1.hsap_kredit,0)
										FROM ms_accper
										LEFT JOIN ms_accgrp ON msag_no = SUBSTRING(msap_no,1,2)
										LEFT JOIN
											(SELECT dtju_msap_no,
												IFNULL(SUM(dtju_debet),0) AS dtju_debet,
												IFNULL(SUM(dtju_kredit),0) AS dtju_kredit
											FROM dt_jurnal
											LEFT JOIN tr_jurnal ON dtju_no = trju_no
											WHERE  MONTH(trju_tgl)='.substr($periode, 4,2).' AND YEAR(trju_tgl)="'.substr($periode, 0,4).'" AND trju_void = 0
											GROUP BY dtju_msap_no) AS tbl1 ON tbl1.dtju_msap_no = msap_no
										LEFT JOIN his_accper x1 ON x1.hsap_no = msap_no AND x1.hsap_periode = "'.$prev_periode.'"
										WHERE msag_jenis = "B"
										GROUP BY msap_no, msap_nm, msap_listmscb, msap_aktif
										)';
		
		// insert data akun yang jenisnya B
		if($this->db->simple_query($query) == false){
			$err = 1;
			$err_msg = 'ERROR INSERT ACCOUNT (B)';			
		}

		return array('err'=>$err, 'err_msg' => $err_msg);
	}
	*/

	public function insert_accper_tohis($periode){
		$err = 0;
		$err_msg = '';

		// variabel mundurin tanggal (untuk akumulasi nilai sebelumnya akun/grup yang jenis B)__________
		$thn = substr($periode, 0,4);
		$bln = substr($periode, 4,2);
		$prev_bln = (int)substr($periode, 4,2) - 1;			

		if($prev_bln < 1){
			$prev_bln = 12;
			$thn = (int)$thn - 1;
		}

		$prev_bln = sprintf("%'.02d", $prev_bln);
		$prev_periode = $thn.$prev_bln;
		//_____________________________________________________________________________

		// STEP 1
		// PROSES INSERT DATA MASTER ms_accper KE temp_his_accper
		$query = "INSERT INTO temp_his_accper(
					hsap_periode,
					hsap_no,
					hsap_nm,
					hsap_debet,
					hsap_kredit,
					hsap_listmscb,
					hsap_aktif,
					hsap_mscb_no,
					hsap_mscc_no
					)
					(
					 SELECT '".$periode."', msap_no, msap_nm, 0, 0, msap_listmscb, msap_aktif, '', ''
					 FROM ms_accper 
					)";

		if($this->db->simple_query($query) == false){
			$err = 1;
			$err_msg = 'ERROR INSERT ACCOUNT FROM ms_accper TO temp_his_accper';			
		}		

		// STEP 2
		// PROSES INSERT DATA his_accper PERIODE SEBELUMNYA KE temp_his_accper
		// JIKA JENIS GROUP AKUNNYA 'B' MAKA NILAI DEBET/KREDITNYA NGANBIL DARI hsap_debet/hsap_kredit PERIODE SEBELUMNYA
		// JIKA JENIS GROUP AKUNNYA 'I' MAKA NILAI DEBET/KREDITNYA 0 (NOL). KARENA TIDAK DIAKUMULASI
		$query = "INSERT INTO temp_his_accper(
					hsap_periode,
					hsap_no,
					hsap_nm,
					hsap_debet,
					hsap_kredit,
					hsap_listmscb,
					hsap_aktif,
					hsap_mscb_no,
					hsap_mscc_no
					)
					(
					 SELECT '".$periode."', hsap_no, hsap_nm, IF(hsag_jenis = 'B', hsap_debet, 0), IF(hsag_jenis = 'B', hsap_kredit, 0), hsap_listmscb, hsap_aktif, hsap_mscb_no, hsap_mscc_no
					 FROM his_accper
					 LEFT JOIN his_accgrp ON hsag_no = SUBSTRING(hsap_no,1,2) and hsag_periode = '".$prev_periode."'					 
					 WHERE hsap_periode = '".$prev_periode."'
					)";

		if($this->db->simple_query($query) == false){			
			$err = 1;
			$err_msg = 'ERROR INSERT ACCOUNT FROM his_accper TO temp_his_accper';			
		}
		
		// STEP 3		
		// INSERT TRANSAKSI JURNAL / dt_jurnal KE temp_his_accper
		$query = "INSERT INTO temp_his_accper(
					hsap_periode,
					hsap_no,
					hsap_nm,
					hsap_debet,
					hsap_kredit,
					hsap_listmscb,
					hsap_aktif,
					hsap_mscb_no,
					hsap_mscc_no
					)
					(
						SELECT '".$periode."', dtju_msap_no, msap_nm, IFNULL(SUM(dtju_debet), 0), IFNULL(SUM(dtju_kredit), 0), msap_listmscb, msap_aktif, trju_mscb_no, dtju_mscc_no 
						FROM dt_jurnal
						LEFT JOIN tr_jurnal ON trju_no = dtju_no
						LEFT JOIN ms_accper ON msap_no = dtju_msap_no
						LEFT JOIN ms_accgrp ON msag_no = SUBSTRING(msap_no,1,2)
						WHERE MONTH(trju_tgl)='".substr($periode, 4,2)."' AND YEAR(trju_tgl)='".substr($periode, 0,4)."' 
						AND trju_void = 0						
						GROUP BY dtju_msap_no, msap_nm, trju_mscb_no, dtju_mscc_no						
					)";		
				
		if($this->db->simple_query($query) == false){
			$err = 1;
			$err_msg = 'ERROR INSERT ACCOUNT FROM dt_jurnal TO temp_his_accper';			
		}			

		// STEP 4
		// INSERT temp_his_accper KE his_accper
		$query = "INSERT INTO his_accper(
										hsap_periode,
										hsap_no,
										hsap_nm,
										hsap_debet,
										hsap_kredit,
										hsap_listmscb,
										hsap_aktif,
										hsap_mscb_no,
										hsap_mscc_no
										)
										(
											SELECT '".$periode."', t.hsap_no, t.hsap_nm, SUM(t.hsap_debet), SUM(t.hsap_kredit), t.hsap_listmscb, t.hsap_aktif, t.hsap_mscb_no, t.hsap_mscc_no 
											FROM temp_his_accper t
											WHERE t.hsap_periode = '".$periode."'
											GROUP BY t.hsap_periode, t.hsap_no, t.hsap_mscb_no, t.hsap_mscc_no
										)";

		if($this->db->simple_query($query) == false){			
			$err = 1;
			$err_msg = 'ERROR INSERT ACCOUNT FROM temp_his_accper TO his_accper';			
		}			

		return array('err'=>$err, 'err_msg' => $err_msg);
	}

	public function proses_perhitungan_bulanan($periode){
			$vok = true;
			$err = 0;
			$err_msg = '';
			
			if($vok){
				// clear data master acc
				$this->clear_hisacc($periode);					
			}	

			if($vok){
				// insert data master acc to his
				$hsl = $this->insert_grpsub_tohis($periode);
				if($hsl['err'] == 1){
					$vok = false;
					$err = 1;
					$err_msg = $hsl['err_msg'];
				}
			}
	
			if($vok){
				// create jurnal spesial
				$cabang = $this->m_cabang->get_all_cabang();
				foreach ($cabang as $key => $value) {
					$hsl = $this->create_special_jurnal($periode, $value['mscb_no']);
					if($hsl['err'] == 1){
						$vok = false;
						$err = 1;
						$err_msg = $hsl['err_msg'];
						break;
					}					
				}				
			}

			if($vok){
				// insert data akun yang jenisnya I dan B
				$hsl = $this->insert_accper_tohis($periode);
				if($hsl['err'] == 1){
					$vok = false;
					$err = 1;
					$err_msg = $hsl['err_msg'];
				}
			}

			return array('err'=>$err, 'err_msg' => $err_msg);
	}

	public function update_temp_periode_proteksi($periode){		
		// update tgl terakhir proteksi sementara
		$this->db->update('simrel', array('simr_char1' => $periode), array('simr_no' => 'tcj', 'simr_seq' => 1));

		if ($this->db->affected_rows() > 0 ) {
			return 1;
		}else{
			return 0;
		}
	}

	public function reset_temp_periode_proteksi(){
		$err = 0;
		$err_msg = '';

		$query = 'UPDATE simrel SET simr_char1 = simr_char2 WHERE simr_no = "tcj" AND simr_seq = 1';

		// reset tgl terakhir proteksi sementara = tgl last closing
		if($this->db->simple_query($query) == false){
			$err = 1;
			$err_msg = 'ERROR RESET TGL TERAKHIR PROTEKSI SEMENTARA';
		}

		return array('err'=>$err, 'err_msg' => $err_msg);
	}

	public function close_periode_berikutnya(){
		$err = 0;
		$err_msg = '';
		$lst_cls = $this->m_setting->get_setting('simr_char2','tcj', 1);
		$thn = substr($lst_cls, 0,4);
		$bln = substr($lst_cls, 4,2);		
		$dt = strtotime($thn.'-'.$bln);
		$lst_cls = date("Y-m", strtotime("+1 month", $dt));
		$lst_cls = str_replace('-', '', $lst_cls);		

		$query = 'UPDATE simrel SET simr_char2 = '.$lst_cls.' WHERE simr_no = "tcj" AND simr_seq = 1';

		// closing periode bulanan
		if($this->db->simple_query($query) == false){
			$err = 1;
			$err_msg = 'ERROR CLOSING PERIODE BULANAN';
		}

		return array('err'=>$err, 'err_msg' => $err_msg);
	}

}
