<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_jurnal extends MY_Model {

	public function get_jurnal_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trju_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('*');
		$this->db->from('tr_jurnal');

		$query_string = '';

		if(isset($arr_filter['msap_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_jurnal x1 WHERE x1.dtju_no = trju_no AND x1.dtju_msap_no LIKE "%'. $arr_filter['msap_no']. '%")';							
			unset($arr_filter['msap_no']);
		}

		if(isset($arr_filter['msap_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.* FROM dt_jurnal x2 LEFT JOIN ms_accper AS a ON a.msap_no = x2.dtju_msap_no WHERE x2.dtju_no = trju_no AND a.msap_nm LIKE "%'. $arr_filter['msap_nm']. '%")';
			unset($arr_filter['msap_nm']);
		}

		if(isset($arr_filter['dtju_catatan'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x3.* FROM dt_jurnal x3 WHERE x3.dtju_no = trju_no AND x3.dtju_catatan LIKE "%'. $arr_filter['dtju_catatan']. '%")';
			unset($arr_filter['dtju_catatan']);
		}

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_jurnal($trju_no){		
		$data = array();

		//Get jurnal header berdasarkan trju_no	
		$this->db->select('tr_jurnal.*, msus_no, msus_nm, mscb_no, mscb_nm');
		$this->db->from('tr_jurnal');		
		$this->db->join('ms_user','msus_no = trju_msus_no', 'left');
		$this->db->join('ms_cabang','mscb_no = trju_mscb_no', 'left');		
		$this->db->where('trju_no',$trju_no);
		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['jurnal_h'] = $result[0];
		}
		
		//Get jurnal detail berdasarkan trju_no	
		$this->db->select('dt_jurnal.*, msap_nm, mscc_nm');
		$this->db->from('dt_jurnal');
		$this->db->join('ms_accper', 'msap_no = dtju_msap_no','left');					
		$this->db->join('ms_costcenter', 'mscc_no = dtju_mscc_no','left');					
		$this->db->where('dtju_no',$trju_no);
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['jurnal_d'] = $detail;
		}
		if(count($data) > 0){
			return $data;
		}else{
			return false;
		}
	}

	public function is_recon_exists($trju_no){				
		$this->db->select('dtju_cek');
		$this->db->from('dt_jurnal');		
		$this->db->where('dtju_no',$trju_no);
		$this->db->where('dtju_cek','Y');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function get_jurnal_rekon($data){				
		$this->db->select('dt_jurnal.*,trju_no, trju_tipe, trju_refno, trju_catatan,
							(CASE								
								WHEN trju_reftipe = "SD" THEN "Sales Delivery"
								WHEN trju_reftipe = "DR" THEN "Sales Delivery - Reject"								
								WHEN trju_reftipe = "PY" THEN "SO Payment"
								WHEN trju_reftipe = "SR" THEN "Sales Return"
								WHEN trju_reftipe = "AS" THEN "Stock Adjustment"
								WHEN trju_reftipe = "GT" THEN "Goods Transformation"								
								WHEN trju_reftipe = "SP" THEN "SPK Penjualan"
								WHEN trju_reftipe = "SC" THEN "SPK COA"
								WHEN trju_reftipe = "PR" THEN "Purchase Return"
								WHEN trju_reftipe = "ID" THEN "Incoming Delivery"
								WHEN trju_reftipe = "AT" THEN "Aktiva Tetap"
								WHEN trju_reftipe = "PN" THEN "Penyusutan"
								WHEN trju_reftipe = "DA" THEN "Dispose Aktiva"
								WHEN trju_reftipe = "GC" THEN "Goods Convertion"
								WHEN trju_reftipe = "BK" THEN "Biaya Kirim (Incoming Delivery)"
								WHEN trju_reftipe = "BB" THEN "Bea (Incoming Delivery)"
								WHEN trju_reftipe = "PP" THEN "PO Payment"								
								WHEN trju_reftipe = "PK" THEN "SPK Payment"								
								WHEN trju_reftipe = "MD" THEN "Mutasi Delivery"
								WHEN trju_reftipe = "MR" THEN "Mutasi Receive"
								WHEN trju_reftipe = "SJ" THEN "Special Jurnal"
								WHEN trju_reftipe = "SK" THEN "Selisih Kurs"
								WHEN trju_reftipe = "PH" THEN "PPh 22 (Incoming Delivery)"
								WHEN trju_reftipe = "PS" THEN "PPN Shipping (Incoming Delivery)"
								ELSE trju_reftipe
							END) AS trju_reftipe,
							DATE_FORMAT(CONVERT(trju_tgl, date), "%d/%m/%Y") as trju_tgl,
							FORMAT(dtju_debet, 2) as dtju_debet,
							FORMAT(dtju_kredit, 2) as dtju_kredit');
		$this->db->from('dt_jurnal');
		$this->db->join('tr_jurnal', 'trju_no = dtju_no','left');					
		$this->db->join('ms_accper', 'msap_no = dtju_msap_no','left');
		$this->db->where('trju_void',0);
		$this->db->where('POSITION(trju_mscb_no in "'.$data['listmscb'].'")', null, false);

		if($data['dtju_msap_no'] != ''){
			$this->db->where('dtju_msap_no',$data['dtju_msap_no']);
		}

		if($data['trju_tgl_dari'] != '' && $data['trju_tgl_sampai'] != ''){
			$this->db->where('CONVERT(trju_tgl, DATE) >=', $data['trju_tgl_dari']);
			$this->db->where('CONVERT(trju_tgl, DATE) <=', $data['trju_tgl_sampai']);
		}

		if($data['status_cek'] != 'ALL'){
			if($data['status_cek'] == 'Y'){
				$this->db->where('dtju_cek','Y');
			}else{
				$this->db->where('dtju_cek !=','Y');
			}
		}

		if($data['tipe_jurnal'] != 'ALL'){
			$this->db->where('trju_tipe',$data['tipe_jurnal']);			
		}

		if($data['trju_refno'] != ''){
			$this->db->like('trju_refno',$data['trju_refno']);			
		}

		if($data['trju_catatan'] != ''){
			$this->db->like('trju_catatan',$data['trju_catatan']);			
			$this->db->or_like('dtju_catatan',$data['trju_catatan']);			
		}		

		$query = $this->db->get();						
		return $query->result_array();				
	}

	public function get_jurnalid($trju_refno){		
		$query = $this->db->get_where('tr_jurnal', array('trju_refno' => $trju_refno));		
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['trju_no'];			
		}else{
			return false;
		}
	}

	public function jurnal_kode_auto($trju_kode_depan){
		$this->db->select_max("trju_no");
		$this->db->like("trju_no", $trju_kode_depan, "after");
		$query = $this->db->get("tr_jurnal");
		if ($query->num_rows() == 0){
			return $trju_kode_depan. "00000001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trju_no'];
			$nomor = ((int) substr($kode, 7)) + 1;			
			return $trju_kode_depan. sprintf("%'.08d", $nomor);
		}
	}

	private function jurnal_isvalid_cekint($trju_no, $trju_cekint){		
		$query = $this->db->get_where('tr_jurnal', array('trju_no' => $trju_no, 'trju_cekint' => $trju_cekint));		
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}
	
	public function get_jurnal_cekint($trju_no, $trju_cekint){		
		$query = $this->db->get_where('tr_jurnal', array('trju_no' => $trju_no, 'trju_cekint' => $trju_cekint));				 
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_jurnal_cekint($trju_no){		
		//Update trju_cekint di tabel tr_jurnal
		$this->db->where('trju_no', $trju_no);
		$this->db->update('tr_jurnal', array('trju_cekint' => rand(0,10000)));
	}	

	public function jurnal_simpan($data){	
		try {

			if($data['action'] == 'NEW'){
				$this->simpan_data($data);
			}

			if($data['action'] == 'EDIT'){
				$this->update_data($data);
			}

			if($data['action'] == 'VOID'){
				$this->void_data($data);
			}

			if($data['action'] == 'STCOPY'){
				$this->db->where('trju_no', $data['header']['trju_no']);
				$this->db->update('tr_jurnal', array('trju_stcopy'=>$data['header']['trju_stcopy']));
			}

			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function jurnal_rekon_all_simpan($data){	
		try {					
				if(isset($data['detail'])){
					foreach ($data['detail'] as $key => $value) {																	
						if($data['detail'][$key]['dtju_cek'] != $data['detail'][$key]['dtju_cek_lm']){																								
							$this->db->where(array('dtju_no' => $data['detail'][$key]['dtju_no'], 'dtju_seq' => $data['detail'][$key]['dtju_seq']));
							$this->db->update('dt_jurnal', array('dtju_cek'=>$data['detail'][$key]['dtju_cek']));
						}
					}
				}

			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function jurnal_rekon_simpan($data){	
		try {									
				$this->db->where(array('dtju_no' => $data['dtju_no'], 'dtju_seq' => $data['dtju_seq']));
				$this->db->update('dt_jurnal', array('dtju_cek'=>$data['dtju_cek']));
			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	private function simpan_data($data){
		// Generate CekInt
		$data['header']['trju_cekint'] = rand(0,10000);

		//Insert data header jurnal
		$this->db->insert('tr_jurnal',$data['header']);

		//Insert data detail jurnal
		if(isset($data['detail'])){
			// for ($i=0; $i < count($data['detail']) ; $i++) {										
			//     $this->db->insert('dt_jurnal',$data['detail'][$i]);				    
			// }			
			foreach ($data['detail'] as $key => $value) {
				$this->db->insert('dt_jurnal',$data['detail'][$key]);
			}
		}			
	}

	private function update_data($data){
		// Generate CekInt
		$data['header']['trju_cekint'] = rand(0,10000);

		//Update data header jurnal
		$this->db->where('trju_no', $data['header']['trju_no']);
		$this->db->update('tr_jurnal', $data['header']);	
	
		//Delete data lama di tabel dt_jurnal sesuai trju_no
		$this->db->delete('dt_jurnal', array('dtju_no' => $data['header']['trju_no']));

		//Insert data detail jurnal
		if(isset($data['detail'])){
			// for ($i=0; $i < count($data['detail']) ; $i++) {										
			//     $this->db->insert('dt_jurnal',$data['detail'][$i]);				    
			// }	
			foreach ($data['detail'] as $key => $value) {
				$this->db->insert('dt_jurnal',$data['detail'][$key]);
			}		
		}			
	}	

	private function void_data($data){		
		$this->db->where('trju_no', $data['header']['trju_no']);
		$this->db->update('tr_jurnal', array('trju_cekint'=>rand(0,10000),'trju_void'=>1));											
	}

}
