<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_supplier extends MY_Model {

	public function get_supplier_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'mssp_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('*');
		$this->db->from('ms_supplier');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}

		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	/*public function supplier_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_supplier');		
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}*/	

	public function get_supplier($mssp_no){		
		$this->db->select('*');
		$this->db->from('ms_supplier');		
		$this->db->where('mssp_no',$mssp_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}
	

	public function get_suppliername($mssp_no, $mssp_nm){		
		$this->db->select('*');
		$this->db->from('ms_supplier');
		if($mssp_no === null){
			$this->db->where('mssp_nm',$mssp_nm);
		}else{
			$this->db->where('mssp_no !=',$mssp_no);
			$this->db->where('mssp_nm',$mssp_nm);
		}						
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function get_all_supplier(){				
		$query = $this->db->get('ms_supplier');
		return $query->result_array(); 					
	}	

	public function supplier_kode_auto($mssp_jenis){
		$this->db->select_max("mssp_no");
		$this->db->like("mssp_no", $mssp_jenis, "after");
		$query = $this->db->get("ms_supplier");
		if ($query->num_rows() == 0){
			return $mssp_jenis. "00001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['mssp_no'];
			$nomor = ((int) substr($kode, 1)) + 1;
			return $mssp_jenis. sprintf("%'.05d", $nomor);
		}
	}

	public function get_supplier_autocomplete($keyword){
		$this->db->select('*');
		$this->db->from('ms_supplier');				
		$this->db->like('mssp_no', $keyword);
		$this->db->or_like('mssp_nm', $keyword);
		$this->db->like('mssp_listmscb', $this->session->userdata('user_aktif')['msus_mscb_no']);
		$this->db->like('mssp_aktif', 1);				
		$query = $this->db->get();
		return $query->result_array();				
	}	

	public function supplier_simpan($data){						
		try{			
			$this->db->insert('ms_supplier',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function supplier_edit_simpan($data){						
		try{
			$this->db->where('mssp_no', $data['mssp_no']);
			$this->db->update('ms_supplier', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function supplier_aktif_simpan($data){						
		try{
			$mssp_aktif = ($data['mssp_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('mssp_no' => $data['mssp_no']));
			$this->db->update('ms_supplier', array('mssp_aktif' => $mssp_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	


	
}
