<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_sales extends MY_Model {

	public function get_sales_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'mssl_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];	

		$this->db->select('*');
		$this->db->from('ms_sales');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	/*public function sales_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_sales');		
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}*/	

	public function get_sales($mssl_no){		
		$this->db->select('*');
		$this->db->from('ms_sales');		
		$this->db->where('mssl_no',$mssl_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_salesno($mssl_no){		
		$this->db->select('mssl_no');
		$this->db->from('ms_sales');		
		$this->db->where('mssl_no',$mssl_no);		
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function get_salesnm($mssl_no, $mssl_nm){		
		$this->db->select('*');
		$this->db->from('ms_sales');
		if($mssl_no === null){
			$this->db->where('mssl_nm',$mssl_nm);
		}else{
			$this->db->where('mssl_no !=',$mssl_no);
			$this->db->where('mssl_nm',$mssl_nm);
		}						
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function get_all_sales(){				
		$query = $this->db->get('ms_sales');
		return $query->result_array(); 					
	}	

	public function sales_new_simpan($data){						
		try{			
			$this->db->insert('ms_sales',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function sales_edit_simpan($data){						
		try{
			$this->db->where('mssl_no', $data['mssl_no']);
			$this->db->update('ms_sales', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function sales_aktif_simpan($data){						
		try{
			$mssl_aktif = ($data['mssl_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('mssl_no' => $data['mssl_no']));
			$this->db->update('ms_sales', array('mssl_aktif' => $mssl_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}		
}
