<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_produk extends MY_Model {

	public function get_produk_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'mspd_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];		
		
		$this->db->select('*');
		$this->db->from('ms_produk');				
		$this->db->join('ms_supplier', 'ms_produk.mspd_mssp_no = ms_supplier.mssp_no','left');
		$this->db->join('ms_merk', 'ms_produk.mspd_msmr_no = ms_merk.msmr_no','left');
		$this->db->join('ms_famili', 'ms_famili.msfm_no = SUBSTRING(ms_produk.mspd_no,1,3)','left');
		$this->db->join('ms_model', 'ms_model.msmd_no = SUBSTRING(ms_produk.mspd_no,1,6)','left');
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_produk.mspd_no,1,1)','left');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);
		
		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}

		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	/*public function produk_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_produk');
		$this->db->join('ms_supplier', 'ms_produk.mspd_mssp_no = ms_supplier.mssp_no','left');
		$this->db->join('ms_merk', 'ms_produk.mspd_msmr_no = ms_merk.msmr_no','left');				
		$this->db->join('ms_famili', 'ms_famili.msfm_no = SUBSTRING(ms_produk.mspd_no,1,3)','left');
		$this->db->join('ms_model', 'ms_model.msmd_no = SUBSTRING(ms_produk.mspd_no,1,6)','left');
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}*/

	public function get_produk($mspd_no){		
		$this->db->select('*');
		$this->db->from('ms_produk');	
		$this->db->join('ms_kategori','mskt_no = SUBSTRING(mspd_no, 1, 1)','left');			
		$this->db->where('mspd_no',$mspd_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		$data['produk'] = $result[0];

		$this->db->select('*');
		$this->db->from('md_paket_prod');				
		$this->db->join('ms_produk','mspd_no = mdpp_mspd_no','left');		
		$this->db->where('mdpp_no',$mspd_no);		
		$query = $this->db->get();						
		if($query->num_rows() > 0){
			$data['paket'] = $query->result_array();
		}

		return $data;
	}

	public function get_produk_gambar_info($mspd_no){		
		$data = array();
		$this->db->select('ms_produk.*, msmr_nm');
		$this->db->join('ms_merk', 'msmr_no = mspd_msmr_no', 'left');
		$this->db->from('ms_produk');				
		$this->db->where('mspd_no',$mspd_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		$data['produk'] = $result[0];

		return $data;
	}

	public function get_produkno($mspd_no){		
		$this->db->select('mspd_no');
		$this->db->from('ms_produk');		
		$this->db->where('mspd_no',$mspd_no);		
		$query = $this->db->get();						
		return $query->num_rows();
	}			

	public function get_produk_autocomplete($data){
		$this->db->select('*');
		$this->db->from('ms_produk');
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_produk.mspd_no,1,1)','left');					
		$this->db->like($data['input_name'], $data['keyword']);
		$this->db->like('mspd_listmscb', $this->session->userdata('user_aktif')['msus_mscb_no']);
		$this->db->where(array('mspd_aktif' => 1));
		
		if($data['mskt_statusinv'] == 'Y' || $data['mskt_statusinv'] == 'N'){
			$this->db->where(array('mskt_statusinv'=>$data['mskt_statusinv']));				
		}

		if($data['mspd_reqserialno'] == 'Y' || $data['mspd_reqserialno'] == 'N'){
			$this->db->where(array('mspd_reqserialno'=>$data['mspd_reqserialno']));				
		}		

		if($data['mskt_showinspk'] == 'Y' || $data['mskt_showinspk'] == 'N'){
			$this->db->where(array('mskt_showinspk'=>$data['mskt_showinspk']));
		}		

		if($data['mspd_paket'] == 'Y' || $data['mspd_paket'] == 'N'){
			$this->db->where(array('mspd_paket'=>$data['mspd_paket']));
		}		

		if($data['mspd_fin'] == 'F' || $data['mspd_fin'] == 'C'){
			$this->db->where(array('mspd_fin'=>$data['mspd_fin']));
		}		

		$query = $this->db->get();
		return $query->result_array();				
	}

	public function get_produk_fortrash_autocomplete($keyword){
		$this->db->select('mspd_no, mspd_nm');
		$this->db->from('ms_produk');
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_produk.mspd_no,1,1)','left');					
		$this->db->where('mspd_aktif', 1);
		$this->db->where('mskt_statusinv', 'Y');			
		$this->db->where('mspd_paket', 'N');			
		$this->db->where('mspd_fin', 'F');							
		$this->db->like('mspd_no', $keyword);
		$this->db->or_like('mspd_nm', $keyword);		
		$query = $this->db->get();
		return $query->result_array();				
	}

	// public function get_produkstok_autocomplete($data){		
	// 	$this->db->select('ms_produk.*,IFNULL((msst_qty),0) AS msst_qty');
	// 	$this->db->from('ms_produk');						
	// 	$this->db->join('ms_stok','msst_mspd_no = mspd_no AND msst_msgd_no = "'. $data['msgd_no']. '"','left');		
	// 	$this->db->like($data['input_name'], $data['keyword']);
	// 	$this->db->like('mspd_listmscb', $this->session->userdata('user_aktif')['msus_mscb_no']);
	// 	$this->db->like('mspd_aktif', 1);				
	// 	$query = $this->db->get();
	// 	return $query->result_array();				
	// }		

	public function get_produkstok($data, $msgd_no){		
		$this->db->select('ms_produk.*,IFNULL((msst_qty),0) AS msst_qty');
		$this->db->from('ms_produk');						
		$this->db->join('ms_stok','msst_mspd_no = mspd_no AND msst_msgd_no = "'. $msgd_no. '"','left');		
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_produk.mspd_no,1,1)','left');
		$this->db->where_in('mspd_no', $data);
		$this->db->like('mspd_listmscb', $this->session->userdata('user_aktif')['msus_mscb_no']);
		$this->db->where(array('mspd_aktif' => 1));				
		$query = $this->db->get();
		return $query->result_array();
	}

	public function avaliable_stock_query(){
		$this->load->model('data_master/m_cabang');		
		$mscb_listmsgd = $this->m_cabang->get_mscb_listmsgd($this->session->userdata('user_aktif')['msus_mscb_no']);

		if($mscb_listmsgd != ''){
			$mscb_listmsgd = "'".str_replace(",", "','", $mscb_listmsgd)."'";
			$total_query_y = " IFNULL((SELECT SUM(msst_qty) FROM ms_stok LEFT JOIN ms_gudang ON msgd_no = msst_msgd_no WHERE msst_mspd_no = mspd_no AND msst_msgd_no IN(". $mscb_listmsgd .")),0)";
		}
		else{

			$this->db->select('*');
			$this->db->from('ms_gudang');		
			$this->db->like(array('msgd_listmscb' => $this->session->userdata('user_aktif')['msus_mscb_no'], 'msgd_aktif'=>1));
			$query = $this->db->get();
			$gudang = $query->result_array(); 
					
			$total_query_y = "";		

			if(count($gudang) > 0){
				foreach ($gudang as $key => $value) {
					if($gudang[$key]['msgd_avl'] == 'Y'){
						$gudang_query = " IFNULL((SELECT SUM(msst_qty) FROM ms_stok INNER JOIN ms_gudang ON msgd_no = msst_msgd_no AND msgd_avl = 'Y' WHERE msst_mspd_no = mspd_no AND msst_msgd_no = '". $gudang[$key]['msgd_no'] ."'),0)";

						if($total_query_y != ""){
							$total_query_y .= " + ";
						}

						$total_query_y .= $gudang_query;
					}
				}				
			}else{
				$total_query_y .= " IFNULL((SELECT SUM(msst_qty) FROM ms_stok INNER JOIN ms_gudang ON msgd_no = msst_msgd_no AND msgd_avl = 'Y' WHERE msst_mspd_no = mspd_no AND msst_msgd_no = 'GUDANG_BELUM_ADA'),0)";
			}
		}							

		$so_dekat_locky = " IFNULL((SELECT SUM(dtso_qtysd - dtso_qtykirim) FROM dt_so LEFT JOIN tr_so ON trso_no = dtso_no WHERE trso_void = 0 AND trso_lock='Y' AND trso_mscb_no LIKE '%". $this->session->userdata('user_aktif')['msus_mscb_no'] ."%' AND DATEDIFF(trso_tglestkirim,'". date('Y-m-d') ."') <= 120 AND dtso_mspd_no = mspd_no),0)";
		$so_dekat_lockn = " IFNULL((SELECT SUM(dtso_qty - dtso_qtykirim) FROM dt_so LEFT JOIN tr_so ON trso_no = dtso_no WHERE trso_void = 0 AND trso_lock='N' AND trso_mscb_no LIKE '%". $this->session->userdata('user_aktif')['msus_mscb_no'] ."%' AND DATEDIFF(trso_tglestkirim,'". date('Y-m-d') ."') <= 120 AND dtso_mspd_no = mspd_no),0)";
		$so_dekat_query = $so_dekat_lockn. '+'. $so_dekat_locky;
		
		$mutasi_out_query = " IFNULL((SELECT SUM(dtmt_qtyout - dtmt_qtyin)"
								 ." FROM dt_mutasi"
								 ." LEFT JOIN tr_mutasi ON trmt_no = dtmt_no"
								 ." LEFT JOIN ms_gudang ON msgd_no = trmt_msgd_no1"
								 ." WHERE trmt_void = 0"
								 ." AND trmt_tglkirim = '0000-00-00'"
								 ." AND dtmt_mspd_no = mspd_no"
								 ." AND dtmt_stapv = 'N'" 
								 ." AND msgd_listmscb LIKE '%".$this->session->userdata('user_aktif')['msus_mscb_no']."%'), 0) ";			

		//query field avaliable stock
		$avaliable_stock_query = $total_query_y. " - (". $so_dekat_query. " + ". $mutasi_out_query. ") ";
		return $avaliable_stock_query;
	}		

	public function get_produk_avaliablestock($data){			
		$sql = 'ms_produk.*,';
		$avaliable_stock_query = $this->avaliable_stock_query();

		$sql .= $avaliable_stock_query." AS 'mspd_qtyavl', mskt_statusinv";
		
		$this->db->select($sql);
		$this->db->from('ms_produk');			
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_produk.mspd_no,1,1)','left');					
		$this->db->join('ms_cabang', 'ms_cabang.mscb_no = "'.$this->session->userdata('user_aktif')['msus_mscb_no'].'"','left');					
		$this->db->where_in('mspd_no', $data);
		$this->db->like('mspd_listmscb', $this->session->userdata('user_aktif')['msus_mscb_no']);
		$this->db->where(array('mspd_aktif' => 1));				
		$query = $this->db->get();
		return $query->result_array();
	}

	public function get_produk_wip_po($data){		
		$sql = 'ms_produk.*,';
		$wip_po_locky = " IFNULL((SELECT SUM(dtpo_qtyid - dtpo_qtyterima) FROM dt_po LEFT JOIN tr_po ON tr_po.trpo_no=dt_po.dtpo_no WHERE trpo_void = 0 AND trpo_lock='Y' AND trpo_mscb_no LIKE '%".$this->session->userdata('user_aktif')['msus_mscb_no']."%' AND dtpo_mspd_no = mspd_no),0) ";
		$wip_po_lockn = " IFNULL((SELECT SUM(dtpo_qty - dtpo_qtyterima) FROM dt_po LEFT JOIN tr_po ON tr_po.trpo_no=dt_po.dtpo_no WHERE trpo_void = 0 AND trpo_lock='N' AND trpo_mscb_no LIKE '%".$this->session->userdata('user_aktif')['msus_mscb_no']."%' AND dtpo_mspd_no = mspd_no),0) ";
		$wip_po_query = $wip_po_lockn. '+'. $wip_po_locky;

		$sql .= $wip_po_query. " AS 'mspd_qty_wip_po', mskt_statusinv";
		
		$this->db->select($sql);
		$this->db->from('ms_produk');			
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_produk.mspd_no,1,1)','left');					
		$this->db->where_in('mspd_no', $data);
		$this->db->like('mspd_listmscb', $this->session->userdata('user_aktif')['msus_mscb_no']);
		$this->db->where(array('mspd_aktif' => 1));				
		$query = $this->db->get();
		return $query->result_array();
	}	


	public function get_all_produk(){				
		$query = $this->db->get('ms_produk');
		return $query->result_array(); 					
	}			

	public function produk_kode_auto($msmd_no){
		$this->db->select_max("mspd_no");
		$this->db->like("mspd_no", $msmd_no, "after");
		$query = $this->db->get("ms_produk");
		if ($query->num_rows() == 0){
			return $msmd_no. "001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['mspd_no'];
			$nomor = ((int) substr($kode, 6)) + 1;
			return $msmd_no. sprintf("%'.03d", $nomor);
		}
	}

	public function produk_simpan($data){				
		try{			
			if($data['action'] == 'NEW'){
				$this->db->insert('ms_produk',$data['ms']);
				if($data['ms']['mspd_paket'] == 'Y'){				
					foreach ($data['md'] as $key => $value) {					
						$this->db->insert('md_paket_prod',$data['md'][$key]);
					}
				}
			}

			if($data['action'] == 'EDIT'){
				$this->db->where('mspd_no', $data['ms']['mspd_no']);
				$this->db->update('ms_produk', $data['ms']);
			}
			return 1;
		}catch (Exception $e) {
			return 0;
		}		
	}

	public function produk_aktif_simpan($data){						
		try{
			$mspd_aktif = ($data['mspd_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('mspd_no' => $data['mspd_no']));
			$this->db->update('ms_produk', array('mspd_aktif' => $mspd_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function get_hpp($mspd_no){
		$query = $this->db->get_where('ms_produk', array('mspd_no'=>$mspd_no));
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['mspd_hpp'];
		}else{
			return 0;
		}
	}

	public function get_jlh_garansi($mspd_no, $field_garansi){
		$query = $this->db->get_where('ms_produk', array('mspd_no'=>$mspd_no));
		if($query->num_rows() > 0){
			$result = $query->result_array();			
			return $result[0][$field_garansi];
		}else{
			return 0;
		}
	}
	
}
