<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_model extends MY_Model {

	public function get_model_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msmd_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('*');
		$this->db->from('ms_model');		
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_model.msmd_no,1,1)','left');
		$this->db->join('ms_famili', 'ms_famili.msfm_no = SUBSTRING(ms_model.msmd_no,1,3)','left');
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	/*public function model_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_model');
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_model.msmd_no,1,1)','left');
		$this->db->join('ms_famili', 'ms_famili.msfm_no = SUBSTRING(ms_model.msmd_no,1,3)','left');
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}	*/

	public function get_model($msmd_no){		
		$this->db->select('*');
		$this->db->from('ms_model');		
		$this->db->where('msmd_no',$msmd_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_modelno($msmd_no){		
		$this->db->select('msmd_no');
		$this->db->from('ms_model');		
		$this->db->where('msmd_no',$msmd_no);		
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function get_all_model(){				
		$query = $this->db->get('ms_model');
		return $query->result_array(); 					
	}	

	public function model_new_simpan($data){						
		try{			
			$this->db->insert('ms_model',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function model_edit_simpan($data){						
		try{
			$this->db->where('msmd_no', $data['msmd_no']);
			$this->db->update('ms_model', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function model_aktif_simpan($data){						
		try{
			$msmd_aktif = ($data['msmd_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('msmd_no' => $data['msmd_no']));
			$this->db->update('ms_model', array('msmd_aktif' => $msmd_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}		
	
}
