<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_gudang extends MY_Model {

	public function get_gudang_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msgd_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('*');
		$this->db->from('ms_gudang');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}

		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}

	/*public function gudang_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_gudang');		
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}*/	

	public function get_gudang($msgd_no){		
		$this->db->select('*');
		$this->db->from('ms_gudang');		
		$this->db->where('msgd_no',$msgd_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_all_gudang(){				
		$query = $this->db->get('ms_gudang');
		return $query->result_array(); 					
	}	

	public function get_gudangnm($msgd_no, $msgd_nm){		
		$this->db->select('*');
		$this->db->from('ms_gudang');
		if($msgd_no === null){
			$this->db->where('msgd_nm',$msgd_nm);
		}else{
			$this->db->where('msgd_no !=',$msgd_no);
			$this->db->where('msgd_nm',$msgd_nm);
		}						
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function gudang_count_all(){		
		$num_rows = $this->db->count_all('ms_gudang');				
		// $num_rows = $this->db->where(['msgd_aktif'=>1])->from("ms_gudang")->count_all_results();		
		return $num_rows;
	}

	public function gudang_kode_auto(){
		$this->db->select_max("msgd_no");
		$query = $this->db->get("ms_gudang");
		if ($query->num_rows() == 0){
			return "G01";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['msgd_no'];
			$nomor = ((int) substr($kode, 1)) + 1;
			return "G".sprintf("%'.02d", $nomor);
		}
	}

	public function gudang_new_simpan($data){						
		try{			
			$this->db->insert('ms_gudang',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function gudang_edit_simpan($data){						
		try{
			$this->db->where('msgd_no', $data['msgd_no']);
			$this->db->update('ms_gudang', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function gudang_aktif_simpan($data){						
		try{
			$msgd_aktif = ($data['msgd_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('msgd_no' => $data['msgd_no']));
			$this->db->update('ms_gudang', array('msgd_aktif' => $msgd_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}

	public function get_nama_gudang($msgd_no){						
		$this->db->select('msgd_nm');
		$this->db->from('ms_gudang');		
		$this->db->where('msgd_no',$msgd_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0]['msgd_nm'];
	}	
	
}
