<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_costcenter extends MY_Model {	

	public function get_costcenter_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'mscc_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('*');
		$this->db->from('ms_costcenter');				
		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}				
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_costcenter($mscc_no){		
		$data = array();
		
		$this->db->select('*');
		$this->db->from('ms_costcenter');				
		$this->db->where('mscc_no',$mscc_no);		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();			
			$data['data'] = $result[0];
		}	

		return $data;	
	}

	public function is_mscc_nm_exists($mscc_nm, $mscc_no=null){										
		$this->db->select('mscc_nm');
		$this->db->from('ms_costcenter');	
		if($mscc_no == null){
			$this->db->where('mscc_nm',$mscc_nm);
		}else{
			$this->db->where('mscc_nm',$mscc_nm);
			$this->db->where('mscc_no !=',$mscc_no);
		}
		$query = $this->db->get();		
		if($query->num_rows() > 0){
			return true;			
		}else{
			return false;			
		}		
	}

	public function is_mscc_no_exists($mscc_no){										
		$this->db->select('mscc_no');
		$this->db->from('ms_costcenter');			
		$this->db->where('mscc_no',$mscc_no);		
		$query = $this->db->get();		
		if($query->num_rows() > 0){			
			return true;			
		}else{			
			return false;			
		}		
	}	

	public function costcenter_simpan($data){						
		try{						
			if($data['action'] == 'NEW'){
				$this->db->insert('ms_costcenter',$data['ms']);			
			}

			if($data['action'] == 'EDIT'){				
				$this->db->where('mscc_no', $data['ms']['mscc_no']);
				$this->db->update('ms_costcenter', $data['ms']);
			}

			if($data['action'] == 'LOCK'){				
				$query = "UPDATE ms_costcenter SET mscc_aktif = IF(mscc_aktif = 0, 1, 0)
							WHERE mscc_no = '".$data['ms']['mscc_no']."'";
				$this->db->simple_query($query);
			}
			
			return 1;			 								
		}catch (Exception $e) {
			return 0;
		}		
	}		

	public function get_costcenter_fromtrju($data){
		$query = 'SELECT * FROM ms_costcenter
					WHERE (mscc_aktif = 1 OR mscc_no IN (SELECT dtju_mscc_no FROM dt_jurnal WHERE dtju_no = "'.$data['trju_no'].'"))
					AND (mscc_no LIKE "%'.$data['keyword'].'%" OR mscc_nm LIKE "%'.$data['keyword'].'%")
					AND mscc_listmscb LIKE "%'.$this->session->userdata('user_aktif')['msus_mscb_no'].'%"';

		$result = $this->db->query($query);
		return $result->result_array();				
	}
	
}
