<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_cabang extends MY_Model {

	public function get_cabang_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'mscb_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('*');
		$this->db->from('ms_cabang');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}

	public function get_cabang($mscb_no){		
		$this->db->select('*');
		$this->db->from('ms_cabang');		
		$this->db->where('mscb_no',$mscb_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_all_cabang(){		
		$query = $this->db->get('ms_cabang');
		return $query->result_array(); 					
	}

	public function get_cabang_aktif_only(){				
		//$this->db->select('*');
		//$this->db->from('ms_cabang');
		// $this->db->where('mscb_aktif','1');	
		$query = $this->db->get('ms_cabang');
		return $query->result_array(); 					
	}

	public function get_cabangno($mscb_no){		
		$this->db->select('mscb_no');
		$this->db->from('ms_cabang');		
		$this->db->where('mscb_no',$mscb_no);		
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function get_cabangnm($mscb_no, $mscb_nm){		
		$this->db->select('*');
		$this->db->from('ms_cabang');
		if($mscb_no === null){
			$this->db->where('mscb_nm',$mscb_nm);
		}else{
			$this->db->where('mscb_no !=',$mscb_no);
			$this->db->where('mscb_nm',$mscb_nm);
		}						
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function cabang_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_cabang');		
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}

	public function cabang_new_simpan($data){						
		try{			
			$this->db->insert('ms_cabang',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function cabang_edit_simpan($data){						
		try{
			$this->db->where('mscb_no', $data['mscb_no']);
			$this->db->update('ms_cabang', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function cabang_aktif_simpan($data){						
		try{
			$mscb_aktif = ($data['mscb_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('mscb_no' => $data['mscb_no']));
			$this->db->update('ms_cabang', array('mscb_aktif' => $mscb_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}

	public function get_mscb_listmsgd($mscb_no){
		$query = $this->db->get_where('ms_cabang', array('mscb_no' => $mscb_no));		
		$result = $query->result_array();
		return $result[0]['mscb_listmsgd'];
	}	
	
	public function get_mscb_nm($mscb_no){		
		$this->db->select('mscb_nm');
		$this->db->from('ms_cabang');		
		$this->db->where('mscb_no',$mscb_no);
		$query = $this->db->get();						

		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['mscb_nm'];
		}else{
			return '';
		}
	}
}
