<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_acc_sub extends MY_Model {

	public function get_acc_sub_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msas_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];	

		$this->db->select('*');
		$this->db->from('ms_accsub');		
		$this->db->join('ms_accgrp', 'ms_accgrp.msag_no = SUBSTRING(ms_accsub.msas_no,1,2)','left');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}

	/*public function acc_sub_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_accsub');		
		$this->db->join('ms_accgrp', 'ms_accgrp.msag_no = SUBSTRING(ms_accsub.msas_no,1,2)','left');
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}	*/	

	public function get_acc_sub($msas_no){		
		$this->db->select('*');
		$this->db->from('ms_accsub');		
		$this->db->where('msas_no',$msas_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_acc_subno($msas_no){		
		$this->db->select('msas_no');
		$this->db->from('ms_accsub');		
		$this->db->where('msas_no',$msas_no);		
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function get_all_acc_sub(){				
		$query = $this->db->get('ms_accsub');
		return $query->result_array(); 					
	}

	public function get_acc_subnm($msas_no, $msas_nm){
		$this->db->select('*');
		$this->db->from('ms_accsub');
		if($msas_no === null){
			$this->db->where('msas_nm',$msas_nm);
		}else{
			$this->db->where('msas_no !=',$msas_no);
			$this->db->where('msas_nm',$msas_nm);
		}						
		$query = $this->db->get();						
		return $query->num_rows();
	}	

	public function acc_sub_new_simpan($data){						
		try{			
			$this->db->insert('ms_accsub',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function acc_sub_edit_simpan($data){						
		try{
			$this->db->where('msas_no', $data['msas_no']);
			$this->db->update('ms_accsub', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function acc_sub_aktif_simpan($data){						
		try{
			$msas_aktif = ($data['msas_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('msas_no' => $data['msas_no']));
			$this->db->update('ms_accsub', array('msas_aktif' => $msas_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}

	public function get_acc_sub_autocomplete($keyword){		
		$this->db->select('*');
		$this->db->from('ms_accsub');				
		$this->db->like('msas_no', $keyword);
		$this->db->or_like('msas_nm', $keyword);
		$this->db->like('msas_listmscb', $this->session->userdata('user_aktif')['msus_mscb_no']);
		$this->db->like('msas_aktif', 1);				
		$query = $this->db->get();
		return $query->result_array();				
	}		
	
}
