<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class usergroup extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_usergroup');
		$this->load->library('pagination');
	}

	public function index(){				
		if(!fcek_hak_akses('.AL0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/usergroup/v_usergroup_list', $data);
		$this->load->view('v_footer');			
	}

	public function usergroup_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'usergroup');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['usergroup_list'] = $this->m_usergroup->get_usergroup_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['usergroup_list']);
		}
		else {
			$pagination['total_list'] = $this->m_usergroup->get_usergroup_list($arr_filter, true);		
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['usergroup_list'] = $this->load->view('data_master/usergroup/v_usergroup_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function usergroup_new($msgd_no=NULL){	
		if(!fcek_hak_akses('.AL1.')) {
			redirect('forbidden');
		}

		$data = array();
		
		$jml = $this->db->get('ms_gudang');

		//pengaturan pagination
		 $config['base_url'] = '#';
		 $config['total_rows'] = $jml->num_rows();
		 $config['per_page'] = '15';
		 $config['first_page'] = 'Awal';
		 $config['last_page'] = 'Akhir';

		//inisialisasi config
		 $this->pagination->initialize($config);

		//buat pagination
		 $data['halaman'] = $this->pagination->create_links();

		//tamplikan data
		 $data['detail'] = $this->m_usergroup->get_gudang($config['per_page'], $msgd_no);
	
		// $data['detail'] = $this->m_usergroup->get_gudang();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/usergroup/v_usergroup_form',$data);
		$this->load->view('v_footer');		
	}

	public function usergroup_view($msug_no, $msgd_no=NULL){	
		if(!fcek_hak_akses('.AL0.')) {
			redirect('forbidden');
		}

		if (is_null($msug_no) || count($this->m_usergroup->get_usergroup($msug_no)) <= 0) {
			redirect('usergroup');
			return;
		}
		$data = array();
		
		$jml = $this->db->get('ms_gudang');

		//pengaturan pagination
		 $config['base_url'] = base_url().'usergroup/usergroup_new';
		 $config['total_rows'] = $jml->num_rows();
		 $config['per_page'] = '15';
		 $config['first_page'] = 'Awal';
		 $config['last_page'] = 'Akhir';

		//inisialisasi config
		 $this->pagination->initialize($config);

		//buat pagination
		 $data['halaman'] = $this->pagination->create_links();

		//tamplikan data
		 $data['detail'] = $this->m_usergroup->get_gudang($config['per_page'], $msgd_no);
		// $data['detail'] = $this->m_usergroup->get_gudang();
		$data['action'] = 'view';		
		$data['usergroup'] = $this->m_usergroup->get_usergroup($msug_no);
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/usergroup/v_usergroup_form',$data);
		$this->load->view('v_footer');		
	}

	public function usergroup_new_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'usergroup');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		$jml = $this->db->get('ms_gudang');

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{					
			$data = array();				
			$data['msug_no'] = $this->m_usergroup->usergroup_kode_auto();
			$data['msug_nm'] = fhapus_kutip($this->input->post('msug_nm'));							
			$data['msug_hakakses'] = (($this->input->post('hak_akses') != '') ? ".". implode('.', $this->input->post('hak_akses')). "." : '');
			$data['msug_aktif'] = 1; //(($this->input->post('msug_aktif') == 'on') ? 1 : 0);			
			$data['msug_catatan'] = fhapus_kutip($this->input->post('msug_catatan'));
			$data['msug_lsupd'] = date('Y-m-d H:i:s');
			$data['msug_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
								
			if($this->m_usergroup->usergroup_simpan($data)){
				$this->session->set_userdata('alert_sukses','sukses');
				$result['response'] = 'sukses';				
	  	 		$result['msug_no'] = $data['msug_no'];	      	 		
	  	 		echo json_encode($result);
			}						
		}				        
	}

	public function usergroup_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'usergroup');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{			
         	$data = array();		
			$data['msug_no'] = $this->input->post('msug_no');
			$data['msug_nm'] = fhapus_kutip($this->input->post('msug_nm'));				
			$data['msug_hakakses'] = (($this->input->post('hak_akses') != '') ? ".". implode('.', $this->input->post('hak_akses')). "." : '');						
			$data['msug_catatan'] = fhapus_kutip($this->input->post('msug_catatan'));
			//$data['msug_aktif'] = (($this->input->post('msug_aktif') == 'on') ? 1 : 0);			
			$data['msug_lsupd'] = date('Y-m-d H:i:s');
			$data['msug_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
								
			if($this->m_usergroup->usergroup_edit_simpan($data)){	
				$this->session->set_userdata('alert_sukses','sukses');		
				$result['response'] = 'sukses';				
      	 		$result['msug_no'] = $data['msug_no'];			
      	 		echo json_encode($result);
			}			
		}				        
	}

	public function get_usergroup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'usergroup');
						
		echo json_encode($this->m_usergroup->get_all_usergroup());				
	}

	public function usergroup_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'usergroup');

		$data['msug_no'] = $this->input->post('msug_no');
		$data['msug_aktif'] = $this->input->post('msug_aktif');

		if($this->m_usergroup->usergroup_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['msug_no'] = $data['msug_no'];			
  	 		echo json_encode($result);
		}
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'msug_nm',
		                'label' => 'Group Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        )

		);
		return $config;
	}
	
}