<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class transfer_masuk extends MY_Controller {	
	private $data = array();

	function __construct(){
		parent::__construct();	
		$this->load->model('finance_and_acc/m_transfer_masuk');	
		$this->load->model('stok_kontrol/m_sales_delivery');
		$this->load->model('finance_and_acc/m_so_payment');
		$this->load->model('finance_and_acc/m_jurnal');		
		$this->load->model('setting/m_setting_account');	
		$this->load->model('spk/m_spk');	
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index(){			
		// cek hak akses		
		if(!fcek_hak_akses('.EH0.')){				
			exit('Cannot access this page.');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/transfer_masuk/v_transfer_masuk_list', $data);
		$this->load->view('v_footer');			
	}

	public function transfer_masuk_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'transfer_masuk');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['transfer_masuk_list'] = $this->m_transfer_masuk->get_transfer_masuk_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['transfer_masuk_list']);
		}
		else {
			$pagination['total_list'] = $this->m_transfer_masuk->get_transfer_masuk_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['transfer_masuk_list'] = $this->load->view('finance_and_acc/transfer_masuk/v_transfer_masuk_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function transfer_masuk_new()
	{
		// cek hak akses		
		if(!fcek_hak_akses('.EH1.')){				
			exit('Cannot access this page.');
		}		
		
		$data['action'] = 'NEW';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/transfer_masuk/v_transfer_masuk_form',$data);
		$this->load->view('v_footer');		
	}

	public function transfer_masuk_view()
	{
		// cek hak akses		
		if(!fcek_hak_akses('.EH1.')){				
			exit('Cannot access this page.');
		}
		
		$trfm_no = $this->input->get('trfm_no');
		$data = $this->m_transfer_masuk->get_transfer_masuk($trfm_no);
		$data['pbso'] = $this->m_so_payment->get_so_payment_bytrfmno($trfm_no);
		$data['pbspk'] = $this->m_spk->get_spk_payment_bytrfmno($trfm_no);		
		
		$data['action'] = 'VIEW';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/transfer_masuk/v_transfer_masuk_form',$data);
		$this->load->view('v_footer');			
	}

	public function transfer_masuk_simpan()
	{
		// Proteksi supaya tidak bisa di akses dari URL 		
		if(!$this->input->is_ajax_request()) {
		   exit('No direct script access allowed');
		}

		$vok = true;
		$msg = '';

		// set data
		if($vok){
			$data = array();
			$data['action'] = $this->input->post('action');									
			$data['trfm_cekint'] = $this->input->post('trfm_cekint');
			$trfm_tgltransfer = $this->input->post('trfm_tgltransfer');

			if($data['action'] == 'NEW'){
				$bulan = substr($trfm_tgltransfer, 5, 2);
				$tahun = substr($trfm_tgltransfer, 2, 2);
				$kode_depan = "TFM".$tahun.$bulan.'-';
				$data['tr']['trfm_no'] = $this->m_transfer_masuk->transfer_masuk_kode_auto($kode_depan);    
				$data['tr']['trfm_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$data['tr']['trfm_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$data['tr']['trfm_void'] = 0;
				$data['tr']['trfm_nprint'] = 0;
			}

			if($data['action'] != 'NEW'){
				$data['tr']['trfm_no'] = fhapus_kutip($this->input->post('trfm_no'));
			}

			$data['tr']['trfm_tgltransfer'] = $trfm_tgltransfer;
			$data['tr']['trfm_mscs_no'] = ($this->input->post('trfm_mscs_no') == '') ? '' : str_replace("-", "", fhapus_kutip(substr($this->input->post('trfm_mscs_no'), 0, 6))); 			
			$data['tr']['trfm_msap_no_tfm'] = fhapus_kutip($this->input->post('trfm_msap_no_tfm'));
			$data['tr']['trfm_msap_no_slh'] = fhapus_kutip($this->input->post('trfm_msap_no_slh'));
			$data['tr']['trfm_total'] = ftodouble($this->input->post('trfm_total'));
			$data['tr']['trfm_used'] = ftodouble($this->input->post('trfm_used'));
			$data['tr']['trfm_catatan'] = fhapus_kutip($this->input->post('trfm_catatan'));			
			$data['tr']['trfm_tag'] = fhapus_kutip($this->input->post('trfm_tag'));							
			$data['tr']['trfm_lsupd'] = date('Y-m-d H:i:s');
			$data['tr']['trfm_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];	

			$pbyr = $this->input->post('pbyr');

			if(isset($pbyr)){																
				foreach ($pbyr['jlhbayar'] as $key => $value) {
					if ($pbyr['jlhbayar'][$key] != '') {

						// set data pembayran Sales Delivery/Faktur	
						if($pbyr['jenistrans'][$key] == 'S'){										
							$data['pbso'][$key]['pbso_no'] = $this->m_so_payment->so_payment_kode_auto(substr($pbyr['refno'][$key], 0, 12));
							$data['pbso'][$key]['pbso_seq'] = 1;
							$data['pbso'][$key]['pbso_refno'] = $pbyr['refno'][$key];
							$data['pbso'][$key]['pbso_msjb_no'] = 0;
							$data['pbso'][$key]['pbso_jenis'] = 'T';
							$data['pbso'][$key]['pbso_bayardp'] = 'T';
							$data['pbso'][$key]['pbso_jlhbayar'] = ftodouble($pbyr['jlhbayar'][$key]);
							$data['pbso'][$key]['pbso_catatan'] = '';
							$data['pbso'][$key]['pbso_tglterima'] = $pbyr['tglbyr'][$key]. ' '. date('H:i:s');
							$data['pbso'][$key]['pbso_tglcair'] = $pbyr['tglbyr'][$key];
							$data['pbso'][$key]['pbso_void'] = 0;
							$data['pbso'][$key]['pbso_cekint'] = 1;
							$data['pbso'][$key]['pbso_lsupd'] = date('Y-m-d H:i:s');
							$data['pbso'][$key]['pbso_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
							$data['pbso'][$key]['pbso_nprint'] = 0;
							$data['pbso'][$key]['pbso_tag'] = '';
							$data['pbso'][$key]['pbso_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
							$data['pbso'][$key]['pbso_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no']; 
							$data['pbso'][$key]['pbso_trsr_no'] = '';
							$data['pbso'][$key]['pbso_refnopbyr'] = $data['tr']['trfm_no'];

						// set data pembayran SPK
						}else if($pbyr['jenistrans'][$key] == 'K'){
							$data['pbspk'][$key]['pbspk_no'] = $this->m_spk->spk_payment_kode_auto($pbyr['refno'][$key]);
							$data['pbspk'][$key]['pbspk_msjb_no'] = 0;
							$data['pbspk'][$key]['pbspk_jlhbayar'] = ftodouble($pbyr['jlhbayar'][$key]);
							$data['pbspk'][$key]['pbspk_catatan'] = '';
							$data['pbspk'][$key]['pbspk_tglterima'] = $pbyr['tglbyr'][$key]. ' '. date('H:i:s');
							$data['pbspk'][$key]['pbspk_tglcair'] = $pbyr['tglbyr'][$key];
							$data['pbspk'][$key]['pbspk_void'] = 0;
							$data['pbspk'][$key]['pbspk_lsupd'] = date('Y-m-d H:i:s');
							$data['pbspk'][$key]['pbspk_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
							$data['pbspk'][$key]['pbspk_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
							$data['pbspk'][$key]['pbspk_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no']; 
							$data['pbspk'][$key]['pbspk_jenis'] = 'T';
							$data['pbspk'][$key]['pbspk_refnopbyr'] = $data['tr']['trfm_no'];
						}
					}					
				}
			}													
		}

		// cek form validation
		if($vok){
			$this->form_validation->set_rules($this->config_validation());
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();
			}
		}

		// cek valid data transaksi
		if($vok) {
			$hasil_cek = $this->cek_valid_data_trans($data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error_message'=>$hasil_cek['msg']);				
			}
		}

		// Simpan data
		if($vok){
			$vresult = $this->m_transfer_masuk->transfer_masuk_simpan($data);			
			if($vresult == 0){
				$vok = false;				
				$msg = array('error_message' => 'Error Query');
			}
		}		
		
		// Berhasil simpan data
		if($vok){
			$this->session->set_userdata('response','sukses');
			$result['response'] = 'sukses';
  	 		$result['trfm_no'] = $data['tr']['trfm_no'];
		}
				
		// Gagal simpan data							
		if(!$vok){
			$result['response'] = 'gagal';  	 		
  	 		$result['error_message'] = $msg;	  	 		
		}	

		echo json_encode($result);
	}	

	private function config_validation(){
		$config = array(		        			        			        
					array(
			                'field' => 'trfm_mscs_no',
			                'label' => 'Customer',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Silakan input %s. <br>',			                        
			                )
			        ),
			        array(
			                'field' => 'trfm_msap_no_tfm',
			                'label' => 'Akun Bank',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Silakan input %s. <br>',			                        
			                )
			        ),
			        array(
			                'field' => 'trfm_total',
			                'label' => 'Total Transfer Masuk',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Silakan input %s. <br>',			                        
			                )
			        )   
		);		

		return $config;
	}

	private function cek_valid_data_trans($data){
		$vok = true;
		$msg = '';
		$pbyr = $this->input->post('pbyr');

		if($data['action'] == 'NEW' || $data['action'] == 'EDIT'){						
			// cek pembayaran harus diinput
			if($vok && !isset($data['pbso']) && !isset($data['pbspk'])){
				$vok = false;
				$msg = 'Please input payment.';	
			}

			// cek total bayar tidak boleh > total transfer
			if($vok && ftodouble($this->input->post('totalbyr')) > ftodouble($this->input->post('totaltrasfer'))){
				$vok = false;
				$msg = 'Total bayar tidak boleh > total transfer.';	
			}

			// akun bank in transit harus disetting
			if($vok && !$this->m_setting_account->get_setting_account_byid('BINT')){
				$vok = false;				
				$msg = 'Akun Bank In Transit belum di setting <br>';
				$msg .= 'Cek di menu Setting >> Trans Account';
			}

			if(isset($data['pbso'])){
				foreach ($data['pbso'] as $key => $value) {				
					if($vok && ftodouble($data['pbso'][$key]['pbso_jlhbayar']) > ftodouble($pbyr['sisabayar'][$key])){
						$vok = false;
						$msg = 'Jumlah bayar tidak boleh > dari sisa bayar.<br>';
						$msg .= 'No. Trans: '. $pbyr['refno'][$key];
						break;
					}					

					// utk pengecekan trsd_cekint, 
					// Valid = CekInt tidak berubah
					if($vok){
						if($this->m_sales_delivery->get_sales_delivery_cekint($pbyr['refno'][$key], $pbyr['cekint'][$key]) == false){
							$vok = false;
							$msg = 'Data have been changed by another user. Please Refresh the page<br>';								
							$msg .= 'No. Trans: '. $pbyr['refno'][$key].'<br>';
							break;
						}
					}
				}				
			}

			if(isset($data['pbspk'])){
				foreach ($data['pbspk'] as $key => $value) {				
					if($vok && ftodouble($data['pbspk'][$key]['pbspk_jlhbayar']) > ftodouble($pbyr['sisabayar'][$key])){
						$vok = false;
						$msg = 'Jumlah bayar tidak boleh > dari sisa bayar.<br>';
						$msg .= 'No. Trans: '. $pbyr['refno'][$key];
						break;
					}					

					// utk pengecekan trspk_cekint, 
					// Valid = CekInt tidak berubah
					if($vok){
						if($this->m_spk->get_spk_cekint($pbyr['refno'][$key], $pbyr['cekint'][$key]) == false){
							$vok = false;
							$msg = 'Data have been changed by another user. Please Refresh the page<br>';								
							$msg .= 'No. Trans: '. $pbyr['refno'][$key].'<br>';
							break;
						}
					}
				}				
			}							
		}			

		// utk pengecekan cekint, 
		// Valid = CekInt tidak berubah
		if ($vok && $data['action'] != 'NEW') {
			if($this->m_transfer_masuk->cek_exists_cekint($data['tr']['trfm_no'], $data['trfm_cekint']) == false){
				$vok = false;
				$msg = 'Data have been changed by another user. Please Refresh the page';
			}else{
				$this->m_transfer_masuk->set_transfer_masuk_cekint($data['tr']['trfm_no']);
			}
		}				

		return array('valid'=>$vok, 'msg'=>$msg);
	}

}