<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class tipe_aktivatetap extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_tipe_aktivatetap');					
	}

	public function index(){			
		if(!fcek_hak_akses('.AS0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/tipe_aktivatetap/v_tipe_aktivatetap_list', $data);
		$this->load->view('v_footer');			
	}

	public function tipe_aktivatetap_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'tipe_aktivatetap');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['tipe_aktivatetap_list'] = $this->m_tipe_aktivatetap->get_tipe_aktivatetap_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['tipe_aktivatetap_list']);
		}
		else {
			$pagination['total_list'] = $this->m_tipe_aktivatetap->get_tipe_aktivatetap_list($arr_filter, true);		
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['tipe_aktivatetap_list'] = $this->load->view('data_master/tipe_aktivatetap/v_tipe_aktivatetap_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function tipe_aktivatetap_new(){			
		if(!fcek_hak_akses('.AS1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/tipe_aktivatetap/v_tipe_aktivatetap_form',$data);
		$this->load->view('v_footer');		
	}

	public function tipe_aktivatetap_view($msta_no){
		if(!fcek_hak_akses('.AS0.')) {
			redirect('forbidden');
		}

		if (is_null($msta_no) || count($this->m_tipe_aktivatetap->get_tipe_aktivatetap($msta_no)) <= 0) {
			redirect('tipe_aktivatetap');
			return;
		}	
		$data = array();
		$data['action'] = 'view';				
		$data['tipe_aktivatetap'] = $this->m_tipe_aktivatetap->get_tipe_aktivatetap($msta_no);
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);	
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/tipe_aktivatetap/v_tipe_aktivatetap_form',$data);
		$this->load->view('v_footer');		
	}

	public function tipe_aktivatetap_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'tipe_aktivatetap');		
		$this->form_validation->set_rules($this->config_validation());
		$vok = true;		

		if($vok){
			$data = array();
			$data['action'] = $this->input->post('action');

			if($data['action'] == 'NEW'){
				$data['ms']['msta_no'] = $this->m_tipe_aktivatetap->tipe_aktivatetap_kode_auto();
			}

			if($data['action'] != 'NEW'){
				$data['ms']['msta_no'] = $this->input->post('msta_no');
			}

			$data['ms']['msta_nm'] = fhapus_kutip($this->input->post('msta_nm'));
			$data['ms']['msta_listmscb'] = (($this->input->post('msta_listmscb') != '') ? ".". implode('.', $this->input->post('msta_listmscb')). "." : '');
			$data['ms']['msta_catatan'] = fhapus_kutip($this->input->post('msta_catatan'));
			$data['ms']['msta_msmp_no'] = fhapus_kutip($this->input->post('msta_msmp_no'));			
			$data['ms']['msta_aktif'] = fhapus_kutip($this->input->post('msta_aktif'));
			$data['ms']['msta_lsupd'] = date('Y-m-d H:i:s');
			$data['ms']['msta_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];

		}				        

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();
			}
		}

		// cek valid data master
		if($vok){
			$hasil_cek = $this->cek_valid_data_master($data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);				
			}
		}

		// Simpan data
		if($vok){
			$vresult = $this->m_tipe_aktivatetap->tipe_aktivatetap_simpan($data);
			if($vresult == 0){
				$vok = false;				
				$msg = array('error' => 'Error Query');
			}
		}
		
		// Berhasil simpan data
		if($vok){
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['msta_no'] = $data['ms']['msta_no'];
		}
				
		// Gagal simpan data							
		if(!$vok){
			$result['response'] = 'gagal';  	 		
  	 		$result['error_message'] = $msg;			  	 		
		}	

		echo json_encode($result);		
	}

	private function cek_valid_data_master($data){
		$msg = '';
		$hsl = true;

		// cek tidak bisa menyimpan da yg status [OFF]
		if($hsl){			
			$data_status['msta_listmscb'] = (($this->input->post('msta_listmscb') != '') ? ".". implode('.', $this->input->post('msta_listmscb')). "." : '');			
			if(fcek_status($data_status)){
				$hsl = false;
				$msg = 'Can not save [OFF] status';				   	
			}
		}		
		
		return array('valid'=>$hsl, 'msg'=>$msg);
	}	
	

	public function get_tipe_aktivatetap(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'tipe_aktivatetap');
						
		echo json_encode($this->m_tipe_aktivatetap->get_all_tipe_aktivatetap());				
	}	

	private function config_validation(){
		$config = array(		        
				        array(
				                'field' => 'msta_nm',
				                'label' => 'Name',
				                'rules' => 'required',
				                'errors' => array(
				                        'required' => ' Please input %s. '
				                )
				        ),
				        array(
				                'field' => 'msta_listmscb[]',
				                'label' => 'Area',
				                'rules' => 'required',
				                'errors' => array(
				                        'required' => ' Please select %s. '
				                )
				        ),
				        array(
				                'field' => 'msta_msmp_no',
				                'label' => 'Metode Penyusutan',
				                'rules' => 'required',
				                'errors' => array(
				                        'required' => ' Please select %s. '
				                )
				        )

				);
		return $config;
	}

}