<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class supplier extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_supplier');					
	}

	public function index(){
		if(!fcek_hak_akses('.AB0.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/supplier/v_supplier_list', $data);
		$this->load->view('v_footer');			
	}

	public function supplier_list(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'supplier');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');						
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['supplier_list'] = $this->m_supplier->get_supplier_list($arr_filter, false, $per_page, $offset, $fn, $sort);
		$data['request_from'] = $this->input->post('request_from');

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['supplier_list']);
		}
		else {
			$pagination['total_list'] = $this->m_supplier->get_supplier_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['supplier_list'] = $this->load->view('data_master/supplier/v_supplier_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function supplier_new(){			
		if(!fcek_hak_akses('.AB1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/supplier/v_supplier_form',$data);
		$this->load->view('v_footer');		
	}

	public function supplier_view($mssp_no){	
		if(!fcek_hak_akses('.AB0.')) {
			redirect('forbidden');
		}

		if (is_null($mssp_no) || count($this->m_supplier->get_supplier($mssp_no)) <= 0) {
			redirect('supplier');
			return;
		}
		$data = array();
		$data['action'] = 'view';				
		$data['supplier'] = $this->m_supplier->get_supplier($mssp_no);
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);	
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/supplier/v_supplier_form',$data);
		$this->load->view('v_footer');		
	}

	public function supplier_new_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'supplier');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{			
			if($this->m_supplier->get_suppliername(null, fhapus_kutip($this->input->post('mssp_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Supplier name already exists');
				echo json_encode($result);
			}else{			
					$data = array();				
					$mssp_jenis = $this->input->post('mssp_jenis');
					$data['mssp_no'] = $this->m_supplier->supplier_kode_auto($mssp_jenis);
					$data['mssp_nm'] = fhapus_kutip($this->input->post('mssp_nm'));					
					$data['mssp_jenis'] = $this->input->post('mssp_jenis');		
					$data['mssp_listmscb'] = (($this->input->post('mssp_listmscb') != '') ? ".". implode('.', $this->input->post('mssp_listmscb')). "." : '');
					$data['mssp_top'] = fhapus_kutip($this->input->post('mssp_top'));
					$data['mssp_ppn'] = $this->input->post('mssp_ppn');
					$data['mssp_telp'] = fhapus_kutip($this->input->post('mssp_telp'));
					$data['mssp_cp'] = fhapus_kutip($this->input->post('mssp_cp'));
					$data['mssp_fax'] = fhapus_kutip($this->input->post('mssp_fax'));
					$data['mssp_hp'] = fhapus_kutip($this->input->post('mssp_hp'));
					$data['mssp_email'] = fhapus_kutip($this->input->post('mssp_email'));
					$data['mssp_almt_jln'] = fhapus_kutip($this->input->post('mssp_almt_jln'));
					$data['mssp_almt_kota'] = fhapus_kutip($this->input->post('mssp_almt_kota'));
					$data['mssp_almt_negara'] = fhapus_kutip($this->input->post('mssp_almt_negara'));
					$data['mssp_bank1_nm'] = fhapus_kutip($this->input->post('mssp_bank1_nm'));
					$data['mssp_bank1_almt'] = fhapus_kutip($this->input->post('mssp_bank1_almt'));
					$data['mssp_bank1_accno'] = fhapus_kutip($this->input->post('mssp_bank1_accno'));
					$data['mssp_bank1_accnm'] = fhapus_kutip($this->input->post('mssp_bank1_accnm'));
					$data['mssp_bank1_swift'] = fhapus_kutip($this->input->post('mssp_bank1_swift'));
					$data['mssp_bank2_nm'] = fhapus_kutip($this->input->post('mssp_bank2_nm'));
					$data['mssp_bank2_almt'] = fhapus_kutip($this->input->post('mssp_bank2_almt'));
					$data['mssp_bank2_accno'] = fhapus_kutip($this->input->post('mssp_bank2_accno'));
					$data['mssp_bank2_accnm'] = fhapus_kutip($this->input->post('mssp_bank2_accnm'));
					$data['mssp_bank2_swift'] = fhapus_kutip($this->input->post('mssp_bank2_swift'));
					$data['mssp_bank3_nm'] = fhapus_kutip($this->input->post('mssp_bank3_nm'));
					$data['mssp_bank3_almt'] = fhapus_kutip($this->input->post('mssp_bank3_almt'));
					$data['mssp_bank3_accno'] = fhapus_kutip($this->input->post('mssp_bank3_accno'));
					$data['mssp_bank3_accnm'] = fhapus_kutip($this->input->post('mssp_bank3_accnm'));
					$data['mssp_bank3_swift'] = fhapus_kutip($this->input->post('mssp_bank3_swift'));
					$data['mssp_tag'] = fhapus_kutip($this->input->post('mssp_tag'));
					$data['mssp_catatan'] = fhapus_kutip($this->input->post('mssp_catatan'));
					$data['mssp_aktif'] = 1; //(($this->input->post('mssp_aktif') == 'on') ? 1 : 0);			
					$data['mssp_lsupd'] = date('Y-m-d H:i:s');
					$data['mssp_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
								
					if($this->m_supplier->supplier_simpan($data)){
						$this->session->set_userdata('alert_sukses','sukses');
						$result['response'] = 'sukses';				
			  	 		$result['mssp_no'] = $data['mssp_no'];	      	 		
			  	 		echo json_encode($result);
					}			
			}					
		}				        
	}

	public function supplier_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'supplier');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$data_status['mssp_listmscb'] = (($this->input->post('mssp_listmscb') != '') ? ".". implode('.', $this->input->post('mssp_listmscb')). "." : '');
			if(fcek_status($data_status)){
				$result['response'] = 'gagal';
				$result['error_message'] = array('fail'=>'Can not save [OFF] status');
				echo json_encode($result);
			}else{			
				if($this->m_supplier->get_suppliername($this->input->post('mssp_no'), fhapus_kutip($this->input->post('mssp_nm'))) > 0){
					$result['response'] = 'gagal';
					$result['error_message'] = array('error'=>'Supplier name already exists');
					echo json_encode($result);
				}else{
						$data = array();		     		
						$data['mssp_no'] = $this->input->post('mssp_no');
						$data['mssp_nm'] = fhapus_kutip($this->input->post('mssp_nm'));			
						$data['mssp_listmscb'] = $data_status['mssp_listmscb'];
						$data['mssp_top'] = fhapus_kutip($this->input->post('mssp_top'));
						$data['mssp_ppn'] = $this->input->post('mssp_ppn');
						$data['mssp_telp'] = fhapus_kutip($this->input->post('mssp_telp'));
						$data['mssp_cp'] = fhapus_kutip($this->input->post('mssp_cp'));
						$data['mssp_fax'] = fhapus_kutip($this->input->post('mssp_fax'));
						$data['mssp_hp'] = fhapus_kutip($this->input->post('mssp_hp'));
						$data['mssp_email'] = fhapus_kutip($this->input->post('mssp_email'));
						$data['mssp_almt_jln'] = fhapus_kutip($this->input->post('mssp_almt_jln'));
						$data['mssp_almt_kota'] = fhapus_kutip($this->input->post('mssp_almt_kota'));
						$data['mssp_almt_negara'] = fhapus_kutip($this->input->post('mssp_almt_negara'));
						$data['mssp_bank1_nm'] = fhapus_kutip($this->input->post('mssp_bank1_nm'));
						$data['mssp_bank1_almt'] = fhapus_kutip($this->input->post('mssp_bank1_almt'));
						$data['mssp_bank1_accno'] = fhapus_kutip($this->input->post('mssp_bank1_accno'));
						$data['mssp_bank1_accnm'] = fhapus_kutip($this->input->post('mssp_bank1_accnm'));
						$data['mssp_bank1_swift'] = fhapus_kutip($this->input->post('mssp_bank1_swift'));
						$data['mssp_bank2_nm'] = fhapus_kutip($this->input->post('mssp_bank2_nm'));
						$data['mssp_bank2_almt'] = fhapus_kutip($this->input->post('mssp_bank2_almt'));
						$data['mssp_bank2_accno'] = fhapus_kutip($this->input->post('mssp_bank2_accno'));
						$data['mssp_bank2_accnm'] = fhapus_kutip($this->input->post('mssp_bank2_accnm'));
						$data['mssp_bank2_swift'] = fhapus_kutip($this->input->post('mssp_bank2_swift'));
						$data['mssp_bank3_nm'] = fhapus_kutip($this->input->post('mssp_bank3_nm'));
						$data['mssp_bank3_almt'] = fhapus_kutip($this->input->post('mssp_bank3_almt'));
						$data['mssp_bank3_accno'] = fhapus_kutip($this->input->post('mssp_bank3_accno'));
						$data['mssp_bank3_accnm'] = fhapus_kutip($this->input->post('mssp_bank3_accnm'));
						$data['mssp_bank3_swift'] = fhapus_kutip($this->input->post('mssp_bank3_swift'));
						$data['mssp_tag'] = fhapus_kutip($this->input->post('mssp_tag'));
						$data['mssp_catatan'] = fhapus_kutip($this->input->post('mssp_catatan'));
						// $data['mssp_aktif'] = (($this->input->post('mssp_aktif') == 'on') ? 1 : 0);			
						$data['mssp_lsupd'] = date('Y-m-d H:i:s');
						$data['mssp_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
											
						if($this->m_supplier->supplier_edit_simpan($data)){	
							$this->session->set_userdata('alert_sukses','sukses');		
							$result['response'] = 'sukses';				
				  	 		$result['mssp_no'] = $data['mssp_no'];			
				  	 		echo json_encode($result);
						}
				}		
			}				
		}				        
	}

	public function get_supplier(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'supplier');
						
		echo json_encode($this->m_supplier->get_all_supplier());				
	}

	public function supplier_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'supplier');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';

		$respon = array();
		$respon['popup'] = $this->load->view('data_master/supplier/v_supplier_popup',$data,true);	
		echo json_encode($respon);		
	}

	public function supplier_autocomplete(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'supplier');

		$keyword = $this->input->post('query');
		if (strpos($keyword, '-') !== FALSE) {
			$keyword = substr($keyword, 0, 6);
		}		
		$data_supplier = $this->m_supplier->get_supplier_autocomplete($keyword);
		foreach ($data_supplier as $key => $value) {
			$data_supplier[$key]['value'] = $value['mssp_nm'];
		}
		$data_supplier['suggestions'] = $data_supplier;
		echo json_encode($data_supplier);
	}

	public function supplier_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'supplier');

		$data['mssp_no'] = $this->input->post('mssp_no');
		$data['mssp_aktif'] = $this->input->post('mssp_aktif');

		if($this->m_supplier->supplier_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['mssp_no'] = $data['mssp_no'];			
  	 		echo json_encode($result);
		}
	}

	private function config_validation(){
		$config = array(		        
		        array(
		                'field' => 'mssp_nm',
		                'label' => 'Supplier Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mssp_top',
		                'label' => 'TOP',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mssp_cp',
		                'label' => 'Contact Person',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mssp_telp',
		                'label' => 'Contact Number',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mssp_almt_jln',
		                'label' => 'Address',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mssp_almt_kota',
		                'label' => 'City',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mssp_almt_negara',
		                'label' => 'Country',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mssp_email',
		                'label' => 'Email',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mssp_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please Select %s. '
		                )
		        )
		);
		return $config;
	}

}