<?php defined('BASEPATH') OR exit('No direct script access allowed');

class spk_visit extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('spk/m_spk_visit');						
		$this->load->model('spk/m_spk');						
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index(){
		if(!fcek_hak_akses('.GB0.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('spk/spk_visit/v_spk_visit_list',$data);
		$this->load->view('v_footer');			
	}

	public function spk_visit_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk_visit');
		
		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['spk_visit_list'] = $this->m_spk_visit->get_spk_visit_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['spk_visit_list']);
		}
		else {
			$pagination['total_list'] = $this->m_spk_visit->get_spk_visit_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['spk_visit_list'] = $this->load->view('spk/spk_visit/v_spk_visit_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}	

	public function spk_visit_new($trspk_no = null){	
		if(!fcek_hak_akses('.GB1.')) {
			redirect('forbidden');
		}

		$data = array();
		if(is_null($trspk_no)){			
			$data['action'] = 'new';			
		}else{
			if(!$this->m_spk->get_spk($trspk_no)) {
				redirect('spk');
				return;
			}else{
				$data = $this->m_spk->get_spk($trspk_no);							
				$data['action'] = 'new_import';
			}				
		}
		
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('spk/spk_visit/v_spk_visit_form',$data);
		$this->load->view('v_footer');		
	}

	public function spk_visit_view($trsv_no){	
		if(!fcek_hak_akses('.GB0.')) {
			redirect('forbidden');
		}

		if (is_null($trsv_no) || !$this->m_spk_visit->get_spk_visit($trsv_no)) {
			redirect('spk_visit');
			return;
		}
		$data = array();				
		$data = $this->m_spk_visit->get_spk_visit($trsv_no);			
			
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('spk/spk_visit/v_spk_visit_form',$data);
		$this->load->view('v_footer');		
	}


	public function spk_visit_print(){
		$this->load->library('java_bridge');
		$trsv_no = $this->input->get('trsv_no');
		$paper_size = $this->input->get('paper_size');

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];


		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		if($paper_size == 'A5'){
			$path = APPPATH.'prints\spk\spk_visit\p_spk_visit_A5.jrxml';
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\spk\spk_visit\p_spk_visit_A4.jrxml';
		}		
		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_TRSV_NO",new Java('java.lang.String', $trsv_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}

	public function spk_visit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk_visit');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());
		$vok = true;

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = $this->form_validation->error_array();
				echo json_encode($result);
			}
		}	

		// cek visit date from dan visit date until required
		if($vok){
			if($this->input->post('action') == 'CONF_VISIT'){				
				if ($this->input->post('trsv_tglvisitfrom') == '0000-00-00' || $this->input->post('trsv_tglvisituntil') == '0000-00-00'){
					$vok = false;
					$result['response'] = 'gagal';
					$result['error_message'] = array('error'=>'Visit date from and visit date until is required');
					echo json_encode($result);
                }
			}
		}

		// cek tidak bisa di cancel kalau spk sudah di finish
		if($vok){
			if($this->input->post('action') == 'CANCEL_CONF_VISIT'){
				if ($this->input->post('is_spkfinish') == 1){
					$vok = false;
					$result['response'] = 'gagal';
					$result['error_message'] = array('error'=>'Cannot cancel confirm visit, SPK has finished');
					echo json_encode($result);
                }
			}
		}

		// set data
		if($vok) {
			$data = array();	
			$trspk_no = $this->input->post('trspk_no');
			$data['action'] = $this->input->post('action');

			if($data['action'] == 'NEW'){
				$data['header']['trsv_no'] = $this->m_spk_visit->spk_visit_kode_auto($trspk_no);
				$data['header']['trsv_tgl'] = $this->input->post('trsv_tgl');
				$data['header']['trsv_void'] = 0;
				$data['header']['trsv_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$data['header']['trsv_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			}
			
			if($data['action'] == 'EDIT' || $data['action'] == 'CONF_VISIT' || $data['action'] == 'CANCEL_CONF_VISIT'){
				$data['header']['trsv_no'] = $this->input->post('trsv_no');
				$data['trsv_cekint'] = $this->input->post('trsv_cekint');
			}

			if($data['action'] == 'CONF_VISIT'){
				$data['header']['trsv_tglvisitfrom'] = fhapus_kutip($this->input->post('trsv_tglvisitfrom'));
				$data['header']['trsv_tglvisituntil'] = fhapus_kutip($this->input->post('trsv_tglvisituntil'));				
				$data['header']['trsv_cnfusr'] = $this->session->userdata('user_aktif')['msus_no'];				
			}

			if($data['action'] == 'CANCEL_CONF_VISIT'){
				$data['header']['trsv_tglvisitfrom'] = '0000-00-00';
				$data['header']['trsv_tglvisituntil'] = '0000-00-00';
				$data['header']['trsv_cnfusr'] = '';
			}

			if($data['action'] == 'NEW' || $data['action'] == 'EDIT' || $data['action'] == 'CONF_VISIT'){
				$data['header']['trsv_catatan'] = fhapus_kutip($this->input->post('trsv_catatan'));
				$data['header']['trsv_kesimpulan'] = fhapus_kutip($this->input->post('trsv_kesimpulan'));
				$data['header']['trsv_ketkonfirmasi'] = fhapus_kutip($this->input->post('trsv_ketkonfirmasi'));				
			}			

			if($data['action'] == 'NEW' || $data['action'] == 'EDIT'){
				$data['header']['trsv_tglrncnvisitfrom'] = fhapus_kutip($this->input->post('trsv_tglrncnvisitfrom'));
				$data['header']['trsv_tglrncnvisituntil'] = fhapus_kutip($this->input->post('trsv_tglrncnvisituntil'));
				$data['header']['trsv_alamat'] = fhapus_kutip($this->input->post('trsv_alamat'));
				$data['header']['trsv_cp'] = fhapus_kutip($this->input->post('trsv_cp'));
				$data['header']['trsv_mssl_no'] = fhapus_kutip($this->input->post('trsv_mssl_no'));
				$data['header']['trsv_tag'] = fhapus_kutip($this->input->post('trsv_tag'));
				$data['header']['trsv_lsupd'] = date('Y-m-d H:i:s');
				$data['header']['trsv_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
			}

			if($data['action'] == 'EDIT'){
				$data['userlog']['msul_tgl'] = date('Y-m-d H:i:s');
				$data['userlog']['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$data['userlog']['msul_catatan'] = substr(trim('['.$data['action']. '] SPK.VST '. $data['header']['trsv_no']. ' '. fhapus_kutip($this->input->post('trsv_tag')). ' '. fhapus_kutip($this->input->post('trsv_catatan'))), 0, 250);
			}
		}	

		//cek valid data trans
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($data['action'], $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}
			
		// simpan data
		if ($vok) {		
			$vresult = $this->m_spk_visit->spk_visit_simpan($data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');
				$result['response'] = 'sukses';				
      	 		$result['trsv_no'] = $data['header']['trsv_no'];	      	 		
      	 		echo json_encode($result);
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}					        
	}

	public function spk_visit_void(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk_visit');
		
		$vok = true;
		
		// Set data
		if($vok){
			$data['header']['trsv_no'] = $this->input->post('trsv_no');				
			$data['trsv_cekint'] = $this->input->post('trsv_cekint');
			
			$data['userlog']['msul_tgl'] = date('Y-m-d H:i:s');
			$data['userlog']['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['userlog']['msul_catatan'] = substr(trim('[VOID] SPK.VST '. $data['header']['trsv_no']. ' '. fhapus_kutip($this->input->post('trsv_tag')). ' '. fhapus_kutip($this->input->post('trsv_catatan'))), 0, 250);
		}

		//cek valid data trans
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('VOID', $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}

		// proses data VOID
		if ($vok) {
			$vresult = $this->m_spk_visit->spk_visit_void($data);	
			if($vresult == 1){				
				$result['response'] = 'sukses';
      	 		$result['trsv_no'] = $data['header']['trsv_no'];	      	 		
      	 		echo json_encode($result);
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}						
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'trsv_mssl_no',
		                'label' => 'Technician',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )
		);
		return $config;
	}	

	private function cek_valid_data_trans($menu, $data){
		// keterangan :
		// $menu = NEW | EDIT | VOID

		$msg = '';
		$hsl = true;
		
		// Utk pengecekan cekint SPK Visit, 
		// Valid = CekInt tidak berubah			
		if ($hsl && $menu != 'NEW') {
			if($this->m_spk_visit->get_spk_visit_cekint($data['header']['trsv_no'], $data['trsv_cekint']) == false){
				$hsl = false;
				$msg = 'Data have been changed by another user. Please Refresh the page';
			}else{
				$this->m_spk_visit->set_spk_visit_cekint($data['header']['trsv_no']);
			}
		}

		return array('valid'=>$hsl, 'msg'=>$msg);
	}
}	