<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class spk extends MY_Controller {
	private $data = array();	

	function __construct(){
		parent::__construct();
		$this->load->model('spk/m_spk');
		$this->load->model('setting/m_setting_efaktur');	
		$this->load->model('setting/m_currency_rates');	
		$this->load->model('finance_and_acc/m_jurnal');	
		$this->load->model('setting/m_setting_account');
		$this->load->model('data_master/m_kategori');
		$this->load->model('stok_kontrol/m_stok');
		$this->load->model('data_master/m_produk');
		$this->load->model('data_master/m_user');		
		$this->load->model('setting/m_setting');
		$this->load->model('finance_and_acc/m_giro_masuk');	
		$this->load->helper('security');		
		error_reporting(E_ALL ^ (E_NOTICE));
		error_reporting(E_ERROR | E_PARSE);
	}

	public function index($tipe_trans = null){						

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			if(!fcek_hak_akses('.HB7.')){
				redirect('forbidden');
			}

			$tipe_trans = 'F';
		} else {
			if(!fcek_hak_akses('.HB8.')){
				redirect('forbidden');
			}

			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('spk');
			}
		}

		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		$data['tipe_trans']	= $tipe_trans;		
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('spk/spk/v_spk_list', $data);
		$this->load->view('v_footer');			
	}

	public function spk_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['spk_list'] = $this->m_spk->get_spk_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['spk_list']);
		}
		else {
			$pagination['total_list'] = $this->m_spk->get_spk_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['spk_list'] = $this->load->view('spk/spk/v_spk_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function spk_dashboard_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['spk_list'] = $this->m_spk->get_spk_dashboard_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['spk_list']);
		}
		else {
			$pagination['total_list'] = $this->m_spk->get_spk_dashboard_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['spk_list'] = $this->load->view('spk/spk/v_spk_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function spk_toplist(){	
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk');

		$data = array();
		$result = array();
		$pagination = array();

		$per_page = $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');
		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			

		$data['spk_toplist'] = $this->m_spk->get_spk_toplist($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;
		$pagination['total_list'] = $this->m_spk->get_spk_toplist($arr_filter, true);		
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['spk_toplist'] = $this->load->view('spk/spk/v_spk_topdatalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $this->m_spk->get_spk_toplist($arr_filter, true);
		
		echo json_encode($result);
	}

	public function spk_new($tipe_trans = null){	
		if(!fcek_hak_akses('.GA1.')) {
			redirect('forbidden');
		}

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			$tipe_trans = 'F';
		} else {
			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('spk');
			}
		}

		$data = array();
		$data['action'] = 'new';
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('spk/spk/v_spk_form',$data);
		$this->load->view('v_footer');		
	}

	public function spk_view($trspk_no = null){				

		if(!fcek_hak_akses('.GA0.')) {
			redirect('forbidden');
		}

		if (is_null($trspk_no) && !$this->m_spk->get_spk($trspk_no)) {
			redirect('spk');
			return;
		}		
		
		$data = array();				
		$data = $this->m_spk->get_spk($trspk_no);						

		$trju_pj_no = $this->m_jurnal->get_jurnalid($trspk_no.'SP');
		if($trju_pj_no != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_pj_no);			
			$data['jurnal_pj_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_pj_d'] = $data_jurnal['jurnal_d'];				
		}

		$trju_acc_no = $this->m_jurnal->get_jurnalid($trspk_no.'SC');
		if($trju_acc_no != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_acc_no);			
			$data['jurnal_acc_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_acc_d'] = $data_jurnal['jurnal_d'];				
		}		
		
		$data_jurnal = $this->m_spk->get_jurnal_pembayaranspk($trspk_no);				
		if($data_jurnal != false){
			$data['jurnal_pbyspk_d'] = $data_jurnal;
		}
				
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();					
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		$data['tipe_trans']	= $data['header']['trspk_fin'];
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('spk/spk/v_spk_form',$data);
		$this->load->view('v_footer');		
	}

	public function spk_print(){
		$this->load->library('java_bridge');
		$trspk_no = $this->input->get('trspk_no');
		$paper_size = $this->input->get('paper_size');
		$print_invoice = $this->input->get('print_invoice');
		$tglselesai = $this->input->get('trspk_tglselesai');
		
		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];


		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		if($print_invoice == "Y" && $tglselesai == 0){
			die("Invoice SPK tidak dapat di cetak karena SPK belum finish");
		}

		
		$query = $this->db->get_where('top_spk', array('tpspk_no' => $trspk_no));
		$toplist = $query->result(); 
		$top="";
		foreach ($toplist as $value) {
			$top .= $value->tpspk_tgljatuhtempo ." ".$value->tpspk_cttn." ". number_format($value->tpspk_value)."\n";
		}

		if($paper_size == 'A5'){
			$path = APPPATH.'prints\spk\spk_form\p_spk_form_A5.jrxml';
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\spk\spk_form\p_spk_form_A4.jrxml';
		}

		if($print_invoice == "Y" && $paper_size=="A4"){
			$path = APPPATH.'prints\spk\spk_form\p_spk_invoice_A4.jrxml';
		}

		$note1 = $this->session->userdata('user_aktif')['mscb_footer1'];
		$note2 = $this->session->userdata('user_aktif')['mscb_footer2'];
		$note3 = $this->session->userdata('user_aktif')['mscb_footer3'];
		$note4 = $this->session->userdata('user_aktif')['mscb_footer4'];
		$note5 = $this->session->userdata('user_aktif')['mscb_footer5'];

		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_TRSPK_NO",new Java('java.lang.String', $trspk_no));
		$params->put("top_tgl",new Java('java.lang.String', $top));
		$params->put("invoice", new Java('java.lang.String', $print_invoice));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$params->put("note1",new Java('java.lang.String', $note1));
		$params->put("note2",new Java('java.lang.String', $note2));
		$params->put("note3",new Java('java.lang.String', $note3));
		$params->put("note4",new Java('java.lang.String', $note4));
		$params->put("note5",new Java('java.lang.String', $note5));
		$params->put("user_print",new Java('java.lang.String', $this->session->userdata('user_aktif')['msus_no']. ' - ' . $this->session->userdata('user_aktif')['msus_nm']));
		$this->java_bridge->print_data($path, $params);
	}

	public function spk_print_faktur_negara(){
		$this->load->library('java_bridge');
		$trspk_no = $this->input->get('trspk_no');
		$tgl_faktur = $this->input->get('faktur_tgl');

		// update trsd_fakturtgl ---------
		$this->db->set('trspk_fakturtgl', $tgl_faktur);
		$this->db->where('trspk_no', $trspk_no);
		$this->db->update('tr_spk'); 
		// end update --------------------

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		$path = APPPATH.'prints\spk\spk_form\p_spk_faktur_negara_A4.jrxml';

		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$params->put("P_TRSPK_NO",new Java('java.lang.String', $trspk_no));
		$params->put("user_print",new Java('java.lang.String', $this->session->userdata('user_aktif')['msus_no']. ' - ' . $this->session->userdata('user_aktif')['msus_nm']));

		$this->java_bridge->print_data($path, $params);
	}

	//==========================================================================================================
	//============== CSV eFaktur berikut ini sudah disesuaikan untuk program DJP 3.2 (April 2022) ==============
	//==========================================================================================================
	public function spk_eksport_txtfile_csv_efaktur(){
		$trspk_no = $this->input->get('trspk_no');
		$tgl_faktur = $this->input->get('faktur_tgl');
		$no_faktur = $this->input->get('faktur_no');
		// echo $trspk_no;

		// update trspk_fakturtgl -------------------------------------------------------
		$update = array('trspk_fakturtgl' => $tgl_faktur, 'trspk_fakturno' => $no_faktur);
		$this->db->where('trspk_no', $trspk_no);
		$this->db->update('tr_spk', $update); 
		// end update ------------------------------------------------------------------
		
		// === CREATE CSV FILE ======================================================================================================
		$filename = 'eFaktur '. $trspk_no . '.csv';
		$myfile = fopen($filename,'w');

		$OutLine = '"FK","KD_JENIS_TRANSAKSI","FG_PENGGANTI","NOMOR_FAKTUR","MASA_PAJAK","TAHUN_PAJAK","TANGGAL_FAKTUR"';
		$OutLine = $OutLine . ',"NPWP","NAMA","ALAMAT_LENGKAP","JUMLAH_DPP","JUMLAH_PPN","JUMLAH_PPNBM","ID_KETERANGAN_TAMBAHAN"';
		$OutLine = $OutLine . ',"FG_UANG_MUKA","UANG_MUKA_DPP","UANG_MUKA_PPN","UANG_MUKA_PPNBM","REFERENSI","KODE_DOKUMEN_PENDUKUNG"';
		$OutLine = $OutLine . "\n";
		fwrite($myfile, $OutLine);

		$OutLine = '"LT","NPWP","NAMA","JALAN","BLOK","NOMOR","RT","RW","KECAMATAN","KELURAHAN","KABUPATEN","PROPINSI"';
        $OutLine = $OutLine . ',"KODE_POS","NOMOR_TELEPON"';
		$OutLine = $OutLine . "\n";
		fwrite($myfile, $OutLine);

		$OutLine = '"OF","KODE_OBJEK","NAMA","HARGA_SATUAN","JUMLAH_BARANG","HARGA_TOTAL","DISKON","DPP","PPN","TARIF_PPNBM","PPNBM"';
		$OutLine = $OutLine . "\n";
		fwrite($myfile, $OutLine);

		// CALCULATE TOTAL DPP dan PPN dari detail ========================================
		$total_dpp = 0;
		$total_ppn = 0;
		// get data detail from model (database)--------------------------------------------------------------------
		$detail = $this->m_spk->get_eksport_csv_efaktur_details($trspk_no);
		foreach ($detail as $key => $data) {
			$total_dpp += round(($data['dtspk_qty'])*$data['dtspk_bftax']);
			$total_ppn += round(($data['dtspk_qty'])*$data['dtspk_tax']);
		}
		// END - CALCULATE TOTAL DPP dan PPN dari detail ==================================
		
		
		// ============================================ Tulis bagian FK ============================================
		// get data header from model (database)--------------------------------------------------------------------
		$header = $this->m_spk->get_eksport_csv_efaktur_header($trspk_no);
		foreach ($header as $key => $data) {
			$OutLine = '"FK","01","0","'.  $data['trspk_fakturno'] .'","'. substr($data['trspk_fakturtgl'],5,2) .'","'. substr($data['trspk_fakturtgl'],0,4) .'"';
			$OutLine = $OutLine . ',"'. date('d/m/Y',strtotime($data['trspk_fakturtgl'])) .'"';
			$OutLine = $OutLine . ',"'. preg_replace('/[^a-zA-Z0-9]/', '', $data['mscs_npwp']) .'"';
			$OutLine = $OutLine . ',"'. $data['mscs_nm'] .'"';
			$OutLine = $OutLine . ',"'. preg_replace( '/\r|\n/', ' ', $data['trspk_alamatnpwp']) .'"';
			// $OutLine = $OutLine . ',"'. round($data['dpp_total']) .'"';
			// $OutLine = $OutLine . ',"'. round($data['ppn_total']) .'"';
			$OutLine = $OutLine . ',"'. $total_dpp .'"';
			$OutLine = $OutLine . ',"'. $total_ppn .'"';
			$OutLine = $OutLine . ',"0","","0","0","0","0","'. $data['trspk_no'] .'",';
			$OutLine = $OutLine . "\n";
			fwrite($myfile, $OutLine);
		}

		// ============================================ Tulis bagian FAPR ============================================
		$fapr = $this->m_setting_efaktur->get_setting_efaktur();
		$OutLine = '"FAPR","'.$fapr['fapr_compname'].'","'.$fapr['fapr_address'].'","","","",';
		$OutLine = $OutLine . "\n";
		fwrite($myfile, $OutLine);


		// ============================================ Tulis bagian OF ============================================
		// get data detail from model (database)--------------------------------------------------------------------
		// $detail = $this->m_spk->get_eksport_csv_efaktur_details($trspk_no);
		foreach ($detail as $key => $data) {
			$OutLine = '"OF","'. $data['dtspk_mspd_no'] .'","'. $data['mspd_nm'] .'"';
			$OutLine = $OutLine . ',"'. round($data['dtspk_bftax']) .'"';
			$OutLine = $OutLine . ',"'. ($data['dtspk_qty']) .'"';
			$OutLine = $OutLine . ',"'. round(($data['dtspk_qty'])*$data['dtspk_bftax']) .'"';
			$OutLine = $OutLine . ',"0"';
			$OutLine = $OutLine . ',"'. round(($data['dtspk_qty'])*$data['dtspk_bftax']) .'"';
			$OutLine = $OutLine . ',"'. round(($data['dtspk_qty'])*$data['dtspk_tax']) .'"';
			$OutLine = $OutLine . ',"0","0.00"';
			$OutLine = $OutLine . "\n";
			fwrite($myfile, $OutLine);
		}

		// Close and Save File to local ----------------------------------------------------------------------------
		fclose($myfile);

		header('Content-Description: File Transfer');
		header('Content-Disposition: attachment; filename='.basename($filename));
		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($filename));
		header("Content-Type: text/plain");
		readfile($filename);
	}

	/*
	public function spk_eksport_csv_efaktur(){
		$trspk_no = $this->input->get('trspk_no');
		$tgl_faktur = $this->input->get('faktur_tgl');
		$no_faktur = $this->input->get('faktur_no');
		// echo "<pre>"; print_r($tgl_faktur);
		// update trsd_fakturtgl -------------------------------------------------------
		$update = array('trspk_fakturtgl' => $tgl_faktur, 'trspk_fakturno' => $no_faktur);
		$this->db->where('trspk_no', $trspk_no);
		$this->db->update('tr_spk', $update); 
		// end update ------------------------------------------------------------------

		// === CREATE CSV FILE ======================================================================================================
		$this->load->library('Excel');
		PHPExcel_Cell::setValueBinder(new PHPExcel_Cell_AdvancedValueBinder());
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$column = 0;
		$row = 0;

		// --- Header csv first line ----------------------------------------------------------------------------------------
		$row+=1; $col = -1;
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FK");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KD_JENIS_TRANSAKSI");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FG_PENGGANTI");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NOMOR_FAKTUR");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "MASA_PAJAK");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TAHUN_PAJAK");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TANGGAL_FAKTUR");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NPWP");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NAMA");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "ALAMAT_LENGKAP");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JUMLAH_DPP");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JUMLAH_PPN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JUMLAH_PPNBM");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "ID_KETERANGAN_TAMBAHAN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FG_UANG_MUKA");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "UANG_MUKA_DPP");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "UANG_MUKA_PPN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "UANG_MUKA_PPNBM");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "REFERENSI");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KODE_DOKUMEN_PENDUKUNG");
		// --- END Header csv first line ------------------------------------------------------------------------------------

		// --- Header csv second line ---------------------------------------------------------------------------------------
		$row+=1; $col = -1;
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "LT");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NPWP");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NAMA");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JALAN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "BLOK");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NOMOR");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "RT");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "RW");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KECAMATAN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KELURAHAN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KABUPATEN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "PROPINSI");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KODE_POS");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NOMOR_TELEPON");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// --- END Header csv second line ------------------------------------------------------------------------------------

		// --- Header csv third line ---------------------------------------------------------------------------------------
		$row+=1; $col = -1;
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "OF");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KODE_OBJEK");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NAMA");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "HARGA_SATUAN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JUMLAH_BARANG");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "HARGA_TOTAL");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "DISKON");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "DPP");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "PPN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TARIF_PPNBM");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "PPNBM");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// --- END Header csv third line ------------------------------------------------------------------------------------

		// get data header from model (database)---------------------------------------------------------------------------------------------------------
		$header = $this->m_spk->get_eksport_csv_efaktur_header($trspk_no);
		// echo "<pre>"; print_r($header); die();
		$row =4; $col = -1;
		foreach ($header as $key => $data) {
			// ---  first line data----------------------------------------------------------------------------------------
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FK");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "01");
						$object->getActiveSheet()->getStyle('B4')->getNumberFormat()->setFormatCode('00');
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "0");
			$col += 1; $object->getActiveSheet()->setCellValueExplicit('D4', $data['trspk_fakturno'], PHPExcel_Cell_DataType::TYPE_STRING);
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, substr($data['trspk_fakturtgl'],5,2));
			$object->getActiveSheet()->getStyle('E4')->getNumberFormat()->setFormatCode('00');
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, substr($data['trspk_fakturtgl'],0,4));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $data['trspk_fakturtgl']);
					   $object->getActiveSheet()->getStyle('G4')->getNumberFormat()->setFormatCode('dd/mm/yyyy');
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, preg_replace('/[^a-zA-Z0-9]/', '', $data['mscs_npwp']));
					   $object->getActiveSheet()->getStyle('H4')->getNumberFormat()->setFormatCode('000000000000000');
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $data['mscs_nm']);
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, preg_replace( '/\r|\n/', ' ', $data['mscs_almt_jln'].' '.$data['mscs_almt_kota'].' '.$data['mscs_almt_provinsi']));
			// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $dpp_total);
			// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $ppn_total);
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, round($data['dpp_total']));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, round($data['ppn_total']));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $data['trspk_no']);
			// --- END Header csv first line ------------------------------------------------------------------------------------
		}

		$detail = $this->m_spk->get_eksport_csv_efaktur_details($trspk_no);
		// echo "<pre>"; print_r($detail); 
		// $dpp_total = 0; $ppn_total=0;
		$col = -1; $baris=5; 
		foreach ($detail as $key => $data) {
			// --- Detail Produk -------------------------------------------------------------------------------------------------
			$sheet = 'E'.$baris;
			$col = -1;
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "OF");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, $data['dtspk_mspd_no']);
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, $data['mspd_nm']);
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, round($data['dtspk_bftax']));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, $data['dtspk_qty'])
							  ->getStyle($sheet)->getNumberFormat()->setFormatCode("#,##0.0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, round($data['dtspk_qty']*$data['dtspk_bftax']));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, round($data['dtspk_qty']*$data['dtspk_bftax']));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, round(($data['dtspk_qty']*$data['dtspk_tax'])));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$baris+=1;
			// $dpp_total += round($data['dtspk_qty']*$data['dtspk_bftax']);
			// $ppn_total += round(($data['dtspk_qty']*$data['dtspk_tax']));
			// --- END Detail Produk ------ ------------------------------------------------------------------------------------
		}

		

		$objWriter = PHPExcel_IOFactory::createWriter($object, 'csv');
		$objWriter->setPreCalculateFormulas(true);
        $filename='eFaktur.csv'; //save our workbook as this file name
        header('Content-Type: application/vnd.csv'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
	}
	*/

	public function spk_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');	
		fcek_direct_access($key, $hash_key, 'spk');
		$this->form_validation->set_rules($this->config_validation());
		$vok = true;
		$error_apv = false;
		$msg;				

		// set data
		if($vok){												
				$this->data['action'] = $this->input->post('action');
				$this->data['header']['trspk_tag'] = fhapus_kutip($this->input->post('trspk_tag'));				
				$this->data['header']['trspk_lsupd'] = date('Y-m-d H:i:s');
				$this->data['header']['trspk_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['header']['trspk_msgd_no'] = $this->input->post('trspk_msgd_no');					
				$this->data['trspk_cekint'] = $this->input->post('trspk_cekint');

				if($this->data['action'] == 'NEW'){
					$trspk_mscb_no = $this->session->userdata('user_aktif')['msus_mscb_no'];
					$trspk_tgl = $this->input->post('trspk_tgl');
					$bulan = substr($trspk_tgl, 5, 2);			
					$tahun = substr($trspk_tgl, 2, 2);		
					$separator = ($this->input->post('trspk_fin') == 'F') ? '-' : '_';	
					$trspk_kode_depan = $trspk_mscb_no."SP".$tahun.$bulan.$separator;
					$this->data['header']['trspk_no'] = $this->m_spk->spk_kode_auto($trspk_kode_depan);
					$this->data['header']['trspk_tgl'] = $trspk_tgl;
					$this->data['header']['trspk_void'] = 0;
					$this->data['header']['trspk_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
					$this->data['header']['trspk_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
					$this->data['header']['trspk_fin'] = $this->input->post('trspk_fin');
					$this->data['header']['trspk_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trspk_fin') == 'C') ? 'A' : 'W';
				}

				if($this->data['action'] != 'NEW'){
					$this->data['header']['trspk_no'] = $this->input->post('trspk_no');
				}

				if($this->data['action'] == 'FINISH_SPK'){					
					$this->data['header']['trspk_tglselesai'] = $this->input->post('trspk_tglselesai');
					$this->data['header']['trspk_stcopy'] = ($this->input->post('trspk_stcopy') == 'W') ? 'R' : $this->input->post('trspk_stcopy');
					$this->data['temp_fin'] = $this->input->post('trspk_fin');
					$date=date_create($this->data['header']['trspk_tglselesai']);
					date_add($date,date_interval_create_from_date_string($this->input->post('trspk_tophari')." days"));
					$this->data['header']['trspk_toptgl'] = date_format($date,"Y-m-d");
				}
				
				if($this->data['action'] == 'NEW' || $this->data['action'] == 'EDIT'){
					$this->data['header']['trspk_catatan'] = fhapus_kutip($this->input->post('trspk_catatan'));
					$this->data['header']['trspk_mscs_no'] = substr($this->input->post('trspk_mscs_no'), 0, 6);
					$this->data['header']['trspk_alamat'] = fhapus_kutip($this->input->post('trspk_alamat'));
					$this->data['header']['trspk_alamatnpwp'] = fhapus_kutip($this->input->post('trspk_alamatnpwp'));
					$this->data['header']['trspk_cp'] = fhapus_kutip($this->input->post('trspk_cp'));
					$this->data['header']['trspk_noserial'] = fhapus_kutip($this->input->post('trspk_noserial'));
					$this->data['header']['trspk_dtsd_no'] = fhapus_kutip($this->input->post('trspk_dtsd_no'));
					$this->data['header']['trspk_dtsd_seq'] = fhapus_kutip($this->input->post('trspk_dtsd_seq'));
					$this->data['header']['trspk_mspd_no'] = ($this->input->post('trspk_mspd_no') == '') ? '' : substr($this->input->post('trspk_mspd_no'), 0, 9);
					$this->data['header']['trspk_garansisp'] = $this->input->post('trspk_garansisp');
					$this->data['header']['trspk_garansijasa'] = $this->input->post('trspk_garansijasa');
					$this->data['header']['trspk_keluhan'] = fhapus_kutip($this->input->post('trspk_keluhan'));
					$this->data['header']['trspk_jnsservis'] = fhapus_kutip($this->input->post('trspk_jnsservis'));
					$this->data['header']['trspk_tophari'] = fhapus_kutip($this->input->post('trspk_tophari'));
					//$this->data['header']['trspk_biayaservis'] = fhapus_kutip(ftodouble($this->input->post('trspk_biayaservis')));
					$this->data['header']['trspk_kurs'] = fhapus_kutip(ftodouble($this->input->post('trspk_kurs')));					
				}					

				if($this->data['action'] == 'STCOPY'){				
					$this->data['header']['trspk_stcopy'] = ($this->input->post('trspk_stcopy') == 'R') ? 'X' : 'R';
				}

				$ul_idx = 0;

				if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
					$this->data['userlog'][$ul_idx]['msul_tgl'] = $this->data['header']['trspk_lsupd'];
					$this->data['userlog'][$ul_idx]['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
					$this->data['userlog'][$ul_idx]['msul_catatan'] = substr(trim('['.$this->data['action']. '] SPK '. $this->data['header']['trspk_no']. ' CUST:'. substr($this->input->post('trspk_mscs_no'), 9). ' '. fhapus_kutip($this->input->post('trspk_tag')). ' '. fhapus_kutip($this->input->post('trspk_catatan'))), 0, 250);
				}

				$top_spk = $this->input->post('top_spk');

				if(isset($top_spk)){
					foreach ($top_spk as $key => $value) {
						for ($i=0; $i < count($top_spk[$key]); $i++) {
							if ($top_spk['tpspk_tgljatuhtempo'][$i] != '' || $top_spk['tpspk_value'][$i] != '' || $top_spk['tpspk_cttn'][$i] != '') {
								$this->data['top_spk'][$i]['tpspk_no'] = $this->data['header']['trspk_no'];
								if($key == 'tpspk_value'){
									$this->data['top_spk'][$i][$key] = ftodouble($value[$i]);
								}else{
									$this->data['top_spk'][$i][$key] = $value[$i];
								}
							}
							
						}
					}
				}

				$dtspk = $this->input->post('dtspk');
				$temp_dtspk = $this->input->post('temp_dtspk');

				if(isset($dtspk)){
					foreach ($dtspk as $key => $value) {
						for ($i=0; $i < count($dtspk[$key]); $i++) {
							if($dtspk['dtspk_mspd_no'][$i] != ''){
								$this->data['detail'][$i]['dtspk_no'] = $this->data['header']['trspk_no'];
								if($key == 'dtspk_seq' || $key == 'dtspk_mspd_no' || $key == 'dtspk_seqpaket' || $key == 'dtspk_statuspaket' || $key == 'dtspk_mdpp_no'){
									$this->data['detail'][$i][$key] = $value[$i];
								}elseif($key == 'dtspk_msus_no') {
									$this->data['detail'][$i][$key] = $value[$i];
									if($dtspk['dtspk_msus_no'][$i] != ''){								
										$ul_idx += 1; 
										$this->data['userlog'][$ul_idx]['msul_tgl'] = $this->data['header']['trspk_lsupd'];
										$this->data['userlog'][$ul_idx]['msul_msus_no'] = $dtspk['dtspk_msus_no'][$i];
										$this->data['userlog'][$ul_idx]['msul_catatan'] = substr(trim('[APV.HRG.SPK] '.$this->data['header']['trspk_no']. ' MIN Rp '. $dtspk['dtspk_minprice'][$i]. ' DI APPROVE Rp '.  $dtspk['dtspk_nett'][$i]. ' PRODUK: '. $dtspk['dtspk_mspd_no'][$i]. ' - '. $temp_dtspk['mspd_nm'][$i]), 0, 250);
									}
								}else{
									$this->data['detail'][$i][$key] = ftodouble($value[$i]);
								}
								
						 		if($this->data['action'] == 'NEW' && $key == 'dtspk_mspd_no'){									
									$this->data['detail'][$i]['dtspk_hpp'] = $this->m_produk->get_hpp($dtspk['dtspk_mspd_no'][$i]);
								}

								if($this->data['action'] == 'FINISH_SPK' && $key == 'dtspk_mspd_no'){
									$this->data['detail'][$i]['dtspk_hpp'] = $this->m_spk->get_dtspk_hpp($this->data['header']['trspk_no'], $dtspk['dtspk_seq'][$i]);
								}															
							}							
							if($this->data['action'] == 'FINISH_SPK'){
								unset($this->data['detail'][$i]['dtspk_minprice']);
								unset($this->data['detail'][$i]['dtspk_msus_no']);
							}
						}						
					}
				}
				
				$dtspkap = $this->input->post('dtspkap');
			
				if(isset($dtspkap)){
					foreach ($dtspkap as $key => $value) {
						for ($i=0; $i < count($dtspkap[$key]); $i++){					
							if($dtspkap['dtspkap_msap_no'][$i] != ''){
								$this->data['detail_acc'][$i]['dtspkap_no'] = $this->data['header']['trspk_no'];
								if($key == 'dtspkap_total'){
									$this->data['detail_acc'][$i][$key] = ftodouble($value[$i]);
								}else{
									$this->data['detail_acc'][$i][$key] = $value[$i];
								}						
							}
						}
					}					
				}
		}			

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;
				$msg = $this->form_validation->error_array();								
			}
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$msg = array('error'=>$hasil_cek['msg']);
				$error_apv = $hasil_cek['error_apv'];
			}
		}

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal_pj($this->data);
			$this->set_data_jurnal_acc($this->data);
		}

		// cek valid data jurnal				
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal($this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}

		// simpan data
		if($vok){
			$vresult = $this->m_spk->spk_simpan($this->data);			
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}		
		}	

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['trspk_no'] = $this->data['header']['trspk_no'];      	 			      	       	 		      	 		
      	 	// $result['trju_pbspk_no'] = ($this->input->post('trju_pbspk_no') == '') ? 'default' : $this->input->post('trju_pbspk_no');      	 		
		}			

		// gagal simpan data
		if (!$vok) {
			if($error_apv == true){
				$result['response'] = 'perlu_acc';				
			}else{
				$result['response'] = 'gagal';					
			}
			$result['error_message'] = $msg;	
		}	

		echo json_encode($result);		      							        
	}	

	public function spk_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';
		$data['payment_status'] = $this->input->post('payment_status');		
		$data['payment_status_disabled'] = $this->input->post('payment_status_disabled');
		
		$respon = array();
		$respon['popup'] = $this->load->view('spk/spk/v_spk_popup',$data,true);	
		echo json_encode($respon);		
	}

	public function spk_popup_pbyr(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';		
		
		$respon = array();
		$respon['popup'] = $this->load->view('spk/spk/v_spk_popuppbyr',$data,true);	
		echo json_encode($respon);		
	}

	public function top_spk_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk');		
		$vok = true;

		// set data
		if($vok){
			$data['header']['trspk_no'] = $this->input->post('trspk_no');
			$data['trspk_cekint'] = $this->input->post('trspk_cekint');
			$data['top_spk'] = $this->input->post('top_spk');
		}		

		// cek data valid
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('EDIT_TOP_SPK', $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}	

		// void data
		if($vok){
			$vresult = $this->m_spk->top_spk_simpan($data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');				
				$result['response'] = 'sukses';
      	 		$result['trspk_no'] = $data['header']['trspk_no'];
      	 		echo json_encode($result);			      	 	
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}	
	}	

	public function get_trspk_terbayar(){
		$trspk_terbayar = $this->m_spk->get_trspk_terbayar($this->input->post('trspk_no'));
		echo json_encode($trspk_terbayar);
	}

	public function spk_cancel_finish(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk');		
		$vok = true;

		// set data
		if($vok){
			$data['action'] = 'CANCEL_FINISH_SPK';
			$data['header']['trspk_no'] = $this->input->post('trspk_no');			
			$data['header']['trspk_tglselesai'] = $this->input->post('trspk_tglselesai');							
			$data['header']['trspk_stcopy'] = ($this->input->post('trspk_stcopy') == 'R') ? 'W' : $this->input->post('trspk_stcopy');
			$data['trspk_cekint'] = $this->input->post('trspk_cekint');			
		}		

		// cek data valid
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($data['action'], $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}	

		// void data
		if($vok){
			$vresult = $this->m_spk->spk_simpan($data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');				
				$result['response'] = 'sukses';
      	 		$result['trspk_no'] = $data['header']['trspk_no'];
      	 		echo json_encode($result);			      	 	
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}	
	}

	public function spk_payment_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk');
		$vok = true;		 
		
		// set data
		if($vok){			
			$this->data['action'] = $this->input->post('action');
			$this->data['trspk_cekint'] = $this->input->post('trspk_cekint');
			$this->data['header']['trspk_no'] = $this->input->post('trspk_no');
			
			if($this->data['action'] == 'SPK_PAYMENT_NEW'){
				$this->data['header']['pbspk_no'] = $this->m_spk->spk_payment_kode_auto($this->input->post('trspk_no'));
				$this->data['header']['pbspk_tglterima'] = $this->input->post('pbspk_tglterima');
				$this->data['header']['pbspk_msus_no'] = substr($this->input->post('pbspk_msus_no'), 0, 4);
				$this->data['header']['pbspk_mscb_no'] = substr($this->input->post('pbspk_mscb_no'), 0, 1);			
			}

			if($this->data['action'] == 'SPK_PAYMENT_EDIT'){
				$this->data['header']['pbspk_no'] = $this->input->post('pbspk_no');
			}

			$this->data['header']['pbspk_jenis'] = $this->input->post('pbspk_jenis');			
			$this->data['header']['pbspk_refnopbyr'] = $this->input->post('pbspk_refnopbyr');			
			$this->data['header']['pbspk_tglcair'] = $this->input->post('pbspk_tglcair');			
			$this->data['header']['pbspk_jlhbayar'] = fhapus_kutip(ftodouble($this->input->post('pbspk_jlhbayar')));
			$this->data['header']['pbspk_msjb_no'] = $this->input->post('pbspk_msjb_no');
			$this->data['header']['pbspk_catatan'] = fhapus_kutip($this->input->post('pbspk_catatan'));			
			$this->data['header']['pbspk_void'] = 0;			
			$this->data['header']['pbspk_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['pbspk_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
			$this->data['mscs_jenis'] = $this->input->post('mscs_jenis');						
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}				

		// Set Jurnal Pembayaran
		if($vok){						
			$this->set_jurnal_pembayaran($this->data);
		}

		// Cek valid data jurnal
		if($vok){			
			$this->cek_valid_data_jurnal($this->data);
		}

		// simpan data
		if($vok){			
			$vresult = $this->m_spk->spk_payment_simpan($this->data);			
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['trspk_no'] = $this->input->post('trspk_no');
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);	
	}

	public function spk_payment_view(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk');

		echo json_encode($this->m_spk->get_spk_payment($this->input->post('pbspk_no')));
	}

	public function spk_payment_void(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk');
		$vok = true;

		// set data
		if($vok){
			$this->data['action'] = 'SPK_PAYMENT_VOID';
			$this->data['trspk_cekint'] = $this->input->post('trspk_cekint');
			$this->data['header']['trspk_no'] = $this->input->post('trspk_no');
			$this->data['header']['pbspk_no'] = $this->input->post('pbspk_no');
			$this->data['header']['pbspk_jenis'] = $this->input->post('pbspk_jenis');
			$this->data['header']['trspk_no'] = $this->input->post('trspk_no');
			$this->data['header']['trju_no'] = $this->input->post('trju_pbspk_no');							
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}				

		// Set Jurnal Pembayaran
		if($vok){						
			$this->set_jurnal_pembayaran($this->data);
		}

		// void data
		if($vok){
			$vresult = $this->m_spk->spk_payment_void($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['trspk_no'] =  $this->input->post('trspk_no');
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);	
	}

	public function get_spk_bycust(){
		$mscs_no = $this->input->post('mscs_no');
		$data = $this->m_spk->get_spk_bycust($mscs_no);
		echo json_encode($data);
	}	

	private function set_data_jurnal_pj($data){
		if($data['action'] == 'FINISH_SPK'){
			//Header jurnal			
			$trju_catatan = $data['header']['trspk_tag'].' '.$data['header']['trspk_no'].'/'.substr($this->input->post('trspk_mscs_no'), 0, 6). ' - '. substr($this->input->post('trspk_mscs_no'), 9);
			$data['jurnal_h']['trju_refno'] = $data['header']['trspk_no'].'SP';
			$data['jurnal_h']['trju_reftipe'] = 'SP';
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_tgl'] = $data['header']['trspk_tglselesai'];
			$data['jurnal_h']['trju_tipe'] = 'A';				
			$data['jurnal_h']['trju_void'] = 0;			
			$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
			$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trspk_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trspk_fin');
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));

			// Set account			
			if(isset($data['detail'])){
				$array = array();
				$data['jurnal_d'] = array();
				foreach ($data['detail'] as $key => $value) {					
			 		// Account Piutang (Debet) dan Penjualan (Kredit)
			 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv				 		
			 			$mskt_no = substr($data['detail'][$key]['dtspk_mspd_no'], 0, 1);
					 	$saldo = round((ftodouble($data['detail'][$key]['dtspk_nett']) * ftodouble($data['detail'][$key]['dtspk_qty'])), 4); 
					 	$bftax = round((ftodouble($data['detail'][$key]['dtspk_bftax']) * ftodouble($data['detail'][$key]['dtspk_qty'])), 4); 
						$tax = $saldo - $bftax;

						// Account Piutang Retail / Agen (Debet)
						if($data['mscs_jenis'] == 'A'){
							$acc = $this->m_setting_account->get_setting_account_byid('PIUA');
						}else{
							$acc = $this->m_setting_account->get_setting_account_byid('PIUR');
						}
						$array['dtju_msap_no'] = $acc['mssa_msap_no'];
						$array['dtju_debet'] = $saldo;
						$array['dtju_kredit'] = 0;
						array_push($data['jurnal_d'], $array);

						// Account Penjualan spk (Kredit)						
					 	if($data['mscs_jenis'] == 'A'){
					 		$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_spa');
						}else{
							$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_spr');
						}						

						$array['dtju_msap_no'] = $acc;
				 		$array['dtju_debet'] = 0;
				 		$array['dtju_kredit'] = $bftax;
				 		array_push($data['jurnal_d'], $array);

				 		// Account PPN Keluaran (Kredit)							
				 		$acc = $this->m_setting_account->get_setting_account_byid('PPNK');
					 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
				 		$array['dtju_debet'] = 0;
				 		$array['dtju_kredit'] = $tax;
				 		array_push($data['jurnal_d'], $array);
			 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

			 		// Account HPP (Debet) dan Inventory (Kredit)
			 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
				 		$saldo = round((ftodouble($data['detail'][$key]['dtspk_hpp']) * ftodouble($data['detail'][$key]['dtspk_qty'])), 4);
				 		// Account HPP (Debet)
						if($data['mscs_jenis'] == 'A'){
					 		$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpa');
						} else {
							$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpr');
						}							

						$array['dtju_msap_no'] = $acc;
				 		$array['dtju_debet'] = $saldo;
				 		$array['dtju_kredit'] = 0;
				 		array_push($data['jurnal_d'], $array);	

				 		// Account Inventory (Kredit)
				 		$array['dtju_msap_no'] = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
						$array['dtju_debet'] = 0;
				 		$array['dtju_kredit'] = $saldo;
				 		array_push($data['jurnal_d'], $array);
			 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^					
				}
				$this->data['jurnal_pj_d'] = $data['jurnal_d'];			
			}
			$this->data['jurnal_pj_h'] = $data['jurnal_h'];						
		}		
	}

	private function set_data_jurnal_acc($data){
		if($data['action'] == 'FINISH_SPK'){
			//Header jurnal			
			$trju_catatan = $data['header']['trspk_tag'].' '.$data['header']['trspk_no'].'/'.substr($this->input->post('trspk_mscs_no'), 0, 6). ' - '. substr($this->input->post('trspk_mscs_no'), 9);
			$data['jurnal_h']['trju_refno'] = $data['header']['trspk_no'].'SC';
			$data['jurnal_h']['trju_reftipe'] = 'SC';
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_tgl'] = $data['header']['trspk_tglselesai'];
			$data['jurnal_h']['trju_tipe'] = 'A';								
			$data['jurnal_h']['trju_void'] = 0;			
			$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
			$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];		
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trspk_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trspk_fin');
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));

			// Set account		
			if(isset($data['detail_acc'])){
				$array = array();
				$data['jurnal_d'] = array();
				foreach ($data['detail_acc'] as $key => $value) {					
			 		// COA (Debet) dan SPK Expenses (Kredit)
			 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv				 		
					 	$saldo = ftodouble($data['detail_acc'][$key]['dtspkap_total']);
						
						// COA (Debet)
						$array['dtju_msap_no'] = $data['detail_acc'][$key]['dtspkap_msap_no'];
						$array['dtju_debet'] = $saldo;
						$array['dtju_kredit'] = 0;
						array_push($data['jurnal_d'], $array);

						// Account SPK Expenses (Kredit)											
						$acc = $this->m_setting_account->get_setting_account_byid('SPKE');
				 		$array['dtju_msap_no'] = $acc['mssa_msap_no'];					 	
				 		$array['dtju_debet'] = 0;
				 		$array['dtju_kredit'] = $saldo;
				 		array_push($data['jurnal_d'], $array);
			 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^			 		
				}
				$this->data['jurnal_acc_d'] = $data['jurnal_d'];			
			}												
			$this->data['jurnal_acc_h'] = $data['jurnal_h'];
		}	
	}	

	private function set_jurnal_pembayaran($data){
		//Header jurnal
		if($this->data['action'] == 'SPK_PAYMENT_NEW'){
			$trju_tgl = $data['header']['pbspk_tglterima'];
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);
			$tahun = substr($trju_tgl, 2, 2);	
			$separator = ($this->input->post('trspk_fin') == 'F') ? '-' : '_';
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);							
			$data['jurnal_h']['trju_refno'] = $data['header']['pbspk_no'].'PK';
			$data['jurnal_h']['trju_reftipe'] = 'PK';
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_void'] = 0;
			$data['jurnal_h']['trju_catatan'] = $this->input->post('trspk_no').'/'.substr($this->input->post('trspk_mscs_no'), 0, 6). ' - '. substr($this->input->post('trspk_mscs_no'), 9);
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trspk_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trspk_fin');			
		}

		if($this->data['action'] == 'SPK_PAYMENT_EDIT' || $this->data['action'] == 'SPK_PAYMENT_VOID'){
			$trju_no = $this->m_jurnal->get_jurnalid($data['header']['pbspk_no'].'PK');		
			$data['jurnal_h']['trju_no'] = $trju_no;
		}

		$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
		$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];

		// Set account								
		// Account Pembayaran (Debet) dan Piutang Reatail / Agen (Kredit)
		$data['jurnal_d'] = array();
		$array = array();
 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv				 									
 			$piur = $this->m_setting_account->get_setting_account_byid('PIUR');
			$piua = $this->m_setting_account->get_setting_account_byid('PIUA');
			$pugi = $this->m_setting_account->get_setting_account_byid('PUGI');
			$saldo = ftodouble($this->input->post('pbspk_jlhbayar'));

			if($data['header']['pbspk_jenis'] == 'O'){
				$acc = $this->input->post('msjb_msap_no');
			}elseif ($data['header']['pbspk_jenis'] == 'G') {
				$acc = $pugi['mssa_msap_no'];
			}

			// Account Pembayaran (Debet)
		 	$array['dtju_msap_no'] = $acc;
	 		$array['dtju_debet'] = $saldo;
	 		$array['dtju_kredit'] = 0;
	 		array_push($data['jurnal_d'], $array);							

	 		// Account Piutang Reatail / Agen (Kredit)
			$array['dtju_msap_no'] = ($data['mscs_jenis'] == 'A') ? $piua['mssa_msap_no'] : $piur['mssa_msap_no']; 
			$array['dtju_debet'] = 0;
			$array['dtju_kredit'] = $saldo;
			array_push($data['jurnal_d'], $array);
			
			$this->data['jurnal_d'] = $data['jurnal_d'];			
		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
		$this->data['jurnal_h'] = $data['jurnal_h'];		
	}

	public function approve_underminprice(){		
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'spk');

		$vok = true;
		$msg = '';		

		if($this->input->post('jenis_otorisasi') == 'K'){			
			$key_otorisasi = $this->input->post('key_otorisasi');
			$user_otorisasi = $this->input->post('user_otorisasi');
			$kode_otorisasi = $this->input->post('kode_otorisasi');
			$kode_otorisasi_gen = fkode_otorisasi_gen($user_otorisasi, $key_otorisasi);
			$msus_data = $this->m_user->get_user_byotoritas($user_otorisasi,'.GA8.');

			if($vok && $user_otorisasi == ''){
				$vok = false;
				$msg = 'Please input user otorisasi';
			}			

			if($vok && $kode_otorisasi != $kode_otorisasi_gen){
				$vok = false;
				$msg = 'User Otorisasi or Kode Otorisasi is invalid';
			}

			if($vok && count($msus_data) <= 0){
				$vok = false;
				$msg = 'User Otorisasi does not have permissions';
			}
		}

		if($this->input->post('jenis_otorisasi') == 'L'){
			$msus_nm = $this->input->post('msus_nm');
			$msus_pswd = do_hash($this->input->post('msus_pswd'),'md5');		
			$msus_data = $this->m_user->get_user_aktif($msus_nm,$msus_pswd);

			if($vok && $msus_nm == ''){
				$vok = false;
				$msg = 'Please input username';
			}

			if($vok && $this->input->post('msus_pswd') == ''){
				$vok = false;
				$msg = 'Please input password';
			}

			if($vok && count($msus_data) <= 0){
				$vok = false;
				$msg = 'Userame and password do not match or User is not allowed';
			}

			if($vok && preg_match("/(.GA8.)/i", $msus_data[0]['msug_hakakses']) == false){
				$vok = false;
				$msg = 'User does not have permissions';
			}
		}		

		if($vok){
			$result['response'] = "sukses";			
			$result['msus_no'] = $msus_data[0]['msus_no'];
		}else{								
			$result['response'] = "gagal";			
			$result['error_message'] = $msg;		
			$result['mt_rand'] = mt_rand(100000, 999999);		
		}

		echo json_encode($result);				
	}

	private function config_validation(){
		$config = array(
				        array(
				                'field' => 'trspk_jnsservis',
				                'label' => 'Service Type',
				                'rules' => 'required',
				                'errors' => array(
				                        'required' => ' Please Select %s. '
				                )
				        ),
				        array(
				                'field' => 'trspk_msgd_no',
				                'label' => 'Warehouse',
				                'rules' => 'required',
				                'errors' => array(
				                        'required' => ' Please Select %s. '
				                )
				        ),
				        array(
				                'field' => 'trspk_tophari',
				                'label' => 'TOP / Number of Days',
				                'rules' => 'required',
				                'errors' => array(
				                        'required' => ' Please Input %s. '
				                )
				        )
				);
		return $config;
	}

	private function cek_valid_data_jurnal($data){		
		$msg = '';
		$hsl = true;

		// cek setting account harus diisi
		if(!$this->m_setting_account->get_setting_account_byid('PIUA') ||
			!$this->m_setting_account->get_setting_account_byid('PIUR') ||
			!$this->m_setting_account->get_setting_account_byid('SPKE') ||
			!$this->m_setting_account->get_setting_account_byid('PPNK')){
			$hsl = false;				
			$msg = 'There is an account that has not been set';
		}				

		//cek akun perkiraan di master kategori harus diisi
		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $value) {		
				$mskt_no = substr($data['detail'][$key]['dtspk_mspd_no'], 0, 1);							
				if(!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv') ||							
						!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_spr') ||
						!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_spa') ||
						!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpr') ||
						!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpa')){
						$hsl = false;						
						$msg = 'There is an account not yet filled in Category Master';
				}						
			}
		}					

		return array('valid'=>$hsl, 'msg'=>$msg);
	}	

	private function cek_valid_data_trans($menu, $data){
		// keterangan :
		// $menu = NEW | EDIT | VOID | FINISH_SPK | SPK_PAYMENT_NEW | SPK_PAYMENT_EDIT

		$msg = '';
		$hsl = true;
		$error_apv = false;
		$tgl_cls_jurnal = $this->m_setting->get_setting('simr_char1','tcj', 1);

		// cek customer dan serial number tidak bisa di edit kalau spk visit sudah dibuat
		if($hsl && $menu == 'EDIT'){
			if($this->input->post('is_spkvisitcreated') == 1){
				if($this->input->post('trspk_mscs_no_lama') != substr($this->input->post('trspk_mscs_no'), 0, 6)|| 
					($this->input->post('trspk_dtsd_no') != $this->input->post('trspk_dtsd_no_lm') && $this->input->post('trspk_dtsd_seq') != $this->input->post('trspk_dtsd_seq_lm')) 
					){
					$hsl = false;						
					$msg = 'Serial number and customer cannot be chaged, SPK Visit has created.';
				}
			}			
		}
			
		if($data['action'] == 'FINISH_SPK' || $data['action'] == 'CANCEL_FINISH_SPK'){						
			// cek tgl finish SPK tidak boleh <= tanggal closing jurnal
			if($hsl){
				$tgl_trans = $this->input->post('trspk_tglselesai');
				$tahun = substr($tgl_trans, 0, 4);
				$bulan = substr($tgl_trans, 5, 2);	
				$tgl_trans = (int)$tahun.$bulan;

				if($hsl && $tgl_trans <= $tgl_cls_jurnal){
					$hsl = false;
					$msg = 'Can not create new/edit/void transaction if journal transaction date is closed. Please choose another date.';
				}
			}		
		}

		if($data['action'] == 'FINISH_SPK'){

			// cek format tgl valid
			if($hsl){
				if(!fcek_date_format($this->input->post('trspk_tglselesai'))){
					$hsl = false;						
					$msg = "Date format is incorrect <br>";						
					$msg .= "Date Format yyyy-mm-dd <br>";						
					$msg .= "Example : 2018-01-25";						
				}
			}

			// cek spk tidak bisa di finih kalau spk visit belum di confirm
			if($hsl){
				if($this->input->post('trspk_tglselesai') != '0000-00-00'){
					if($this->input->post('is_notconfvisit') == 1){					
						$hsl = false;						
						$msg = "Cannot finish SPK, there's one or more SPK visit not yet confirmed";						
					}
				}	
			}
		}

		if($data['action'] == 'VOID'){						
			if($hsl && $this->m_spk->cek_pby_spk_exists($data['header']['trspk_no'])){
				$hsl = false;
				$msg = 'Transaction cannot be void. Payment already made.';
			}			
		}

		//cek jenis bayar haru diisi
		if(($menu == 'SPK_PAYMENT_NEW' || $menu == 'SPK_PAYMENT_EDIT')){
			if($hsl && $this->input->post('pbspk_jenis') == 'O'){
				$this->form_validation->set_rules('pbspk_msjb_no', 'Payment Type', 'required');
				if ($this->form_validation->run() == FALSE){
					$hsl = false;				
					$msg = 'Please select payment type';
				}
			}

			if ($this->input->post('pbspk_jlhbayar') == ''){
				$hsl = false;				
				$msg = 'Please input amount';
			}

			if($this->input->post('pbspk_jenis') == 'G'){				
				if ($hsl &&  $this->input->post('pbspk_refnopbyr') == ''){
					$hsl = false;				
					$msg = 'Please select giro in';
				}

				if($hsl && $this->m_giro_masuk->cek_exists_cekint($this->input->post('pbspk_refnopbyr'), $this->input->post('cekint_tm_gm')) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}			
			}					
		}
		
		if($hsl && ($menu == 'SPK_PAYMENT_NEW' || $menu == 'SPK_PAYMENT_EDIT' || $menu == 'SPK_PAYMENT_VOID')){
			// transaksi tidak bisa di buat/edit/void jika tgl transaksi/jurnal sudah di closing
			$tgl_trans = $this->input->post('pbspk_tglterima');
			$tahun = substr($tgl_trans, 0, 4);
			$bulan = substr($tgl_trans, 5, 2);	
			$tgl_trans = (int)$tahun.$bulan;

			if($hsl && $tgl_trans <= $tgl_cls_jurnal){
				$hsl = false;
				$msg = 'Can not create new/edit/void transaction if journal transaction date is closed. Please choose another date.';
			}			
		}

		if($hsl && ($menu == 'SPK_PAYMENT_EDIT' || $menu == 'SPK_PAYMENT_VOID')){			
			// Transaksi yang sudah di rekonsiliasi tidak bisa di edit/void/cancel
			if($hsl && ($this->m_app->is_recon_exists($data['header']['pbspk_no'].'PK'))){
				$hsl = false;
				$msg = 'Transactions cannot be changed. Journal already in reconciliation';
			}	

			if($hsl && $this->input->post('pbspk_jenis') == 'G'){
				$pbspk_refnopbyr = $this->m_spk->get_pbspk_refnopbyr($this->input->post('pbspk_no'));
				if($this->m_giro_masuk->status_pencairan_giro($pbspk_refnopbyr)){
					$hsl = false;
					$msg = 'Giro In sudah dicairkan (Pembayaran tidak bisa di edit/void).';		
				}				
			}
		}		
		
		// cek tidak boleh di cancel kalo status copy-nya (X)
		if($hsl && $menu == 'CANCEL_FINISH_SPK'){
			if($data['header']['trspk_stcopy'] == 'X'){
				$hsl = false;					
				$msg = 'Transaction cannot be cancelled. Please change status exclude (X) first.';
			}

			// Transaksi yang sudah di rekonsiliasi tidak bisa di edit/void/cancel
			if($hsl && ($this->m_app->is_recon_exists($data['header']['trspk_no'].'SP') || $this->m_app->is_recon_exists($data['header']['trspk_no'].'SC'))){
				$hsl = false;
				$msg = 'Transactions cannot be changed. Journal already in reconciliation';
			}	
		}
				
		if(isset($data['detail'])){
			$cek_stok = false;			
			foreach ($data['detail'] as $key => $value) {
				if($menu == 'NEW' || $menu == 'EDIT'){	
					$stok = $this->m_stok->get_stok($data['detail'][$key]['dtspk_mspd_no'],$data['header']['trspk_msgd_no']);
					$mskt_statusinv = $this->m_kategori->get_mskt_statusinv(substr($data['detail'][$key]['dtspk_mspd_no'], 0, 1));					

					if($menu == 'NEW'){
						$qty_update = $data['detail'][$key]['dtspk_qty'];
						$cek_stok = true;
					}elseif($menu == 'EDIT'){
						// hanya jika qty baru > qty lama yang akan di cek ke stok (nilai yang di cek dr selisih qty/qty baru - qty lama)
						if($data['detail'][$key]['dtspk_qty'] > $data['detail'][$key]['dtspk_qty_lm']){
							$qty_update = $data['detail'][$key]['dtspk_qty'] - $data['detail'][$key]['dtspk_qty_lm'];
							$cek_stok = true;
						}							
					}	

					// cek stok
					if($hsl && $cek_stok){
						if($mskt_statusinv == 'Y' && $data['detail'][$key]['dtspk_statuspaket'] != 'P'){
							if($this->session->userdata('svlogin') != 'F'){
								if (($stok - $qty_update) < 0){
									$hsl = false;
									$msg = 'Stock Insufficient'.
									       '<br>Product: ' . $data['detail'][$key]['dtspk_mspd_no'].
									       '<br>Warehouse: ' . $data['header']['trspk_msgd_no'].
									       '<br>Stock: ' . $stok;
									 break;
								}
							}
						}
					}

					// cek harga bftax tidak boleh dibawah harga minimum (hasil hitungan (pricelist - % 1, 2 dan 3) di ms_kategori)
					if($hsl && ($data['detail'][$key]['dtspk_mspp_no'] == '') || ($data['detail'][$key]['dtspk_mdpp_no'] != '' && $data['detail'][$key]['dtspk_statuspaket'] == 'P')) {
						// $dtspk_bftax = fhapus_kutip(ftodouble($data['detail'][$key]['dtspk_bftax']));
						$dtspk_nett = fhapus_kutip(ftodouble($data['detail'][$key]['dtspk_nett']));
						$dtspk_minprice = fhapus_kutip(ftodouble($data['detail'][$key]['dtspk_minprice']));
						if($dtspk_nett < $dtspk_minprice && $data['detail'][$key]['dtspk_msus_no'] == ""){
							$msg .= 'The price of the following products is less than the minimum price. To continue the process, please input approval:';
							$msg .= ' <br/> - Product ID: '.$data['detail'][$key]['dtspk_mspd_no'];
							$hsl = false;													
							$error_apv = true;
							break;
						}
					}					

					// cek produk mesin tidak boleh > 1
					if ($hsl && $data['detail'][$key]['mspd_reqserialno'] == 'Y' && $data['detail'][$key]['dtspk_qty'] > 1) {
						$hsl = false;																					
						$msg = 'Machine products can not be more than one';
					}	
				}

				unset($this->data['detail'][$key]['dtspk_qty_lm']);	
				unset($this->data['detail'][$key]['dtspk_minprice']);	
				unset($this->data['detail'][$key]['dtspk_msus_no']);
				unset($this->data['detail'][$key]['mspd_reqserialno']);									
			}								
		}

			// cek total Total TOP persen harus <= 100
			
			// if($hsl && ftodouble($this->input->post('top_persen_total')) > 100){
			// 	$hsl = false;					
			// 	$msg = 'Total TOP percent must be <= 100';					
			// }										

		// utk pengecekan cekint SPK
		// Valid = CekInt tidak berubah		
		if ($hsl && $menu != 'NEW') {
			if($this->m_spk->get_spk_cekint($data['header']['trspk_no'], $data['trspk_cekint']) == false){
				$hsl = false;
				$msg = 'Data have been changed by another user. Please Refresh the page';					
			}else{
				$this->m_spk->set_spk_cekint($data['header']['trspk_no']);
			}
		}

		if($hsl && ($menu == 'SPK_PAYMENT_NEW'|| $menu == 'SPK_PAYMENT_EDIT' || $menu == 'SPK_PAYMENT_VOID')){
			unset($this->data['header']['trspk_no']);
		}

		return array('valid'=>$hsl, 'msg'=>$msg, 'error_apv' => $error_apv);
	}

}