<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class sales_retur extends MY_Controller {
	private $data = array();	

	function __construct(){
		parent::__construct();		
		$this->load->model('sales/m_sales_retur');				
		$this->load->model('sales/m_sales_order');				
		$this->load->model('stok_kontrol/m_sales_delivery');				
		$this->load->model('finance_and_acc/m_jurnal');				
		$this->load->model('setting/m_setting_account');
		$this->load->model('data_master/m_kategori');
		$this->load->model('setting/m_setting');
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index(){		
		if(!fcek_hak_akses('.CC0.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('sales/sales_retur/v_sales_retur_list', $data);
		$this->load->view('v_footer');			
	}

	public function sales_retur_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_retur');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['sales_retur_list'] = $this->m_sales_retur->get_sales_retur_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['sales_retur_list']);
		}
		else {
			$pagination['total_list'] = $this->m_sales_retur->get_sales_retur_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['sales_retur_list'] = $this->load->view('sales/sales_retur/v_sales_retur_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function sales_retur_new($trsd_no = null){	
		if(!fcek_hak_akses('.CC1.')) {
			redirect('forbidden');
		}

		$data = array();
		if(is_null($trsd_no)){			
			$data['action'] = 'new';
		}else{
			if(!$this->m_sales_delivery->get_sales_delivery_import($trsd_no)) {
				redirect('sales_retur');
				return;
			}else{
				$data = $this->m_sales_delivery->get_sales_delivery_import($trsd_no);
				$data['action'] = 'new_import';
			}				
		}
				
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}		
		$this->load->view('sales/sales_retur/v_sales_retur_form',$data);
		$this->load->view('v_footer');		
	}

	public function sales_retur_view($trsr_no){	
		if(!fcek_hak_akses('.CC0.')) {
			redirect('forbidden');
		}		

		if (is_null($trsr_no) || !$this->m_sales_retur->get_sales_retur($trsr_no)) {
			redirect('sales_retur');
			return;
		}		

		$data = array();				
		$data = $this->m_sales_retur->get_sales_retur($trsr_no);				

		$trju_no = $this->m_jurnal->get_jurnalid($trsr_no);
		if($trju_no != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);			
			$data['jurnal_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_d'] = $data_jurnal['jurnal_d'];				
		}
		
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('sales/sales_retur/v_sales_retur_form',$data);
		$this->load->view('v_footer');
	}

	public function sales_retur_print(){
		$this->load->library('java_bridge');
		$trsr_no = $this->input->get('trsr_no');
		$paper_size = $this->input->get('paper_size');

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];
		

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		if($paper_size == 'A5'){
			$path = APPPATH.'prints\sales\sales_retur\p_sales_retur_A5.jrxml';
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\sales\sales_retur\p_sales_retur_A4.jrxml';
		}	
			
		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_TRSR_NO",new Java('java.lang.String', $trsr_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}

	public function sales_retur_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_retur');		
		$this->form_validation->set_rules($this->config_validation());				
		$vok = true;
		
		// set data transaksi
		if($vok){													
			$this->data['action'] = $this->input->post('action');
			$this->data['trsd_no'] = $this->input->post('trsd_no');
			$this->data['trsd_cekint'] = $this->input->post('trsd_cekint');
			$this->data['trsr_cekint'] = $this->input->post('trsr_cekint');						
			$this->data['mscs_jenis'] = $this->input->post('mscs_jenis');					
			$this->data['trsr_jenis'] = $this->input->post('trsr_jenis');		
			$this->data['header']['trsr_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['trsr_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];					
			$this->data['header']['trsr_tag'] = fhapus_kutip($this->input->post('trsr_tag'));										

			if($this->data['action'] == 'NEW'){
				$trsd_no = $this->input->post('trsd_no');			
				$this->data['header']['trsr_no'] = $this->m_sales_retur->sales_retur_kode_auto($trsd_no);			
				$this->data['header']['trsr_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$this->data['header']['trsr_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['header']['trsr_tgl'] = $this->input->post('trsr_tgl');
				$this->data['header']['trsr_void'] = 0;			
			}

			if($this->data['action'] != 'NEW'){
				$this->data['header']['trsr_no'] = $this->input->post('trsr_no');
			}

			if($this->data['action'] == 'NEW' || $this->data['action'] == 'EDIT'){
				$this->data['header']['trsr_msgd_no'] = $this->input->post('trsr_msgd_no');
				$this->data['header']['trsr_mscs_no'] = substr($this->input->post('trsr_mscs_no'), 0, 6);
				$this->data['header']['trsr_jenis'] = $this->input->post('trsr_jenis');				
				$this->data['header']['trsr_catatan'] = fhapus_kutip($this->input->post('trsr_catatan'));
			}					

			if($this->data['action'] == 'CONF_RECEIVING_GOODS'){
				$this->data['header']['trsr_tglterima'] = $this->input->post('trsr_tglterima');
			}

			if($this->data['action'] == 'CANCEL_RECEIVING_GOODS'){
				$this->data['header']['trsr_tglterima'] = '';
			}

			if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['userlog']['msul_tgl'] = date('Y-m-d H:i:s');
				$this->data['userlog']['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['userlog']['msul_catatan'] = substr(trim('['.$this->data['action']. '] SLS.RET '. $this->data['header']['trsr_no']. ' CUST:'. substr($this->input->post('trsr_mscs_no'), 9). ' '. fhapus_kutip($this->input->post('trsr_tag')). ' '. fhapus_kutip($this->input->post('trsr_catatan'))), 0, 250);
			}										

			$dtsr = $this->input->post('dtsr');
						
			foreach ($dtsr as $key => $value) {
				for ($i=0; $i < count($dtsr[$key]); $i++) {																									
					if($dtsr['dtsr_qtyretur'][$i] > 0){
						$this->data['detail'][$i]['dtsr_no'] = $this->data['header']['trsr_no'];
						if($key == 'dtsr_seq' || $key == 'dtsr_mspd_no'){
							$this->data['detail'][$i][$key] = $value[$i];
						}else{
						 	$this->data['detail'][$i][$key] = ftodouble($value[$i]);
						}

						if($key == 'dtsr_mspd_no'){
							$this->data['detail'][$i]['dtsr_hpp'] = $this->m_sales_delivery->get_hppsd(substr($this->data['header']['trsr_no'], 0, 17), $dtsr['dtsr_seq'][$i]);
						}
					}						
				} 								
			}					
		}	

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = $this->form_validation->error_array();
				echo json_encode($result);
			}	
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}					
		
		// Set data jurnal
		if($vok){			
			$this->set_data_jurnal($this->data);			
		}

		// cek valid data jurnal				
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal($this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}		

		// simpan data
		if($vok){
			$vresult = $this->m_sales_retur->sales_retur_simpan($this->data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');
				$result['response'] = 'sukses';				
      	 		$result['trsr_no'] = $this->data['header']['trsr_no'];      	 		
      	 		echo json_encode($result);
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}				        
	}	

	public function sales_retur_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_retur');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';

		$respon = array();
		$respon['popup'] = $this->load->view('sales/sales_retur/v_sales_retur_popup',$data,true);
		echo json_encode($respon);		
	}

	private function set_data_jurnal($data){
		if($data['action'] == 'CONF_RECEIVING_GOODS'){
			//Header jurnal
			$trju_tgl = $data['header']['trsr_tglterima'];
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);			
			$tahun = substr($trju_tgl, 2, 2);		
			$separator = ($this->input->post('trso_fin') == 'F') ? '-' : '_';			
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;							
			$trju_catatan = $data['header']['trsr_tag'].' '.$data['header']['trsr_no'].'/'.substr($this->input->post('trsr_mscs_no'), 0, 6). ' - '. substr($this->input->post('trsr_mscs_no'), 9);
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);							
			$data['jurnal_h']['trju_refno'] = $data['header']['trsr_no'];
			$data['jurnal_h']['trju_reftipe'] = 'SR';
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_void'] = 0;			
			$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
			$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];									
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trso_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trso_fin');
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));

			// Set account			
			if(isset($data['detail'])){			
				$data['jurnal_d'] = array();
				$array = array();
				foreach ($data['detail'] as $key => $value) {						 		
					// Account Inventory (Debet) dan HPP (Kredit) 
			 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
			 			$mskt_no = substr($data['detail'][$key]['dtsr_mspd_no'], 0, 1);
				 		$saldo = round((ftodouble($data['detail'][$key]['dtsr_hpp']) * ftodouble($data['detail'][$key]['dtsr_qtyretur'])), 4);

				 		// Account Inventory (Debet)
				 		$array['dtju_msap_no'] = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
						$array['dtju_debet'] = $saldo;
				 		$array['dtju_kredit'] = 0;
				 		array_push($data['jurnal_d'], $array);

				 		// Account HPP (Kredit)
						if($data['mscs_jenis'] == 'A'){
					 		$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpa');
						} else {
							$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpr');
						}						

						$array['dtju_msap_no'] = $acc;
				 		$array['dtju_debet'] = 0;
				 		$array['dtju_kredit'] = $saldo;
				 		array_push($data['jurnal_d'], $array);						 		
			 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

			 		// Account Retur Retail / Agen dan PPN Masukan (Debet) dan Retur Retail / Voucher (Kredit)
			 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv				 		
					 	$saldo = round(ftodouble($data['detail'][$key]['dtsr_nett']) * ftodouble($data['detail'][$key]['dtsr_qtyretur']), 4);
					 	$bftax = round(ftodouble($data['detail'][$key]['dtsr_bftax']) * ftodouble($data['detail'][$key]['dtsr_qtyretur']), 4);
					 	// $tax = ftodouble($data['detail'][$key]['dtsr_tax']) * ftodouble($data['detail'][$key]['dtsr_qtyretur']);
					 	$tax = $saldo - $bftax;

						// Account Retur Retail / Agen (Debet)
						if($data['mscs_jenis'] == 'A'){
					 		$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_sra');
					 	} else {
					 		$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_srr');
					 	}

					 	$array['dtju_msap_no'] = $acc;
				 		$array['dtju_debet'] = $bftax;
				 		$array['dtju_kredit'] = 0;
				 		array_push($data['jurnal_d'], $array);

						// Account PPN Keluaran (Debet)
				 		$acc = $this->m_setting_account->get_setting_account_byid('PPNK');

				 		$array['dtju_msap_no'] = $acc['mssa_msap_no'];
				 		$array['dtju_debet'] = $tax;
				 		$array['dtju_kredit'] = 0;
				 		array_push($data['jurnal_d'], $array);

				 		// Account Retur Cash / Voucher (Kredit)
				 		if($data['mscs_jenis'] == 'A' && $data['trsr_jenis'] == 'C'){			 			
							$acc = $this->m_setting_account->get_setting_account_byid('SRCA');						
				 		}elseif ($data['mscs_jenis'] == 'R' && $data['trsr_jenis'] == 'C') {
				 			$acc = $this->m_setting_account->get_setting_account_byid('SRCR');			 			
				 		}elseif ($data['mscs_jenis'] == 'A' && $data['trsr_jenis'] == 'V') {			 			
							$acc = $this->m_setting_account->get_setting_account_byid('SRVA');
				 		}elseif ($data['mscs_jenis'] == 'R' && $data['trsr_jenis'] == 'V') {
				 			$acc = $this->m_setting_account->get_setting_account_byid('SRVR');
				 		}			 					 		

						$array['dtju_msap_no'] = $acc['mssa_msap_no'];
						$array['dtju_debet'] = 0;
						$array['dtju_kredit'] = $saldo;
						array_push($data['jurnal_d'], $array);
			 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^				
				}			
				$this->data['jurnal_d'] = $data['jurnal_d'];
			}
			$this->data['jurnal_h'] = $data['jurnal_h'];
		}

		if($data['action'] == 'CANCEL_RECEIVING_GOODS'){
			$this->data['jurnal_h']['trju_no'] = $this->input->post('trju_no');
		}
	}

	private function cek_valid_data_jurnal($data){
		$msg = '';
		$hsl = true;

		// cek setting account harus diisi
		if($hsl){
			if(!$this->m_setting_account->get_setting_account_byid('SRCA') ||
				!$this->m_setting_account->get_setting_account_byid('SRCR') ||
				!$this->m_setting_account->get_setting_account_byid('SRVA') ||
				!$this->m_setting_account->get_setting_account_byid('SRVR') ||
				!$this->m_setting_account->get_setting_account_byid('PPNK')){
				$hsl = false;				
				$msg = 'There is an account that has not been set';
			}				
		}

		//cek akun perkiraan di master kategori harus diisi
		if($hsl){
			if(isset($data['detail'])){
				foreach ($data['detail'] as $key => $value) {				
					$mskt_no = substr($data['detail'][$key]['dtsr_mspd_no'], 0, 1);
					if(!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv') ||							
						!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_sra') ||
						!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_srr') ||
						!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpa') ||
						!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpr')){
						$hsl = false;						
						$msg = 'There is an account not yet filled in Category Master';
					}						
				}
			}
		}

		return array('valid'=>$hsl, 'msg'=>$msg);
	}

	private function config_validation(){
			$config = array(			        
			        array(
			                'field' => 'trsr_msgd_no',
			                'label' => 'warehouse',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Please select %s. '
			                )
			        )
			);
			return $config;
	}

	public function cek_valid_data_trans($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | VOID

			$msg = '';
			$hsl = true;
			$tgl_cls_jurnal = $this->m_setting->get_setting('simr_char1','tcj', 1);			

			// Sales delivery bisa diretur kalau sudah di confirm
			if($menu == 'NEW'){
				if($this->m_sales_delivery->sd_confirmed($this->input->post('trsd_no')) == false){
					$hsl = false;
					$msg = 'Sales delivery has not been confirmed.';
				}
			}

			if($menu == 'CONF_RECEIVING_GOODS' || $menu == 'CANCEL_RECEIVING_GOODS'){
				// transaksi tidak bisa di buat/edit/void jika tgl transaksi/jurnal sudah di closing
				$tgl_trans = $this->input->post('trsr_tglterima');				

				$tahun = substr($tgl_trans, 0, 4);
				$bulan = substr($tgl_trans, 5, 2);	
				$tgl_trans = (int)$tahun.$bulan;	

				if($hsl && $tgl_trans <= $tgl_cls_jurnal){
					$hsl = false;
					$msg = 'Can not create new/edit/void transaction if journal transaction date is closed. Please choose another date.';
				}
			}

			if($menu == 'CANCEL_RECEIVING_GOODS'){								
				// Transaksi yang sudah di rekonsiliasi tidak bisa di edit/void/cancel
				if($hsl && $this->m_app->is_recon_exists($data['header']['trsr_no'])){
					$hsl = false;
					$msg = 'Transactions cannot be changed. Journal already in reconciliation';
				}

			}

			if($hsl){
				if(!isset($data['detail'])){
					$hsl = false;
					$msg = 'Please input qty return';	
				}	
			}

			// utk pengecekan dtsr_qtyretur
			if ($hsl) {
				if(isset($data['detail'])){
					foreach ($data['detail'] as $key => $value) {

						if ($menu == 'NEW' || $menu == 'EDIT' || $menu == 'CONF_RECEIVING_GOODS') { 

							$qtyupdate = $data['detail'][$key]['dtsr_qtykrmsd'] - $data['detail'][$key]['dtsr_qtysudahretur'];
							
							if ($data['detail'][$key]['dtsr_qtyretur'] > $qtyupdate){
								$hsl = false;
								$msg = 'Exceeds the maximum number'.
										'<br>Product: '. $data['detail'][$key]['dtsr_mspd_no'].
										'<br>Maximu number: '. $qtyupdate;								
								 break;
							}												
						}						
						unset($this->data['detail'][$key]['dtsr_qtykrmsd']);
						unset($this->data['detail'][$key]['dtsr_qtysudahretur']);						
					}
				}	
			}	
			
			// utk pengecekan cekint, 
			// Valid = CekInt tidak berubah			
			if ($hsl) {
				if($this->m_sales_delivery->get_sales_delivery_cekint(substr($data['header']['trsr_no'], 0, 17), $data['trsd_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_sales_delivery->set_sales_delivery_cekint(substr($data['header']['trsr_no'], 0, 17));
				}				
			}			

			if ($hsl && $menu != 'NEW') {
				if($this->m_sales_retur->get_sales_retur_cekint($data['header']['trsr_no'], $data['trsr_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_sales_retur->set_sales_retur_cekint($data['header']['trsr_no']);
				}
			}

			return array('valid'=>$hsl, 'msg'=>$msg);
	}

}	