<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class sales_order extends MY_Controller {
	private $data = array();	

	function __construct(){
		parent::__construct();
		$this->load->model('sales/m_sales_order');
		$this->load->model('sales/m_sales_inquery');
		$this->load->model('data_master/m_produk');										
		$this->load->model('finance_and_acc/m_so_payment');	
		$this->load->model('setting/m_currency_rates');	
		$this->load->model('data_master/m_user');		
		$this->load->model('data_master/m_kategori');		
		$this->load->helper('security');		
		error_reporting(E_ALL ^ (E_NOTICE));
		error_reporting(E_ERROR | E_PARSE);
	}

	public function index($tipe_trans = null){
		
		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			if(!fcek_hak_akses('.HB7.')){
				redirect('forbidden');
			}

			$tipe_trans = 'F';
		} else {
			if(!fcek_hak_akses('.HB8.')){
				redirect('forbidden');
			}

			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('sales_order');
			}
		}
		// if($tipe_trans != null){			
		// 	if($this->session->userdata('svlogin') == 'C' && $tipe_trans != 'F' && $tipe_trans != 'C' ||
		// 		$this->session->userdata('svlogin') == 'F' && $tipe_trans != null && $tipe_trans != 'F'){				
		// 		redirect('sales_order');
		// 	}
		// }

		$data = array();
		$data['mskt'] = $this->m_kategori->get_all_kategori();		
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? '' : 'C';
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('sales/sales_order/v_sales_order_list', $data);
		$this->load->view('v_footer');			
	}

	public function sales_order_list(){	
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_order');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['sales_order_list'] = $this->m_sales_order->get_sales_order_list($arr_filter, false, $per_page, $offset, $fn, $sort);
		$data['request_from'] = $this->input->post('request_from');

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['sales_order_list']);
		}
		else {
			$pagination['total_list'] = $this->m_sales_order->get_sales_order_list($arr_filter, true);		
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['sales_order_list'] = $this->load->view('sales/sales_order/v_sales_order_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function sales_order_toplist(){	
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_order');

		$data = array();
		$result = array();
		$pagination = array();

		$per_page = $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');
		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			

		$data['sales_order_toplist'] = $this->m_sales_order->get_sales_order_toplist($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;
		$pagination['total_list'] = $this->m_sales_order->get_sales_order_toplist($arr_filter, true);		
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['sales_order_toplist'] = $this->load->view('sales/sales_order/v_sales_order_topdatalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $this->m_sales_order->get_sales_order_toplist($arr_filter, true);
		
		echo json_encode($result);
	}
	
	public function sales_order_new($trsi_no, $tipe_trans = null){	
		if(!fcek_hak_akses('.CB1.')) {
			redirect('forbidden');
		}

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			$tipe_trans = 'F';
		} else {
			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('sales_order');
			}
		}

		// if($tipe_trans != null){			
		// 	if($this->session->userdata('svlogin') == 'C' && $tipe_trans != 'F' && $tipe_trans != 'C' ||
		// 		$this->session->userdata('svlogin') == 'F' && $tipe_trans != null && $tipe_trans != 'F'){				
		// 		redirect('sales_order');
		// 	}
		// }

		$data = array();
		if($trsi_no == 'default'){			
			$data['action'] = 'new';
		}else{
			if(!$this->m_sales_inquery->get_sales_inquery($trsi_no)) {
				redirect('sales_order');
				return;
			}else{
				$data = $this->m_sales_inquery->get_sales_inquery($trsi_no);			
				if($data['header']['trsi_fin'] != $tipe_trans){
					redirect('sales_order');
					return;
				}
				$data['action'] = 'new_import';
			}				
		}
		
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();		
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? '' : 'C';
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('sales/sales_order/v_sales_order_form',$data);
		$this->load->view('v_footer');		
	}

	public function sales_order_view($trso_no){	
		if(!fcek_hak_akses('.CB0.')) {
			redirect('forbidden');
		}

		$data = array();		
		$data = $this->m_sales_order->get_sales_order($trso_no);		

		if (is_null($trso_no) || count($data) <= 0) {
			redirect('sales_order');
			return;
		}	
		
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';		
		$data['tipe_trans']	= $data['header']['trso_fin'];
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('sales/sales_order/v_sales_order_form',$data);
		$this->load->view('v_footer');		
	}

	public function sales_order_print(){
		$this->load->library('java_bridge');
		$trso_no = $this->input->get('trso_no');
		$paper_size = $this->input->get('paper_size');

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];
		

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		if($paper_size == 'A5'){
			$path = APPPATH.'prints\sales\sales_order\p_sales_order_A5.jrxml';
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\sales\sales_order\p_sales_order_A4.jrxml';
		}		
		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_TRSO_NO",new Java('java.lang.String', $trso_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}

	public function sales_order_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_order');			
		$this->form_validation->set_rules($this->config_validation());
		$vok = true;
		$error_apv = false;

		// set data transaksi
		if($vok){			
			$this->data['trso_cekint'] = $this->input->post('trso_cekint');
			$this->data['action'] = $this->input->post('action');

			if($this->data['action'] == 'NEW'){				
				$trso_mscb_no = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$trso_tgl = $this->input->post('trso_tgl');
				$bulan = substr($trso_tgl, 5, 2);			
				$tahun = substr($trso_tgl, 2, 2);
				$separator = ($this->input->post('trso_fin') == 'F') ? '-' : $this->input->post('trso_klas');			
				$trso_kode_depan = $trso_mscb_no."SO".$tahun.$bulan.$separator;
				$date=date_create(substr($trso_tgl, 0, 10));
				date_add($date,date_interval_create_from_date_string("89 days"));								

				if($this->input->post('trso_no') == ''){
					$this->data['header']['trso_no'] = $this->m_sales_order->sales_order_kode_auto($trso_kode_depan);
				}else{
					$this->data['header']['trso_no'] = $this->input->post('trso_no');
				}

				$this->data['header']['trso_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['header']['trso_mscb_no'] = $trso_mscb_no;
				$this->data['header']['trso_tgl'] = $trso_tgl;
				$this->data['header']['trso_tglbataslock'] = date_format($date,"Y-m-d");
				$this->data['header']['trso_void'] = 0;
				$this->data['header']['trso_lock'] = 'N';
				$this->data['header']['trso_fin'] = $this->input->post('trso_fin');
				$this->data['header']['trso_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trso_fin') == 'C') ? 'A' : 'W';
				$this->data['header']['trso_klas'] = ($this->input->post('trso_fin') == 'C') ? $this->input->post('trso_klas') : '0';
			}

			if($this->data['action'] != 'NEW'){
				$this->data['header']['trso_no'] = $this->input->post('trso_no');
			}

			if($this->data['action'] == 'STCOPY'){				
				$this->data['header']['trso_stcopy'] = ($this->input->post('trso_stcopy') == 'R') ? 'X' : 'R';
			}
			
			$this->data['header']['trso_tglestkirim'] = $this->input->post('trso_tglestkirim');
			$this->data['header']['trso_mssl_no'] = $this->input->post('trso_mssl_no');
			$this->data['header']['trso_statusppn'] = 'Y';
			$this->data['header']['trso_tophari'] = fhapus_kutip($this->input->post('trso_tophari'));
			$this->data['header']['trso_mscs_no'] = substr($this->input->post('trso_mscs_no'), 0, 6);
			$this->data['header']['trso_alamatkirim'] = fhapus_kutip($this->input->post('trso_alamatkirim'));
			$this->data['header']['trso_alamatnpwp'] = fhapus_kutip($this->input->post('trso_alamatnpwp'));
			$this->data['header']['trso_cp'] = fhapus_kutip($this->input->post('trso_cp'));
			$this->data['header']['trso_kurs'] = ftodouble($this->input->post('trso_kurs'));
			$this->data['header']['trso_pocust'] = fhapus_kutip($this->input->post('trso_pocust'));
			$this->data['header']['trso_ekspedisi'] = fhapus_kutip($this->input->post('trso_ekspedisi')); 
			$this->data['header']['trso_biayaekspedisi'] = ftodouble($this->input->post('trso_biayaekspedisi')); 			
			$this->data['header']['trso_total'] = ftodouble($this->input->post('trso_total'));
			$this->data['header']['trso_catatan'] = fhapus_kutip($this->input->post('trso_catatan'));
			$this->data['header']['trso_tag'] = fhapus_kutip($this->input->post('trso_tag'));								
			$this->data['header']['trso_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['trso_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
			
			$ul_idx = 0; 

			if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['userlog'][$ul_idx]['msul_tgl'] = $this->data['header']['trso_lsupd'];
				$this->data['userlog'][$ul_idx]['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['userlog'][$ul_idx]['msul_catatan'] = substr(trim('['.$this->data['action']. '] SLS.ORD '. $this->data['header']['trso_no']. ' CUST:'. substr($this->input->post('trso_mscs_no'), 9). ' '. fhapus_kutip($this->input->post('trso_tag')). ' '. fhapus_kutip($this->input->post('trso_catatan'))), 0, 250);
			}			

			$dtso = $this->input->post('dtso');
			$temp_dtso = $this->input->post('temp_dtso');

			foreach ($dtso as $key => $value) {
				for ($i=0; $i < count($dtso[$key]); $i++) {
					if ($dtso['dtso_mspd_no'][$i] != '') {	
						$this->data['detail'][$i]['dtso_no'] = $this->data['header']['trso_no'];
						if($key == 'dtso_mspd_no' || $key == 'dtso_seq' || $key == 'dtso_curr' || $key == 'dtso_seqpaket' || $key == 'dtso_statuspaket' || $key == 'dtso_mdpp_no'){
							$this->data['detail'][$i][$key] = $value[$i];
						}elseif($key == 'dtso_msus_no') {
							$this->data['detail'][$i][$key] = $value[$i];
							if($dtso['dtso_msus_no'][$i] != ''){								
								$ul_idx += 1; 
								$this->data['userlog'][$ul_idx]['msul_tgl'] = $this->data['header']['trso_lsupd'];
								$this->data['userlog'][$ul_idx]['msul_msus_no'] = $dtso['dtso_msus_no'][$i];
								$this->data['userlog'][$ul_idx]['msul_catatan'] = substr(trim('[APV.HRG.SO] '.$this->data['header']['trso_no']. ' MIN Rp '. $dtso['dtso_minprice'][$i]. ' DI APPROVE Rp '.  $dtso['dtso_nett'][$i]. ' PRODUK: '. $dtso['dtso_mspd_no'][$i]. ' - '. $temp_dtso['mspd_nm'][$i]), 0, 250);
							}
						}else{							
							$this->data['detail'][$i][$key] = ftodouble($value[$i]);							
						}						
					}
				}
			}			
			
			$top_so = $this->input->post('top_so');

			if(isset($top_so)){
				foreach ($top_so as $key => $value) {
					for ($i=0; $i < count($top_so[$key]); $i++) {
						if ($top_so['tpso_tgljatuhtempo'][$i] != '' || $top_so['tpso_value'][$i] != '' || $top_so['tpso_cttn'][$i] != '') {
							$this->data['top_so'][$i]['tpso_no'] = $this->data['header']['trso_no'];
							if($key == 'tpso_value'){
								$this->data['top_so'][$i][$key] = ftodouble($value[$i]);
							}else{
								$this->data['top_so'][$i][$key] = $value[$i];
							}
						}
						
					}
				}
			}
		}	
				

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();				
			}
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);				
				$error_apv = $hasil_cek['error_apv'];
			}
		}					

		// simpan data
		if($vok){							
			$vresult = $this->m_sales_order->sales_order_simpan($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}			
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';				
  	 		$result['trso_no'] = $this->data['header']['trso_no'];
		}	

		// gagal simpan data
		if (!$vok) {
			if($error_apv == true){
				$result['response'] = 'perlu_acc';				
			}else{
				$result['response'] = 'gagal';					
			}
			$result['error_message'] = $msg;	
		}	

		echo json_encode($result);			        			        
	}

	public function sales_order_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_order');

		if(fcek_hak_akses('.HB7.') && fcek_hak_akses('.HB8.')){
			$tipe_trans = '';
		}elseif (fcek_hak_akses('.HB7.') && !fcek_hak_akses('.HB8.')) {
			$tipe_trans = 'F';
		}elseif (!fcek_hak_akses('.HB7.') && fcek_hak_akses('.HB8.')) {
			if($this->session->userdata('svlogin') == 'C'){
				$tipe_trans = 'C';
			}else{
				$tipe_trans = '';
			}
		}	

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';
		$data['tipe_trans'] = $tipe_trans;
		// $data['import_so'] = true;

		$respon = array();
		$respon['popup'] = $this->load->view('sales/sales_order/v_sales_order_popup',$data,true);	
		echo json_encode($respon);		
	}

	public function top_so_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_order');		
		$vok = true;

		// set data
		if($vok){
			$data['header']['trso_no'] = $this->input->post('trso_no');
			$data['trso_cekint'] = $this->input->post('trso_cekint');
			$data['top_so'] = $this->input->post('top_so');
		}		

		// cek data valid
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('EDIT_TOP_SO', $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}	

		// void data
		if($vok){
			$vresult = $this->m_sales_order->top_so_simpan($data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');				
				$result['response'] = 'sukses';
      	 		$result['trso_no'] = $data['header']['trso_no'];
      	 		echo json_encode($result);			      	 	
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}	
	}

	public function sales_order_info(){
		// $key = $this->input->post('key');
		// $hash_key = $this->input->post('hash_key');

		// if (!$key || !$hash_key){
		// 	redirect('sales_order');
  // 	 		return;
		// }

		// if ($hash_key != fenkripsi($key)){
		// 	redirect('sales_order');
  // 	 		return;
		// }

		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		

		$respon = array();
		$respon['infolist'] = $this->load->view('sales/sales_order/v_sales_order_dashboard',$data,true);	
		echo json_encode($respon);		
	}

	public function sales_order_edit_catatan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_order');

		$vok = true;

		// set data
		if($vok){
			$data['trso_cekint'] = $this->input->post('trso_cekint');			
			$data['header']['trso_no'] = $this->input->post('trso_no');
			$data['header']['trso_catatan'] = $this->input->post('trso_catatan');
		}

		// cek data valid
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('EDIT_CATATAN', $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}	

		// void data
		if($vok){
			$vresult = $this->m_sales_order->sales_order_edit_catatan($data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');				
				$result['response'] = 'sukses';
      	 		$result['trso_no'] = $data['header']['trso_no'];
      	 		echo json_encode($result);			      	 	
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}	
	}

	public function sales_order_lockso(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_order');

		$vok = true;

		// set data
		if($vok){
			$data['header']['trso_no'] = $this->input->post('trso_no');
			$data['trso_cekint'] = $this->input->post('trso_cekint');
			$data['trso_sisadp'] = $this->input->post('trso_sisadp');
		}

		// cek data valid
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('LOCKSO', $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}	

		// void data
		if($vok){
			$vresult = $this->m_sales_order->sales_order_lockso(null, $data['header']['trso_no']);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');				
				$result['response'] = 'sukses';
      	 		$result['trso_no'] = $data['header']['trso_no'];
      	 		echo json_encode($result);			      	 	
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}	
	}	

	public function sales_order_cancellockso(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_order');

		$vok = true;

		// set data
		if($vok){
			$data['trso_cekint'] = $this->input->post('trso_cekint');
			$data['trso_stcopy'] = $this->input->post('trso_stcopy');
			$data['header']['trso_no'] = $this->input->post('trso_no');
			$data['header']['trso_total'] = ftodouble($this->input->post('trso_total'));
		}		

		// cek data valid
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('CANCEL_LOCKSO', $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}	

		// cancel lock so
		if($vok){
			$vresult = $this->m_sales_order->sales_order_cancellockso($data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');				
				$result['response'] = 'sukses';
      	 		$result['trso_no'] = $data['header']['trso_no'];
      	 		echo json_encode($result);			      	 	
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}	
	}

	public function approve_underminprice(){		
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_order');
		
		$vok = true;
		$msg = '';		

		if($this->input->post('jenis_otorisasi') == 'K'){			
			$key_otorisasi = $this->input->post('key_otorisasi');
			$user_otorisasi = $this->input->post('user_otorisasi');
			$kode_otorisasi = $this->input->post('kode_otorisasi');
			$kode_otorisasi_gen = fkode_otorisasi_gen($user_otorisasi, $key_otorisasi);
			$msus_data = $this->m_user->get_user_byotoritas($user_otorisasi,'.CB9.');

			if($vok && $user_otorisasi == ''){
				$vok = false;
				$msg = 'Please input user otorisasi';
			}			

			if($vok && $kode_otorisasi != $kode_otorisasi_gen){
				$vok = false;
				$msg = 'User Otorisasi or Kode Otorisasi is invalid';
			}

			if($vok && count($msus_data) <= 0){
				$vok = false;
				$msg = 'User Otorisasi does not have permissions';
			}
		}

		if($this->input->post('jenis_otorisasi') == 'L'){
			$msus_nm = $this->input->post('msus_nm');
			$msus_pswd = do_hash($this->input->post('msus_pswd'),'md5');		
			$msus_data = $this->m_user->get_user_aktif($msus_nm,$msus_pswd);

			if($vok && $msus_nm == ''){
				$vok = false;
				$msg = 'Please input username';
			}

			if($vok && $this->input->post('msus_pswd') == ''){
				$vok = false;
				$msg = 'Please input password';
			}

			if($vok && count($msus_data) <= 0){
				$vok = false;
				$msg = 'Userame and password do not match or User is not allowed';
			}

			if($vok && preg_match("/(.CB9.)/i", $msus_data[0]['msug_hakakses']) == false){
				$vok = false;
				$msg = 'User does not have permissions';
			}
		}		

		if($vok){
			$result['response'] = "sukses";			
			$result['msus_no'] = $msus_data[0]['msus_no'];
		}else{								
			$result['response'] = "gagal";			
			$result['error_message'] = $msg;		
			$result['mt_rand'] = mt_rand(100000, 999999);		
		}

		echo json_encode($result);
	}		

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'trso_mscs_no',
		                'label' => 'Customer',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),
		        array(
		                'field' => 'trso_mssl_no',
		                'label' => 'Sales',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),
		        array(
		                'field' => 'trso_tophari',
		                'label' => 'TOP / Number of Days',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        )
		);
		return $config;
	}						

	public function cek_valid_data_trans($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | VOID

			$msg = '';
			$hsl = true;
			$error_apv = false;

			// cek jika input SO # manual maka harus 12 karakter
			if($hsl && $menu == 'NEW' && $this->session->userdata('svlogin') == 'F'){
				if($this->input->post('trso_no') != ''){
					$this->form_validation->set_rules('trso_no', 'SO #', 'min_length[12]|max_length[12]');
					if ($this->form_validation->run() == FALSE){
						$hsl = false;				
						$msg = 'The length of the SO ID should be 12';
					}
				}				
			}

			// cek jika input SO # manual maka ID harus unik
			if($hsl && $menu == 'NEW' && $this->session->userdata('svlogin') == 'F'){
				if($this->input->post('trso_no') != ''){					
					if ($this->m_sales_order->cek_trso_no_exists($this->input->post('trso_no'))){
						$hsl = false;				
						$msg = 'SO # already exists';
					}
				}				
			}

			if($menu == 'NEW' || $menu == 'EDIT'){
				// cek trso_tgl tidak boleh sama dengan tgl trso_tglestkirim
				if($hsl){
					if($this->input->post('trso_tgl') == $this->input->post('trso_tglestkirim')){	
						$hsl = false;					
						$msg = 'Shipping date may not be the same as the estimated date';					
					}
				}

				// cek customer harus terdaftar di data master
				if($hsl){					
					if(!$this->m_sales_order->cek_trso_mscs_no_exists($data['header']['trso_mscs_no'])){	
						$hsl = false;					
						$msg = 'Please input customer correctly';					
					}
				}

				// cek produk harus dipilih
				if($hsl){
					if(!isset($this->data['detail'])){
						$hsl = false;					
						$msg = 'Please select product';					
					}	
				}

				// cek harga bftax tidak boleh dibawah harga minimum (hasil hitungan (pricelist - % 1, 2 dan 3) di ms_kategori)
				if($hsl){				
					$msg .= 'The price of the following products is less than the minimum price. To continue the process, please input approval:';
					if(isset($data['detail'])){
						foreach ($data['detail'] as $key => $value) {
							if (($data['detail'][$key]['dtso_mdpp_no'] == '') || ($data['detail'][$key]['dtso_mdpp_no'] != '' && $data['detail'][$key]['dtso_statuspaket'] == 'P')) {
								// $dtso_bftax = fhapus_kutip(ftodouble($data['detail'][$key]['dtso_bftax']));
								$dtso_nett = fhapus_kutip(ftodouble($data['detail'][$key]['dtso_nett']));
								$dtso_minprice = fhapus_kutip(ftodouble($data['detail'][$key]['dtso_minprice']));
								if($dtso_nett < $dtso_minprice && $data['detail'][$key]['dtso_msus_no'] == ""){
									$msg .= ' <br/> - Product ID: '.$data['detail'][$key]['dtso_mspd_no'];
									$hsl = false;													
									$error_apv = true;
								}
							}
							unset($this->data['detail'][$key]['dtso_minprice']);	
							unset($this->data['detail'][$key]['dtso_msus_no']);
						}					
					}				
				}

				// cek produk mesin tidak boleh > 1
				if($hsl){				
					if(isset($data['detail'])){
						foreach ($data['detail'] as $key => $value) {							
							if ($data['detail'][$key]['mspd_reqserialno'] == 'Y' && $data['detail'][$key]['dtso_qty'] > 1) {
								$hsl = false;																					
								$msg = 'Machine products can not be more than one';
							}							
							unset($this->data['detail'][$key]['mspd_reqserialno']);
						}					
					}								
				}

				// cek total TOP SO harus <= Total SO
				// if($hsl){				
				// 	if(ftodouble($this->input->post('top_total')) > ftodouble($this->input->post('trso_total'))){
				// 		$hsl = false;					
				// 		$msg = 'TOP Total must be <= SO Total';					
				// 	}				
				// }

				// cek total Total TOP persen harus <= 100
				// if($hsl){				
				// 	if(ftodouble($this->input->post('top_persen_total')) > 100){
				// 		$hsl = false;					
				// 		$msg = 'Total TOP percent must be <= 100';					
				// 	}				
				// }

				// cek kelas harus disi
				if($hsl){				
					if($data['action'] == 'NEW' && $this->input->post('trso_fin') == 'C' && $this->input->post('trso_klas') ==  ''){
						$hsl = false;					
						$msg = 'Please select classification';
					}				
				}

				// cek total so tidak boleh > 400 jt
				if($hsl){
					$trso_no = ($data['action'] == 'NEW') ? '' : $this->input->post('trso_no');
					$trso_total = ftodouble($this->input->post('trso_total'));
					$total_bulan_ini = $this->m_sales_order->get_trso_total_currmonth($this->input->post('trso_klas'), $trso_no);
					if($this->input->post('trso_fin') == 'C' && ($total_bulan_ini + $trso_total) > 400000000){
						$hsl = false;
						$msg = 'Total transactions in this month have exceeded the limit.'
								.'<br/> - Limit Rp 400,000,000'
								.'<br/> - Total in this month Rp '.number_format($total_bulan_ini)
								.'<br/> - Remains Rp '.number_format((400000000 - $total_bulan_ini));
					}
				}
			}


			if($menu == 'EDIT' || $menu == 'VOID'){
				//cek data tidak bisa di edit kalau sudah dibuat so payment atau sales delivery
				if($hsl){
					if($this->input->post('is_sdcreated') == 1 || $this->input->post('is_spcreated') == 1){
						$hsl = false;					
						$msg = 'Data can not be edit/void, so payment or sales delivery transaction has been created';
					}
				}
			}

			// cek tidak boleh di cancel kalo status copy-nya (X)
			if($hsl && $menu == 'CANCEL_LOCKSO'){
				if($data['trso_stcopy'] == 'X'){
					$hsl = false;					
					$msg = 'Transaction cannot be cancelled. Please change status exclude (X) first.';
				}	
			}

			// cek jika sisa DP > 0 maka tidak bisa di lock
			if($hsl && $menu == 'LOCKSO'){
				if($data['trso_sisadp'] > 0){
					$hsl = false;					
					$msg = 'Cannot lock SO. (DP > 0)';
				}	
			}
			
			// utk pengecekan cekint Sales Order, 
			// Valid = CekInt tidak berubah			
			if ($hsl && $menu != 'NEW') {
				if($this->m_sales_order->get_sales_order_cekint($data['header']['trso_no'], $data['trso_cekint']) == false){
					$hsl = false;					
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_sales_order->set_sales_order_cekint($data['header']['trso_no']);
				}
			}

			return array('valid'=>$hsl, 'msg'=>$msg, 'error_apv' => $error_apv);
	}	

}