<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class sales_delivery extends MY_Controller {
	private $data = array();	

	function __construct(){
		parent::__construct();
		$this->load->model('stok_kontrol/m_sales_delivery');
		$this->load->model('stok_kontrol/m_stok');
		$this->load->model('sales/m_sales_order');
		$this->load->model('finance_and_acc/m_so_payment');	
		$this->load->model('finance_and_acc/m_jurnal');	
		$this->load->model('setting/m_setting_account');
		$this->load->model('data_master/m_produk');
		$this->load->model('data_master/m_kategori');
		$this->load->model('setting/m_setting');
		$this->load->model('setting/m_setting_efaktur');	
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index(){
		if(!fcek_hak_akses('.DB0.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['mskt'] = $this->m_kategori->get_all_kategori();	
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('stok_kontrol/sales_delivery/v_sales_delivery_list', $data);
		$this->load->view('v_footer');			
	}

	public function sales_delivery_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_delivery');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['sales_delivery_list'] = $this->m_sales_delivery->get_sales_delivery_list($arr_filter, false, $per_page, $offset, $fn, $sort);
		$data['request_from'] = $this->input->post('request_from');

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['sales_delivery_list']);
		}
		else {
			$pagination['total_list'] = $this->m_sales_delivery->get_sales_delivery_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['sales_delivery_list'] = $this->load->view('stok_kontrol/sales_delivery/v_sales_delivery_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function sales_delivery_dtlist(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_delivery');

		$data = array();
		$result = array();
		$pagination = array();

		$per_page = $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');
		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			

		$data['sales_delivery_dtlist'] = $this->m_sales_delivery->get_sales_delivery_dtlist($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;
		$pagination['total_list'] = $this->m_sales_delivery->get_sales_delivery_dtlist($arr_filter, true);		
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['sales_delivery_dtlist'] = $this->load->view('stok_kontrol/sales_delivery/v_sales_delivery_dtdatalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $this->m_sales_delivery->get_sales_delivery_dtlist($arr_filter, true);
		
		echo json_encode($result);
	}
	
	public function sales_delivery_new($trso_no = null){	
		if(!fcek_hak_akses('.DB1.')) {
			redirect('forbidden');
		}

		$data = array();
		if(is_null($trso_no)){			
			$data['action'] = 'new';
		}else{
			$data = $this->m_sales_order->get_sales_order($trso_no);
			
			if(count($data) <= 0) {
				redirect('sales_order');
				return;
			}else{				
				$data['action'] = 'new_import';
			}				
		}
				
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('stok_kontrol/sales_delivery/v_sales_delivery_form',$data);
		$this->load->view('v_footer');		
	}

	public function sales_delivery_view($trsd_no){	
		if(!fcek_hak_akses('.DB0.')) {
			redirect('forbidden');
		}

		$data = array();				
		$data_sd = $this->m_sales_delivery->get_sales_delivery($trsd_no);

		if (is_null($trsd_no) || count($data_sd) <= 0) {
			redirect('sales_delivery');
			return;
		}		
		
		$data['header'] = $data_sd['header'];
		$data['detail'] = $data_sd['detail'];

		$trju_no1 = $this->m_jurnal->get_jurnalid($trsd_no.'SD');
		if($trju_no1 != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no1);			
			$data['jurnal_dlvnow_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_dlvnow_d'] = $data_jurnal['jurnal_d'];				
		}

		$trju_no2 = $this->m_jurnal->get_jurnalid($trsd_no.'DR');
		if($trju_no2 != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no2);			
			$data['jurnal_cnfdlv_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_cnfdlv_d'] = $data_jurnal['jurnal_d'];			
		}
				
		
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('stok_kontrol/sales_delivery/v_sales_delivery_form',$data);
		$this->load->view('v_footer');		
	}

	public function sales_delivery_print(){
		$this->load->library('java_bridge');
		$trsd_no = $this->input->get('trsd_no');
		$trso_no = $this->input->get('trso_no');
		$paper_size = $this->input->get('paper_size');
		$trsd_tglkirim = $this->input->get('trsd_tglkirim');
		$trsd_tglbalik = $this->input->get('trsd_tglbalik');
		$jns_print = $this->input->get('jns_print');

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];


		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}
		
		// Jenis Print (Preparation / Surat Jalan)
		if($jns_print == "SJ"){ // print surat jalan
			if($paper_size == 'A5'){
				$path = APPPATH.'prints\sales\sales_delivery\p_sales_delivery_A5.jrxml';
			}elseif($paper_size == 'A4') {
				$path = APPPATH.'prints\sales\sales_delivery\p_sales_delivery_A4.jrxml';
			}

			if($trsd_tglkirim == '0000-00-00' && $trsd_tglbalik == '0000-00-00'){
				$jenis_suratjalan = 'PREPARATION';
			}else if($trsd_tglkirim != '0000-00-00' && $trsd_tglbalik == '0000-00-00'){
				$jenis_suratjalan = 'DELIVERY';
			}else if($trsd_tglkirim != '0000-00-00' && $trsd_tglbalik != '0000-00-00'){
				$jenis_suratjalan = 'CONFIRM';
			}
			

			$params = new Java("java.util.HashMap");
			$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
			$params->put("P_TRSD_NO",new Java('java.lang.String', $trsd_no));
			$params->put("jenis_suratjalan",new Java('java.lang.String', $jenis_suratjalan));
			$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
			$params->put("alamat_area",new Java('java.lang.String', $line1));
			$params->put("telp_area",new Java('java.lang.String', $line2));
			$params->put("user_print",new Java('java.lang.String', $this->session->userdata('user_aktif')['msus_no']. ' - ' . $this->session->userdata('user_aktif')['msus_nm']));

		}else{  // print preparation
			if($paper_size == 'A5'){
				$path = APPPATH.'prints\sales\sales_delivery\p_sales_prepar_A5.jrxml';
			}elseif($paper_size == 'A4') {
				$path = APPPATH.'prints\sales\sales_delivery\p_sales_prepar_A4.jrxml';
			}

			$params = new Java("java.util.HashMap");
			$params->put("P_IMG_PATH",new Java('java.lang.String', realpath(".")."/asset/images/logo-pjs.png"));
			$params->put("P_TRSO_NO",new Java('java.lang.String', $trso_no));
			$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
			$params->put("alamat_area",new Java('java.lang.String', $line1));
			$params->put("telp_area",new Java('java.lang.String', $line2));
			$params->put("user_print",new Java('java.lang.String', $this->session->userdata('user_aktif')['msus_no']. ' - ' . $this->session->userdata('user_aktif')['msus_nm']));
		}

		//load print jrxml file
		$this->java_bridge->print_data($path, $params);
	}

	public function sales_delivery_print_faktur(){
		$this->load->library('java_bridge');
		$trsd_no = $this->input->get('trsd_no');
		$paper_size = $this->input->get('paper_size');
		$show_ppn = $this->input->get('show_ppn');
		$show_totalkirim = $this->input->get('show_totalkirim');
		$top_no = substr(($this->input->get('trsd_no')),0,12);
	

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];

		$note1 = $this->session->userdata('user_aktif')['mscb_footer1'];
		$note2 = $this->session->userdata('user_aktif')['mscb_footer2'];
		$note3 = $this->session->userdata('user_aktif')['mscb_footer3'];
		$note4 = $this->session->userdata('user_aktif')['mscb_footer4'];
		$note5 = $this->session->userdata('user_aktif')['mscb_footer5'];
		// echo "<pre>"; print_r($this->session->userdata('user_aktif')); die();

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		$query = $this->db->get_where('top_so', array('tpso_no' => $top_no));
		$toplist = $query->result(); 
		$top="";
		foreach ($toplist as $value) {
			$top .= $value->tpso_tgljatuhtempo ." ".$value->tpso_cttn." ". number_format($value->tpso_value)."\n";
			}
			
		if($paper_size == 'A5'){
			$path = APPPATH.'prints\sales\sales_faktur\p_sales_faktur_A5.jrxml';
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\sales\sales_faktur\p_sales_faktur_A4.jrxml';
		}


		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$params->put("P_TRSD_NO",new Java('java.lang.String', $trsd_no));
		$params->put("show_ppn",new Java('java.lang.String', $show_ppn));
		$params->put("show_totalkirim",new Java('java.lang.String', $show_totalkirim));
		$params->put("top_tgl",new Java('java.lang.String', $top));
		$params->put("note1",new Java('java.lang.String', $note1));
		$params->put("note2",new Java('java.lang.String', $note2));
		$params->put("note3",new Java('java.lang.String', $note3));
		$params->put("note4",new Java('java.lang.String', $note4));
		$params->put("note5",new Java('java.lang.String', $note5));
		$params->put("user_print",new Java('java.lang.String', $this->session->userdata('user_aktif')['msus_no']. ' - ' . $this->session->userdata('user_aktif')['msus_nm']));

		$this->java_bridge->print_data($path, $params);
	}

	public function sales_delivery_print_faktur_negara(){
		$this->load->library('java_bridge');
		$trsd_no = $this->input->get('trsd_no');
		$tgl_faktur = $this->input->get('faktur_tgl');

		// update trsd_fakturtgl ---------
		$this->db->set('trsd_fakturtgl', $tgl_faktur);
		$this->db->where('trsd_no', $trsd_no);
		$this->db->update('tr_sales_dlv'); 
		// end update --------------------

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		$path = APPPATH.'prints\sales\sales_faktur\p_sales_faktur_negara_A4.jrxml';

		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$params->put("P_TRSD_NO",new Java('java.lang.String', $trsd_no));
		$params->put("user_print",new Java('java.lang.String', $this->session->userdata('user_aktif')['msus_no']. ' - ' . $this->session->userdata('user_aktif')['msus_nm']));

		$this->java_bridge->print_data($path, $params);
	}

	//==========================================================================================================
	//============== CSV eFaktur berikut ini sudah disesuaikan untuk program DJP 3.2 (April 2022) ==============
	//==========================================================================================================
	public function sales_delivery_eksport_txtfile_csv_efaktur(){
		$trsd_no = $this->input->get('trsd_no');
		$tgl_faktur = $this->input->get('faktur_tgl');
		$no_faktur = $this->input->get('faktur_no');
		// echo $trsd_no;

		// update trsd_fakturtgl -------------------------------------------------------
		$update = array('trsd_fakturtgl' => $tgl_faktur, 'trsd_fakturno' => $no_faktur);
		$this->db->where('trsd_no', $trsd_no);
		$this->db->update('tr_sales_dlv', $update); 
		// end update ------------------------------------------------------------------
		
		// === CREATE CSV FILE ======================================================================================================
		$filename = 'eFaktur '. $trsd_no . '.csv';
		$myfile = fopen($filename,'w');

		$OutLine = '"FK","KD_JENIS_TRANSAKSI","FG_PENGGANTI","NOMOR_FAKTUR","MASA_PAJAK","TAHUN_PAJAK","TANGGAL_FAKTUR"';
		$OutLine = $OutLine . ',"NPWP","NAMA","ALAMAT_LENGKAP","JUMLAH_DPP","JUMLAH_PPN","JUMLAH_PPNBM","ID_KETERANGAN_TAMBAHAN"';
		$OutLine = $OutLine . ',"FG_UANG_MUKA","UANG_MUKA_DPP","UANG_MUKA_PPN","UANG_MUKA_PPNBM","REFERENSI","KODE_DOKUMEN_PENDUKUNG"';
		$OutLine = $OutLine . "\n";
		fwrite($myfile, $OutLine);

		$OutLine = '"LT","NPWP","NAMA","JALAN","BLOK","NOMOR","RT","RW","KECAMATAN","KELURAHAN","KABUPATEN","PROPINSI"';
        $OutLine = $OutLine . ',"KODE_POS","NOMOR_TELEPON"';
		$OutLine = $OutLine . "\n";
		fwrite($myfile, $OutLine);

		$OutLine = '"OF","KODE_OBJEK","NAMA","HARGA_SATUAN","JUMLAH_BARANG","HARGA_TOTAL","DISKON","DPP","PPN","TARIF_PPNBM","PPNBM"';
		$OutLine = $OutLine . "\n";
		fwrite($myfile, $OutLine);

		// CALCULATE TOTAL DPP dan PPN dari detail ========================================
		$total_dpp = 0;
		$total_ppn = 0;
		// get data detail from model (database)--------------------------------------------------------------------
		$detail = $this->m_sales_delivery->get_eksport_csv_efaktur_details($trsd_no);
		foreach ($detail as $key => $data) {
			$total_dpp += round(($data['dtsd_qtykrm']-$data['dtsd_qtyrej'])*$data['dtsd_bftax']);
			$total_ppn += round(($data['dtsd_qtykrm']-$data['dtsd_qtyrej'])*$data['dtsd_tax']);
		}
		// END - CALCULATE TOTAL DPP dan PPN dari detail ==================================
		
		
		// ============================================ Tulis bagian FK ============================================
		// get data header from model (database)--------------------------------------------------------------------
		$header = $this->m_sales_delivery->get_eksport_csv_efaktur_header($trsd_no);
		foreach ($header as $key => $data) {
			$OutLine = '"FK","01","0","'.  $data['trsd_fakturno'] .'","'. substr($data['trsd_fakturtgl'],5,2) .'","'. substr($data['trsd_fakturtgl'],0,4) .'"';
			$OutLine = $OutLine . ',"'. date('d/m/Y',strtotime($data['trsd_fakturtgl'])) .'"';
			$OutLine = $OutLine . ',"'. preg_replace('/[^a-zA-Z0-9]/', '', $data['mscs_npwp']) .'"';
			$OutLine = $OutLine . ',"'. $data['mscs_nm'] .'"';
			$OutLine = $OutLine . ',"'. preg_replace( '/\r|\n/', ' ', $data['trso_alamatnpwp']) .'"';
			// $OutLine = $OutLine . ',"'. round($data['dpp_total']) .'"';
			// $OutLine = $OutLine . ',"'. round($data['ppn_total']) .'"';
			$OutLine = $OutLine . ',"'. $total_dpp .'"';
			$OutLine = $OutLine . ',"'. $total_ppn .'"';
			$OutLine = $OutLine . ',"0","","0","0","0","0","'. $data['trsd_no'] .'",';
			$OutLine = $OutLine . "\n";
			fwrite($myfile, $OutLine);
		}

		// ============================================ Tulis bagian FAPR ============================================
		$fapr = $this->m_setting_efaktur->get_setting_efaktur();
		$OutLine = '"FAPR","'.$fapr['fapr_compname'].'","'.$fapr['fapr_address'].'","","","",';
		$OutLine = $OutLine . "\n";
		fwrite($myfile, $OutLine);


		// ============================================ Tulis bagian OF ============================================
		// get data detail from model (database)--------------------------------------------------------------------
		// $detail = $this->m_sales_delivery->get_eksport_csv_efaktur_details($trsd_no);
		foreach ($detail as $key => $data) {
			$OutLine = '"OF","'. $data['dtsd_mspd_no'] .'","'. $data['mspd_nm'] .'"';
			$OutLine = $OutLine . ',"'. round($data['dtsd_bftax']) .'"';
			$OutLine = $OutLine . ',"'. ($data['dtsd_qtykrm']-$data['dtsd_qtyrej']) .'"';
			$OutLine = $OutLine . ',"'. round(($data['dtsd_qtykrm']-$data['dtsd_qtyrej'])*$data['dtsd_bftax']) .'"';
			$OutLine = $OutLine . ',"0"';
			$OutLine = $OutLine . ',"'. round(($data['dtsd_qtykrm']-$data['dtsd_qtyrej'])*$data['dtsd_bftax']) .'"';
			$OutLine = $OutLine . ',"'. round(($data['dtsd_qtykrm']-$data['dtsd_qtyrej'])*$data['dtsd_tax']) .'"';
			$OutLine = $OutLine . ',"0","0.00"';
			$OutLine = $OutLine . "\n";
			fwrite($myfile, $OutLine);
		}

		// Close and Save File to local ----------------------------------------------------------------------------
		fclose($myfile);

		header('Content-Description: File Transfer');
		header('Content-Disposition: attachment; filename='.basename($filename));
		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($filename));
		header("Content-Type: text/plain");
		readfile($filename);
	}
	    
	/*
	public function sales_delivery_eksport_csv_efaktur(){
		$trsd_no = $this->input->get('trsd_no');
		$tgl_faktur = $this->input->get('faktur_tgl');
		$no_faktur = $this->input->get('faktur_no');
		// echo $trsd_no;

		// update trsd_fakturtgl -------------------------------------------------------
		$update = array('trsd_fakturtgl' => $tgl_faktur, 'trsd_fakturno' => $no_faktur);
		$this->db->where('trsd_no', $trsd_no);
		$this->db->update('tr_sales_dlv', $update); 
		// end update ------------------------------------------------------------------

		// === CREATE CSV FILE ======================================================================================================
		$this->load->library('Excel');
		PHPExcel_Cell::setValueBinder(new PHPExcel_Cell_AdvancedValueBinder());
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$column = 0;
		$row = 0;

		// --- Header csv first line ----------------------------------------------------------------------------------------
		$row+=1; $col = -1;
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FK");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KD_JENIS_TRANSAKSI");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FG_PENGGANTI");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NOMOR_FAKTUR");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "MASA_PAJAK");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TAHUN_PAJAK");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TANGGAL_FAKTUR");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NPWP");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NAMA");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "ALAMAT_LENGKAP");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JUMLAH_DPP");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JUMLAH_PPN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JUMLAH_PPNBM");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "ID_KETERANGAN_TAMBAHAN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FG_UANG_MUKA");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "UANG_MUKA_DPP");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "UANG_MUKA_PPN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "UANG_MUKA_PPNBM");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "REFERENSI");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KODE_DOKUMEN_PENDUKUNG");
		// --- END Header csv first line ------------------------------------------------------------------------------------

		// --- Header csv second line ---------------------------------------------------------------------------------------
		$row+=1; $col = -1;
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "LT");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NPWP");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NAMA");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JALAN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "BLOK");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NOMOR");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "RT");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "RW");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KECAMATAN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KELURAHAN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KABUPATEN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "PROPINSI");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KODE_POS");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NOMOR_TELEPON");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// --- END Header csv second line ------------------------------------------------------------------------------------

		// --- Header csv third line ---------------------------------------------------------------------------------------
		$row+=1; $col = -1;
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "OF");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KODE_OBJEK");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NAMA");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "HARGA_SATUAN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JUMLAH_BARANG");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "HARGA_TOTAL");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "DISKON");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "DPP");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "PPN");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TARIF_PPNBM");
		$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "PPNBM");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
		// --- END Header csv third line ------------------------------------------------------------------------------------

		// get data header from model (database)---------------------------------------------------------------------------------------------------------
		$header = $this->m_sales_delivery->get_eksport_csv_efaktur_header($trsd_no);
		// echo "<pre>"; print_r($header); die();
		$row =4; $col = -1;
		foreach ($header as $key => $data) {
			// ---  first line data----------------------------------------------------------------------------------------
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FK");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "01");
						$object->getActiveSheet()->getStyle('B4')->getNumberFormat()->setFormatCode('00');
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "0");
			$col += 1; $object->getActiveSheet()->setCellValueExplicit('D4', $data['trsd_fakturno'], PHPExcel_Cell_DataType::TYPE_STRING);
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, substr($data['trsd_fakturtgl'],5,2));
			$object->getActiveSheet()->getStyle('E4')->getNumberFormat()->setFormatCode('00');
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, substr($data['trsd_fakturtgl'],0,4));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $data['trsd_fakturtgl']);
					   $object->getActiveSheet()->getStyle('G4')->getNumberFormat()->setFormatCode('dd/mm/yyyy');
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, preg_replace('/[^a-zA-Z0-9]/', '', $data['mscs_npwp']));
					   $object->getActiveSheet()->getStyle('H4')->getNumberFormat()->setFormatCode('000000000000000');
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $data['mscs_nm']);
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, preg_replace( '/\r|\n/', ' ', $data['mscs_almt_jln'].' '.$data['mscs_almt_kota'].' '.$data['mscs_almt_provinsi']));
			// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $dpp_total);
			// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $ppn_total);
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, round($data['dpp_total']));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, round($data['ppn_total']));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $data['trsd_no']);
			// --- END Header csv first line ------------------------------------------------------------------------------------
		}

		$detail = $this->m_sales_delivery->get_eksport_csv_efaktur_details($trsd_no);
		// echo "<pre>"; print_r($detail); die();
		// $dpp_total = 0; $ppn_total=0;
		$col = -1; $baris=5; 
		foreach ($detail as $key => $data) {
			// --- Detail Produk -------------------------------------------------------------------------------------------------
			$sheet = 'E'.$baris;
			$col = -1;
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "OF");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, $data['dtsd_mspd_no']);
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, $data['mspd_nm']);
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, round($data['dtsd_bftax']));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, $data['dtsd_qtykrm']-$data['dtsd_qtyrej'])
							  ->getStyle($sheet)->getNumberFormat()->setFormatCode("#,##0.0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, round(($data['dtsd_qtykrm']-$data['dtsd_qtyrej'])*$data['dtsd_bftax']));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, round(($data['dtsd_qtykrm']-$data['dtsd_qtyrej'])*$data['dtsd_bftax']));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, round((($data['dtsd_qtykrm']-$data['dtsd_qtyrej'])*$data['dtsd_tax'])));
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "0");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
			$baris+=1;
			// $dpp_total += round(($data['dtsd_qtykrm']-$data['dtsd_qtyrej'])*$data['dtsd_bftax']);
			// $ppn_total += round((($data['dtsd_qtykrm']-$data['dtsd_qtyrej'])*$data['dtsd_tax']));
			// --- END Detail Produk ------ ------------------------------------------------------------------------------------
		}

		

		$objWriter = PHPExcel_IOFactory::createWriter($object, 'csv');
		$objWriter->setPreCalculateFormulas(true);
        $filename='eFaktur.csv'; //save our workbook as this file name
        header('Content-Type: application/vnd.csv'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
	}
	*/

	public function sales_delivery_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_delivery');		
		$this->form_validation->set_rules($this->config_validation());			
		$vok = true;

		// set data transaksi
		if($vok){													
			$this->data['action'] = $this->input->post('action');
			$this->data['mscs_jenis'] = $this->input->post('mscs_jenis');
			$this->data['trsd_cekint'] = $this->input->post('trsd_cekint');
			$this->data['trso_cekint'] = $this->input->post('trso_cekint');
			$this->data['header']['trsd_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['trsd_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
			$this->data['header']['trsd_tag'] = fhapus_kutip($this->input->post('trsd_tag'));

			if($this->data['action'] == 'NEW'){
				$trso_no = $this->input->post('trso_no');						
				$this->data['header']['trsd_no'] = $this->m_sales_delivery->sales_delivery_kode_auto($trso_no);
				$this->data['header']['trsd_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['header']['trsd_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$this->data['header']['trsd_tgl'] = $this->input->post('trsd_tgl');
				$this->data['header']['trsd_void'] = 0;				
			}

			if($this->data['action'] != 'NEW'){
				$this->data['header']['trsd_no'] = $this->input->post('trsd_no');
			}

			if($this->data['action'] == 'NEW' || $this->data['action'] == 'EDIT' || $this->data['action'] == 'DELIVERYNOW'){
				$this->data['header']['trsd_msgd_no'] = $this->input->post('trsd_msgd_no');
				$this->data['header']['trsd_sopir'] = fhapus_kutip($this->input->post('trsd_sopir'));
				$this->data['header']['trsd_nopol'] = fhapus_kutip($this->input->post('trsd_nopol'));
			}
					
			if($this->data['action'] == 'NEW' || $this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){				
				$this->data['header']['trsd_tglestkirim'] = $this->input->post('trsd_tglestkirim');								
				$this->data['header']['trsd_mscs_no'] = substr($this->input->post('trsd_mscs_no'), 0, 6);
				$this->data['header']['trsd_alamatkirim'] = fhapus_kutip($this->input->post('trsd_alamatkirim'));
				$this->data['header']['trsd_cp'] = fhapus_kutip($this->input->post('trsd_cp'));			
				$this->data['header']['trsd_biayaekspedisi'] = ftodouble($this->input->post('trsd_biayaekspedisi'));
				// $this->data['header']['trsd_total'] = ftodouble($this->input->post('trsd_total'));
				$this->data['header']['trsd_catatan'] = fhapus_kutip($this->input->post('trsd_catatan'));				
			}

			if($this->data['action'] == 'NEW' || $this->data['action'] == 'SHIPPINGFEE'){
				$this->data['header']['trsd_noekspedisi'] = ftodouble($this->input->post('trsd_noekspedisi'));
				$this->data['header']['trsd_ekspedisi'] = fhapus_kutip($this->input->post('trsd_ekspedisi')); 
				$this->data['header']['trsd_biayaekspedisi'] = ftodouble($this->input->post('trsd_biayaekspedisi'));
			}			

			if($this->data['action'] == 'DELIVERYNOW'){
				$this->data['header']['trsd_tglkirim'] = $this->input->post('trsd_tglkirim');
				$this->data['header']['trsd_dlvnowusr'] = $this->session->userdata('user_aktif')['msus_no'];
			}			

			if($this->data['action'] == 'CANCEL_DELIVERYNOW'){
				$this->data['header']['trsd_tglkirim'] = '';
				$this->data['header']['trsd_dlvnowusr'] = '';
			}			

			if($this->data['action'] == 'CONFDELIVERY'){
				$this->data['header']['trsd_tglbalik'] = $this->input->post('trsd_tglbalik');
				$this->data['header']['trsd_cnfusr'] = $this->session->userdata('user_aktif')['msus_no'];				
				$date=date_create($this->data['header']['trsd_tglbalik']);
				date_add($date,date_interval_create_from_date_string($this->m_sales_order->get_trso_tophari(substr($this->data['header']['trsd_no'], 0, 12))." days"));
				$this->data['header']['trsd_toptgl'] = date_format($date,"Y-m-d");
			}	

			if($this->data['action'] == 'CANCEL_CONFDELIVERY'){
				$this->data['header']['trsd_tglbalik'] = '';
				$this->data['header']['trsd_toptgl'] = '';
				$this->data['header']['trsd_cnfusr'] = '';
				$this->data['trso_stcopy'] = $this->input->post('trso_stcopy');
			}

			if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['userlog']['msul_tgl'] = date('Y-m-d H:i:s');
				$this->data['userlog']['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['userlog']['msul_catatan'] = substr(trim('['.$this->data['action']. '] SLS.DLV '. $this->data['header']['trsd_no']. ' CUST:'. substr($this->input->post('trsd_mscs_no'), 9). ' '. fhapus_kutip($this->input->post('trsd_tag')). ' '. fhapus_kutip($this->input->post('trsd_catatan'))), 0, 250);
			}	

			$dtsd = $this->input->post('dtsd');							
			foreach ($dtsd as $key => $value) {
				for ($i=0; $i < count($dtsd[$key]); $i++) {																																							
					if($dtsd['dtsd_qtykrm'][$i] != 0){
						$this->data['detail'][$i]['dtsd_no'] = $this->data['header']['trsd_no'];												 	
				 		if($key == 'dtsd_qtysisa' || $key == 'dtsd_qtykrm' || $key == 'dtsd_qtyrej' || $key == 'dtsd_nett' || $key == 'dtsd_bftax' || $key == 'dtsd_tax'){
					 		$this->data['detail'][$i][$key] = ftodouble($value[$i]);	
					 	}elseif($key == 'dtsd_tglgaransisp') {
					 		if($this->data['action'] == 'CONFDELIVERY'){
					 			if($dtsd['dtsd_qtyrej'][$i] <= 0 && $dtsd['mspd_reqserialno'][$i] == 'Y'){
						 			$mspd_garansisp = $this->m_produk->get_jlh_garansi($dtsd['dtsd_mspd_no'][$i], 'mspd_garansisp');
				 					$date=date_create($this->data['header']['trsd_tglbalik']);
									date_add($date,date_interval_create_from_date_string($mspd_garansisp." days"));
									$tglgaransisp = date_format($date,"Y-m-d");				
					 				$this->data['detail'][$i]['dtsd_tglgaransisp'] = $tglgaransisp;
					 			}else{
					 				$this->data['detail'][$i]['dtsd_tglgaransisp'] = '';
					 			}
					 		}
					 	}elseif($key == 'dtsd_tglgaransijasa'){
					 		if($this->data['action'] == 'CONFDELIVERY'){
					 			if($dtsd['dtsd_qtyrej'][$i] <= 0 && $dtsd['mspd_reqserialno'][$i] == 'Y'){
						 			$mspd_garansijasa = $this->m_produk->get_jlh_garansi($dtsd['dtsd_mspd_no'][$i], 'mspd_garansijasa');
						 			$date=date_create($this->data['header']['trsd_tglbalik']);
									date_add($date,date_interval_create_from_date_string($mspd_garansijasa." days"));
									$tglgaransijasa = date_format($date,"Y-m-d");
					 				$this->data['detail'][$i]['dtsd_tglgaransijasa'] = $tglgaransijasa;
					 			}else{
					 				$this->data['detail'][$i]['dtsd_tglgaransisp'] = '';
					 			}
					 		}
					 	}else{
					 		$this->data['detail'][$i][$key] = $value[$i];	
					 	}					 

					 	if($this->data['action'] == 'DELIVERYNOW'){						 
					 		if($key == 'dtsd_mspd_no'){
								$this->data['detail'][$i]['dtsd_hpp'] = $this->m_produk->get_hpp($dtsd['dtsd_mspd_no'][$i]);
							}
						}

						if($this->data['action'] == 'CANCEL_DELIVERYNOW'){
					 		if($key == 'dtsd_mspd_no'){
								$this->data['detail'][$i]['dtsd_hpp'] = 0;
							}
						}

						if($this->data['action'] == 'CONFDELIVERY' || $this->data['action'] == 'CANCEL_CONFDELIVERY'){
					 		if($key == 'dtsd_mspd_no'){
								$this->data['detail'][$i]['dtsd_hpp'] = $this->m_sales_delivery->get_dtsd_hpp($this->data['header']['trsd_no'], $dtsd['dtsd_seq'][$i]);
							}
						}

						if($this->data['action'] == 'CANCEL_CONFDELIVERY'){
					 		if($key == 'dtsd_qtyrej'){
								$this->data['detail'][$i]['dtsd_qtyrej'] = 0;
							}
						}						
					}										
				}										
			}			
		}		

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = $this->form_validation->error_array();
				echo json_encode($result);		
			}
		}		

		//cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal($this->data);			
		}
		
		// cek valid data jurnal		
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal($this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}		

		// simpan data
		if($vok){
			$vresult = $this->m_sales_delivery->sales_delivery_simpan($this->data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');
				$result['response'] = 'sukses';
      	 		$result['trsd_no'] = $this->data['header']['trsd_no'];      	 		
      	 		echo json_encode($result);
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}
	}

	private function set_data_jurnal($data){		
		if($data['action'] == 'DELIVERYNOW' && isset($data['detail']) || $data['action'] == 'CONFDELIVERY' && isset($data['detail'])){			
			//Header jurnal
			if($data['action'] == 'DELIVERYNOW'){
				$trju_tgl = $data['header']['trsd_tglkirim'];
			}

			if($data['action'] == 'CONFDELIVERY'){
				$trju_tgl = $data['header']['trsd_tglbalik'];
			}
			
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);			
			$tahun = substr($trju_tgl, 2, 2);
			$separator = ($this->input->post('trso_fin') == 'F') ? '-' : '_';
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$trju_catatan = $data['header']['trsd_tag'].' '.$data['header']['trsd_no'].'/'.substr($this->input->post('trsd_mscs_no'), 0, 6). ' - '. substr($this->input->post('trsd_mscs_no'), 9);

			if($data['action'] == 'DELIVERYNOW'){
				$data['jurnal_h']['trju_refno'] = $data['header']['trsd_no'].'SD';			
				$data['jurnal_h']['trju_reftipe'] = 'SD';
			}

			if($data['action'] == 'CONFDELIVERY'){
				$data['jurnal_h']['trju_refno'] = $data['header']['trsd_no'].'DR';			
				$data['jurnal_h']['trju_reftipe'] = 'DR';
			}

			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);							
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_void'] = 0;			
			$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
			$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trso_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trso_fin');
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));

			// Set account
			if(isset($data['detail'])){
				$data['jurnal_d'] = array();
				$array = array();
				foreach ($data['detail'] as $key => $value) {						
			 		// Set account delivery now
			 		if($data['action'] == 'DELIVERYNOW'){
				 		// Account Piutang (Debet) / Penjualan dan PPN Keluaran (Kredit)
				 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
				 			$mskt_no = substr($data['detail'][$key]['dtsd_mspd_no'], 0, 1);					
						 	// $saldo = round((ftodouble($data['detail'][$key]['dtsd_nett']) * (ftodouble($data['detail'][$key]['dtsd_qtykrm']) - ftodouble($data['detail'][$key]['dtsd_qtyrej']))), 4); 
						 	$saldo = round((ftodouble($data['detail'][$key]['dtsd_nett']) * ftodouble($data['detail'][$key]['dtsd_qtykrm'])), 4); 
						 	// $bftax = round((ftodouble($data['detail'][$key]['dtsd_bftax']) * (ftodouble($data['detail'][$key]['dtsd_qtykrm']) - ftodouble($data['detail'][$key]['dtsd_qtyrej']))), 4); 
						 	$bftax = round((ftodouble($data['detail'][$key]['dtsd_bftax']) * ftodouble($data['detail'][$key]['dtsd_qtykrm'])), 4); 
						 	//$tax = round((ftodouble($data['detail'][$key]['dtsd_tax']) * (ftodouble($data['detail'][$key]['dtsd_qtykrm']) - ftodouble($data['detail'][$key]['dtsd_qtyrej']))), 4); 
							$tax = $saldo - $bftax;

							// Account Piutang Retail / Agen (Debet)
							if($data['mscs_jenis'] == 'A'){
								$acc = $this->m_setting_account->get_setting_account_byid('PIUA');					
							}else{
								$acc = $this->m_setting_account->get_setting_account_byid('PIUR');
							}

							$array['dtju_msap_no'] =  $acc['mssa_msap_no'];
							$array['dtju_debet'] = $saldo;
							$array['dtju_kredit'] = 0;
							array_push($data['jurnal_d'], $array);

							// Account Penjualan (Kredit)
							if($data['mscs_jenis'] == 'A'){
						 		$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_pja');
						 	} else {
						 		$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_pjr');
						 	}

						 	$array['dtju_msap_no'] = $acc;
					 		$array['dtju_debet'] = 0;
					 		$array['dtju_kredit'] = $bftax;
					 		array_push($data['jurnal_d'], $array);

					 		// Account PPN Keluaran (Kredit)							
					 		$acc = $this->m_setting_account->get_setting_account_byid('PPNK');
						 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
					 		$array['dtju_debet'] = 0;
					 		$array['dtju_kredit'] = $tax;
					 		array_push($data['jurnal_d'], $array);
				 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

				 		// Account HPP (Debet) dan Inventory (Kredit)
				 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
					 		// $saldo = ftodouble($data['detail'][$key]['dtsd_hpp']) * (ftodouble($data['detail'][$key]['dtsd_qtykrm']) - ftodouble($data['detail'][$key]['dtsd_qtyrej']));
					 		$saldo = round((ftodouble($data['detail'][$key]['dtsd_hpp']) * ftodouble($data['detail'][$key]['dtsd_qtykrm'])), 4);

					 		// Account HPP (Debet)
							if($data['mscs_jenis'] == 'A'){				 		
						 		$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpa');
							} else {
								$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpr');
							}

					 		$array['dtju_msap_no'] = $acc;
					 		$array['dtju_debet'] = $saldo;
					 		$array['dtju_kredit'] = 0;
					 		array_push($data['jurnal_d'], $array);	

					 		// Account Inventory (Kredit)
					 		$array['dtju_msap_no'] = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
							$array['dtju_debet'] = 0;
					 		$array['dtju_kredit'] = $saldo;
					 		array_push($data['jurnal_d'], $array);
				 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
					}

				 	// Set account confirm delivery
				 	if($data['action'] == 'CONFDELIVERY'){
				 		if($data['detail'][$key]['dtsd_qtyrej'] != 0){
						 	// Account Penjualan dan PPN Keluaran (Debet) / Piutang (Kredit)
					 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv				
					 			$mskt_no = substr($data['detail'][$key]['dtsd_mspd_no'], 0, 1); 		
							 	$saldo = round((ftodouble($data['detail'][$key]['dtsd_nett']) * ftodouble($data['detail'][$key]['dtsd_qtyrej'])), 4); 
							 	$bftax = round((ftodouble($data['detail'][$key]['dtsd_bftax']) * ftodouble($data['detail'][$key]['dtsd_qtyrej'])), 4); 
							 	// $tax = round((ftodouble($data['detail'][$key]['dtsd_tax']) * ftodouble($data['detail'][$key]['dtsd_qtyrej'])), 4); 
							 	$tax = $saldo - $bftax;

								// Account Penjualan (Debet)
								if($data['mscs_jenis'] == 'A'){
							 		$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_pja');
							 	} else {
							 		$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_pjr');
							 	}

							 	$array['dtju_msap_no'] = $acc;
						 		$array['dtju_debet'] = $bftax;
						 		$array['dtju_kredit'] = 0;
						 		array_push($data['jurnal_d'], $array);

						 		// Account PPN Keluaran (Debet)
						 		$acc = $this->m_setting_account->get_setting_account_byid('PPNK');
							 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
						 		$array['dtju_debet'] = $tax;
						 		$array['dtju_kredit'] = 0;
						 		array_push($data['jurnal_d'], $array);

								// Account Piutang Retail / Agen (Kredit)
								if($data['mscs_jenis'] == 'A'){
									$acc = $this->m_setting_account->get_setting_account_byid('PIUA');					
								}else{
									$acc = $this->m_setting_account->get_setting_account_byid('PIUR');
								}

								$array['dtju_msap_no'] = $acc['mssa_msap_no'];
								$array['dtju_debet'] = 0;
								$array['dtju_kredit'] = $saldo;
								array_push($data['jurnal_d'], $array);							
					 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

					 		// Account HPP (Kredit) dan Inventory (Debet)
					 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
						 		$saldo = round(ftodouble($data['detail'][$key]['dtsd_hpp']) * ftodouble($data['detail'][$key]['dtsd_qtyrej']), 4);

						 		// Account Inventory (Debet)
						 		$array['dtju_msap_no'] = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
								$array['dtju_debet'] = $saldo;
						 		$array['dtju_kredit'] = 0;
						 		array_push($data['jurnal_d'], $array);

						 		// Account HPP (Kredit)
								if($data['mscs_jenis'] == 'A'){				 		
							 		$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpa');
								} else {
									$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpr');
								}

								$array['dtju_msap_no'] = $acc;
						 		$array['dtju_debet'] = 0;
						 		$array['dtju_kredit'] = $saldo;
						 		array_push($data['jurnal_d'], $array);						 		
					 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
						}						
					}	
					if(count($data['jurnal_d']) > 0){
						$this->data['jurnal_d'] = $data['jurnal_d'];					
					}
				}			
			}				
			$this->data['jurnal_h'] = $data['jurnal_h'];
		}
		
		if($data['action'] == 'CANCEL_DELIVERYNOW'){
			$this->data['jurnal_h']['trju_no'] = $this->input->post('trju_no1');
		}

		if($data['action'] == 'CANCEL_CONFDELIVERY'){
			$this->data['jurnal_h']['trju_no'] = $this->input->post('trju_no2');
		}
	}

	public function sales_delivery_dtpopup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_delivery');

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		$data['tipe_trans'] = $this->input->post('tipe_trans');

		$respon = array();
		$respon['popup'] = $this->load->view('stok_kontrol/sales_delivery/v_sales_delivery_dtpopup',$data, true);	
		echo json_encode($respon);		
	}

	public function sales_delivery_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_delivery');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';
		$data['confirm_status'] = $this->input->post('confirm_status');
		$data['payment_status'] = $this->input->post('payment_status');
		$data['confirm_status_disabled'] = $this->input->post('confirm_status_disabled');
		$data['payment_status_disabled'] = $this->input->post('payment_status_disabled');
			
		$respon = array();
		$respon['popup'] = $this->load->view('stok_kontrol/sales_delivery/v_sales_delivery_popup',$data,true);
		echo json_encode($respon);		
	}

	public function get_sales_delivery_bycust(){
		$mscs_no = $this->input->post('mscs_no');
		$data = $this->m_sales_delivery->get_sales_delivery_bycust($mscs_no);
		echo json_encode($data);
	}	

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'trsd_msgd_no',
		                'label' => 'Warehouse',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )
		        // array(
		        //         'field' => 'trsd_sopir',
		        //         'label' => 'Driver',
		        //         'rules' => 'required',
		        //         'errors' => array(
		        //                 'required' => ' Please select %s. '
		        //         )
		        // ),
		        // array(
		        //         'field' => 'trsd_nopol',
		        //         'label' => 'License Number',
		        //         'rules' => 'required',
		        //         'errors' => array(
		        //                 'required' => ' Please select %s. '
		        //         )
		        // )
		);
		return $config;
	}

	private function cek_valid_data_jurnal($data){		
		$msg = '';
		$hsl = true;

		// cek setting account harus diisi
		if($hsl){
			if(!$this->m_setting_account->get_setting_account_byid('PIUA') ||
				!$this->m_setting_account->get_setting_account_byid('PIUR') ||
				!$this->m_setting_account->get_setting_account_byid('PPNK')){
				$hsl = false;				
				$msg = 'There is an account that has not been set';
			}
		}	

		//cek akun perkiraan di master kategori harus diisi
		if($hsl){
			if(isset($data['detail'])){
				foreach ($data['detail'] as $key => $value) {
					$mskt_no = substr($data['detail'][$key]['dtsd_mspd_no'], 0, 1);					
					if(!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv') ||
						!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_pjr') ||
						!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_pja') ||
						!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpr') ||
						!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_hpa')){
						$hsl = false;						
						$msg = 'There is an account not yet filled in Category Master';
					}								
				}
			}
		}

		return array('valid'=>$hsl, 'msg'=>$msg);	
	}	

	private function cek_valid_data_trans($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | DELIVERYNOW | CONFDELIVERY | VOID

			$msg = '';
			$hsl = true;
			$tgl_cls_jurnal = $this->m_setting->get_setting('simr_char1','tcj', 1);

			if($menu == 'DELIVERYNOW' || $menu == 'CONFDELIVERY'){
				// cek jika tgl/bln jurnal sudah diclosing maka transaksi tidak bisa di create/edit/void
				if($menu == 'DELIVERYNOW' || $menu == 'CANCEL_CONFDELIVERY'){
					$tgl_trans = $this->input->post('trsd_tglkirim');
				}else if($menu == 'CONFDELIVERY' || $menu == 'CANCEL_CONFDELIVERY'){
					$tgl_trans = $this->input->post('trsd_tglbalik');
				}

				$tahun = substr($tgl_trans, 0, 4);
				$bulan = substr($tgl_trans, 5, 2);	
				$tgl_trans = (int)$tahun.$bulan;

				if($hsl && $tgl_trans <= $tgl_cls_jurnal){
					$hsl = false;
					$msg = 'Can not create new/edit/void transaction if journal transaction date is closed. Please choose another date.';
				}
			}

			if($menu == 'CANCEL_DELIVERYNOW' || $menu == 'CANCEL_CONFDELIVERY'){
				// transaksi tidak bisa di cancel jika jurnal sudah di closing
				if($menu == 'CANCEL_DELIVERYNOW'){
					$tgl_trans = $this->input->post('trsd_tglkirim');
					$is_recon_exists = $this->m_app->is_recon_exists($data['header']['trsd_no'].'SD');
				}

				if($menu == 'CANCEL_CONFDELIVERY'){
					$tgl_trans = $this->input->post('trsd_tglbalik');
					$is_recon_exists = $this->m_app->is_recon_exists($data['header']['trsd_no'].'DR');
				}

				$tahun = substr($tgl_trans, 0, 4);
				$bulan = substr($tgl_trans, 5, 2);	
				$tgl_trans = (int)$tahun.$bulan;	

				if($hsl && $tgl_trans <= $tgl_cls_jurnal){
					$hsl = false;
					$msg = 'Transactions cannot be changed. Journal is already closing';					
				}

				// Transaksi yang sudah di rekonsiliasi tidak bisa di edit/void/cancel
				if($hsl && $is_recon_exists){
					$hsl = false;
					$msg = 'Transactions cannot be changed. Journal already in reconciliation';
				}

			}

			if($menu == 'DELIVERYNOW'){				
				// cek driver required
				if($hsl && $this->input->post('trsd_sopir') == ''){					
					$hsl = false;
					$msg = 'Please input driver';						
				}	
			
				// cek license plate required				
				if($hsl && $this->input->post('trsd_nopol') == ''){					
					$hsl = false;
					$msg = 'Please input license plate';						
				}					

				// Cek Qty kirim harus di isi (minimal 1 produk)				
				if($hsl && !isset($data['detail'])){
					$hsl = false;
					$msg = 'Cannot delivery with 0 qty';	
				}					
			}			

			// cek tidak boleh di cancel kalo status copy-nya (X)
			if($hsl && $menu == 'CANCEL_CONFDELIVERY'){
				if($data['trso_stcopy'] == 'X'){
					$hsl = false;					
					$msg = 'Transaction cannot be cancelled. Please change status exclude (X) first on Sales Order';
				}	
			}
			
			// Utk pengecekan dtsd_qtykrm dan dtsd_qtyrej Sales Delivery			
			if ($hsl) {
				if(isset($data['detail'])){
					foreach ($data['detail'] as $key => $value) {

						if ($menu == 'NEW' || $menu == 'EDIT' || $menu == 'DELIVERYNOW') { 
							$qtyupdate = $data['detail'][$key]['dtsd_qtykrm'];
							$stok = $this->m_stok->get_stok($data['detail'][$key]['dtsd_mspd_no'],$data['header']['trsd_msgd_no']);

							if ($qtyupdate < 0){
								$hsl = false;
								$msg = 'Qty Delivery cannot < 0';
								break;
							}

							if($data['detail'][$key]['mskt_statusinv'] == 'Y' && $data['detail'][$key]['dtsd_statuspaket'] != 'P'){
								if($this->session->userdata('svlogin') != 'F'){
									if (($stok - $qtyupdate) < 0){
										$hsl = false;
										$msg = 'Stock Insufficient'.
										       '<br>Product: ' . $data['detail'][$key]['dtsd_mspd_no'].
										       '<br>Warehouse: ' . $data['header']['trsd_msgd_no'].
										       '<br>Stock: ' . $stok;
										 break;
									}
								}
							}								

							if($data['detail'][$key]['dtsd_qtykrm'] < 0 || $data['detail'][$key]['dtsd_qtykrm'] > $data['detail'][$key]['dtsd_qtysisa']){
								$hsl = false;
								$msg = 'Qty delivery must be >= 0 or <= qty remaining'.
										'<br>Product: '. $data['detail'][$key]['dtsd_mspd_no'].
										'<br>Qty Remaining: '. $data['detail'][$key]['dtsd_qtysisa'];
								break;
							}						
						}												

						if($menu == 'DELIVERYNOW'){
							if($data['detail'][$key]['dtsd_qtykrm'] == 1 && $data['detail'][$key]['mspd_reqserialno'] == 'Y' && $data['detail'][$key]['dtsd_noserial'] == ''){
								$hsl = false;
								$msg = 'Please input serial number'.
										'<br>Product: '. $data['detail'][$key]['dtsd_mspd_no'];
								break;	
							}	
						}

						if($menu == 'CONFDELIVERY'){						
							if($data['detail'][$key]['dtsd_qtyrej'] < 0 || $data['detail'][$key]['dtsd_qtyrej'] > $data['detail'][$key]['dtsd_qtykrm']){
								$hsl = false;
								$msg = 'Qty reject must be => 0 or <= qty delivery'.
										'<br>Product: '. $data['detail'][$key]['dtsd_mspd_no'].
										'<br>Qty Delivery: '. $data['detail'][$key]['dtsd_qtykrm'];
								break;
							}
						}	
						unset($this->data['detail'][$key]['dtsd_qtysisa']);
						unset($this->data['detail'][$key]['mspd_reqserialno']);						
						unset($this->data['detail'][$key]['mskt_statusinv']);						
					}
				}				
			}				

			// utk pengecekan cekint Sales Delivery, 
			// Valid = CekInt tidak berubah
			if ($hsl) {				
				if($this->m_sales_order->get_sales_order_cekint(substr($data['header']['trsd_no'], 0, 12), $data['trso_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_sales_order->set_sales_order_cekint(substr($data['header']['trsd_no'], 0, 12));
				}				
			}

			if ($hsl && $menu != 'NEW') {
				if($this->m_sales_delivery->get_sales_delivery_cekint($data['header']['trsd_no'], $data['trsd_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_sales_delivery->set_sales_delivery_cekint($data['header']['trsd_no']);
				}
			}
			
			return array('valid'=>$hsl, 'msg'=>$msg);
	}

}