<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class sales extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_sales');					
	}

	public function index(){			
		if(!fcek_hak_akses('.AJ0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/sales/v_sales_list', $data);
		$this->load->view('v_footer');			
	}

	public function sales_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['sales_list'] = $this->m_sales->get_sales_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['sales_list']);
		}
		else {
			$pagination['total_list'] = $this->m_sales->get_sales_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['sales_list'] = $this->load->view('data_master/sales/v_sales_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function sales_new(){	
		if(!fcek_hak_akses('.AJ1.')){
			redirect('forbidden');
		}
		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/sales/v_sales_form',$data);
		$this->load->view('v_footer');		
	}

	public function sales_view($mssl_no){	
		if(!fcek_hak_akses('.AJ0.')) {
			redirect('forbidden');
		}
		if (is_null($mssl_no) || count($this->m_sales->get_sales($mssl_no)) <= 0) {
			redirect('sales');
			return;
		}
		$data = array();
		$data['action'] = 'view';		
		$data['sales'] = $this->m_sales->get_sales($mssl_no);
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/sales/v_sales_form',$data);
		$this->load->view('v_footer');		
	}

	public function sales_new_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{			
			$mssl_no = $this->input->post('mssl_no');
			if($this->m_sales->get_salesno($mssl_no) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('mssl_no' => 'Sales ID: '.$mssl_no.' is already registered. Please input Sales ID.');
				echo json_encode($result);				
			}else if($this->m_sales->get_salesnm(null, fhapus_kutip($this->input->post('mssl_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Sales name already exists');
				echo json_encode($result);
			}else{												
				$data = array();
				$data['mssl_no'] = $mssl_no;
				$data['mssl_nm'] = fhapus_kutip($this->input->post('mssl_nm'));
				$data['mssl_divisi'] = $this->input->post('mssl_divisi');
				$data['mssl_listmscb'] = (($this->input->post('mssl_listmscb') != '') ? ".". implode('.', $this->input->post('mssl_listmscb')). "." : '');
				$data['mssl_telp1'] = fhapus_kutip($this->input->post('mssl_telp1'));
				$data['mssl_telp2'] = fhapus_kutip($this->input->post('mssl_telp2'));
				$data['mssl_email'] = fhapus_kutip($this->input->post('mssl_email'));
				$data['mssl_catatan'] = fhapus_kutip($this->input->post('mssl_catatan'));
				$data['mssl_aktif'] = 1; //(($this->input->post('mssl_aktif') == 'on') ? 1 : 0);			
				$data['mssl_lsupd'] = date('Y-m-d H:i:s');
				$data['mssl_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_sales->sales_new_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');
					$result['response'] = 'sukses';				
		  	 		$result['mssl_no'] = $data['mssl_no'];	      	 		
		  	 		echo json_encode($result);
				}			
			}	
			
		}				        
	}

	public function sales_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$data_status['mssl_listmscb'] = (($this->input->post('mssl_listmscb') != '') ? ".". implode('.', $this->input->post('mssl_listmscb')). "." : '');			
			if(fcek_status($data_status)){
		     	$result['response'] = 'gagal';
				$result['error_message'] = array('fail'=>'Can not save [OFF] status');
				echo json_encode($result);
			}else if($this->m_sales->get_salesnm($this->input->post('mssl_no'), fhapus_kutip($this->input->post('mssl_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Sales name already exists');
				echo json_encode($result);
			}else{	     	
				$data = array();
				$data['mssl_no'] = $this->input->post('mssl_no');
				$data['mssl_nm'] = fhapus_kutip($this->input->post('mssl_nm'));			
				$data['mssl_divisi'] = $this->input->post('mssl_divisi');
				$data['mssl_listmscb'] = (($this->input->post('mssl_listmscb') != '') ? ".". implode('.', $this->input->post('mssl_listmscb')). "." : '');
				$data['mssl_telp1'] = fhapus_kutip($this->input->post('mssl_telp1'));
				$data['mssl_telp2'] = fhapus_kutip($this->input->post('mssl_telp2'));
				$data['mssl_email'] = fhapus_kutip($this->input->post('mssl_email'));
				$data['mssl_catatan'] = fhapus_kutip($this->input->post('mssl_catatan'));
				//$data['mssl_aktif'] = (($this->input->post('mssl_aktif') == 'on') ? 1 : 0);			
				$data['mssl_lsupd'] = date('Y-m-d H:i:s');
				$data['mssl_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_sales->sales_edit_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');			
					$result['response'] = 'sukses';				
		  	 		$result['mssl_no'] = $data['mssl_no'];			
		  	 		echo json_encode($result);
				}
			}	
					
		}				        
	}

	public function get_sales(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales');

		echo json_encode($this->m_sales->get_all_sales());				
	}

	public function sales_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales');

		$data['mssl_no'] = $this->input->post('mssl_no');
		$data['mssl_aktif'] = $this->input->post('mssl_aktif');

		if($this->m_sales->sales_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['mssl_no'] = $data['mssl_no'];			
  	 		echo json_encode($result);
		}
	}	

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'mssl_no',
		                'label' => 'Sales ID',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mssl_nm',
		                'label' => 'Sales Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mssl_telp1',
		                'label' => 'Contact Number 1',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),		       
		        array(
		                'field' => 'mssl_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )
		);
		return $config;
	}	

}