<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Revisi_hpp extends MY_Controller {
	private  $MWIP = '';
	private  $MTRS = '';
	private  $ADJS = '';
	private  $PIUA = '';
	private  $PIUR = '';
	private  $PPNK = '';	
	private  $SRCA = '';
	private  $SRCR = '';
	private  $SRVA = '';
	private  $SRVR = '';
	private  $msap_no = '';

	function __construct(){
		parent::__construct();	
		$this->load->library('excel');			
	}	 		

	public function index(){
		$this->load->view('v_revisi_hpp');
	}

	public function execute_revisi_hpp(){

		if(isset($_FILES["file"]["name"])){
			$this->msap_no = $this->input->post('msap_no');

			if($this->msap_no == ''){
				die('Akun selisih belum diinput.');
			}

			$query = $this->db->query("SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'MWIP' LIMIT 1;");
			$row = $query->result_array();
			$this->MWIP = $row[0]['mssa_msap_no'];

			$query = $this->db->query("SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'MTRS' LIMIT 1;");
			$row = $query->result_array();
			$this->MTRS = $row[0]['mssa_msap_no'];

			$query = $this->db->query("SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'ADJS' LIMIT 1;");
			$row = $query->result_array();
			$this->ADJS = $row[0]['mssa_msap_no'];	

			$query = $this->db->query("SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUA' LIMIT 1;");
			$row = $query->result_array();
			$this->PIUA = $row[0]['mssa_msap_no'];
			
			$query = $this->db->query("SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUR' LIMIT 1;");
			$row = $query->result_array();
			$this->PIUR = $row[0]['mssa_msap_no'];					

			$query = $this->db->query("SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PPNK' LIMIT 1;");
			$row = $query->result_array();
			$this->PPNK = $row[0]['mssa_msap_no'];	

			$query = $this->db->query("SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'SRCA' LIMIT 1;");
			$row = $query->result_array();
			$this->SRCA = $row[0]['mssa_msap_no'];
			
			$query = $this->db->query("SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'SRCR' LIMIT 1;");
			$row = $query->result_array();
			$this->SRCR = $row[0]['mssa_msap_no'];

			$query = $this->db->query("SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'SRVA' LIMIT 1;");
			$row = $query->result_array();
			$this->SRVA = $row[0]['mssa_msap_no'];

			$query = $this->db->query("SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'SRVR' LIMIT 1;");
			$row = $query->result_array();
			$this->SRVR = $row[0]['mssa_msap_no'];						

			$query = "DROP TABLE IF EXISTS temp_trans_jurnal";
			$this->db->simple_query($query);
	
			$query = "CREATE TABLE temp_trans_jurnal(
							ref_no VARCHAR(25) NOT NULL DEFAULT '',
							trju_no CHAR(15) NOT NULL DEFAULT '',
							PRIMARY KEY (ref_no,trju_no)
						) ENGINE=INNODB DEFAULT CHARSET=latin1";
			
			$this->db->simple_query($query);			

			echo 'Sedang diproses. Silakan tunggu...';
			flush();ob_flush();sleep(0.001);

			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);

			foreach($object->getWorksheetIterator() as $worksheet){
				$highestRow = $worksheet->getHighestRow();
				$totalRow = $highestRow - 1;				
				$dataSukses = 0;
								
				for($row=2; $row<=$highestRow; $row++){						
					$mspd_no = fhapus_kutip(trim($worksheet->getCellByColumnAndRow(0, $row)->getValue()));
					$mspd_hpp = fhapus_kutip(trim($worksheet->getCellByColumnAndRow(6, $row)->getValue()));					

					if($mspd_no != ''){
						echo '<br>';
						echo date('H:i:s'). ' ===== PRODUK '.$mspd_no.' -> Mulai Proses =====';																				
						flush();ob_flush();sleep(0.001);

						$this->revisi_hpp_produk($mspd_no, $mspd_hpp);					
						
						echo '<br>';
						echo date('H:i:s'). ' ----- PRODUK '.$mspd_no.' -> Selesai -----';																				
						flush();ob_flush();sleep(0.001);
					}					
				}

				break;
			}

			// truncate his_accgrp, his_accsub, his_accper
			$this->db->truncate('his_accgrp');
			$this->db->truncate('his_accsub');
			$this->db->truncate('his_accper');	

			// void spesial jurnal by periode
			$this->db->update('tr_jurnal', array('trju_void' => 1), array('trju_reftipe' => 'SJ'));

			$query = "DROP TABLE IF EXISTS temp_trans_jurnal";
			$this->db->simple_query($query);			

			echo '<br>';
			echo '<br>';
			echo '<b> >>>>>>>> PROSES SELESAI. JAM '. date('H:i:s').'<<<<<<<<<< </b>';
		}				
	}

	private function revisi_hpp_produk($mspd_no, $mspd_hpp){
		$vok = true;
		$err = false;
		$err_msg = '';
		
		// save produk yang diubah hpp-nya ke log_set_hpp_1908
		$this->db->insert('log_set_hpp_1908', array('lgsh_mspd_no' => $mspd_no, 'lgsh_hpp' => $mspd_hpp));				

		// update mspd_hpp di ms_produk
		$this->db->where('mspd_no', $mspd_no);
		$this->db->update('ms_produk', array('mspd_hpp' => $mspd_hpp));			

		// delete tr_his_hpp by mspd_no
		$this->db->delete('tr_his_hpp', array('trhpp_mspd_no' => $mspd_no));					

		echo '<br>';
		echo date('H:i:s'). ' -> Mulai delete dt_jurnal job costing atuo setting hpp';																				
		flush();ob_flush();sleep(0.001);

		// delete dt_jurnal job costing atuo setting hpp
		$query = "DELETE dtju FROM dt_jurnal dtju
					LEFT JOIN tr_jurnal ON trju_no = dtju.dtju_no
					WHERE trju_reftipe = 'GT'
					AND trju_refno IN(SELECT CONCAT(dtash_trans_no,'GT') FROM dt_auto_set_hpp
								LEFT JOIN tr_auto_set_hpp ON trash_no = dtash_no
								WHERE trash_mspd_no = '".$mspd_no."'
								AND dtash_trans_jenis = '2JC')";
		$this->db->simple_query($query);

		echo '<br>';
		echo date('H:i:s'). ' -> Mulai delete tr_jurnal job costing auto setting hpp';																				
		flush();ob_flush();sleep(0.001);

		// delete tr_jurnal job costing auto setting hpp
		$query = "DELETE trju FROM tr_jurnal trju
					WHERE trju.trju_reftipe = 'GT'
					AND trju.trju_refno IN(SELECT CONCAT(dtash_trans_no,'GT') FROM dt_auto_set_hpp
								LEFT JOIN tr_auto_set_hpp ON trash_no = dtash_no
								WHERE trash_mspd_no = '".$mspd_no."'
								AND dtash_trans_jenis = '2JC')";
		$this->db->simple_query($query);

		echo '<br>';
		echo date('H:i:s'). ' -> Mulai delete dt_tfmgoods auto setting hpp';																				
		flush();ob_flush();sleep(0.001);

		// delete dt_tfmgoods auto setting hpp
		$query = "DELETE dtts FROM dt_tfmgoods dtts
					WHERE dtts.dtts_no IN(SELECT dtash_trans_no FROM dt_auto_set_hpp
								LEFT JOIN tr_auto_set_hpp ON trash_no = dtash_no
								WHERE trash_mspd_no = '".$mspd_no."'
								AND dtash_trans_jenis = '2JC')";
		$this->db->simple_query($query);

		echo '<br>';
		echo date('H:i:s'). ' -> Mulai delete tr_tfmgoods auto setting hpp';																				
		flush();ob_flush();sleep(0.001);

		// delete tr_tfmgoods auto setting hpp
		$query = "DELETE trts FROM tr_tfmgoods trts
					WHERE trts.trts_no IN(SELECT dtash_trans_no FROM dt_auto_set_hpp
								LEFT JOIN tr_auto_set_hpp ON trash_no = dtash_no
								WHERE trash_mspd_no = '".$mspd_no."'
								AND dtash_trans_jenis = '2JC')";
		$this->db->simple_query($query);

		echo '<br>';
		echo date('H:i:s'). ' -> Mulai delete dt_jurnal mutasi auto setting hpp';																				
		flush();ob_flush();sleep(0.001);

		// delete dt_jurnal mutasi auto setting hpp
		$query = "DELETE dtju FROM dt_jurnal dtju
					LEFT JOIN tr_jurnal ON trju_no = dtju.dtju_no
					WHERE trju_reftipe = 'MT'
					AND SUBSTRING(trju_refno, 1, 12) IN(SELECT dtash_trans_no FROM dt_auto_set_hpp
								LEFT JOIN tr_auto_set_hpp ON trash_no = dtash_no
								WHERE trash_mspd_no = '".$mspd_no."'
								AND SUBSTRING(dtash_trans_jenis, 2, 2) = 'MT')";
		$this->db->simple_query($query);

		echo '<br>';
		echo date('H:i:s'). ' -> Mulai delete tr_jurnal mutasi auto setting hpp';																				
		flush();ob_flush();sleep(0.001);

		// delete tr_jurnal mutasi auto setting hpp
		$query = "DELETE trju FROM tr_jurnal trju
					WHERE trju.trju_reftipe = 'MT'
					AND SUBSTRING(trju.trju_refno, 1, 12) IN(SELECT dtash_trans_no FROM dt_auto_set_hpp
								LEFT JOIN tr_auto_set_hpp ON trash_no = dtash_no
								WHERE trash_mspd_no = '".$mspd_no."'
								AND SUBSTRING(dtash_trans_jenis, 2, 2) = 'MT')";
		$this->db->simple_query($query);

		echo '<br>';
		echo date('H:i:s'). ' -> Mulai dt_mutasi auto setting hpp';																				
		flush();ob_flush();sleep(0.001);

		// delete dt_mutasi auto setting hpp
		$query = "DELETE dtmt FROM dt_mutasi dtmt
					WHERE dtmt.dtmt_no IN(SELECT dtash_trans_no FROM dt_auto_set_hpp
								LEFT JOIN tr_auto_set_hpp ON trash_no = dtash_no
								WHERE trash_mspd_no = '".$mspd_no."'
								AND SUBSTRING(dtash_trans_jenis, 2, 2) = 'MT')";
		$this->db->simple_query($query);

		echo '<br>';
		echo date('H:i:s'). ' -> Mulai tr_mutasi auto setting hpp';																				
		flush();ob_flush();sleep(0.001);

		// delete tr_mutasi auto setting hpp
		$query = "DELETE trmt FROM tr_mutasi trmt
					WHERE trmt.trmt_no IN(SELECT dtash_trans_no FROM dt_auto_set_hpp
								LEFT JOIN tr_auto_set_hpp ON trash_no = dtash_no
								WHERE trash_mspd_no = '".$mspd_no."'
								AND SUBSTRING(dtash_trans_jenis, 2, 2) = 'MT')";
		$this->db->simple_query($query);

		echo '<br>';
		echo date('H:i:s'). ' -> Mulai dt_auto_set_hpp dan tr_auto_set_hpp';																				
		flush();ob_flush();sleep(0.001);

		// delete dt_auto_set_hpp
		$query = "DELETE dtash FROM dt_auto_set_hpp dtash
					LEFT JOIN tr_auto_set_hpp ON trash_no = dtash.dtash_no
					WHERE trash_mspd_no = '".$mspd_no."'";
		$this->db->simple_query($query);					

		// delete tr_auto_set_hpp
		$query = "DELETE trash FROM tr_auto_set_hpp trash
					WHERE trash.trash_mspd_no = '".$mspd_no."'";
		$this->db->simple_query($query);			

		/*
		----------------------------------------------------------------------------------------------
		| PROSES UPDATE/REVISI JURNAL TRANSAKSI YANG BERKAITAN DENGAN HPP
		----------------------------------------------------------------------------------------------
		*/				

		// PROSES UPDATE HPP (DETAIL STOCK ADJUSTMENT)-----------------------------------------------
		if($vok){
			// SET dtas_hpp 
			$str_query = "UPDATE dt_adjstok
							LEFT JOIN ms_produk ON mspd_no = dtas_mspd_no
							LEFT JOIN tr_adjstok ON tras_no = dtas_no
							SET dtas_hpp = mspd_hpp
							WHERE dtas_mspd_no = '".$mspd_no."'
							AND tras_void = 0";
			
			if(!$this->db->simple_query($str_query)){
				$vok = false;
				$err = true;
				$err_msg = 'Error set dtas_hpp';
			}		
		}

		// PROSES UPDATE JURNAL STOCK ADJUSTMENT-----------------------------------------------------
		if($vok){
			$str_query = "SELECT tras_no, trju_no 
							FROM dt_adjstok
							LEFT JOIN tr_adjstok ON tras_no = dtas_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'AS'
													AND trju_refno = CONCAT(tras_no, 'AS')
						WHERE dtas_mspd_no = '".$mspd_no."'
						AND tras_void = 0
						AND trju_no IS NOT NULL
						LIMIT 1";
			$query = $this->db->query($str_query);				

			if($query->num_rows() > 0){
				$str_query = "TRUNCATE TABLE temp_trans_jurnal";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai ADJUSTMENT STOCK ----- insert temp table';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO temp_trans_jurnal (ref_no,trju_no)
								(SELECT DISTINCT tras_no, trju_no 
									FROM dt_adjstok
									LEFT JOIN tr_adjstok ON tras_no = dtas_no 
									LEFT JOIN tr_jurnal ON trju_tipe = 'A'
															AND trju_reftipe = 'AS'
															AND trju_refno = CONCAT(tras_no, 'AS')
								WHERE dtas_mspd_no = '".$mspd_no."'
								AND tras_void = 0
								AND trju_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai ADJUSTMENT STOCK ----- DELETE dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "DELETE dtju FROM dt_jurnal dtju
								WHERE dtju.dtju_no IN 
								(SELECT DISTINCT trju_no FROM temp_trans_jurnal)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 1
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai ADJUSTMENT STOCK ----- tahap 1 dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtas_seq * 2) - 1, 
									mskt_msap_no_inv,
									ROUND((dtas_qty * dtas_hpp), 4),
									0,
									'',''
								FROM dt_adjstok		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtas_no
								LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtas_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 2
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai ADJUSTMENT STOCK ----- tahap 2 dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtas_seq * 2), 
									'".$this->ADJS."',
									0,
									ROUND((dtas_qty * dtas_hpp), 4),
									'',''
								FROM dt_adjstok		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtas_no								
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);
			}
		}

		// PROSES UPDATE HPP (DETAIL MUTASI)---------------------------------------------------------
		if($vok){
			// SET dtmt_hpp 			
			$str_query = "UPDATE dt_mutasi
							LEFT JOIN ms_produk ON mspd_no = dtmt_mspd_no
							LEFT JOIN tr_mutasi ON trmt_no = dtmt_no
							SET dtmt_hpp = mspd_hpp
							WHERE dtmt_mspd_no = '".$mspd_no."'
							AND trmt_void = 0";
			
			if(!$this->db->simple_query($str_query)){
				$vok = false;
				$err = true;
				$err_msg = 'Error set dtmt_hpp';
			}			
		}

		// PROSES UPDATE JURNAL MUTASI OUT-----------------------------------------------------------
		if($vok){
			$str_query = "SELECT trmt_no, trju_no 
								FROM dt_mutasi
								LEFT JOIN tr_mutasi ON trmt_no = dtmt_no 
								LEFT JOIN tr_jurnal ON trju_tipe = 'A'
														AND trju_reftipe = 'MD'
														AND trju_refno = CONCAT(trmt_no, 'MD')
							WHERE dtmt_mspd_no = '".$mspd_no."'
							AND trmt_void = 0
							AND trju_no IS NOT NULL
							AND trmt_tglkirim <> '0000-00-00'
							LIMIT 1";
			$query = $this->db->query($str_query);

			if($query->num_rows() > 0){
				$str_query = "TRUNCATE TABLE temp_trans_jurnal";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai MUTASI OUT ----- insert temp table';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO temp_trans_jurnal (ref_no,trju_no)
							(SELECT DISTINCT trmt_no, trju_no 
								FROM dt_mutasi
								LEFT JOIN tr_mutasi ON trmt_no = dtmt_no 
								LEFT JOIN tr_jurnal ON trju_tipe = 'A'
														AND trju_reftipe = 'MD'
														AND trju_refno = CONCAT(trmt_no, 'MD')
							WHERE dtmt_mspd_no = '".$mspd_no."'
							AND trmt_void = 0
							AND trju_no IS NOT NULL
							AND trmt_tglkirim <> '0000-00-00'
							)";
				$query = $this->db->query($str_query);
												
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai MUTASI OUT ----- DELETE dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "DELETE dtju FROM dt_jurnal dtju
								WHERE dtju.dtju_no IN 
								(SELECT DISTINCT trju_no FROM temp_trans_jurnal)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 1
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai MUTASI OUT ----- tahap 1 dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtmt_seq * 2) - 1, 
									'".$this->MWIP."',
									ROUND((dtmt_qtyout * dtmt_hpp), 4),
									0,
									'',''
								FROM dt_mutasi 		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtmt_no
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 2
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai MUTASI OUT ----- tahap 2 dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtmt_seq * 2), 
									mskt_msap_no_inv,
									0,
									ROUND((dtmt_qtyout * dtmt_hpp), 4),
									'',''
								FROM dt_mutasi										
								LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtmt_mspd_no, 1, 1)
								LEFT JOIN temp_trans_jurnal ON ref_no = dtmt_no
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);
			}
		}

		// PROSES UPDATE JURNAL MUTASI IN------------------------------------------------------------
		if($vok){
			$str_query = "SELECT trmt_no, trju_no 
								FROM dt_mutasi
								LEFT JOIN tr_mutasi ON trmt_no = dtmt_no 
								LEFT JOIN tr_jurnal ON trju_tipe = 'A'
														AND trju_reftipe = 'MR'
														AND trju_refno = CONCAT(trmt_no, 'MR')
							WHERE dtmt_mspd_no = '".$mspd_no."'
							AND trmt_void = 0
							AND trju_no IS NOT NULL
							AND trmt_tglterima <> '0000-00-00'
							LIMIT 1";
			$query = $this->db->query($str_query);

			if($query->num_rows() > 0){
				$str_query = "TRUNCATE TABLE temp_trans_jurnal";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai MUTASI IN ----- insert temp table';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO temp_trans_jurnal (ref_no,trju_no)
							(SELECT DISTINCT trmt_no, trju_no 
								FROM dt_mutasi
								LEFT JOIN tr_mutasi ON trmt_no = dtmt_no 
								LEFT JOIN tr_jurnal ON trju_tipe = 'A'
														AND trju_reftipe = 'MR'
														AND trju_refno = CONCAT(trmt_no, 'MR')
							WHERE dtmt_mspd_no = '".$mspd_no."'
							AND trmt_void = 0
							AND trju_no IS NOT NULL
							AND trmt_tglterima <> '0000-00-00'
							)";
				$query = $this->db->query($str_query);
								
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai MUTASI IN ----- DELETE dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "DELETE dtju FROM dt_jurnal dtju
								WHERE dtju.dtju_no IN 
								(SELECT DISTINCT trju_no FROM temp_trans_jurnal)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 1
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai MUTASI IN ----- tahap 1 dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtmt_seq * 3) - 2, 
									mskt_msap_no_inv,
									ROUND((dtmt_qtyin * dtmt_hpp), 4),
									0,
									'',''
								FROM dt_mutasi 		
								LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtmt_mspd_no, 1, 1)
								LEFT JOIN temp_trans_jurnal ON ref_no = dtmt_no
								WHERE ref_no IS NOT NULL
								)";								
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 2
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai MUTASI IN ----- tahap 2 dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtmt_seq * 3) - 1, 
									'".$this->MWIP."',
									0,
									ROUND((dtmt_qtyout * dtmt_hpp), 4),
									'',''
								FROM dt_mutasi 		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtmt_no
								WHERE ref_no IS NOT NULL
								)";					
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 3 (selisih debet)
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai MUTASI IN ----- tahap 3 (selisih debet)';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtmt_seq * 3), 
									'".$this->MTRS."',
									IF(((SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtmt_seq * 3) - 2)
										-
										(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtmt_seq * 3) - 1)) < 0
										, 
										(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtmt_seq * 3) - 1)
										-
										(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtmt_seq * 3) - 2)
										, 0),

									IF(((SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtmt_seq * 3) - 2)
										-
										(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtmt_seq * 3) - 1)) > 0
										, 
										(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtmt_seq * 3) - 2)
										-
										(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtmt_seq * 3) - 1)
										, 0),

									'',''
								FROM dt_mutasi 		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtmt_no
								WHERE ref_no IS NOT NULL
								)";					
				$query = $this->db->query($str_query);
				
				// delete debet = 0 dan kredit = 0
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai MUTASI IN ----- delete debet = 0 dan kredit = 0';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "DELETE dtju FROM dt_jurnal dtju
								LEFT JOIN temp_trans_jurnal ON trju_no = dtju.dtju_no
								WHERE trju_no IS NOT NULL
								AND dtju.dtju_debet = 0
								AND dtju.dtju_kredit = 0";					
				$query = $this->db->query($str_query);
			}
		}	

		// PROSES UPDATE HPP (DETAIL SALES DELIVERY)-------------------------------------------------
		if($vok){
			// SET dtsd_hpp 
			$str_query = "UPDATE dt_sales_dlv
							LEFT JOIN ms_produk ON mspd_no = dtsd_mspd_no
							LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
							SET dtsd_hpp = mspd_hpp
							WHERE dtsd_mspd_no = '".$mspd_no."'
							AND trsd_void = 0";
			
			if(!$this->db->simple_query($str_query)){				
				$vok = false;
				$err = true;
				$err_msg = 'Error set dtsd_hpp';
			}		
		}

		// PROSES UPDATE JURNAL SALES DELIVERY (DELIVERY NOW)----------------------------------------
		if($vok){
			$str_query = "SELECT trsd_no, trju_no 
							FROM dt_sales_dlv
							LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'SD'
													AND trju_refno = CONCAT(trsd_no, 'SD')
						WHERE dtsd_mspd_no = '".$mspd_no."'
						AND trsd_void = 0
						AND trju_no IS NOT NULL
						AND trsd_tglkirim <> '0000-00-00'
						LIMIT 1";
			$query = $this->db->query($str_query);					

			if($query->num_rows() > 0){
				$str_query = "TRUNCATE TABLE temp_trans_jurnal";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (DELIVERY NOW) ----- insert temp table';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO temp_trans_jurnal (ref_no,trju_no)
								(SELECT DISTINCT trsd_no, trju_no 
									FROM dt_sales_dlv
									LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no 
									LEFT JOIN tr_jurnal ON trju_tipe = 'A'
															AND trju_reftipe = 'SD'
															AND trju_refno = CONCAT(trsd_no, 'SD')
								WHERE dtsd_mspd_no = '".$mspd_no."'
								AND trsd_void = 0
								AND trju_no IS NOT NULL
								AND trsd_tglkirim <> '0000-00-00'
								)";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (DELIVERY NOW) ----- DELETE dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "DELETE dtju FROM dt_jurnal dtju
								WHERE dtju.dtju_no IN 
								(SELECT DISTINCT trju_no FROM temp_trans_jurnal)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 1
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (DELIVERY NOW) ----- tahap 1 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtsd_seq * 5) - 4, 
									IF(mscs_jenis = 'A', '".$this->PIUA."','".$this->PIUR."'),
									ROUND((dtsd_nett * dtsd_qtykrm), 4),
									0,
									'',''
								FROM dt_sales_dlv		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsd_no								
								LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
								LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no										
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 2
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (DELIVERY NOW) ----- tahap 2 dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtsd_seq * 5) - 3, 
									IF(mscs_jenis = 'A', mskt_msap_no_pja, mskt_msap_no_pjr),
									0,
									ROUND((dtsd_bftax * dtsd_qtykrm), 4),
									'',''
								FROM dt_sales_dlv		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsd_no								
								LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
								LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no										
								LEFT JOIN ms_kategori ON mskt_no = substr(dtsd_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 3
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (DELIVERY NOW) ----- tahap 3 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtsd_seq * 5) - 2, 
									'".$this->PPNK."',
									0,
									round(
									(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtsd_seq * 5) - 4)
									-
									(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtsd_seq * 5) - 3)
									, 4),
									'',''
								FROM dt_sales_dlv		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsd_no																
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 4
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (DELIVERY NOW) ----- tahap 4 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtsd_seq * 5) - 1, 
									IF(mscs_jenis = 'A', mskt_msap_no_hpa, mskt_msap_no_hpr),
									ROUND((dtsd_hpp * dtsd_qtykrm), 4),
									0,
									'',''
								FROM dt_sales_dlv		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsd_no								
								LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
								LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no										
								LEFT JOIN ms_kategori ON mskt_no = substr(dtsd_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 5
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (DELIVERY NOW) ----- tahap 5 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtsd_seq * 5), 
									mskt_msap_no_inv,
									0,
									ROUND((dtsd_hpp * dtsd_qtykrm), 4),
									'',''
								FROM dt_sales_dlv		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsd_no																
								LEFT JOIN ms_kategori ON mskt_no = substr(dtsd_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

			}			
		}

		// PROSES UPDATE JURNAL SALES DELIVERY (CONFIRM DELIVERY)------------------------------------
		if($vok){
			$str_query = "SELECT trsd_no, trju_no 
							FROM dt_sales_dlv
							LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'DR'
													AND trju_refno = CONCAT(trsd_no, 'DR')
						WHERE dtsd_mspd_no = '".$mspd_no."'
						AND trsd_void = 0
						AND trju_no IS NOT NULL
						AND dtsd_qtyrej <> 0
						AND trsd_tglbalik <> '0000-00-00'
						LIMIT 1";

			$query = $this->db->query($str_query);

			if($query->num_rows() > 0){
				$str_query = "TRUNCATE TABLE temp_trans_jurnal";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (CONFIRM DELIVERY) ----- insert temp table';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO temp_trans_jurnal (ref_no,trju_no)
								(SELECT DISTINCT trsd_no, trju_no 
									FROM dt_sales_dlv
									LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no 
									LEFT JOIN tr_jurnal ON trju_tipe = 'A'
															AND trju_reftipe = 'DR'
															AND trju_refno = CONCAT(trsd_no, 'DR')
								WHERE dtsd_mspd_no = '".$mspd_no."'
								AND trsd_void = 0
								AND trju_no IS NOT NULL
								AND dtsd_qtyrej <> 0
								AND trsd_tglbalik <> '0000-00-00'
								)";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (CONFIRM DELIVERY) ----- DELETE dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "DELETE dtju FROM dt_jurnal dtju
								WHERE dtju.dtju_no IN 
								(SELECT DISTINCT trju_no FROM temp_trans_jurnal)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 1
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (CONFIRM DELIVERY) ----- tahap 1 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtsd_seq * 5) - 4, 
									IF(mscs_jenis = 'A', mskt_msap_no_pja, mskt_msap_no_pjr),
									ROUND((dtsd_bftax * dtsd_qtyrej), 4),
									0,
									'',''
								FROM dt_sales_dlv		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsd_no								
								LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
								LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no										
								LEFT JOIN ms_kategori ON mskt_no = substr(dtsd_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								AND dtsd_qtyrej <> 0
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 3
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (CONFIRM DELIVERY) ----- tahap 3 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtsd_seq * 5) - 2, 
									IF(mscs_jenis = 'A', '".$this->PIUA."','".$this->PIUR."'),
									0,
									ROUND((dtsd_nett * dtsd_qtyrej), 4),
									'',''
								FROM dt_sales_dlv		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsd_no								
								LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
								LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no																		
								WHERE ref_no IS NOT NULL
								AND dtsd_qtyrej <> 0
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 2
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (CONFIRM DELIVERY) ----- tahap 2 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtsd_seq * 5) - 3, 
									'".$this->PPNK."',
									round(
									(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtsd_seq * 5) - 2)
									-
									(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtsd_seq * 5) - 4)
									, 4),										
									0,
									'',''
								FROM dt_sales_dlv		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsd_no																
								WHERE ref_no IS NOT NULL
								AND dtsd_qtyrej <> 0
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 4
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (CONFIRM DELIVERY) ----- tahap 4 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtsd_seq * 5) - 1, 
									mskt_msap_no_inv,
									ROUND((dtsd_hpp * dtsd_qtyrej), 4),
									0,
									'',''
								FROM dt_sales_dlv		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsd_no																
								LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsd_mspd_no, 1, 1)				
								WHERE ref_no IS NOT NULL
								AND dtsd_qtyrej <> 0
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 5
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES DELIVERY (CONFIRM DELIVERY) ----- tahap 5 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtsd_seq * 5), 
									IF(mscs_jenis = 'A', mskt_msap_no_hpa, mskt_msap_no_hpr),
									0,
									ROUND((dtsd_hpp * dtsd_qtyrej), 4),
									'',''
								FROM dt_sales_dlv		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsd_no																
								LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
								LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no
								LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsd_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								AND dtsd_qtyrej <> 0
								)";
				$query = $this->db->query($str_query);
			}
		}

		// PROSES UPDATE HPP (DETAIL SALES RETUR)----------------------------------------------------
		if($vok){
			// SET dtsr_hpp 
			$str_query = "UPDATE dt_salesret
							LEFT JOIN ms_produk ON mspd_no = dtsr_mspd_no
							LEFT JOIN tr_salesret ON trsr_no = dtsr_no
							SET dtsr_hpp = mspd_hpp
							WHERE dtsr_mspd_no = '".$mspd_no."'
							AND trsr_void = 0";
			
			if(!$this->db->simple_query($str_query)){				
				die('Error set dtsr_hpp.');
			}		
		}

		// PROSES UPDATE JURNAL SALES RETUR----------------------------------------------------------
		if($vok){
			$str_query = "SELECT trsr_no, trju_no 
							FROM dt_salesret
							LEFT JOIN tr_salesret ON trsr_no = dtsr_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'SR'
													AND trju_refno = trsr_no
						WHERE dtsr_mspd_no = '".$mspd_no."'
						AND trsr_void = 0
						AND trju_no IS NOT NULL
						AND trsr_tglterima <> '0000-00-00'
						LIMIT 1";

			$query = $this->db->query($str_query);

			if($query->num_rows() > 0){
				$str_query = "TRUNCATE TABLE temp_trans_jurnal";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES RETURN ----- insert temp table';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO temp_trans_jurnal (ref_no,trju_no)
								(SELECT DISTINCT trsr_no, trju_no 
									FROM dt_salesret
									LEFT JOIN tr_salesret ON trsr_no = dtsr_no 
									LEFT JOIN tr_jurnal ON trju_tipe = 'A'
															AND trju_reftipe = 'SR'
															AND trju_refno = trsr_no
								WHERE dtsr_mspd_no = '".$mspd_no."'
								AND trsr_void = 0
								AND trju_no IS NOT NULL
								AND trsr_tglterima <> '0000-00-00'
								)";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES RETURN ----- DELETE dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "DELETE dtju FROM dt_jurnal dtju
								WHERE dtju.dtju_no IN 
								(SELECT DISTINCT trju_no FROM temp_trans_jurnal)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 1
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES RETURN ----- tahap 1 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
											(dtsr_seq * 5) - 4, 
											mskt_msap_no_inv,
											ROUND((dtsr_qtyretur * dtsr_hpp), 4),
											0,
											'',''
								FROM dt_salesret		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsr_no																
								LEFT JOIN ms_kategori ON mskt_no = substr(dtsr_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								AND dtsr_qtyretur <> 0
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 2
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES RETURN ----- tahap 2 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
										(dtsr_seq * 5) - 3, 
										IF(mscs_jenis = 'A', mskt_msap_no_hpa, mskt_msap_no_hpr),
										0,
										ROUND((dtsr_qtyretur * dtsr_hpp), 4),
										'',''
								FROM dt_salesret		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsr_no																
								LEFT JOIN tr_salesret ON trsr_no = dtsr_no
								LEFT JOIN ms_customer ON mscs_no = trsr_mscs_no										
								LEFT JOIN ms_kategori ON mskt_no = substr(dtsr_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								AND dtsr_qtyretur <> 0
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 3
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES RETURN ----- tahap 3 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
											(dtsr_seq * 5) - 2, 
											IF(mscs_jenis = 'A', mskt_msap_no_sra, mskt_msap_no_srr),
											ROUND((dtsr_qtyretur * dtsr_bftax), 4),
											0,
											'',''
								FROM dt_salesret		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsr_no																
								LEFT JOIN tr_salesret ON trsr_no = dtsr_no
								LEFT JOIN ms_customer ON mscs_no = trsr_mscs_no										
								LEFT JOIN ms_kategori ON mskt_no = substr(dtsr_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								AND dtsr_qtyretur <> 0
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 5
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES RETURN ----- tahap 5 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
											(dtsr_seq * 5), 
											IF(mscs_jenis = 'A' AND trsr_jenis = 'C', '".$this->SRCA."',
												IF(mscs_jenis = 'R' AND trsr_jenis = 'C', '".$this->SRCR."',
													IF(mscs_jenis = 'A' AND trsr_jenis = 'V', '".$this->SRVA."',
														'".$this->SRVR."'
													)	
												)
											),
											0,
											ROUND((dtsr_qtyretur * dtsr_nett), 4),
											'',''
								FROM dt_salesret		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsr_no																
								LEFT JOIN tr_salesret ON trsr_no = dtsr_no
								LEFT JOIN ms_customer ON mscs_no = trsr_mscs_no																		
								WHERE ref_no IS NOT NULL
								AND dtsr_qtyretur <> 0
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 4
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SALES RETURN ----- tahap 4 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
											(dtsr_seq * 5) - 1, 
											'".$this->PPNK."',
											round(
											(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtsr_seq * 5))
											-
											(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtsr_seq * 5) - 2)
											, 4),
											0,
											'',''
								FROM dt_salesret		
								LEFT JOIN temp_trans_jurnal ON ref_no = dtsr_no																								
								WHERE ref_no IS NOT NULL
								AND dtsr_qtyretur <> 0
								)";
				$query = $this->db->query($str_query);
			}

		}	

		// PROSES UPDATE HPP (DETAIL SPK)------------------------------------------------------------
		if($vok){
			// SET dtspk_hpp 
			$str_query = "UPDATE dt_spk_sp
							LEFT JOIN ms_produk ON mspd_no = dtspk_mspd_no
							LEFT JOIN tr_spk ON trspk_no = dtspk_no
							SET dtspk_hpp = mspd_hpp
							WHERE dtspk_mspd_no = '".$mspd_no."'
							AND trspk_void = 0";
			
			if(!$this->db->simple_query($str_query)){				
				$vok = false;
				$err = true;
				$err_msg = 'Error set dtspk_hpp';
			}		
		}

		// PROSES UPDATE JURNAL SPK (SPK FINISH)------------------------------------------------------
		if($vok){
			$str_query = "SELECT trspk_no, trju_no 
							FROM dt_spk_sp
							LEFT JOIN tr_spk ON trspk_no = dtspk_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'SP'
													AND trju_refno = CONCAT(trspk_no, 'SP')
						WHERE dtspk_mspd_no = '".$mspd_no."'
						AND trspk_void = 0
						AND trju_no IS NOT NULL
						AND trspk_tglselesai <> '0000-00-00'
						LIMIT 1";
			$query = $this->db->query($str_query);

			if($query->num_rows() > 0){
				$str_query = "TRUNCATE TABLE temp_trans_jurnal";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SPK ----- insert temp table';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO temp_trans_jurnal (ref_no,trju_no)
								(SELECT DISTINCT trspk_no, trju_no 
									FROM dt_spk_sp
									LEFT JOIN tr_spk ON trspk_no = dtspk_no 
									LEFT JOIN tr_jurnal ON trju_tipe = 'A'
															AND trju_reftipe = 'SP'
															AND trju_refno = CONCAT(trspk_no, 'SP')
								WHERE dtspk_mspd_no = '".$mspd_no."'
								AND trspk_void = 0
								AND trju_no IS NOT NULL
								AND trspk_tglselesai <> '0000-00-00'
								)";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SPK ----- DELETE dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "DELETE dtju FROM dt_jurnal dtju
								WHERE dtju.dtju_no IN 
								(SELECT DISTINCT trju_no FROM temp_trans_jurnal)";
				$query = $this->db->query($str_query);				

				// Insert data detail jurnal tahap 1
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SPK ----- tahap 1 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									(dtspk_seq * 5) - 4, 
									IF(mscs_jenis = 'A', '".$this->PIUA."',
													'".$this->PIUR."'),
									ROUND((dtspk_nett * dtspk_qty), 4),
									0,
									'',''
								FROM dt_spk_sp
								LEFT JOIN temp_trans_jurnal ON ref_no = dtspk_no								
								LEFT JOIN tr_spk ON trspk_no = dtspk_no
								LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no										
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 2
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SPK ----- tahap 2 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
											(dtspk_seq * 5) - 3, 
											IF(mscs_jenis = 'A', mskt_msap_no_spa, mskt_msap_no_spr),
											0,
											ROUND((dtspk_bftax * dtspk_qty), 4),
									'',''
								FROM dt_spk_sp
								LEFT JOIN temp_trans_jurnal ON ref_no = dtspk_no								
								LEFT JOIN tr_spk ON trspk_no = dtspk_no
								LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no										
								LEFT JOIN ms_kategori ON mskt_no = substr(dtspk_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 3
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SPK ----- tahap 3 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
											(dtspk_seq * 5) - 2, 
											'".$this->PPNK."',
											0,
											round(
											(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtspk_seq * 5) - 4)
											-
											(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = trju_no AND dtju_seq = (dtspk_seq * 5) - 3)
											, 4),
									'',''
								FROM dt_spk_sp
								LEFT JOIN temp_trans_jurnal ON ref_no = dtspk_no																
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 4
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SPK ----- tahap 4 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
											(dtspk_seq * 5) - 1, 
											IF(mscs_jenis = 'A', mskt_msap_no_hpa, mskt_msap_no_hpr),
											ROUND((dtspk_hpp * dtspk_qty), 4),
											0,
									'',''
								FROM dt_spk_sp
								LEFT JOIN temp_trans_jurnal ON ref_no = dtspk_no																
								LEFT JOIN tr_spk ON trspk_no = dtspk_no
								LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no										
								LEFT JOIN ms_kategori ON mskt_no = substr(dtspk_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 5
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai SPK ----- tahap 5 dtju';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
											(dtspk_seq * 5), 
											mskt_msap_no_inv,
											0,
											ROUND((dtspk_hpp * dtspk_qty), 4),
									'',''
								FROM dt_spk_sp
								LEFT JOIN temp_trans_jurnal ON ref_no = dtspk_no																								
								LEFT JOIN ms_kategori ON mskt_no = substr(dtspk_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);						
			}
		}
		
		echo '<br>';
		echo date('H:i:s'). ' -> PROSES DELETE DETAIL JURNAL JOB COSTING';																				
		flush();
		ob_flush();
		sleep(0.001);

		// PROSES DELETE DETAIL JURNAL JOB COSTING----------------------------------------------------
		if($vok){
			$str_query = "DELETE dtju FROM dt_jurnal dtju
							LEFT JOIN tr_jurnal ON trju_no = dtju.dtju_no
							WHERE trju_refno IN(
							SELECT CONCAT(d.dtts_no, 'GT')
							FROM dt_tfmgoods d
							LEFT JOIN ms_produk p ON p.mspd_no = d.dtts_mspd_no
							LEFT JOIN tr_tfmgoods t ON t.trts_no = d.dtts_no
							LEFT JOIN
							(SELECT x.dtts_no,x.dtts_mspd_no,x.dtts_qty,x.dtts_hpp FROM dt_tfmgoods X
							WHERE x.dtts_jenis = 'R'
							) z ON z.dtts_no = d.dtts_no
							AND z.dtts_mspd_no = d.dtts_mspd_no
							AND z.dtts_qty = d.dtts_qty
							WHERE t.trts_void = 0
							AND d.dtts_jenis = 'F'
							AND z.dtts_no IS NOT NULL)
							AND trju_reftipe = 'GT'";
							
			if(!$this->db->simple_query($str_query)){
				$vok = false;
				$err = true;
				$err_msg = 'Error delete dt_jurnal job costing';
			}
		}

		echo '<br>';
		echo date('H:i:s'). ' -> PROSES DELETE HEADER JURNAL JOB COSTING';																				
		flush();
		ob_flush();
		sleep(0.001);

		// PROSES DELETE HEADER JURNAL JOB COSTING----------------------------------------------------
		if($vok){
			$str_query = "DELETE trju FROM tr_jurnal trju							
							WHERE trju_refno IN(
							SELECT CONCAT(d.dtts_no, 'GT')
							FROM dt_tfmgoods d
							LEFT JOIN ms_produk p ON p.mspd_no = d.dtts_mspd_no
							LEFT JOIN tr_tfmgoods t ON t.trts_no = d.dtts_no
							LEFT JOIN
							(SELECT x.dtts_no,x.dtts_mspd_no,x.dtts_qty,x.dtts_hpp FROM dt_tfmgoods X
							WHERE x.dtts_jenis = 'R'
							) z ON z.dtts_no = d.dtts_no
							AND z.dtts_mspd_no = d.dtts_mspd_no
							AND z.dtts_qty = d.dtts_qty
							WHERE t.trts_void = 0
							AND d.dtts_jenis = 'F'
							AND z.dtts_no IS NOT NULL)
							AND trju_reftipe = 'GT'";
							
			if(!$this->db->simple_query($str_query)){				
				$vok = false;
				$err = true;
				$err_msg = 'Error delete tr_jurnal job costing';
			}
		}
		
		echo '<br>';
		echo date('H:i:s'). ' -> PROSES VOID JOB COSTING YANG MERUBAH HPP';																				
		flush();
		ob_flush();
		sleep(0.001);

		// PROSES VOID JOB COSTING YANG MERUBAH HPP
		if($vok){
			$str_query = "UPDATE dt_tfmgoods d
								LEFT JOIN ms_produk p ON p.mspd_no = d.dtts_mspd_no
								LEFT JOIN tr_tfmgoods t ON t.trts_no = d.dtts_no
								LEFT JOIN
								(SELECT x.dtts_no,x.dtts_mspd_no,x.dtts_qty,x.dtts_hpp FROM dt_tfmgoods X
								WHERE x.dtts_jenis = 'R'
								) z ON z.dtts_no = d.dtts_no
								AND z.dtts_mspd_no = d.dtts_mspd_no
								AND z.dtts_qty = d.dtts_qty			 
						SET t.trts_void = 1			
						WHERE t.trts_void = 0
						AND d.dtts_jenis = 'F'
						AND z.dtts_no IS NOT NULL";

			if(!$this->db->simple_query($str_query)){				
				$vok = false;
				$err = true;
				$err_msg = 'Error void tr_tfmgoods';
			}	
		}		

		// PROSES UPDATE HPP (DETAIL JOB COSTING)-----------------------------------------------------
		if($vok){
			// SET dtts_hpp 
			$str_query = "UPDATE dt_tfmgoods
							LEFT JOIN ms_produk ON mspd_no = dtts_mspd_no
							LEFT JOIN tr_tfmgoods ON trts_no = dtts_no
							SET dtts_hpp = mspd_hpp
							WHERE dtts_mspd_no = '".$mspd_no."'
							AND trts_void = 0";
			
			if(!$this->db->simple_query($str_query)){				
				$vok = false;
				$err = true;
				$err_msg = 'Error set dtts_hpp';
			}		
		}

		// PROSES UPDATE JURNAL JOB COSTING ----------------------------------------------------------
		if($vok){
			$str_query = "SELECT trts_no, trju_no 
							FROM dt_tfmgoods
							LEFT JOIN tr_tfmgoods ON trts_no = dtts_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'GT'
													AND trju_refno = CONCAT(trts_no, 'GT')
						WHERE dtts_mspd_no = '".$mspd_no."'
						AND trts_void = 0
						AND trju_no IS NOT NULL
						LIMIT 1";
			$query = $this->db->query($str_query);

			if($query->num_rows() > 0){
				$str_query = "TRUNCATE TABLE temp_trans_jurnal";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai JOB COSTING ----- insert temp table';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO temp_trans_jurnal (ref_no,trju_no)
								(SELECT DISTINCT trts_no, trju_no 
									FROM dt_tfmgoods
									LEFT JOIN tr_tfmgoods ON trts_no = dtts_no 
									LEFT JOIN tr_jurnal ON trju_tipe = 'A'
															AND trju_reftipe = 'GT'
															AND trju_refno = CONCAT(trts_no, 'GT')
								WHERE dtts_mspd_no = '".$mspd_no."'
								AND trts_void = 0
								AND trju_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai JOB COSTING ----- DELETE dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "DELETE dtju FROM dt_jurnal dtju
								WHERE dtju.dtju_no IN 
								(SELECT DISTINCT trju_no FROM temp_trans_jurnal)";
				$query = $this->db->query($str_query);

				// INGAT!!! KONFIRMASI AKUN SELISIH 

				// Insert detail accper selisih	-----------------------------------------------------------------------				
				$str_query = "INSERT INTO dt_tfmgoods_accper(dttsap_no,dttsap_seq,dttsap_jenis,dttsap_msap_no,dttsap_total)
								(SELECT
									temp.trts_no
									,temp.max_seq + 1
									,IF((totalResult + totalAccperResult) <= (totalFrom + totalAccperFrom), 'R', 'F')									
									,'".$this->msap_no."'
									,ABS((totalFrom + totalAccperFrom) - (totalResult + totalAccperResult))
								FROM
									(SELECT
										trts_no
										,(SELECT IFNULL(ROUND(SUM(dtts_qty * dtts_hpp), 4), 0) FROM dt_tfmgoods WHERE dtts_no = trts_no AND dtts_jenis = 'F') totalFrom
										,(SELECT IFNULL(SUM(dttsap_total), 0) FROM dt_tfmgoods_accper WHERE dttsap_no = trts_no AND dttsap_jenis = 'F') totalAccperFrom
										,(SELECT IFNULL(ROUND(SUM(dtts_qty * dtts_hpp), 4), 0) FROM dt_tfmgoods WHERE dtts_no = trts_no AND dtts_jenis = 'R') totalResult	
										,(SELECT IFNULL(SUM(dttsap_total), 0) FROM dt_tfmgoods_accper WHERE dttsap_no = trts_no AND dttsap_jenis = 'R') totalAccperResult
										,(SELECT IFNULL(MAX(dttsap_seq), 0) FROM dt_tfmgoods_accper WHERE dttsap_no = trts_no) max_seq	
										FROM tr_tfmgoods 
										LEFT JOIN temp_trans_jurnal ON ref_no = trts_no
										WHERE ref_no IS NOT NULL
										GROUP BY trts_no	
									) AS temp
								)";
				$query = $this->db->query($str_query);


				// Insert data detail jurnal tahap 1
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai JOB COSTING ----- tahap 1 dtju';		
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
									dtts_seq, 
									mskt_msap_no_inv,
									iF((dtts_jenis = 'R'), ROUND(dtts_qty * dtts_hpp, 4), 0),
									iF((dtts_jenis = 'F'), ROUND(dtts_qty * dtts_hpp, 4), 0),
									'',''
								FROM dt_tfmgoods
								LEFT JOIN temp_trans_jurnal ON ref_no = dtts_no
								LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtts_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								)";								
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 2
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai JOB COSTING ----- tahap 2 dtju';		
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
										(dttsap_seq + 5000), 
										dttsap_msap_no,
										IF((dttsap_jenis = 'R'), dttsap_total, 0),
										IF((dttsap_jenis = 'F'), dttsap_total, 0),
									'',''
								FROM dt_tfmgoods_accper
								LEFT JOIN temp_trans_jurnal ON ref_no = dttsap_no								
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);
			}			
		}

		echo '<br>';
		echo date('H:i:s'). ' -> PROSES DELETE DETAIL JURNAL GOODS CONVERSION';																				
		flush();ob_flush();sleep(0.001);

		// PROSES DELETE DETAIL JURNAL GOODS CONVERSION-----------------------------------------------
		if($vok){
			$str_query = "DELETE dtju FROM dt_jurnal dtju
							LEFT JOIN tr_jurnal ON trju_no = dtju.dtju_no
							WHERE trju_refno IN 
							(SELECT CONCAT(d.dtcv_no, 'GC') FROM dt_cvtgoods d
							LEFT JOIN ms_produk p ON p.mspd_no = d.dtcv_mspd_no
							LEFT JOIN tr_cvtgoods t ON t.trcv_no = d.dtcv_no
							LEFT JOIN
							(SELECT x.dtcv_no,x.dtcv_mspd_no,x.dtcv_qty,x.dtcv_hpp FROM dt_cvtgoods X
							WHERE x.dtcv_jenis = 'R'
							) z ON z.dtcv_no = d.dtcv_no
							AND z.dtcv_mspd_no = d.dtcv_mspd_no
							AND z.dtcv_qty = d.dtcv_qty
							WHERE t.trcv_void = 0
							AND d.dtcv_jenis = 'F'
							AND z.dtcv_no IS NOT NULL)
							AND trju_reftipe = 'GC'";
			
			if(!$this->db->simple_query($str_query)){				
				$vok = false;
				$err = true;
				$err_msg = 'Error delete dt_jurnal goods conversion.';
			}	
		}

		echo '<br>';
		echo date('H:i:s'). ' -> PROSES DELETE HEADER JURNAL GOODS CONVERSION';																				
		flush();ob_flush();sleep(0.001);

		// PROSES DELETE HEADER JURNAL GOODS CONVERSION-----------------------------------------------
		if($vok){
			$str_query = "DELETE trju FROM tr_jurnal trju
							WHERE trju_refno IN 
							(SELECT CONCAT(d.dtcv_no, 'GC') FROM dt_cvtgoods d
							LEFT JOIN ms_produk p ON p.mspd_no = d.dtcv_mspd_no
							LEFT JOIN tr_cvtgoods t ON t.trcv_no = d.dtcv_no
							LEFT JOIN
							(SELECT x.dtcv_no,x.dtcv_mspd_no,x.dtcv_qty,x.dtcv_hpp FROM dt_cvtgoods X
							WHERE x.dtcv_jenis = 'R'
							) z ON z.dtcv_no = d.dtcv_no
							AND z.dtcv_mspd_no = d.dtcv_mspd_no
							AND z.dtcv_qty = d.dtcv_qty
							WHERE t.trcv_void = 0
							AND d.dtcv_jenis = 'F'
							AND z.dtcv_no IS NOT NULL)
							AND trju_reftipe = 'GC'";
			
			if(!$this->db->simple_query($str_query)){
				$vok = false;
				$err = true;
				$err_msg = 'Error delete tr_jurnal goods conversion.';
			}	
		}
		
		echo '<br>';
		echo date('H:i:s'). ' -> PROSES VOID GOODS CONVERSION YANG MERUBAH HPP';																				
		flush();ob_flush();sleep(0.001);

		// PROSES VOID GOODS CONVERSION YANG MERUBAH HPP----------------------------------------------
		if($vok){
			$str_query = "UPDATE dt_cvtgoods d
							LEFT JOIN ms_produk p ON p.mspd_no = d.dtcv_mspd_no
							LEFT JOIN tr_cvtgoods t ON t.trcv_no = d.dtcv_no
							LEFT JOIN
							(SELECT x.dtcv_no,x.dtcv_mspd_no,x.dtcv_qty,x.dtcv_hpp FROM dt_cvtgoods X
							WHERE x.dtcv_jenis = 'R'
							) z ON z.dtcv_no = d.dtcv_no
							AND z.dtcv_mspd_no = d.dtcv_mspd_no
							AND z.dtcv_qty = d.dtcv_qty
						SET trcv_void = 1
						WHERE t.trcv_void = 0
						AND d.dtcv_jenis = 'F'
						AND z.dtcv_no IS NOT NULL";

			if(!$this->db->simple_query($str_query)){				
				$vok = false;
				$err = true;
				$err_msg = 'Error void tr_cvtgoods';
			}	
		}
			
		// PROSES UPDATE HPP (DETAIL GOODS CONVERSION)------------------------------------------------
		if($vok){
			// SET dtcv_hpp 
			$str_query = "UPDATE dt_cvtgoods
							LEFT JOIN ms_produk ON mspd_no = dtcv_mspd_no
							LEFT JOIN tr_cvtgoods ON trcv_no = dtcv_no
							SET dtcv_hpp = mspd_hpp
							WHERE dtcv_mspd_no = '".$mspd_no."'
							AND trcv_void = 0";
			
			if(!$this->db->simple_query($str_query)){				
				$vok = false;
				$err = true;
				$err_msg = 'Error set dtcv_hpp';
			}		
		}

		// PROSES UPDATE JURNAL GOODS CONVERSION -------------------------------------------------
		if($vok){
			$str_query = "SELECT trcv_no, trju_no 
							FROM dt_cvtgoods
							LEFT JOIN tr_cvtgoods ON trcv_no = dtcv_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'GC'
													AND trju_refno = CONCAT(trcv_no, 'GC')
						WHERE dtcv_mspd_no = '".$mspd_no."'
						AND trcv_void = 0
						AND trju_no IS NOT NULL
						LIMIT 1";
			$query = $this->db->query($str_query);

			if($query->num_rows() > 0){
				$str_query = "TRUNCATE TABLE temp_trans_jurnal";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai GOODS CONVERSION ----- insert temp table';
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO temp_trans_jurnal (ref_no,trju_no)
								(SELECT DISTINCT trcv_no, trju_no 
									FROM dt_cvtgoods
									LEFT JOIN tr_cvtgoods ON trcv_no = dtcv_no 
									LEFT JOIN tr_jurnal ON trju_tipe = 'A'
															AND trju_reftipe = 'GC'
															AND trju_refno = CONCAT(trcv_no, 'GC')
								WHERE dtcv_mspd_no = '".$mspd_no."'
								AND trcv_void = 0
								AND trju_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai GOODS CONVERSION ----- DELETE dtju';																				
				flush();ob_flush();sleep(0.001);

				$str_query = "DELETE dtju FROM dt_jurnal dtju
								WHERE dtju.dtju_no IN 
								(SELECT DISTINCT trju_no FROM temp_trans_jurnal)";
				$query = $this->db->query($str_query);				

				echo '<br>';
				echo date('H:i:s'). ' -> Mulai GOODS CONVERSION ----- INSERT AKUN SELISIH';																				
				flush();ob_flush();sleep(0.001);
								
				// Insert detail accper selisih
				$str_query = "INSERT INTO dt_cvtgoods_accper(dtcvap_no,dtcvap_seq,dtcvap_jenis,dtcvap_msap_no,dtcvap_total)
								(SELECT
									temp.trcv_no
									,temp.max_seq + 1 
									,IF((totalResult + totalAccperResult) <= (totalFrom + totalAccperFrom), 'R', 'F')
									,'".$this->msap_no."'
									,ABS((totalFrom + totalAccperFrom) - (totalResult + totalAccperResult))
								FROM
									(SELECT 
										trcv_no
										,(SELECT IFNULL(ROUND(SUM(dtcv_qty * dtcv_hpp), 4), 0) FROM dt_cvtgoods WHERE dtcv_no = trcv_no AND dtcv_jenis = 'F') totalFrom
										,(SELECT IFNULL(SUM(dtcvap_total), 0) FROM dt_cvtgoods_accper WHERE dtcvap_no = trcv_no AND dtcvap_jenis = 'F') totalAccperFrom
										,(SELECT IFNULL(ROUND(SUM(dtcv_qty * dtcv_hpp), 4), 0) FROM dt_cvtgoods WHERE dtcv_no = trcv_no AND dtcv_jenis = 'R') totalResult	
										,(SELECT IFNULL(SUM(dtcvap_total), 0) FROM dt_cvtgoods_accper WHERE dtcvap_no = trcv_no AND dtcvap_jenis = 'R') totalAccperResult	
										,(SELECT IFNULL(MAX(dtcvap_seq), 0) FROM dt_cvtgoods_accper WHERE dtcvap_no = trcv_no) max_seq	
										FROM tr_cvtgoods 
										LEFT JOIN temp_trans_jurnal ON ref_no = trcv_no
										WHERE ref_no IS NOT NULL
										GROUP BY trcv_no	
									) AS temp
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 1
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai GOODS CONVERSION ----- tahap 1 dtju';		
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
											dtcv_seq, 
											mskt_msap_no_inv,
											IF((dtcv_jenis = 'R'), ROUND(dtcv_qty * dtcv_hpp, 4), 0),
											IF((dtcv_jenis = 'F'), ROUND(dtcv_qty * dtcv_hpp, 4), 0),
											'',''
								FROM dt_cvtgoods
								LEFT JOIN temp_trans_jurnal ON ref_no = dtcv_no
								LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtcv_mspd_no, 1, 1)
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);

				// Insert data detail jurnal tahap 2
				echo '<br>';
				echo date('H:i:s'). ' -> Mulai GOODS CONVERSION ----- tahap 2 dtju';		
				flush();ob_flush();sleep(0.001);

				$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
								(SELECT trju_no,
											(dtcvap_seq + 5000), 
											dtcvap_msap_no,
											IF((dtcvap_jenis = 'R'), dtcvap_total, 0),
											IF((dtcvap_jenis = 'F'), dtcvap_total, 0),
											'',''
								FROM dt_cvtgoods_accper								
								LEFT JOIN temp_trans_jurnal ON ref_no = dtcvap_no								
								WHERE ref_no IS NOT NULL
								)";
				$query = $this->db->query($str_query);
			}																																												
		}							

		return array('err' => $err, 'err_msg' => $err_msg);
	}
						
}
