<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class purchase_request extends MY_Controller {
	private $data = array();
	private $vok = true;

	function __construct(){
		parent::__construct();
		$this->load->model('purchase/m_purchase_request');
		$this->load->model('data_master/m_produk');								
		$this->load->model('setting/m_user_log');		
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index(){			
		if(!fcek_hak_akses('.BA0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/purchase_request/v_purchase_request_list', $data);
		$this->load->view('v_footer');			
	}
	public function purchase_request_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_request');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['purchase_request_list'] = $this->m_purchase_request->get_purchase_request_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['purchase_request_list']);
		}
		else {
			$pagination['total_list'] = $this->m_purchase_request->get_purchase_request_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['purchase_request_list'] = $this->load->view('purchase/purchase_request/v_purchase_request_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function purchase_request_print(){
		$this->load->library('java_bridge');
		$trpr_no = $this->input->get('trpr_no');
		$paper_size = $this->input->get('paper_size');

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];
		

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		if($paper_size == 'A5'){
			$path = APPPATH.'prints\purchase\purchase_request\p_purchase_request_A5.jrxml';
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\purchase\purchase_request\p_purchase_request_A4.jrxml';
		}	
			
		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_TRPR_NO",new Java('java.lang.String', $trpr_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}

	public function pr_detail_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_request');

		$data = array();
		$result = array();
		$pagination = array();

		$per_page = $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');
		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');					

		$data['pr_detail_list'] = $this->m_purchase_request->pr_detail_list($arr_filter, $per_page, $offset, $fn, $sort, false);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;
		$pagination['total_list'] = count($this->m_purchase_request->pr_detail_list($arr_filter, $per_page, $offset, $fn, $sort, true));

		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['pr_detail_list'] = $this->load->view('purchase/purchase_request/v_pr_detail_datalist',$data,true);		
		$result['pr_detail'] = $this->m_purchase_request->pr_detail_list(array(), $per_page, $offset, $fn, $sort, true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		
		echo json_encode($result);
	}

	public function get_pr_detail(){									
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_request');
		
		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			

		echo json_encode($this->m_purchase_request->get_pr_detail($arr_filter));
	}
	
	public function purchase_request_new(){	
		if(!fcek_hak_akses('.BA1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/purchase_request/v_purchase_request_form',$data);
		$this->load->view('v_footer');		
	}

	public function purchase_request_view($trpr_no){	
		if(!fcek_hak_akses('.BA0.')) {
			redirect('forbidden');
		}

		if (is_null($trpr_no) || !$this->m_purchase_request->cek_trpr_no_exists($trpr_no)) {
			redirect('purchase_request');
			return;
		}
		$data = array();				
		$data = $this->m_purchase_request->get_purchase_request($trpr_no);
		// $data['detail_lm'] = json_encode($data['detail']);
		unset($_SESSION['detail_lm']);
		$this->session->set_userdata('detail_lm',$data['detail']);
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/purchase_request/v_purchase_request_form',$data);
		$this->load->view('v_footer');		
	}

	public function purchase_request_simpan(){		
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_request');		
		$vok = true;

		// set data transaksi
		if($vok){							
			$this->data['action'] = $this->input->post('action');			

			if($this->data['action'] == 'NEW'){
				$trpr_mscb_no = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$trpr_tgl = $this->input->post('trpr_tgl');
				$bulan = substr($trpr_tgl, 5, 2);			
				$tahun = substr($trpr_tgl, 2, 2);			
				$trpr_kode_depan = $trpr_mscb_no."PR".$tahun.$bulan; 			
				$this->data['header']['trpr_no'] = $this->m_purchase_request->purchase_request_kode_auto($trpr_kode_depan);
				$this->data['header']['trpr_mscb_no'] = $trpr_mscb_no;			
				$this->data['header']['trpr_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['header']['trpr_tgl'] = $trpr_tgl;
				$this->data['header']['trpr_void'] = 0;
			}

			if($this->data['action'] != 'NEW'){
				$this->data['header']['trpr_no'] = $this->input->post('trpr_no');
				// $this->data['detail_lm'] = $this->input->post('detail_lm');
			}

			$this->data['header']['trpr_catatan'] = fhapus_kutip($this->input->post('trpr_catatan'));
			$this->data['header']['trpr_tag'] = fhapus_kutip($this->input->post('trpr_tag'));			
			$this->data['header']['trpr_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['trpr_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];						

			if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['userlog']['msul_tgl'] = date('Y-m-d H:i:s');
				$this->data['userlog']['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['userlog']['msul_catatan'] = substr(trim('['.$this->data['action']. '] PURC.REQ '. $this->data['header']['trpr_no']. ' '. fhapus_kutip($this->input->post('trpr_tag')). ' '. fhapus_kutip($this->input->post('trpr_catatan'))), 0, 250);
			}
								
			$dtpr = $this->input->post('dtpr');			
						
			foreach ($dtpr as $key => $value) {			
				for ($i=0; $i < count($dtpr[$key]); $i++) {
					if($dtpr['dtpr_mspd_no'][$i] != ''){
						$this->data['detail'][$i]['dtpr_no'] = $this->data['header']['trpr_no'];
						if($key == 'dtpr_qtyreq'){
							$this->data['detail'][$i][$key] = ftodouble($value[$i]);
						}else{
							$this->data['detail'][$i][$key] = $value[$i];
						}
					}				
				}
			}							
		}				

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);								
			}
		}				

		// simpan data transaksi
		if($vok){		
			$vresult = $this->m_purchase_request->purchase_request_simpan($this->data);
			if($vresult == 0){				
				$vok = false;
				$msg = array('error'=>'Error query');								
			}
		}				        

		// berhasil simpan data
		if($vok){											
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';				
  	 		$result['trpr_no'] = $this->data['header']['trpr_no'];	      	 		      	 		
		}			

		// gagal simpan data
		if(!$vok){					
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;							
		}				        

		echo json_encode($result);
	}	

	private function cek_valid_data_trans($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | VOID

			$msg = '';
			$hsl = true;					

			// cek produk required
			if($hsl){				
				if(!isset($data['detail'])){
					$hsl = false;					
					$msg = 'Please select product';					
				}
			}			

			if($hsl){
				$data['detail_lm'] = $this->session->userdata('detail_lm');
				if(isset($data['detail_lm'])){
					foreach ($data['detail_lm'] as $key => $value) {						

						// utk pengecekan cekint detail Purchase Request 
						// Valid = CekInt tidak berubah			
						if ($menu == 'EDIT' || $menu == 'VOID') {
							if($this->m_purchase_request->get_purchase_request_cekint($data['detail_lm'][$key]['dtpr_no'],
																						$data['detail_lm'][$key]['dtpr_seq'],
																						$data['detail_lm'][$key]['dtpr_cekint']) == false){

								$hsl = false;
								$msg = 'Data have been changed by another user. Please Refresh the page';
								break;		
							}else{
								$this->m_purchase_request->set_purchase_request_cekint($data['detail_lm'][$key]['dtpr_no'],
																						$data['detail_lm'][$key]['dtpr_seq']);
							}							
						}							
					}
				}	
				unset($_SESSION['po_detail_lm']);	
			}	

			return array('valid'=>$hsl, 'msg'=>$msg);
	}

}