<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class purchase_order extends MY_Controller {
	private $data = array();

	function __construct(){
		parent::__construct();
		$this->load->model('purchase/m_purchase_order');
		$this->load->model('purchase/m_apv_pr');
		$this->load->model('setting/m_currency_rates');
		$this->load->model('finance_and_acc/m_po_payment');		
		$this->load->model('finance_and_acc/m_jurnal');
		$this->load->model('data_master/m_user');
		$this->load->helper('security');
		$this->load->library('java_bridge');
		error_reporting(E_ALL ^ (E_NOTICE));
		error_reporting(E_ERROR | E_PARSE);
	}

	public function index($tipe_trans = null){					

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			if(!fcek_hak_akses('.HB7.')){
				redirect('forbidden');
			}

			$tipe_trans = 'F';
		} else {
			if(!fcek_hak_akses('.HB8.')){
				redirect('forbidden');
			}

			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('purchase_order');
			}
		}
		// if($tipe_trans != null){			
		// 	if($this->session->userdata('svlogin') == 'C' && $tipe_trans != 'F' && $tipe_trans != 'C' ||
		// 		$this->session->userdata('svlogin') == 'F' && $tipe_trans != null && $tipe_trans != 'F'){				
		// 		redirect('purchase_order');
		// 	}
		// }

		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? 'F' : 'C';
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/purchase_order/v_purchase_order_list', $data);
		$this->load->view('v_footer');			
	}

	public function purchase_order_list(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_order');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['purchase_order_list'] = $this->m_purchase_order->get_purchase_order_list($arr_filter, false, $per_page, $offset, $fn, $sort);
		$data['request_from'] = $this->input->post('request_from');

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['purchase_order_list']);
		}
		else {
			$pagination['total_list'] = $this->m_purchase_order->get_purchase_order_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['purchase_order_list'] = $this->load->view('purchase/purchase_order/v_purchase_order_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}	

	public function purchase_order_toplist(){	
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_order');

		$data = array();
		$result = array();
		$pagination = array();

		$per_page = $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');
		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			

		$data['purchase_order_toplist'] = $this->m_purchase_order->get_purchase_order_toplist($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;
		$pagination['total_list'] = $this->m_purchase_order->get_purchase_order_toplist($arr_filter, true);		
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['purchase_order_toplist'] = $this->load->view('purchase/purchase_order/v_purchase_order_topdatalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $this->m_purchase_order->get_purchase_order_toplist($arr_filter, true);
		
		echo json_encode($result);
	}

	public function purchase_order_new($tipe_trans = null){	
		if(!fcek_hak_akses('.BC1.')) {
			redirect('forbidden');
		}

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			$tipe_trans = 'F';
		} else {
			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('purchase_order');
			}
		}
		// if($tipe_trans != null){			
		// 	if($this->session->userdata('svlogin') == 'C' && $tipe_trans != 'F' && $tipe_trans != 'C' ||
		// 		$this->session->userdata('svlogin') == 'F' && $tipe_trans != null && $tipe_trans != 'F'){				
		// 		redirect('purchase_order');
		// 	}
		// }

		$data = array();
		$data['action'] = 'new';
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? 'F' : 'C';
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/purchase_order/v_purchase_order_form',$data);
		$this->load->view('v_footer');		
	}

	public function purchase_order_print(){
		$trpo_no = $this->input->get('trpo_no');
		$paper_size = $this->input->get('paper_size');

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];
		

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		if($paper_size == 'A5'){
			$path = APPPATH.'prints\purchase\purchase_order\p_purchase_order_A5.jrxml';
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\purchase\purchase_order\p_purchase_order_A4.jrxml';
		}

		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH", new Java('java.lang.String', $logo));
		$params->put("P_TRPO_NO", new Java('java.lang.String', $trpo_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}

	public function purchase_order_view($trpo_no){			
		if(!fcek_hak_akses('.BC0.')) {
			redirect('forbidden');
		}

		$data = array();				
		$data = $this->m_purchase_order->get_purchase_order($trpo_no);	

		if (is_null($trpo_no) || count($data) <= 0) {
			redirect('purchase_order');
			return;
		}		

		$trju_no = $this->m_jurnal->get_jurnalid($trpo_no.'SK');
		if($trju_no != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);			
			$data['jurnal_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_d'] = $data_jurnal['jurnal_d'];				
		}
		
		unset($_SESSION['po_detail_lm']);
		$this->session->set_userdata('po_detail_lm',$data['detail']);
		// $data['resume_po_payment'] = $this->m_po_payment->get_resume_po_payment($trpo_no);		
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		$data['tipe_trans']	= $data['header']['trpo_fin'];
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/purchase_order/v_purchase_order_form',$data);
		$this->load->view('v_footer');		
	}

	public function purchase_order_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_order');		
		$this->form_validation->set_rules($this->config_validation());
		$vok = true;	
		$error_apv = false;	

		// set data transaksi
		if($vok){													
			$this->data['trpo_cekint'] = $this->input->post('trpo_cekint');
			$this->data['action'] = $this->input->post('action');

			if($this->data['action'] == 'NEW'){
				$trpo_mscb_no = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$trpo_tgl = $this->input->post('trpo_tgl');
				$bulan = substr($trpo_tgl, 5, 2);			
				$tahun = substr($trpo_tgl, 2, 2);		
				$separator = ($this->input->post('trpo_fin') == 'F') ? '-' : '_';		
				$trpo_kode_depan = $trpo_mscb_no."PO".$tahun.$bulan.$separator;
				$this->data['header']['trpo_no'] = $this->m_purchase_order->purchase_order_kode_auto($trpo_kode_depan);
				$this->data['header']['trpo_mscb_no'] = $trpo_mscb_no;
				$this->data['header']['trpo_tgl'] = $trpo_tgl;
				$this->data['header']['trpo_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['header']['trpo_lock'] = 'N';
				$this->data['header']['trpo_void'] = 0;
				$this->data['header']['trpo_fin'] = $this->input->post('trpo_fin');
				$this->data['header']['trpo_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trpo_fin') == 'C') ? 'A' : 'W';
			}

			if($this->data['action'] != 'NEW'){
				$this->data['header']['trpo_no'] = $this->input->post('trpo_no');
			}

			if($this->data['action'] == 'STCOPY'){				
				$this->data['header']['trpo_stcopy'] = ($this->input->post('trpo_stcopy') == 'R') ? 'X' : 'R';
			}			

			$this->data['header']['trpo_mssp_no'] = substr($this->input->post('trpo_mssp_no'), 0, 6);
			$this->data['header']['trpo_curr'] = $this->input->post('trpo_curr');			
			$this->data['header']['trpo_total'] = ftodouble($this->input->post('trpo_total'));
			$this->data['header']['trpo_catatan'] = fhapus_kutip($this->input->post('trpo_catatan'));
			$this->data['header']['trpo_tag'] = fhapus_kutip($this->input->post('trpo_tag'));			
			$this->data['header']['trpo_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['trpo_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];

			$ul_idx = 0;
			if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['userlog'][$ul_idx]['msul_tgl'] = date('Y-m-d H:i:s');
				$this->data['userlog'][$ul_idx]['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['userlog'][$ul_idx]['msul_catatan'] = substr(trim('['.$this->data['action']. '] PO '. $this->data['header']['trpo_no']. ' SUPP:'. substr($this->input->post('trpo_mssp_no'), 9). ' '. fhapus_kutip($this->input->post('trpo_tag')). ' '. fhapus_kutip($this->input->post('trpo_catatan'))), 0, 250);
			}

			$dtpo = $this->input->post('dtpo');
			$temp_dtpo = $this->input->post('temp_dtpo');
			
			if(isset($dtpo)){
				foreach ($dtpo as $key => $value) {			
					for ($i=0; $i < count($dtpo[$key]); $i++) {						
						$this->data['detail'][$i]['dtpo_no'] = $this->data['header']['trpo_no'];
						if($key == 'dtpo_qty' || $key == 'dtpo_bftax' || $key == 'dtpo_tax' || $key == 'dtpo_nett'){
							$this->data['detail'][$i][$key] = ftodouble($value[$i]);
						}else if($key == 'dtpo_msus_no'){
							$this->data['detail'][$i][$key] = $value[$i];
							if($dtpo['dtpo_msus_no'][$i] != ''){
								$ul_idx += 1;
								$this->data['userlog'][$ul_idx]['msul_tgl'] = $this->data['header']['trpo_lsupd'];
								$this->data['userlog'][$ul_idx]['msul_msus_no'] = $dtpo['dtpo_msus_no'][$i];
								$this->data['userlog'][$ul_idx]['msul_catatan'] = substr(trim('[APV.HRG.PO] '.$this->data['header']['trpo_no']. ' DPP Last PO '.$dtpo['dtpo_last_curr'][$i].' '.$dtpo['dtpo_last_price'][$i].' APPROVED '.$dtpo['dtpo_bftax'][$i].' PRODUK: '.$dtpo['dtpo_mspd_no'][$i].' - '.$temp_dtpo['mspd_nm'][$i]),0, 250);
							}

						}else{
							$this->data['detail'][$i][$key] = $value[$i];
						}						
					}
				}
			}

			$top_po = $this->input->post('top_po');
			
			if(isset($top_po)){
				foreach ($top_po as $key => $value) {
					for ($i=0; $i < count($top_po[$key]); $i++) {
						if ($top_po['tppo_tgljatuhtempo'][$i] != '' || $top_po['tppo_value'][$i] != '' || $top_so['tppo_cttn'][$i] != '') {
							$this->data['top_po'][$i]['tppo_no'] = $this->data['header']['trpo_no'];
							if($key == 'tppo_value'){
								$this->data['top_po'][$i][$key] = ftodouble($value[$i]);
							}else{
								$this->data['top_po'][$i][$key] = $value[$i];
							}
						}						
					}
				}
			}				
		}

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;
				$msg = $this->form_validation->error_array();
				// $result['response'] = 'gagal';
				// $result['error_message'] = $this->form_validation->error_array();
				// echo json_encode($result);
			}
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$msg = array('error'=>$hasil_cek['msg']);
				$error_apv = $hasil_cek['error_apv'];
				// $result['response'] = 'gagal';
				// $result['error_message'] = array('error'=>$hasil_cek['msg']);
				// echo json_encode($result);
			}
		}	
		
		// simpan data
		if($vok){							
			$vresult = $this->m_purchase_order->purchase_order_simpan($this->data);
			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');
				$result['response'] = 'sukses';				
      	 		$result['trpo_no'] = $this->data['header']['trpo_no'];
      	 		// echo json_encode($result);
			}else{
				$vok = false;
				$msg = array('error'=>'Error query');
				// $result['response'] = 'gagal';
				// $result['error_message'] = array('error'=>'Error query');
				// echo json_encode($result);
			}
		}else{
			if($error_apv == true){
				$result['response'] = 'perlu_acc';
			}else{
				$result['response'] = 'gagal';
			}
			$result['error_message'] = $msg;
			// $result['error_message'] = $result['response'];
		}

		echo json_encode($result);				        
	}

	public function last_price_dpp(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_order');

		$data = array();
		$data = $this->input->post('arr_mspd_no');					
		$last_price = $this->m_purchase_order->get_limit_price_dt($data);
		
		echo json_encode($last_price);
	}

	public function approve_underminprice(){		
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_order');
		
		$vok = true;
		$msg = '';		

		if($this->input->post('jenis_otorisasi') == 'K'){			
			$key_otorisasi = $this->input->post('key_otorisasi');
			$user_otorisasi = $this->input->post('user_otorisasi');
			$kode_otorisasi = $this->input->post('kode_otorisasi');
			$kode_otorisasi_gen = fkode_otorisasi_gen($user_otorisasi, $key_otorisasi);
			$msus_data = $this->m_user->get_user_byotoritas($user_otorisasi,'.BCC.');

			if($vok && $user_otorisasi == ''){
				$vok = false;
				$msg = 'Please input user otorisasi';
			}			

			if($vok && $kode_otorisasi != $kode_otorisasi_gen){
				$vok = false;
				$msg = 'User Otorisasi or Kode Otorisasi is invalid';
			}

			if($vok && count($msus_data) <= 0){
				$vok = false;
				$msg = 'User Otorisasi does not have permissions';
			}
		}

		if($this->input->post('jenis_otorisasi') == 'L'){
			$msus_nm = $this->input->post('msus_nm');
			$msus_pswd = do_hash($this->input->post('msus_pswd'),'md5');		
			$msus_data = $this->m_user->get_user_aktif($msus_nm,$msus_pswd);

			if($vok && $msus_nm == ''){
				$vok = false;
				$msg = 'Please input username';
			}

			if($vok && $this->input->post('msus_pswd') == ''){
				$vok = false;
				$msg = 'Please input password';
			}

			if($vok && count($msus_data) <= 0){
				$vok = false;
				$msg = 'Userame and password do not match or User is not allowed';
			}

			if($vok && preg_match("/(.BCC.)/i", $msus_data[0]['msug_hakakses']) == false){
				$vok = false;
				$msg = 'User does not have permissions';
			}
		}		

		if($vok){
			$result['response'] = "sukses";			
			$result['msus_no'] = $msus_data[0]['msus_no'];
		}else{								
			$result['response'] = "gagal";			
			$result['error_message'] = $msg;		
			$result['mt_rand'] = mt_rand(100000, 999999);		
		}

		echo json_encode($result);
	}

	public function purchase_order_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_order');

		if(fcek_hak_akses('.HB7.') && fcek_hak_akses('.HB8.')){
			$tipe_trans = '';
		}elseif (fcek_hak_akses('.HB7.') && !fcek_hak_akses('.HB8.')) {
			$tipe_trans = 'F';
		}elseif (!fcek_hak_akses('.HB7.') && fcek_hak_akses('.HB8.')) {
			if($this->session->userdata('svlogin') == 'C'){
				$tipe_trans = 'C';
			}else{
				$tipe_trans = '';
			}
		}

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';
		$data['tipe_trans'] = $tipe_trans;
		// $data['import_po'] = true;

		$respon = array();
		$respon['popup'] = $this->load->view('purchase/purchase_order/v_purchase_order_popup',$data,true);	
		echo json_encode($respon);		
	}

	public function top_po_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_order');		
		$vok = true;

		// set data
		if($vok){
			$data['header']['trpo_no'] = $this->input->post('trpo_no');
			$data['trpo_cekint'] = $this->input->post('trpo_cekint');
			$data['top_po'] = $this->input->post('top_po');			
		}		

		// cek data valid
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('EDIT_TOP_PO', $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}	

		// void data
		if($vok){
			$vresult = $this->m_purchase_order->top_po_simpan($data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');				
				$result['response'] = 'sukses';
      	 		$result['trpo_no'] = $data['header']['trpo_no'];
      	 		echo json_encode($result);			      	 	
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}	
	}

	public function purchase_order_lockpo(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_order');

		$vok = true;

		// set data
		if($vok){
			$data['header']['trpo_no'] = $this->input->post('trpo_no');
			$data['trpo_cekint'] = $this->input->post('trpo_cekint');
			$data['trpo_sisadp'] = $this->input->post('trpo_sisadp');
		}		

		// cek data valid
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('LOCKPO', $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}

		// lock PO
		if($vok){
			$vresult = $this->m_purchase_order->purchase_order_lockpo($data['header']['trpo_no']);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');				
				$result['response'] = 'sukses';
      	 		$result['trpo_no'] = $data['header']['trpo_no'];
      	 		echo json_encode($result);			      	 	
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}	
	}	

	public function purchase_order_cancellockpo(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_order');

		$vok = true;

		// set data
		if($vok){
			$data['trpo_cekint'] = $this->input->post('trpo_cekint');
			$data['trpo_stcopy'] = $this->input->post('trpo_stcopy');
			$data['header']['trpo_no'] = $this->input->post('trpo_no');
			$data['header']['trpo_total'] = ftodouble($this->input->post('trpo_total'));
		}

		// cek data valid
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('CANCEL_LOCKPO', $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}		

		// void data
		if($vok){
			$vresult = $this->m_purchase_order->purchase_order_cancellockpo($data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');				
				$result['response'] = 'sukses';
      	 		$result['trpo_no'] = $data['header']['trpo_no'];
      	 		echo json_encode($result);			      	 	
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}	
	}

	public function purchase_order_finalize($trpo_no){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_order');

		$vok = true;
		$msg = '';

		// set data
		if($vok){
			$this->data['trpo_cekint'] = $this->input->post('trpo_cekint');
			$this->data['trpo_sisadp'] = $this->input->post('trpo_sisadp');
			$this->data['trpo_total'] = ftodouble($this->input->post('trpo_total_lock'));
			$this->data['trpo_terbayar'] = ftodouble($this->input->post('trpo_terbayar'));
			$this->data['header']['trpo_no'] = $this->input->post('trpo_no');			
			$this->data['header']['trpo_final'] = 'Y';
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('FINALIZE_PO', $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}	

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal();			
		}		

		// cek valid data jurnal				
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal();
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}

		// finalize PO
		if($vok){							
			$vresult = $this->m_purchase_order->purchase_order_finalize($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}			
		}		

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['trpo_no'] = $this->input->post('trpo_no');      	 		  	 		
		}	

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);		
	}

	public function purchase_order_cancel_finalize($trpo_no){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_order');

		$vok = true;
		$msg = '';

		// set data
		if($vok){
			$this->data['trpo_cekint'] = $this->input->post('trpo_cekint');
			$this->data['header']['trpo_no'] = $this->input->post('trpo_no');
			$this->data['jurnal_h']['trju_no'] = $this->input->post('trju_no');
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('CANCEL_FINALIZE_PO', $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}	

		// cancel finalize PO
		if($vok){							
			$vresult = $this->m_purchase_order->purchase_order_cancel_finalize($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}			
		}		

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['trpo_no'] = $this->input->post('trpo_no');      	 		  	 		
		}	

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);		
	}

	private function set_data_jurnal($data){
		$trpo_no = $this->input->post('trpo_no');
		$dp = $this->m_po_payment->get_total_acc_dp($trpo_no);	

		if(($dp['total_debet'] > $dp['total_kredit']) || ($dp['total_kredit'] > $dp['total_debet'])){			
			//Header jurnal		
			$trpo_fin = $this->input->post('trpo_fin');
			$msus_no = $this->session->userdata('user_aktif')['msus_no'];
			$trju_catatan = $this->input->post('trpo_tag').' '.$trpo_no.'/'.substr($this->input->post('trpo_mssp_no'), 0, 6). ' - '. substr($this->input->post('trpo_mssp_no'), 9);
			$trju_tgl = date('Y-m-d H:i:s');
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);			
			$tahun = substr($trju_tgl, 2, 2);
			$separator = ($trpo_fin == 'F') ? '-' : '_';		
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);							
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_refno'] = $trpo_no.'SK';
			$data['jurnal_h']['trju_msus_no'] = $msus_no;
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_void'] = 0;			
			$data['jurnal_h']['trju_reftipe'] = 'SK';
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $trpo_fin == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $trpo_fin;		
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));
			$data['jurnal_h']['trju_lsupd'] = $trju_tgl;
			$data['jurnal_h']['trju_lsusr'] = $msus_no;			

			// Set account														
	 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv			
				$data['jurnal_d'] = array();
				$array = array();			
				$mssp = substr($this->input->post('trpo_mssp_no'), 0, 1);												

				// set akun selisih kurs dan akun uang muka
				if($dp['total_debet'] > $dp['total_kredit']){
					$saldo = $dp['total_debet'] - $dp['total_kredit'];
					$acc_d = $this->m_setting_account->get_setting_account_byid('SLHK');
					$acc_k = $this->m_setting_account->get_setting_account_byid('PPDP');
				}elseif ($dp['total_kredit'] > $dp['total_debet']) {
					$saldo = $dp['total_kredit'] - $dp['total_debet'];
					$acc_d = $this->m_setting_account->get_setting_account_byid('PPDP');
					$acc_k = $this->m_setting_account->get_setting_account_byid('SLHK');
				}

				$array['dtju_msap_no'] = $acc_d['mssa_msap_no'];
				$array['dtju_debet'] = $saldo;
				$array['dtju_kredit'] = 0;
				array_push($data['jurnal_d'], $array);
				
			 	$array['dtju_msap_no'] = $acc_k['mssa_msap_no'];
		 		$array['dtju_debet'] = 0;
		 		$array['dtju_kredit'] = $saldo;
		 		array_push($data['jurnal_d'], $array);	

				$this->data['jurnal_d'] = $data['jurnal_d'];						 	
				$this->data['jurnal_h'] = $data['jurnal_h'];
			//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv			
		}
	}	

	private function config_validation(){
		$config = array(		     
		        array(
		                'field' => 'trpo_mssp_no',
		                'label' => 'Supplier',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )
		);
		return $config;
	}

	private function cek_valid_data_jurnal(){
		$msg = '';
		$hsl = true;

		// cek setting account harus diisi
		if($hsl){
			if(!$this->m_setting_account->get_setting_account_byid('PPDP') ||
				!$this->m_setting_account->get_setting_account_byid('SLHK')){
				$hsl = false;				
				$msg = 'There is an account that has not been set';
			}				
		}		

		return array('valid'=>$hsl, 'msg'=>$msg);
	}

	private function cek_valid_data_trans($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | VOID

			$msg = '';
			$hsl = true;				

			if($hsl && ($menu == 'NEW' || $menu == 'EDIT')){
				// cek produk required
				if(!isset($data['detail'])){
					$hsl = false;					
					$msg = 'Please select product';					
				}
			
				// cek total TOP persen harus <= 100			
				// if(ftodouble($this->input->post('top_persen_total')) > 100){
				// 	$hsl = false;					
				// 	$msg = 'Total TOP percent must be <= 100';					
				// }							
			}

			// cek tidak boleh di cancel kalo status copy-nya (X)
			if($hsl && $menu == 'CANCEL_LOCKPO'){
				if($data['trpo_stcopy'] == 'X'){
					$hsl = false;					
					$msg = 'Transaction cannot be cancelled. Please change status exclude (X) first.';
				}	
			}

			// cek harga bftax tidak melebihi batas +- 30% dari harga pada PO sebelumnya
			if($hsl && ($menu == 'NEW' || $menu == 'EDIT')){
				$msg .= 'The price of the following products are over the limit price. To continue the process, please input approval:';
				if(isset($data['detail'])){
					foreach ($data['detail'] as $key => $value) {
						$dtpo_bftax = fhapus_kutip(ftodouble($data['detail'][$key]['dtpo_bftax']));
						$dtpo_last_price = fhapus_kutip(ftodouble($data['detail'][$key]['dtpo_last_price']));
						$price_limit_max = ($dtpo_last_price+($dtpo_last_price*0.3));
						$price_limit_min = ($dtpo_last_price-($dtpo_last_price*0.3));
						
						if(($dtpo_last_price != '') && ($dtpo_bftax > $price_limit_max || $dtpo_bftax < $price_limit_min) && $data['detail'][$key]['dtpo_msus_no'] == ""){
							$hsl = false;
							$msg .= ' <br/> - Product ID: '.$data['detail'][$key]['dtpo_mspd_no']." => PO NO : ".$data['detail'][$key]['dtpo_last_po']." Harga DPP ".$data['detail'][$key]['dtpo_last_curr']." ".$data['detail'][$key]['dtpo_last_price'];
							$error_apv = true;
						}

						unset($this->data['detail'][$key]['dtpo_msus_no']);
						unset($this->data['detail'][$key]['dtpo_last_po']);
						unset($this->data['detail'][$key]['dtpo_last_curr']);
						unset($this->data['detail'][$key]['dtpo_last_price']);
					}	
				}		
			}

			// cek jika sisa DP > 0 maka tidak bisa di lock/di finalize
			if($menu == 'LOCKPO' || $menu == 'FINALIZE_PO'){
				if($hsl &&  $data['trpo_sisadp'] > 0){
					$hsl = false;
					if($menu == 'LOCKPO'){
						$msg = 'Cannot Lock PO. (DP > 0)';
					}

					if($menu == 'FINALIZE_PO'){
						$msg = 'Cannot Finalize PO. (DP > 0)';
					}
				}

				if($hsl && $menu == 'FINALIZE_PO' && $data['trpo_terbayar'] < $data['trpo_total']){
					$hsl = false;			
					$msg = 'Cannot Finalize PO. (PO Unsettled)';					
				}

				if($menu == 'FINALIZE_PO'){					
					$this->m_po_payment->set_po_payment_cekint_bypo($data['header']['trpo_no']);
				}
			}			

			// utk pengecekan cekint detail Approval PR 
			// Valid = CekInt tidak berubah
			if($hsl && ($menu == 'NEW' || $menu == 'EDIT' || $menu == 'VOID')){
				if(isset($data['detail'])){
					foreach ($data['detail'] as $key => $value) {											
						if($this->m_apv_pr->get_apv_pr_cekint($data['detail'][$key]['dtpo_dappr_no'],
														$data['detail'][$key]['dtpo_dappr_seq'],
														$data['detail'][$key]['dappr_cekint']) == false){
							$hsl = false;
							$msg = 'Data have been changed by another user. Please Refresh the page';
							break;									
						}					
						unset($this->data['detail'][$key]['dappr_cekint']);									
					}
				}					
			}	

			if ($hsl && ($menu == 'EDIT' || $menu == 'VOID' || $menu == 'LOCKPO' || $menu == 'CANCEL_LOCKPO' || $menu == 'EDIT_TOP_PO' || $menu == 'FINALIZE_PO' || $menu == 'CANCEL_FINALIZE_PO')) {
				if($this->m_purchase_order->get_purchase_order_cekint($data['header']['trpo_no'], $data['trpo_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';					
				}else{
					$this->m_purchase_order->set_purchase_order_cekint($data['header']['trpo_no']);
				}
			}

			if ($hsl && ($menu == 'EDIT' || $menu == 'VOID')) {	
				$data['po_detail_lm'] = $this->session->userdata('po_detail_lm');
				if(isset($data['po_detail_lm'])){
					foreach ($data['po_detail_lm'] as $key => $value) {						
						if($this->m_apv_pr->get_apv_pr_cekint($data['po_detail_lm'][$key]['dappr_no'],
																$data['po_detail_lm'][$key]['dappr_seq'],
																$data['po_detail_lm'][$key]['dappr_cekint']) == false){
							$hsl = false;
							$msg = 'Data have been changed by another user. Please Refresh the page';
							break;		
						}							
					}
					unset($_SESSION['po_detail_lm']);																		
				}

				// Update cekint
				if($hsl && ($menu == 'NEW' || $menu == 'EDIT' || $menu == 'VOID')){
					if(isset($data['detail'])){
						foreach ($data['detail'] as $key => $value) {												
								$this->m_apv_pr->set_apv_pr_cekint($data['detail'][$key]['dtpo_dappr_no'],
																$data['detail'][$key]['dtpo_dappr_seq']);
						}						
					}	
				}

				if ($hsl && ($menu == 'EDIT' || $menu == 'VOID')) {
					$this->m_apv_pr->setall_apv_pr_cekint($data['trpo_no']);
				}
				
			}
			return array('valid'=>$hsl, 'msg'=>$msg, 'error_apv'=> $error_apv);
	}
}	