<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class produk extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_produk');		
		$this->load->model('purchase/m_purchase_order');		
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index(){
		if(!fcek_hak_akses('.AC0.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		$data['tipe_trans'] = '';
		$data['mspd_paket'] = '';
		$data['mskt_statusinv'] = '';
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/produk/v_produk_list', $data);
		$this->load->view('v_footer');			
	}

	public function produk_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'produk');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['produk_list'] = $this->m_produk->get_produk_list($arr_filter, false, $per_page, $offset, $fn, $sort);
		$data['request_from'] = $this->input->post('request_from');

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['produk_list']);
		}
		else {
			$pagination['total_list'] = $this->m_produk->get_produk_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['produk_list'] = $this->load->view('data_master/produk/v_produk_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function produk_new(){			
		if(!fcek_hak_akses('.AC1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/produk/v_produk_form',$data);
		$this->load->view('v_footer');		
	}

	public function produk_view($mspd_no){
		if(!fcek_hak_akses('.AC0.')) {
			redirect('forbidden');
		}

		if (is_null($mspd_no) || count($this->m_produk->get_produk($mspd_no)) <= 0) {
			redirect('produk');
			return;
		}	
		$data = array();		
		$data = $this->m_produk->get_produk($mspd_no);		
		$data['dtpo'] = $this->m_purchase_order->get_dtpo_bymspdno($mspd_no);		
		$data['action'] = 'view';				
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);	
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/produk/v_produk_form',$data);
		$this->load->view('v_footer');		
	}

	public function produk_gambar(){
		$data = array();					
		$mspd_no = $this->input->get('mspd_no');				
		$path = './images/produk/'.$mspd_no.'.jpg';		        
			
		if(!file_exists($path)){   					
			die('Gambar tidak tersedia');
		}

		$data = $this->m_produk->get_produk_gambar_info($mspd_no);						
		$this->load->view('data_master/produk/v_produk_gambar',$data);
	}

	public function produk_simpan_gambar(){		
		$vok = true;

		/*
		CARA ALTERNATIF UNTUK CEK FILE MENGGUNAKAN URL
		-----------------------------------------------
		$path = base_url('images/produk/').'/'.$data['ms']['mspd_no'].'.jpg';		
  		$headers=get_headers($path);
		$image_axists = stripos($headers[0],"200 OK")?true:false;   		   				
		-----------------------------------------------
		*/	

		if($vok){
			$mspd_no = $this->input->post('mspd_no');		

			if(isset($_FILES["mspd_gambar"]["name"])){
				$config['upload_path']		= './images/produk';
		        $config['allowed_types']	= 'jpg';		            
		        $config['file_name']		= $mspd_no;
		        $this->load->library('upload', $config);		        

		        $path = './images/produk/';
		        $path_jpg = $path.$mspd_no.'.jpg';
		        $path_temp = $path.$mspd_no.'_temp.jpg';
			
				if(file_exists($path_jpg)){   					
					// copy($path_jpg, $path_temp);					
					rename($path_jpg, $path_temp);					
				}
				
				if(!$this->upload->do_upload('mspd_gambar')){	
					if(file_exists($path_temp)){   						            
						rename($path_temp, $path_jpg);
					}
		            $vok = false;				
					$msg = array('error'=>$this->upload->display_errors(). 'File type must be JPEG image (.jpg)');	
		        }else{
		        	if(file_exists($path_temp)){   					
			        	unlink($path_temp);
			        }
		        }			    
		    }else{
		    	$vok = false;				
				$msg = array('error'=>'Please select picture.');	
		    }
		}

	    // Berhasil upload image
		if($vok){
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['mspd_no'] = $mspd_no;
		}
				
		// Gagal upload image
		if(!$vok){
			$result['response'] = 'gagal';  	 		
  	 		$result['error_message'] = $msg;			  	 		
		}	

		echo json_encode($result);		    
	}

	public function produk_hapus_gambar(){		
		$mspd_no = $this->input->post('mspd_no');		
		$path = './images/produk/'.$mspd_no.'.jpg';		
		
		if(file_exists($path)){
			unlink($path);			
  	 		$result['mspd_no'] = $mspd_no;
		}else{
			$result['response'] = 'gagal';  	 		
  	 		$result['error_message'] = array('error' => 'Picture not available.');			  	 		
		}

		echo json_encode($result);		    
	}

	public function produk_simpan(){
		// Gagal simpan data									
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'produk');		
		$this->form_validation->set_rules($this->config_validation());
		$vok = true;		
		
		// set data
		if($vok){
			$data = array();				
			$data['action'] = $this->input->post('action');
			if($data['action'] == 'NEW'){
				$data['ms']['mspd_no'] = $this->m_produk->produk_kode_auto($this->input->post('msmd_no'));
				$data['ms']['mspd_reqserialno'] = $this->input->post('mspd_reqserialno');
				$data['ms']['mspd_fin'] = ($this->input->post('mspd_fin') == 'F') ? 'F' : 'C';
			}

			if($data['action'] == 'EDIT'){
				$data['ms']['mspd_no'] = $this->input->post('msmd_no'). $this->input->post('mspd_no');
			}

			if($data['action'] == 'NEW'){
				$data['ms']['mspd_hpp'] = ftodouble($this->input->post('mspd_hpp'));
			}

			$data['ms']['mspd_paket'] = $this->input->post('mspd_paket');			
			$data['ms']['mspd_nm'] = fhapus_kutip($this->input->post('mspd_nm'));
			$data['ms']['mspd_msmr_no'] = $this->input->post('mspd_msmr_no');

			$data['ms']['mspd_mssp_no'] = ($this->input->post('mspd_mssp_no') == '') ? '' : $this->input->post('mspd_mssp_no');

			$data['ms']['mspd_pricelist'] = ftodouble($this->input->post('mspd_pricelist'));
			$data['ms']['mspd_rop'] = ftodouble($this->input->post('mspd_rop'));
			$data['ms']['mspd_satuan'] = $this->input->post('mspd_satuan');
			$data['ms']['mspd_dimensi'] =ftodouble( $this->input->post('mspd_dimensi'));
			$data['ms']['mspd_berat'] = ftodouble($this->input->post('mspd_berat'));
			$data['ms']['mspd_curr'] = $this->input->post('mspd_curr');			
			$data['ms']['mspd_garansisp'] = $this->input->post('mspd_garansisp');
			$data['ms']['mspd_garansijasa'] = $this->input->post('mspd_garansijasa');
			$data['ms']['mspd_tag'] = $this->input->post('mspd_tag');			
			$data['ms']['mspd_listmscb'] = (($this->input->post('mspd_listmscb') != '') ? ".". implode('.', $this->input->post('mspd_listmscb')). "." : '');
			$data['ms']['mspd_catatan'] = fhapus_kutip($this->input->post('mspd_catatan'));
			$data['ms']['mspd_aktif'] = fhapus_kutip($this->input->post('mspd_aktif'));
			$data['ms']['mspd_lsupd'] = date('Y-m-d H:i:s');
			$data['ms']['mspd_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];											

			if($data['ms']['mspd_paket'] == 'Y'){
				$mdpp = $this->input->post('mdpp');									
				foreach ($mdpp as $key => $value1) {
					foreach ($mdpp[$key] as $idx => $value2) {					
						if ($mdpp['mdpp_mspd_no'][$idx] != '') {
							$data['md'][$idx]['mdpp_no'] = $data['ms']['mspd_no'];
							if($key == 'mdpp_qty'){
								$data['md'][$idx][$key] = ftodouble($value2);							
							}else{							
								$data['md'][$idx][$key] = $value2;
							}
						}
					}				
				}
			}
		}		

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();
			}
		}

		// cek valid data master
		if($vok){
			$hasil_cek = $this->cek_valid_data_master($data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);				
			}
		}

		// Simpan data
		if($vok){
			$vresult = $this->m_produk->produk_simpan($data);
			if($vresult == 0){
				$vok = false;				
				$msg = array('error' => 'Error Query');
			}
		}
		
		// Berhasil simpan data
		if($vok){
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['mspd_no'] = $data['ms']['mspd_no'];
		}
				
		// Gagal simpan data							
		if(!$vok){
			$result['response'] = 'gagal';  	 		
  	 		$result['error_message'] = $msg;			  	 		
		}	

		echo json_encode($result);		        		
	}		

	public function get_produk(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'produk');

		echo json_encode($this->m_produk->get_all_produk());			
	}	

	public function produk_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'produk');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';
		$data['tipe_trans'] = $this->input->post('tipe_trans');
		$data['mspd_paket'] = $this->input->post('mspd_paket');
		$data['mspd_paket_readonly'] = $this->input->post('mspd_paket_readonly');
		$data['mskt_statusinv'] = $this->input->post('mskt_statusinv');
		
		$respon = array();
		$respon['popup'] = $this->load->view('data_master/produk/v_produk_popup',$data,true);	
		echo json_encode($respon);		
	}

	public function produk_autocomplete(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'produk');				

		$data['input_name'] = $this->input->post('input_name');
		$data['keyword'] = $this->input->post('query');
		$data['mskt_statusinv'] = $this->input->post('mskt_statusinv');
		$data['mspd_reqserialno'] = $this->input->post('mspd_reqserialno');
		$data['mskt_showinspk'] = $this->input->post('mskt_showinspk');
		$data['mspd_paket'] = $this->input->post('mspd_paket');
		$data['mspd_fin'] = $this->input->post('mspd_fin');
		
		$data_produk = $this->m_produk->get_produk_autocomplete($data);		

		foreach ($data_produk as $key => $value) {
			$data_produk[$key]['value'] = $value[$data['input_name']];			
		}
		$data_produk['suggestions'] = $data_produk;
		echo json_encode($data_produk);
	}

	public function produk_fortrash_autocomplete(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'produk');

		$keyword = $this->input->post('query');
		if (strpos($keyword, ':') !== FALSE) {
			$keyword = substr($keyword, 0, 9);
		}		
		$data_produk = $this->m_produk->get_produk_fortrash_autocomplete($keyword);
		foreach ($data_produk as $key => $value) {
			$data_produk[$key]['value'] = $value['mspd_nm'];
		}
		$data_produk['suggestions'] = $data_produk;
		echo json_encode($data_produk);
	}

	// public function produkstok_autocomplete(){
	// 	$key = $this->input->post('key');
	// 	$hash_key = $this->input->post('hash_key');

	// 	if (!$key){
	// 		redirect('produk');
 //  	 		return;
	// 	}

	// 	if ($hash_key != fenkripsi($key)){
	// 		redirect('produk');
 //  	 		return;
	// 	}
	// 	$data = array();
	// 	$data['keyword'] = $this->input->post('query');
	// 	$data['input_name'] = $this->input->post('input_name');		
	// 	$data['msgd_no'] = $this->input->post('msgd_no');				
	// 	$data_produk = $this->m_produk->get_produkstok_autocomplete($data);
	// 	foreach ($data_produk as $key => $value) {
	// 		$data_produk[$key]['value'] = $value[$data['input_name']];			
	// 	}
	// 	$data_produk['suggestions'] = $data_produk;
	// 	echo json_encode($data_produk);
	// }

	public function produkstok(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'produk');

		$data = array();
		$data = $this->input->post('arr_mspd_no');			
		$msgd_no = $this->input->post('msgd_no');	
		$data_produk = $this->m_produk->get_produkstok($data, $msgd_no);
		
		echo json_encode($data_produk);
	}

	public function produk_avaliablestock(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'produk');

		$data = array();
		$data = $this->input->post('arr_mspd_no');					
		$data_produk = $this->m_produk->get_produk_avaliablestock($data);
		
		echo json_encode($data_produk);
	}

	public function produk_wip_po(){
			$key = $this->input->post('key');
			$hash_key = $this->input->post('hash_key');
			fcek_direct_access($key, $hash_key, 'produk');

			$data = array();
			$data = $this->input->post('arr_mspd_no_wip_po');					
			$data_produk_wip_po = $this->m_produk->get_produk_wip_po($data);
			
			echo json_encode($data_produk_wip_po);
	}

	public function produk_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'produk');

		$data['mspd_no'] = $this->input->post('mspd_no');
		$data['mspd_aktif'] = $this->input->post('mspd_aktif');

		if($this->m_produk->produk_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['mspd_no'] = $data['mspd_no'];			
  	 		echo json_encode($result);
		}
	}

	public function produk_paket(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'produk');		
		$data = $this->m_produk->get_produk($this->input->post('mdpp_no'));
		$data['produk']['mdpp_no'] = $data['produk']['mspd_no'];
		$data['produk']['mdpp_mspd_no'] = $data['produk']['mspd_no'];
		$data['produk']['mdpp_qty'] = 1;
		$data['paket_item'] = $data['paket'];		
		array_unshift($data['paket_item'], $data['produk']);

		echo json_encode($data['paket_item']);		
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'msmd_no',
		                'label' => 'Model ID',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),
		        array(
		                'field' => 'mspd_nm',
		                'label' => 'Product Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mspd_msmr_no',
		                'label' => 'Brand',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),
		        array(
		                'field' => 'mspd_pricelist',
		                'label' => 'Price List',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mspd_satuan',
		                'label' => 'Unit Scale',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mspd_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )

		);
		return $config;
	}

	private function cek_valid_data_master($data){
		$msg = '';
		$hsl = true;

		if($data['action'] == 'NEW'){
			if($hsl && ($data['ms']['mspd_hpp'] == 0 || $data['ms']['mspd_hpp'] == '') && $data['ms']['mspd_paket'] == 'N'){
				$hsl = false;
				$msg = 'Please input HPP';
			}

			if($hsl && $data['ms']['mspd_hpp'] != 0 && $data['ms']['mspd_paket'] == 'Y'){
				$hsl = false;
				$msg = 'For product package, HPP should be 0';
			}
		}

		// cek ga boleh simpan [off] status
		if($hsl && $data['action'] == 'EDIT'){
			$data_status['msmd_no'] = $this->input->post('msmd_no');
			$data_status['mspd_msmr_no'] = $this->input->post('mspd_msmr_no');
			$data_status['mspd_mssp_no'] = $this->input->post('mspd_mssp_no');
			$data_status['mspd_listmscb'] = (($this->input->post('mspd_listmscb') != '') ? ".". implode('.', $this->input->post('mspd_listmscb')). "." : '');						
			if(fcek_status($data_status)){
				$hsl = false;
				$msg = 'Can not save [OFF] status';
			}				
		}

		if($hsl && $this->input->post('mspd_paket') == 'Y'){
			if(!isset($data['md'])){
				$hsl = false;
				$msg = 'Please select product';
			}
		}
		
		return array('valid'=>$hsl, 'msg'=>$msg);
	}	

}