<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class perhitungan_bulanan extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('finance_and_acc/m_perhitungan_bulanan');
		$this->load->model('setting/m_setting_account');
		$this->load->model('setting/m_setting');	
		$this->load->model('data_master/m_cabang');						
	}

	public function index(){		
		if(!fcek_hak_akses('.EE0.')){
			redirect('forbidden');
		}
		$data = array();
		$data['key'] = uniqid();
		$data['action'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		$months = array('Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Augustus', 'September', 'Oktober', 'November', 'Desember');

		$lst_cls = $this->m_setting->get_setting('simr_char2','tcj', 1);		
		if((int)$lst_cls > 0){
			$thn = substr($lst_cls, 0,4);
			$bln = (int)substr($lst_cls, 4,2);
			$idx_bln = $bln - 1;						
			$data['lst_cls'] = $months[$idx_bln]. ' '. $thn;	

			if(($bln + 1) == 13){
				$idx_bln = 0;	
				$thn = $thn + 1;		
			}else{
				$idx_bln = $bln;
			}

			$data['next_lst_cls'] = $months[$idx_bln]. ' '. $thn;			
		}else{
			$data['lst_cls'] = '';
			$data['next_lst_cls'] = '';
		}

		$lst_prt = $this->m_setting->get_setting('simr_char1','tcj', 1);
		if((int)$lst_prt > 0){
			$thn = substr($lst_prt, 0,4);
			$bln = (int)substr($lst_prt, 4,2);
			$idx_bln = $bln - 1;
			$data['lst_prt'] = $months[$idx_bln]. ' '. $thn;

			if(($bln + 1) == 13){
				$idx_bln = 0;			
				$thn = $thn + 1;
			}else{
				$idx_bln = $bln;
			}

			$data['next_lst_prt'] = $months[$idx_bln]. ' '. $thn;
		}else{
			$data['lst_prt'] = '';
			$data['next_lst_prt'] = '';
		}

		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/perhitungan_bulanan/v_perhitungan_bulanan', $data);
		$this->load->view('v_footer');
	}

	public function proses_perhitungan_bulanan(){	
		// OPSI:
		// 1. PERHITUNGAN_BULANAN
		// 2. PROTEKSI_SEMENTARA
		// 3. RESET_TGL_PROTEKSI_SEMENTARA
		// 4. CLOSING_PERIODE_BULANAN
		$opsi = $this->input->post('opsi');
		$vok = true;
		$periode = '';
		$msg = '';		

		// set periode
		if($vok){
			if($opsi == 1){
				// ambil dari view
				$periode_bln = $this->input->post('periode_bln');
				$periode_thn = $this->input->post('periode_thn');
				$periode = (string)$periode_thn.$periode_bln;		
			}else if($opsi == 2){
				// ambil dari database (last proteksi sementera + 1)
				$lst_prt = $this->m_setting->get_setting('simr_char1','tcj', 1);			
				$thn = substr($lst_prt, 0,4);
				$bln = substr($lst_prt, 4,2);				
				$dt = strtotime($thn.'-'.$bln);
				$lst_prt = date("Y-m", strtotime("+1 month", $dt));
				$lst_prt = str_replace('-', '', $lst_prt);		
				$periode = $lst_prt;
			}
		}

		// cek valid data				
		if($vok) {			
			$hsl = $this->cek_valid_data($periode, $opsi);
			if($hsl['err'] == 1){
				$vok = false;				
				$msg = array('error'=>$hsl['err_msg']);
			}			
		}

		if($vok){			
			// *jika opsi = 'PERHITUNGAN_BULANAN' maka yang diproses hanya perhitungan bulanan saja
			// *jika opsi = 'PROTEKSI_SEMENTARA' maka yang diproses adalah:
			//  	1. perhitungan bulanan
			//  	2. update tgl proteksi sementara (last date proteksi sementara + 1)
			// *jika opsi = 'RESET_TGL_PROTEKSI_SEMENTARA' maka yang diproses reset tgl terakhir proteksi sementara = tgl last closing
			// *jika opsi = 'CLOSING_PERIODE_BULANAN' update tgl closing periode bulanan (last closing + 1)
			if($opsi == 1 || $opsi == 2){
				// proses perhitungan bulanan
				$hsl = $this->m_perhitungan_bulanan->proses_perhitungan_bulanan($periode);
				if($hsl['err'] == 1){
					$vok = false;
					$msg = array('error'=>$hsl['err_msg']);
				}else{
					if($opsi == 2){
						// update tgl terakhir proteksi sementara
						$this->m_perhitungan_bulanan->update_temp_periode_proteksi($periode);
					}
				}
			}else if($opsi == 3){
				// reset tgl terakhir proteksi sementara = tgl last closing
				$hsl = $this->m_perhitungan_bulanan->reset_temp_periode_proteksi();
				if($hsl['err'] == 1){
					$vok = false;
					$msg = array('error'=>$hsl['err_msg']);
				}
			}else if($opsi == 4){
				// closing periode bulanan
				$hsl = $this->m_perhitungan_bulanan->close_periode_berikutnya();
				if($hsl['err'] == 1){
					$vok = false;
					$msg = array('error'=>$hsl['err_msg']);
				}
			}
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');

			if($opsi == 1){
				$this->session->set_userdata('sukses_msg','Perhitungan bulanan selesai.');
			}else if($opsi == 2){
				$this->session->set_userdata('sukses_msg','Proteksi sementara dan perhitungan bulanan selesai.');
			}else if($opsi == 3){
				$this->session->set_userdata('sukses_msg','Reset proteksi sementara berhasil.');
			}else if($opsi == 4){
				$this->session->set_userdata('sukses_msg','Berhasil di closing.');
			}

			$result['response'] = 'sukses';  	 		   	 		  	 	
		}	

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);
	}

	private function cek_valid_data($periode, $opsi){				
		$err_msg = '';
		$err = 0;
		$vok = true;
		$lst_prt = $this->m_setting->get_setting('simr_char1','tcj', 1);
		$lst_cls = $this->m_setting->get_setting('simr_char2','tcj', 1);
		$thn = substr($lst_cls, 0,4);
		$bln = substr($lst_cls, 4,2);		
		$dt = strtotime($thn.'-'.$bln);
		$lst_cls = date("Y-m", strtotime("+1 month", $dt));
		$lst_cls = str_replace('-', '', $lst_cls);

		if($vok){
			if($periode == '' && $opsi == 1){
				$vok = false;
				$err = 1;
				$err_msg = 'Silakan pilih periode';	
			}
		}

		if($vok){
			if($periode <= $lst_prt && $opsi == 1){
				$vok = false;
				$err = 1;
				$err_msg = 'Periode perhitungan bulanan harus lebih besar dari periode terproteksi sementara';	
			}
		}

		if($vok){
			if($lst_cls > $lst_prt && $opsi == 4){
				$vok = false;
				$err = 1;
				$err_msg = 'Periode closing berikutnya tidak boleh melebihi periode proteksi sementara bulanan';	
			}
		}

		if($vok){
			// cek setting account harus diisi		
			if(!$this->m_setting_account->get_setting_account_byid('LBRG')||
				!$this->m_setting_account->get_setting_account_byid('LBTB')){
					$vok = false;
					$err = 1;
					$err_msg = 'There is an account that has not been set';	
			}		
		}

		return array('err'=>$err, 'err_msg'=>$err_msg);		
	}
	
}