<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class model extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_model');				
	}

	public function index(){			
		if(!fcek_hak_akses('.AF0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/model/v_model_list', $data);
		$this->load->view('v_footer');			
	}

	public function model_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'model');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['model_list'] = $this->m_model->get_model_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['model_list']);
		}
		else {
			$pagination['total_list'] = $this->m_model->get_model_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['model_list'] = $this->load->view('data_master/model/v_model_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function model_new(){	
		if(!fcek_hak_akses('.AF1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/model/v_model_form',$data);
		$this->load->view('v_footer');		
	}

	public function model_view($msmd_no){	
		if(!fcek_hak_akses('.AF0.')) {
			redirect('forbidden');
		}

		if (is_null($msmd_no) || count($this->m_model->get_model($msmd_no)) <= 0) {
			redirect('model');
			return;
		}
		$data = array();
		$data['action'] = 'view';		
		$data['model'] = $this->m_model->get_model($msmd_no);
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);				
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/model/v_model_form',$data);
		$this->load->view('v_footer');		
	}
	
	public function model_new_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'model');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$msmd_no = $this->input->post('msfm_no'). "-". $this->input->post('msmd_no');		
			if($this->m_model->get_modelno($msmd_no) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('msmd_no' => 'Model ID: '.$msmd_no.' is already registered. Please input Model ID.');
				echo json_encode($result);	
			}else{	
				$data = array();										
				$data['msmd_no'] = $msmd_no;
				$data['msmd_nm'] = fhapus_kutip($this->input->post('msmd_nm'));							
				$data['msmd_listmscb'] = (($this->input->post('msmd_listmscb') != '') ? ".". implode('.', $this->input->post('msmd_listmscb')). "." : '');
				$data['msmd_catatan'] = fhapus_kutip($this->input->post('msmd_catatan'));
				$data['msmd_aktif'] = 1; //(($this->input->post('msmd_aktif') == 'on') ? 1 : 0);			
				$data['msmd_lsupd'] = date('Y-m-d H:i:s');
				$data['msmd_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_model->model_new_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');
					$result['response'] = 'sukses';				
		  	 		$result['msmd_no'] = $data['msmd_no'];	      	 		
		  	 		echo json_encode($result);
				}			
			}	
		}				        
	}

	public function model_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'model');
						
		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$data_status['msmd_listmscb'] = (($this->input->post('msmd_listmscb') != '') ? ".". implode('.', $this->input->post('msmd_listmscb')). "." : '');			
			$data_status['msfm_no'] = $this->input->post('msfm_no');
			if(fcek_status($data_status)){
				$result['response'] = 'gagal';
				$result['error_message'] = array('fail'=>'Can not save [OFF] status');
				echo json_encode($result);		     	
			}else{
				$data = array();						     		
				$data['msmd_no'] = $data_status['msfm_no']. '-'. $this->input->post('msmd_no');
				$data['msmd_nm'] = fhapus_kutip($this->input->post('msmd_nm'));			
				$data['msmd_listmscb'] = $data_status['msmd_listmscb'];
				$data['msmd_catatan'] = fhapus_kutip($this->input->post('msmd_catatan'));
				// $data['msmd_aktif'] = (($this->input->post('msmd_aktif') == 'on') ? 1 : 0);			
				$data['msmd_lsupd'] = date('Y-m-d H:i:s');
				$data['msmd_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_model->model_edit_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');			
					$result['response'] = 'sukses';				
		  	 		$result['msmd_no'] = $data['msmd_no'];			
		  	 		echo json_encode($result);
				}				
			}	
		}				        
	}

	public function get_model(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'model');

		echo json_encode($this->m_model->get_all_model());				
	}

	public function model_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'model');
		
		$data['msmd_no'] = $this->input->post('msmd_no');
		$data['msmd_aktif'] = $this->input->post('msmd_aktif');

		if($this->m_model->model_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['msmd_no'] = $data['msmd_no'];			
  	 		echo json_encode($result);
		}
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'msfm_no',
		                'label' => 'Family ID',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'msmd_no',
		                'label' => 'Model ID',
		                'rules' => 'required|min_length[2]',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),		        
		        array(
		                'field' => 'msmd_nm',
		                'label' => 'Model Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'msmd_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )

		);
		return $config;
	}

}