<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class jurnal extends MY_Controller {
	private $data = array();

	function __construct(){
		parent::__construct();
		$this->load->model('finance_and_acc/m_jurnal');
		$this->load->model('setting/m_setting');	
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index($trju_tipe = null, $tipe_trans = null){	

		if($trju_tipe == 'M' || $trju_tipe == 'm'){
			$trju_tipe = 'M';
		}elseif($trju_tipe == 'A' || $trju_tipe == 'a'){
			$trju_tipe = 'A';
		}else{
			redirect('forbidden/page_notfound');	
		}

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			if(!fcek_hak_akses('.HB7.')){
				redirect('forbidden');
			}

			$tipe_trans = 'F';
		} else {
			if(!fcek_hak_akses('.HB8.')){
				redirect('forbidden');
			}

			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('forbidden/page_notfound');
			}
		}
		// if($tipe_trans != null){			
		// 	if($this->session->userdata('svlogin') == 'C' && $tipe_trans != 'F' && $tipe_trans != 'C' ||
		// 		$this->session->userdata('svlogin') == 'F' && $tipe_trans != null && $tipe_trans != 'F'){
		// 		redirect('jurnal');
		// 	}
		// }

		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? '' : 'C';
		$data['trju_tipe']	= $trju_tipe;
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/jurnal/v_jurnal_list', $data);
		$this->load->view('v_footer');			
	}

	public function jurnal_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'jurnal');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['jurnal_list'] = $this->m_jurnal->get_jurnal_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['jurnal_list']);
		}
		else {
			$pagination['total_list'] = $this->m_jurnal->get_jurnal_list($arr_filter, true);		
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['jurnal_list'] = $this->load->view('finance_and_acc/jurnal/v_jurnal_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function jurnal_new($tipe_trans = null){
		if(!fcek_hak_akses('.EB1.')) {
			redirect('forbidden');
		}

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			$tipe_trans = 'F';
		} else {
			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('forbidden/page_notfound');
			}
		}

		// if($tipe_trans != null){			
		// 	if($this->session->userdata('svlogin') == 'C' && $tipe_trans != 'F' && $tipe_trans != 'C' ||
		// 		$this->session->userdata('svlogin') == 'F' && $tipe_trans != null && $tipe_trans != 'F'){
		// 		redirect('jurnal');
		// 	}
		// }

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? '' : 'C';
		$data['trju_tipe']	= 'M';
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/jurnal/v_jurnal_form',$data);
		$this->load->view('v_footer');		
	}

	public function jurnal_view($trju_no = null, $trju_tipe = null){	
		if(!fcek_hak_akses('.EB0.')) {
			redirect('forbidden');
		}

		if($trju_tipe == 'M' || $trju_tipe == 'm'){
			$trju_tipe = 'M';
		}elseif($trju_tipe == 'A' || $trju_tipe == 'a'){
			$trju_tipe = 'A';
		}else{
			redirect('forbidden/page_notfound');
		}

		if (is_null($trju_no) || !$this->m_jurnal->get_jurnal($trju_no)) {
			redirect('forbidden/page_notfound');
			return;
		}

		$data = array();				
		$data = $this->m_jurnal->get_jurnal($trju_no);
			
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		$data['trju_tipe']	= $trju_tipe;
		$data['tipe_trans']	= $data['jurnal_h']['trju_fin'];
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/jurnal/v_jurnal_form',$data);
		$this->load->view('v_footer');		
	}

	public function jurnal_print(){
		$this->load->library('java_bridge');
		$trju_no = $this->input->get('trju_no');
		$paper_size = $this->input->get('paper_size');

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];
		

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		if($paper_size == 'A5'){
			$path = APPPATH.'prints\finance_and_acc\jurnal\p_jurnal_A5.jrxml';
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\finance_and_acc\jurnal\p_jurnal_A4.jrxml';
		}		
		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_TRJU_NO",new Java('java.lang.String', $trju_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}

	public function jurnal_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');	
		fcek_direct_access($key, $hash_key, 'jurnal');
		$vok = true;
		
		// set data
		if($vok){
				$this->data['action'] = $this->input->post('action');
				$this->data['trju_cekint'] = $this->input->post('trju_cekint');
				
				if($this->data['action'] == 'NEW'){
					$trju_tgl = $this->input->post('trju_tgl');
					$trju_tipe = $this->input->post('trju_tipe');
					$bulan = substr($trju_tgl, 5, 2);			
					$tahun = substr($trju_tgl, 2, 2);			
					$separator = ($this->input->post('trju_fin') == 'F') ? '-' : '_';
					$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
					$this->data['header']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
					$this->data['header']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
					$this->data['header']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];					
					$this->data['header']['trju_tgl'] = $trju_tgl;
					$this->data['header']['trju_tipe'] = $trju_tipe;
					$this->data['header']['trju_void'] = 0;
					$this->data['header']['trju_fin'] = $this->input->post('trju_fin');
					$this->data['header']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trju_fin') == 'C') ? 'A' : 'R';
				}

				if($this->data['action'] != 'NEW'){
					$this->data['header']['trju_no'] = $this->input->post('trju_no');								
				}

				if($this->data['action'] == 'STCOPY'){				
					$this->data['header']['trju_stcopy'] = ($this->input->post('trju_stcopy') == 'R') ? 'X' : 'R';
				}

				$this->data['header']['trju_lsupd'] = date('Y-m-d H:i:s');
				$this->data['header']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];			
				$this->data['header']['trju_catatan'] = fhapus_kutip($this->input->post('trju_catatan'));				
				$this->data['header']['trju_tag'] = fhapus_kutip($this->input->post('trju_tag'));

				$dtju = $this->input->post('dtju');

				if(isset($dtju)){					
					foreach ($dtju['dtju_msap_no'] as $key => $value) {

						if($dtju['dtju_msap_no'][$key] != ''){
							$this->data['detail'][$key]['dtju_no'] = $this->data['header']['trju_no'];
							$this->data['detail'][$key]['dtju_seq'] = $dtju['dtju_seq'][$key];
							$this->data['detail'][$key]['dtju_msap_no'] = $dtju['dtju_msap_no'][$key];
							$this->data['detail'][$key]['dtju_debet'] = ftodouble($dtju['dtju_debet'][$key]);
							$this->data['detail'][$key]['dtju_kredit'] = ftodouble($dtju['dtju_kredit'][$key]);
							$this->data['detail'][$key]['dtju_catatan'] = $dtju['dtju_catatan'][$key];
							$this->data['detail'][$key]['dtju_cek'] = '';

							if(isset($dtju['dtju_mscc_no'][$key])){
								$this->data['detail'][$key]['dtju_mscc_no'] = $dtju['dtju_mscc_no'][$key]; 
							}else{
								$this->data['detail'][$key]['dtju_mscc_no'] = ''; 
							}
						}
						

						// for ($i=0; $i < count($dtju[$key]); $i++) {
						// 	if($dtju['dtju_msap_no'][$i] != ''){
						// 		$this->data['detail'][$i]['dtju_no'] = $this->data['header']['trju_no'];
						// 		if($key == 'dtju_debet' || $key == 'dtju_kredit'){
						// 			$this->data['detail'][$i][$key] = ftodouble($value[$i]);			
						// 		}else{
						// 			$this->data['detail'][$i][$key] = $value[$i];
						// 		}		
						// 	}
						// }
					}
				}				
		}					

		// cek valid data
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}								

		// simpan data
		if ($vok) {		
			$vresult = $this->m_jurnal->jurnal_simpan($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}		
		}			

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['trju_no'] = $this->data['header']['trju_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);
	}

	public function jurnal_rekon_all_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');	
		fcek_direct_access($key, $hash_key, 'jurnal');
		$vok = true;
		
		// set data
		if($vok){		
			$dtju = $this->input->post('dtju');			
			if(isset($dtju)){
				foreach ($dtju as $key => $value1) {
					foreach ($dtju[$key] as $idx => $value2) {
						if($key == 'dtju_no'){
							// set data dtju_no
							$data['detail'][$idx][$key] = $value2;
						
							// set data dtju_cek
							if(isset($dtju['dtju_cek'][$idx])){
								$data['detail'][$idx]['dtju_cek'] = 'Y';								
							}else{								
								$data['detail'][$idx]['dtju_cek'] = '';							
							}

							// set data dtju_cek lama
							if(isset($dtju['dtju_cek_lm'][$idx])){
								$data['detail'][$idx]['dtju_cek_lm'] = 'Y';								
							}else{
								$data['detail'][$idx]['dtju_cek_lm'] = '';
							}
						}else if($key == 'dtju_seq'){
							// set data dtju_seq
							$data['detail'][$idx][$key] = $value2;

						}

					}						
				}
			}
		}					

		// cek valid data master
		// if ($vok) {
		// 	$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
		// 	if($hasil_cek['valid'] == false){
		// 		$vok = false;				
		// 		$msg = array('error'=>$hasil_cek['msg']);
		// 	}
		// }								

		// simpan data
		if ($vok) {		
			$vresult = $this->m_jurnal->jurnal_rekon_simpan($data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}		
		}			

		// berhasil simpan data
		if ($vok) {			
			$result['response'] = 'sukses';  	 		
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';			
		}	

		echo json_encode($result);
	}

	public function jurnal_rekon_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');	
		fcek_direct_access($key, $hash_key, 'jurnal');
		$vok = true;									

		// set data
		if($vok){
			$data['dtju_no'] = $this->input->post('dtju_no');
			$data['dtju_seq'] = $this->input->post('dtju_seq');
			$data['dtju_cek'] = $this->input->post('dtju_cek');
		}

		// simpan data
		if ($vok) {		
			$vresult = $this->m_jurnal->jurnal_rekon_simpan($data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}		
		}			

		// berhasil simpan data
		if ($vok) {			
			$result['response'] = 'sukses';  	 		
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';			
		}	

		echo json_encode($result);
	}

	public function get_jurnal_rekon(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'jurnal');
		$data['trju_refno'] = $this->input->post('trju_refno');
		$data['trju_catatan'] = $this->input->post('trju_catatan');
		$data['listmscb'] = $this->input->post('listmscb');
		$data['trju_tgl_dari'] = $this->input->post('trju_tgl_dari');
		$data['trju_tgl_sampai'] = $this->input->post('trju_tgl_sampai');
		$data['status_cek'] = $this->input->post('status_cek');
		$data['tipe_jurnal'] = $this->input->post('tipe_jurnal');
		$data['dtju_msap_no'] = substr($this->input->post('msap_no'), 0, 11);	
		echo json_encode($this->m_jurnal->get_jurnal_rekon($data));
	}	

	private function cek_valid_data_trans($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | VOID

			$msg = '';
			$hsl = true;
			$tgl_cls_jurnal = $this->m_setting->get_setting('simr_char1','tcj', 1);

			if($hsl && ($menu == 'NEW' || $menu == 'EDIT' || $menu == 'VOID')){
				// transaksi tidak bisa di buat/edit/void jika tgl transaksi/jurnal sudah di closing
				$tgl_trans = $this->input->post('trju_tgl');
				$tahun = substr($tgl_trans, 0, 4);
				$bulan = substr($tgl_trans, 5, 2);	
				$tgl_trans = (int)$tahun.$bulan;

				if($hsl && $tgl_trans <= $tgl_cls_jurnal){
					$hsl = false;
					$msg = 'Can not create new/edit/void transaction if journal transaction date is closed. Please choose another date.';
				}
			}

			// Transaksi yang sudah di rekonsiliasi tidak bisa di edit/void/cancel
			if($hsl && ($menu == 'EDIT' || $menu == 'VOID')){
				if($this->m_jurnal->is_recon_exists($data['header']['trju_no'])){
					$hsl = false;
					$msg = 'Transactions cannot be changed. Journal already in reconciliation';
				}
			}			

			// cek total debet dan total kredit harus sama
			if($hsl){
				if($this->input->post('trju_debettotal') != $this->input->post('trju_kredittotal')){
					$hsl = false;					
					$msg = 'Total debet must be equal total kredit';					
				}	
			}

			// cek account harus dipilih
			if($hsl){
				if(!isset($data['detail'])){
					$hsl = false;					
					$msg = 'Please select account';					
				}	
			}

			// utk pengecekan cekint Jurnal 
			// Valid = CekInt tidak berubah			
			if ($hsl && $menu != 'NEW') {
				if($this->m_jurnal->get_jurnal_cekint($data['header']['trju_no'], $data['trju_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_jurnal->set_jurnal_cekint($data['header']['trju_no']);
				}
			}
			
			return array('valid'=>$hsl, 'msg'=>$msg);
	}
	
}