<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class incoming_delivery extends MY_Controller {
	private $data = array();	

	function __construct(){
		parent::__construct();
		$this->load->model('purchase/m_incoming_delivery');
		$this->load->model('stok_kontrol/m_stok');
		$this->load->model('purchase/m_purchase_order');
		$this->load->model('setting/m_currency_rates');
		$this->load->model('finance_and_acc/m_po_payment');	
		$this->load->model('finance_and_acc/m_jurnal');	
		$this->load->model('setting/m_setting_account');
		$this->load->model('data_master/m_kategori');
		$this->load->model('data_master/m_acc_perkiraan');
		$this->load->model('setting/m_setting');
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index(){			
		if(!fcek_hak_akses('.BD0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/incoming_delivery/v_incoming_delivery_list', $data);
		$this->load->view('v_footer');			
	}	

	public function incoming_delivery_print(){
		$this->load->library('java_bridge');
		$trid_no = $this->input->get('trid_no');
		$paper_size = $this->input->get('paper_size');
		$jenis_print = $this->input->get('jenis_print');
		
		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];
		

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}
		

		if($jenis_print == 'PERHITUNGAN_HPP'){
			if (fcek_hak_akses('.BDN.')) {
				if ($paper_size == 'A4') {
					$path = APPPATH.'prints\purchase\incoming_delivery\p_incoming_delivery_perhitunganHPP.jrxml';					
				}
			}else{
				echo 'AKSES TIDAK DI IJINKAN';
			}
		}else if($jenis_print == 'id_payment'){
			if(fcek_hak_akses('.BDO.')){
				if($paper_size == 'A5'){
					$path = APPPATH.'prints\purchase\incoming_delivery\p_incoming_delivery_payment_A5.jrxml';
				}elseif($paper_size == 'A4') {
					$path = APPPATH.'prints\purchase\incoming_delivery\p_incoming_delivery_payment_A4.jrxml';
				}
			}else{
				echo 'AKSES TIDAK DI IJINKAN';
			}
		}else{
			if(fcek_hak_akses('.BD9.')){
				if($paper_size == 'A5'){
						// $path = APPPATH.'prints\purchase\incoming_delivery\p_incoming_delivery_purcver_A5.jrxml';
					}elseif($paper_size == 'A4') {
						$path = APPPATH.'prints\purchase\incoming_delivery\p_incoming_delivery_purcver_A4.jrxml';
					}
				}else{
					if($paper_size == 'A5'){
						$path = APPPATH.'prints\purchase\incoming_delivery\p_incoming_delivery_A5.jrxml';
					}elseif($paper_size == 'A4') {
						$path = APPPATH.'prints\purchase\incoming_delivery\p_incoming_delivery_A4.jrxml';
					}
				}
			}				

		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_DTID_NO",new Java('java.lang.String', $trid_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}

	public function incoming_delivery_print_hpp_excel(){
		$this->load->library('Excel');
		$trid_no = $this->input->get('trid_no');
		$paper_size = $this->input->get('paper_size');
		$jenis_print = $this->input->get('jenis_print');

		$query = 'select dtid_no, dtid_qtyterima, trid_tgl, dtpo_nett, trid_total,
					trid_totalbiayakirim, trid_totaldimensi, trid_totalppnshipping, trid_totalpph22,
					trid_kurs, dtpo_qty, trpo_curr, msus_nm, mspd_nm, mssp_nm, msgd_nm,
					mskt_no, dtid_mspd_no, mssp_no, dtid_biayakirim, dtid_bea, 
					(dtpo_nett*dtpo_qty) as totalunit,
					((dtpo_nett*dtpo_qty)*trid_kurs) as totalRp, trid_pl_no, dtid_dimensi, dtid_hpp,
					if(trid_tglterima="0000:00:00","",trid_tglterima) as trid_tglterima,
					(dtid_bea+dtid_biayakirim) as totalcost,
					if(trid_pl_tgl="0000:00:00","",trid_pl_tgl) as trid_pl_tgl, trid_bl_no,
					if(trid_bl_tgl="0000:00:00","",trid_bl_tgl) as trid_bl_tgl,
					(SELECT sum(dtid_bea) from dt_in_dlv where dtid_no="'.$trid_no.'") as bea, mskt_nm
				FROM dt_in_dlv
				LEFT JOIN tr_in_dlv ON trid_no = dtid_no
				LEFT JOIN tr_po on trpo_no = SUBSTRING(dtid_no,1,12)
				LEFT JOIN dt_po on dtpo_no = SUBSTRING(dtid_no,1,12)
					and dtpo_seq = dtid_seq
				LEFT JOIN ms_user on msus_no = trid_msus_no
				LEFT JOIN ms_gudang ON msgd_no = trid_msgd_no
				LEFT JOIN ms_supplier ON mssp_no = trid_mssp_no
				LEFT JOIN ms_produk ON mspd_no = dtpo_mspd_no
				LEFT JOIN ms_kategori on mskt_no = substring(dtid_mspd_no,1,1)
				where dtid_no = "'.$trid_no.'"
				order by mskt_no, dtid_seq';
				// die($query);

		$data = $this->db->query($query);
		$data = $data->result_array();	

		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);
		$styleArray = array(
	   					'font'  => array(
	    	   			'bold' => true,
	       				'size'  => 14,
	        			'name' => 'Verdana'
	    			));

		$column = 0;
		$row = 0;
		
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "PERHITUNGAN HPP")
		->getStyle()->applyFromArray($styleArray);
		$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "ID : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $trid_no);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Tgl Transaksi : ".$data[0]['trid_tgl']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, "User Pembuat : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $data[0]['msus_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, "Currency : ".$data[0]['trpo_curr']);
		$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Supplier : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $data[0]['mssp_no']." - ".$data[0]['mssp_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "No PL : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $data[0]['trid_pl_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, "Shipping Fee : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $data[0]['trid_totalbiayakirim']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, "Kurs : ".$data[0]['trid_kurs']);
		$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Total Dimensi : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $data[0]['trid_totaldimensi']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Tgl PL : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $data[0]['trid_pl_tgl']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, "PPN Shipping : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $data[0]['trid_totalppnshipping']);
		$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Gudang : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $data[0]['msgd_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "No BL : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $data[0]['trid_bl_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, "Bea Masuk : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $data[0]['bea']);
		$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Tgl trid_tglterima : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $data[0]['trid_tglterima']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Tgl BL : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $data[0]['trid_bl_tgl']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, "PPH Pasal 22 : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $data[0]['trid_totalpph22']);
		$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, "TOTAL COST : ");
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, "=SUM(I3:I6)");			
		
		$row+=2;
		$table_colums = array('PRODUCT ID', 'PRODUCT NAME', 'QTY PO', 'QTY RCV', 'HARGA/UNIT (RP/USD)', 'TOTAL (RP/USD)',
							 'TOTAL RP', 'DIMENSI', 'BEA MASUK', 'BIAYA KIRIM',	'TOTAL COST', 'HPP / UNIT');
		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}
		// $datax = reset($data);
		
		$row += 1;
		foreach ($data as $key => $value) {	
		
				$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['dtid_mspd_no']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['mspd_nm']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['dtpo_qty']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['dtid_qtyterima']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['dtpo_nett']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['totalunit']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['totalRp']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['dtid_dimensi']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['dtid_bea']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $value['dtid_biayakirim']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $value['totalcost']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $value['dtid_hpp']);
				$row += 1;
			}
	      
	        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .xls Excel 2007 format
	    $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
		$filename='PERHITUNGAN HPP.xls'; //save our workbook as this file name
	    header('Content-Type: application/vnd.ms-excel'); //mime type
	    header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	    header('Cache-Control: max-age=0'); //no cache 
	    //force user to download the Excel file without writing it to server's HD
	    $objWriter->save('php://output');
	}
	
	public function incoming_delivery_list(){		
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['incoming_delivery_list'] = $this->m_incoming_delivery->get_incoming_delivery_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['incoming_delivery_list']);
		}
		else {
			$pagination['total_list'] = $this->m_incoming_delivery->get_incoming_delivery_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['incoming_delivery_list'] = $this->load->view('purchase/incoming_delivery/v_incoming_delivery_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function incoming_delivery_new($trpo_no = null){	
		if(!fcek_hak_akses('.BD1.')) {
			redirect('forbidden');
		}

		$data = array();
		if(is_null($trpo_no)){			
			$data['action'] = 'new';			
		}else{
			$data = $this->m_purchase_order->get_purchase_order($trpo_no);
			if(count($data) <= 0) {
				redirect('purchase_order');
				return;
			}else{				
				$data['action'] = 'new_import';
			}				
		}

		$data['kurs'] = $this->m_currency_rates->get_currency_rates();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/incoming_delivery/v_incoming_delivery_form',$data);		
		$this->load->view('v_footer');
	}

	public function incoming_delivery_view($trid_no){							
		if(!fcek_hak_akses('.BD0.')) {
			redirect('forbidden');
		}

		$data = array();				
		$data = $this->m_incoming_delivery->get_incoming_delivery($trid_no);				

		if (is_null($trid_no) || count($data) <= 0) {
			redirect('incoming_delivery');
			return;
		}
		
		// $data['resume_po_payment'] = $this->m_po_payment->get_resume_po_payment($trid_no);
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();							

		$trju_no = $this->m_jurnal->get_jurnalid($trid_no.'ID');
		if($trju_no != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);
			$data['jurnal_h_id'] = $data_jurnal['jurnal_h'];
			$data['jurnal_d_id'] = $data_jurnal['jurnal_d'];				
		}

		$trju_no = $this->m_jurnal->get_jurnalid($trid_no.'BK');
		if($trju_no != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);
			$data['jurnal_h_bk'] = $data_jurnal['jurnal_h'];
			$data['jurnal_d_bk'] = $data_jurnal['jurnal_d'];				
		}

		$trju_no = $this->m_jurnal->get_jurnalid($trid_no.'PS');		
		if($trju_no != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);			
			$data['jurnal_h_ps'] = $data_jurnal['jurnal_h'];
			$data['jurnal_d_ps'] = $data_jurnal['jurnal_d'];			
		}

		$trju_no = $this->m_jurnal->get_jurnalid($trid_no.'BB');
		if($trju_no != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);
			$data['jurnal_h_bb'] = $data_jurnal['jurnal_h'];
			$data['jurnal_d_bb'] = $data_jurnal['jurnal_d'];				
		}

		$trju_no = $this->m_jurnal->get_jurnalid($trid_no.'PH');		
		if($trju_no != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);			
			$data['jurnal_h_ph'] = $data_jurnal['jurnal_h'];
			$data['jurnal_d_ph'] = $data_jurnal['jurnal_d'];			
		}

		$trju_no = $this->m_jurnal->get_jurnalid($trid_no.'PI');		
		if($trju_no != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);			
			$data['jurnal_h_pi'] = $data_jurnal['jurnal_h'];
			$data['jurnal_d_pi'] = $data_jurnal['jurnal_d'];			
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/incoming_delivery/v_incoming_delivery_form',$data);
		$this->load->view('v_footer');		
	}

	public function incoming_delivery_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');		
		$this->form_validation->set_rules($this->config_validation());
		$vok = true;

		// set data transaksi
		if($vok){
			$this->data['action'] = $this->input->post('action');			
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');		
			$this->data['trpo_cekint'] = $this->input->post('trpo_cekint');		
			$this->data['trid_mssp_no'] = substr($this->input->post('trid_mssp_no'), 0, 1);			

			if($this->data['action'] == 'NEW'){
				$trpo_no = $this->input->post('trpo_no');								
				$this->data['header']['trid_no'] = $this->m_incoming_delivery->incoming_delivery_kode_auto($trpo_no);
				$this->data['header']['trid_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['header']['trid_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$this->data['header']['trid_mssp_no'] = substr($this->input->post('trid_mssp_no'), 0, 6);
				$this->data['header']['trid_tgl'] = $this->input->post('trid_tgl');			
				$this->data['header']['trid_void'] = 0;												
			}

			if($this->data['action'] != 'NEW'){
				$this->data['header']['trid_no'] = $this->input->post('trid_no');
			}
			
			$this->data['header']['trid_msgd_no'] = $this->input->post('trid_msgd_no');								
			$this->data['header']['trid_pl_no'] = fhapus_kutip($this->input->post('trid_pl_no'));
			$this->data['header']['trid_pl_tgl'] = $this->input->post('trid_pl_tgl');
			$this->data['header']['trid_pl_kontrak'] = fhapus_kutip($this->input->post('trid_pl_kontrak'));
			$this->data['header']['trid_pl_catatan'] = fhapus_kutip($this->input->post('trid_pl_catatan'));
			$this->data['header']['trid_bl_no'] = fhapus_kutip($this->input->post('trid_bl_no'));
			$this->data['header']['trid_bl_tgl'] = $this->input->post('trid_bl_tgl');
			$this->data['header']['trid_bl_tglestterima'] = $this->input->post('trid_bl_tglestterima');
			$this->data['header']['trid_bl_catatan'] = fhapus_kutip($this->input->post('trid_bl_catatan'));
			$this->data['header']['trid_totalbiayakirim'] = fhapus_kutip(ftodouble($this->input->post('trid_totalbiayakirim')));
			$this->data['header']['trid_totalppnshipping'] = fhapus_kutip(ftodouble($this->input->post('trid_totalppnshipping')));
			$this->data['header']['trid_totalpph22'] = fhapus_kutip(ftodouble($this->input->post('trid_totalpph22')));
			$this->data['header']['trid_totalppnimport'] = fhapus_kutip(ftodouble($this->input->post('trid_totalppnimport')));
			$this->data['header']['trid_totaldimensi'] = fhapus_kutip(ftodouble($this->input->post('trid_totaldimensi')));				
			$this->data['header']['trid_kurs'] = fhapus_kutip(ftodouble($this->input->post('trid_kurs')));
			// $this->data['header']['trid_total'] = ftodouble($this->input->post('trid_total'));
			$this->data['header']['trid_catatan'] = fhapus_kutip($this->input->post('trid_catatan'));
			$this->data['header']['trid_tag'] = fhapus_kutip($this->input->post('trid_tag'));				
			$this->data['header']['trid_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['trid_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];			
			
			if($this->data['action'] == 'CONF_RECEIVING_GOODS'){
				$this->data['header']['trid_tglterima'] = $this->input->post('trid_tglterima');
				$this->data['header']['trid_usrterima'] = $this->session->userdata('user_aktif')['msus_no'];
			}

			if($this->data['action'] == 'CANCEL_RECEIVING_GOODS'){
				$this->data['header']['trid_tglterima'] = '';
				$this->data['header']['trid_usrterima'] = '';
				$this->data['trpo_stcopy'] = $this->input->post('trpo_stcopy');
			}

			if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['userlog']['msul_tgl'] = date('Y-m-d H:i:s');
				$this->data['userlog']['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['userlog']['msul_catatan'] = substr(trim('['.$this->data['action']. '] IN.DLV '. $this->data['header']['trid_no']. ' SUPP'. substr($this->input->post('trid_mssp_no'), 9). ' '. fhapus_kutip($this->input->post('trid_tag')). ' '. fhapus_kutip($this->input->post('trid_catatan'))), 0, 250);
			}

			$dtid = $this->input->post('dtid');
						
			foreach ($dtid as $key => $value) {
				for ($i=0; $i < count($dtid[$key]); $i++) {																																
					$this->data['detail'][$i]['dtid_no'] = $this->data['header']['trid_no'];														 	
			 		if($key == 'dtid_seq' || $key == 'dtid_mspd_no'){
				 		$this->data['detail'][$i][$key] = $value[$i];	
				 	}else{
				 		$this->data['detail'][$i][$key] = ftodouble($value[$i]);					 		
				 	}				 	
				 } 								
			}		

		}		

		// cek form validation
		if($vok){
			if(fcek_hak_akses('.BD9.') || $this->data['action'] == 'NEW'){
				if($this->form_validation->run() == FALSE){
					$vok = false;					
					$msg = $this->form_validation->error_array();					
				}
			}
		}				

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}		

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal($this->data);			
		}

		// cek valid data jurnal				
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal($this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}	
			
		// simpan data				
		if($vok){
			$vresult = $this->m_incoming_delivery->incoming_delivery_simpan($this->data);			
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}			
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['trid_no'] = $this->data['header']['trid_no'];	
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);				        
	}

	public function ppn_shipping_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');
		$vok = true;	
		
		// set data
		if($vok){			
			$this->data['action'] = 'EDIT_PPN_SHIPPING';			
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');
			$this->data['header']['trid_no'] = $this->input->post('trid_no');
			$this->data['header']['trid_totalppnshipping'] = fhapus_kutip(ftodouble($this->input->post('trid_totalppnshipping')));
		}

		// cek valid data transaksi
		if ($vok){
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}						

		// simpan data
		if($vok){
			$vresult = $this->m_incoming_delivery->ppn_shipping_simpan($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['trid_no'] =$this->data['header']['trid_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);
	}

	public function pph22_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');
		$vok = true;	
		
		// set data
		if($vok){			
			$this->data['action'] = 'EDIT_PPH22';			
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');
			$this->data['header']['trid_no'] = $this->input->post('trid_no');
			$this->data['header']['trid_totalpph22'] = fhapus_kutip(ftodouble($this->input->post('trid_totalpph22')));
		}

		// cek valid data transaksi
		if ($vok){
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}						

		// simpan data
		if($vok){
			$vresult = $this->m_incoming_delivery->pph22_simpan($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['trid_no'] =$this->data['header']['trid_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);
	}

	public function ppnimport_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');
		$vok = true;	
		
		// set data
		if($vok){			
			$this->data['action'] = 'EDIT_PPN_IMPORT';			
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');
			$this->data['header']['trid_no'] = $this->input->post('trid_no');
			$this->data['header']['trid_totalppnimport'] = fhapus_kutip(ftodouble($this->input->post('trid_totalppnimport')));
		}

		// cek valid data transaksi
		if ($vok){
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}						

		// simpan data
		if($vok){
			$vresult = $this->m_incoming_delivery->ppnimport_simpan($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['trid_no'] =$this->data['header']['trid_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);
	}
	
	public function incoming_delivery_biayakirim_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');
		$vok = true;	
		
		// set data
		if($vok){			
			$this->data['action'] = 'BIAYA_KIRIM';
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');
			$this->data['trid_totalbiayakirim'] = ftodouble($this->input->post('trid_totalbiayakirim'));
			$this->data['header']['trid_no'] = $this->input->post('trid_no');
			$this->data['header']['pbidbk_trid_no'] = $this->input->post('pbidbk_trid_no');
			$this->data['header']['pbidbk_tgl'] = $this->input->post('pbidbk_tgl');
			$this->data['header']['pbidbk_adj'] = fhapus_kutip(ftodouble($this->input->post('pbidbk_adj')));
			$this->data['header']['pbidbk_msjb_no'] = $this->input->post('pbidbk_msjb_no');
			$this->data['header']['pbidbk_jlhbayar'] = fhapus_kutip(ftodouble($this->input->post('pbidbk_jlhbayar')));
			$this->data['header']['pbidbk_catatan'] = fhapus_kutip($this->input->post('pbidbk_catatan'));
			$this->data['header']['pbidbk_tglbayar'] = $this->input->post('pbidbk_tglbayar');
			$this->data['header']['pbidbk_tag'] = fhapus_kutip($this->input->post('pbidbk_tag'));
			$this->data['header']['pbidbk_msus_no'] = substr($this->input->post('pbidbk_msus_no'), 0, 4);
			$this->data['header']['pbidbk_mscb_no'] = substr($this->input->post('pbidbk_mscb_no'), 0, 1);			
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}				

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal_biayakirim($this->data);			
		}

		// cek valid data jurnal				
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal($this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}

		// simpan data
		if($vok){
			$vresult = $this->m_incoming_delivery->incoming_delivery_biayakirim_simpan($this->data);			
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['pbidbk_trid_no'] = $this->data['header']['pbidbk_trid_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);
	}

	public function incoming_delivery_ppnshipping_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');
		$vok = true;	
		
		// set data
		if($vok){			
			$this->data['action'] = 'PPN_SHIPPING';
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');
			$this->data['trid_totalppnshipping'] = ftodouble($this->input->post('trid_totalppnshipping'));
			$this->data['header']['trid_no'] = $this->input->post('trid_no');
			$this->data['header']['pbidps_trid_no'] = $this->input->post('pbidps_trid_no');
			$this->data['header']['pbidps_tgl'] = $this->input->post('pbidps_tgl');
			$this->data['header']['pbidps_adj'] = fhapus_kutip(ftodouble($this->input->post('pbidps_adj')));
			$this->data['header']['pbidps_msjb_no'] = $this->input->post('pbidps_msjb_no');
			$this->data['header']['pbidps_jlhbayar'] = fhapus_kutip(ftodouble($this->input->post('pbidps_jlhbayar')));
			$this->data['header']['pbidps_catatan'] = fhapus_kutip($this->input->post('pbidps_catatan'));
			$this->data['header']['pbidps_tglbayar'] = $this->input->post('pbidps_tglbayar');
			$this->data['header']['pbidps_tag'] = fhapus_kutip($this->input->post('pbidps_tag'));
			$this->data['header']['pbidps_msus_no'] = substr($this->input->post('pbidps_msus_no'), 0, 4);
			$this->data['header']['pbidps_mscb_no'] = substr($this->input->post('pbidps_mscb_no'), 0, 1);			
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}				

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal_ppnshipping($this->data);			
		}

		// cek valid data jurnal				
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal($this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}

		// simpan data
		if($vok){
			$vresult = $this->m_incoming_delivery->incoming_delivery_ppnshipping_simpan($this->data);			
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['pbidps_trid_no'] = $this->data['header']['pbidps_trid_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);
	}

	public function incoming_delivery_pph22_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');
		$vok = true;	
		
		// set data
		if($vok){			
			$this->data['action'] = 'PPH_22';
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');
			$this->data['trid_totalpph22'] = ftodouble($this->input->post('trid_totalpph22'));
			$this->data['header']['trid_no'] = $this->input->post('trid_no');
			$this->data['header']['pbidph_trid_no'] = $this->input->post('pbidph_trid_no');
			$this->data['header']['pbidph_tgl'] = $this->input->post('pbidph_tgl');
			$this->data['header']['pbidph_adj'] = fhapus_kutip(ftodouble($this->input->post('pbidph_adj')));
			$this->data['header']['pbidph_msjb_no'] = $this->input->post('pbidph_msjb_no');
			$this->data['header']['pbidph_jlhbayar'] = fhapus_kutip(ftodouble($this->input->post('pbidph_jlhbayar')));
			$this->data['header']['pbidph_catatan'] = fhapus_kutip($this->input->post('pbidph_catatan'));
			$this->data['header']['pbidph_tglbayar'] = $this->input->post('pbidph_tglbayar');
			$this->data['header']['pbidph_tag'] = fhapus_kutip($this->input->post('pbidph_tag'));
			$this->data['header']['pbidph_msus_no'] = substr($this->input->post('pbidph_msus_no'), 0, 4);
			$this->data['header']['pbidph_mscb_no'] = substr($this->input->post('pbidph_mscb_no'), 0, 1);			
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}				

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal_pph22($this->data);			
		}

		// cek valid data jurnal				
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal($this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}

		// simpan data
		if($vok){
			$vresult = $this->m_incoming_delivery->incoming_delivery_pph22_simpan($this->data);			
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['pbidph_trid_no'] = $this->data['header']['pbidph_trid_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);
	}

	public function incoming_delivery_ppnimport_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');
		$vok = true;	
		
		// set data
		if($vok){			
			$this->data['action'] = 'PPN_IMPORT';
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');
			$this->data['trid_totalppnimport'] = ftodouble($this->input->post('trid_totalppnimport'));
			$this->data['header']['trid_no'] = $this->input->post('trid_no');
			$this->data['header']['pbidpi_trid_no'] = $this->input->post('pbidpi_trid_no');
			$this->data['header']['pbidpi_tgl'] = $this->input->post('pbidpi_tgl');
			$this->data['header']['pbidpi_adj'] = fhapus_kutip(ftodouble($this->input->post('pbidpi_adj')));
			$this->data['header']['pbidpi_msjb_no'] = $this->input->post('pbidpi_msjb_no');
			$this->data['header']['pbidpi_jlhbayar'] = fhapus_kutip(ftodouble($this->input->post('pbidpi_jlhbayar')));
			$this->data['header']['pbidpi_catatan'] = fhapus_kutip($this->input->post('pbidpi_catatan'));
			$this->data['header']['pbidpi_tglbayar'] = $this->input->post('pbidpi_tglbayar');
			$this->data['header']['pbidpi_tag'] = fhapus_kutip($this->input->post('pbidpi_tag'));
			$this->data['header']['pbidpi_msus_no'] = substr($this->input->post('pbidpi_msus_no'), 0, 4);
			$this->data['header']['pbidpi_mscb_no'] = substr($this->input->post('pbidpi_mscb_no'), 0, 1);			
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}				

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal_ppnimport($this->data);			
		}

		// cek valid data jurnal				
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal($this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}

		// simpan data
		if($vok){
			$vresult = $this->m_incoming_delivery->incoming_delivery_ppnimport_simpan($this->data);			
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['pbidpi_trid_no'] = $this->data['header']['pbidpi_trid_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);
	}

	public function get_incoming_delivery_biayakirim(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');

		echo json_encode($this->m_incoming_delivery->get_incoming_delivery_biayakirim($this->input->post('pbidbk_trid_no')));
	}

	public function get_incoming_delivery_ppnshipping(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');

		echo json_encode($this->m_incoming_delivery->get_incoming_delivery_ppnshipping($this->input->post('pbidps_trid_no')));
	}

	public function get_incoming_delivery_pph22(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');

		echo json_encode($this->m_incoming_delivery->get_incoming_delivery_pph22($this->input->post('pbidph_trid_no')));
	}

	public function get_incoming_delivery_ppnimport(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');

		echo json_encode($this->m_incoming_delivery->get_incoming_delivery_ppnimport($this->input->post('pbidpi_trid_no')));
	}

	public function incoming_delivery_cancelbiayakirim(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');
		$vok = true;

		// set data
		if($vok){
			$this->data['action'] = 'CANCEL_BIAYA_KIRIM';
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');
			$this->data['header']['trid_no'] = $this->input->post('pbidbk_trid_no');			
			$this->data['header']['pbidbk_trid_no'] = $this->input->post('pbidbk_trid_no');			
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}	

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal_biayakirim($this->data);			
		}			

		// cancel biayakirim
		if($vok){
			$vresult = $this->m_incoming_delivery->incoming_delivery_cancelbiayakirim($this->data);	
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}							        
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['pbidbk_trid_no'] = $this->data['header']['pbidbk_trid_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);	
	}

	public function incoming_delivery_cancelppnshipping(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');
		$vok = true;

		// set data
		if($vok){
			$this->data['action'] = 'CANCEL_PPN_SHIPPING';
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');
			$this->data['header']['trid_no'] = $this->input->post('pbidps_trid_no');			
			$this->data['header']['pbidps_trid_no'] = $this->input->post('pbidps_trid_no');			
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}	

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal_ppnshipping($this->data);			
		}			

		// cancel PPN Shipping
		if($vok){
			$vresult = $this->m_incoming_delivery->incoming_delivery_cancelppnshipping($this->data);	
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}							        
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['pbidps_trid_no'] = $this->data['header']['pbidps_trid_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);	
	}

	public function incoming_delivery_bea_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');
		$vok = true;	
	
		// set data
		if($vok){			
			$this->data['action'] = 'BEA';
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');
			$this->data['header']['trid_no'] = $this->input->post('trid_no');
			$this->data['header']['pbidbm_trid_no'] = $this->input->post('pbidbm_trid_no');
			$this->data['header']['pbidbm_tgl'] = $this->input->post('pbidbm_tgl');
			$this->data['header']['pbidbm_adj'] = fhapus_kutip(ftodouble($this->input->post('pbidbm_adj')));
			$this->data['header']['pbidbm_msjb_no'] = $this->input->post('pbidbm_msjb_no');
			$this->data['header']['pbidbm_jlhbayar'] = fhapus_kutip(ftodouble($this->input->post('pbidbm_jlhbayar')));
			$this->data['header']['pbidbm_catatan'] = fhapus_kutip($this->input->post('pbidbm_catatan'));
			$this->data['header']['pbidbm_tglbayar'] = $this->input->post('pbidbm_tglbayar');
			$this->data['header']['pbidbm_tag'] = fhapus_kutip($this->input->post('pbidbm_tag'));
			$this->data['header']['pbidbm_msus_no'] = substr($this->input->post('pbidbm_msus_no'), 0, 4);
			$this->data['header']['pbidbm_mscb_no'] = substr($this->input->post('pbidbm_mscb_no'), 0, 1);
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}				

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal_bea($this->data);
		}	

		// cek valid data jurnal				
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal($this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}							

		// simpan data
		if($vok){
			$vresult = $this->m_incoming_delivery->incoming_delivery_bea_simpan($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}						        
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['pbidbm_trid_no'] = $this->data['header']['pbidbm_trid_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);	
	}

	public function incoming_delivery_cancelpph22(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');
		$vok = true;

		// set data
		if($vok){
			$this->data['action'] = 'CANCEL_PPH_22';
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');
			$this->data['header']['trid_no'] = $this->input->post('pbidph_trid_no');			
			$this->data['header']['pbidph_trid_no'] = $this->input->post('pbidph_trid_no');			
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}	

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal_pph22($this->data);			
		}			

		// cancel PPh 22
		if($vok){
			$vresult = $this->m_incoming_delivery->incoming_delivery_cancelpph22($this->data);	
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}							        
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['pbidph_trid_no'] = $this->data['header']['pbidph_trid_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);	
	}

	public function incoming_delivery_cancelppnimport(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');
		$vok = true;

		// set data
		if($vok){
			$this->data['action'] = 'CANCEL_PPN_IMPORT';
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');
			$this->data['header']['trid_no'] = $this->input->post('pbidpi_trid_no');			
			$this->data['header']['pbidpi_trid_no'] = $this->input->post('pbidpi_trid_no');			
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}	

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal_ppnimport($this->data);			
		}			

		// cancel PPh 22
		if($vok){
			$vresult = $this->m_incoming_delivery->incoming_delivery_cancelppnimport($this->data);	
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}							        
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['pbidpi_trid_no'] = $this->data['header']['pbidpi_trid_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);	
	}

	public function get_incoming_delivery_bea(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');

		echo json_encode($this->m_incoming_delivery->get_incoming_delivery_bea($this->input->post('pbidbm_trid_no')));
	}

	public function incoming_delivery_cancelbea(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'incoming_delivery');
		$vok = true;

		// set data
		if($vok){
			$this->data['action'] = 'CANCEL_BEA';
			$this->data['trid_cekint'] = $this->input->post('trid_cekint');
			$this->data['header']['trid_no'] = $this->input->post('pbidbm_trid_no');			
			$this->data['header']['pbidbm_trid_no'] = $this->input->post('pbidbm_trid_no');			
		}	

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);				
			}
		}	

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal_bea($this->data);					
		}			

		// cancel bea
		if($vok){
			$vresult = $this->m_incoming_delivery->incoming_delivery_cancelbea($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}										       
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['pbidbm_trid_no'] = $this->data['header']['pbidbm_trid_no'];
		}

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);		
	}

	public function get_incoming_delivery_bycust(){
		$mssp_no = $this->input->post('mssp_no');
		$data = $this->m_incoming_delivery->get_incoming_delivery_bycust($mssp_no);
		echo json_encode($data);
	}	
	
	private function config_validation(){
		$config = array(
				array(
		                'field' => 'trid_msgd_no',
		                'label' => 'Warehouse',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),
		        array(
		                'field' => 'trid_totalbiayakirim',
		                'label' => 'Total shipping fee',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'trid_kurs',
		                'label' => 'Kurs',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        )
		);
		return $config;
	}

	private function set_data_jurnal($data){
		if($data['action'] == 'CONF_RECEIVING_GOODS'){
			//Header jurnal
			$trju_tgl = $data['header']['trid_tglterima'];
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);			
			$tahun = substr($trju_tgl, 2, 2);
			$separator = ($this->input->post('trpo_fin') == 'F') ? '-' : '_';		
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$trju_catatan = $data['header']['trid_tag']. ' '. $data['header']['trid_no'].'/'.substr($this->input->post('trid_mssp_no'), 0, 6). ' - '. substr($this->input->post('trid_mssp_no'), 9);
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);							
			$data['jurnal_h']['trju_refno'] = $data['header']['trid_no'].'ID';
			$data['jurnal_h']['trju_reftipe'] = 'ID';
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;	
			$data['jurnal_h']['trju_void'] = 0;			
			$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
			$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trpo_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trpo_fin');										
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));

			// Set account			
			if(isset($data['detail'])){			
				$data['jurnal_d'] = array();
				$array = array();				
				foreach ($data['detail'] as $key => $value) {					
					if(ftodouble($data['detail'][$key]['dtid_qtyterima'] > 0)){	 		
						// Account Inventory dan PPN Masukan (Debet) and Hutang Dagang, Bea Masuk dan Ekspedisi (Kredit)
				 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv				 		
				 			$mskt_no = substr($data['detail'][$key]['dtid_mspd_no'], 0, 1);					 	
				 			$nett_po = round((ftodouble($data['detail'][$key]['dtid_nett']) * ftodouble($data['detail'][$key]['dtid_qtyterima'])), 4);
						 	$hpp = round((ftodouble($data['detail'][$key]['dtid_hpp']) * ftodouble($data['detail'][$key]['dtid_qtyterima'])), 4);
						 	//$bftax = (ftodouble($data['detail'][$key]['dtid_taxcurr']) > 0) ? round(($hpp / 1.1), 4) : $hpp;

						 	// --------------------------------------------------------------------------------------------
						 	// $tax = $hpp - $bftax;
						 	// $bea_masuk = ftodouble($data['detail'][$key]['dtid_bea']);
						 	// $biayakirim = ftodouble($data['detail'][$key]['dtid_biayakirim']);	
						 	// --------------------------------------------------------------------------------------------			
						 	// Rev. 2018-13-22 CL. Supaya jurnal benar-benar balance (mencegah selisih 0.01)
						 	$bea_masuk = ftodouble($data['detail'][$key]['dtid_bea']);
						 	$biayakirim = ftodouble($data['detail'][$key]['dtid_biayakirim']);	
						 	$tax = ($nett_po + $bea_masuk + $biayakirim) - $hpp;
						 	// --------------------------------------------------------------------------------------------

						 	// Account Inventory (Debet)
						 	$array['dtju_msap_no'] = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
							$array['dtju_debet'] = $hpp;
							$array['dtju_kredit'] = 0;
							array_push($data['jurnal_d'], $array);

							// Account PPN Masukan (Debet)
							$acc = $this->m_setting_account->get_setting_account_byid('PPNM');
						 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
					 		$array['dtju_debet'] = $tax;
					 		$array['dtju_kredit'] = 0;
					 		array_push($data['jurnal_d'], $array);

							// Account Hutang Dagang (Kredit)
							if($data['trid_mssp_no'] == 'I'){	
								$acc = $this->m_setting_account->get_setting_account_byid('HUTI');						
					 		}elseif ($data['trid_mssp_no'] == 'L') {
					 			$acc = $this->m_setting_account->get_setting_account_byid('HUTL');			 			
					 		}			 		

							$array['dtju_msap_no'] = $acc['mssa_msap_no'];
							$array['dtju_debet'] = 0;
							$array['dtju_kredit'] = $nett_po;
							array_push($data['jurnal_d'], $array);

							// Account Bea Masuk (Kredit)
							$acc = $this->m_setting_account->get_setting_account_byid('IDBM');										
							$array['dtju_msap_no'] = $acc['mssa_msap_no'];
							$array['dtju_debet'] = 0;
							$array['dtju_kredit'] = $bea_masuk;
							array_push($data['jurnal_d'], $array);

							// Account Ekspedisi (Kredit)
							$acc = $this->m_setting_account->get_setting_account_byid('IDBK');										
							$array['dtju_msap_no'] = $acc['mssa_msap_no'];
							$array['dtju_debet'] = 0;
							$array['dtju_kredit'] = $biayakirim;
							array_push($data['jurnal_d'], $array);
				 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^			
					}
				}			
				$this->data['jurnal_d'] = $data['jurnal_d'];
			}
			$this->data['jurnal_h'] = $data['jurnal_h'];
		}

		if($data['action'] == 'CANCEL_RECEIVING_GOODS'){
			$this->data['jurnal_h']['trju_no'] = $this->input->post('trju_no_id');
		}
	}

	private function set_data_jurnal_biayakirim($data){
		//Header jurnal
		if($data['action'] == 'BIAYA_KIRIM'){
			$trju_tgl = $data['header']['pbidbk_tgl'];
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);			
			$tahun = substr($trju_tgl, 2, 2);
			$separator = ($this->input->post('trpo_fin') == 'F') ? '-' : '_';		
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$trju_catatan = $data['header']['pbidbk_tag']. ' '. $data['header']['pbidbk_trid_no'].'/'.substr($this->input->post('trid_mssp_no'), 0, 6). ' - '. substr($this->input->post('trid_mssp_no'), 9);
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);							
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_refno'] = $data['header']['pbidbk_trid_no'].'BK';
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_void'] = 0;			
			$data['jurnal_h']['trju_reftipe'] = 'BK';
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trpo_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trpo_fin');
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));
		}

		if($data['action'] == 'CANCEL_BIAYA_KIRIM'){
			$data['jurnal_h']['trju_no'] = $this->input->post('trju_no_bk');
		}

		$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
		$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];		

		// Set account														
 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv									
			$data['jurnal_d'] = array();
			$array = array();				
			$saldo = ftodouble($data['header']['pbidbk_jlhbayar']);

			// Ekspedisi (Debet)
		 	$acc = $this->m_setting_account->get_setting_account_byid('IDBK');						
		 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	 		$array['dtju_debet'] = $data['trid_totalbiayakirim'];
	 		$array['dtju_kredit'] = 0;
	 		array_push($data['jurnal_d'], $array);

	 		// Adjustment Ekspedisi (Debet)
		 	$acc = $this->m_setting_account->get_setting_account_byid('IDAK');						
		 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	 		$array['dtju_debet'] = $data['header']['pbidbk_adj'];
	 		$array['dtju_kredit'] = 0;
	 		array_push($data['jurnal_d'], $array);							

			// Payment type (Kredit)			 						 						
		 	$array['dtju_msap_no'] = $this->m_acc_perkiraan->get_msjb_msap_no($data['header']['pbidbk_msjb_no']);
			$array['dtju_debet'] = 0;
			$array['dtju_kredit'] = $saldo;
			array_push($data['jurnal_d'], $array);

			$this->data['jurnal_d'] = $data['jurnal_d'];						
 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^				 																								
		$this->data['jurnal_h'] = $data['jurnal_h'];
	}

	private function set_data_jurnal_ppnshipping($data){
		//Header jurnal
		if($data['action'] == 'PPN_SHIPPING'){
			$trju_tgl = $data['header']['pbidps_tgl'];
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);			
			$tahun = substr($trju_tgl, 2, 2);
			$separator = ($this->input->post('trpo_fin') == 'F') ? '-' : '_';		
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$trju_catatan = $data['header']['pbidps_tag']. ' '. $data['header']['pbidps_trid_no'].'/'.substr($this->input->post('trid_mssp_no'), 0, 6). ' - '. substr($this->input->post('trid_mssp_no'), 9);
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);							
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_refno'] = $data['header']['pbidps_trid_no'].'PS';
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_void'] = 0;			
			$data['jurnal_h']['trju_reftipe'] = 'PS';
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trpo_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trpo_fin');
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));
		}

		if($data['action'] == 'CANCEL_PPN_SHIPPING'){
			$data['jurnal_h']['trju_no'] = $this->input->post('trju_no_ps');
		}

		$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
		$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];		

		// Set account														
 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv									
			$data['jurnal_d'] = array();
			$array = array();				
			$saldo = ftodouble($data['header']['pbidps_jlhbayar']);

			// PPN Shipping (Debet)
		 	$acc = $this->m_setting_account->get_setting_account_byid('IDPS');
		 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	 		$array['dtju_debet'] = $data['trid_totalppnshipping'];
	 		$array['dtju_kredit'] = 0;
	 		array_push($data['jurnal_d'], $array);

	 		// Adjustment PPN Shipping (Debet)
		 	$acc = $this->m_setting_account->get_setting_account_byid('IDAP');						
		 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	 		$array['dtju_debet'] = $data['header']['pbidps_adj'];
	 		$array['dtju_kredit'] = 0;
	 		array_push($data['jurnal_d'], $array);							

			// Payment type (Kredit)			 						 						
		 	$array['dtju_msap_no'] = $this->m_acc_perkiraan->get_msjb_msap_no($data['header']['pbidps_msjb_no']);
			$array['dtju_debet'] = 0;
			$array['dtju_kredit'] = $saldo;
			array_push($data['jurnal_d'], $array);

			$this->data['jurnal_d'] = $data['jurnal_d'];						
 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^				 																								
		$this->data['jurnal_h'] = $data['jurnal_h'];
	}

	private function set_data_jurnal_pph22($data){
		//Header jurnal
		if($data['action'] == 'PPH_22'){
			$trju_tgl = $data['header']['pbidph_tgl'];
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);			
			$tahun = substr($trju_tgl, 2, 2);
			$separator = ($this->input->post('trpo_fin') == 'F') ? '-' : '_';		
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$trju_catatan = $data['header']['pbidph_tag']. ' '. $data['header']['pbidph_trid_no'].'/'.substr($this->input->post('trid_mssp_no'), 0, 6). ' - '. substr($this->input->post('trid_mssp_no'), 9);
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_refno'] = $data['header']['pbidph_trid_no'].'PH';
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_void'] = 0;			
			$data['jurnal_h']['trju_reftipe'] = 'PH';
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trpo_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trpo_fin');
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));
		}

		if($data['action'] == 'CANCEL_PPH_22'){
			$data['jurnal_h']['trju_no'] = $this->input->post('trju_no_ph');
		}

		$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
		$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];		

		// Set account														
 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv									
			$data['jurnal_d'] = array();
			$array = array();				
			$saldo = ftodouble($data['header']['pbidph_jlhbayar']);

			// PPh 22 (Debet)
		 	$acc = $this->m_setting_account->get_setting_account_byid('IDPH');
		 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	 		$array['dtju_debet'] = $data['trid_totalpph22'];
	 		$array['dtju_kredit'] = 0;
	 		array_push($data['jurnal_d'], $array);

	 		// Adjustment PPh 22 (Debet)
		 	$acc = $this->m_setting_account->get_setting_account_byid('IDAH');						
		 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	 		$array['dtju_debet'] = $data['header']['pbidph_adj'];
	 		$array['dtju_kredit'] = 0;
	 		array_push($data['jurnal_d'], $array);							

			// Payment type (Kredit)			 						 						
		 	$array['dtju_msap_no'] = $this->m_acc_perkiraan->get_msjb_msap_no($data['header']['pbidph_msjb_no']);
			$array['dtju_debet'] = 0;
			$array['dtju_kredit'] = $saldo;
			array_push($data['jurnal_d'], $array);

			$this->data['jurnal_d'] = $data['jurnal_d'];						
 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^				 																								
		$this->data['jurnal_h'] = $data['jurnal_h'];
	}

	private function set_data_jurnal_ppnimport($data){
		//Header jurnal
		if($data['action'] == 'PPN_IMPORT'){
			$trju_tgl = $data['header']['pbidpi_tgl'];
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);			
			$tahun = substr($trju_tgl, 2, 2);
			$separator = ($this->input->post('trpo_fin') == 'F') ? '-' : '_';		
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$trju_catatan = $data['header']['pbidpi_tag']. ' '. $data['header']['pbidpi_trid_no'].'/'.substr($this->input->post('trid_mssp_no'), 0, 6). ' - '. substr($this->input->post('trid_mssp_no'), 9);
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_refno'] = $data['header']['pbidpi_trid_no'].'PI';
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_void'] = 0;			
			$data['jurnal_h']['trju_reftipe'] = 'PI';
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trpo_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trpo_fin');
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));
		}

		if($data['action'] == 'CANCEL_PPN_IMPORT'){
			$data['jurnal_h']['trju_no'] = $this->input->post('trju_no_pi');
		}

		$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
		$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];		

		// Set account														
 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv									
			$data['jurnal_d'] = array();
			$array = array();				
			$saldo = ftodouble($data['header']['pbidpi_jlhbayar']);

			// (Debet)
		 	$acc = $this->m_setting_account->get_setting_account_byid('IDPI');
		 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	 		$array['dtju_debet'] = $data['trid_totalppnimport'];
	 		$array['dtju_kredit'] = 0;
	 		array_push($data['jurnal_d'], $array);

	 		// Adjustment (Debet)
		 	$acc = $this->m_setting_account->get_setting_account_byid('IDAI');						
		 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	 		$array['dtju_debet'] = $data['header']['pbidpi_adj'];
	 		$array['dtju_kredit'] = 0;
	 		array_push($data['jurnal_d'], $array);							

			// Payment type (Kredit)			 						 						
		 	$array['dtju_msap_no'] = $this->m_acc_perkiraan->get_msjb_msap_no($data['header']['pbidpi_msjb_no']);
			$array['dtju_debet'] = 0;
			$array['dtju_kredit'] = $saldo;
			array_push($data['jurnal_d'], $array);

			$this->data['jurnal_d'] = $data['jurnal_d'];						
 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^				 																								
		$this->data['jurnal_h'] = $data['jurnal_h'];
	}

	private function set_data_jurnal_bea($data){
		//Header jurnal
		if($data['action'] == 'BEA'){
			$trju_tgl = $data['header']['pbidbm_tgl'];
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);			
			$tahun = substr($trju_tgl, 2, 2);
			$separator = ($this->input->post('trpo_fin') == 'F') ? '-' : '_';		
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$trju_catatan = $data['header']['pbidbm_tag'].' '.$data['header']['pbidbm_trid_no'].'/'.substr($this->input->post('trid_mssp_no'), 0, 6). ' - '. substr($this->input->post('trid_mssp_no'), 9);
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);							
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;
			$data['jurnal_h']['trju_refno'] = $data['header']['pbidbm_trid_no'].'BB';
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_void'] = 0;
			$data['jurnal_h']['trju_reftipe'] = 'BB';
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trpo_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trpo_fin');
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));
		}

		if($data['action'] == 'CANCEL_BEA'){
			$data['jurnal_h']['trju_no'] = $this->input->post('trju_no_bb');
		}

		$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
		$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];		

		// Set account														
 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv									
			$data['jurnal_d'] = array();
			$array = array();				
			$saldo = ftodouble($data['header']['pbidbm_jlhbayar']);
			
			// Bea Masuk (Debet)
		 	$acc = $this->m_setting_account->get_setting_account_byid('IDBM');						
		 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	 		$array['dtju_debet'] = $saldo - $data['header']['pbidbm_adj'];
	 		$array['dtju_kredit'] = 0;
	 		array_push($data['jurnal_d'], $array);

	 		// Adjustment Bea Masuk (Debet)
		 	$acc = $this->m_setting_account->get_setting_account_byid('IDAB');						
		 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	 		$array['dtju_debet'] = $data['header']['pbidbm_adj'];
	 		$array['dtju_kredit'] = 0;
	 		array_push($data['jurnal_d'], $array);							

			// Payment type (Kredit)			 						 						
		 	$array['dtju_msap_no'] = $this->m_acc_perkiraan->get_msjb_msap_no($data['header']['pbidbm_msjb_no']);
			$array['dtju_debet'] = 0;
			$array['dtju_kredit'] = $saldo;
			array_push($data['jurnal_d'], $array);

			$this->data['jurnal_d'] = $data['jurnal_d'];						
 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^				 																								
		$this->data['jurnal_h'] = $data['jurnal_h'];

	}

	private function cek_valid_data_jurnal($data){				
		$msg = '';
		$hsl = true;

		// cek setting account harus diisi
		if($hsl){
			if(!$this->m_setting_account->get_setting_account_byid('HUTI') ||
				!$this->m_setting_account->get_setting_account_byid('HUTL') ||
				!$this->m_setting_account->get_setting_account_byid('IDBM') ||
				!$this->m_setting_account->get_setting_account_byid('IDBK') ||
				!$this->m_setting_account->get_setting_account_byid('PPNM') ||
				!$this->m_setting_account->get_setting_account_byid('IDAB') ||
				!$this->m_setting_account->get_setting_account_byid('IDPS') ||
				!$this->m_setting_account->get_setting_account_byid('IDAP') ||
				!$this->m_setting_account->get_setting_account_byid('IDPH') ||
				!$this->m_setting_account->get_setting_account_byid('IDAH') ||
				!$this->m_setting_account->get_setting_account_byid('IDPI') ||
				!$this->m_setting_account->get_setting_account_byid('IDAI') ||
				!$this->m_setting_account->get_setting_account_byid('IDAK')){
					$hsl = false;					
					$msg = 'There is an account that has not been set';	
			}
		}	

		//cek akun perkiraan di master kategori harus diisi
		if($hsl){
			if(isset($data['detail'])){
				foreach ($data['detail'] as $key => $value) {
					$mskt_no = substr($data['detail'][$key]['dtid_mspd_no'], 0, 1);					
					if(!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv')){
						$hsl = false;						
						$msg = 'There is an account not yet filled in Category Master';
					}								
				}
			}
		}
		return array('valid'=>$hsl, 'msg'=>$msg);		
	}

	private function cek_valid_data_trans($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | VOID | CONF_RECEIVING_GOODS | CANCEL_RECEIVING_GOODS

			$msg = '';
			$hsl = true;
			$qty_valid = false;
			$qty_cek = true;
			$tgl_cls_jurnal = $this->m_setting->get_setting('simr_char1','tcj', 1);

			// Utk pengecekan dtid_qtyterima incoming delivery		
			if ($hsl) {
				if(isset($data['detail'])){
					foreach ($data['detail'] as $key => $value) {

						if ($menu == 'NEW' || $menu == 'EDIT' || $menu == 'CONF_RECEIVING_GOODS') { 
							$qtyupdate = ftodouble($data['detail'][$key]['dtid_qtyterima']);							

							if ($qtyupdate < 0){
								$hsl = false;
								$msg = 'Qty receive cannot < 0';
								break;
							}														

							if($qtyupdate > ftodouble($data['detail'][$key]['dtid_qtysisa'])){
								$hsl = false;
								$msg = 'Qty receive must be >= 0 or <= qty remaining'.
										'<br>Product: '. $data['detail'][$key]['dtid_mspd_no'].
										'<br>Qty Remaining: '. ftodouble($data['detail'][$key]['dtid_qtysisa']);
								break;
							}

							if($menu == 'CONF_RECEIVING_GOODS'){
								if ($qtyupdate > 0 && ftodouble($data['detail'][$key]['dtid_dimensi'] <= 0)){
									$hsl = false;
									$msg = 'Please input dimention';
									break;
								}
							}
						}																								

						if($qty_cek){
							if ($qtyupdate > 0){
								$qty_cek = false;
								$qty_valid = true;																
							}														
						}

						unset($this->data['detail'][$key]['dtid_qtysisa']);						
					}
				}				
			}

			// cek jika sudah ada pembayaran tidak bisa di edit
			if($hsl && $menu == 'EDIT'){
				if($this->m_incoming_delivery->cek_pby_biayakirim_exists($data['header']['trid_no'])){
					$hsl = false;
					$msg = 'Transaction cannot be edit, payment of shipping fee already paid';
				}																		

				if($this->m_incoming_delivery->cek_pby_beamasuk_exists($data['header']['trid_no'])){
					$hsl = false;
					$msg = 'Transaction cannot be edit, payment of bea masuk already paid';
				}																		
			}

			if($menu == 'NEW' || $menu == 'EDIT' || $menu == 'CONF_RECEIVING_GOODS'){
				// cek qty receive haru di isi (minimal satu produk)
				if ($hsl && $qty_valid == false){
					$hsl = false;
					$msg = 'Please input qty receive.';
				}				
			}
			
			if($menu == 'CONF_RECEIVING_GOODS' || $menu == 'CANCEL_RECEIVING_GOODS'){				
				// transaksi tidak bisa di buat/edit/void jika tgl transaksi/jurnal sudah di closing
				if($hsl){
					$tgl_trans = $this->input->post('trid_tglterima');				
					$tahun = substr($tgl_trans, 0, 4);
					$bulan = substr($tgl_trans, 5, 2);	
					$tgl_trans = (int)$tahun.$bulan;	

					if($hsl && $tgl_trans <= $tgl_cls_jurnal){
						$hsl = false;
						$msg = 'Can not create new/edit/void transaction if journal transaction date is closed. Please choose another date.';
					}
				}					
			}

			if($menu == 'CANCEL_RECEIVING_GOODS'){				
				// Transaksi yang sudah di rekonsiliasi tidak bisa di edit/void/cancel
				if($hsl && $this->m_app->is_recon_exists($data['header']['trid_no'].'ID')){
					$hsl = false;
					$msg = 'Transactions cannot be changed. Journal already in reconciliation';
				}
				
				// cek tidak boleh di cancel kalo status copy-nya (X)
				if($hsl){
					if($data['trpo_stcopy'] == 'X'){
						$hsl = false;					
						$msg = 'Transaction cannot be cancelled. Please change status exclude (X) first on Purchase Order';
					}
				}	
			}

			if($menu == 'BIAYA_KIRIM' || $menu == 'PPN_SHIPPING' || $menu == 'BEA' || $menu == 'PPH_22' || $menu == 'PPN_IMPORT' ||
				$menu == 'CANCEL_BIAYA_KIRIM' || $menu == 'CANCEL_PPN_SHIPPING' || $menu == 'CANCEL_BEA' || $menu == 'CANCEL_PPH_22' || $menu == 'CANCEL_PPN_IMPORT'){
				if($hsl){
						// transaksi tidak bisa di buat/edit/void jika tgl transaksi/jurnal sudah di closing
						if($menu == 'BIAYA_KIRIM' || $menu == 'CANCEL_BIAYA_KIRIM'){
							$tgl_trans = $this->input->post('pbidbk_tgl');									
						}

						if($menu == 'PPN_SHIPPING' || $menu == 'CANCEL_PPN_SHIPPING'){
							$tgl_trans = $this->input->post('pbidps_tgl');									
						}

						if($menu == 'BEA' || $menu == 'CANCEL_BEA'){
							$tgl_trans = $this->input->post('pbidbm_tgl');									
						}

						if($menu == 'PPH_22' || $menu == 'CANCEL_PPH_22'){
							$tgl_trans = $this->input->post('pbidph_tgl');									
						}

						if($menu == 'PPN_IMPORT' || $menu == 'CANCEL_PPN_IMPORT'){
							$tgl_trans = $this->input->post('pbidpi_tgl');									
						}
						
						$tahun = substr($tgl_trans, 0, 4);
						$bulan = substr($tgl_trans, 5, 2);	
						$tgl_trans = (int)$tahun.$bulan;	

						if($tgl_trans <= $tgl_cls_jurnal){
							$hsl = false;
							$msg = 'Can not create new/edit/void transaction if journal transaction date is closed. Please choose another date.';
						}
				}
			}

			if($menu == 'CANCEL_BIAYA_KIRIM' || $menu == 'CANCEL_PPN_SHIPPING' || $menu == 'CANCEL_BEA' || $menu == 'CANCEL_PPH_22' || $menu == 'CANCEL_PPN_IMPORT'){				
				if($hsl){					
					if($menu == 'CANCEL_BIAYA_KIRIM'){					
						$is_recon_exists = $this->m_app->is_recon_exists($data['header']['pbidbk_trid_no'].'BK');
					}

					if($menu == 'CANCEL_PPN_SHIPPING'){					
						$is_recon_exists = $this->m_app->is_recon_exists($data['header']['pbidps_trid_no'].'PS');
					}

					if($menu == 'CANCEL_BEA'){					
						$is_recon_exists = $this->m_app->is_recon_exists($data['header']['pbidbm_trid_no'].'BB');
					}

					if($menu == 'CANCEL_PPH_22'){					
						$is_recon_exists = $this->m_app->is_recon_exists($data['header']['pbidph_trid_no'].'PH');
					}

					if($menu == 'CANCEL_PPN_IMPORT'){					
						$is_recon_exists = $this->m_app->is_recon_exists($data['header']['pbidpi_trid_no'].'PI');
					}

					// Transaksi yang sudah di rekonsiliasi tidak bisa di edit/void/cancel
					if($is_recon_exists){
						$hsl = false;
						$msg = 'Transactions cannot be changed. Journal already in reconciliation';
					}
				}
			}
			
			if($menu == 'BIAYA_KIRIM'){
				//cek jenis bayar haru diisi
				if($hsl){				
					$this->form_validation->set_rules('pbidbk_msjb_no', 'Payment Type', 'required');
					if ($this->form_validation->run() == FALSE){
						$hsl = false;					
						$msg = 'Please select payment type';
					}
				}

				// cek adjustment dan amount harus sama
				if($hsl){				
					$trid_totalbiayakirim = fhapus_kutip(ftodouble($this->input->post('trid_totalbiayakirim')));
					$pbidbk_adj = fhapus_kutip(ftodouble($this->input->post('pbidbk_adj')));
					$pbidbk_jlhbayar = number_format(fhapus_kutip(ftodouble($this->input->post('pbidbk_jlhbayar'))), 4);
					$fee = number_format(($trid_totalbiayakirim + $pbidbk_adj), 4);

					if ($fee != $pbidbk_jlhbayar){
						$hsl = false;					
						$msg = 'Total shipping fee and amount must be the same';											
					}
				}				
			}

			if($menu == 'PPN_SHIPPING'){
				//cek jenis bayar haru diisi
				if($hsl){				
					$this->form_validation->set_rules('pbidps_msjb_no', 'Payment Type', 'required');
					if ($this->form_validation->run() == FALSE){
						$hsl = false;					
						$msg = 'Please select payment type';
					}
				}

				// cek adjustment dan amount harus sama
				if($hsl){				
					$trid_totalppnshipping = fhapus_kutip(ftodouble($this->input->post('trid_totalppnshipping')));
					$pbidps_adj = fhapus_kutip(ftodouble($this->input->post('pbidps_adj')));
					$pbidps_jlhbayar = number_format(fhapus_kutip(ftodouble($this->input->post('pbidps_jlhbayar'))), 4);
					$fee = number_format(($trid_totalppnshipping + $pbidps_adj), 4);

					if ($fee != $pbidps_jlhbayar){
						$hsl = false;					
						$msg = 'Total PPN shipping and amount must be the same';					
					}
				}
			}			
			
			if($menu == 'BEA'){
				//cek jenis bayar haru diisi
				if($hsl){
					$this->form_validation->set_rules('pbidbm_msjb_no', 'Payment Type', 'required');
					if ($this->form_validation->run() == FALSE){
						$hsl = false;					
						$msg = 'Please select payment type';					
					}
				}

				// cek adjustment dan amount harus sama
				if($hsl){
					$trid_bea = fhapus_kutip(ftodouble($this->input->post('trid_bea')));
					$pbidbm_adj = fhapus_kutip(ftodouble($this->input->post('pbidbm_adj')));
					$pbidbm_jlhbayar = number_format(fhapus_kutip(ftodouble($this->input->post('pbidbm_jlhbayar'))), 4);
					$fee = number_format(($trid_bea + $pbidbm_adj), 4);
					if ($fee != $pbidbm_jlhbayar){
						$hsl = false;					
						$msg = 'Total bea masuk and amount must be the same';					
					}
				}
			}

			if($menu == 'PPH_22'){
				//cek jenis bayar haru diisi
				if($hsl){				
					$this->form_validation->set_rules('pbidph_msjb_no', 'Payment Type', 'required');
					if ($this->form_validation->run() == FALSE){
						$hsl = false;					
						$msg = 'Please select payment type';
					}
				}

				// cek adjustment dan amount harus sama
				if($hsl){				
					$trid_totalpph22 = fhapus_kutip(ftodouble($this->input->post('trid_totalpph22')));
					$pbidph_adj = fhapus_kutip(ftodouble($this->input->post('pbidph_adj')));
					$pbidph_jlhbayar = number_format(fhapus_kutip(ftodouble($this->input->post('pbidph_jlhbayar'))), 4);
					$fee = number_format(($trid_totalpph22 + $pbidph_adj), 4);

					if ($fee != $pbidph_jlhbayar){
						$hsl = false;					
						$msg = 'Total PPh 22 and amount must be the same';					
					}
				}
			}

			if($menu == 'PPN_IMPORT'){
				//cek jenis bayar haru diisi
				if($hsl){				
					$this->form_validation->set_rules('pbidpi_msjb_no', 'Payment Type', 'required');
					if ($this->form_validation->run() == FALSE){
						$hsl = false;					
						$msg = 'Please select payment type';
					}
				}

				// cek adjustment dan amount harus sama
				if($hsl){				
					$trid_totalppnimport = fhapus_kutip(ftodouble($this->input->post('trid_totalppnimport')));
					$pbidpi_adj = fhapus_kutip(ftodouble($this->input->post('pbidpi_adj')));
					$pbidpi_jlhbayar = number_format(fhapus_kutip(ftodouble($this->input->post('pbidpi_jlhbayar'))), 4);
					$fee = number_format(($trid_totalppnimport + $pbidpi_adj), 4);

					if ($fee != $pbidpi_jlhbayar){
						$hsl = false;					
						$msg = 'Total PPN Import and amount must be the same';					
					}
				}
			}				

			// utk pengecekan cekint Purchase Order 
			// Valid = CekInt tidak berubah
			if ($hsl && ($menu == 'NEW' || $menu == 'EDIT' || $menu == 'VOID' || $menu == 'CONF_RECEIVING_GOODS' || $menu == 'CANCEL_RECEIVING_GOODS')) {
				if($this->m_purchase_order->get_purchase_order_cekint(substr($data['header']['trid_no'], 0, 12), $data['trpo_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_purchase_order->set_purchase_order_cekint(substr($data['header']['trid_no'], 0, 12));
				}				
			}
			

			if ($hsl && $menu != 'NEW') {
				if($this->m_incoming_delivery->get_incoming_delivery_cekint($data['header']['trid_no'], $data['trid_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';										
				}else{
					$this->m_incoming_delivery->set_incoming_delivery_cekint($data['header']['trid_no']);
				}
			}

			if($hsl && ($menu == 'BIAYA_KIRIM'|| $menu == 'CANCEL_BIAYA_KIRIM' || $menu == 'BEA' || $menu == 'CANCEL_BEA' || $menu == 'PPN_SHIPPING' || $menu == 'PPH_22' || $menu == 'PPN_IMPORT')){
				unset($this->data['header']['trid_no']);
			}

			return array('valid'=>$hsl, 'msg'=>$msg);		
	}

}