<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class giro_masuk extends MY_Controller {	
	private $data = array();

	function __construct(){
		parent::__construct();	
		$this->load->model('finance_and_acc/m_giro_masuk');	
		$this->load->model('stok_kontrol/m_sales_delivery');
		$this->load->model('finance_and_acc/m_so_payment');
		$this->load->model('finance_and_acc/m_jurnal');		
		$this->load->model('spk/m_spk');	
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index(){			
		// cek hak akses		
		if(!fcek_hak_akses('.EG0.')){				
			exit('Cannot access this page.');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/giro_masuk/v_giro_masuk_list', $data);
		$this->load->view('v_footer');			
	}

	public function giro_masuk_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'giro_masuk');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['giro_masuk_list'] = $this->m_giro_masuk->get_giro_masuk_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['giro_masuk_list']);
		}
		else {
			$pagination['total_list'] = $this->m_giro_masuk->get_giro_masuk_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['giro_masuk_list'] = $this->load->view('finance_and_acc/giro_masuk/v_giro_masuk_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function giro_masuk_new()
	{
		// cek hak akses		
		if(!fcek_hak_akses('.EG1.')){				
			exit('Cannot access this page.');
		}		
		
		$data['action'] = 'NEW';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/giro_masuk/v_giro_masuk_form',$data);
		$this->load->view('v_footer');		
	}

	public function giro_masuk_view()
	{
		// cek hak akses		
		if(!fcek_hak_akses('.EG1.')){				
			exit('Cannot access this page.');
		}
		
		$trgm_no = $this->input->get('trgm_no');
		$data = $this->m_giro_masuk->get_giro_masuk($trgm_no);								
		$data['action'] = 'VIEW';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/giro_masuk/v_giro_masuk_form',$data);
		$this->load->view('v_footer');			
	}

	public function giro_masuk_simpan()
	{
		// Proteksi supaya tidak bisa di akses dari URL 		
		if(!$this->input->is_ajax_request()) {
		   exit('No direct script access allowed');
		}

		$vok = true;
		$msg = '';

		// set data
		if($vok){
			$data = array();
			$data['action'] = $this->input->post('action');									
			$data['trgm_cekint'] = $this->input->post('trgm_cekint');
			$data['tr']['trgm_no'] = fhapus_kutip(trim($this->input->post('trgm_no')));				
			$data['trgm_no_lama'] = fhapus_kutip(trim($this->input->post('trgm_no_lama')));				

			if($data['action'] == 'NEW'){					
				$data['tr']['trgm_tglterima'] = $this->input->post('trgm_tglterima');
				$data['tr']['trgm_tglcair'] = 0;
				$data['tr']['trgm_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$data['tr']['trgm_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$data['tr']['trgm_msap_no_bgm'] = '';
				$data['tr']['trgm_void'] = 0;								
				$data['tr']['trgm_nprint'] = 0;				
			}
									
			$data['tr']['trgm_mscs_no'] = ($this->input->post('trgm_mscs_no') == '') ? '' : str_replace("-", "", fhapus_kutip(substr($this->input->post('trgm_mscs_no'), 0, 6)));
			$data['tr']['trgm_tgljthtempo'] = $this->input->post('trgm_tgljthtempo');			
			$data['tr']['trgm_total'] = ftodouble($this->input->post('trgm_total'));
			$data['tr']['trgm_used'] = ftodouble($this->input->post('trgm_used'));
			$data['tr']['trgm_catatan'] = fhapus_kutip($this->input->post('trgm_catatan'));
			$data['tr']['trgm_tag'] = fhapus_kutip($this->input->post('trgm_tag'));	
			$data['tr']['trgm_lsupd'] = date('Y-m-d H:i:s');
			$data['tr']['trgm_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];												
		}

		// cek form validation
		if($vok){
			$this->form_validation->set_rules($this->config_validation());
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();
			}
		}

		// cek valid data transaksi
		if($vok) {
			$hasil_cek = $this->cek_valid_data_trans($data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error_message'=>$hasil_cek['msg']);				
			}
		}

		// Simpan data
		if($vok){
			$vresult = $this->m_giro_masuk->giro_masuk_simpan($data);			
			if($vresult == 0){
				$vok = false;				
				$msg = array('error_message' => 'Error Query');
			}
		}		
		
		// Berhasil simpan data
		if($vok){
			$this->session->set_userdata('response','sukses');
			$result['response'] = 'sukses';
  	 		$result['trgm_no'] = $data['tr']['trgm_no'];
		}
				
		// Gagal simpan data							
		if(!$vok){
			$result['response'] = 'gagal';  	 		
  	 		$result['error_message'] = $msg;	  	 		
		}	

		echo json_encode($result);
	}	

	public function giro_masuk_payment_simpan(){
		$vok = true;

		// set data
		if($vok){
			$data['action'] = 'GIRO_MASUK_PAYMENT';
			$data['trgm_no'] = $this->input->post('trgm_no');			
			$data['trgm_cekint'] = $this->input->post('trgm_cekint');
			$data['trgm_no_lama'] = $data['trgm_no'];
			$pbyr = $this->input->post('pbyr');

			if(isset($pbyr)){																
				foreach ($pbyr['jlhbayar'] as $key => $value) {
					if ($pbyr['jlhbayar'][$key] != '') {											

						// set data pembayran Sales Delivery/Faktur	
						if($pbyr['jenistrans'][$key] == 'S'){	
								$data['pbso'][$key]['pbso_no'] = $this->m_so_payment->so_payment_kode_auto(substr($pbyr['refno'][$key], 0, 12));
								$data['pbso'][$key]['pbso_seq'] = 1;
								$data['pbso'][$key]['pbso_refno'] = $pbyr['refno'][$key];
								$data['pbso'][$key]['pbso_msjb_no'] = 0;
								$data['pbso'][$key]['pbso_jenis'] = 'G';
								$data['pbso'][$key]['pbso_bayardp'] = 'T';
								$data['pbso'][$key]['pbso_jlhbayar'] = ftodouble($pbyr['jlhbayar'][$key]);
								$data['pbso'][$key]['pbso_catatan'] = '';
								$data['pbso'][$key]['pbso_tglterima'] = $pbyr['tglbyr'][$key]. ' '. date('H:i:s');
								$data['pbso'][$key]['pbso_tglcair'] = $this->input->post('trgm_tgljthtempo');
								$data['pbso'][$key]['pbso_void'] = 0;
								$data['pbso'][$key]['pbso_cekint'] = 1;
								$data['pbso'][$key]['pbso_lsupd'] = date('Y-m-d H:i:s');
								$data['pbso'][$key]['pbso_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
								$data['pbso'][$key]['pbso_nprint'] = 0;
								$data['pbso'][$key]['pbso_tag'] = '';
								$data['pbso'][$key]['pbso_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
								$data['pbso'][$key]['pbso_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no']; 
								$data['pbso'][$key]['pbso_trsr_no'] = '';
								$data['pbso'][$key]['pbso_refnopbyr'] = $data['trgm_no'];

						// set data pembayran SPK
						}else if($pbyr['jenistrans'][$key] == 'K'){
							$data['pbspk'][$key]['pbspk_no'] = $this->m_spk->spk_payment_kode_auto($pbyr['refno'][$key]);
							$data['pbspk'][$key]['pbspk_msjb_no'] = 0;
							$data['pbspk'][$key]['pbspk_jlhbayar'] = ftodouble($pbyr['jlhbayar'][$key]);
							$data['pbspk'][$key]['pbspk_catatan'] = '';
							$data['pbspk'][$key]['pbspk_tglterima'] = $pbyr['tglbyr'][$key]. ' '. date('H:i:s');
							$data['pbspk'][$key]['pbspk_tglcair'] = $pbyr['tglbyr'][$key];
							$data['pbspk'][$key]['pbspk_void'] = 0;
							$data['pbspk'][$key]['pbspk_lsupd'] = date('Y-m-d H:i:s');
							$data['pbspk'][$key]['pbspk_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
							$data['pbspk'][$key]['pbspk_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
							$data['pbspk'][$key]['pbspk_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no']; 
							$data['pbspk'][$key]['pbspk_jenis'] = 'G';
							$data['pbspk'][$key]['pbspk_refnopbyr'] = $data['trgm_no'];
						}
					}					
				}
			}	

		}

		// cek valid data transaksi
		if($vok) {
			$hasil_cek = $this->cek_valid_data_trans($data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error_message'=>$hasil_cek['msg']);
			}
		}

		// Simpan data
		if($vok){
			$vresult = $this->m_giro_masuk->giro_masuk_payment_simpan($data);			
			if($vresult == 0){
				$vok = false;				
				$msg = array('error_message' => 'Error Query');
			}
		}		
		
		// Berhasil simpan data
		if($vok){
			$this->session->set_userdata('response','sukses');
			$result['response'] = 'sukses';
  	 		$result['trgm_no'] = $this->input->post('trgm_no');
		}
				
		// Gagal simpan data							
		if(!$vok){
			$result['response'] = 'gagal';  	 		
  	 		$result['error_message'] = $msg;	  	 		
		}	

		echo json_encode($result);
	}

	public function pencairan_giro_simpan()
	{		
		// Proteksi supaya tidak bisa di akses dari URL 		
		if(!$this->input->is_ajax_request()) {
		   exit('No direct script access allowed');
		}
		
		$vok = true;
		$msg = '';

		// set data
		if($vok){
			$data = array();
			$data['action'] = 'PENCAIRAN_GIRO';									
			$data['trgm_cekint'] = $this->input->post('trgm_cekint');
			$data['mscs'] = fhapus_kutip($this->input->post('trgm_mscs_no'));
			$data['trgm_no_lama'] = fhapus_kutip(trim($this->input->post('trgm_no_lama')));			
			$data['trgm_total'] = ftodouble($this->input->post('trgm_total'));
			$data['trgm_used'] = ftodouble($this->input->post('trgm_used'));
			$data['trgm_catatan'] = fhapus_kutip($this->input->post('trgm_catatan'));
			$data['trgm_tag'] = fhapus_kutip($this->input->post('trgm_tag'));	

			$data['tr']['trgm_msap_no_bgm'] = fhapus_kutip($this->input->post('trgm_msap_no_bgm'));
			$data['tr']['trgm_msap_no_slh'] = fhapus_kutip($this->input->post('trgm_msap_no_slh'));
			$data['tr']['trgm_tglcair'] = $this->input->post('trgm_tglcair');
			$data['tr']['trgm_lsupd'] = date('Y-m-d H:i:s');
			$data['tr']['trgm_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];													
		}		

		// cek valid data transaksi
		if($vok) {
			$hasil_cek = $this->cek_valid_data_trans($data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error_message'=>$hasil_cek['msg']);				
			}
		}

		// Simpan data
		if($vok){
			$vresult = $this->m_giro_masuk->giro_masuk_simpan($data);			
			if($vresult == 0){
				$vok = false;				
				$msg = array('error_message' => 'Error Query');
			}
		}		
		
		// Berhasil simpan data
		if($vok){
			$this->session->set_userdata('response','sukses');
			$result['response'] = 'sukses';
  	 		$result['trgm_no'] = $data['trgm_no_lama'];
		}
				
		// Gagal simpan data							
		if(!$vok){
			$result['response'] = 'gagal';  	 		
  	 		$result['error_message'] = $msg;	  	 		
		}	

		echo json_encode($result);
	}

	public function batal_cair_simpan()
	{
		// Proteksi supaya tidak bisa di akses dari URL 		
		if(!$this->input->is_ajax_request()) {
		   exit('No direct script access allowed');
		}

		$vok = true;
		$msg = '';

		// set data
		if($vok){
			$data = array();
			$data['action'] = 'BATAL_PENCAIRAN_GIRO';
			$data['trgm_cekint'] = $this->input->post('trgm_cekint');			
			$data['trgm_no_lama'] = fhapus_kutip(trim($this->input->post('trgm_no_lama')));			
			$data['tr']['trgm_msap_no_bgm'] = '';
			$data['tr']['trgm_msap_no_slh'] = '';
			$data['tr']['trgm_tglcair'] = 0;
			$data['tr']['trgm_lsupd'] = date('Y-m-d H:i:s');
			$data['tr']['trgm_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
		}

		// cek valid data transaksi
		if($vok) {
			$hasil_cek = $this->cek_valid_data_trans($data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error_message'=>$hasil_cek['msg']);				
			}
		}				

		// Simpan data
		if($vok){
			$vresult = $this->m_giro_masuk->giro_masuk_simpan($data);			
			if($vresult == 0){
				$vok = false;				
				$msg = array('error_message' => 'Error Query');
			}
		}		
		
		// Berhasil simpan data
		if($vok){
			$this->session->set_userdata('response','sukses');
			$result['response'] = 'sukses';
  	 		$result['trgm_no'] = $data['trgm_no_lama'];
		}
				
		// Gagal simpan data							
		if(!$vok){
			$result['response'] = 'gagal';  	 		
  	 		$result['error_message'] = $msg;	  	 		
		}	

		echo json_encode($result);
	}

	public function giro_masuk_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'giro_masuk');		

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';		
		$data['st_cair'] = $this->input->post('st_cair');
		$data['trgm_mscs_no'] = $this->input->post('trgm_mscs_no');

		$respon = array();
		$respon['popup'] = $this->load->view('finance_and_acc/giro_masuk/v_giro_masuk_popup',$data,true);	
		echo json_encode($respon);		
	}

	private function config_validation(){
		$config = array(		        
			        array(
			                'field' => 'trgm_no',
			                'label' => 'No. Giro',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Please input %s. <br>',			                        
			                )
			        ),
			        array(
			                'field' => 'trgm_mscs_no',
			                'label' => 'Customer',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Please input %s. <br>',			                        
			                )
			        ),
			        array(
			                'field' => 'trgm_tgljthtempo',
			                'label' => 'Tgl Jatuh Tempo',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Please input %s. <br>',			                        
			                )
			        ),
			        array(
			                'field' => 'trgm_total',
			                'label' => 'Total Giro',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Please input %s. <br>',			                        
			                )
			        )   
		);		

		return $config;
	}

	private function cek_valid_data_trans($data){
		$vok = true;
		$msg = '';

		if($data['action'] == 'NEW' || $data['action'] == 'EDIT'){						
			$hsl_cek_no_giro = false;

			if($data['action'] == 'NEW'){
				$hsl_cek_no_giro = $this->m_giro_masuk->is_trgm_no_exists($data['tr']['trgm_no']);
			}elseif($data['action'] == 'EDIT'){
				$hsl_cek_no_giro = $this->m_giro_masuk->is_trgm_no_exists($data['tr']['trgm_no'], $data['trgm_no_lama']);
			}

			// cek No. Giro harus uniq		
			if($vok && $hsl_cek_no_giro){				
				$vok = false;
				$msg = 'No. Giro tidak valid / No. Giro sudah ada.';				
			}			
		}

		if($data['action'] == 'PENCAIRAN_GIRO'){									
			// cek Tgl Cair wajib diisi		
			if($vok && $data['tr']['trgm_tglcair'] == ''){				
				$vok = false;
				$msg = 'Silakan input tgl cair.';				
			}			

			// cek Akun Bank wajib diisi		
			if($vok && $data['tr']['trgm_msap_no_bgm'] == ''){				
				$vok = false;
				$msg = 'Silakan input akun bank.';				
			}				

			// cek Akun Selisih wajib diisi jika ada selisih
			if($vok && ($data['tr']['trgm_msap_no_slh'] == '') && ($data['trgm_total'] != $data['trgm_used'])){				
				$vok = false;
				$msg = 'Total Giro tidak sama dengan penggunaan Giro.<br>';				
				$msg .= 'Silakan input akun selisih.';				
			}						
		}			

		if($data['action'] == 'EDIT' || $data['action'] == 'VOID'){						
			// cek transaksi tidak boleh di edit jika giro sudah di gunakan untuk pembayaran
			if($vok && $data['tr']['trgm_used'] != 0){
				// $vok = false;
				$msg = 'Transaksi tidak bisa di edit/void. Giro sudah digunakan untuk pembayaran Transaksi.';	
			}
		}

		if($data['action'] == 'GIRO_MASUK_PAYMENT'){			
			$pbyr = $this->input->post('pbyr');

			// cek pembayaran harus di input
			if($vok && !isset($data['pbso']) && !isset($data['pbspk'])){
				$vok = false;
				$msg = 'Silakan input pembayaran.';
			}

			if($vok && (ftodouble($this->input->post('total_byr')) > ftodouble($this->input->post('sisa_giro')))){
				$vok = false;
				$msg = 'Total bayar tidak boleh > sisa giro.';
			}					

			if(isset($data['pbso'])){
				foreach ($data['pbso'] as $key => $value) {				
					if($vok && ftodouble($data['pbso'][$key]['pbso_jlhbayar']) > ftodouble($pbyr['sisabayar'][$key])){
						$vok = false;
						$msg = 'Jumlah bayar tidak boleh > dari sisa bayar.<br>';
						$msg .= 'No. Trans: '. $pbyr['refno'][$key];
						break;
					}					

					// utk pengecekan trsd_cekint, 
					// Valid = CekInt tidak berubah
					if($vok){
						if($this->m_sales_delivery->get_sales_delivery_cekint($pbyr['refno'][$key], $pbyr['cekint'][$key]) == false){
							$vok = false;
							$msg = 'Data sudah dirubah oleh user lain. Silakan refresh halaman<br>';								
							$msg .= 'No. Trans: '. $pbyr['refno'][$key].'<br>';
							break;
						}
					}
				}				
			}			

			if(isset($data['pbspk'])){
				foreach ($data['pbspk'] as $key => $value) {				
					if($vok && ftodouble($data['pbspk'][$key]['pbspk_jlhbayar']) > ftodouble($pbyr['sisabayar'][$key])){
						$vok = false;
						$msg = 'Jumlah bayar tidak boleh > dari sisa bayar.<br>';
						$msg .= 'No. Trans: '. $pbyr['refno'][$key];
						break;
					}								

					// utk pengecekan trspk_cekint, 
					// Valid = CekInt tidak berubah
					if($vok){
						if($this->m_spk->get_spk_cekint($pbyr['refno'][$key], $pbyr['cekint'][$key]) == false){
							$vok = false;
							$msg = 'Data have been changed by another user. Please Refresh the page<br>';								
							$msg .= 'No. Trans: '. $pbyr['refno'][$key].'<br>';							
							break;
						}
					}
				}				
			}							
		}

		// utk pengecekan cekint, 
		// Valid = CekInt tidak berubah
		if ($vok && $data['action'] != 'NEW') {
			if($this->m_giro_masuk->cek_exists_cekint($data['trgm_no_lama'], $data['trgm_cekint']) == false){
				$vok = false;
				$msg = 'Data have been changed by another user. Please Refresh the page';
			}else{
				$this->m_giro_masuk->set_giro_masuk_cekint($data['trgm_no_lama']);
			}
		}				

		return array('valid'=>$vok, 'msg'=>$msg);
	}

}