<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class giro_keluar extends MY_Controller {	
	private $data = array();

	function __construct(){
		parent::__construct();	
		$this->load->model('finance_and_acc/m_giro_keluar');	
		$this->load->model('purchase/m_incoming_delivery');
		$this->load->model('finance_and_acc/m_po_payment');
		$this->load->model('finance_and_acc/m_jurnal');		
		$this->load->model('setting/m_setting_account');					
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index(){			
		// cek hak akses		
		if(!fcek_hak_akses('.EI0.')){				
			exit('Cannot access this page.');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/giro_keluar/v_giro_keluar_list', $data);
		$this->load->view('v_footer');			
	}

	public function giro_keluar_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'giro_keluar');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['giro_keluar_list'] = $this->m_giro_keluar->get_giro_keluar_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['giro_keluar_list']);
		}
		else {
			$pagination['total_list'] = $this->m_giro_keluar->get_giro_keluar_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['giro_keluar_list'] = $this->load->view('finance_and_acc/giro_keluar/v_giro_keluar_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function giro_keluar_new()
	{
		// cek hak akses		
		if(!fcek_hak_akses('.EI1.')){				
			exit('Cannot access this page.');
		}		
		
		$data['action'] = 'NEW';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/giro_keluar/v_giro_keluar_form',$data);
		$this->load->view('v_footer');		
	}

	public function giro_keluar_view()
	{
		// cek hak akses		
		if(!fcek_hak_akses('.EI1.')){				
			exit('Cannot access this page.');
		}
		
		$trgk_no = $this->input->get('trgk_no');
		$data = $this->m_giro_keluar->get_giro_keluar($trgk_no);
		$data['pbpo'] = $this->m_po_payment->get_po_payment_bytrgkno($trgk_no);		
		
		$data['action'] = 'VIEW';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/giro_keluar/v_giro_keluar_form',$data);
		$this->load->view('v_footer');			
	}

	public function giro_keluar_simpan()
	{
		// Proteksi supaya tidak bisa di akses dari URL 		
		if(!$this->input->is_ajax_request()) {
		   exit('No direct script access allowed');
		}

		$vok = true;
		$msg = '';

		// set data
		if($vok){
			$data = array();
			$data['action'] = $this->input->post('action');									
			$data['trgk_cekint'] = $this->input->post('trgk_cekint');
			$data['tr']['trgk_no'] = fhapus_kutip(trim($this->input->post('trgk_no')));				
			$data['trgk_no_lama'] = fhapus_kutip(trim($this->input->post('trgk_no_lama')));							

			if($data['action'] == 'NEW'){								
				$data['tr']['trgk_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$data['tr']['trgk_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$data['tr']['trgk_void'] = 0;
				$data['tr']['trgk_nprint'] = 0;
			}			

			$data['tr']['trgk_tglbayar'] = $this->input->post('trgk_tglbayar');
			$data['tr']['trgk_tgljthtempo'] = $this->input->post('trgk_tgljthtempo');
			$data['tr']['trgk_tglcair'] = ftodouble($this->input->post('trgk_tglcair'));
			$data['tr']['trgk_mssp_no'] = ($this->input->post('trgk_mssp_no') == '') ? '' : str_replace("-", "", fhapus_kutip(substr($this->input->post('trgk_mssp_no'), 0, 6))); 			
			$data['tr']['trgk_msap_no_bgk'] = fhapus_kutip($this->input->post('trgk_msap_no_bgk'));
			$data['tr']['trgk_msap_no_slh'] = fhapus_kutip($this->input->post('trgk_msap_no_slh'));
			$data['tr']['trgk_total'] = ftodouble($this->input->post('trgk_total'));
			$data['tr']['trgk_used'] = ftodouble($this->input->post('trgk_used'));
			$data['tr']['trgk_catatan'] = fhapus_kutip($this->input->post('trgk_catatan'));			
			$data['tr']['trgk_tag'] = fhapus_kutip($this->input->post('trgk_tag'));							
			$data['tr']['trgk_lsupd'] = date('Y-m-d H:i:s');
			$data['tr']['trgk_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];	

			$pbyr = $this->input->post('pbyr');

			if(isset($pbyr)){																
				foreach ($pbyr['jlhbayar'] as $key => $value) {
					if ($pbyr['jlhbayar'][$key] != '') {							
						$data['pbpo'][$key]['pbpo_no'] = $this->m_po_payment->po_payment_kode_auto(substr($pbyr['refno'][$key], 0, 12));
						$data['pbpo'][$key]['pbpo_seq'] = 1;
						$data['pbpo'][$key]['pbpo_refno'] = $pbyr['refno'][$key];
						$data['pbpo'][$key]['pbpo_msjb_no'] = 0;
						$data['pbpo'][$key]['pbpo_jenis'] = 'G';
						$data['pbpo'][$key]['pbpo_bayardp'] = 'T';
						$data['pbpo'][$key]['pbpo_jlhbayar'] = ftodouble($pbyr['jlhbayar'][$key]);
						$data['pbpo'][$key]['pbpo_catatan'] = '';
						$data['pbpo'][$key]['pbpo_tgl'] = $pbyr['tglbyr'][$key]. ' '. date('H:i:s');
						$data['pbpo'][$key]['pbpo_tglcair'] = $pbyr['tglbyr'][$key];
						$data['pbpo'][$key]['pbpo_void'] = 0;
						$data['pbpo'][$key]['pbpo_cekint'] = 1;
						$data['pbpo'][$key]['pbpo_lsupd'] = date('Y-m-d H:i:s');
						$data['pbpo'][$key]['pbpo_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
						$data['pbpo'][$key]['pbpo_nprint'] = 0;
						$data['pbpo'][$key]['pbpo_tag'] = '';
						$data['pbpo'][$key]['pbpo_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
						$data['pbpo'][$key]['pbpo_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no']; 
						$data['pbpo'][$key]['pbpo_trpt_no'] = '';
						$data['pbpo'][$key]['pbpo_kurs'] = 1;
						$data['pbpo'][$key]['pbpo_refnopbyr'] = $data['tr']['trgk_no'];						
					}					
				}
			}													
		}

		// cek form validation
		if($vok){
			$this->form_validation->set_rules($this->config_validation());
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();
			}
		}

		// cek valid data transaksi
		if($vok) {
			$hasil_cek = $this->cek_valid_data_trans($data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error_message'=>$hasil_cek['msg']);				
			}
		}

		// Simpan data
		if($vok){
			$vresult = $this->m_giro_keluar->giro_keluar_simpan($data);			
			if($vresult == 0){
				$vok = false;				
				$msg = array('error_message' => 'Error Query');
			}
		}		
		
		// Berhasil simpan data
		if($vok){
			$this->session->set_userdata('response','sukses');
			$result['response'] = 'sukses';
  	 		$result['trgk_no'] = $data['tr']['trgk_no'];
		}
				
		// Gagal simpan data							
		if(!$vok){
			$result['response'] = 'gagal';  	 		
  	 		$result['error_message'] = $msg;	  	 		
		}	

		echo json_encode($result);
	}	

	private function config_validation(){
		$config = array(		        			        			        
					array(
			                'field' => 'trgk_mssp_no',
			                'label' => 'Supplier',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Silakan input %s. <br>',			                        
			                )
			        ),
			        array(
			                'field' => 'trgk_msap_no_bgk',
			                'label' => 'Akun Bank',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Silakan input %s. <br>',			                        
			                )
			        ),
			        array(
			                'field' => 'trgk_total',
			                'label' => 'Total Transfer Masuk',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Silakan input %s. <br>',			                        
			                )
			        ),			        
			        array(
			                'field' => 'trgk_tgljthtempo',
			                'label' => 'Tgl Jatuh Tempo',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Silakan input %s. <br>',			                        
			                )
			        ),
			        array(
			                'field' => 'trgk_tglcair',
			                'label' => 'Tgl Cair',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Silakan input %s. <br>',			                        
			                )
			        )   
		);		

		return $config;
	}

	private function cek_valid_data_trans($data){
		$vok = true;
		$msg = '';
		$pbyr = $this->input->post('pbyr');

		// $trju_no = $this->m_giro_keluar->get_trju_no_byrefno($data['trgk_no_lama']);
		// $vok = false;
		// $msg = $data['trgk_no_lama'].'<br>';				
		// $msg = $trju_no;				

		if($data['action'] == 'NEW' || $data['action'] == 'EDIT'){						
			$hsl_cek_no_giro = false;

			if($data['action'] == 'NEW'){
				$hsl_cek_no_giro = $this->m_giro_keluar->is_trgk_no_exists($data['tr']['trgk_no']);
			}elseif($data['action'] == 'EDIT'){
				$hsl_cek_no_giro = $this->m_giro_keluar->is_trgk_no_exists($data['tr']['trgk_no'], $data['trgk_no_lama']);
			}

			// cek No. Giro harus uniq		
			if($vok && $hsl_cek_no_giro){				
				$vok = false;
				$msg = 'No. Giro tidak valid / No. Giro sudah ada.';				
			}			

			// cek pembayaran harus diinput
			if($vok && !isset($data['pbpo'])){
				$vok = false;
				$msg = 'Please input payment.';	
			}

			// cek total bayar tidak boleh > total giro
			if($vok && ftodouble($this->input->post('totalbyr')) > ftodouble($this->input->post('totalgiro'))){
				$vok = false;
				$msg = 'Total bayar tidak boleh > total giro.';	
			}

			// akun bank in transit harus disetting
			if($vok && !$this->m_setting_account->get_setting_account_byid('HUGI')){
				$vok = false;				
				$msg = 'Akun Hutang Giro belum di setting <br>';
				$msg .= 'Cek di menu Setting >> Trans Account';
			}

			if(isset($data['pbpo'])){
				foreach ($data['pbpo'] as $key => $value) {				
					if($vok && ftodouble($data['pbpo'][$key]['pbpo_jlhbayar']) > ftodouble($pbyr['sisabayar'][$key])){
						$vok = false;
						$msg = 'Jumlah bayar tidak boleh > dari sisa bayar.<br>';
						$msg .= 'No. Trans: '. $pbyr['refno'][$key];
						break;
					}					

					// utk pengecekan trid_cekint, 
					// Valid = CekInt tidak berubah
					if($vok){
						if($this->m_incoming_delivery->get_incoming_delivery_cekint($pbyr['refno'][$key], $pbyr['cekint'][$key]) == false){
							$vok = false;
							$msg = 'Data have been changed by another user. Please Refresh the page<br>';								
							$msg .= 'No. Trans: '. $pbyr['refno'][$key].'<br>';
							break;
						}
					}
				}				
			}			
		}			

		// utk pengecekan cekint, 
		// Valid = CekInt tidak berubah
		if ($vok && $data['action'] != 'NEW') {
			if($this->m_giro_keluar->cek_exists_cekint($data['trgk_no_lama'], $data['trgk_cekint']) == false){
				$vok = false;
				$msg = 'Data have been changed by another user. Please Refresh the page';
			}else{
				$this->m_giro_keluar->set_giro_keluar_cekint($data['trgk_no_lama']);
			}
		}				

		return array('valid'=>$vok, 'msg'=>$msg);
	}

}