<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class famili extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_famili');				
	}

	public function index(){	
		if(!fcek_hak_akses('.AE0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/famili/v_famili_list', $data);
		$this->load->view('v_footer');			
	}

	public function famili_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'famili');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['famili_list'] = $this->m_famili->get_famili_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['famili_list']);
		}
		else {
			$pagination['total_list'] = $this->m_famili->get_famili_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['famili_list'] = $this->load->view('data_master/famili/v_famili_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function famili_new(){	
		if(!fcek_hak_akses('.AE1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/famili/v_famili_form',$data);
		$this->load->view('v_footer');			
	}

	public function famili_view($msfm_no = null){
		if(!fcek_hak_akses('.AE0.')) {
			redirect('forbidden');
		}

		if (is_null($msfm_no) || count($this->m_famili->get_famili($msfm_no)) <= 0) {
			redirect('famili');
			return;
		}

		$data = array();
		$data['action'] = 'view';				
		$data['famili'] = $this->m_famili->get_famili($msfm_no);	
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/famili/v_famili_form',$data);
		$this->load->view('v_footer');														
	}

	public function famili_new_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'famili');

		$result = array();					 
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$msfm_no = $this->input->post('mskt_no'). $this->input->post('msfm_no');		
			if($this->m_famili->get_familino($msfm_no) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('msfm_no' => 'Family ID: '.$msfm_no.' is already registered. Please input Family ID.');
				echo json_encode($result);	
			}else if($this->m_famili->get_familinm(null, fhapus_kutip($this->input->post('msfm_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Family name already exists');
				echo json_encode($result);			
			}else{							
				$data = array();			
				$data['msfm_no'] = $msfm_no;
				$data['msfm_nm'] = fhapus_kutip($this->input->post('msfm_nm'));							
				$data['msfm_listmscb'] = (($this->input->post('msfm_listmscb') != '') ? ".". implode('.', $this->input->post('msfm_listmscb')). "." : '');
				$data['msfm_catatan'] = fhapus_kutip($this->input->post('msfm_catatan'));
				$data['msfm_aktif'] = 1; //(($this->input->post('msfm_aktif') == 'on') ? 1 : 0);			
				$data['msfm_lsupd'] = date('Y-m-d H:i:s');
				$data['msfm_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_famili->famili_new_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');
					$result['response'] = 'sukses';				
		  	 		$result['msfm_no'] = $data['msfm_no'];	      	 		
		  	 		echo json_encode($result);
				}			
			}	
		}				        
	}

	public function famili_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'famili');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$data_status['msfm_listmscb'] = (($this->input->post('msfm_listmscb') != '') ? ".". implode('.', $this->input->post('msfm_listmscb')). "." : '');			
			$data_status['mskt_no'] = $this->input->post('mskt_no');
			if(fcek_status($data_status)){
				$result['response'] = 'gagal';
				$result['error_message'] = array('fail'=>'Can not save [OFF] status');
				echo json_encode($result);		     	
			}else if($this->m_famili->get_familinm($this->input->post('mskt_no').$this->input->post('msfm_no'), fhapus_kutip($this->input->post('msfm_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Family name already exists');
				echo json_encode($result);			
			}else{			     	
				$data = array();
				$data['msfm_no'] = $data_status['mskt_no']. $this->input->post('msfm_no');
				$data['msfm_nm'] = fhapus_kutip($this->input->post('msfm_nm'));			
				$data['msfm_listmscb'] = $data_status['msfm_listmscb'];
				$data['msfm_catatan'] = fhapus_kutip($this->input->post('msfm_catatan'));
				//$data['msfm_aktif'] = (($this->input->post('msfm_aktif') == 'on') ? 1 : 0);			
				$data['msfm_lsupd'] = date('Y-m-d H:i:s');
				$data['msfm_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_famili->famili_edit_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');			
					$result['response'] = 'sukses';				
		  	 		$result['msfm_no'] = $data['msfm_no'];			
		  	 		echo json_encode($result);
				}				
			}	
		}				        
	}

	public function get_famili(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'famili');

		echo json_encode($this->m_famili->get_all_famili());				
	}

	public function famili_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'famili');

		$data['msfm_no'] = $this->input->post('msfm_no');
		$data['msfm_aktif'] = $this->input->post('msfm_aktif');

		if($this->m_famili->famili_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['msfm_no'] = $data['msfm_no'];			
  	 		echo json_encode($result);
		}
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'mskt_no',
		                'label' => 'Category ID',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'msfm_no',
		                'label' => 'Family ID',
		                'rules' => 'required|min_length[2]',
		                'errors' => array(
		                        'required' => ' Please input %s. '		      
		                )
		        ),		        
		        array(
		                'field' => 'msfm_nm',
		                'label' => 'Family Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'msfm_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )

		);
		return $config;
	}	

}