<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class customer extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_customer');						
	}

	public function index(){
		if(!fcek_hak_akses('.AA0.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/customer/v_customer_list', $data);
		$this->load->view('v_footer');			
	}

	public function customer_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'customer');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');			

		$data['customer_list'] = $this->m_customer->get_customer_list($arr_filter, false, $per_page, $offset, $fn, $sort);
		$data['request_from'] = $this->input->post('request_from');

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['customer_list']);
		}
		else {
			$pagination['total_list'] = $this->m_customer->get_customer_list($arr_filter, true);		
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['customer_list'] = $this->load->view('data_master/customer/v_customer_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function customer_dalist(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'customer');

		$data = array();
		$result = array();
		$pagination = array();

		$per_page = $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');
		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			

		$data['customer_dalist'] = $this->m_customer->get_customer_dalist($arr_filter, false, $per_page, $offset, $fn, $sort);		

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;
		$pagination['total_list'] = $this->m_customer->get_customer_dalist($arr_filter, true);
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['customer_dalist'] = $this->load->view('data_master/customer/v_customer_dadatalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $this->m_customer->get_customer_dalist($arr_filter, true);
		
		echo json_encode($result);
	}
	
	public function customer_nalist(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'customer');

		$data = array();
		$result = array();
		$pagination = array();

		$per_page = $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');
		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			

		$data['customer_nalist'] = $this->m_customer->get_customer_nalist($arr_filter, false, $per_page, $offset, $fn, $sort);		

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;
		$pagination['total_list'] = $this->m_customer->get_customer_nalist($arr_filter, true);
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['customer_nalist'] = $this->load->view('data_master/customer/v_customer_nadatalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $this->m_customer->get_customer_nalist($arr_filter, true);
		
		echo json_encode($result);
	}

	public function customer_new(){			
		if(!fcek_hak_akses('.AA1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/customer/v_customer_form',$data);
		$this->load->view('v_footer');		
	}

	public function customer_view($mscs_no){
		if(!fcek_hak_akses('.AA0.')) {
			redirect('forbidden');
		}

		if (is_null($mscs_no) || count($this->m_customer->get_customer($mscs_no)) <= 0) {
			redirect('customer');
			return;
		}	
		
		$data = array();
		$data = $this->m_customer->get_customer($mscs_no);	
		$data['action'] = 'view';				
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/customer/v_customer_form',$data);
		$this->load->view('v_footer');		
	}
	
	public function customer_new_simpan(){						
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'customer');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{

			if($this->m_customer->get_customername(null, fhapus_kutip($this->input->post('mscs_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Customer name already exists');
				echo json_encode($result);
			}else{				
					$data = array();				
					$mscs_jenis = $this->input->post('mscs_jenis');
					$data['mscs_no'] = $this->m_customer->customer_kode_auto($mscs_jenis);
					$data['mscs_nm'] = fhapus_kutip($this->input->post('mscs_nm'));					
					$data['mscs_jenis'] = $mscs_jenis;			
					$data['mscs_ppn'] = $this->input->post('mscs_ppn');
					$data['mscs_listmscb'] = (($this->input->post('mscs_listmscb') != '') ? ".". implode('.', $this->input->post('mscs_listmscb')). "." : '');
					$data['mscs_top'] = fhapus_kutip($this->input->post('mscs_top'));					
					$data['mscs_telp'] = fhapus_kutip($this->input->post('mscs_telp'));
					$data['mscs_fax'] = fhapus_kutip($this->input->post('mscs_fax'));
					$data['mscs_hp'] = fhapus_kutip($this->input->post('mscs_hp'));
					$data['mscs_npwp'] = fhapus_kutip($this->input->post('mscs_npwp'));
					$data['mscs_email'] = fhapus_kutip($this->input->post('mscs_email'));
					$data['mscs_cp'] = fhapus_kutip($this->input->post('mscs_cp'));
					$data['mscs_almt_jln'] = fhapus_kutip($this->input->post('mscs_almt_jln'));
					$data['mscs_almt_kota'] = fhapus_kutip($this->input->post('mscs_almt_kota'));
					$data['mscs_almt_provinsi'] = fhapus_kutip($this->input->post('mscs_almt_provinsi'));
					$data['mscs_klas'] = ($this->input->post('mscs_klas') != '') ? $this->input->post('mscs_klas') : '0';
					// $data['mscs_kirim_jln'] = fhapus_kutip($this->input->post('mscs_kirim_jln'));
					// $data['mscs_kirim_kota'] = fhapus_kutip($this->input->post('mscs_kirim_kota'));
					// $data['mscs_kirim_provinsi'] = fhapus_kutip($this->input->post('mscs_kirim_provinsi'));
					$data['mscs_tag'] = fhapus_kutip($this->input->post('mscs_tag'));
					$data['mscs_catatan'] = fhapus_kutip($this->input->post('mscs_catatan'));
					$data['mscs_aktif'] = 1; //(($this->input->post('mscs_aktif') == 'on') ? 1 : 0);			
					$data['mscs_lsupd'] = date('Y-m-d H:i:s');
					$data['mscs_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];

					$mscsda = $this->input->post('mscsda');

					foreach ($mscsda as $key => $value) {
						for ($i=0; $i < count($mscsda[$key]); $i++) {
							if ($mscsda['mscsda_kirim_jln'][$i] != '' || $mscsda['mscsda_kirim_kota'][$i] != '' || $mscsda['mscsda_kirim_provinsi'][$i] != '') {
								$data['mscsda'][$i]['mscsda_no'] = $data['mscs_no'];
								$data['mscsda'][$i][$key] = $value[$i];								
							}							
						}
					}

					$mscsna = $this->input->post('mscsna');

					foreach ($mscsna as $key => $value) {
						for ($i=0; $i < count($mscsna[$key]); $i++) {
							if ($mscsna['mscsna_npwp_jln'][$i] != '' || $mscsna['mscsna_npwp_kota'][$i] != '' || $mscsna['mscsna_npwp_provinsi'][$i] != '') {
								$data['mscsna'][$i]['mscsna_no'] = $data['mscs_no'];
								$data['mscsna'][$i][$key] = $value[$i];								
							}							
						}
					}
															
					if($this->m_customer->customer_new_simpan($data)){					
						$this->session->set_userdata('alert_sukses','sukses');
						$result['response'] = 'sukses';				
			  	 		$result['mscs_no'] = $data['mscs_no'];	      	 		
			  	 		echo json_encode($result);
					}
			}	
					
		}				        
	}


	public function customer_edit_simpan(){		
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'customer');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$data_status['mscs_listmscb'] = (($this->input->post('mscs_listmscb') != '') ? ".". implode('.', $this->input->post('mscs_listmscb')). "." : '');
			if(fcek_status($data_status)){
				$result['response'] = 'gagal';
				$result['error_message'] = array('fail'=>'Can not save [OFF] status');
				echo json_encode($result);		 
			}else{			
				if($this->m_customer->get_customername($this->input->post('mscs_no'), fhapus_kutip($this->input->post('mscs_nm'))) > 0){
					$result['response'] = 'gagal';
					$result['error_message'] = array('error'=>'Customer name already exists');
					echo json_encode($result);
				}else{
						$data = array();		     		
						$data['mscs_no'] = $this->input->post('mscs_no');
						$data['mscs_nm'] = fhapus_kutip($this->input->post('mscs_nm'));
						$data['mscs_ppn'] = $this->input->post('mscs_ppn');
						$data['mscs_listmscb'] = $data_status['mscs_listmscb'];
						$data['mscs_top'] = fhapus_kutip($this->input->post('mscs_top'));					
						$data['mscs_telp'] = fhapus_kutip($this->input->post('mscs_telp'));
						$data['mscs_fax'] = fhapus_kutip($this->input->post('mscs_fax'));
						$data['mscs_hp'] = fhapus_kutip($this->input->post('mscs_hp'));
						$data['mscs_npwp'] = fhapus_kutip($this->input->post('mscs_npwp'));
						$data['mscs_email'] = fhapus_kutip($this->input->post('mscs_email'));
						$data['mscs_cp'] = fhapus_kutip($this->input->post('mscs_cp'));
						$data['mscs_almt_jln'] = fhapus_kutip($this->input->post('mscs_almt_jln'));
						$data['mscs_almt_kota'] = fhapus_kutip($this->input->post('mscs_almt_kota'));
						$data['mscs_almt_provinsi'] = fhapus_kutip($this->input->post('mscs_almt_provinsi'));
						$data['mscs_klas'] = ($this->input->post('mscs_klas') != '') ? $this->input->post('mscs_klas') : '0';
						// $data['mscs_kirim_jln'] = fhapus_kutip($this->input->post('mscs_kirim_jln'));
						// $data['mscs_kirim_kota'] = fhapus_kutip($this->input->post('mscs_kirim_kota'));
						// $data['mscs_kirim_provinsi'] = fhapus_kutip($this->input->post('mscs_kirim_provinsi'));
						$data['mscs_tag'] = fhapus_kutip($this->input->post('mscs_tag'));
						$data['mscs_catatan'] = fhapus_kutip($this->input->post('mscs_catatan'));
						// $data['mscs_aktif'] = (($this->input->post('mscs_aktif') == 'on') ? 1 : 0);			
						$data['mscs_lsupd'] = date('Y-m-d H:i:s');
						$data['mscs_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];

						$mscsda = $this->input->post('mscsda');

						foreach ($mscsda as $key => $value) {
							for ($i=0; $i < count($mscsda[$key]); $i++) {
								if ($mscsda['mscsda_kirim_jln'][$i] != '' || $mscsda['mscsda_kirim_kota'][$i] != '' || $mscsda['mscsda_kirim_provinsi'][$i] != '') {
									$data['mscsda'][$i]['mscsda_no'] = $data['mscs_no'];
									$data['mscsda'][$i][$key] = $value[$i];								
								}							
							}
						}

						$mscsna = $this->input->post('mscsna');

						foreach ($mscsna as $key => $value) {
							for ($i=0; $i < count($mscsna[$key]); $i++) {
								if ($mscsna['mscsna_npwp_jln'][$i] != '' || $mscsna['mscsna_npwp_kota'][$i] != '' || $mscsna['mscsna_npwp_provinsi'][$i] != '') {
									$data['mscsna'][$i]['mscsna_no'] = $data['mscs_no'];
									$data['mscsna'][$i][$key] = $value[$i];								
								}							
							}
						}
											
						if($this->m_customer->customer_edit_simpan($data)){
							$this->session->set_userdata('alert_sukses','sukses');			
							$result['response'] = 'sukses';				
				  	 		$result['mscs_no'] = $data['mscs_no'];			
				  	 		echo json_encode($result);
						}
				}		
			}					
		}				        
	}	

	public function get_customer(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'customer');

		echo json_encode($this->m_customer->get_all_customer());				
	}

	public function customer_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'customer');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';

		$respon = array();
		$respon['popup'] = $this->load->view('data_master/customer/v_customer_popup',$data,true);	
		echo json_encode($respon);		
	}

	public function customer_autocomplete(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'customer');

		$keyword = $this->input->post('query');
		if (strpos($keyword, '-') !== FALSE) {
			$keyword = substr($keyword, 0, 6);
		}		
		$data_customer = $this->m_customer->get_customer_autocomplete($keyword);
		foreach ($data_customer as $key => $value) {
			$data_customer[$key]['value'] = $value['mscs_nm'];			
		}
		$data_customer['suggestions'] = $data_customer;
		echo json_encode($data_customer);
	}

	public function customer_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'customer');

		$data['mscs_no'] = $this->input->post('mscs_no');
		$data['mscs_aktif'] = $this->input->post('mscs_aktif');

		if($this->m_customer->customer_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['mscs_no'] = $data['mscs_no'];			
  	 		echo json_encode($result);
		}
	}

	public function alamat_kirim_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'customer');

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);

		$respon = array();
		$respon['popup'] = $this->load->view('data_master/customer/v_customer_dapopup',$data, true);	
		echo json_encode($respon);		
	}

	public function alamat_npwp_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'customer');

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);

		$respon = array();
		$respon['popup'] = $this->load->view('data_master/customer/v_customer_napopup',$data, true);	
		echo json_encode($respon);		
	}

	private function config_validation(){
		$config = array(		        
		        array(
		                'field' => 'mscs_nm',
		                'label' => 'Customer Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mscs_cp',
		                'label' => 'Contact Person',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mscs_telp',
		                'label' => 'Contact Number',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mscs_almt_jln',
		                'label' => 'Address',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mscs_almt_kota',
		                'label' => 'City',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mscs_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )
		);
		return $config;
	}
	

}