<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class cabang extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_cabang');				
	}

	public function index(){
		if(!fcek_hak_akses('.AH0.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/cabang/v_cabang_list',$data);
		$this->load->view('v_footer');			
	}

	public function cabang_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'cabang');
		
		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['cabang_list'] = $this->m_cabang->get_cabang_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['cabang_list']);
		}
		else {
			$pagination['total_list'] = $this->m_cabang->get_cabang_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['cabang_list'] = $this->load->view('data_master/cabang/v_cabang_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}	

	public function cabang_new(){			
		if(!fcek_hak_akses('.AH1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/cabang/v_cabang_form',$data);
		$this->load->view('v_footer');		
	}

	public function cabang_view($mscb_no){
		if(!fcek_hak_akses('.AH0.')) {
			redirect('forbidden');
		}

		if (is_null($mscb_no) || count($this->m_cabang->get_cabang($mscb_no)) <= 0) {
			redirect('cabang');
			return;
		}	
		$data = array();
		$data['action'] = 'view';				
		$data['cabang'] = $this->m_cabang->get_cabang($mscb_no);
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);	
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/cabang/v_cabang_form',$data);
		$this->load->view('v_footer');		
	}
	
	public function cabang_new_simpan(){				      		
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'cabang');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			if($this->m_cabang->get_cabangno($this->input->post('mscb_no')) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('mscb_no' => 'Area ID: '.$this->input->post('mscb_no').' is already registered. Please input Area ID.');
				echo json_encode($result);
			}else if($this->m_cabang->get_cabangnm(null,$this->input->post('mscb_nm')) != 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error' => 'Area Name already exists');
				echo json_encode($result);		
			}else{
				$data = array();	
				$logo_path = '';
				$err = false;

				if(isset($_FILES["mscb_logo"]["name"])){

					$config['upload_path']          = './uploads';
			        $config['allowed_types']        = 'jpg|png';		            
			        $this->load->library('upload', $config);

					if(!$this->upload->do_upload('mscb_logo'))
			        {			            
			        	$err = true;
						$msg_err = 'Cannot upload image/logo. Allowed image (jpg/png).';
			        }else{		        	
			        	$info = $this->upload->data();                
			        	$logo_path = base_url('uploads/'.$info['raw_name'].$info['file_ext']);		        
			        }
				}else{
					$err = true;
					$msg_err = 'Please select Logo';
				}	


				if($err == true){
					$result['response'] = 'gagal';
					$result['error_message'] = array('error' => $msg_err);
					echo json_encode($result);					         			
					exit();
				}

				if(isset($_FILES["mscb_logo"]["name"])){	
					$data['mscb_logo'] = $logo_path;					
		        }

				$data['mscb_no'] = $this->input->post('mscb_no');
				$data['mscb_nm'] = fhapus_kutip($this->input->post('mscb_nm'));			
				$data['mscb_prshn_nm'] = fhapus_kutip($this->input->post('mscb_prshn_nm'));			
				$data['mscb_aktif'] = 1; //(($this->input->post('mscb_aktif') == 'on') ? 1 : 0);			
				$data['mscb_catatan'] = fhapus_kutip($this->input->post('mscb_catatan'));
				$data['mscb_alamat'] = fhapus_kutip($this->input->post('mscb_alamat'));
				$data['mscb_telp1'] = fhapus_kutip($this->input->post('mscb_telp1'));
				$data['mscb_telp2'] = fhapus_kutip($this->input->post('mscb_telp2'));
				$data['mscb_pic'] = fhapus_kutip($this->input->post('mscb_pic'));
				$data['mscb_telp'] = fhapus_kutip($this->input->post('mscb_telp'));
				$data['mscb_email1'] = fhapus_kutip($this->input->post('mscb_email1'));
				$data['mscb_email2'] = fhapus_kutip($this->input->post('mscb_email2'));				
				$data['mscb_line1'] = fhapus_kutip($this->input->post('mscb_line1'));
				$data['mscb_line2'] = fhapus_kutip($this->input->post('mscb_line2'));
				$data['mscb_footer1'] = fhapus_kutip($this->input->post('mscb_footer1'));
				$data['mscb_footer2'] = fhapus_kutip($this->input->post('mscb_footer2'));
				$data['mscb_footer3'] = fhapus_kutip($this->input->post('mscb_footer3'));
				$data['mscb_footer4'] = fhapus_kutip($this->input->post('mscb_footer4'));
				$data['mscb_footer5'] = fhapus_kutip($this->input->post('mscb_footer5'));
				$data['mscb_listmsgd'] = ($this->input->post('mscb_listmsgd') != '') ? implode(',', $this->input->post('mscb_listmsgd')) : '';
				$data['mscb_lsupd'] = date('Y-m-d H:i:s');
				$data['mscb_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_cabang->cabang_new_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');
					$result['response'] = 'sukses';				
	      	 		$result['mscb_no'] = $data['mscb_no'];			
	      	 		echo json_encode($result);
				}
			}
		}				        
	}

	public function cabang_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'cabang');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{			

			if($this->m_cabang->get_cabangnm($this->input->post('mscb_no'),fhapus_kutip($this->input->post('mscb_nm'))) != 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error' => 'Area Name already exists');
				echo json_encode($result);					         			
			}else{
				$data = array();
				$logo_path = '';

				if(isset($_FILES["mscb_logo"]["name"])){
					$config['upload_path']          = './uploads';
			        $config['allowed_types']        = 'jpg|png';		            
			        $this->load->library('upload', $config);

					if(!$this->upload->do_upload('mscb_logo'))
			        {
			            $result['response'] = 'gagal';
						$result['error_message'] = array('error' => 'Cannot upload image/logo. Allowed image (jpg/png).');
						echo json_encode($result);					         			
						exit();
			        }else{		        	
			        	$info = $this->upload->data();                
			        	$logo_path = base_url('uploads/'.$info['raw_name'].$info['file_ext']);		        
			        }
				}

				$data['mscb_no'] = $this->input->post('mscb_no');

				if(isset($_FILES["mscb_logo"]["name"])){						
					$data['mscb_logo'] = $logo_path;					
		        }

				$data['mscb_nm'] = fhapus_kutip($this->input->post('mscb_nm'));			
				$data['mscb_prshn_nm'] = fhapus_kutip($this->input->post('mscb_prshn_nm'));			
				$data['mscb_catatan'] = fhapus_kutip($this->input->post('mscb_catatan'));
				$data['mscb_alamat'] = fhapus_kutip($this->input->post('mscb_alamat'));
				$data['mscb_telp1'] = fhapus_kutip($this->input->post('mscb_telp1'));
				$data['mscb_telp2'] = fhapus_kutip($this->input->post('mscb_telp2'));
				$data['mscb_pic'] = fhapus_kutip($this->input->post('mscb_pic'));
				$data['mscb_telp'] = fhapus_kutip($this->input->post('mscb_telp'));
				$data['mscb_email1'] = fhapus_kutip($this->input->post('mscb_email1'));
				$data['mscb_email2'] = fhapus_kutip($this->input->post('mscb_email2'));
				$data['mscb_line1'] = fhapus_kutip($this->input->post('mscb_line1'));
				$data['mscb_line2'] = fhapus_kutip($this->input->post('mscb_line2'));
				$data['mscb_footer1'] = fhapus_kutip($this->input->post('mscb_footer1'));
				$data['mscb_footer2'] = fhapus_kutip($this->input->post('mscb_footer2'));
				$data['mscb_footer3'] = fhapus_kutip($this->input->post('mscb_footer3'));
				$data['mscb_footer4'] = fhapus_kutip($this->input->post('mscb_footer4'));
				$data['mscb_footer5'] = fhapus_kutip($this->input->post('mscb_footer5'));
				$data['mscb_listmsgd'] = ($this->input->post('mscb_listmsgd') != '') ? implode(',', $this->input->post('mscb_listmsgd')) : '';
				//$data['mscb_aktif'] = (($this->input->post('mscb_aktif') == 'on') ? 1 : 0);			
				$data['mscb_lsupd'] = date('Y-m-d H:i:s');
				$data['mscb_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_cabang->cabang_edit_simpan($data)){

					// hapus logo sebelumnya jika logo diedit
					if(isset($_FILES["mscb_logo"]["name"])){
						if($this->input->post('mscb_logo_path') != ''){	
							$arr_path = explode('/', $this->input->post('mscb_logo_path'));
							$file_name = end($arr_path);
							$old_logo_path = './uploads/'.$file_name;
							if(file_exists($old_logo_path)){
								unlink($old_logo_path);
							}
						}
			        }

					$this->session->set_userdata('alert_sukses','sukses');			
					$result['response'] = 'sukses';				
	      	 		$result['mscb_no'] = $data['mscb_no'];			
	      	 		echo json_encode($result);
				}	
			}				
		}				        
	}

	public function get_cabang(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'cabang');
							
		echo json_encode($this->m_cabang->get_all_cabang());			
	}

	public function cabang_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'cabang');

		$data['mscb_no'] = $this->input->post('mscb_no');
		$data['mscb_aktif'] = $this->input->post('mscb_aktif');

		if($this->m_cabang->cabang_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['mscb_no'] = $data['mscb_no'];			
  	 		echo json_encode($result);
		}
	}	


	private function config_validation(){
		$config = array(		        		        
		        array(
		                'field' => 'mscb_no',
		                'label' => 'Area ID',
		                'rules' => 'required|alpha_numeric',
		                'errors' => array(
		                        'required' => ' Please input %s. ',
		                        'alpha_numeric' => ' Please input alpha numeric %s. '
		                )
		        ),
		        array(
		                'field' => 'mscb_nm',
		                'label' => 'Area Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mscb_telp',
		                'label' => 'Contact Number',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mscb_telp1',
		                'label' => 'Phone Number 1',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mscb_email1',
		                'label' => 'Email 1',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mscb_pic',
		                'label' => 'Person in charge',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mscb_alamat',
		                'label' => 'Address',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mscb_prshn_nm',
		                'label' => 'Company Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),		        
		        array(
		                'field' => 'mscb_line1',
		                'label' => 'Setting Address for print',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        )
		);
		return $config;
	}


}