<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class adjstok extends MY_Controller {
	private $data = array();	

	function __construct(){
		parent::__construct();
		$this->load->model('stok_kontrol/m_adjstok');				
		$this->load->model('stok_kontrol/m_stok');
		$this->load->model('finance_and_acc/m_jurnal');				
		$this->load->model('setting/m_setting_account');
		$this->load->model('data_master/m_produk');
		$this->load->model('data_master/m_kategori');
		$this->load->model('data_master/m_gudang');		
		$this->load->model('setting/m_setting');
		error_reporting(E_ALL ^ (E_NOTICE));
	}	

	public function index($tipe_trans = null){
	
		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			if(!fcek_hak_akses('.HB7.')){
				redirect('forbidden');
			}

			$tipe_trans = 'F';
		} else {
			if(!fcek_hak_akses('.HB8.')){
				redirect('forbidden');
			}

			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('adjstok');
			}
		}

		// if($tipe_trans != null){			
		// 	if($this->session->userdata('svlogin') == 'C' && $tipe_trans != 'F' && $tipe_trans != 'C' ||
		// 		$this->session->userdata('svlogin') == 'F' && $tipe_trans != null && $tipe_trans != 'F'){
		// 		redirect('adjstok');
		// 	}
		// }		

		$data = array();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? '' : 'C';
		$data['tipe_trans']	= $tipe_trans;

		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('stok_kontrol/adjstok/v_adjstok_list',$data);
		$this->load->view('v_footer');			
	}	

	public function adjstok_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'adjstok');
		
		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['adjstok_list'] = $this->m_adjstok->get_adjstok_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['adjstok_list']);
		}
		else {
			$pagination['total_list'] = $this->m_adjstok->get_adjstok_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['adjstok_list'] = $this->load->view('stok_kontrol/adjstok/v_adjstok_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}	

	public function adjstok_new($tipe_trans = null){	
		if(!fcek_hak_akses('.DD1.')) {
			redirect('forbidden');
		}

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			$tipe_trans = 'F';
		} else {
			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('adjstok');
			}
		}

		// if($tipe_trans != null){			
		// 	if($this->session->userdata('svlogin') == 'C' && $tipe_trans != 'F' && $tipe_trans != 'C' ||
		// 		$this->session->userdata('svlogin') == 'F' && $tipe_trans != null && $tipe_trans != 'F'){
		// 		redirect('adjstok');
		// 	}
		// }

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? 'F' : 'C';
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('stok_kontrol/adjstok/v_adjstok_form',$data);
		$this->load->view('v_footer');		
	}

	public function adjstok_view($tras_no){	
		if(!fcek_hak_akses('.DD0.')) {
			redirect('forbidden');
		}

		if (is_null($tras_no) || !$this->m_adjstok->get_adjstok($tras_no)) {
			redirect('adjstok');
			return;
		}

		$data = array();				
		$data = $this->m_adjstok->get_adjstok($tras_no);		
		// $data['adjstok_lm'] = json_encode($data);		

		$trju_no = $this->m_jurnal->get_jurnalid($tras_no.'AS');
		if($trju_no != false){			
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);			
			$data['jurnal_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_d'] = $data_jurnal['jurnal_d'];			
		}				

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		$data['tipe_trans']	= $data['header']['tras_fin'];
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('stok_kontrol/adjstok/v_adjstok_form',$data);
		$this->load->view('v_footer');		
	}

	public function adjstok_print(){
		$this->load->library('java_bridge');
		$tras_no = $this->input->get('tras_no');
		$paper_size = $this->input->get('paper_size');
		
		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];


		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		if($paper_size == 'A5'){
			$path = APPPATH.'prints\stok_kontrol\adjstok\p_adjstok_A5.jrxml';					
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\stok_kontrol\adjstok\p_adjstok_A4.jrxml';					
		}		
		$params = new Java("java.util.HashMap");			
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_TRAS_NO",new Java('java.lang.String', $tras_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}

	public function adjstok_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'adjstok');		
		$this->form_validation->set_rules($this->config_validation());		
		$vok = true;
		$msg;

		// set data transaksi
		if($vok) {
			$this->data['action'] = $this->input->post('action');		
			$this->data['header']['tras_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['tras_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];

			if($this->data['action'] == 'NEW'){
				$tras_mscb_no = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$tras_tgl = $this->input->post('tras_tgl');
				$bulan = substr($tras_tgl, 5, 2);
				$tahun = substr($tras_tgl, 2, 2);
				$separator = ($this->input->post('tras_fin') == 'F') ? '-' : '_';
				$tras_kode_depan = $tras_mscb_no."AD".$tahun.$bulan.$separator;
				$this->data['header']['tras_no'] = $this->m_adjstok->adjstok_kode_auto($tras_kode_depan);
				$this->data['header']['tras_tgl'] = $tras_tgl;
				$this->data['header']['tras_mscb_no'] = $tras_mscb_no;
				$this->data['header']['tras_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['header']['tras_void'] = 0;
				$this->data['header']['tras_fin'] = $this->input->post('tras_fin');
				$this->data['header']['tras_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('tras_fin') == 'C') ? 'A' : 'R';
				$this->data['header']['tras_manual'] = 'Y';
			}			

			if($this->data['action'] != 'NEW'){
				$this->data['header']['tras_no'] = $this->input->post('tras_no');
				$this->data['header']['tras_cekint'] = $this->input->post('tras_cekint');			
				$this->data['jurnal_h']['trju_no'] = $this->input->post('trju_no');
			}

			// if($this->data['action'] == 'EDIT'){				
			// 	$this->data['adjstok_lm'] = $this->input->post('adjstok_lm');				
			// }						

			if($this->data['action'] == 'NEW' || $this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['header']['tras_msgd_no'] = $this->input->post('tras_msgd_no');				
			}			

			if($this->data['action'] == 'NEW' || $this->data['action'] == 'EDIT'){
				$this->data['header']['tras_catatan'] = fhapus_kutip($this->input->post('tras_catatan'));
				$this->data['header']['tras_tag'] = fhapus_kutip($this->input->post('tras_tag'));										
			}

			if($this->data['action'] == 'STCOPY'){				
				$this->data['header']['tras_stcopy'] = ($this->input->post('tras_stcopy') == 'R') ? 'X' : 'R';
			}

			if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['userlog']['msul_tgl'] = date('Y-m-d H:i:s');
				$this->data['userlog']['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['userlog']['msul_catatan'] = substr(trim('['.$this->data['action']. '] ADJS '. $this->data['header']['tras_no']. ' GD:'. $this->m_gudang->get_nama_gudang($this->input->post('tras_msgd_no')). ' '. fhapus_kutip($this->input->post('tras_tag')). ' '. fhapus_kutip($this->input->post('tras_catatan'))), 0, 250);
			}

			$dtas = $this->input->post('dtas');	
			
			if(isset($dtas)){
				foreach ($dtas as $key => $value) {
					for ($i=0; $i < count($dtas[$key]); $i++) { 	
						if($dtas['dtas_mspd_no'][$i] != ''){
							$this->data['detail'][$i]['dtas_no'] = $this->data['header']['tras_no'];											
							if($key == 'dtas_qty'){
								$this->data['detail'][$i][$key] = ftodouble($value[$i]);
							}else{
								$this->data['detail'][$i][$key] = $value[$i];
							}

							if($this->data['action'] == 'NEW' && $key == 'dtas_mspd_no'){
								$this->data['detail'][$i]['dtas_hpp'] = $this->m_produk->get_hpp($dtas['dtas_mspd_no'][$i]);							
							}

							// if($this->data['action'] == 'EDIT' && $key == 'dtas_mspd_no'){								
							// 	$this->data['detail'][$i]['dtas_hpp'] = $this->m_adjstok->get_dtas_hpp($this->data['header']['tras_no'], $dtspk['dtas_seq'][$i]);
							// }					
						}
					}
				}				
			}	
		}

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();								
			}
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}		

		// set data jurnal
		// if($vok){			
		// 	$this->set_data_jurnal($this->data);			
		// }

		// cek valid data jurnal				
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal($this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}
			
		// simpan data
		if ($vok) {		
			$vresult = $this->m_adjstok->adjstok_simpan($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}		
		}			

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['tras_no'] = $this->data['header']['tras_no'];  	 		
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);
	}	

	// private function set_data_jurnal($data){
	// 		//Header jurnal			
	// 		if($data['action'] == 'NEW'){
	// 			$gudang = $this->m_gudang->get_gudang($this->input->post('tras_msgd_no'));				
	// 			$trju_tgl = $data['header']['tras_tgl'];
	// 			$trju_tipe = 'A';
	// 			$bulan = substr($trju_tgl, 5, 2);			
	// 			$tahun = substr($trju_tgl, 2, 2);			
	// 			$separator = ($this->input->post('tras_fin') == 'F') ? '-' : '_';
	// 			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
	// 			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
	// 			$data['jurnal_h']['trju_refno'] = $data['header']['tras_no'].'AS';
	// 			$data['jurnal_h']['trju_reftipe'] = 'AS';
	// 			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
	// 			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
	// 			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
	// 			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
	// 			$data['jurnal_h']['trju_void'] = 0;
	// 			$data['jurnal_h']['trju_catatan'] = $data['header']['tras_no'].'/'.$gudang['msgd_no'].' - '.$gudang['msgd_nm'];
	// 			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('tras_fin') == 'C') ? 'A' : 'R';
	// 			$data['jurnal_h']['trju_fin'] = $this->input->post('tras_fin');
	// 		}

	// 		if($data['action'] != 'NEW'){
	// 			$data['jurnal_h']['trju_no'] = $this->input->post('trju_no');
	// 		}
						
	// 		$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
	// 		$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];						
				
	// 		// Set account
	// 		//-----------------------------------------------------------------------------------						
	// 		if(isset($data['detail'])){								
	// 			$array = array();
	// 			$data['jurnal_d'] = array();
	// 			foreach ($data['detail'] as $key => $value) {										 					 					 		
	// 				$mskt_no = substr($data['detail'][$key]['dtas_mspd_no'], 0, 1);
	// 			 	$saldo = ftodouble($data['detail'][$key]['dtas_hpp']) * ftodouble($data['detail'][$key]['dtas_qty']);				 

	// 		 		// Account Adjustment Stok (Debet)
	// 		 		$acc = $this->m_setting_account->get_setting_account_byid('ADJS');
	// 				$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	// 				$array['dtju_debet'] = $saldo;
	// 				$array['dtju_kredit'] = 0;
	// 				array_push($data['jurnal_d'], $array);

	// 				// Account Inventory (Kredit)
	// 				$array['dtju_msap_no'] = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
	// 				$array['dtju_debet'] = 0;
	// 				$array['dtju_kredit'] = $saldo;
	// 				array_push($data['jurnal_d'], $array);				 		
	// 			}
	// 			$this->data['jurnal_d'] = $data['jurnal_d'];
	// 		}		
	// 		//--------------------------------------------------------------------------------
	// 		$this->data['jurnal_h'] = $data['jurnal_h'];									
	// }

	private function cek_valid_data_jurnal($data){
		$msg = '';
		$hsl = true;

		// cek setting account harus diisi
		if($hsl){
			if(!$this->m_setting_account->get_setting_account_byid('ADJS')){
				$hsl = false;				
				$msg = 'There is an account that has not been set';
			}
		}

		//cek akun perkiraan di master kategori harus diisi
		if($hsl){
			if(isset($data['detail'])){
				foreach ($data['detail'] as $key => $value) {													
					$mskt_no = substr($data['detail'][$key]['dtas_mspd_no'], 0, 1);
					if(!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv')){
						$hsl = false;						
						$msg = 'There is an account not yet filled in Category Master';
					}						
				}
			}
		}
		
		return array('valid'=>$hsl, 'msg'=>$msg);
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'tras_msgd_no',
		                'label' => 'Warehouse',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )
		);
		return $config;
	}

	public function cek_valid_data_trans($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | VOID

			$msg = '';
			$hsl = true;
			$tgl_cls_jurnal = $this->m_setting->get_setting('simr_char1','tcj', 1);

			if($hsl && ($menu == 'NEW' || $menu == 'EDIT' || $menu == 'VOID')){
				// transaksi tidak bisa di buat/edit/void jika jurnal sudah di closing
				$tgl_trans = $this->input->post('tras_tgl');
				$tahun = substr($tgl_trans, 0, 4);
				$bulan = substr($tgl_trans, 5, 2);	
				$tgl_trans = (int)$tahun.$bulan;

				if($hsl && $tgl_trans <= $tgl_cls_jurnal){
					$hsl = false;					
					$msg = 'Can not create new/edit/void transaction if journal transaction date is closed. Please choose another date.';					
				}
			}

			// Transaksi yang sudah di rekonsiliasi tidak bisa di edit/void/cancel
			if($hsl && ($menu == 'EDIT' || $menu == 'VOID')){				
				if($this->m_app->is_recon_exists($data['header']['tras_no'].'AS')){
					$hsl = false;
					$msg = 'Transactions cannot be changed. Journal already in reconciliation';
				}
			}

			// cek produk harus dipilih
			if($hsl){
				if(!isset($data['detail'])){
					$hsl = false;
					$msg = 'Please select product';
				}
			}
			
			// utk pengecekan dtas_qty Stock Adustment
			// Valid = Stok setelah adjustment tidak boleh minus
			if ($hsl) {
				if(isset($data['detail'])){
					for ($i=0; $i < count($data['detail']) ; $i++) {
						if ($menu == 'NEW') { 
							$qtyupdate = $data['detail'][$i]['dtas_qty'];
						}elseif ($menu == 'EDIT') {
							$qtyupdate = -1 * ($data['detail'][$i]['dtas_qty_lama'] - $data['detail'][$i]['dtas_qty']);
						}elseif ($menu == 'VOID') {
							$qtyupdate = -1 * $data['detail'][$i]['dtas_qty'];
						}

						$stok = $this->m_stok->get_stok($data['detail'][$i]['dtas_mspd_no'],$data['header']['tras_msgd_no']);
						if($this->session->userdata('svlogin') != 'F'){
							if (($stok + $qtyupdate) < 0){
								$hsl = false;
								$msg = 'Stock Insufficient'.
								       '<br>Product: ' . $data['detail'][$i]['dtas_mspd_no'].
								       '<br>Warehouse: ' . $data['header']['tras_msgd_no'].
								       '<br>Stock: ' . $stok;
								 break;
							}
						}
						unset($this->data['detail'][$i]['dtas_qty_lama']);
					}
				}
			}

			// utk pengecekan cekint Stock Adjustment, 
			// Valid = CekInt tidak berubah
			if ($hsl && $menu != 'NEW') {
				if($this->m_adjstok->get_adjstok_cekint($data['header']['tras_no'], $data['header']['tras_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
					$msg = $data['header']['tras_no'];
				}
			}
			
			return array('valid'=>$hsl, 'msg'=>$msg);
	}

	public function temp_jurnal_ulang(){		
		$this->load->view('v_temp_jurnal_ulang');		
	}

	public function execute_temp_jurnal_ulang(){				
		$pass = $this->input->post('pass');	
		if($pass == '122333'){
			$query = "DROP TABLE IF EXISTS temp_dt_jurnal";
			$this->db->simple_query($query);

			$query = "CREATE TABLE temp_dt_jurnal ("		
						."dtju_no char(15) NOT NULL,"
						."dtju_seq int NOT NULL DEFAULT 0,"
						."dtju_msap_no char(11) NOT NULL DEFAULT '',"
						."dtju_debet double NOT NULL DEFAULT 0,"
						."dtju_kredit double NOT NULL DEFAULT 0, "
						."dtju_catatan varchar(250) NOT NULL DEFAULT '' "
					    .") ENGINE=InnoDB DEFAULT CHARSET=latin1";
			$this->db->simple_query($query);

			$query = "INSERT INTO temp_dt_jurnal(dtju_no, dtju_seq, dtju_msap_no, dtju_debet, dtju_kredit, dtju_catatan)
						(SELECT a.dtju_no, a.dtju_seq, a.dtju_msap_no, a.dtju_kredit, a.dtju_debet, a.dtju_catatan
						FROM dt_jurnal a
						LEFT JOIN tr_jurnal ON trju_no = a.dtju_no 
						WHERE trju_reftipe = 'AS')"; 
			$this->db->simple_query($query);

			$query = "DELETE FROM dt_jurnal
						WHERE dtju_no in (select trju_no from tr_jurnal WHERE trju_reftipe = 'AS')";						
			$this->db->simple_query($query);
			
			$query = "INSERT INTO dt_jurnal(dtju_no, dtju_seq, dtju_msap_no, dtju_debet, dtju_kredit, dtju_catatan)
						(SELECT a.dtju_no, a.dtju_seq, a.dtju_msap_no, a.dtju_debet, a.dtju_kredit, a.dtju_catatan
						FROM temp_dt_jurnal a)";
			$this->db->simple_query($query);

			$query = "DROP TABLE IF EXISTS temp_dt_jurnal";
			$this->db->simple_query($query);
		}else{
			echo 'tidak valid';
		}
	}	
}	